(* ::Package:: *)

(* ::Title::Closed:: *)
(*Integrands of the form (c x)^m (b x^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (b x^1)^p*)


{(c*x)^m*(b*x)^p, x, 2, ((b*x)^(1 + p)*(c*x)^m)/(b*(1 + m + p))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (b x^2)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (b x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{Sqrt[b*x^2]*x^3, x, 2, (1/5)*x^4*Sqrt[b*x^2]}
{Sqrt[b*x^2]*x^2, x, 2, (1/4)*x^3*Sqrt[b*x^2]}
{Sqrt[b*x^2]*x^1, x, 2, (1/3)*x^2*Sqrt[b*x^2]}
{Sqrt[b*x^2]*x^0, x, 2, (1/2)*x*Sqrt[b*x^2]}
{Sqrt[b*x^2]/x^1, x, 2, Sqrt[b*x^2]}
{Sqrt[b*x^2]/x^2, x, 2, (Sqrt[b*x^2]*Log[x])/x}
{Sqrt[b*x^2]/x^3, x, 2, -(Sqrt[b*x^2]/x^2)}
{Sqrt[b*x^2]/x^4, x, 2, -(Sqrt[b*x^2]/(2*x^3))}
{Sqrt[b*x^2]/x^5, x, 2, -(Sqrt[b*x^2]/(3*x^4))}

{Sqrt[x^2]*x^2, x, 2, (1/4)*x^3*Sqrt[x^2]}


{(b*x^2)^(3/2)*x^2, x, 2, (1/6)*b*x^5*Sqrt[b*x^2]}
{(b*x^2)^(3/2)*x^1, x, 2, (1/5)*b*x^4*Sqrt[b*x^2]}
{(b*x^2)^(3/2)*x^0, x, 2, (1/4)*b*x^3*Sqrt[b*x^2]}
{(b*x^2)^(3/2)/x^1, x, 2, (1/3)*b*x^2*Sqrt[b*x^2]}
{(b*x^2)^(3/2)/x^2, x, 2, (1/2)*b*x*Sqrt[b*x^2]}
{(b*x^2)^(3/2)/x^3, x, 2, b*Sqrt[b*x^2]}
{(b*x^2)^(3/2)/x^4, x, 2, (b*Sqrt[b*x^2]*Log[x])/x}
{(b*x^2)^(3/2)/x^5, x, 2, -((b*Sqrt[b*x^2])/x^2)}
{(b*x^2)^(3/2)/x^6, x, 2, -((b*Sqrt[b*x^2])/(2*x^3))}
{(b*x^2)^(3/2)/x^7, x, 2, -((b*Sqrt[b*x^2])/(3*x^4))}

{(x^2)^(3/2)*x^2, x, 2, (1/6)*x^5*Sqrt[x^2]}


{(b*x^2)^(5/2)*x^1, x, 2, (1/7)*b^2*x^6*Sqrt[b*x^2]}
{(b*x^2)^(5/2)*x^0, x, 2, (1/6)*b^2*x^5*Sqrt[b*x^2]}
{(b*x^2)^(5/2)/x^1, x, 2, (1/5)*b^2*x^4*Sqrt[b*x^2]}
{(b*x^2)^(5/2)/x^2, x, 2, (1/4)*b^2*x^3*Sqrt[b*x^2]}
{(b*x^2)^(5/2)/x^3, x, 2, (1/3)*b^2*x^2*Sqrt[b*x^2]}
{(b*x^2)^(5/2)/x^4, x, 2, (1/2)*b^2*x*Sqrt[b*x^2]}
{(b*x^2)^(5/2)/x^5, x, 2, b^2*Sqrt[b*x^2]}
{(b*x^2)^(5/2)/x^6, x, 2, (b^2*Sqrt[b*x^2]*Log[x])/x}
{(b*x^2)^(5/2)/x^7, x, 2, -((b^2*Sqrt[b*x^2])/x^2)}
{(b*x^2)^(5/2)/x^8, x, 2, -((b^2*Sqrt[b*x^2])/(2*x^3))}
{(b*x^2)^(5/2)/x^9, x, 2, -((b^2*Sqrt[b*x^2])/(3*x^4))}

{(x^2)^(5/2)*x^2, x, 2, (1/8)*x^7*Sqrt[x^2]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/Sqrt[b*x^2]*x^3, x, 2, x^4/(3*Sqrt[b*x^2])}
{1/Sqrt[b*x^2]*x^1, x, 2, x^2/Sqrt[b*x^2]}
{1/Sqrt[b*x^2]/x^1, x, 2, -(1/Sqrt[b*x^2])}
{1/Sqrt[b*x^2]/x^3, x, 2, -(1/(3*x^2*Sqrt[b*x^2]))}

{1/Sqrt[b*x^2]*x^2, x, 2, x^3/(2*Sqrt[b*x^2])}
{1/Sqrt[b*x^2]*x^0, x, 2, (x*Log[x])/Sqrt[b*x^2]}
{1/Sqrt[b*x^2]/x^2, x, 2, -(1/(2*x*Sqrt[b*x^2]))}


{1/(b*x^2)^(3/2)*x^5, x, 2, x^4/(3*b*Sqrt[b*x^2])}
{1/(b*x^2)^(3/2)*x^3, x, 2, x^2/(b*Sqrt[b*x^2])}
{1/(b*x^2)^(3/2)*x^1, x, 2, -(1/(b*Sqrt[b*x^2]))}
{1/(b*x^2)^(3/2)/x^1, x, 2, -(1/(3*b*x^2*Sqrt[b*x^2]))}
{1/(b*x^2)^(3/2)/x^3, x, 2, -(1/(5*b*x^4*Sqrt[b*x^2]))}

{1/(b*x^2)^(3/2)*x^6, x, 2, x^5/(4*b*Sqrt[b*x^2])}
{1/(b*x^2)^(3/2)*x^4, x, 2, x^3/(2*b*Sqrt[b*x^2])}
{1/(b*x^2)^(3/2)*x^2, x, 2, (x*Log[x])/(b*Sqrt[b*x^2])}
{1/(b*x^2)^(3/2)*x^0, x, 2, -(1/(2*b*x*Sqrt[b*x^2]))}
{1/(b*x^2)^(3/2)/x^2, x, 2, -(1/(4*b*x^3*Sqrt[b*x^2]))}


{1/(b*x^2)^(5/2)*x^7, x, 2, x^4/(3*b^2*Sqrt[b*x^2])}
{1/(b*x^2)^(5/2)*x^5, x, 2, x^2/(b^2*Sqrt[b*x^2])}
{1/(b*x^2)^(5/2)*x^3, x, 2, -(1/(b^2*Sqrt[b*x^2]))}
{1/(b*x^2)^(5/2)*x^1, x, 2, -(1/(3*b^2*x^2*Sqrt[b*x^2]))}
{1/(b*x^2)^(5/2)/x^1, x, 2, -(1/(5*b^2*x^4*Sqrt[b*x^2]))}

{1/(b*x^2)^(5/2)*x^6, x, 2, x^3/(2*b^2*Sqrt[b*x^2])}
{1/(b*x^2)^(5/2)*x^4, x, 2, (x*Log[x])/(b^2*Sqrt[b*x^2])}
{1/(b*x^2)^(5/2)*x^2, x, 2, -(1/(2*b^2*x*Sqrt[b*x^2]))}
{1/(b*x^2)^(5/2)*x^0, x, 2, -(1/(4*b^2*x^3*Sqrt[b*x^2]))}
{1/(b*x^2)^(5/2)/x^2, x, 2, -(1/(6*b^2*x^5*Sqrt[b*x^2]))}


(* ::Subsection:: *)
(*Integrands of the form (c x)^(m/2) (b x^2)^(p/2)*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (b x^2)^(p/2) with m symbolic*)


{(c*x)^m*(b*x^2)^(3/2), x, 3, (b*(c*x)^(4 + m)*Sqrt[b*x^2])/(c^4*(4 + m)*x)}
{(c*x)^m*(b*x^2)^(1/2), x, 3, ((c*x)^(2 + m)*Sqrt[b*x^2])/(c^2*(2 + m)*x)}
{(c*x)^m/(b*x^2)^(1/2), x, 3, (x*(c*x)^m)/(m*Sqrt[b*x^2])}
{(c*x)^m/(b*x^2)^(3/2), x, 3, -((c^2*x*(c*x)^(-2 + m))/(b*(2 - m)*Sqrt[b*x^2]))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (b x^2)^p with p symbolic*)


{x^m*(b*x^2)^p, x, 2, (x^(1 + m)*(b*x^2)^p)/(1 + m + 2*p)}
{(c*x)^m*(b*x^2)^p, x, 3, (x*(c*x)^m*(b*x^2)^p)/(1 + m + 2*p)}


{(x^2)^p/x^(2*p + 1), x, 2, ((x^2)^p*Log[x])/x^(2*p)}


{(b*x^2)^p*x^3, x, 2, (x^4*(b*x^2)^p)/(2*(2 + p))}
{(b*x^2)^p*x^2, x, 2, (x^3*(b*x^2)^p)/(3 + 2*p)}
{(b*x^2)^p*x^1, x, 2, (x^2*(b*x^2)^p)/(2*(1 + p))}
{(b*x^2)^p*x^0, x, 2, (x*(b*x^2)^p)/(1 + 2*p)}
{(b*x^2)^p/x^1, x, 2, (b*x^2)^p/(2*p)}
{(b*x^2)^p/x^2, x, 2, -((b*x^2)^p/((1 - 2*p)*x))}
{(b*x^2)^p/x^3, x, 2, -((b*x^2)^p/(2*(1 - p)*x^2))}
{(b*x^2)^p/x^4, x, 2, -((b*x^2)^p/((3 - 2*p)*x^3))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (b x^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (b x^n)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{Sqrt[b*x^3], x, 2, (2/5)*x*Sqrt[b*x^3]}
{Sqrt[b*x^2], x, 2, (1/2)*x*Sqrt[b*x^2]}
{Sqrt[b*x^1], x, 1, (2*(b*x)^(3/2))/(3*b)}
{Sqrt[b/x^1], x, 2, 2*Sqrt[b/x]*x}
{Sqrt[b/x^2], x, 2, Sqrt[b/x^2]*x*Log[x]}
{Sqrt[b/x^3], x, 2, -2*Sqrt[b/x^3]*x}


{(b*x^3)^(3/2), x, 2, (2/11)*b*x^4*Sqrt[b*x^3]}
{(b*x^2)^(3/2), x, 2, (1/4)*b*x^3*Sqrt[b*x^2]}
{(b*x^1)^(3/2), x, 1, (2*(b*x)^(5/2))/(5*b)}
{(b/x^1)^(3/2), x, 2, -2*b*Sqrt[b/x]}
{(b/x^2)^(3/2), x, 2, -((b*Sqrt[b/x^2])/(2*x))}
{(b/x^3)^(3/2), x, 2, -((2*b*Sqrt[b/x^3])/(7*x^2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/Sqrt[b*x^3], x, 2, -((2*x)/Sqrt[b*x^3])}
{1/Sqrt[b*x^2], x, 2, (x*Log[x])/Sqrt[b*x^2]}
{1/Sqrt[b*x^1], x, 1, (2*Sqrt[b*x])/b}
{1/Sqrt[b/x^1], x, 2, (2*x)/(3*Sqrt[b/x])}
{1/Sqrt[b/x^2], x, 2, x/(2*Sqrt[b/x^2])}
{1/Sqrt[b/x^3], x, 2, (2*x)/(5*Sqrt[b/x^3])}


{1/(b*x^3)^(3/2), x, 2, -(2/(7*b*x^2*Sqrt[b*x^3]))}
{1/(b*x^2)^(3/2), x, 2, -(1/(2*b*x*Sqrt[b*x^2]))}
{1/(b*x^1)^(3/2), x, 1, -(2/(b*Sqrt[b*x]))}
{1/(b/x^1)^(3/2), x, 2, (2*x^2)/(5*b*Sqrt[b/x])}
{1/(b/x^2)^(3/2), x, 2, x^3/(4*b*Sqrt[b/x^2])}
{1/(b/x^3)^(3/2), x, 2, (2*x^4)/(11*b*Sqrt[b/x^3])}


(* ::Subsection::Closed:: *)
(*Integrands of the form (b x^n)^(p/3)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(b*x^n)^(1/3), x, 2, (3*x*(b*x^n)^(1/3))/(3 + n)}

{(b*x^3)^(1/3), x, 2, (1/2)*x*(b*x^3)^(1/3)}
{(b*x^2)^(1/3), x, 2, (3/5)*x*(b*x^2)^(1/3)}
{(b*x^1)^(1/3), x, 1, (3*(b*x)^(4/3))/(4*b)}
{(b/x^1)^(1/3), x, 2, (3/2)*(b/x)^(1/3)*x}
{(b/x^2)^(1/3), x, 2, 3*(b/x^2)^(1/3)*x}
{(b/x^3)^(1/3), x, 2, (b/x^3)^(1/3)*x*Log[x]}
{(b/x^4)^(1/3), x, 2, -3*(b/x^4)^(1/3)*x}


{(b*x^n)^(2/3), x, 2, (3*x*(b*x^n)^(2/3))/(3 + 2*n)}

{(b*x^2)^(2/3), x, 2, (3/7)*x*(b*x^2)^(2/3)}
{(b*x^1)^(2/3), x, 1, (3*(b*x)^(5/3))/(5*b)}
{(b/x^1)^(2/3), x, 2, 3*(b/x)^(2/3)*x}
{(b/x^2)^(2/3), x, 2, -3*(b/x^2)^(2/3)*x}
{(b/x^3)^(2/3), x, 2, (-(b/x^3)^(2/3))*x}
{(b/x^4)^(2/3), x, 2, (-(3/5))*(b/x^4)^(2/3)*x}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(b*x^n)^(1/3), x, 2, (3*x)/((3 - n)*(b*x^n)^(1/3))}

{1/(b*x^4)^(1/3), x, 2, -((3*x)/(b*x^4)^(1/3))}
{1/(b*x^3)^(1/3), x, 2, (x*Log[x])/(b*x^3)^(1/3)}
{1/(b*x^2)^(1/3), x, 2, (3*x)/(b*x^2)^(1/3)}
{1/(b*x^1)^(1/3), x, 1, (3*(b*x)^(2/3))/(2*b)}
{1/(b/x^1)^(1/3), x, 2, (3*x)/(4*(b/x)^(1/3))}
{1/(b/x^2)^(1/3), x, 2, (3*x)/(5*(b/x^2)^(1/3))}
{1/(b/x^3)^(1/3), x, 2, x/(2*(b/x^3)^(1/3))}


{1/(b*x^n)^(2/3), x, 2, (3*x)/((3 - 2*n)*(b*x^n)^(2/3))}

{1/(b*x^3)^(2/3), x, 2, -(x/(b*x^3)^(2/3))}
{1/(b*x^2)^(2/3), x, 2, -((3*x)/(b*x^2)^(2/3))}
{1/(b*x^1)^(2/3), x, 1, (3*(b*x)^(1/3))/b}
{1/(b/x^1)^(2/3), x, 2, (3*x)/(5*(b/x)^(2/3))}
{1/(b/x^2)^(2/3), x, 2, (3*x)/(7*(b/x^2)^(2/3))}
{1/(b/x^3)^(2/3), x, 2, x/(3*(b/x^3)^(2/3))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (b x^n)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^2*Sqrt[b*x^n], x, 2, (2*x^3*Sqrt[b*x^n])/(6 + n)}
{x^1*Sqrt[b*x^n], x, 2, (2*x^2*Sqrt[b*x^n])/(4 + n)}
{x^0*Sqrt[b*x^n], x, 2, (2*x*Sqrt[b*x^n])/(2 + n)}
{Sqrt[b*x^n]/x^1, x, 2, (2*Sqrt[b*x^n])/n}
{Sqrt[b*x^n]/x^2, x, 2, -((2*Sqrt[b*x^n])/((2 - n)*x))}
{Sqrt[b*x^n]/x^3, x, 2, -((2*Sqrt[b*x^n])/((4 - n)*x^2))}


{(b*x^n)^(3/2)*x^1, x, 2, (2*b*x^(2 + n)*Sqrt[b*x^n])/(4 + 3*n)}
{(b*x^n)^(3/2)*x^0, x, 2, (2*b*x^(1 + n)*Sqrt[b*x^n])/(2 + 3*n)}
{(b*x^n)^(3/2)/x^1, x, 2, (2*b*x^n*Sqrt[b*x^n])/(3*n)}
{(b*x^n)^(3/2)/x^2, x, 2, -((2*b*x^(-1 + n)*Sqrt[b*x^n])/(2 - 3*n))}
{(b*x^n)^(3/2)/x^3, x, 2, -((2*b*x^(-2 + n)*Sqrt[b*x^n])/(4 - 3*n))}
{(b*x^n)^(3/2)/x^4, x, 2, -((2*b*x^(-3 + n)*Sqrt[b*x^n])/(3*(2 - n)))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^2/Sqrt[b*x^n], x, 2, (2*x^3)/((6 - n)*Sqrt[b*x^n])}
{x^1/Sqrt[b*x^n], x, 2, (2*x^2)/((4 - n)*Sqrt[b*x^n])}
{x^0/Sqrt[b*x^n], x, 2, (2*x)/((2 - n)*Sqrt[b*x^n])}
{1/(x^1*Sqrt[b*x^n]), x, 2, -(2/(n*Sqrt[b*x^n]))}
{1/(x^2*Sqrt[b*x^n]), x, 2, -(2/((2 + n)*x*Sqrt[b*x^n]))}
{1/(x^3*Sqrt[b*x^n]), x, 2, -(2/((4 + n)*x^2*Sqrt[b*x^n]))}


{1/(b*x^n)^(3/2)*x^2, x, 2, (2*x^(3 - n))/(3*b*(2 - n)*Sqrt[b*x^n])}
{1/(b*x^n)^(3/2)*x^1, x, 2, (2*x^(2 - n))/(b*(4 - 3*n)*Sqrt[b*x^n])}
{1/(b*x^n)^(3/2)*x^0, x, 2, (2*x^(1 - n))/(b*(2 - 3*n)*Sqrt[b*x^n])}
{1/(b*x^n)^(3/2)/x^1, x, 2, -(2/(x^n*(3*b*n*Sqrt[b*x^n])))}
{1/(b*x^n)^(3/2)/x^2, x, 2, -((2*x^(-1 - n))/(b*(2 + 3*n)*Sqrt[b*x^n]))}
{1/(b*x^n)^(3/2)/x^3, x, 2, -((2*x^(-2 - n))/(b*(4 + 3*n)*Sqrt[b*x^n]))}
{1/(b*x^n)^(3/2)/x^4, x, 2, -((2*x^(-3 - n))/(3*b*(2 + n)*Sqrt[b*x^n]))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (b x^n)^(p/2) with m symbolic*)


{x^m/(a*x^n)^(3/2), x, 2, (2*x^(1 + m - n))/(a*(2 + 2*m - 3*n)*Sqrt[a*x^n])}
{(c*x)^m/(a*x^n)^(3/2), x, 3, (2*x^(1 - n)*(c*x)^m)/(a*(2 + 2*m - 3*n)*Sqrt[a*x^n])}


{x^m*(b*x^n)^(3/2), x, 2, (2*b*x^(1 + m + n)*Sqrt[b*x^n])/(2 + 2*m + 3*n)}
{x^m*(b*x^n)^(1/2), x, 2, (2*x^(1 + m)*Sqrt[b*x^n])/(2 + 2*m + n)}
{x^m/(b*x^n)^(1/2), x, 2, (2*x^(1 + m))/((2 + 2*m - n)*Sqrt[b*x^n])}
{x^m/(b*x^n)^(3/2), x, 2, (2*x^(1 + m - n))/(b*(2 + 2*m - 3*n)*Sqrt[b*x^n])}


{(c*x)^m*(b*x^n)^(5/2), x, 3, (2*(c*x)^(1 + m)*(b*x^n)^(5/2))/(c*(2 + 2*m + 5*n)), (2*b^2*x^(1 + 2*n)*(c*x)^m*Sqrt[b*x^n])/(2 + 2*m + 5*n)}
{(c*x)^m*(b*x^n)^(3/2), x, 3, (2*b*x^(1 + n)*(c*x)^m*Sqrt[b*x^n])/(2 + 2*m + 3*n)}
{(c*x)^m*(b*x^n)^(1/2), x, 3, (2*(c*x)^(1 + m)*Sqrt[b*x^n])/(c*(2 + 2*m + n)), (2*x*(c*x)^m*Sqrt[b*x^n])/(2 + 2*m + n)}
{(c*x)^m/(b*x^n)^(1/2), x, 3, (2*x*(c*x)^m)/((2 + 2*m - n)*Sqrt[b*x^n])}
{(c*x)^m/(b*x^n)^(3/2), x, 3, (2*x^(1 - n)*(c*x)^m)/(b*(2 + 2*m - 3*n)*Sqrt[b*x^n])}
{(c*x)^m/(b*x^n)^(5/2), x, 3, (2*x^(1 - 2*n)*(c*x)^m)/(b^2*(2 + 2*m - 5*n)*Sqrt[b*x^n])}


{(b*x^n)^(3/2)/x^(3*n/2+1), x, 2, (b*Sqrt[b*x^n]*Log[x])/x^(n/2)}
{(b*x^n)^(1/2)/x^(n/2+1), x, 2, (Sqrt[b*x^n]*Log[x])/x^(n/2)}
{x^(n/2-1)/(b*x^n)^(1/2), x, 2, (x^(n/2)*Log[x])/Sqrt[b*x^n]}
{x^(3*n/2-1)/(b*x^n)^(3/2), x, 2, (x^(n/2)*Log[x])/(b*Sqrt[b*x^n])}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (b x^n)^p with p symbolic*)


{x^m*(b*x^n)^p, x, 2, (x^(1 + m)*(b*x^n)^p)/(1 + m + n*p)}
{(c*x)^m*(b*x^n)^p, x, 3, ((c*x)^(m + 1)*(b*x^n)^p)/(c*(1 + m + n*p)), (x*(c*x)^m*(b*x^n)^p)/(1 + m + n*p)}


{(b*x^n)^p*x^2, x, 2, (x^3*(b*x^n)^p)/(3 + n*p)}
{(b*x^n)^p*x^1, x, 2, (x^2*(b*x^n)^p)/(2 + n*p)}
{(b*x^n)^p*x^0, x, 2, (x*(b*x^n)^p)/(1 + n*p)}
{(b*x^n)^p/x^1, x, 2, (b*x^n)^p/(n*p)}
{(b*x^n)^p/x^2, x, 2, -((b*x^n)^p/((1 - n*p)*x))}
{(b*x^n)^p/x^3, x, 2, -((b*x^n)^p/((2 - n*p)*x^2))}


{x^m/(a*x^n)^(1/n), x, 2, x^(1 + m)/((a*x^n)^(1/n)*m)}
{(c*x)^m/(a*x^n)^(1/n), x, 3, (x*(c*x)^m)/((a*x^n)^n^(-1)*m)}


{x^2/(a*x^n)^(1/n), x, 2, ((1/2)*x^3)/(a*x^n)^(1/n)}
{x^1/(a*x^n)^(1/n), x, 2, x^2/(a*x^n)^(1/n)}
{x^0/(a*x^n)^(1/n), x, 2, (x*Log[x])/(a*x^n)^(1/n)}
{1/(x^1*(a*x^n)^(1/n)), x, 2, -(a*x^n)^(-n^(-1))}
{1/(x^2*(a*x^n)^(1/n)), x, 2, -(1/((a*x^n)^(1/n)*(2*x)))}


{x^m/(a*x^n)^((1 + m)/n), x, 2, (x^(1 + m)*Log[x])/(a*x^n)^((1 + m)/n)}
{(a*x^n)^p/x^(n*p+1), x, 2, ((a*x^n)^p*Log[x])/x^(n*p)}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a (b x^n)^p)^q*)


{x^m*(a*(b*x^n)^p)^q, x, 2, (x^(1 + m)*(a*(b*x^n)^p)^q)/(1 + m + n*p*q)}

{x^2*(a*(b*x^n)^p)^q, x, 2, (x^3*(a*(b*x^n)^p)^q)/(3 + n*p*q)}
{x^1*(a*(b*x^n)^p)^q, x, 2, (x^2*(a*(b*x^n)^p)^q)/(2 + n*p*q)}
{x^0*(a*(b*x^n)^p)^q, x, 2, (x*(a*(b*x^n)^p)^q)/(1 + n*p*q)}
{(a*(b*x^n)^p)^q/x^1, x, 2, (a*(b*x^n)^p)^q/(n*p*q)}
{(a*(b*x^n)^p)^q/x^2, x, 2, -((a*(b*x^n)^p)^q/((1 - n*p*q)*x))}
{(a*(b*x^n)^p)^q/x^3, x, 2, -((a*(b*x^n)^p)^q/((2 - n*p*q)*x^2))}


{x^2/(a*(b*x^m)^n)^(1/(m*n)), x, 2, ((1/2)*x^3)/(a*(b*x^m)^n)^(1/(m*n))}
{x^1/(a*(b*x^m)^n)^(1/(m*n)), x, 2, x^2/(a*(b*x^m)^n)^(1/(m*n))}
{x^0/(a*(b*x^m)^n)^(1/(m*n)), x, 2, (x*Log[x])/(a*(b*x^m)^n)^(1/(m*n))}
{1/(x^1*(a*(b*x^m)^n)^(1/(m*n))), x, 2, -(a*(b*x^m)^n)^(-(1/(m*n)))}
{1/(x^2*(a*(b*x^m)^n)^(1/(m*n))), x, 2, -(1/((a*(b*x^m)^n)^(1/(m*n))*(2*x)))}


{x^(2-n*p*q)*(a*(b*x^n)^p)^q, x, 2, (1/3)*x^(3 - n*p*q)*(a*(b*x^n)^p)^q}
{x^(1-n*p*q)*(a*(b*x^n)^p)^q, x, 2, (1/2)*x^(2 - n*p*q)*(a*(b*x^n)^p)^q}
{x^(0-n*p*q)*(a*(b*x^n)^p)^q, x, 2, x^(1 - n*p*q)*(a*(b*x^n)^p)^q}
{x^(-1-n*p*q)*(a*(b*x^n)^p)^q, x, 2, ((a*(b*x^n)^p)^q*Log[x])/x^(n*p*q)}
{x^(-2-n*p*q)*(a*(b*x^n)^p)^q, x, 2, (-x^(-1 - n*p*q))*(a*(b*x^n)^p)^q}


(* ::Title::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p when n>2 is an integer*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^3)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^3)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*(a + b*x^3), x, 2, (a*x^4)/4 + (b*x^7)/7}
{x^2*(a + b*x^3), x, 2, (a*x^3)/3 + (b*x^6)/6}
{x*(a + b*x^3), x, 2, (a*x^2)/2 + (b*x^5)/5}
{(a + b*x^3), x, 1, a*x + (b*x^4)/4}
{(a + b*x^3)/x, x, 2, (b*x^3)/3 + a*Log[x]}
{(a + b*x^3)/x^2, x, 2, -(a/x) + (b*x^2)/2}
{(a + b*x^3)/x^3, x, 2, -(a/(2*x^2)) + b*x}
{(a + b*x^3)/x^4, x, 2, -(a/(3*x^3)) + b*Log[x]}
{(a + b*x^3)/x^5, x, 2, -(a/(4*x^4)) - b/x}
{(a + b*x^3)/x^6, x, 2, -(a/(5*x^5)) - b/(2*x^2)}
{(a + b*x^3)/x^7, x, 2, -(a/(6*x^6)) - b/(3*x^3)}
{(a + b*x^3)/x^8, x, 2, -(a/(7*x^7)) - b/(4*x^4)}


{x^4*(a + b*x^3)^2, x, 2, (a^2*x^5)/5 + (1/4)*a*b*x^8 + (b^2*x^11)/11}
{x^3*(a + b*x^3)^2, x, 2, (a^2*x^4)/4 + (2/7)*a*b*x^7 + (b^2*x^10)/10}
{x^2*(a + b*x^3)^2, x, 1, (a + b*x^3)^3/(9*b)}
{x*(a + b*x^3)^2, x, 2, (a^2*x^2)/2 + (2/5)*a*b*x^5 + (b^2*x^8)/8}
{(a + b*x^3)^2, x, 2, a^2*x + (1/2)*a*b*x^4 + (b^2*x^7)/7}
{(a + b*x^3)^2/x, x, 3, (2/3)*a*b*x^3 + (b^2*x^6)/6 + a^2*Log[x]}
{(a + b*x^3)^2/x^2, x, 2, -(a^2/x) + a*b*x^2 + (b^2*x^5)/5}
{(a + b*x^3)^2/x^3, x, 2, -(a^2/(2*x^2)) + 2*a*b*x + (b^2*x^4)/4}
{(a + b*x^3)^2/x^4, x, 3, -(a^2/(3*x^3)) + (b^2*x^3)/3 + 2*a*b*Log[x]}
{(a + b*x^3)^2/x^5, x, 2, -(a^2/(4*x^4)) - (2*a*b)/x + (b^2*x^2)/2}
{(a + b*x^3)^2/x^6, x, 2, -(a^2/(5*x^5)) - (a*b)/x^2 + b^2*x}
{(a + b*x^3)^2/x^7, x, 3, -(a^2/(6*x^6)) - (2*a*b)/(3*x^3) + b^2*Log[x]}
{(a + b*x^3)^2/x^8, x, 2, -(a^2/(7*x^7)) - (a*b)/(2*x^4) - b^2/x}
{(a + b*x^3)^2/x^9, x, 2, -(a^2/(8*x^8)) - (2*a*b)/(5*x^5) - b^2/(2*x^2)}
{(a + b*x^3)^2/x^10, x, 1, -((a + b*x^3)^3/(9*a*x^9))}
{(a + b*x^3)^2/x^11, x, 2, -(a^2/(10*x^10)) - (2*a*b)/(7*x^7) - b^2/(4*x^4)}
{(a + b*x^3)^2/x^12, x, 2, -(a^2/(11*x^11)) - (a*b)/(4*x^8) - b^2/(5*x^5)}
{(a + b*x^3)^2/x^13, x, 3, -(a^2/(12*x^12)) - (2*a*b)/(9*x^9) - b^2/(6*x^6)}


{x^14*(a + b*x^3)^3, x, 3, (a^3*x^15)/15 + (1/6)*a^2*b*x^18 + (1/7)*a*b^2*x^21 + (b^3*x^24)/24}
{x^11*(a + b*x^3)^3, x, 3, (a^3*x^12)/12 + (1/5)*a^2*b*x^15 + (1/6)*a*b^2*x^18 + (b^3*x^21)/21}
{x^8*(a + b*x^3)^3, x, 3, (a^3*x^9)/9 + (1/4)*a^2*b*x^12 + (1/5)*a*b^2*x^15 + (b^3*x^18)/18}
{x^5*(a + b*x^3)^3, x, 3, -((a*(a + b*x^3)^4)/(12*b^2)) + (a + b*x^3)^5/(15*b^2)}
{x^2*(a + b*x^3)^3, x, 1, (a + b*x^3)^4/(12*b)}
{(a + b*x^3)^3/x, x, 3, a^2*b*x^3 + (1/2)*a*b^2*x^6 + (b^3*x^9)/9 + a^3*Log[x]}
{(a + b*x^3)^3/x^4, x, 3, -(a^3/(3*x^3)) + a*b^2*x^3 + (b^3*x^6)/6 + 3*a^2*b*Log[x]}
{(a + b*x^3)^3/x^7, x, 3, -(a^3/(6*x^6)) - (a^2*b)/x^3 + (b^3*x^3)/3 + 3*a*b^2*Log[x]}
{(a + b*x^3)^3/x^10, x, 3, -(a^3/(9*x^9)) - (a^2*b)/(2*x^6) - (a*b^2)/x^3 + b^3*Log[x]}
{(a + b*x^3)^3/x^13, x, 1, -((a + b*x^3)^4/(12*a*x^12))}
{(a + b*x^3)^3/x^16, x, 3, -((a + b*x^3)^4/(15*a*x^15)) + (b*(a + b*x^3)^4)/(60*a^2*x^12)}
{(a + b*x^3)^3/x^19, x, 3, -(a^3/(18*x^18)) - (a^2*b)/(5*x^15) - (a*b^2)/(4*x^12) - b^3/(9*x^9)}
{(a + b*x^3)^3/x^22, x, 3, -(a^3/(21*x^21)) - (a^2*b)/(6*x^18) - (a*b^2)/(5*x^15) - b^3/(12*x^12)}

{x^4*(a + b*x^3)^3, x, 2, (a^3*x^5)/5 + (3/8)*a^2*b*x^8 + (3/11)*a*b^2*x^11 + (b^3*x^14)/14}
{x^3*(a + b*x^3)^3, x, 2, (a^3*x^4)/4 + (3/7)*a^2*b*x^7 + (3/10)*a*b^2*x^10 + (b^3*x^13)/13}
{x*(a + b*x^3)^3, x, 2, (a^3*x^2)/2 + (3/5)*a^2*b*x^5 + (3/8)*a*b^2*x^8 + (b^3*x^11)/11}
{(a + b*x^3)^3, x, 2, a^3*x + (3/4)*a^2*b*x^4 + (3/7)*a*b^2*x^7 + (b^3*x^10)/10}
{(a + b*x^3)^3/x^2, x, 2, -(a^3/x) + (3/2)*a^2*b*x^2 + (3/5)*a*b^2*x^5 + (b^3*x^8)/8}
{(a + b*x^3)^3/x^3, x, 2, -(a^3/(2*x^2)) + 3*a^2*b*x + (3/4)*a*b^2*x^4 + (b^3*x^7)/7}
{(a + b*x^3)^3/x^5, x, 2, -(a^3/(4*x^4)) - (3*a^2*b)/x + (3/2)*a*b^2*x^2 + (b^3*x^5)/5}
{(a + b*x^3)^3/x^6, x, 2, -(a^3/(5*x^5)) - (3*a^2*b)/(2*x^2) + 3*a*b^2*x + (b^3*x^4)/4}
{(a + b*x^3)^3/x^8, x, 2, -(a^3/(7*x^7)) - (3*a^2*b)/(4*x^4) - (3*a*b^2)/x + (b^3*x^2)/2}


{x^17*(a + b*x^3)^5, x, 3, (a^5*x^18)/18 + (5*a^4*b*x^21)/21 + (5*a^3*b^2*x^24)/12 + (10*a^2*b^3*x^27)/27 + (a*b^4*x^30)/6 + (b^5*x^33)/33}
{x^14*(a + b*x^3)^5, x, 3, (a^5*x^15)/15 + (5/18)*a^4*b*x^18 + (10/21)*a^3*b^2*x^21 + (5/12)*a^2*b^3*x^24 + (5/27)*a*b^4*x^27 + (b^5*x^30)/30}
{x^11*(a + b*x^3)^5, x, 3, -((a^3*(a + b*x^3)^6)/(18*b^4)) + (a^2*(a + b*x^3)^7)/(7*b^4) - (a*(a + b*x^3)^8)/(8*b^4) + (a + b*x^3)^9/(27*b^4)}
{x^8*(a + b*x^3)^5, x, 3, (a^2*(a + b*x^3)^6)/(18*b^3) - (2*a*(a + b*x^3)^7)/(21*b^3) + (a + b*x^3)^8/(24*b^3)}
{x^5*(a + b*x^3)^5, x, 3, -((a*(a + b*x^3)^6)/(18*b^2)) + (a + b*x^3)^7/(21*b^2)}
{x^2*(a + b*x^3)^5, x, 1, (a + b*x^3)^6/(18*b)}
{(a + b*x^3)^5/x^1, x, 3, (5*a^4*b*x^3)/3 + (5*a^3*b^2*x^6)/3 + (10*a^2*b^3*x^9)/9 + (5*a*b^4*x^12)/12 + (b^5*x^15)/15 + a^5*Log[x]}
{(a + b*x^3)^5/x^4, x, 3, -a^5/(3*x^3) + (10*a^3*b^2*x^3)/3 + (5*a^2*b^3*x^6)/3 + (5*a*b^4*x^9)/9 + (b^5*x^12)/12 + 5*a^4*b*Log[x]}
{(a + b*x^3)^5/x^7, x, 3, -a^5/(6*x^6) - (5*a^4*b)/(3*x^3) + (10*a^2*b^3*x^3)/3 + (5*a*b^4*x^6)/6 + (b^5*x^9)/9 + 10*a^3*b^2*Log[x]}
{(a + b*x^3)^5/x^10, x, 3, -a^5/(9*x^9) - (5*a^4*b)/(6*x^6) - (10*a^3*b^2)/(3*x^3) + (5*a*b^4*x^3)/3 + (b^5*x^6)/6 + 10*a^2*b^3*Log[x]}
{(a + b*x^3)^5/x^13, x, 3, -a^5/(12*x^12) - (5*a^4*b)/(9*x^9) - (5*a^3*b^2)/(3*x^6) - (10*a^2*b^3)/(3*x^3) + (b^5*x^3)/3 + 5*a*b^4*Log[x]}
{(a + b*x^3)^5/x^16, x, 3, -a^5/(15*x^15) - (5*a^4*b)/(12*x^12) - (10*a^3*b^2)/(9*x^9) - (5*a^2*b^3)/(3*x^6) - (5*a*b^4)/(3*x^3) + b^5*Log[x]}
{(a + b*x^3)^5/x^19, x, 1, -(a + b*x^3)^6/(18*a*x^18)}
{(a + b*x^3)^5/x^22, x, 3, -(a + b*x^3)^6/(21*a*x^21) + (b*(a + b*x^3)^6)/(126*a^2*x^18)}
{(a + b*x^3)^5/x^25, x, 4, -((a + b*x^3)^6/(24*a*x^24)) + (b*(a + b*x^3)^6)/(84*a^2*x^21) - (b^2*(a + b*x^3)^6)/(504*a^3*x^18)}
{(a + b*x^3)^5/x^28, x, 3, -a^5/(27*x^27) - (5*a^4*b)/(24*x^24) - (10*a^3*b^2)/(21*x^21) - (5*a^2*b^3)/(9*x^18) - (a*b^4)/(3*x^15) - b^5/(12*x^12)}
{(a + b*x^3)^5/x^31, x, 3, -a^5/(30*x^30) - (5*a^4*b)/(27*x^27) - (5*a^3*b^2)/(12*x^24) - (10*a^2*b^3)/(21*x^21) - (5*a*b^4)/(18*x^18) - b^5/(15*x^15)}

{x^4*(a + b*x^3)^5, x, 2, (a^5*x^5)/5 + (5*a^4*b*x^8)/8 + (10*a^3*b^2*x^11)/11 + (5*a^2*b^3*x^14)/7 + (5*a*b^4*x^17)/17 + (b^5*x^20)/20}
{x^3*(a + b*x^3)^5, x, 2, (a^5*x^4)/4 + (5*a^4*b*x^7)/7 + a^3*b^2*x^10 + (10*a^2*b^3*x^13)/13 + (5*a*b^4*x^16)/16 + (b^5*x^19)/19}
{x^1*(a + b*x^3)^5, x, 2, (a^5*x^2)/2 + a^4*b*x^5 + (5*a^3*b^2*x^8)/4 + (10*a^2*b^3*x^11)/11 + (5*a*b^4*x^14)/14 + (b^5*x^17)/17}
{x^0*(a + b*x^3)^5, x, 2, a^5*x + (5*a^4*b*x^4)/4 + (10*a^3*b^2*x^7)/7 + a^2*b^3*x^10 + (5*a*b^4*x^13)/13 + (b^5*x^16)/16}
{(a + b*x^3)^5/x^2, x, 2, -(a^5/x) + (5*a^4*b*x^2)/2 + 2*a^3*b^2*x^5 + (5*a^2*b^3*x^8)/4 + (5*a*b^4*x^11)/11 + (b^5*x^14)/14}
{(a + b*x^3)^5/x^3, x, 2, -a^5/(2*x^2) + 5*a^4*b*x + (5*a^3*b^2*x^4)/2 + (10*a^2*b^3*x^7)/7 + (a*b^4*x^10)/2 + (b^5*x^13)/13}
{(a + b*x^3)^5/x^5, x, 2, -a^5/(4*x^4) - (5*a^4*b)/x + 5*a^3*b^2*x^2 + 2*a^2*b^3*x^5 + (5*a*b^4*x^8)/8 + (b^5*x^11)/11}
{(a + b*x^3)^5/x^6, x, 2, -a^5/(5*x^5) - (5*a^4*b)/(2*x^2) + 10*a^3*b^2*x + (5*a^2*b^3*x^4)/2 + (5*a*b^4*x^7)/7 + (b^5*x^10)/10}
{(a + b*x^3)^5/x^8, x, 2, -a^5/(7*x^7) - (5*a^4*b)/(4*x^4) - (10*a^3*b^2)/x + 5*a^2*b^3*x^2 + a*b^4*x^5 + (b^5*x^8)/8}
{(a + b*x^3)^5/x^9, x, 2, -a^5/(8*x^8) - (a^4*b)/x^5 - (5*a^3*b^2)/x^2 + 10*a^2*b^3*x + (5*a*b^4*x^4)/4 + (b^5*x^7)/7}


{x^20*(a + b*x^3)^8, x, 3, (a^6*(a + b*x^3)^9)/(27*b^7) - (a^5*(a + b*x^3)^10)/(5*b^7) + (5*a^4*(a + b*x^3)^11)/(11*b^7) - (5*a^3*(a + b*x^3)^12)/(9*b^7) + (5*a^2*(a + b*x^3)^13)/(13*b^7) - (a*(a + b*x^3)^14)/(7*b^7) + (a + b*x^3)^15/(45*b^7)}
{x^17*(a + b*x^3)^8, x, 3, -((a^5*(a + b*x^3)^9)/(27*b^6)) + (a^4*(a + b*x^3)^10)/(6*b^6) - (10*a^3*(a + b*x^3)^11)/(33*b^6) + (5*a^2*(a + b*x^3)^12)/(18*b^6) - (5*a*(a + b*x^3)^13)/(39*b^6) + (a + b*x^3)^14/(42*b^6)}
{x^14*(a + b*x^3)^8, x, 3, (a^4*(a + b*x^3)^9)/(27*b^5) - (2*a^3*(a + b*x^3)^10)/(15*b^5) + (2*a^2*(a + b*x^3)^11)/(11*b^5) - (a*(a + b*x^3)^12)/(9*b^5) + (a + b*x^3)^13/(39*b^5)}
{x^11*(a + b*x^3)^8, x, 3, -((a^3*(a + b*x^3)^9)/(27*b^4)) + (a^2*(a + b*x^3)^10)/(10*b^4) - (a*(a + b*x^3)^11)/(11*b^4) + (a + b*x^3)^12/(36*b^4)}
{x^8*(a + b*x^3)^8, x, 3, (a^2*(a + b*x^3)^9)/(27*b^3) - (a*(a + b*x^3)^10)/(15*b^3) + (a + b*x^3)^11/(33*b^3)}
{x^5*(a + b*x^3)^8, x, 3, -((a*(a + b*x^3)^9)/(27*b^2)) + (a + b*x^3)^10/(30*b^2)}
{x^2*(a + b*x^3)^8, x, 1, (a + b*x^3)^9/(27*b)}
{(a + b*x^3)^8/x^1, x, 3, (8*a^7*b*x^3)/3 + (14*a^6*b^2*x^6)/3 + (56*a^5*b^3*x^9)/9 + (35*a^4*b^4*x^12)/6 + (56*a^3*b^5*x^15)/15 + (14*a^2*b^6*x^18)/9 + (8*a*b^7*x^21)/21 + (b^8*x^24)/24 + a^8*Log[x]}
{(a + b*x^3)^8/x^4, x, 3, -a^8/(3*x^3) + (28*a^6*b^2*x^3)/3 + (28*a^5*b^3*x^6)/3 + (70*a^4*b^4*x^9)/9 + (14*a^3*b^5*x^12)/3 + (28*a^2*b^6*x^15)/15 + (4*a*b^7*x^18)/9 + (b^8*x^21)/21 + 8*a^7*b*Log[x]}
{(a + b*x^3)^8/x^7, x, 3, -a^8/(6*x^6) - (8*a^7*b)/(3*x^3) + (56*a^5*b^3*x^3)/3 + (35*a^4*b^4*x^6)/3 + (56*a^3*b^5*x^9)/9 + (7*a^2*b^6*x^12)/3 + (8*a*b^7*x^15)/15 + (b^8*x^18)/18 + 28*a^6*b^2*Log[x]}
{(a + b*x^3)^8/x^10, x, 3, -a^8/(9*x^9) - (4*a^7*b)/(3*x^6) - (28*a^6*b^2)/(3*x^3) + (70*a^4*b^4*x^3)/3 + (28*a^3*b^5*x^6)/3 + (28*a^2*b^6*x^9)/9 + (2*a*b^7*x^12)/3 + (b^8*x^15)/15 + 56*a^5*b^3*Log[x]}
{(a + b*x^3)^8/x^13, x, 3, -a^8/(12*x^12) - (8*a^7*b)/(9*x^9) - (14*a^6*b^2)/(3*x^6) - (56*a^5*b^3)/(3*x^3) + (56*a^3*b^5*x^3)/3 + (14*a^2*b^6*x^6)/3 + (8*a*b^7*x^9)/9 + (b^8*x^12)/12 + 70*a^4*b^4*Log[x]}
{(a + b*x^3)^8/x^16, x, 3, -a^8/(15*x^15) - (2*a^7*b)/(3*x^12) - (28*a^6*b^2)/(9*x^9) - (28*a^5*b^3)/(3*x^6) - (70*a^4*b^4)/(3*x^3) + (28*a^2*b^6*x^3)/3 + (4*a*b^7*x^6)/3 + (b^8*x^9)/9 + 56*a^3*b^5*Log[x]}
{(a + b*x^3)^8/x^19, x, 3, -a^8/(18*x^18) - (8*a^7*b)/(15*x^15) - (7*a^6*b^2)/(3*x^12) - (56*a^5*b^3)/(9*x^9) - (35*a^4*b^4)/(3*x^6) - (56*a^3*b^5)/(3*x^3) + (8*a*b^7*x^3)/3 + (b^8*x^6)/6 + 28*a^2*b^6*Log[x]}
{(a + b*x^3)^8/x^22, x, 3, -a^8/(21*x^21) - (4*a^7*b)/(9*x^18) - (28*a^6*b^2)/(15*x^15) - (14*a^5*b^3)/(3*x^12) - (70*a^4*b^4)/(9*x^9) - (28*a^3*b^5)/(3*x^6) - (28*a^2*b^6)/(3*x^3) + (b^8*x^3)/3 + 8*a*b^7*Log[x]}
{(a + b*x^3)^8/x^25, x, 3, -a^8/(24*x^24) - (8*a^7*b)/(21*x^21) - (14*a^6*b^2)/(9*x^18) - (56*a^5*b^3)/(15*x^15) - (35*a^4*b^4)/(6*x^12) - (56*a^3*b^5)/(9*x^9) - (14*a^2*b^6)/(3*x^6) - (8*a*b^7)/(3*x^3) + b^8*Log[x]}
{(a + b*x^3)^8/x^28, x, 1, -(a + b*x^3)^9/(27*a*x^27)}
{(a + b*x^3)^8/x^31, x, 3, -(a + b*x^3)^9/(30*a*x^30) + (b*(a + b*x^3)^9)/(270*a^2*x^27)}
{(a + b*x^3)^8/x^34, x, 4, -(a + b*x^3)^9/(33*a*x^33) + (b*(a + b*x^3)^9)/(165*a^2*x^30) - (b^2*(a + b*x^3)^9)/(1485*a^3*x^27)}
{(a + b*x^3)^8/x^37, x, 5, -((a + b*x^3)^9/(36*a*x^36)) + (b*(a + b*x^3)^9)/(132*a^2*x^33) - (b^2*(a + b*x^3)^9)/(660*a^3*x^30) + (b^3*(a + b*x^3)^9)/(5940*a^4*x^27)}
{(a + b*x^3)^8/x^40, x, 6, -((a + b*x^3)^9/(39*a*x^39)) + (b*(a + b*x^3)^9)/(117*a^2*x^36) - (b^2*(a + b*x^3)^9)/(429*a^3*x^33) + (b^3*(a + b*x^3)^9)/(2145*a^4*x^30) - (b^4*(a + b*x^3)^9)/(19305*a^5*x^27)}
{(a + b*x^3)^8/x^43, x, 3, -a^8/(42*x^42) - (8*a^7*b)/(39*x^39) - (7*a^6*b^2)/(9*x^36) - (56*a^5*b^3)/(33*x^33) - (7*a^4*b^4)/(3*x^30) - (56*a^3*b^5)/(27*x^27) - (7*a^2*b^6)/(6*x^24) - (8*a*b^7)/(21*x^21) - b^8/(18*x^18)}
{(a + b*x^3)^8/x^46, x, 3, -a^8/(45*x^45) - (4*a^7*b)/(21*x^42) - (28*a^6*b^2)/(39*x^39) - (14*a^5*b^3)/(9*x^36) - (70*a^4*b^4)/(33*x^33) - (28*a^3*b^5)/(15*x^30) - (28*a^2*b^6)/(27*x^27) - (a*b^7)/(3*x^24) - b^8/(21*x^21)}

{x^4*(a + b*x^3)^8, x, 2, (a^8*x^5)/5 + a^7*b*x^8 + (28*a^6*b^2*x^11)/11 + 4*a^5*b^3*x^14 + (70*a^4*b^4*x^17)/17 + (14*a^3*b^5*x^20)/5 + (28*a^2*b^6*x^23)/23 + (4*a*b^7*x^26)/13 + (b^8*x^29)/29}
{x^3*(a + b*x^3)^8, x, 2, (a^8*x^4)/4 + (8*a^7*b*x^7)/7 + (14*a^6*b^2*x^10)/5 + (56*a^5*b^3*x^13)/13 + (35*a^4*b^4*x^16)/8 + (56*a^3*b^5*x^19)/19 + (14*a^2*b^6*x^22)/11 + (8*a*b^7*x^25)/25 + (b^8*x^28)/28}
{x^1*(a + b*x^3)^8, x, 2, (a^8*x^2)/2 + (8*a^7*b*x^5)/5 + (7*a^6*b^2*x^8)/2 + (56*a^5*b^3*x^11)/11 + 5*a^4*b^4*x^14 + (56*a^3*b^5*x^17)/17 + (7*a^2*b^6*x^20)/5 + (8*a*b^7*x^23)/23 + (b^8*x^26)/26}
{x^0*(a + b*x^3)^8, x, 2, a^8*x + 2*a^7*b*x^4 + 4*a^6*b^2*x^7 + (28*a^5*b^3*x^10)/5 + (70*a^4*b^4*x^13)/13 + (7*a^3*b^5*x^16)/2 + (28*a^2*b^6*x^19)/19 + (4*a*b^7*x^22)/11 + (b^8*x^25)/25}
{(a + b*x^3)^8/x^2, x, 2, -(a^8/x) + 4*a^7*b*x^2 + (28*a^6*b^2*x^5)/5 + 7*a^5*b^3*x^8 + (70*a^4*b^4*x^11)/11 + 4*a^3*b^5*x^14 + (28*a^2*b^6*x^17)/17 + (2*a*b^7*x^20)/5 + (b^8*x^23)/23}
{(a + b*x^3)^8/x^3, x, 2, -a^8/(2*x^2) + 8*a^7*b*x + 7*a^6*b^2*x^4 + 8*a^5*b^3*x^7 + 7*a^4*b^4*x^10 + (56*a^3*b^5*x^13)/13 + (7*a^2*b^6*x^16)/4 + (8*a*b^7*x^19)/19 + (b^8*x^22)/22}
{(a + b*x^3)^8/x^5, x, 2, -a^8/(4*x^4) - (8*a^7*b)/x + 14*a^6*b^2*x^2 + (56*a^5*b^3*x^5)/5 + (35*a^4*b^4*x^8)/4 + (56*a^3*b^5*x^11)/11 + 2*a^2*b^6*x^14 + (8*a*b^7*x^17)/17 + (b^8*x^20)/20}
{(a + b*x^3)^8/x^6, x, 2, -a^8/(5*x^5) - (4*a^7*b)/x^2 + 28*a^6*b^2*x + 14*a^5*b^3*x^4 + 10*a^4*b^4*x^7 + (28*a^3*b^5*x^10)/5 + (28*a^2*b^6*x^13)/13 + (a*b^7*x^16)/2 + (b^8*x^19)/19}
{(a + b*x^3)^8/x^8, x, 2, -a^8/(7*x^7) - (2*a^7*b)/x^4 - (28*a^6*b^2)/x + 28*a^5*b^3*x^2 + 14*a^4*b^4*x^5 + 7*a^3*b^5*x^8 + (28*a^2*b^6*x^11)/11 + (4*a*b^7*x^14)/7 + (b^8*x^17)/17}
{(a + b*x^3)^8/x^9, x, 2, -a^8/(8*x^8) - (8*a^7*b)/(5*x^5) - (14*a^6*b^2)/x^2 + 56*a^5*b^3*x + (35*a^4*b^4*x^4)/2 + 8*a^3*b^5*x^7 + (14*a^2*b^6*x^10)/5 + (8*a*b^7*x^13)/13 + (b^8*x^16)/16}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^8/(a + b*x^3), x, 3, -((a*x^3)/(3*b^2)) + x^6/(6*b) + (a^2*Log[a + b*x^3])/(3*b^3)}
{x^5/(a + b*x^3), x, 3, x^3/(3*b) - (a*Log[a + b*x^3])/(3*b^2)}
{x^2/(a + b*x^3), x, 1, Log[a + b*x^3]/(3*b)}
{1/(x^1*(a + b*x^3)), x, 4, Log[x]/a - Log[a + b*x^3]/(3*a)}
{1/(x^4*(a + b*x^3)), x, 3, -(1/(3*a*x^3)) - (b*Log[x])/a^2 + (b*Log[a + b*x^3])/(3*a^2)}

{x^4/(a + b*x^3), x, 7, x^2/(2*b) + (a^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(5/3)) + (a^(2/3)*Log[a^(1/3) + b^(1/3)*x])/(3*b^(5/3)) - (a^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(5/3))}
{x^3/(a + b*x^3), x, 7, x/b + (a^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(4/3)) - (a^(1/3)*Log[a^(1/3) + b^(1/3)*x])/(3*b^(4/3)) + (a^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(4/3))}
{x^1/(a + b*x^3), x, 6, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3))) - Log[a^(1/3) + b^(1/3)*x]/(3*a^(1/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(1/3)*b^(2/3))}
{x^0/(a + b*x^3), x, 6, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3)*b^(1/3))) + Log[a^(1/3) + b^(1/3)*x]/(3*a^(2/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(2/3)*b^(1/3))}
{1/(x^2*(a + b*x^3)), x, 7, -(1/(a*x)) + (b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*x])/(3*a^(4/3)) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(4/3))}
{1/(x^3*(a + b*x^3)), x, 7, -(1/(2*a*x^2)) + (b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)) - (b^(2/3)*Log[a^(1/3) + b^(1/3)*x])/(3*a^(5/3)) + (b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(5/3))}


{x^8/(a + b*x^3)^2, x, 3, x^3/(3*b^2) - a^2/(3*b^3*(a + b*x^3)) - (2*a*Log[a + b*x^3])/(3*b^3)}
{x^5/(a + b*x^3)^2, x, 3, a/(3*b^2*(a + b*x^3)) + Log[a + b*x^3]/(3*b^2)}
{x^2/(a + b*x^3)^2, x, 1, -(1/(3*b*(a + b*x^3)))}
{1/(x^1*(a + b*x^3)^2), x, 3, 1/(3*a*(a + b*x^3)) + Log[x]/a^2 - Log[a + b*x^3]/(3*a^2)}
{1/(x^4*(a + b*x^3)^2), x, 3, -(1/(3*a^2*x^3)) - b/(3*a^2*(a + b*x^3)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x^3])/(3*a^3)}

{x^4/(a + b*x^3)^2, x, 7, -(x^2/(3*b*(a + b*x^3))) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(1/3)*b^(5/3)) - (2*Log[a^(1/3) + b^(1/3)*x])/(9*a^(1/3)*b^(5/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(9*a^(1/3)*b^(5/3))}
{x^3/(a + b*x^3)^2, x, 7, -(x/(3*b*(a + b*x^3))) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(2/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x]/(9*a^(2/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(18*a^(2/3)*b^(4/3))}
{x^1/(a + b*x^3)^2, x, 7, x^2/(3*a*(a + b*x^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(4/3)*b^(2/3)) - Log[a^(1/3) + b^(1/3)*x]/(9*a^(4/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(18*a^(4/3)*b^(2/3))}
{x^0/(a + b*x^3)^2, x, 7, x/(3*a*(a + b*x^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(5/3)*b^(1/3)) + (2*Log[a^(1/3) + b^(1/3)*x])/(9*a^(5/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(9*a^(5/3)*b^(1/3))}
{1/(x^2*(a + b*x^3)^2), x, 8, -(4/(3*a^2*x)) + 1/(3*a*x*(a + b*x^3)) + (4*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)) + (4*b^(1/3)*Log[a^(1/3) + b^(1/3)*x])/(9*a^(7/3)) - (2*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(9*a^(7/3))}
{1/(x^3*(a + b*x^3)^2), x, 8, -(5/(6*a^2*x^2)) + 1/(3*a*x^2*(a + b*x^3)) + (5*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(8/3)) - (5*b^(2/3)*Log[a^(1/3) + b^(1/3)*x])/(9*a^(8/3)) + (5*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(18*a^(8/3))}


{x^11/(a + b*x^3)^3, x, 3, x^3/(3*b^3) + a^3/(6*b^4*(a + b*x^3)^2) - a^2/(b^4*(a + b*x^3)) - (a*Log[a + b*x^3])/b^4}
{x^8/(a + b*x^3)^3, x, 3, -(a^2/(6*b^3*(a + b*x^3)^2)) + (2*a)/(3*b^3*(a + b*x^3)) + Log[a + b*x^3]/(3*b^3)}
{x^5/(a + b*x^3)^3, x, 1, x^6/(6*a*(a + b*x^3)^2)}
{x^2/(a + b*x^3)^3, x, 1, -(1/(6*b*(a + b*x^3)^2))}
{1/(x^1*(a + b*x^3)^3), x, 3, 1/(6*a*(a + b*x^3)^2) + 1/(3*a^2*(a + b*x^3)) + Log[x]/a^3 - Log[a + b*x^3]/(3*a^3)}
{1/(x^4*(a + b*x^3)^3), x, 3, -(1/(3*a^3*x^3)) - b/(6*a^2*(a + b*x^3)^2) - (2*b)/(3*a^3*(a + b*x^3)) - (3*b*Log[x])/a^4 + (b*Log[a + b*x^3])/a^4}

{x^7/(a + b*x^3)^3, x, 8, -(x^5/(6*b*(a + b*x^3)^2)) - (5*x^2)/(18*b^2*(a + b*x^3)) - (5*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(1/3)*b^(8/3)) - (5*Log[a^(1/3) + b^(1/3)*x])/(27*a^(1/3)*b^(8/3)) + (5*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(54*a^(1/3)*b^(8/3))}
{x^6/(a + b*x^3)^3, x, 8, -(x^4/(6*b*(a + b*x^3)^2)) - (2*x)/(9*b^2*(a + b*x^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(2/3)*b^(7/3)) + (2*Log[a^(1/3) + b^(1/3)*x])/(27*a^(2/3)*b^(7/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(27*a^(2/3)*b^(7/3))}
{x^4/(a + b*x^3)^3, x, 8, -(x^2/(6*b*(a + b*x^3)^2)) + x^2/(9*a*b*(a + b*x^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(4/3)*b^(5/3)) - Log[a^(1/3) + b^(1/3)*x]/(27*a^(4/3)*b^(5/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(54*a^(4/3)*b^(5/3))}
{x^3/(a + b*x^3)^3, x, 8, -(x/(6*b*(a + b*x^3)^2)) + x/(18*a*b*(a + b*x^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(5/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x]/(27*a^(5/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(54*a^(5/3)*b^(4/3))}
{x/(a + b*x^3)^3, x, 8, x^2/(6*a*(a + b*x^3)^2) + (2*x^2)/(9*a^2*(a + b*x^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(7/3)*b^(2/3)) - (2*Log[a^(1/3) + b^(1/3)*x])/(27*a^(7/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(27*a^(7/3)*b^(2/3))}
{1/(a + b*x^3)^3, x, 8, x/(6*a*(a + b*x^3)^2) + (5*x)/(18*a^2*(a + b*x^3)) - (5*ArcTan[(a^(1/3) - 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(8/3)*b^(1/3)) + (5*Log[a^(1/3) + b^(1/3)*x])/(27*a^(8/3)*b^(1/3)) - (5*Log[a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(54*a^(8/3)*b^(1/3))}


{x^8/(a - b*x^3), x, 3, -((a*x^3)/(3*b^2)) - x^6/(6*b) - (a^2*Log[a - b*x^3])/(3*b^3)}
{x^5/(a - b*x^3), x, 3, -(x^3/(3*b)) - (a*Log[a - b*x^3])/(3*b^2)}
{x^2/(a - b*x^3), x, 1, -(Log[a - b*x^3]/(3*b))}
{1/(x^1*(a - b*x^3)), x, 4, Log[x]/a - Log[a - b*x^3]/(3*a)}
{1/(x^4*(a - b*x^3)), x, 3, -(1/(3*a*x^3)) + (b*Log[x])/a^2 - (b*Log[a - b*x^3])/(3*a^2)}

{x^4/(a - b*x^3), x, 7, -(x^2/(2*b)) - (a^(2/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(5/3)) - (a^(2/3)*Log[a^(1/3) - b^(1/3)*x])/(3*b^(5/3)) + (a^(2/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(5/3))}
{x^3/(a - b*x^3), x, 7, -(x/b) + (a^(1/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(4/3)) - (a^(1/3)*Log[a^(1/3) - b^(1/3)*x])/(3*b^(4/3)) + (a^(1/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*b^(4/3))}
{x^1/(a - b*x^3), x, 6, -(ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3))) - Log[a^(1/3) - b^(1/3)*x]/(3*a^(1/3)*b^(2/3)) + Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(1/3)*b^(2/3))}
{x^0/(a - b*x^3), x, 6, ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3)*b^(1/3)) - Log[a^(1/3) - b^(1/3)*x]/(3*a^(2/3)*b^(1/3)) + Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*a^(2/3)*b^(1/3))}
{1/(x^2*(a - b*x^3)), x, 7, -(1/(a*x)) - (b^(1/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)) - (b^(1/3)*Log[a^(1/3) - b^(1/3)*x])/(3*a^(4/3)) + (b^(1/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(4/3))}
{1/(x^3*(a - b*x^3)), x, 7, -(1/(2*a*x^2)) + (b^(2/3)*ArcTan[(a^(1/3) + 2*b^(1/3)*x)/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)) - (b^(2/3)*Log[a^(1/3) - b^(1/3)*x])/(3*a^(5/3)) + (b^(2/3)*Log[a^(2/3) + a^(1/3)*b^(1/3)*x + b^(2/3)*x^2])/(6*a^(5/3))}


{1/(1 + a + b*x^3), x, 6, -(ArcTan[(1 - (2*b^(1/3)*x)/(1 + a)^(1/3))/Sqrt[3]]/(Sqrt[3]*(1 + a)^(2/3)*b^(1/3))) + Log[(1 + a)^(1/3) + b^(1/3)*x]/(3*(1 + a)^(2/3)*b^(1/3)) - Log[(1 + a)^(2/3) - (1 + a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(1 + a)^(2/3)*b^(1/3))}
{1/(1 + a - b*x^3), x, 6, ArcTan[(1 + (2*b^(1/3)*x)/(1 + a)^(1/3))/Sqrt[3]]/(Sqrt[3]*(1 + a)^(2/3)*b^(1/3)) - Log[(1 + a)^(1/3) - b^(1/3)*x]/(3*(1 + a)^(2/3)*b^(1/3)) + Log[(1 + a)^(2/3) + (1 + a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(1 + a)^(2/3)*b^(1/3))}
{1/(-1 + a + b*x^3), x, 6, -(ArcTan[(1 + (2*b^(1/3)*x)/(1 - a)^(1/3))/Sqrt[3]]/(Sqrt[3]*(1 - a)^(2/3)*b^(1/3))) + Log[(1 - a)^(1/3) - b^(1/3)*x]/(3*(1 - a)^(2/3)*b^(1/3)) - Log[(1 - a)^(2/3) + (1 - a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(1 - a)^(2/3)*b^(1/3))}
{1/(-1 + a - b*x^3), x, 6, ArcTan[(1 - (2*b^(1/3)*x)/(1 - a)^(1/3))/Sqrt[3]]/(Sqrt[3]*(1 - a)^(2/3)*b^(1/3)) - Log[(1 - a)^(1/3) + b^(1/3)*x]/(3*(1 - a)^(2/3)*b^(1/3)) + Log[(1 - a)^(2/3) - (1 - a)^(1/3)*b^(1/3)*x + b^(2/3)*x^2]/(6*(1 - a)^(2/3)*b^(1/3))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^3)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{Sqrt[x]/(1 + x^3), x, 3, (2*ArcTan[x^(3/2)])/3}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^3)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^11*Sqrt[a + b*x^3], x, 3, (-2*a^3*(a + b*x^3)^(3/2))/(9*b^4) + (2*a^2*(a + b*x^3)^(5/2))/(5*b^4) - (2*a*(a + b*x^3)^(7/2))/(7*b^4) + (2*(a + b*x^3)^(9/2))/(27*b^4)}
{x^8*Sqrt[a + b*x^3], x, 3, (2*a^2*(a + b*x^3)^(3/2))/(9*b^3) - (4*a*(a + b*x^3)^(5/2))/(15*b^3) + (2*(a + b*x^3)^(7/2))/(21*b^3)}
{x^5*Sqrt[a + b*x^3], x, 3, (-2*a*(a + b*x^3)^(3/2))/(9*b^2) + (2*(a + b*x^3)^(5/2))/(15*b^2)}
{x^2*Sqrt[a + b*x^3], x, 1, (2*(a + b*x^3)^(3/2))/(9*b)}
{Sqrt[a + b*x^3]/x^1, x, 4, (2*Sqrt[a + b*x^3])/3 - (2*Sqrt[a]*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/3}
{Sqrt[a + b*x^3]/x^4, x, 4, -Sqrt[a + b*x^3]/(3*x^3) - (b*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(3*Sqrt[a])}
{Sqrt[a + b*x^3]/x^7, x, 5, -Sqrt[a + b*x^3]/(6*x^6) - (b*Sqrt[a + b*x^3])/(12*a*x^3) + (b^2*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(12*a^(3/2))}
{Sqrt[a + b*x^3]/x^10, x, 6, -Sqrt[a + b*x^3]/(9*x^9) - (b*Sqrt[a + b*x^3])/(36*a*x^6) + (b^2*Sqrt[a + b*x^3])/(24*a^2*x^3) - (b^3*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(24*a^(5/2))}

{x^6*Sqrt[a + b*x^3], x, 4, (-48*a^2*x*Sqrt[a + b*x^3])/(935*b^2) + (6*a*x^4*Sqrt[a + b*x^3])/(187*b) + (2*x^7*Sqrt[a + b*x^3])/17 + (32*3^(3/4)*Sqrt[2+Sqrt[3]]*a^3*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(935*b^(7/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^3*Sqrt[a + b*x^3], x, 3, (6*a*x*Sqrt[a + b*x^3])/(55*b) + (2*x^4*Sqrt[a + b*x^3])/11 - (4*3^(3/4)*Sqrt[2+Sqrt[3]]*a^2*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(55*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^0*Sqrt[a + b*x^3], x, 2, (2*x*Sqrt[a + b*x^3])/5 + (2*3^(3/4)*Sqrt[2+Sqrt[3]]*a*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(5*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{Sqrt[a + b*x^3]/x^3, x, 2, -Sqrt[a + b*x^3]/(2*x^2) + (3^(3/4)*Sqrt[2+Sqrt[3]]*b^(2/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{Sqrt[a + b*x^3]/x^6, x, 3, -Sqrt[a + b*x^3]/(5*x^5) - (3*b*Sqrt[a + b*x^3])/(20*a*x^2) - (3^(3/4)*Sqrt[2+Sqrt[3]]*b^(5/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(20*a*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{Sqrt[a + b*x^3]/x^9, x, 4, -Sqrt[a + b*x^3]/(8*x^8) - (3*b*Sqrt[a + b*x^3])/(80*a*x^5) + (21*b^2*Sqrt[a + b*x^3])/(320*a^2*x^2) + (7*3^(3/4)*Sqrt[2+Sqrt[3]]*b^(8/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(320*a^2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}

{x^7*Sqrt[a + b*x^3], x, 6, (-60*a^2*x^2*Sqrt[a + b*x^3])/(1729*b^2) + (6*a*x^5*Sqrt[a + b*x^3])/(247*b) + (2*x^8*Sqrt[a + b*x^3])/19 + (240*a^3*Sqrt[a + b*x^3])/(1729*b^(8/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (120*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(10/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(1729*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (80*Sqrt[2]*3^(3/4)*a^(10/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(1729*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^4*Sqrt[a + b*x^3], x, 5, (6*a*x^2*Sqrt[a + b*x^3])/(91*b) + (2*x^5*Sqrt[a + b*x^3])/13 - (24*a^2*Sqrt[a + b*x^3])/(91*b^(5/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (12*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(7/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(91*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) - (8*Sqrt[2]*3^(3/4)*a^(7/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(91*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^1*Sqrt[a + b*x^3], x, 4, (2*x^2*Sqrt[a + b*x^3])/7 + (6*a*Sqrt[a + b*x^3])/(7*b^(2/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(7*b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (2*Sqrt[2]*3^(3/4)*a^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(7*b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{Sqrt[a + b*x^3]/x^2, x, 4, -(Sqrt[a + b*x^3]/x) + (3*b^(1/3)*Sqrt[a + b*x^3])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x) - (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (Sqrt[2]*3^(3/4)*a^(1/3)*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{Sqrt[a + b*x^3]/x^5, x, 5, -Sqrt[a + b*x^3]/(4*x^4) - (3*b*Sqrt[a + b*x^3])/(8*a*x) + (3*b^(4/3)*Sqrt[a + b*x^3])/(8*a*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(16*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (3^(3/4)*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}


{x^11*(a + b*x^3)^(3/2), x, 3, (-2*a^3*(a + b*x^3)^(5/2))/(15*b^4) + (2*a^2*(a + b*x^3)^(7/2))/(7*b^4) - (2*a*(a + b*x^3)^(9/2))/(9*b^4) + (2*(a + b*x^3)^(11/2))/(33*b^4)}
{x^8*(a + b*x^3)^(3/2), x, 3, (2*a^2*(a + b*x^3)^(5/2))/(15*b^3) - (4*a*(a + b*x^3)^(7/2))/(21*b^3) + (2*(a + b*x^3)^(9/2))/(27*b^3)}
{x^5*(a + b*x^3)^(3/2), x, 3, (-2*a*(a + b*x^3)^(5/2))/(15*b^2) + (2*(a + b*x^3)^(7/2))/(21*b^2)}
{x^2*(a + b*x^3)^(3/2), x, 1, (2*(a + b*x^3)^(5/2))/(15*b)}
{(a + b*x^3)^(3/2)/x^1, x, 5, (2*a*Sqrt[a + b*x^3])/3 + (2*(a + b*x^3)^(3/2))/9 - (2*a^(3/2)*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/3}
{(a + b*x^3)^(3/2)/x^4, x, 5, b*Sqrt[a + b*x^3] - (a + b*x^3)^(3/2)/(3*x^3) - Sqrt[a]*b*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]]}
{(a + b*x^3)^(3/2)/x^7, x, 5, -(b*Sqrt[a + b*x^3])/(4*x^3) - (a + b*x^3)^(3/2)/(6*x^6) - (b^2*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(4*Sqrt[a])}

{x^6*(a + b*x^3)^(3/2), x, 5, (-432*a^3*x*Sqrt[a + b*x^3])/(21505*b^2) + (54*a^2*x^4*Sqrt[a + b*x^3])/(4301*b) + (18*a*x^7*Sqrt[a + b*x^3])/391 + (2*x^7*(a + b*x^3)^(3/2))/23 + (288*3^(3/4)*Sqrt[2+Sqrt[3]]*a^4*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(21505*b^(7/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^3*(a + b*x^3)^(3/2), x, 4, (54*a^2*x*Sqrt[a + b*x^3])/(935*b) + (18*a*x^4*Sqrt[a + b*x^3])/187 + (2*x^4*(a + b*x^3)^(3/2))/17 - (36*3^(3/4)*Sqrt[2+Sqrt[3]]*a^3*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(935*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^0*(a + b*x^3)^(3/2), x, 3, (18*a*x*Sqrt[a + b*x^3])/55 + (2*x*(a + b*x^3)^(3/2))/11 + (18*3^(3/4)*Sqrt[2+Sqrt[3]]*a^2*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(55*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{(a + b*x^3)^(3/2)/x^3, x, 3, (9*b*x*Sqrt[a + b*x^3])/10 - (a + b*x^3)^(3/2)/(2*x^2) + (9*3^(3/4)*Sqrt[2+Sqrt[3]]*a*b^(2/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(10*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{(a + b*x^3)^(3/2)/x^6, x, 3, (-9*b*Sqrt[a + b*x^3])/(20*x^2) - (a + b*x^3)^(3/2)/(5*x^5) + (9*3^(3/4)*Sqrt[2+Sqrt[3]]*b^(5/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(20*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}

{x^7*(a + b*x^3)^(3/2), x, 7, (-108*a^3*x^2*Sqrt[a + b*x^3])/(8645*b^2) + (54*a^2*x^5*Sqrt[a + b*x^3])/(6175*b) + (18*a*x^8*Sqrt[a + b*x^3])/475 + (432*a^4*Sqrt[a + b*x^3])/(8645*b^(8/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (2*x^8*(a + b*x^3)^(3/2))/25 - (216*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(13/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(8645*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (144*Sqrt[2]*3^(3/4)*a^(13/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(8645*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^4*(a + b*x^3)^(3/2), x, 6, (54*a^2*x^2*Sqrt[a + b*x^3])/(1729*b) + (18*a*x^5*Sqrt[a + b*x^3])/247 - (216*a^3*Sqrt[a + b*x^3])/(1729*b^(5/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (2*x^5*(a + b*x^3)^(3/2))/19 + (108*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(10/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(1729*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) - (72*Sqrt[2]*3^(3/4)*a^(10/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(1729*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^1*(a + b*x^3)^(3/2), x, 5, (18*a*x^2*Sqrt[a + b*x^3])/91 + (54*a^2*Sqrt[a + b*x^3])/(91*b^(2/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (2*x^2*(a + b*x^3)^(3/2))/13 - (27*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(7/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(91*b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (18*Sqrt[2]*3^(3/4)*a^(7/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(91*b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{(a + b*x^3)^(3/2)/x^2, x, 5, (9*b*x^2*Sqrt[a + b*x^3])/7 + (27*a*b^(1/3)*Sqrt[a + b*x^3])/(7*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (a + b*x^3)^(3/2)/x - (27*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(14*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (9*Sqrt[2]*3^(3/4)*a^(4/3)*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(7*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{(a + b*x^3)^(3/2)/x^5, x, 5, (-9*b*Sqrt[a + b*x^3])/(8*x) + (27*b^(4/3)*Sqrt[a + b*x^3])/(8*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (a + b*x^3)^(3/2)/(4*x^4) - (27*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(16*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (9*3^(3/4)*a^(1/3)*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^11/Sqrt[a + b*x^3], x, 3, (-2*a^3*Sqrt[a + b*x^3])/(3*b^4) + (2*a^2*(a + b*x^3)^(3/2))/(3*b^4) - (2*a*(a + b*x^3)^(5/2))/(5*b^4) + (2*(a + b*x^3)^(7/2))/(21*b^4)}
{x^8/Sqrt[a + b*x^3], x, 3, (2*a^2*Sqrt[a + b*x^3])/(3*b^3) - (4*a*(a + b*x^3)^(3/2))/(9*b^3) + (2*(a + b*x^3)^(5/2))/(15*b^3)}
{x^5/Sqrt[a + b*x^3], x, 3, (-2*a*Sqrt[a + b*x^3])/(3*b^2) + (2*(a + b*x^3)^(3/2))/(9*b^2)}
{x^2/Sqrt[a + b*x^3], x, 1, (2*Sqrt[a + b*x^3])/(3*b)}
{1/(x^1*Sqrt[a + b*x^3]), x, 3, (-2*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(3*Sqrt[a])}
{1/(x^4*Sqrt[a + b*x^3]), x, 4, -Sqrt[a + b*x^3]/(3*a*x^3) + (b*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(3*a^(3/2))}
{1/(x^7*Sqrt[a + b*x^3]), x, 5, -Sqrt[a + b*x^3]/(6*a*x^6) + (b*Sqrt[a + b*x^3])/(4*a^2*x^3) - (b^2*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(4*a^(5/2))}

{x^6/Sqrt[a + b*x^3], x, 3, (-16*a*x*Sqrt[a + b*x^3])/(55*b^2) + (2*x^4*Sqrt[a + b*x^3])/(11*b) + (32*Sqrt[2+Sqrt[3]]/3^(1/4)*a^2*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(55*b^(7/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^3/Sqrt[a + b*x^3], x, 2, (2*x*Sqrt[a + b*x^3])/(5*b) - (4*Sqrt[2+Sqrt[3]]/3^(1/4)*a*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(5*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^0/Sqrt[a + b*x^3], x, 1, (2*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3^(1/4)*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^3*Sqrt[a + b*x^3]), x, 2, -Sqrt[a + b*x^3]/(2*a*x^2) - (Sqrt[2+Sqrt[3]]/3^(1/4)*b^(2/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(2*a*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^6*Sqrt[a + b*x^3]), x, 3, -Sqrt[a + b*x^3]/(5*a*x^5) + (7*b*Sqrt[a + b*x^3])/(20*a^2*x^2) + (7*Sqrt[2+Sqrt[3]]/3^(1/4)*b^(5/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(20*a^2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}

{x^7/Sqrt[a + b*x^3], x, 5, (-20*a*x^2*Sqrt[a + b*x^3])/(91*b^2) + (2*x^5*Sqrt[a + b*x^3])/(13*b) + (80*a^2*Sqrt[a + b*x^3])/(91*b^(8/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (40*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(7/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(91*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (80*Sqrt[2]*a^(7/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(91*3^(1/4)*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^4/Sqrt[a + b*x^3], x, 4, (2*x^2*Sqrt[a + b*x^3])/(7*b) - (8*a*Sqrt[a + b*x^3])/(7*b^(5/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (4*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(7*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) - (8*Sqrt[2]*a^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(7*3^(1/4)*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^1/Sqrt[a + b*x^3], x, 3, (2*Sqrt[a + b*x^3])/(b^(2/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (2*Sqrt[2]*a^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3^(1/4)*b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^2*Sqrt[a + b*x^3]), x, 4, -(Sqrt[a + b*x^3]/(a*x)) + (b^(1/3)*Sqrt[a + b*x^3])/(a*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(2*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (Sqrt[2]*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3^(1/4)*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^5*Sqrt[a + b*x^3]), x, 5, -Sqrt[a + b*x^3]/(4*a*x^4) + (5*b*Sqrt[a + b*x^3])/(8*a^2*x) - (5*b^(4/3)*Sqrt[a + b*x^3])/(8*a^2*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (5*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(16*a^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) - (5*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*3^(1/4)*a^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}


{x^11/(a + b*x^3)^(3/2), x, 3, (2*a^3)/(3*b^4*Sqrt[a + b*x^3]) + (2*a^2*Sqrt[a + b*x^3])/b^4 - (2*a*(a + b*x^3)^(3/2))/(3*b^4) + (2*(a + b*x^3)^(5/2))/(15*b^4)}
{x^8/(a + b*x^3)^(3/2), x, 3, (-2*a^2)/(3*b^3*Sqrt[a + b*x^3]) - (4*a*Sqrt[a + b*x^3])/(3*b^3) + (2*(a + b*x^3)^(3/2))/(9*b^3)}
{x^5/(a + b*x^3)^(3/2), x, 3, (2*a)/(3*b^2*Sqrt[a + b*x^3]) + (2*Sqrt[a + b*x^3])/(3*b^2)}
{x^2/(a + b*x^3)^(3/2), x, 1, -2/(3*b*Sqrt[a + b*x^3])}
{1/(x^1*(a + b*x^3)^(3/2)), x, 4, 2/(3*a*Sqrt[a + b*x^3]) - (2*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(3*a^(3/2))}
{1/(x^4*(a + b*x^3)^(3/2)), x, 5, -(b/(a^2*Sqrt[a + b*x^3])) - 1/(3*a*x^3*Sqrt[a + b*x^3]) + (b*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/a^(5/2)}
{1/(x^7*(a + b*x^3)^(3/2)), x, 6, (5*b^2)/(4*a^3*Sqrt[a + b*x^3]) - 1/(6*a*x^6*Sqrt[a + b*x^3]) + (5*b)/(12*a^2*x^3*Sqrt[a + b*x^3]) - (5*b^2*ArcTanh[Sqrt[a + b*x^3]/Sqrt[a]])/(4*a^(7/2))}

{x^6/(a + b*x^3)^(3/2), x, 3, (-2*x^4)/(3*b*Sqrt[a + b*x^3]) + (16*x*Sqrt[a + b*x^3])/(15*b^2) - (32*Sqrt[2+Sqrt[3]]/3^(1/4)*a*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(15*b^(7/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^3/(a + b*x^3)^(3/2), x, 2, (-2*x)/(3*b*Sqrt[a + b*x^3]) + (4*Sqrt[2+Sqrt[3]]/3^(1/4)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*b^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^0/(a + b*x^3)^(3/2), x, 2, (2*x)/(3*a*Sqrt[a + b*x^3]) + (2*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a*b^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^3*(a + b*x^3)^(3/2)), x, 3, 2/(3*a*x^2*Sqrt[a + b*x^3]) - (7*Sqrt[a + b*x^3])/(6*a^2*x^2) - (7*Sqrt[2+Sqrt[3]]/3^(1/4)*b^(2/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(6*a^2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^6*(a + b*x^3)^(3/2)), x, 4, 2/(3*a*x^5*Sqrt[a + b*x^3]) - (13*Sqrt[a + b*x^3])/(15*a^2*x^5) + (91*b*Sqrt[a + b*x^3])/(60*a^3*x^2) + (91*Sqrt[2+Sqrt[3]]/3^(1/4)*b^(5/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(60*a^3*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}

{x^7/(a + b*x^3)^(3/2), x, 5, (-2*x^5)/(3*b*Sqrt[a + b*x^3]) + (20*x^2*Sqrt[a + b*x^3])/(21*b^2) - (80*a*Sqrt[a + b*x^3])/(21*b^(8/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (40*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(21*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) - (80*Sqrt[2]*a^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(21*3^(1/4)*b^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^4/(a + b*x^3)^(3/2), x, 4, (-2*x^2)/(3*b*Sqrt[a + b*x^3]) + (8*Sqrt[a + b*x^3])/(3*b^(5/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (4*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (8*Sqrt[2]*a^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*b^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{x^1/(a + b*x^3)^(3/2), x, 4, (2*x^2)/(3*a*Sqrt[a + b*x^3]) - (2*Sqrt[a + b*x^3])/(3*a*b^(2/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (3^(1/4)*Sqrt[2 - Sqrt[3]]*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*a^(2/3)*b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) - (2*Sqrt[2]*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a^(2/3)*b^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^2*(a + b*x^3)^(3/2)), x, 5, 2/(3*a*x*Sqrt[a + b*x^3]) - (5*Sqrt[a + b*x^3])/(3*a^2*x) + (5*b^(1/3)*Sqrt[a + b*x^3])/(3*a^2*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) - (5*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(6*a^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) + (5*Sqrt[2]*b^(1/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a^(5/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}
{1/(x^5*(a + b*x^3)^(3/2)), x, 6, 2/(3*a*x^4*Sqrt[a + b*x^3]) - (11*Sqrt[a + b*x^3])/(12*a^2*x^4) + (55*b*Sqrt[a + b*x^3])/(24*a^3*x) - (55*b^(4/3)*Sqrt[a + b*x^3])/(24*a^3*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)) + (55*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(48*a^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3]) - (55*b^(4/3)*(a^(1/3) + b^(1/3)*x)*Sqrt[(a^(2/3) - a^(1/3)*b^(1/3)*x + b^(2/3)*x^2)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)], -7 - 4*Sqrt[3]])/(12*Sqrt[2]*3^(1/4)*a^(8/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*x)^2]*Sqrt[a + b*x^3])}


{x^11/Sqrt[1 + x^3], x, 3, (-(2/3))*Sqrt[1 + x^3] + (2/3)*(1 + x^3)^(3/2) - (2/5)*(1 + x^3)^(5/2) + (2/21)*(1 + x^3)^(7/2)}
{x^8/Sqrt[1 + x^3], x, 3, (2*Sqrt[1 + x^3])/3 - (4/9)*(1 + x^3)^(3/2) + (2/15)*(1 + x^3)^(5/2)}
{x^5/Sqrt[1 + x^3], x, 3, (-(2/3))*Sqrt[1 + x^3] + (2/9)*(1 + x^3)^(3/2)}
{x^2/Sqrt[1 + x^3], x, 1, (2*Sqrt[1 + x^3])/3}
{1/(x^1*Sqrt[1 + x^3]), x, 3, (-(2/3))*ArcTanh[Sqrt[1 + x^3]]}
{1/(x^4*Sqrt[1 + x^3]), x, 4, -(Sqrt[1 + x^3]/(3*x^3)) + (1/3)*ArcTanh[Sqrt[1 + x^3]]}
{1/(x^7*Sqrt[1 + x^3]), x, 5, -(Sqrt[1 + x^3]/(6*x^6)) + Sqrt[1 + x^3]/(4*x^3) - (1/4)*ArcTanh[Sqrt[1 + x^3]]}
{1/(x^10*Sqrt[1 + x^3]), x, 6, -(Sqrt[1 + x^3]/(9*x^9)) + (5*Sqrt[1 + x^3])/(36*x^6) - (5*Sqrt[1 + x^3])/(24*x^3) + (5/24)*ArcTanh[Sqrt[1 + x^3]]}

{x^6/Sqrt[1 + x^3], x, 3, (-(16/55))*x*Sqrt[1 + x^3] + (2/11)*x^4*Sqrt[1 + x^3] + (32*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(55*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{x^3/Sqrt[1 + x^3], x, 2, (2/5)*x*Sqrt[1 + x^3] - (4*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(5*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{x^0/Sqrt[1 + x^3], x, 1, (2*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{1/(x^3*Sqrt[1 + x^3]), x, 2, -(Sqrt[1 + x^3]/(2*x^2)) - (Sqrt[2+Sqrt[3]]/3^(1/4)*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(2*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{1/(x^6*Sqrt[1 + x^3]), x, 3, -(Sqrt[1 + x^3]/(5*x^5)) + (7*Sqrt[1 + x^3])/(20*x^2) + (7*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(20*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}

{x^7/Sqrt[1 + x^3], x, 5, (-(20/91))*x^2*Sqrt[1 + x^3] + (2/13)*x^5*Sqrt[1 + x^3] + (80*Sqrt[1 + x^3])/(91*(1 + Sqrt[3] + x)) - (40*3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(91*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3]) + (80*Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(91*3^(1/4)*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{x^4/Sqrt[1 + x^3], x, 4, (2/7)*x^2*Sqrt[1 + x^3] - (8*Sqrt[1 + x^3])/(7*(1 + Sqrt[3] + x)) + (4*3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(7*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3]) - (8*Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(7*3^(1/4)*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{x^1/Sqrt[1 + x^3], x, 3, (2*Sqrt[1 + x^3])/(1 + Sqrt[3] + x) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3]) + (2*Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(3^(1/4)*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{1/(x^2*Sqrt[1 + x^3]), x, 4, -(Sqrt[1 + x^3]/x) + Sqrt[1 + x^3]/(1 + Sqrt[3] + x) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(2*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3]) + (Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(3^(1/4)*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}
{1/(x^5*Sqrt[1 + x^3]), x, 5, -(Sqrt[1 + x^3]/(4*x^4)) + (5*Sqrt[1 + x^3])/(8*x) - (5*Sqrt[1 + x^3])/(8*(1 + Sqrt[3] + x)) + (5*3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(16*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3]) - (5*(1 + x)*Sqrt[(1 - x + x^2)/(1 + Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] + x)/(1 + Sqrt[3] + x)], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*3^(1/4)*Sqrt[(1 + x)/(1 + Sqrt[3] + x)^2]*Sqrt[1 + x^3])}


{x^11/Sqrt[1 - x^3], x, 3, (-(2/3))*Sqrt[1 - x^3] + (2/3)*(1 - x^3)^(3/2) - (2/5)*(1 - x^3)^(5/2) + (2/21)*(1 - x^3)^(7/2)}
{x^8/Sqrt[1 - x^3], x, 3, (-(2/3))*Sqrt[1 - x^3] + (4/9)*(1 - x^3)^(3/2) - (2/15)*(1 - x^3)^(5/2)}
{x^5/Sqrt[1 - x^3], x, 3, (-(2/3))*Sqrt[1 - x^3] + (2/9)*(1 - x^3)^(3/2)}
{x^2/Sqrt[1 - x^3], x, 1, (-(2/3))*Sqrt[1 - x^3]}
{1/(x^1*Sqrt[1 - x^3]), x, 3, (-(2/3))*ArcTanh[Sqrt[1 - x^3]]}
{1/(x^4*Sqrt[1 - x^3]), x, 4, -(Sqrt[1 - x^3]/(3*x^3)) - (1/3)*ArcTanh[Sqrt[1 - x^3]]}
{1/(x^7*Sqrt[1 - x^3]), x, 5, -(Sqrt[1 - x^3]/(6*x^6)) - Sqrt[1 - x^3]/(4*x^3) - (1/4)*ArcTanh[Sqrt[1 - x^3]]}
{1/(x^10*Sqrt[1 - x^3]), x, 6, -(Sqrt[1 - x^3]/(9*x^9)) - (5*Sqrt[1 - x^3])/(36*x^6) - (5*Sqrt[1 - x^3])/(24*x^3) - (5/24)*ArcTanh[Sqrt[1 - x^3]]}

{x^6/Sqrt[1 - x^3], x, 3, (-(16/55))*x*Sqrt[1 - x^3] - (2/11)*x^4*Sqrt[1 - x^3] - (32*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(55*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}
{x^3/Sqrt[1 - x^3], x, 2, (-(2/5))*x*Sqrt[1 - x^3] - (4*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(5*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}
{x^0/Sqrt[1 - x^3], x, 1, -((2*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3]))}
{1/(x^3*Sqrt[1 - x^3]), x, 2, -(Sqrt[1 - x^3]/(2*x^2)) - (Sqrt[2+Sqrt[3]]/3^(1/4)*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(2*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}
{1/(x^6*Sqrt[1 - x^3]), x, 3, -(Sqrt[1 - x^3]/(5*x^5)) - (7*Sqrt[1 - x^3])/(20*x^2) - (7*Sqrt[2+Sqrt[3]]/3^(1/4)*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(20*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}

{x^7/Sqrt[1 - x^3], x, 5, (80*Sqrt[1 - x^3])/(91*(1 + Sqrt[3] - x)) - (20/91)*x^2*Sqrt[1 - x^3] - (2/13)*x^5*Sqrt[1 - x^3] - (40*3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(91*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3]) + (80*Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(91*3^(1/4)*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}
{x^4/Sqrt[1 - x^3], x, 4, (8*Sqrt[1 - x^3])/(7*(1 + Sqrt[3] - x)) - (2/7)*x^2*Sqrt[1 - x^3] - (4*3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(7*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3]) + (8*Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(7*3^(1/4)*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}
{x^1/Sqrt[1 - x^3], x, 3, (2*Sqrt[1 - x^3])/(1 + Sqrt[3] - x) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3]) + (2*Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(3^(1/4)*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}
{1/(x^2*Sqrt[1 - x^3]), x, 4, -(Sqrt[1 - x^3]/(1 + Sqrt[3] - x)) - Sqrt[1 - x^3]/x + (3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(2*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3]) - (Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(3^(1/4)*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}
{1/(x^5*Sqrt[1 - x^3]), x, 5, -((5*Sqrt[1 - x^3])/(8*(1 + Sqrt[3] - x))) - Sqrt[1 - x^3]/(4*x^4) - (5*Sqrt[1 - x^3])/(8*x) + (5*3^(1/4)*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(16*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3]) - (5*(1 - x)*Sqrt[(1 + x + x^2)/(1 + Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 - Sqrt[3] - x)/(1 + Sqrt[3] - x)], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*3^(1/4)*Sqrt[(1 - x)/(1 + Sqrt[3] - x)^2]*Sqrt[1 - x^3])}


{x^11/Sqrt[-1 + x^3], x, 3, (2/3)*Sqrt[-1 + x^3] + (2/3)*(-1 + x^3)^(3/2) + (2/5)*(-1 + x^3)^(5/2) + (2/21)*(-1 + x^3)^(7/2)}
{x^8/Sqrt[-1 + x^3], x, 3, (2/3)*Sqrt[-1 + x^3] + (4/9)*(-1 + x^3)^(3/2) + (2/15)*(-1 + x^3)^(5/2)}
{x^5/Sqrt[-1 + x^3], x, 3, (2/3)*Sqrt[-1 + x^3] + (2/9)*(-1 + x^3)^(3/2)}
{x^2/Sqrt[-1 + x^3], x, 1, (2/3)*Sqrt[-1 + x^3]}
{1/(x^1*Sqrt[-1 + x^3]), x, 3, (2/3)*ArcTan[Sqrt[-1 + x^3]]}
{1/(x^4*Sqrt[-1 + x^3]), x, 4, Sqrt[-1 + x^3]/(3*x^3) + (1/3)*ArcTan[Sqrt[-1 + x^3]]}
{1/(x^7*Sqrt[-1 + x^3]), x, 5, Sqrt[-1 + x^3]/(6*x^6) + Sqrt[-1 + x^3]/(4*x^3) + (1/4)*ArcTan[Sqrt[-1 + x^3]]}
{1/(x^10*Sqrt[-1 + x^3]), x, 6, Sqrt[-1 + x^3]/(9*x^9) + (5*Sqrt[-1 + x^3])/(36*x^6) + (5*Sqrt[-1 + x^3])/(24*x^3) + (5/24)*ArcTan[Sqrt[-1 + x^3]]}

{x^6/Sqrt[-1 + x^3], x, 3, (16/55)*x*Sqrt[-1 + x^3] + (2/11)*x^4*Sqrt[-1 + x^3] - (32*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(55*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}
{x^3/Sqrt[-1 + x^3], x, 2, (2/5)*x*Sqrt[-1 + x^3] - (4*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(5*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}
{x^0/Sqrt[-1 + x^3], x, 1, -((2*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3]))}
{1/(x^3*Sqrt[-1 + x^3]), x, 2, Sqrt[-1 + x^3]/(2*x^2) - (Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(2*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}
{1/(x^6*Sqrt[-1 + x^3]), x, 3, Sqrt[-1 + x^3]/(5*x^5) + (7*Sqrt[-1 + x^3])/(20*x^2) - (7*Sqrt[2 - Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(20*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}

{x^7/Sqrt[-1 + x^3], x, 5, -((80*Sqrt[-1 + x^3])/(91*(1 - Sqrt[3] - x))) + (20/91)*x^2*Sqrt[-1 + x^3] + (2/13)*x^5*Sqrt[-1 + x^3] + (40*3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(91*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3]) - (80*Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(91*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}
{x^4/Sqrt[-1 + x^3], x, 4, -((8*Sqrt[-1 + x^3])/(7*(1 - Sqrt[3] - x))) + (2/7)*x^2*Sqrt[-1 + x^3] + (4*3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(7*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3]) - (8*Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(7*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}
{x^1/Sqrt[-1 + x^3], x, 3, -((2*Sqrt[-1 + x^3])/(1 - Sqrt[3] - x)) + (3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3]) - (2*Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}
{1/(x^2*Sqrt[-1 + x^3]), x, 4, Sqrt[-1 + x^3]/(1 - Sqrt[3] - x) + Sqrt[-1 + x^3]/x - (3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(2*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3]) + (Sqrt[2]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}
{1/(x^5*Sqrt[-1 + x^3]), x, 5, (5*Sqrt[-1 + x^3])/(8*(1 - Sqrt[3] - x)) + Sqrt[-1 + x^3]/(4*x^4) + (5*Sqrt[-1 + x^3])/(8*x) - (5*3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(16*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3]) + (5*(1 - x)*Sqrt[(1 + x + x^2)/(1 - Sqrt[3] - x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] - x)/(1 - Sqrt[3] - x)], -7 + 4*Sqrt[3]])/(4*Sqrt[2]*3^(1/4)*Sqrt[-((1 - x)/(1 - Sqrt[3] - x)^2)]*Sqrt[-1 + x^3])}


{x^11/Sqrt[-1 - x^3], x, 3, (2/3)*Sqrt[-1 - x^3] + (2/3)*(-1 - x^3)^(3/2) + (2/5)*(-1 - x^3)^(5/2) + (2/21)*(-1 - x^3)^(7/2)}
{x^8/Sqrt[-1 - x^3], x, 3, (-(2/3))*Sqrt[-1 - x^3] - (4/9)*(-1 - x^3)^(3/2) - (2/15)*(-1 - x^3)^(5/2)}
{x^5/Sqrt[-1 - x^3], x, 3, (2/3)*Sqrt[-1 - x^3] + (2/9)*(-1 - x^3)^(3/2)}
{x^2/Sqrt[-1 - x^3], x, 1, (-(2/3))*Sqrt[-1 - x^3]}
{1/(x^1*Sqrt[-1 - x^3]), x, 3, (2/3)*ArcTan[Sqrt[-1 - x^3]]}
{1/(x^4*Sqrt[-1 - x^3]), x, 4, Sqrt[-1 - x^3]/(3*x^3) - (1/3)*ArcTan[Sqrt[-1 - x^3]]}
{1/(x^7*Sqrt[-1 - x^3]), x, 5, Sqrt[-1 - x^3]/(6*x^6) - Sqrt[-1 - x^3]/(4*x^3) + (1/4)*ArcTan[Sqrt[-1 - x^3]]}
{1/(x^10*Sqrt[-1 - x^3]), x, 6, Sqrt[-1 - x^3]/(9*x^9) - (5*Sqrt[-1 - x^3])/(36*x^6) + (5*Sqrt[-1 - x^3])/(24*x^3) - (5/24)*ArcTan[Sqrt[-1 - x^3]]}

{x^6/Sqrt[-1 - x^3], x, 3, (16/55)*x*Sqrt[-1 - x^3] - (2/11)*x^4*Sqrt[-1 - x^3] + (32*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(55*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{x^3/Sqrt[-1 - x^3], x, 2, (-(2/5))*x*Sqrt[-1 - x^3] - (4*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(5*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{x^0/Sqrt[-1 - x^3], x, 1, (2*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{1/(x^3*Sqrt[-1 - x^3]), x, 2, Sqrt[-1 - x^3]/(2*x^2) - (Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(2*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{1/(x^6*Sqrt[-1 - x^3]), x, 3, Sqrt[-1 - x^3]/(5*x^5) - (7*Sqrt[-1 - x^3])/(20*x^2) + (7*Sqrt[2 - Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(20*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}

{x^7/Sqrt[-1 - x^3], x, 5, (20/91)*x^2*Sqrt[-1 - x^3] - (2/13)*x^5*Sqrt[-1 - x^3] - (80*Sqrt[-1 - x^3])/(91*(1 - Sqrt[3] + x)) + (40*3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(91*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3]) - (80*Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(91*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{x^4/Sqrt[-1 - x^3], x, 4, (-(2/7))*x^2*Sqrt[-1 - x^3] + (8*Sqrt[-1 - x^3])/(7*(1 - Sqrt[3] + x)) - (4*3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(7*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3]) + (8*Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(7*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{x^1/Sqrt[-1 - x^3], x, 3, -((2*Sqrt[-1 - x^3])/(1 - Sqrt[3] + x)) + (3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3]) - (2*Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{1/(x^2*Sqrt[-1 - x^3]), x, 4, Sqrt[-1 - x^3]/x - Sqrt[-1 - x^3]/(1 - Sqrt[3] + x) + (3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(2*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3]) - (Sqrt[2]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}
{1/(x^5*Sqrt[-1 - x^3]), x, 5, Sqrt[-1 - x^3]/(4*x^4) - (5*Sqrt[-1 - x^3])/(8*x) + (5*Sqrt[-1 - x^3])/(8*(1 - Sqrt[3] + x)) - (5*3^(1/4)*Sqrt[2 + Sqrt[3]]*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticE[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(16*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3]) + (5*(1 + x)*Sqrt[(1 - x + x^2)/(1 - Sqrt[3] + x)^2]*EllipticF[ArcSin[(1 + Sqrt[3] + x)/(1 - Sqrt[3] + x)], -7 + 4*Sqrt[3]])/(4*Sqrt[2]*3^(1/4)*Sqrt[-((1 + x)/(1 - Sqrt[3] + x)^2)]*Sqrt[-1 - x^3])}


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b x^3)^(p/2)*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^3)^(p/3)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^11*(a + b*x^3)^(1/3), x, 3, -((a^3*(a + b*x^3)^(4/3))/(4*b^4)) + (3*a^2*(a + b*x^3)^(7/3))/(7*b^4) - (3*a*(a + b*x^3)^(10/3))/(10*b^4) + (a + b*x^3)^(13/3)/(13*b^4)}
{x^8*(a + b*x^3)^(1/3), x, 3, (a^2*(a + b*x^3)^(4/3))/(4*b^3) - (2*a*(a + b*x^3)^(7/3))/(7*b^3) + (a + b*x^3)^(10/3)/(10*b^3)}
{x^5*(a + b*x^3)^(1/3), x, 3, -((a*(a + b*x^3)^(4/3))/(4*b^2)) + (a + b*x^3)^(7/3)/(7*b^2)}
{x^2*(a + b*x^3)^(1/3), x, 1, (a + b*x^3)^(4/3)/(4*b)}
{(a + b*x^3)^(1/3)/x^1, x, 6, (a + b*x^3)^(1/3) - (a^(1/3)*ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))])/Sqrt[3] - (1/2)*a^(1/3)*Log[x] + (1/2)*a^(1/3)*Log[a^(1/3) - (a + b*x^3)^(1/3)]}
{(a + b*x^3)^(1/3)/x^4, x, 6, -((a + b*x^3)^(1/3)/(3*x^3)) - (b*ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(2/3)) - (b*Log[x])/(6*a^(2/3)) + (b*Log[a^(1/3) - (a + b*x^3)^(1/3)])/(6*a^(2/3))}

{x^4*(a + b*x^3)^(1/3), x, 3, (a*x^2*(a + b*x^3)^(1/3))/(18*b) + (1/6)*x^5*(a + b*x^3)^(1/3) + (a^2*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(9*Sqrt[3]*b^(5/3)) + (a^2*Log[b^(1/3)*x - (a + b*x^3)^(1/3)])/(18*b^(5/3))}
{x^1*(a + b*x^3)^(1/3), x, 2, (1/3)*x^2*(a + b*x^3)^(1/3) - (a*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(3*Sqrt[3]*b^(2/3)) - (a*Log[b^(1/3)*x - (a + b*x^3)^(1/3)])/(6*b^(2/3))}
{(a + b*x^3)^(1/3)/x^2, x, 2, -((a + b*x^3)^(1/3)/x) - (b^(1/3)*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/Sqrt[3] - (1/2)*b^(1/3)*Log[b^(1/3)*x - (a + b*x^3)^(1/3)]}
{(a + b*x^3)^(1/3)/x^5, x, 1, -((a + b*x^3)^(4/3)/(4*a*x^4))}
{(a + b*x^3)^(1/3)/x^8, x, 2, -((a + b*x^3)^(4/3)/(7*a*x^7)) + (3*b*(a + b*x^3)^(4/3))/(28*a^2*x^4)}
{(a + b*x^3)^(1/3)/x^11, x, 3, -((a + b*x^3)^(4/3)/(10*a*x^10)) + (3*b*(a + b*x^3)^(4/3))/(35*a^2*x^7) - (9*b^2*(a + b*x^3)^(4/3))/(140*a^3*x^4)}
{(a + b*x^3)^(1/3)/x^14, x, 4, -((a + b*x^3)^(4/3)/(13*a*x^13)) + (9*b*(a + b*x^3)^(4/3))/(130*a^2*x^10) - (27*b^2*(a + b*x^3)^(4/3))/(455*a^3*x^7) + (81*b^3*(a + b*x^3)^(4/3))/(1820*a^4*x^4)}

{x^3*(a + b*x^3)^(1/3), x, 2, (x^4*(a + b*x^3)^(4/3)*Hypergeometric2F1[1, 8/3, 7/3, -((b*x^3)/a)])/(4*a), (x^4*(a + b*x^3)^(1/3)*Hypergeometric2F1[-(1/3), 4/3, 7/3, -((b*x^3)/a)])/(4*(1 + (b*x^3)/a)^(1/3))}
{x^0*(a + b*x^3)^(1/3), x, 2, (x*(a + b*x^3)^(4/3)*Hypergeometric2F1[1, 5/3, 4/3, -((b*x^3)/a)])/a, (x*(a + b*x^3)^(1/3)*Hypergeometric2F1[-(1/3), 1/3, 4/3, -((b*x^3)/a)])/(1 + (b*x^3)/a)^(1/3)}
{(a + b*x^3)^(1/3)/x^3, x, 2, -(((a + b*x^3)^(4/3)*Hypergeometric2F1[2/3, 1, 1/3, -((b*x^3)/a)])/(2*a*x^2)), -(((a + b*x^3)^(1/3)*Hypergeometric2F1[-(2/3), -(1/3), 1/3, -((b*x^3)/a)])/(2*x^2*(1 + (b*x^3)/a)^(1/3)))}
{(a + b*x^3)^(1/3)/x^6, x, 2, -(((a + b*x^3)^(4/3)*Hypergeometric2F1[-(1/3), 1, -(2/3), -((b*x^3)/a)])/(5*a*x^5)), -(((a + b*x^3)^(1/3)*Hypergeometric2F1[-(5/3), -(1/3), -(2/3), -((b*x^3)/a)])/(5*x^5*(1 + (b*x^3)/a)^(1/3)))}


{x^11*(a + b*x^3)^(2/3), x, 3, -((a^3*(a + b*x^3)^(5/3))/(5*b^4)) + (3*a^2*(a + b*x^3)^(8/3))/(8*b^4) - (3*a*(a + b*x^3)^(11/3))/(11*b^4) + (a + b*x^3)^(14/3)/(14*b^4)}
{x^8*(a + b*x^3)^(2/3), x, 3, (a^2*(a + b*x^3)^(5/3))/(5*b^3) - (a*(a + b*x^3)^(8/3))/(4*b^3) + (a + b*x^3)^(11/3)/(11*b^3)}
{x^5*(a + b*x^3)^(2/3), x, 3, -((a*(a + b*x^3)^(5/3))/(5*b^2)) + (a + b*x^3)^(8/3)/(8*b^2)}
{x^2*(a + b*x^3)^(2/3), x, 1, (a + b*x^3)^(5/3)/(5*b)}
{(a + b*x^3)^(2/3)/x^1, x, 6, (1/2)*(a + b*x^3)^(2/3) + (a^(2/3)*ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))])/Sqrt[3] - (1/2)*a^(2/3)*Log[x] + (1/2)*a^(2/3)*Log[a^(1/3) - (a + b*x^3)^(1/3)]}
{(a + b*x^3)^(2/3)/x^4, x, 6, -((a + b*x^3)^(2/3)/(3*x^3)) + (2*b*ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(1/3)) - (b*Log[x])/(3*a^(1/3)) + (b*Log[a^(1/3) - (a + b*x^3)^(1/3)])/(3*a^(1/3))}

{x^4*(a + b*x^3)^(2/3), x, 2, (x^5*(a + b*x^3)^(5/3)*Hypergeometric2F1[1, 10/3, 8/3, -((b*x^3)/a)])/(5*a), (x^5*(a + b*x^3)^(2/3)*Hypergeometric2F1[-(2/3), 5/3, 8/3, -((b*x^3)/a)])/(5*(1 + (b*x^3)/a)^(2/3))}
{x^1*(a + b*x^3)^(2/3), x, 2, (x^2*(a + b*x^3)^(5/3)*Hypergeometric2F1[1, 7/3, 5/3, -((b*x^3)/a)])/(2*a), (x^2*(a + b*x^3)^(2/3)*Hypergeometric2F1[-(2/3), 2/3, 5/3, -((b*x^3)/a)])/(2*(1 + (b*x^3)/a)^(2/3))}
{(a + b*x^3)^(2/3)/x^2, x, 2, -(((a + b*x^3)^(5/3)*Hypergeometric2F1[1, 4/3, 2/3, -((b*x^3)/a)])/(a*x)), -(((a + b*x^3)^(2/3)*Hypergeometric2F1[-(2/3), -(1/3), 2/3, -((b*x^3)/a)])/(x*(1 + (b*x^3)/a)^(2/3)))}
{(a + b*x^3)^(2/3)/x^5, x, 2, -(((a + b*x^3)^(5/3)*Hypergeometric2F1[1/3, 1, -(1/3), -((b*x^3)/a)])/(4*a*x^4)), -(((a + b*x^3)^(2/3)*Hypergeometric2F1[-(4/3), -(2/3), -(1/3), -((b*x^3)/a)])/(4*x^4*(1 + (b*x^3)/a)^(2/3)))}

{x^3*(a + b*x^3)^(2/3), x, 3, (a*x*(a + b*x^3)^(2/3))/(9*b) + (1/6)*x^4*(a + b*x^3)^(2/3) - (a^2*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(9*Sqrt[3]*b^(4/3)) + (a^2*Log[(-b^(1/3))*x + (a + b*x^3)^(1/3)])/(18*b^(4/3))}
{x^0*(a + b*x^3)^(2/3), x, 2, (1/3)*x*(a + b*x^3)^(2/3) + (2*a*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(3*Sqrt[3]*b^(1/3)) - (a*Log[(-b^(1/3))*x + (a + b*x^3)^(1/3)])/(3*b^(1/3))}
{(a + b*x^3)^(2/3)/x^3, x, 2, -((a + b*x^3)^(2/3)/(2*x^2)) + (b^(2/3)*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/Sqrt[3] - (1/2)*b^(2/3)*Log[(-b^(1/3))*x + (a + b*x^3)^(1/3)]}
{(a + b*x^3)^(2/3)/x^6, x, 1, -((a + b*x^3)^(5/3)/(5*a*x^5))}
{(a + b*x^3)^(2/3)/x^9, x, 2, -((a + b*x^3)^(5/3)/(8*a*x^8)) + (3*b*(a + b*x^3)^(5/3))/(40*a^2*x^5)}
{(a + b*x^3)^(2/3)/x^12, x, 3, -((a + b*x^3)^(5/3)/(11*a*x^11)) + (3*b*(a + b*x^3)^(5/3))/(44*a^2*x^8) - (9*b^2*(a + b*x^3)^(5/3))/(220*a^3*x^5)}


{x^8*(1 - x^3)^(6/5), x, 3, (-(5/33))*(1 - x^3)^(11/5) + (5/24)*(1 - x^3)^(16/5) - (5/63)*(1 - x^3)^(21/5)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^11/(a + b*x^3)^(1/3), x, 3, -((a^3*(a + b*x^3)^(2/3))/(2*b^4)) + (3*a^2*(a + b*x^3)^(5/3))/(5*b^4) - (3*a*(a + b*x^3)^(8/3))/(8*b^4) + (a + b*x^3)^(11/3)/(11*b^4)}
{x^8/(a + b*x^3)^(1/3), x, 3, (a^2*(a + b*x^3)^(2/3))/(2*b^3) - (2*a*(a + b*x^3)^(5/3))/(5*b^3) + (a + b*x^3)^(8/3)/(8*b^3)}
{x^5/(a + b*x^3)^(1/3), x, 3, -((a*(a + b*x^3)^(2/3))/(2*b^2)) + (a + b*x^3)^(5/3)/(5*b^2)}
{x^2/(a + b*x^3)^(1/3), x, 1, (a + b*x^3)^(2/3)/(2*b)}
{1/(x^1*(a + b*x^3)^(1/3)), x, 5, ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)) - Log[x]/(2*a^(1/3)) + Log[a^(1/3) - (a + b*x^3)^(1/3)]/(2*a^(1/3))}
{1/(x^4*(a + b*x^3)^(1/3)), x, 6, -((a + b*x^3)^(2/3)/(3*a*x^3)) - (b*ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(4/3)) + (b*Log[x])/(6*a^(4/3)) - (b*Log[a^(1/3) - (a + b*x^3)^(1/3)])/(6*a^(4/3))}

{x^7/(a + b*x^3)^(1/3), x, 2, (x^8*(a + b*x^3)^(2/3)*Hypergeometric2F1[1, 10/3, 11/3, -((b*x^3)/a)])/(8*a), (x^8*(1 + (b*x^3)/a)^(1/3)*Hypergeometric2F1[1/3, 8/3, 11/3, -((b*x^3)/a)])/(8*(a + b*x^3)^(1/3))}
{x^4/(a + b*x^3)^(1/3), x, 2, (x^5*(a + b*x^3)^(2/3)*Hypergeometric2F1[1, 7/3, 8/3, -((b*x^3)/a)])/(5*a), (x^5*(1 + (b*x^3)/a)^(1/3)*Hypergeometric2F1[1/3, 5/3, 8/3, -((b*x^3)/a)])/(5*(a + b*x^3)^(1/3))}
{x^1/(a + b*x^3)^(1/3), x, 2, (x^2*(a + b*x^3)^(2/3)*Hypergeometric2F1[1, 4/3, 5/3, -((b*x^3)/a)])/(2*a), (x^2*(1 + (b*x^3)/a)^(1/3)*Hypergeometric2F1[1/3, 2/3, 5/3, -((b*x^3)/a)])/(2*(a + b*x^3)^(1/3))}
{1/(x^2*(a + b*x^3)^(1/3)), x, 2, -(((a + b*x^3)^(2/3)*Hypergeometric2F1[1/3, 1, 2/3, -((b*x^3)/a)])/(a*x)), -(((1 + (b*x^3)/a)^(1/3)*Hypergeometric2F1[-(1/3), 1/3, 2/3, -((b*x^3)/a)])/(x*(a + b*x^3)^(1/3)))}
{1/(x^5*(a + b*x^3)^(1/3)), x, 2, -(((a + b*x^3)^(2/3)*Hypergeometric2F1[-(2/3), 1, -(1/3), -((b*x^3)/a)])/(4*a*x^4)), -(((1 + (b*x^3)/a)^(1/3)*Hypergeometric2F1[-(4/3), 1/3, -(1/3), -((b*x^3)/a)])/(4*x^4*(a + b*x^3)^(1/3)))}

{x^3/(a + b*x^3)^(1/3), x, 2, (x*(a + b*x^3)^(2/3))/(3*b) - (a*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(3*Sqrt[3]*b^(4/3)) + (a*Log[(-b^(1/3))*x + (a + b*x^3)^(1/3)])/(6*b^(4/3))}
{x^0/(a + b*x^3)^(1/3), x, 1, ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]]/(Sqrt[3]*b^(1/3)) - Log[(-b^(1/3))*x + (a + b*x^3)^(1/3)]/(2*b^(1/3))}
{1/(x^3*(a + b*x^3)^(1/3)), x, 1, -((a + b*x^3)^(2/3)/(2*a*x^2))}
{1/(x^6*(a + b*x^3)^(1/3)), x, 2, -((a + b*x^3)^(2/3)/(5*a*x^5)) + (3*b*(a + b*x^3)^(2/3))/(10*a^2*x^2)}
{1/(x^9*(a + b*x^3)^(1/3)), x, 3, -((a + b*x^3)^(2/3)/(8*a*x^8)) + (3*b*(a + b*x^3)^(2/3))/(20*a^2*x^5) - (9*b^2*(a + b*x^3)^(2/3))/(40*a^3*x^2)}
{1/(x^12*(a + b*x^3)^(1/3)), x, 4, -((a + b*x^3)^(2/3)/(11*a*x^11)) + (9*b*(a + b*x^3)^(2/3))/(88*a^2*x^8) - (27*b^2*(a + b*x^3)^(2/3))/(220*a^3*x^5) + (81*b^3*(a + b*x^3)^(2/3))/(440*a^4*x^2)}


{x^11/(a + b*x^3)^(2/3), x, 3, -((a^3*(a + b*x^3)^(1/3))/b^4) + (3*a^2*(a + b*x^3)^(4/3))/(4*b^4) - (3*a*(a + b*x^3)^(7/3))/(7*b^4) + (a + b*x^3)^(10/3)/(10*b^4)}
{x^8/(a + b*x^3)^(2/3), x, 3, (a^2*(a + b*x^3)^(1/3))/b^3 - (a*(a + b*x^3)^(4/3))/(2*b^3) + (a + b*x^3)^(7/3)/(7*b^3)}
{x^5/(a + b*x^3)^(2/3), x, 3, -((a*(a + b*x^3)^(1/3))/b^2) + (a + b*x^3)^(4/3)/(4*b^2)}
{x^2/(a + b*x^3)^(2/3), x, 1, (a + b*x^3)^(1/3)/b}
{1/(x^1*(a + b*x^3)^(2/3)), x, 5, -(ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3))) - Log[x]/(2*a^(2/3)) + Log[a^(1/3) - (a + b*x^3)^(1/3)]/(2*a^(2/3))}
{1/(x^4*(a + b*x^3)^(2/3)), x, 6, -((a + b*x^3)^(1/3)/(3*a*x^3)) + (2*b*ArcTan[(a^(1/3) + 2*(a + b*x^3)^(1/3))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(5/3)) + (b*Log[x])/(3*a^(5/3)) - (b*Log[a^(1/3) - (a + b*x^3)^(1/3)])/(3*a^(5/3))}

{x^7/(a + b*x^3)^(2/3), x, 3, -((5*a*x^2*(a + b*x^3)^(1/3))/(18*b^2)) + (x^5*(a + b*x^3)^(1/3))/(6*b) - (5*a^2*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(9*Sqrt[3]*b^(8/3)) - (5*a^2*Log[b^(1/3)*x - (a + b*x^3)^(1/3)])/(18*b^(8/3))}
{x^4/(a + b*x^3)^(2/3), x, 2, (x^2*(a + b*x^3)^(1/3))/(3*b) + (2*a*ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]])/(3*Sqrt[3]*b^(5/3)) + (a*Log[b^(1/3)*x - (a + b*x^3)^(1/3)])/(3*b^(5/3))}
{x^1/(a + b*x^3)^(2/3), x, 1, -(ArcTan[(1 + (2*b^(1/3)*x)/(a + b*x^3)^(1/3))/Sqrt[3]]/(Sqrt[3]*b^(2/3))) - Log[b^(1/3)*x - (a + b*x^3)^(1/3)]/(2*b^(2/3))}
{1/(x^2*(a + b*x^3)^(2/3)), x, 1, -((a + b*x^3)^(1/3)/(a*x))}
{1/(x^5*(a + b*x^3)^(2/3)), x, 2, -((a + b*x^3)^(1/3)/(4*a*x^4)) + (3*b*(a + b*x^3)^(1/3))/(4*a^2*x)}
{1/(x^8*(a + b*x^3)^(2/3)), x, 3, -((a + b*x^3)^(1/3)/(7*a*x^7)) + (3*b*(a + b*x^3)^(1/3))/(14*a^2*x^4) - (9*b^2*(a + b*x^3)^(1/3))/(14*a^3*x)}
{1/(x^11*(a + b*x^3)^(2/3)), x, 4, -((a + b*x^3)^(1/3)/(10*a*x^10)) + (9*b*(a + b*x^3)^(1/3))/(70*a^2*x^7) - (27*b^2*(a + b*x^3)^(1/3))/(140*a^3*x^4) + (81*b^3*(a + b*x^3)^(1/3))/(140*a^4*x)}

{x^6/(a + b*x^3)^(2/3), x, 2, (x^7*(a + b*x^3)^(1/3)*Hypergeometric2F1[1, 8/3, 10/3, -((b*x^3)/a)])/(7*a), (x^7*(1 + (b*x^3)/a)^(2/3)*Hypergeometric2F1[2/3, 7/3, 10/3, -((b*x^3)/a)])/(7*(a + b*x^3)^(2/3))}
{x^3/(a + b*x^3)^(2/3), x, 2, (x^4*(a + b*x^3)^(1/3)*Hypergeometric2F1[1, 5/3, 7/3, -((b*x^3)/a)])/(4*a), (x^4*(1 + (b*x^3)/a)^(2/3)*Hypergeometric2F1[2/3, 4/3, 7/3, -((b*x^3)/a)])/(4*(a + b*x^3)^(2/3))}
{x^0/(a + b*x^3)^(2/3), x, 2, (x*(a + b*x^3)^(1/3)*Hypergeometric2F1[2/3, 1, 4/3, -((b*x^3)/a)])/a, (x*(1 + (b*x^3)/a)^(2/3)*Hypergeometric2F1[1/3, 2/3, 4/3, -((b*x^3)/a)])/(a + b*x^3)^(2/3)}
{1/(x^3*(a + b*x^3)^(2/3)), x, 2, -(((a + b*x^3)^(1/3)*Hypergeometric2F1[-(1/3), 1, 1/3, -((b*x^3)/a)])/(2*a*x^2)), -(((1 + (b*x^3)/a)^(2/3)*Hypergeometric2F1[-(2/3), 2/3, 1/3, -((b*x^3)/a)])/(2*x^2*(a + b*x^3)^(2/3)))}
{1/(x^6*(a + b*x^3)^(2/3)), x, 2, -(((a + b*x^3)^(1/3)*Hypergeometric2F1[-(4/3), 1, -(2/3), -((b*x^3)/a)])/(5*a*x^5)), -(((1 + (b*x^3)/a)^(2/3)*Hypergeometric2F1[-(5/3), 2/3, -(2/3), -((b*x^3)/a)])/(5*x^5*(a + b*x^3)^(2/3)))}


{x^0/(a - b*x^3)^(1/3), x, 1, -(ArcTan[(1 - (2*b^(1/3)*x)/(a - b*x^3)^(1/3))/Sqrt[3]]/(Sqrt[3]*b^(1/3))) + Log[b^(1/3)*x + (a - b*x^3)^(1/3)]/(2*b^(1/3))}

{x^0/(2 + x^3)^(1/3), x, 1, ArcTan[(1 + (2*x)/(2 + x^3)^(1/3))/Sqrt[3]]/Sqrt[3] - (1/2)*Log[-x + (2 + x^3)^(1/3)]}


{x^1/(1 - x^3)^(2/3), x, 1, -(ArcTan[(1 - (2*x)/(1 - x^3)^(1/3))/Sqrt[3]]/Sqrt[3]) - (1/2)*Log[-x - (1 - x^3)^(1/3)]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^3)^(p/4)*)


{x^2/(2 + x^3)^(1/4), x, 1, (4*(2 + x^3)^(3/4))/9}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^3)^p with m symbolic*)


{x^m*(a + b*x^3)^8, x, 2, (a^8*x^(1 + m))/(1 + m) + (8*a^7*b*x^(4 + m))/(4 + m) + (28*a^6*b^2*x^(7 + m))/(7 + m) + (56*a^5*b^3*x^(10 + m))/(10 + m) + (70*a^4*b^4*x^(13 + m))/(13 + m) + (56*a^3*b^5*x^(16 + m))/(16 + m) + (28*a^2*b^6*x^(19 + m))/(19 + m) + (8*a*b^7*x^(22 + m))/(22 + m) + (b^8*x^(25 + m))/(25 + m)}
{x^m*(a + b*x^3)^5, x, 2, (a^5*x^(1 + m))/(1 + m) + (5*a^4*b*x^(4 + m))/(4 + m) + (10*a^3*b^2*x^(7 + m))/(7 + m) + (10*a^2*b^3*x^(10 + m))/(10 + m) + (5*a*b^4*x^(13 + m))/(13 + m) + (b^5*x^(16 + m))/(16 + m)}
{x^m*(a + b*x^3)^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(4 + m))/(4 + m) + (3*a*b^2*x^(7 + m))/(7 + m) + (b^3*x^(10 + m))/(10 + m)}
{x^m*(a + b*x^3)^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(4 + m))/(4 + m) + (b^2*x^(7 + m))/(7 + m)}
{x^m*(a + b*x^3), x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(4 + m))/(4 + m)}
{x^m/(a + b*x^3), x, 1, (x^(1 + m)*Hypergeometric2F1[1, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(a*(1 + m))}
{x^m/(a + b*x^3)^2, x, 1, (x^(1 + m)*Hypergeometric2F1[2, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(a^2*(1 + m))}
{x^m/(a + b*x^3)^3, x, 1, (x^(1 + m)*Hypergeometric2F1[3, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(a^3*(1 + m))}


{x^m*(a + b*x^3)^(3/2), x, 2, (a*x^(1 + m)*Sqrt[a + b*x^3]*Hypergeometric2F1[-(3/2), (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/((1 + m)*Sqrt[1 + (b*x^3)/a])}
{x^m*Sqrt[a + b*x^3], x, 2, (x^(1 + m)*Sqrt[a + b*x^3]*Hypergeometric2F1[-(1/2), (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/((1 + m)*Sqrt[1 + (b*x^3)/a])}
{x^m/Sqrt[a + b*x^3], x, 2, (x^(1 + m)*Sqrt[a + b*x^3]*Hypergeometric2F1[1, (1/6)*(5 + 2*m), (4 + m)/3, -((b*x^3)/a)])/(a*(1 + m)), (x^(1 + m)*Sqrt[1 + (b*x^3)/a]*Hypergeometric2F1[1/2, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/((1 + m)*Sqrt[a + b*x^3])}
{x^m/(a + b*x^3)^(3/2), x, 2, (x^(1 + m)*Sqrt[1 + (b*x^3)/a]*Hypergeometric2F1[3/2, (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(a*(1 + m)*Sqrt[a + b*x^3])}


{(c*x)^m*(a + b*x^3)^(4/3), x, 2, (a*(c*x)^(1 + m)*(a + b*x^3)^(1/3)*Hypergeometric2F1[-(4/3), (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(c*(1 + m)*(1 + (b*x^3)/a)^(1/3))}
{(c*x)^m*(a + b*x^3)^(2/3), x, 2, ((c*x)^(1 + m)*(a + b*c^3*x^3)^(5/3)*Hypergeometric2F1[1, (6 + m)/3, (4 + m)/3, -((b*c^3*x^3)/a)])/(a*c*(1 + m)), ((c*x)^(1 + m)*(a + b*x^3)^(2/3)*Hypergeometric2F1[-(2/3), (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(c*(1 + m)*(1 + (b*x^3)/a)^(2/3))}
{(c*x)^m*(a + b*x^3)^(1/3), x, 2, ((c*x)^(1 + m)*(a + b*c^3*x^3)^(4/3)*Hypergeometric2F1[1, (5 + m)/3, (4 + m)/3, -((b*c^3*x^3)/a)])/(a*c*(1 + m)), ((c*x)^(1 + m)*(a + b*x^3)^(1/3)*Hypergeometric2F1[-(1/3), (1 + m)/3, (4 + m)/3, -((b*x^3)/a)])/(c*(1 + m)*(1 + (b*x^3)/a)^(1/3))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^3)^p with p symbolic*)


{(c*x)^m*(a + b*x^3)^p, x, 2, ((c*x)^(1 + m)*(a + b*x^3)^p*Hypergeometric2F1[(1 + m)/3, -p, (4 + m)/3, -((b*x^3)/a)])/((1 + (b*x^3)/a)^p*(c*(1 + m)))}


{x^2*(a + b*x^3)^p, x, 1, (a + b*x^3)^(1 + p)/(3*b*(1 + p))}
{x^5*(a + b*x^3)^p, x, 3, -((a*(a + b*x^3)^(1 + p))/(3*b^2*(1 + p))) + (a + b*x^3)^(2 + p)/(3*b^2*(2 + p))}
{x^8*(a + b*x^3)^p, x, 3, (a^2*(a + b*x^3)^(1 + p))/(3*b^3*(1 + p)) - (2*a*(a + b*x^3)^(2 + p))/(3*b^3*(2 + p)) + (a + b*x^3)^(3 + p)/(3*b^3*(3 + p))}
{x^11*(a + b*x^3)^p, x, 3, -((a^3*(a + b*x^3)^(1 + p))/(3*b^4*(1 + p))) + (a^2*(a + b*x^3)^(2 + p))/(b^4*(2 + p)) - (a*(a + b*x^3)^(3 + p))/(b^4*(3 + p)) + (a + b*x^3)^(4 + p)/(3*b^4*(4 + p))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^4)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^4)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^m*(a + b*x^4), x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(5 + m))/(5 + m)}

{x^5*(a + b*x^4), x, 2, (a*x^6)/6 + (b*x^10)/10}
{x^4*(a + b*x^4), x, 2, (a*x^5)/5 + (b*x^9)/9}
{x^3*(a + b*x^4), x, 2, (a*x^4)/4 + (b*x^8)/8}
{x^2*(a + b*x^4), x, 2, (a*x^3)/3 + (b*x^7)/7}
{x^1*(a + b*x^4), x, 2, (a*x^2)/2 + (b*x^6)/6}
{x^0*(a + b*x^4), x, 1, a*x + (b*x^5)/5}
{(a + b*x^4)/x^1, x, 2, (b*x^4)/4 + a*Log[x]}
{(a + b*x^4)/x^2, x, 2, -(a/x) + (b*x^3)/3}
{(a + b*x^4)/x^3, x, 2, -(a/(2*x^2)) + (b*x^2)/2}
{(a + b*x^4)/x^4, x, 2, -(a/(3*x^3)) + b*x}
{(a + b*x^4)/x^5, x, 2, -(a/(4*x^4)) + b*Log[x]}
{(a + b*x^4)/x^6, x, 2, -(a/(5*x^5)) - b/x}
{(a + b*x^4)/x^7, x, 2, -(a/(6*x^6)) - b/(2*x^2)}
{(a + b*x^4)/x^8, x, 2, -(a/(7*x^7)) - b/(3*x^3)}
{(a + b*x^4)/x^9, x, 2, -(a/(8*x^8)) - b/(4*x^4)}
{(a + b*x^4)/x^10, x, 2, -(a/(9*x^9)) - b/(5*x^5)}


{x^m*(a + b*x^4)^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(5 + m))/(5 + m) + (b^2*x^(9 + m))/(9 + m)}

{x^5*(a + b*x^4)^2, x, 2, (a^2*x^6)/6 + (1/5)*a*b*x^10 + (b^2*x^14)/14}
{x^4*(a + b*x^4)^2, x, 2, (a^2*x^5)/5 + (2/9)*a*b*x^9 + (b^2*x^13)/13}
{x^3*(a + b*x^4)^2, x, 1, (a + b*x^4)^3/(12*b)}
{x^2*(a + b*x^4)^2, x, 2, (a^2*x^3)/3 + (2/7)*a*b*x^7 + (b^2*x^11)/11}
{x^1*(a + b*x^4)^2, x, 2, (a^2*x^2)/2 + (1/3)*a*b*x^6 + (b^2*x^10)/10}
{x^0*(a + b*x^4)^2, x, 2, a^2*x + (2/5)*a*b*x^5 + (b^2*x^9)/9}
{(a + b*x^4)^2/x^1, x, 3, (1/2)*a*b*x^4 + (b^2*x^8)/8 + a^2*Log[x]}
{(a + b*x^4)^2/x^2, x, 2, -(a^2/x) + (2/3)*a*b*x^3 + (b^2*x^7)/7}
{(a + b*x^4)^2/x^3, x, 2, -(a^2/(2*x^2)) + a*b*x^2 + (b^2*x^6)/6}
{(a + b*x^4)^2/x^4, x, 2, -(a^2/(3*x^3)) + 2*a*b*x + (b^2*x^5)/5}
{(a + b*x^4)^2/x^5, x, 3, -(a^2/(4*x^4)) + (b^2*x^4)/4 + 2*a*b*Log[x]}


{x^m*(a + b*x^4)^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(5 + m))/(5 + m) + (3*a*b^2*x^(9 + m))/(9 + m) + (b^3*x^(13 + m))/(13 + m)}

{x^5*(a + b*x^4)^3, x, 2, (a^3*x^6)/6 + (3/10)*a^2*b*x^10 + (3/14)*a*b^2*x^14 + (b^3*x^18)/18}
{x^4*(a + b*x^4)^3, x, 2, (a^3*x^5)/5 + (1/3)*a^2*b*x^9 + (3/13)*a*b^2*x^13 + (b^3*x^17)/17}
{x^3*(a + b*x^4)^3, x, 1, (a + b*x^4)^4/(16*b)}
{x^2*(a + b*x^4)^3, x, 2, (a^3*x^3)/3 + (3/7)*a^2*b*x^7 + (3/11)*a*b^2*x^11 + (b^3*x^15)/15}
{x^1*(a + b*x^4)^3, x, 2, (a^3*x^2)/2 + (1/2)*a^2*b*x^6 + (3/10)*a*b^2*x^10 + (b^3*x^14)/14}
{x^0*(a + b*x^4)^3, x, 2, a^3*x + (3/5)*a^2*b*x^5 + (1/3)*a*b^2*x^9 + (b^3*x^13)/13}
{(a + b*x^4)^3/x^1, x, 3, (3/4)*a^2*b*x^4 + (3/8)*a*b^2*x^8 + (b^3*x^12)/12 + a^3*Log[x]}
{(a + b*x^4)^3/x^2, x, 2, -(a^3/x) + a^2*b*x^3 + (3/7)*a*b^2*x^7 + (b^3*x^11)/11}
{(a + b*x^4)^3/x^3, x, 2, -(a^3/(2*x^2)) + (3/2)*a^2*b*x^2 + (1/2)*a*b^2*x^6 + (b^3*x^10)/10}
{(a + b*x^4)^3/x^4, x, 2, -(a^3/(3*x^3)) + 3*a^2*b*x + (3/5)*a*b^2*x^5 + (b^3*x^9)/9}
{(a + b*x^4)^3/x^5, x, 3, -(a^3/(4*x^4)) + (3/4)*a*b^2*x^4 + (b^3*x^8)/8 + 3*a^2*b*Log[x]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^9/(a + c*x^4), x, 4, -((a*x^2)/(2*c^2)) + x^6/(6*c) + (a^(3/2)*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(2*c^(5/2))}
{x^7/(a + c*x^4), x, 3, x^4/(4*c) - (a*Log[a + c*x^4])/(4*c^2)}
{x^5/(a + c*x^4), x, 3, x^2/(2*c) - (Sqrt[a]*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(2*c^(3/2))}
{x^3/(a + c*x^4), x, 1, Log[a + c*x^4]/(4*c)}
{x^1/(a + c*x^4), x, 2, ArcTan[(Sqrt[c]*x^2)/Sqrt[a]]/(2*Sqrt[a]*Sqrt[c])}
{1/(x^1*(a + c*x^4)), x, 4, Log[x]/a - Log[a + c*x^4]/(4*a)}
{1/(x^3*(a + c*x^4)), x, 3, -1/(2*a*x^2) - (Sqrt[c]*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(2*a^(3/2))}
{1/(x^5*(a + c*x^4)), x, 3, -1/(4*a*x^4) - (c*Log[x])/a^2 + (c*Log[a + c*x^4])/(4*a^2)}
{1/(x^7*(a + c*x^4)), x, 4, -(1/(6*a*x^6)) + c/(2*a^2*x^2) + (c^(3/2)*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(2*a^(5/2))}

{x^4/(a + c*x^4), x, 10, x/c + (a^(1/4)*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*c^(5/4)) - (a^(1/4)*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*c^(5/4)) + (a^(1/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(4*Sqrt[2]*c^(5/4)) - (a^(1/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(4*Sqrt[2]*c^(5/4))}
{x^2/(a + c*x^4), x, 9, -(ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(2*Sqrt[2]*a^(1/4)*c^(3/4))) + ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(2*Sqrt[2]*a^(1/4)*c^(3/4)) + Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(4*Sqrt[2]*a^(1/4)*c^(3/4)) - Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(4*Sqrt[2]*a^(1/4)*c^(3/4))}
{x^0/(a + c*x^4), x, 9, -(ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(2*Sqrt[2]*a^(3/4)*c^(1/4))) + ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(2*Sqrt[2]*a^(3/4)*c^(1/4)) - Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(4*Sqrt[2]*a^(3/4)*c^(1/4)) + Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(4*Sqrt[2]*a^(3/4)*c^(1/4))}
{1/(x^2*(a + c*x^4)), x, 10, -(1/(a*x)) + (c^(1/4)*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(5/4)) - (c^(1/4)*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(5/4)) - (c^(1/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(4*Sqrt[2]*a^(5/4)) + (c^(1/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(4*Sqrt[2]*a^(5/4))}
{1/(x^4*(a + c*x^4)), x, 10, -(1/(3*a*x^3)) + (c^(3/4)*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(7/4)) - (c^(3/4)*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(2*Sqrt[2]*a^(7/4)) + (c^(3/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(4*Sqrt[2]*a^(7/4)) - (c^(3/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(4*Sqrt[2]*a^(7/4))}


{x^11/(a + c*x^4)^2, x, 3, x^4/(4*c^2) - a^2/(4*c^3*(a + c*x^4)) - (a*Log[a + c*x^4])/(2*c^3)}
{x^9/(a + c*x^4)^2, x, 4, (3*x^2)/(4*c^2) - x^6/(4*c*(a + c*x^4)) - (3*Sqrt[a]*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(4*c^(5/2))}
{x^7/(a + c*x^4)^2, x, 3, a/(4*c^2*(a + c*x^4)) + Log[a + c*x^4]/(4*c^2)}
{x^5/(a + c*x^4)^2, x, 3, -x^2/(4*c*(a + c*x^4)) + ArcTan[(Sqrt[c]*x^2)/Sqrt[a]]/(4*Sqrt[a]*c^(3/2))}
{x^3/(a + c*x^4)^2, x, 1, -1/(4*c*(a + c*x^4))}
{x^1/(a + c*x^4)^2, x, 3, x^2/(4*a*(a + c*x^4)) + ArcTan[(Sqrt[c]*x^2)/Sqrt[a]]/(4*a^(3/2)*Sqrt[c])}
{1/(x^1*(a + c*x^4)^2), x, 3, 1/(4*a*(a + c*x^4)) + Log[x]/a^2 - Log[a + c*x^4]/(4*a^2)}
{1/(x^3*(a + c*x^4)^2), x, 4, -3/(4*a^2*x^2) + 1/(4*a*x^2*(a + c*x^4)) - (3*Sqrt[c]*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(4*a^(5/2))}

{x^6/(a + c*x^4)^2, x, 10, -(x^3/(4*c*(a + c*x^4))) - (3*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(1/4)*c^(7/4)) + (3*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(1/4)*c^(7/4)) + (3*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(1/4)*c^(7/4)) - (3*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(1/4)*c^(7/4))}
{x^4/(a + c*x^4)^2, x, 10, -(x/(4*c*(a + c*x^4))) - ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(8*Sqrt[2]*a^(3/4)*c^(5/4)) + ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(8*Sqrt[2]*a^(3/4)*c^(5/4)) - Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(16*Sqrt[2]*a^(3/4)*c^(5/4)) + Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(16*Sqrt[2]*a^(3/4)*c^(5/4))}
{x^2/(a + c*x^4)^2, x, 10, x^3/(4*a*(a + c*x^4)) - ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(8*Sqrt[2]*a^(5/4)*c^(3/4)) + ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)]/(8*Sqrt[2]*a^(5/4)*c^(3/4)) + Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(16*Sqrt[2]*a^(5/4)*c^(3/4)) - Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2]/(16*Sqrt[2]*a^(5/4)*c^(3/4))}
{x^0/(a + c*x^4)^2, x, 10, x/(4*a*(a + c*x^4)) - (3*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(7/4)*c^(1/4)) + (3*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(7/4)*c^(1/4)) - (3*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(7/4)*c^(1/4)) + (3*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(7/4)*c^(1/4))}
{1/(x^2*(a + c*x^4)^2), x, 11, -(5/(4*a^2*x)) + 1/(4*a*x*(a + c*x^4)) + (5*c^(1/4)*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(9/4)) - (5*c^(1/4)*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(9/4)) - (5*c^(1/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(9/4)) + (5*c^(1/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(9/4))}
{1/(x^4*(a + c*x^4)^2), x, 11, -(7/(12*a^2*x^3)) + 1/(4*a*x^3*(a + c*x^4)) + (7*c^(3/4)*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(11/4)) - (7*c^(3/4)*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(8*Sqrt[2]*a^(11/4)) + (7*c^(3/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(11/4)) - (7*c^(3/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(16*Sqrt[2]*a^(11/4))}


{x^11/(a + c*x^4)^3, x, 3, -(a^2/(8*c^3*(a + c*x^4)^2)) + a/(2*c^3*(a + c*x^4)) + Log[a + c*x^4]/(4*c^3)}
{x^9/(a + c*x^4)^3, x, 4, -x^6/(8*c*(a + c*x^4)^2) - (3*x^2)/(16*c^2*(a + c*x^4)) + (3*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(16*Sqrt[a]*c^(5/2))}
{x^7/(a + c*x^4)^3, x, 1, x^8/(8*a*(a + c*x^4)^2)}
{x^5/(a + c*x^4)^3, x, 4, -x^2/(8*c*(a + c*x^4)^2) + x^2/(16*a*c*(a + c*x^4)) + ArcTan[(Sqrt[c]*x^2)/Sqrt[a]]/(16*a^(3/2)*c^(3/2))}
{x^3/(a + c*x^4)^3, x, 1, -1/(8*c*(a + c*x^4)^2)}
{x^1/(a + c*x^4)^3, x, 4, x^2/(8*a*(a + c*x^4)^2) + (3*x^2)/(16*a^2*(a + c*x^4)) + (3*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(16*a^(5/2)*Sqrt[c])}
{1/(x^1*(a + c*x^4)^3), x, 3, 1/(8*a*(a + c*x^4)^2) + 1/(4*a^2*(a + c*x^4)) + Log[x]/a^3 - Log[a + c*x^4]/(4*a^3)}
{1/(x^3*(a + c*x^4)^3), x, 5, -15/(16*a^3*x^2) + 1/(8*a*x^2*(a + c*x^4)^2) + 5/(16*a^2*x^2*(a + c*x^4)) - (15*Sqrt[c]*ArcTan[(Sqrt[c]*x^2)/Sqrt[a]])/(16*a^(7/2))}

{x^10/(a + c*x^4)^3, x, 11, -(x^7/(8*c*(a + c*x^4)^2)) - (7*x^3)/(32*c^2*(a + c*x^4)) - (21*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(1/4)*c^(11/4)) + (21*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(1/4)*c^(11/4)) + (21*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(1/4)*c^(11/4)) - (21*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(1/4)*c^(11/4))}
{x^8/(a + c*x^4)^3, x, 11, -(x^5/(8*c*(a + c*x^4)^2)) - (5*x)/(32*c^2*(a + c*x^4)) - (5*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(3/4)*c^(9/4)) + (5*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(3/4)*c^(9/4)) - (5*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(3/4)*c^(9/4)) + (5*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(3/4)*c^(9/4))}
{x^6/(a + c*x^4)^3, x, 11, -(x^3/(8*c*(a + c*x^4)^2)) + (3*x^3)/(32*a*c*(a + c*x^4)) - (3*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(5/4)*c^(7/4)) + (3*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(5/4)*c^(7/4)) + (3*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(5/4)*c^(7/4)) - (3*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(5/4)*c^(7/4))}
{x^4/(a + c*x^4)^3, x, 11, -(x/(8*c*(a + c*x^4)^2)) + x/(32*a*c*(a + c*x^4)) - (3*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(7/4)*c^(5/4)) + (3*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(7/4)*c^(5/4)) - (3*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(7/4)*c^(5/4)) + (3*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(7/4)*c^(5/4))}
{x^2/(a + c*x^4)^3, x, 11, x^3/(8*a*(a + c*x^4)^2) + (5*x^3)/(32*a^2*(a + c*x^4)) - (5*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(9/4)*c^(3/4)) + (5*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(9/4)*c^(3/4)) + (5*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(9/4)*c^(3/4)) - (5*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(9/4)*c^(3/4))}
{x^0/(a + c*x^4)^3, x, 11, x/(8*a*(a + c*x^4)^2) + (7*x)/(32*a^2*(a + c*x^4)) - (21*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(11/4)*c^(1/4)) + (21*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(11/4)*c^(1/4)) - (21*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(11/4)*c^(1/4)) + (21*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(11/4)*c^(1/4))}
{1/(x^2*(a + c*x^4)^3), x, 12, -(45/(32*a^3*x)) + 1/(8*a*x*(a + c*x^4)^2) + 9/(32*a^2*x*(a + c*x^4)) + (45*c^(1/4)*ArcTan[1 - (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(13/4)) - (45*c^(1/4)*ArcTan[1 + (Sqrt[2]*c^(1/4)*x)/a^(1/4)])/(64*Sqrt[2]*a^(13/4)) - (45*c^(1/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(13/4)) + (45*c^(1/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*c^(1/4)*x + Sqrt[c]*x^2])/(128*Sqrt[2]*a^(13/4))}


{x^9/(2 + 3*x^4), x, 4, -(x^2/9) + x^6/18 + (1/9)*Sqrt[2/3]*ArcTan[Sqrt[3/2]*x^2]}
{x^7/(2 + 3*x^4), x, 3, x^4/12 - (1/18)*Log[2 + 3*x^4]}
{x^5/(2 + 3*x^4), x, 3, x^2/6 - ArcTan[Sqrt[3/2]*x^2]/(3*Sqrt[6])}
{x^3/(2 + 3*x^4), x, 1, (1/12)*Log[2 + 3*x^4]}
{x^1/(2 + 3*x^4), x, 2, ArcTan[Sqrt[3/2]*x^2]/(2*Sqrt[6])}
{1/(x^1*(2 + 3*x^4)), x, 4, Log[x]/2 - (1/8)*Log[2 + 3*x^4]}
{1/(x^3*(2 + 3*x^4)), x, 3, -(1/(4*x^2)) - (1/4)*Sqrt[3/2]*ArcTan[Sqrt[3/2]*x^2]}

{x^6/(2 + 3*x^4), x, 10, x^3/9 + ArcTan[1 - 6^(1/4)*x]/(3*6^(3/4)) - ArcTan[1 + 6^(1/4)*x]/(3*6^(3/4)) - Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(6*6^(3/4)) + Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(6*6^(3/4))}
{x^4/(2 + 3*x^4), x, 10, x/3 + ArcTan[1 - 6^(1/4)*x]/(6*6^(1/4)) - ArcTan[1 + 6^(1/4)*x]/(6*6^(1/4)) + Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(12*6^(1/4)) - Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(12*6^(1/4))}
{x^2/(2 + 3*x^4), x, 9, -(ArcTan[1 - 6^(1/4)*x]/(2*6^(3/4))) + ArcTan[1 + 6^(1/4)*x]/(2*6^(3/4)) + Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(4*6^(3/4)) - Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(4*6^(3/4))}
{x^0/(2 + 3*x^4), x, 9, -(ArcTan[1 - 6^(1/4)*x]/(4*6^(1/4))) + ArcTan[1 + 6^(1/4)*x]/(4*6^(1/4)) - Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(8*6^(1/4)) + Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(8*6^(1/4))}
{1/(x^2*(2 + 3*x^4)), x, 10, -(1/(2*x)) + (3^(1/4)*ArcTan[1 - 6^(1/4)*x])/(4*2^(3/4)) - (3^(1/4)*ArcTan[1 + 6^(1/4)*x])/(4*2^(3/4)) - (3^(1/4)*Log[Sqrt[6] - 6^(3/4)*x + 3*x^2])/(8*2^(3/4)) + (3^(1/4)*Log[Sqrt[6] + 6^(3/4)*x + 3*x^2])/(8*2^(3/4))}


{x^3/(2 + 3*x^4)^2, x, 1, -(1/(12*(2 + 3*x^4)))}
{x^1/(2 + 3*x^4)^2, x, 3, x^2/(8*(2 + 3*x^4)) + ArcTan[Sqrt[3/2]*x^2]/(8*Sqrt[6])}
{1/(x^1*(2 + 3*x^4)^2), x, 3, 1/(8*(2 + 3*x^4)) + Log[x]/4 - (1/16)*Log[2 + 3*x^4]}
{1/(x^3*(2 + 3*x^4)^2), x, 4, -(3/(16*x^2)) + 1/(8*x^2*(2 + 3*x^4)) - (3/16)*Sqrt[3/2]*ArcTan[Sqrt[3/2]*x^2]}

{x^4/(2 + 3*x^4)^2, x, 10, -(x/(12*(2 + 3*x^4))) - ArcTan[1 - 6^(1/4)*x]/(48*6^(1/4)) + ArcTan[1 + 6^(1/4)*x]/(48*6^(1/4)) - Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(96*6^(1/4)) + Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(96*6^(1/4))}
{x^2/(2 + 3*x^4)^2, x, 10, x^3/(8*(2 + 3*x^4)) - ArcTan[1 - 6^(1/4)*x]/(16*6^(3/4)) + ArcTan[1 + 6^(1/4)*x]/(16*6^(3/4)) + Log[Sqrt[6] - 6^(3/4)*x + 3*x^2]/(32*6^(3/4)) - Log[Sqrt[6] + 6^(3/4)*x + 3*x^2]/(32*6^(3/4))}
{x^0/(2 + 3*x^4)^2, x, 10, x/(8*(2 + 3*x^4)) - (3^(3/4)*ArcTan[1 - 6^(1/4)*x])/(32*2^(1/4)) + (3^(3/4)*ArcTan[1 + 6^(1/4)*x])/(32*2^(1/4)) - (3^(3/4)*Log[Sqrt[6] - 6^(3/4)*x + 3*x^2])/(64*2^(1/4)) + (3^(3/4)*Log[Sqrt[6] + 6^(3/4)*x + 3*x^2])/(64*2^(1/4))}
{1/(x^2*(2 + 3*x^4)^2), x, 11, -(5/(16*x)) + 1/(8*x*(2 + 3*x^4)) + (5*3^(1/4)*ArcTan[1 - 6^(1/4)*x])/(32*2^(3/4)) - (5*3^(1/4)*ArcTan[1 + 6^(1/4)*x])/(32*2^(3/4)) - (5*3^(1/4)*Log[Sqrt[6] - 6^(3/4)*x + 3*x^2])/(64*2^(3/4)) + (5*3^(1/4)*Log[Sqrt[6] + 6^(3/4)*x + 3*x^2])/(64*2^(3/4))}


{x^2/(3 + x^4), x, 9, -(ArcTan[1 - (Sqrt[2]*x)/3^(1/4)]/(2*Sqrt[2]*3^(1/4))) + ArcTan[1 + (Sqrt[2]*x)/3^(1/4)]/(2*Sqrt[2]*3^(1/4)) + Log[Sqrt[3] - Sqrt[2]*3^(1/4)*x + x^2]/(4*Sqrt[2]*3^(1/4)) - Log[Sqrt[3] + Sqrt[2]*3^(1/4)*x + x^2]/(4*Sqrt[2]*3^(1/4))}


{1/(1 + a + (-1 + a)*x^4), x, 3, ArcTan[((1 - a)^(1/4)*x)/(1 + a)^(1/4)]/(2*Sqrt[1 + a]*(1 - a^2)^(1/4)) + ArcTanh[((1 - a)^(1/4)*x)/(1 + a)^(1/4)]/(2*Sqrt[1 + a]*(1 - a^2)^(1/4))}


(* Following pairs of integrands are equal. *)
{1/(2*a + 2*b + x^4), x, 3, -(ArcTan[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(3/4)*(-a - b)^(3/4))) - ArcTanh[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(3/4)*(-a - b)^(3/4))}
{1/(2*(a + b) + x^4), x, 3, -(ArcTan[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(3/4)*(-a - b)^(3/4))) - ArcTanh[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(3/4)*(-a - b)^(3/4))}

{x/(2*a + 2*b + x^4), x, 2, ArcTan[x^2/(Sqrt[2]*Sqrt[a + b])]/(2*Sqrt[2]*Sqrt[a + b])}
{x/(2*(a + b) + x^4), x, 2, ArcTan[x^2/(Sqrt[2]*Sqrt[a + b])]/(2*Sqrt[2]*Sqrt[a + b])}

{x^2/(2*a + 2*b + x^4), x, 3, ArcTan[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(1/4)*(-a - b)^(1/4)) - ArcTanh[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(1/4)*(-a - b)^(1/4))}
{x^2/(2*(a + b) + x^4), x, 3, ArcTan[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(1/4)*(-a - b)^(1/4)) - ArcTanh[x/(2^(1/4)*(-a - b)^(1/4))]/(2*2^(1/4)*(-a - b)^(1/4))}

{x^3/(2*a + 2*b + x^4), x, 1, (1/4)*Log[2*(a + b) + x^4]}
{x^3/(2*(a + b) + x^4), x, 1, (1/4)*Log[2*(a + b) + x^4]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^4)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(5/2)*(a + c*x^4), x, 2, (2*a*x^(7/2))/7 + (2*c*x^(15/2))/15}
{x^(3/2)*(a + c*x^4), x, 2, (2*a*x^(5/2))/5 + (2*c*x^(13/2))/13}
{Sqrt[x]*(a + c*x^4), x, 2, (2*a*x^(3/2))/3 + (2*c*x^(11/2))/11}
{(a + c*x^4)/Sqrt[x], x, 2, 2*a*Sqrt[x] + (2*c*x^(9/2))/9}
{(a + c*x^4)/x^(3/2), x, 2, (-2*a)/Sqrt[x] + (2*c*x^(7/2))/7}
{(a + c*x^4)/x^(5/2), x, 2, (-2*a)/(3*x^(3/2)) + (2*c*x^(5/2))/5}
{(a + c*x^4)/x^(7/2), x, 2, (-2*a)/(5*x^(5/2)) + (2*c*x^(3/2))/3}


{x^(5/2)*(a + c*x^4)^2, x, 2, (2*a^2*x^(7/2))/7 + (4*a*c*x^(15/2))/15 + (2*c^2*x^(23/2))/23}
{x^(3/2)*(a + c*x^4)^2, x, 2, (2*a^2*x^(5/2))/5 + (4*a*c*x^(13/2))/13 + (2*c^2*x^(21/2))/21}
{Sqrt[x]*(a + c*x^4)^2, x, 2, (2*a^2*x^(3/2))/3 + (4*a*c*x^(11/2))/11 + (2*c^2*x^(19/2))/19}
{(a + c*x^4)^2/Sqrt[x], x, 2, 2*a^2*Sqrt[x] + (4*a*c*x^(9/2))/9 + (2*c^2*x^(17/2))/17}
{(a + c*x^4)^2/x^(3/2), x, 2, (-2*a^2)/Sqrt[x] + (4*a*c*x^(7/2))/7 + (2*c^2*x^(15/2))/15}
{(a + c*x^4)^2/x^(5/2), x, 2, (-2*a^2)/(3*x^(3/2)) + (4*a*c*x^(5/2))/5 + (2*c^2*x^(13/2))/13}
{(a + c*x^4)^2/x^(7/2), x, 2, (-2*a^2)/(5*x^(5/2)) + (4*a*c*x^(3/2))/3 + (2*c^2*x^(11/2))/11}


{x^(5/2)*(a + c*x^4)^3, x, 2, (2*a^3*x^(7/2))/7 + (2*a^2*c*x^(15/2))/5 + (6*a*c^2*x^(23/2))/23 + (2*c^3*x^(31/2))/31}
{x^(3/2)*(a + c*x^4)^3, x, 2, (2*a^3*x^(5/2))/5 + (6*a^2*c*x^(13/2))/13 + (2*a*c^2*x^(21/2))/7 + (2*c^3*x^(29/2))/29}
{Sqrt[x]*(a + c*x^4)^3, x, 2, (2*a^3*x^(3/2))/3 + (6*a^2*c*x^(11/2))/11 + (6*a*c^2*x^(19/2))/19 + (2*c^3*x^(27/2))/27}
{(a + c*x^4)^3/Sqrt[x], x, 2, 2*a^3*Sqrt[x] + (2*a^2*c*x^(9/2))/3 + (6*a*c^2*x^(17/2))/17 + (2*c^3*x^(25/2))/25}
{(a + c*x^4)^3/x^(3/2), x, 2, (-2*a^3)/Sqrt[x] + (6*a^2*c*x^(7/2))/7 + (2*a*c^2*x^(15/2))/5 + (2*c^3*x^(23/2))/23}
{(a + c*x^4)^3/x^(5/2), x, 2, (-2*a^3)/(3*x^(3/2)) + (6*a^2*c*x^(5/2))/5 + (6*a*c^2*x^(13/2))/13 + (2*c^3*x^(21/2))/21}
{(a + c*x^4)^3/x^(7/2), x, 2, (-2*a^3)/(5*x^(5/2)) + 2*a^2*c*x^(3/2) + (6*a*c^2*x^(11/2))/11 + (2*c^3*x^(19/2))/19}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(9/2)/(a + c*x^4), x, 15, (2*x^(3/2))/(3*c) + ((-a)^(3/8)*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*c^(11/8)) - ((-a)^(3/8)*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*c^(11/8)) + ((-a)^(3/8)*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*c^(11/8)) - ((-a)^(3/8)*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*c^(11/8)) - ((-a)^(3/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*c^(11/8)) + ((-a)^(3/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*c^(11/8))}
{x^(7/2)/(a + c*x^4), x, 15, (2*Sqrt[x])/c + ((-a)^(1/8)*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*c^(9/8)) - ((-a)^(1/8)*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*c^(9/8)) - ((-a)^(1/8)*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*c^(9/8)) - ((-a)^(1/8)*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*c^(9/8)) + ((-a)^(1/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*c^(9/8)) - ((-a)^(1/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*c^(9/8))}
{x^(5/2)/(a + c*x^4), x, 14, -(ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(1/8)*c^(7/8))) + ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(1/8)*c^(7/8)) + ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(1/8)*c^(7/8)) - ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(1/8)*c^(7/8)) + Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(1/8)*c^(7/8)) - Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(1/8)*c^(7/8))}
{x^(3/2)/(a + c*x^4), x, 14, -(ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(3/8)*c^(5/8))) + ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(3/8)*c^(5/8)) - ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(3/8)*c^(5/8)) - ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(3/8)*c^(5/8)) - Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(3/8)*c^(5/8)) + Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(3/8)*c^(5/8))}
{Sqrt[x]/(a + c*x^4), x, 14, ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(5/8)*c^(3/8)) - ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(5/8)*c^(3/8)) + ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(5/8)*c^(3/8)) - ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(5/8)*c^(3/8)) - Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(5/8)*c^(3/8)) + Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(5/8)*c^(3/8))}
{1/(Sqrt[x]*(a + c*x^4)), x, 14, ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(7/8)*c^(1/8)) - ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*Sqrt[2]*(-a)^(7/8)*c^(1/8)) - ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(7/8)*c^(1/8)) - ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(2*(-a)^(7/8)*c^(1/8)) + Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(7/8)*c^(1/8)) - Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(4*Sqrt[2]*(-a)^(7/8)*c^(1/8))}
{1/(x^(3/2)*(a + c*x^4)), x, 15, -(2/(a*Sqrt[x])) - (c^(1/8)*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*(-a)^(9/8)) + (c^(1/8)*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*(-a)^(9/8)) + (c^(1/8)*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*(-a)^(9/8)) - (c^(1/8)*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*(-a)^(9/8)) + (c^(1/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*(-a)^(9/8)) - (c^(1/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*(-a)^(9/8))}
{1/(x^(5/2)*(a + c*x^4)), x, 15, -(2/(3*a*x^(3/2))) - (c^(3/8)*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*(-a)^(11/8)) + (c^(3/8)*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*Sqrt[2]*(-a)^(11/8)) - (c^(3/8)*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*(-a)^(11/8)) - (c^(3/8)*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(2*(-a)^(11/8)) - (c^(3/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*(-a)^(11/8)) + (c^(3/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(4*Sqrt[2]*(-a)^(11/8))}


{x^(13/2)/(a + c*x^4)^2, x, 15, -(x^(7/2)/(4*c*(a + c*x^4))) - (7*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(1/8)*c^(15/8)) + (7*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(1/8)*c^(15/8)) + (7*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(1/8)*c^(15/8)) - (7*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(1/8)*c^(15/8)) + (7*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(1/8)*c^(15/8)) - (7*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(1/8)*c^(15/8))}
{x^(11/2)/(a + c*x^4)^2, x, 15, -(x^(5/2)/(4*c*(a + c*x^4))) - (5*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(3/8)*c^(13/8)) + (5*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(3/8)*c^(13/8)) - (5*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(3/8)*c^(13/8)) - (5*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(3/8)*c^(13/8)) - (5*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(3/8)*c^(13/8)) + (5*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(3/8)*c^(13/8))}
{x^(9/2)/(a + c*x^4)^2, x, 15, -(x^(3/2)/(4*c*(a + c*x^4))) + (3*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(5/8)*c^(11/8)) - (3*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(5/8)*c^(11/8)) + (3*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(5/8)*c^(11/8)) - (3*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(5/8)*c^(11/8)) - (3*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(5/8)*c^(11/8)) + (3*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(5/8)*c^(11/8))}
{x^(7/2)/(a + c*x^4)^2, x, 15, -(Sqrt[x]/(4*c*(a + c*x^4))) + ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*Sqrt[2]*(-a)^(7/8)*c^(9/8)) - ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*Sqrt[2]*(-a)^(7/8)*c^(9/8)) - ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*(-a)^(7/8)*c^(9/8)) - ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*(-a)^(7/8)*c^(9/8)) + Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(32*Sqrt[2]*(-a)^(7/8)*c^(9/8)) - Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(32*Sqrt[2]*(-a)^(7/8)*c^(9/8))}
{x^(5/2)/(a + c*x^4)^2, x, 15, x^(7/2)/(4*a*(a + c*x^4)) + ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*Sqrt[2]*(-a)^(9/8)*c^(7/8)) - ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*Sqrt[2]*(-a)^(9/8)*c^(7/8)) - ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*(-a)^(9/8)*c^(7/8)) + ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)]/(16*(-a)^(9/8)*c^(7/8)) - Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(32*Sqrt[2]*(-a)^(9/8)*c^(7/8)) + Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x]/(32*Sqrt[2]*(-a)^(9/8)*c^(7/8))}
{x^(3/2)/(a + c*x^4)^2, x, 15, x^(5/2)/(4*a*(a + c*x^4)) + (3*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(11/8)*c^(5/8)) - (3*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(11/8)*c^(5/8)) + (3*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(11/8)*c^(5/8)) + (3*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(11/8)*c^(5/8)) + (3*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(11/8)*c^(5/8)) - (3*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(11/8)*c^(5/8))}
{Sqrt[x]/(a + c*x^4)^2, x, 15, x^(3/2)/(4*a*(a + c*x^4)) - (5*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(13/8)*c^(3/8)) + (5*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(13/8)*c^(3/8)) - (5*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(13/8)*c^(3/8)) + (5*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(13/8)*c^(3/8)) + (5*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(13/8)*c^(3/8)) - (5*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(13/8)*c^(3/8))}
{1/(Sqrt[x]*(a + c*x^4)^2), x, 15, Sqrt[x]/(4*a*(a + c*x^4)) - (7*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(15/8)*c^(1/8)) + (7*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(15/8)*c^(1/8)) + (7*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(15/8)*c^(1/8)) + (7*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(15/8)*c^(1/8)) - (7*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(15/8)*c^(1/8)) + (7*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(15/8)*c^(1/8))}
{1/(x^(3/2)*(a + c*x^4)^2), x, 16, -(9/(4*a^2*Sqrt[x])) + 1/(4*a*Sqrt[x]*(a + c*x^4)) + (9*c^(1/8)*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(17/8)) - (9*c^(1/8)*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*Sqrt[2]*(-a)^(17/8)) - (9*c^(1/8)*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(17/8)) + (9*c^(1/8)*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(16*(-a)^(17/8)) - (9*c^(1/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(17/8)) + (9*c^(1/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(32*Sqrt[2]*(-a)^(17/8))}


{x^(15/2)/(a + c*x^4)^3, x, 16, -(x^(9/2)/(8*c*(a + c*x^4)^2)) - (9*Sqrt[x])/(64*c^2*(a + c*x^4)) + (9*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(7/8)*c^(17/8)) - (9*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(7/8)*c^(17/8)) - (9*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(7/8)*c^(17/8)) - (9*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(7/8)*c^(17/8)) + (9*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(7/8)*c^(17/8)) - (9*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(7/8)*c^(17/8))}
{x^(13/2)/(a + c*x^4)^3, x, 16, -(x^(7/2)/(8*c*(a + c*x^4)^2)) + (7*x^(7/2))/(64*a*c*(a + c*x^4)) + (7*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(9/8)*c^(15/8)) - (7*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(9/8)*c^(15/8)) - (7*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(9/8)*c^(15/8)) + (7*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(9/8)*c^(15/8)) - (7*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(9/8)*c^(15/8)) + (7*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(9/8)*c^(15/8))}
{x^(11/2)/(a + c*x^4)^3, x, 16, -(x^(5/2)/(8*c*(a + c*x^4)^2)) + (5*x^(5/2))/(64*a*c*(a + c*x^4)) + (15*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(11/8)*c^(13/8)) - (15*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(11/8)*c^(13/8)) + (15*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(11/8)*c^(13/8)) + (15*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(11/8)*c^(13/8)) + (15*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(11/8)*c^(13/8)) - (15*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(11/8)*c^(13/8))}
{x^(9/2)/(a + c*x^4)^3, x, 16, -(x^(3/2)/(8*c*(a + c*x^4)^2)) + (3*x^(3/2))/(64*a*c*(a + c*x^4)) - (15*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(13/8)*c^(11/8)) + (15*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(13/8)*c^(11/8)) - (15*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(13/8)*c^(11/8)) + (15*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(13/8)*c^(11/8)) + (15*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(13/8)*c^(11/8)) - (15*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(13/8)*c^(11/8))}
{x^(7/2)/(a + c*x^4)^3, x, 16, -(Sqrt[x]/(8*c*(a + c*x^4)^2)) + Sqrt[x]/(64*a*c*(a + c*x^4)) - (7*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(15/8)*c^(9/8)) + (7*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(15/8)*c^(9/8)) + (7*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(15/8)*c^(9/8)) + (7*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(15/8)*c^(9/8)) - (7*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(15/8)*c^(9/8)) + (7*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(15/8)*c^(9/8))}
{x^(5/2)/(a + c*x^4)^3, x, 16, x^(7/2)/(8*a*(a + c*x^4)^2) + (9*x^(7/2))/(64*a^2*(a + c*x^4)) - (9*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(17/8)*c^(7/8)) + (9*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(17/8)*c^(7/8)) + (9*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(17/8)*c^(7/8)) - (9*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(17/8)*c^(7/8)) + (9*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(17/8)*c^(7/8)) - (9*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(17/8)*c^(7/8))}
{x^(3/2)/(a + c*x^4)^3, x, 16, x^(5/2)/(8*a*(a + c*x^4)^2) + (11*x^(5/2))/(64*a^2*(a + c*x^4)) - (33*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(19/8)*c^(5/8)) + (33*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(19/8)*c^(5/8)) - (33*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(19/8)*c^(5/8)) - (33*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(19/8)*c^(5/8)) - (33*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(19/8)*c^(5/8)) + (33*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(19/8)*c^(5/8))}
{Sqrt[x]/(a + c*x^4)^3, x, 16, x^(3/2)/(8*a*(a + c*x^4)^2) + (13*x^(3/2))/(64*a^2*(a + c*x^4)) + (65*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(21/8)*c^(3/8)) - (65*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(21/8)*c^(3/8)) + (65*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(21/8)*c^(3/8)) - (65*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(21/8)*c^(3/8)) - (65*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(21/8)*c^(3/8)) + (65*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(21/8)*c^(3/8))}
{1/(Sqrt[x]*(a + c*x^4)^3), x, 16, Sqrt[x]/(8*a*(a + c*x^4)^2) + (15*Sqrt[x])/(64*a^2*(a + c*x^4)) + (105*ArcTan[1 - (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(23/8)*c^(1/8)) - (105*ArcTan[1 + (Sqrt[2]*c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*Sqrt[2]*(-a)^(23/8)*c^(1/8)) - (105*ArcTan[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(23/8)*c^(1/8)) - (105*ArcTanh[(c^(1/8)*Sqrt[x])/(-a)^(1/8)])/(256*(-a)^(23/8)*c^(1/8)) + (105*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(23/8)*c^(1/8)) - (105*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*c^(1/8)*Sqrt[x] + c^(1/4)*x])/(512*Sqrt[2]*(-a)^(23/8)*c^(1/8))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^4)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^11*Sqrt[a + c*x^4], x, 3, (a^2*(a + c*x^4)^(3/2))/(6*c^3) - (a*(a + c*x^4)^(5/2))/(5*c^3) + (a + c*x^4)^(7/2)/(14*c^3)}
{x^7*Sqrt[a + c*x^4], x, 3, -(a*(a + c*x^4)^(3/2))/(6*c^2) + (a + c*x^4)^(5/2)/(10*c^2)}
{x^3*Sqrt[a + c*x^4], x, 1, (a + c*x^4)^(3/2)/(6*c)}
{Sqrt[a + c*x^4]/x^1, x, 4, Sqrt[a + c*x^4]/2 - (Sqrt[a]*ArcTanh[Sqrt[a + c*x^4]/Sqrt[a]])/2}
{Sqrt[a + c*x^4]/x^5, x, 4, -Sqrt[a + c*x^4]/(4*x^4) - (c*ArcTanh[Sqrt[a + c*x^4]/Sqrt[a]])/(4*Sqrt[a])}
{Sqrt[a + c*x^4]/x^9, x, 5, -Sqrt[a + c*x^4]/(8*x^8) - (c*Sqrt[a + c*x^4])/(16*a*x^4) + (c^2*ArcTanh[Sqrt[a + c*x^4]/Sqrt[a]])/(16*a^(3/2))}

{x^5*Sqrt[a + c*x^4], x, 5, (a*x^2*Sqrt[a + c*x^4])/(16*c) + (x^6*Sqrt[a + c*x^4])/8 - (a^2*ArcTanh[(Sqrt[c]*x^2)/Sqrt[a + c*x^4]])/(16*c^(3/2))}
{x^1*Sqrt[a + c*x^4], x, 4, (x^2*Sqrt[a + c*x^4])/4 + (a*ArcTanh[(Sqrt[c]*x^2)/Sqrt[a + c*x^4]])/(4*Sqrt[c])}
{Sqrt[a + c*x^4]/x^3, x, 4, -Sqrt[a + c*x^4]/(2*x^2) + (Sqrt[c]*ArcTanh[(Sqrt[c]*x^2)/Sqrt[a + c*x^4]])/2}
{Sqrt[a + c*x^4]/x^7, x, 1, -(a + c*x^4)^(3/2)/(6*a*x^6)}
{Sqrt[a + c*x^4]/x^11, x, 2, -(a + c*x^4)^(3/2)/(10*a*x^10) + (c*(a + c*x^4)^(3/2))/(15*a^2*x^6)}
{Sqrt[a + c*x^4]/x^15, x, 3, -((a + c*x^4)^(3/2)/(14*a*x^14)) + (2*c*(a + c*x^4)^(3/2))/(35*a^2*x^10) - (4*c^2*(a + c*x^4)^(3/2))/(105*a^3*x^6)}

{x^4*Sqrt[a + c*x^4], x, 3, (2*a*x*Sqrt[a + c*x^4])/(21*c) + (1/7)*x^5*Sqrt[a + c*x^4] - (a^(7/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(21*c^(5/4)*Sqrt[a + c*x^4])}
{x^0*Sqrt[a + c*x^4], x, 2, (1/3)*x*Sqrt[a + c*x^4] + (a^(3/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(3*c^(1/4)*Sqrt[a + c*x^4])}
{Sqrt[a + c*x^4]/x^4, x, 2, -(Sqrt[a + c*x^4]/(3*x^3)) + (c^(3/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(3*a^(1/4)*Sqrt[a + c*x^4])}
{Sqrt[a + c*x^4]/x^8, x, 3, -(Sqrt[a + c*x^4]/(7*x^7)) - (2*c*Sqrt[a + c*x^4])/(21*a*x^3) - (c^(7/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(21*a^(5/4)*Sqrt[a + c*x^4])}

{x^2*Sqrt[a + c*x^4], x, 4, (1/5)*x^3*Sqrt[a + c*x^4] + (2*a*x*Sqrt[a + c*x^4])/(5*Sqrt[c]*(Sqrt[a] + Sqrt[c]*x^2)) - (2*a^(5/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticE[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*c^(3/4)*Sqrt[a + c*x^4]) + (a^(5/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*c^(3/4)*Sqrt[a + c*x^4])}
{Sqrt[a + c*x^4]/x^2, x, 4, -(Sqrt[a + c*x^4]/x) + (2*Sqrt[c]*x*Sqrt[a + c*x^4])/(Sqrt[a] + Sqrt[c]*x^2) - (2*a^(1/4)*c^(1/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticE[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/Sqrt[a + c*x^4] + (a^(1/4)*c^(1/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/Sqrt[a + c*x^4]}
{Sqrt[a + c*x^4]/x^6, x, 5, -(Sqrt[a + c*x^4]/(5*x^5)) - (2*c*Sqrt[a + c*x^4])/(5*a*x) + (2*c^(3/2)*x*Sqrt[a + c*x^4])/(5*a*(Sqrt[a] + Sqrt[c]*x^2)) - (2*c^(5/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticE[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*a^(3/4)*Sqrt[a + c*x^4]) + (c^(5/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*a^(3/4)*Sqrt[a + c*x^4])}


{x^11*(a + c*x^4)^(3/2), x, 3, (a^2*(a + c*x^4)^(5/2))/(10*c^3) - (a*(a + c*x^4)^(7/2))/(7*c^3) + (a + c*x^4)^(9/2)/(18*c^3)}
{x^7*(a + c*x^4)^(3/2), x, 3, -(a*(a + c*x^4)^(5/2))/(10*c^2) + (a + c*x^4)^(7/2)/(14*c^2)}
{x^3*(a + c*x^4)^(3/2), x, 1, (a + c*x^4)^(5/2)/(10*c)}
{(a + c*x^4)^(3/2)/x^1, x, 5, (a*Sqrt[a + c*x^4])/2 + (a + c*x^4)^(3/2)/6 - (a^(3/2)*ArcTanh[Sqrt[a + c*x^4]/Sqrt[a]])/2}
{(a + c*x^4)^(3/2)/x^5, x, 5, (3*c*Sqrt[a + c*x^4])/4 - (a + c*x^4)^(3/2)/(4*x^4) - (3*Sqrt[a]*c*ArcTanh[Sqrt[a + c*x^4]/Sqrt[a]])/4}
{(a + c*x^4)^(3/2)/x^9, x, 5, (-3*c*Sqrt[a + c*x^4])/(16*x^4) - (a + c*x^4)^(3/2)/(8*x^8) - (3*c^2*ArcTanh[Sqrt[a + c*x^4]/Sqrt[a]])/(16*Sqrt[a])}

{x^5*(a + c*x^4)^(3/2), x, 6, (a^2*x^2*Sqrt[a + c*x^4])/(32*c) + (a*x^6*Sqrt[a + c*x^4])/16 + (x^6*(a + c*x^4)^(3/2))/12 - (a^3*ArcTanh[(Sqrt[c]*x^2)/Sqrt[a + c*x^4]])/(32*c^(3/2))}
{x^1*(a + c*x^4)^(3/2), x, 5, (3*a*x^2*Sqrt[a + c*x^4])/16 + (x^2*(a + c*x^4)^(3/2))/8 + (3*a^2*ArcTanh[(Sqrt[c]*x^2)/Sqrt[a + c*x^4]])/(16*Sqrt[c])}
{(a + c*x^4)^(3/2)/x^3, x, 5, (3*c*x^2*Sqrt[a + c*x^4])/4 - (a + c*x^4)^(3/2)/(2*x^2) + (3*a*Sqrt[c]*ArcTanh[(Sqrt[c]*x^2)/Sqrt[a + c*x^4]])/4}
{(a + c*x^4)^(3/2)/x^7, x, 5, -(c*Sqrt[a + c*x^4])/(2*x^2) - (a + c*x^4)^(3/2)/(6*x^6) + (c^(3/2)*ArcTanh[(Sqrt[c]*x^2)/Sqrt[a + c*x^4]])/2}
{(a + c*x^4)^(3/2)/x^11, x, 1, -(a + c*x^4)^(5/2)/(10*a*x^10)}
{(a + c*x^4)^(3/2)/x^15, x, 2, -(a + c*x^4)^(5/2)/(14*a*x^14) + (c*(a + c*x^4)^(5/2))/(35*a^2*x^10)}
{(a + c*x^4)^(3/2)/x^19, x, 3, -((a + c*x^4)^(5/2)/(18*a*x^18)) + (2*c*(a + c*x^4)^(5/2))/(63*a^2*x^14) - (4*c^2*(a + c*x^4)^(5/2))/(315*a^3*x^10)}

{x^4*(a + c*x^4)^(3/2), x, 4, (4*a^2*x*Sqrt[a + c*x^4])/(77*c) + (6/77)*a*x^5*Sqrt[a + c*x^4] + (1/11)*x^5*(a + c*x^4)^(3/2) - (2*a^(11/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(77*c^(5/4)*Sqrt[a + c*x^4])}
{x^0*(a + c*x^4)^(3/2), x, 3, (2/7)*a*x*Sqrt[a + c*x^4] + (1/7)*x*(a + c*x^4)^(3/2) + (2*a^(7/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(7*c^(1/4)*Sqrt[a + c*x^4])}
{(a + c*x^4)^(3/2)/x^4, x, 3, (2/3)*c*x*Sqrt[a + c*x^4] - (a + c*x^4)^(3/2)/(3*x^3) + (2*a^(3/4)*c^(3/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(3*Sqrt[a + c*x^4])}
{(a + c*x^4)^(3/2)/x^8, x, 3, -((2*c*Sqrt[a + c*x^4])/(7*x^3)) - (a + c*x^4)^(3/2)/(7*x^7) + (2*c^(7/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(7*a^(1/4)*Sqrt[a + c*x^4])}

{x^2*(a + c*x^4)^(3/2), x, 5, (2/15)*a*x^3*Sqrt[a + c*x^4] + (4*a^2*x*Sqrt[a + c*x^4])/(15*Sqrt[c]*(Sqrt[a] + Sqrt[c]*x^2)) + (1/9)*x^3*(a + c*x^4)^(3/2) - (4*a^(9/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticE[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(15*c^(3/4)*Sqrt[a + c*x^4]) + (2*a^(9/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(15*c^(3/4)*Sqrt[a + c*x^4])}
{(a + c*x^4)^(3/2)/x^2, x, 5, (6/5)*c*x^3*Sqrt[a + c*x^4] + (12*a*Sqrt[c]*x*Sqrt[a + c*x^4])/(5*(Sqrt[a] + Sqrt[c]*x^2)) - (a + c*x^4)^(3/2)/x - (12*a^(5/4)*c^(1/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticE[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*Sqrt[a + c*x^4]) + (6*a^(5/4)*c^(1/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*Sqrt[a + c*x^4])}
{(a + c*x^4)^(3/2)/x^6, x, 5, -((6*c*Sqrt[a + c*x^4])/(5*x)) + (12*c^(3/2)*x*Sqrt[a + c*x^4])/(5*(Sqrt[a] + Sqrt[c]*x^2)) - (a + c*x^4)^(3/2)/(5*x^5) - (12*a^(1/4)*c^(5/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticE[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*Sqrt[a + c*x^4]) + (6*a^(1/4)*c^(5/4)*(Sqrt[a] + Sqrt[c]*x^2)*Sqrt[(a + c*x^4)/(Sqrt[a] + Sqrt[c]*x^2)^2]*EllipticF[2*ArcTan[(c^(1/4)*x)/a^(1/4)], 1/2])/(5*Sqrt[a + c*x^4])}


{(1 + x^4)^(3/2), x, 3, (2/7)*x*Sqrt[1 + x^4] + (1/7)*x*(1 + x^4)^(3/2) + (2*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(7*Sqrt[1 + x^4])}
{(1 - x^4)^(3/2), x, 3, (2/7)*x*Sqrt[1 - x^4] + (1/7)*x*(1 - x^4)^(3/2) + (4/7)*EllipticF[ArcSin[x], -1]}


{x^7*Sqrt[5 + 3*x^4], x, 3, (-(5/54))*(5 + 3*x^4)^(3/2) + (1/90)*(5 + 3*x^4)^(5/2)}
{x^3*Sqrt[5 + x^4], x, 1, (1/6)*(5 + x^4)^(3/2)}
{x*Sqrt[3 + 2*x^4], x, 3, (1/4)*x^2*Sqrt[3 + 2*x^4] + (3*ArcSinh[Sqrt[2/3]*x^2])/(4*Sqrt[2])}
{x*Sqrt[-2 + x^4], x, 4, (1/4)*x^2*Sqrt[-2 + x^4] - (1/2)*ArcTanh[x^2/Sqrt[-2 + x^4]]}
{(1 + x^4)^(1/2), x, 2, (1/3)*x*Sqrt[1 + x^4] + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(3*Sqrt[1 + x^4])}
{(1 - x^4)^(1/2), x, 2, (1/3)*x*Sqrt[1 - x^4] + (2/3)*EllipticF[ArcSin[x], -1]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^11/Sqrt[a + b*x^4], x, 3, (a^2*Sqrt[a + b*x^4])/(2*b^3) - (a*(a + b*x^4)^(3/2))/(3*b^3) + (a + b*x^4)^(5/2)/(10*b^3)}
{x^7/Sqrt[a + b*x^4], x, 3, -((a*Sqrt[a + b*x^4])/(2*b^2)) + (a + b*x^4)^(3/2)/(6*b^2)}
{x^3/Sqrt[a + b*x^4], x, 1, Sqrt[a + b*x^4]/(2*b)}
{1/(x^1*Sqrt[a + b*x^4]), x, 3, -ArcTanh[Sqrt[a + b*x^4]/Sqrt[a]]/(2*Sqrt[a])}
{1/(x^5*Sqrt[a + b*x^4]), x, 4, -Sqrt[a + b*x^4]/(4*a*x^4) + (b*ArcTanh[Sqrt[a + b*x^4]/Sqrt[a]])/(4*a^(3/2))}

{x^5/Sqrt[a + b*x^4], x, 4, (x^2*Sqrt[a + b*x^4])/(4*b) - (a*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a + b*x^4]])/(4*b^(3/2))}
{x^1/Sqrt[a + b*x^4], x, 3, ArcTanh[(Sqrt[b]*x^2)/Sqrt[a + b*x^4]]/(2*Sqrt[b])}
{1/(x^3*Sqrt[a + b*x^4]), x, 1, -Sqrt[a + b*x^4]/(2*a*x^2)}
{1/(x^7*Sqrt[a + b*x^4]), x, 2, -Sqrt[a + b*x^4]/(6*a*x^6) + (b*Sqrt[a + b*x^4])/(3*a^2*x^2)}
{1/(x^11*Sqrt[a + b*x^4]), x, 3, -(Sqrt[a + b*x^4]/(10*a*x^10)) + (2*b*Sqrt[a + b*x^4])/(15*a^2*x^6) - (4*b^2*Sqrt[a + b*x^4])/(15*a^3*x^2)}

{x^8/Sqrt[a + b*x^4], x, 3, -((5*a*x*Sqrt[a + b*x^4])/(21*b^2)) + (x^5*Sqrt[a + b*x^4])/(7*b) + (5*a^(7/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(42*b^(9/4)*Sqrt[a + b*x^4])}
{x^4/Sqrt[a + b*x^4], x, 2, (x*Sqrt[a + b*x^4])/(3*b) - (a^(3/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(6*b^(5/4)*Sqrt[a + b*x^4])}
{x^0/Sqrt[a + b*x^4], x, 1, ((Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(2*a^(1/4)*b^(1/4)*Sqrt[a + b*x^4])}
{1/(x^4*Sqrt[a + b*x^4]), x, 2, -(Sqrt[a + b*x^4]/(3*a*x^3)) - (b^(3/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(6*a^(5/4)*Sqrt[a + b*x^4])}
{1/(x^8*Sqrt[a + b*x^4]), x, 3, -(Sqrt[a + b*x^4]/(7*a*x^7)) + (5*b*Sqrt[a + b*x^4])/(21*a^2*x^3) + (5*b^(7/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(42*a^(9/4)*Sqrt[a + b*x^4])}

{x^10/Sqrt[a + b*x^4], x, 5, -((7*a*x^3*Sqrt[a + b*x^4])/(45*b^2)) + (x^7*Sqrt[a + b*x^4])/(9*b) + (7*a^2*x*Sqrt[a + b*x^4])/(15*b^(5/2)*(Sqrt[a] + Sqrt[b]*x^2)) - (7*a^(9/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(15*b^(11/4)*Sqrt[a + b*x^4]) + (7*a^(9/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(30*b^(11/4)*Sqrt[a + b*x^4])}
{x^6/Sqrt[a + b*x^4], x, 4, (x^3*Sqrt[a + b*x^4])/(5*b) - (3*a*x*Sqrt[a + b*x^4])/(5*b^(3/2)*(Sqrt[a] + Sqrt[b]*x^2)) + (3*a^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(5*b^(7/4)*Sqrt[a + b*x^4]) - (3*a^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(10*b^(7/4)*Sqrt[a + b*x^4])}
{x^2/Sqrt[a + b*x^4], x, 3, (x*Sqrt[a + b*x^4])/(Sqrt[b]*(Sqrt[a] + Sqrt[b]*x^2)) - (a^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(b^(3/4)*Sqrt[a + b*x^4]) + (a^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(2*b^(3/4)*Sqrt[a + b*x^4])}
{1/(x^2*Sqrt[a + b*x^4]), x, 4, -(Sqrt[a + b*x^4]/(a*x)) + (Sqrt[b]*x*Sqrt[a + b*x^4])/(a*(Sqrt[a] + Sqrt[b]*x^2)) - (b^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(a^(3/4)*Sqrt[a + b*x^4]) + (b^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(2*a^(3/4)*Sqrt[a + b*x^4])}
{1/(x^6*Sqrt[a + b*x^4]), x, 5, -(Sqrt[a + b*x^4]/(5*a*x^5)) + (3*b*Sqrt[a + b*x^4])/(5*a^2*x) - (3*b^(3/2)*x*Sqrt[a + b*x^4])/(5*a^2*(Sqrt[a] + Sqrt[b]*x^2)) + (3*b^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(5*a^(7/4)*Sqrt[a + b*x^4]) - (3*b^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(10*a^(7/4)*Sqrt[a + b*x^4])}


{x^11/Sqrt[a - b*x^4], x, 3, -((a^2*Sqrt[a - b*x^4])/(2*b^3)) + (a*(a - b*x^4)^(3/2))/(3*b^3) - (a - b*x^4)^(5/2)/(10*b^3)}
{x^7/Sqrt[a - b*x^4], x, 3, -((a*Sqrt[a - b*x^4])/(2*b^2)) + (a - b*x^4)^(3/2)/(6*b^2)}
{x^3/Sqrt[a - b*x^4], x, 1, -(Sqrt[a - b*x^4]/(2*b))}
{1/(x^1*Sqrt[a - b*x^4]), x, 3, -ArcTanh[Sqrt[a - b*x^4]/Sqrt[a]]/(2*Sqrt[a])}
{1/(x^5*Sqrt[a - b*x^4]), x, 4, -(Sqrt[a - b*x^4]/(4*a*x^4)) - (b*ArcTanh[Sqrt[a - b*x^4]/Sqrt[a]])/(4*a^(3/2))}

{x^5/Sqrt[a - b*x^4], x, 4, -((x^2*Sqrt[a - b*x^4])/(4*b)) + (a*ArcTan[(Sqrt[b]*x^2)/Sqrt[a - b*x^4]])/(4*b^(3/2))}
{x^1/Sqrt[a - b*x^4], x, 3, ArcTan[(Sqrt[b]*x^2)/Sqrt[a - b*x^4]]/(2*Sqrt[b])}
{1/(x^3*Sqrt[a - b*x^4]), x, 1, -Sqrt[a - b*x^4]/(2*a*x^2)}
{1/(x^7*Sqrt[a - b*x^4]), x, 2, -(Sqrt[a - b*x^4]/(6*a*x^6)) - (b*Sqrt[a - b*x^4])/(3*a^2*x^2)}
{1/(x^11*Sqrt[a - b*x^4]), x, 3, -(Sqrt[a - b*x^4]/(10*a*x^10)) - (2*b*Sqrt[a - b*x^4])/(15*a^2*x^6) - (4*b^2*Sqrt[a - b*x^4])/(15*a^3*x^2)}

{x^8/Sqrt[a - b*x^4], x, 4, -((5*a*x*Sqrt[a - b*x^4])/(21*b^2)) - (x^5*Sqrt[a - b*x^4])/(7*b) + (5*a^(9/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(21*b^(9/4)*Sqrt[a - b*x^4])}
{x^4/Sqrt[a - b*x^4], x, 3, -((x*Sqrt[a - b*x^4])/(3*b)) + (a^(5/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(3*b^(5/4)*Sqrt[a - b*x^4])}
{x^0/Sqrt[a - b*x^4], x, 2, (a^(1/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(b^(1/4)*Sqrt[a - b*x^4])}
{1/(x^4*Sqrt[a - b*x^4]), x, 3, -(Sqrt[a - b*x^4]/(3*a*x^3)) + (b^(3/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(3*a^(3/4)*Sqrt[a - b*x^4])}
{1/(x^8*Sqrt[a - b*x^4]), x, 4, -(Sqrt[a - b*x^4]/(7*a*x^7)) - (5*b*Sqrt[a - b*x^4])/(21*a^2*x^3) + (5*b^(7/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(21*a^(7/4)*Sqrt[a - b*x^4])}

{x^10/Sqrt[a - b*x^4], x, 8, -((7*a*x^3*Sqrt[a - b*x^4])/(45*b^2)) - (x^7*Sqrt[a - b*x^4])/(9*b) + (7*a^(11/4)*Sqrt[1 - (b*x^4)/a]*EllipticE[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(15*b^(11/4)*Sqrt[a - b*x^4]) - (7*a^(11/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(15*b^(11/4)*Sqrt[a - b*x^4])}
{x^6/Sqrt[a - b*x^4], x, 7, -((x^3*Sqrt[a - b*x^4])/(5*b)) + (3*a^(7/4)*Sqrt[1 - (b*x^4)/a]*EllipticE[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(5*b^(7/4)*Sqrt[a - b*x^4]) - (3*a^(7/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(5*b^(7/4)*Sqrt[a - b*x^4])}
{x^2/Sqrt[a - b*x^4], x, 6, (a^(3/4)*Sqrt[1 - (b*x^4)/a]*EllipticE[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(b^(3/4)*Sqrt[a - b*x^4]) - (a^(3/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(b^(3/4)*Sqrt[a - b*x^4])}
{1/(x^2*Sqrt[a - b*x^4]), x, 7, -(Sqrt[a - b*x^4]/(a*x)) - (b^(1/4)*Sqrt[1 - (b*x^4)/a]*EllipticE[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(a^(1/4)*Sqrt[a - b*x^4]) + (b^(1/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(a^(1/4)*Sqrt[a - b*x^4])}
{1/(x^6*Sqrt[a - b*x^4]), x, 8, -(Sqrt[a - b*x^4]/(5*a*x^5)) - (3*b*Sqrt[a - b*x^4])/(5*a^2*x) - (3*b^(5/4)*Sqrt[1 - (b*x^4)/a]*EllipticE[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(5*a^(5/4)*Sqrt[a - b*x^4]) + (3*b^(5/4)*Sqrt[1 - (b*x^4)/a]*EllipticF[ArcSin[(b^(1/4)*x)/a^(1/4)], -1])/(5*a^(5/4)*Sqrt[a - b*x^4])}


{x^11/(a + b*x^4)^(3/2), x, 3, -(a^2/(2*b^3*Sqrt[a + b*x^4])) - (a*Sqrt[a + b*x^4])/b^3 + (a + b*x^4)^(3/2)/(6*b^3)}
{x^7/(a + b*x^4)^(3/2), x, 3, a/(2*b^2*Sqrt[a + b*x^4]) + Sqrt[a + b*x^4]/(2*b^2)}
{x^3/(a + b*x^4)^(3/2), x, 1, -1/(2*b*Sqrt[a + b*x^4])}
{1/(x^1*(a + b*x^4)^(3/2)), x, 4, 1/(2*a*Sqrt[a + b*x^4]) - ArcTanh[Sqrt[a + b*x^4]/Sqrt[a]]/(2*a^(3/2))}
{1/(x^5*(a + b*x^4)^(3/2)), x, 5, -((3*b)/(4*a^2*Sqrt[a + b*x^4])) - 1/(4*a*x^4*Sqrt[a + b*x^4]) + (3*b*ArcTanh[Sqrt[a + b*x^4]/Sqrt[a]])/(4*a^(5/2))}

{x^9/(a + b*x^4)^(3/2), x, 5, -x^6/(2*b*Sqrt[a + b*x^4]) + (3*x^2*Sqrt[a + b*x^4])/(4*b^2) - (3*a*ArcTanh[(Sqrt[b]*x^2)/Sqrt[a + b*x^4]])/(4*b^(5/2))}
{x^5/(a + b*x^4)^(3/2), x, 4, -x^2/(2*b*Sqrt[a + b*x^4]) + ArcTanh[(Sqrt[b]*x^2)/Sqrt[a + b*x^4]]/(2*b^(3/2))}
{x^1/(a + b*x^4)^(3/2), x, 1, x^2/(2*a*Sqrt[a + b*x^4])}
{1/(x^3*(a + b*x^4)^(3/2)), x, 2, -(1/(2*a*x^2*Sqrt[a + b*x^4])) - (b*x^2)/(a^2*Sqrt[a + b*x^4])}
{1/(x^7*(a + b*x^4)^(3/2)), x, 3, -(1/(6*a*x^6*Sqrt[a + b*x^4])) + (2*b)/(3*a^2*x^2*Sqrt[a + b*x^4]) + (4*b^2*x^2)/(3*a^3*Sqrt[a + b*x^4])}

{x^12/(a + b*x^4)^(3/2), x, 4, -(x^9/(2*b*Sqrt[a + b*x^4])) - (15*a*x*Sqrt[a + b*x^4])/(14*b^3) + (9*x^5*Sqrt[a + b*x^4])/(14*b^2) + (15*a^(7/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(28*b^(13/4)*Sqrt[a + b*x^4])}
{x^8/(a + b*x^4)^(3/2), x, 3, -(x^5/(2*b*Sqrt[a + b*x^4])) + (5*x*Sqrt[a + b*x^4])/(6*b^2) - (5*a^(3/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(12*b^(9/4)*Sqrt[a + b*x^4])}
{x^4/(a + b*x^4)^(3/2), x, 2, -(x/(2*b*Sqrt[a + b*x^4])) + ((Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(4*a^(1/4)*b^(5/4)*Sqrt[a + b*x^4])}
{x^0/(a + b*x^4)^(3/2), x, 2, x/(2*a*Sqrt[a + b*x^4]) + ((Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(4*a^(5/4)*b^(1/4)*Sqrt[a + b*x^4])}
{1/(x^4*(a + b*x^4)^(3/2)), x, 3, 1/(2*a*x^3*Sqrt[a + b*x^4]) - (5*Sqrt[a + b*x^4])/(6*a^2*x^3) - (5*b^(3/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(12*a^(9/4)*Sqrt[a + b*x^4])}
{1/(x^8*(a + b*x^4)^(3/2)), x, 4, 1/(2*a*x^7*Sqrt[a + b*x^4]) - (9*Sqrt[a + b*x^4])/(14*a^2*x^7) + (15*b*Sqrt[a + b*x^4])/(14*a^3*x^3) + (15*b^(7/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(28*a^(13/4)*Sqrt[a + b*x^4])}

{x^14/(a + b*x^4)^(3/2), x, 6, -(x^11/(2*b*Sqrt[a + b*x^4])) - (77*a*x^3*Sqrt[a + b*x^4])/(90*b^3) + (11*x^7*Sqrt[a + b*x^4])/(18*b^2) + (77*a^2*x*Sqrt[a + b*x^4])/(30*b^(7/2)*(Sqrt[a] + Sqrt[b]*x^2)) - (77*a^(9/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(30*b^(15/4)*Sqrt[a + b*x^4]) + (77*a^(9/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(60*b^(15/4)*Sqrt[a + b*x^4])}
{x^10/(a + b*x^4)^(3/2), x, 5, -(x^7/(2*b*Sqrt[a + b*x^4])) + (7*x^3*Sqrt[a + b*x^4])/(10*b^2) - (21*a*x*Sqrt[a + b*x^4])/(10*b^(5/2)*(Sqrt[a] + Sqrt[b]*x^2)) + (21*a^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(10*b^(11/4)*Sqrt[a + b*x^4]) - (21*a^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(20*b^(11/4)*Sqrt[a + b*x^4])}
{x^6/(a + b*x^4)^(3/2), x, 4, -(x^3/(2*b*Sqrt[a + b*x^4])) + (3*x*Sqrt[a + b*x^4])/(2*b^(3/2)*(Sqrt[a] + Sqrt[b]*x^2)) - (3*a^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(2*b^(7/4)*Sqrt[a + b*x^4]) + (3*a^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(4*b^(7/4)*Sqrt[a + b*x^4])}
{x^2/(a + b*x^4)^(3/2), x, 4, x^3/(2*a*Sqrt[a + b*x^4]) - (x*Sqrt[a + b*x^4])/(2*a*Sqrt[b]*(Sqrt[a] + Sqrt[b]*x^2)) + ((Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(2*a^(3/4)*b^(3/4)*Sqrt[a + b*x^4]) - ((Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(4*a^(3/4)*b^(3/4)*Sqrt[a + b*x^4])}
{1/(x^2*(a + b*x^4)^(3/2)), x, 5, 1/(2*a*x*Sqrt[a + b*x^4]) - (3*Sqrt[a + b*x^4])/(2*a^2*x) + (3*Sqrt[b]*x*Sqrt[a + b*x^4])/(2*a^2*(Sqrt[a] + Sqrt[b]*x^2)) - (3*b^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(2*a^(7/4)*Sqrt[a + b*x^4]) + (3*b^(1/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(4*a^(7/4)*Sqrt[a + b*x^4])}
{1/(x^6*(a + b*x^4)^(3/2)), x, 6, 1/(2*a*x^5*Sqrt[a + b*x^4]) - (7*Sqrt[a + b*x^4])/(10*a^2*x^5) + (21*b*Sqrt[a + b*x^4])/(10*a^3*x) - (21*b^(3/2)*x*Sqrt[a + b*x^4])/(10*a^3*(Sqrt[a] + Sqrt[b]*x^2)) + (21*b^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticE[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(10*a^(11/4)*Sqrt[a + b*x^4]) - (21*b^(5/4)*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(20*a^(11/4)*Sqrt[a + b*x^4])}


{1/(a + b*x^4)^(5/2), x, 3, x/(6*a*(a + b*x^4)^(3/2)) + (5*x)/(12*a^2*Sqrt[a + b*x^4]) + (5*(Sqrt[a] + Sqrt[b]*x^2)*Sqrt[(a + b*x^4)/(Sqrt[a] + Sqrt[b]*x^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*x)/a^(1/4)], 1/2])/(24*a^(9/4)*b^(1/4)*Sqrt[a + b*x^4])}


{x^11/Sqrt[1 - x^4], x, 3, -Sqrt[1 - x^4]/2 + (1 - x^4)^(3/2)/3 - (1 - x^4)^(5/2)/10}
{x^7/Sqrt[1 - x^4], x, 3, -Sqrt[1 - x^4]/2 + (1 - x^4)^(3/2)/6}
{x^3/Sqrt[1 - x^4], x, 1, -Sqrt[1 - x^4]/2}
{1/(x^1*Sqrt[1 - x^4]), x, 3, -ArcTanh[Sqrt[1 - x^4]]/2}
{1/(x^5*Sqrt[1 - x^4]), x, 4, -Sqrt[1 - x^4]/(4*x^4) - ArcTanh[Sqrt[1 - x^4]]/4}

{x^5/Sqrt[1 - x^4], x, 3, -(x^2*Sqrt[1 - x^4])/4 + ArcSin[x^2]/4}
{x^1/Sqrt[1 - x^4], x, 2, ArcSin[x^2]/2}
{1/(x^3*Sqrt[1 - x^4]), x, 1, -Sqrt[1 - x^4]/(2*x^2)}
{1/(x^7*Sqrt[1 - x^4]), x, 2, -Sqrt[1 - x^4]/(6*x^6) - Sqrt[1 - x^4]/(3*x^2)}
{1/(x^11*Sqrt[1 - x^4]), x, 3, -Sqrt[1 - x^4]/(10*x^10) - (2*Sqrt[1 - x^4])/(15*x^6) - (4*Sqrt[1 - x^4])/(15*x^2)}

{x^8/Sqrt[1 - x^4], x, 3, (-5*x*Sqrt[1 - x^4])/21 - (x^5*Sqrt[1 - x^4])/7 + (5*EllipticF[ArcSin[x], -1])/21}
{x^4/Sqrt[1 - x^4], x, 2, -(x*Sqrt[1 - x^4])/3 + EllipticF[ArcSin[x], -1]/3}
{x^0/Sqrt[1 - x^4], x, 1, EllipticF[ArcSin[x], -1]}
{1/(x^4*Sqrt[1 - x^4]), x, 2, -Sqrt[1 - x^4]/(3*x^3) + EllipticF[ArcSin[x], -1]/3}
{1/(x^8*Sqrt[1 - x^4]), x, 3, -Sqrt[1 - x^4]/(7*x^7) - (5*Sqrt[1 - x^4])/(21*x^3) + (5*EllipticF[ArcSin[x], -1])/21}

{x^10/Sqrt[1 - x^4], x, 6, (-7*x^3*Sqrt[1 - x^4])/45 - (x^7*Sqrt[1 - x^4])/9 + (7*EllipticE[ArcSin[x], -1])/15 - (7*EllipticF[ArcSin[x], -1])/15}
{x^6/Sqrt[1 - x^4], x, 5, -(x^3*Sqrt[1 - x^4])/5 + (3*EllipticE[ArcSin[x], -1])/5 - (3*EllipticF[ArcSin[x], -1])/5}
{x^2/Sqrt[1 - x^4], x, 4, EllipticE[ArcSin[x], -1] - EllipticF[ArcSin[x], -1]}
{1/(x^2*Sqrt[1 - x^4]), x, 5, -(Sqrt[1 - x^4]/x) - EllipticE[ArcSin[x], -1] + EllipticF[ArcSin[x], -1]}
{1/(x^6*Sqrt[1 - x^4]), x, 6, -Sqrt[1 - x^4]/(5*x^5) - (3*Sqrt[1 - x^4])/(5*x) - (3*EllipticE[ArcSin[x], -1])/5 + (3*EllipticF[ArcSin[x], -1])/5}


{x^11/(1 - x^4)^(3/2), x, 3, 1/(2*Sqrt[1 - x^4]) + Sqrt[1 - x^4] - (1 - x^4)^(3/2)/6}
{x^7/(1 - x^4)^(3/2), x, 3, 1/(2*Sqrt[1 - x^4]) + Sqrt[1 - x^4]/2}
{x^3/(1 - x^4)^(3/2), x, 1, 1/(2*Sqrt[1 - x^4])}
{1/(x^1*(1 - x^4)^(3/2)), x, 4, 1/(2*Sqrt[1 - x^4]) - ArcTanh[Sqrt[1 - x^4]]/2}
{1/(x^5*(1 - x^4)^(3/2)), x, 5, 3/(4*Sqrt[1 - x^4]) - 1/(4*x^4*Sqrt[1 - x^4]) - (3/4)*ArcTanh[Sqrt[1 - x^4]]}

{x^9/(1 - x^4)^(3/2), x, 4, x^6/(2*Sqrt[1 - x^4]) + (3*x^2*Sqrt[1 - x^4])/4 - (3*ArcSin[x^2])/4}
{x^5/(1 - x^4)^(3/2), x, 3, x^2/(2*Sqrt[1 - x^4]) - ArcSin[x^2]/2}
{x^1/(1 - x^4)^(3/2), x, 1, x^2/(2*Sqrt[1 - x^4])}
{1/(x^3*(1 - x^4)^(3/2)), x, 2, -1/(2*x^2*Sqrt[1 - x^4]) + x^2/Sqrt[1 - x^4]}
{1/(x^7*(1 - x^4)^(3/2)), x, 3, -1/(6*x^6*Sqrt[1 - x^4]) - 2/(3*x^2*Sqrt[1 - x^4]) + (4*x^2)/(3*Sqrt[1 - x^4])}

{x^12/(1 - x^4)^(3/2), x, 4, x^9/(2*Sqrt[1 - x^4]) + (15*x*Sqrt[1 - x^4])/14 + (9*x^5*Sqrt[1 - x^4])/14 - (15*EllipticF[ArcSin[x], -1])/14}
{x^8/(1 - x^4)^(3/2), x, 3, x^5/(2*Sqrt[1 - x^4]) + (5*x*Sqrt[1 - x^4])/6 - (5*EllipticF[ArcSin[x], -1])/6}
{x^4/(1 - x^4)^(3/2), x, 2, x/(2*Sqrt[1 - x^4]) - EllipticF[ArcSin[x], -1]/2}
{x^0/(1 - x^4)^(3/2), x, 2, x/(2*Sqrt[1 - x^4]) + EllipticF[ArcSin[x], -1]/2}
{1/(x^4*(1 - x^4)^(3/2)), x, 3, 1/(2*x^3*Sqrt[1 - x^4]) - (5*Sqrt[1 - x^4])/(6*x^3) + (5*EllipticF[ArcSin[x], -1])/6}
{1/(x^8*(1 - x^4)^(3/2)), x, 4, 1/(2*x^7*Sqrt[1 - x^4]) - (9*Sqrt[1 - x^4])/(14*x^7) - (15*Sqrt[1 - x^4])/(14*x^3) + (15*EllipticF[ArcSin[x], -1])/14}

{x^14/(1 - x^4)^(3/2), x, 7, x^11/(2*Sqrt[1 - x^4]) + (77*x^3*Sqrt[1 - x^4])/90 + (11*x^7*Sqrt[1 - x^4])/18 - (77*EllipticE[ArcSin[x], -1])/30 + (77*EllipticF[ArcSin[x], -1])/30}
{x^10/(1 - x^4)^(3/2), x, 6, x^7/(2*Sqrt[1 - x^4]) + (7*x^3*Sqrt[1 - x^4])/10 - (21*EllipticE[ArcSin[x], -1])/10 + (21*EllipticF[ArcSin[x], -1])/10}
{x^6/(1 - x^4)^(3/2), x, 5, x^3/(2*Sqrt[1 - x^4]) - (3*EllipticE[ArcSin[x], -1])/2 + (3*EllipticF[ArcSin[x], -1])/2}
{x^2/(1 - x^4)^(3/2), x, 5, x^3/(2*Sqrt[1 - x^4]) - EllipticE[ArcSin[x], -1]/2 + EllipticF[ArcSin[x], -1]/2}
{1/(x^2*(1 - x^4)^(3/2)), x, 6, 1/(2*x*Sqrt[1 - x^4]) - (3*Sqrt[1 - x^4])/(2*x) - (3*EllipticE[ArcSin[x], -1])/2 + (3*EllipticF[ArcSin[x], -1])/2}
{1/(x^6*(1 - x^4)^(3/2)), x, 7, 1/(2*x^5*Sqrt[1 - x^4]) - (7*Sqrt[1 - x^4])/(10*x^5) - (21*Sqrt[1 - x^4])/(10*x) - (21*EllipticE[ArcSin[x], -1])/10 + (21*EllipticF[ArcSin[x], -1])/10}


{1/(1 - x^4)^(5/2), x, 3, x/(6*(1 - x^4)^(3/2)) + (5*x)/(12*Sqrt[1 - x^4]) + (5/12)*EllipticF[ArcSin[x], -1]}


{x^11/Sqrt[1 + x^4], x, 3, Sqrt[1 + x^4]/2 - (1 + x^4)^(3/2)/3 + (1 + x^4)^(5/2)/10}
{x^7/Sqrt[1 + x^4], x, 3, -Sqrt[1 + x^4]/2 + (1 + x^4)^(3/2)/6}
{x^3/Sqrt[1 + x^4], x, 1, Sqrt[1 + x^4]/2}
{1/(x^1*Sqrt[1 + x^4]), x, 3, -ArcTanh[Sqrt[1 + x^4]]/2}
{1/(x^5*Sqrt[1 + x^4]), x, 4, -Sqrt[1 + x^4]/(4*x^4) + ArcTanh[Sqrt[1 + x^4]]/4}

{x^5/Sqrt[1 + x^4], x, 3, (x^2*Sqrt[1 + x^4])/4 - ArcSinh[x^2]/4}
{x^1/Sqrt[1 + x^4], x, 2, ArcSinh[x^2]/2}
{1/(x^3*Sqrt[1 + x^4]), x, 1, -Sqrt[1 + x^4]/(2*x^2)}
{1/(x^7*Sqrt[1 + x^4]), x, 2, -Sqrt[1 + x^4]/(6*x^6) + Sqrt[1 + x^4]/(3*x^2)}
{1/(x^11*Sqrt[1 + x^4]), x, 3, -Sqrt[1 + x^4]/(10*x^10) + (2*Sqrt[1 + x^4])/(15*x^6) - (4*Sqrt[1 + x^4])/(15*x^2)}

{x^8/Sqrt[1 + x^4], x, 3, (-5*x*Sqrt[1 + x^4])/21 + (x^5*Sqrt[1 + x^4])/7 + (5*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(42*Sqrt[1 + x^4])}
{x^4/Sqrt[1 + x^4], x, 2, (x*Sqrt[1 + x^4])/3 - ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(6*Sqrt[1 + x^4])}
{x^0/Sqrt[1 + x^4], x, 1, ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(2*Sqrt[1 + x^4])}
{1/(x^4*Sqrt[1 + x^4]), x, 2, -Sqrt[1 + x^4]/(3*x^3) - ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(6*Sqrt[1 + x^4])}
{1/(x^8*Sqrt[1 + x^4]), x, 3, -Sqrt[1 + x^4]/(7*x^7) + (5*Sqrt[1 + x^4])/(21*x^3) + (5*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(42*Sqrt[1 + x^4])}

{x^10/Sqrt[1 + x^4], x, 5, (-(7/45))*x^3*Sqrt[1 + x^4] + (1/9)*x^7*Sqrt[1 + x^4] + (7*x*Sqrt[1 + x^4])/(15*(1 + x^2)) - (7*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(15*Sqrt[1 + x^4]) + (7*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(30*Sqrt[1 + x^4])}
{x^6/Sqrt[1 + x^4], x, 4, (1/5)*x^3*Sqrt[1 + x^4] - (3*x*Sqrt[1 + x^4])/(5*(1 + x^2)) + (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(5*Sqrt[1 + x^4]) - (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(10*Sqrt[1 + x^4])}
{x^2/Sqrt[1 + x^4], x, 3, (x*Sqrt[1 + x^4])/(1 + x^2) - ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/Sqrt[1 + x^4] + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(2*Sqrt[1 + x^4])}
{1/(x^2*Sqrt[1 + x^4]), x, 4, -(Sqrt[1 + x^4]/x) + (x*Sqrt[1 + x^4])/(1 + x^2) - ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/Sqrt[1 + x^4] + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(2*Sqrt[1 + x^4])}
{1/(x^6*Sqrt[1 + x^4]), x, 5, -(Sqrt[1 + x^4]/(5*x^5)) + (3*Sqrt[1 + x^4])/(5*x) - (3*x*Sqrt[1 + x^4])/(5*(1 + x^2)) + (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(5*Sqrt[1 + x^4]) - (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(10*Sqrt[1 + x^4])}


{x^11/(1 + x^4)^(3/2), x, 3, -1/(2*Sqrt[1 + x^4]) - Sqrt[1 + x^4] + (1 + x^4)^(3/2)/6}
{x^7/(1 + x^4)^(3/2), x, 3, 1/(2*Sqrt[1 + x^4]) + Sqrt[1 + x^4]/2}
{x^3/(1 + x^4)^(3/2), x, 1, -1/(2*Sqrt[1 + x^4])}
{1/(x^1*(1 + x^4)^(3/2)), x, 4, 1/(2*Sqrt[1 + x^4]) - ArcTanh[Sqrt[1 + x^4]]/2}
{1/(x^5*(1 + x^4)^(3/2)), x, 5, -(3/(4*Sqrt[1 + x^4])) - 1/(4*x^4*Sqrt[1 + x^4]) + (3/4)*ArcTanh[Sqrt[1 + x^4]]}

{x^9/(1 + x^4)^(3/2), x, 4, -x^6/(2*Sqrt[1 + x^4]) + (3*x^2*Sqrt[1 + x^4])/4 - (3*ArcSinh[x^2])/4}
{x^5/(1 + x^4)^(3/2), x, 3, -x^2/(2*Sqrt[1 + x^4]) + ArcSinh[x^2]/2}
{x^1/(1 + x^4)^(3/2), x, 1, x^2/(2*Sqrt[1 + x^4])}
{1/(x^3*(1 + x^4)^(3/2)), x, 2, -1/(2*x^2*Sqrt[1 + x^4]) - x^2/Sqrt[1 + x^4]}
{1/(x^7*(1 + x^4)^(3/2)), x, 3, -1/(6*x^6*Sqrt[1 + x^4]) + 2/(3*x^2*Sqrt[1 + x^4]) + (4*x^2)/(3*Sqrt[1 + x^4])}

{x^12/(1 + x^4)^(3/2), x, 4, -x^9/(2*Sqrt[1 + x^4]) - (15*x*Sqrt[1 + x^4])/14 + (9*x^5*Sqrt[1 + x^4])/14 + (15*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(28*Sqrt[1 + x^4])}
{x^8/(1 + x^4)^(3/2), x, 3, -x^5/(2*Sqrt[1 + x^4]) + (5*x*Sqrt[1 + x^4])/6 - (5*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(12*Sqrt[1 + x^4])}
{x^4/(1 + x^4)^(3/2), x, 2, -x/(2*Sqrt[1 + x^4]) + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(4*Sqrt[1 + x^4])}
{x^0/(1 + x^4)^(3/2), x, 2, x/(2*Sqrt[1 + x^4]) + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(4*Sqrt[1 + x^4])}
{1/(x^4*(1 + x^4)^(3/2)), x, 3, 1/(2*x^3*Sqrt[1 + x^4]) - (5*Sqrt[1 + x^4])/(6*x^3) - (5*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(12*Sqrt[1 + x^4])}
{1/(x^8*(1 + x^4)^(3/2)), x, 4, 1/(2*x^7*Sqrt[1 + x^4]) - (9*Sqrt[1 + x^4])/(14*x^7) + (15*Sqrt[1 + x^4])/(14*x^3) + (15*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(28*Sqrt[1 + x^4])}

{x^14/(1 + x^4)^(3/2), x, 6, -(x^11/(2*Sqrt[1 + x^4])) - (77/90)*x^3*Sqrt[1 + x^4] + (11/18)*x^7*Sqrt[1 + x^4] + (77*x*Sqrt[1 + x^4])/(30*(1 + x^2)) - (77*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(30*Sqrt[1 + x^4]) + (77*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(60*Sqrt[1 + x^4])}
{x^10/(1 + x^4)^(3/2), x, 5, -(x^7/(2*Sqrt[1 + x^4])) + (7/10)*x^3*Sqrt[1 + x^4] - (21*x*Sqrt[1 + x^4])/(10*(1 + x^2)) + (21*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(10*Sqrt[1 + x^4]) - (21*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(20*Sqrt[1 + x^4])}
{x^6/(1 + x^4)^(3/2), x, 4, -(x^3/(2*Sqrt[1 + x^4])) + (3*x*Sqrt[1 + x^4])/(2*(1 + x^2)) - (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(2*Sqrt[1 + x^4]) + (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(4*Sqrt[1 + x^4])}
{x^2/(1 + x^4)^(3/2), x, 4, x^3/(2*Sqrt[1 + x^4]) - (x*Sqrt[1 + x^4])/(2*(1 + x^2)) + ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(2*Sqrt[1 + x^4]) - ((1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(4*Sqrt[1 + x^4])}
{1/(x^2*(1 + x^4)^(3/2)), x, 5, 1/(2*x*Sqrt[1 + x^4]) - (3*Sqrt[1 + x^4])/(2*x) + (3*x*Sqrt[1 + x^4])/(2*(1 + x^2)) - (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(2*Sqrt[1 + x^4]) + (3*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(4*Sqrt[1 + x^4])}
{1/(x^6*(1 + x^4)^(3/2)), x, 6, 1/(2*x^5*Sqrt[1 + x^4]) - (7*Sqrt[1 + x^4])/(10*x^5) + (21*Sqrt[1 + x^4])/(10*x) - (21*x*Sqrt[1 + x^4])/(10*(1 + x^2)) + (21*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticE[2*ArcTan[x], 1/2])/(10*Sqrt[1 + x^4]) - (21*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(20*Sqrt[1 + x^4])}


{1/(1 + x^4)^(5/2), x, 3, x/(6*(1 + x^4)^(3/2)) + (5*x)/(12*Sqrt[1 + x^4]) + (5*(1 + x^2)*Sqrt[(1 + x^4)/(1 + x^2)^2]*EllipticF[2*ArcTan[x], 1/2])/(24*Sqrt[1 + x^4])}


{x^7/Sqrt[16 - x^4], x, 3, -8*Sqrt[16 - x^4] + (1/6)*(16 - x^4)^(3/2)}
{x^5/Sqrt[16 - x^4], x, 3, (-(1/4))*x^2*Sqrt[16 - x^4] + 4*ArcSin[x^2/4]}
{x^3/Sqrt[16 - x^4], x, 1, (-(1/2))*Sqrt[16 - x^4]}
{x^1/Sqrt[16 - x^4], x, 2, (1/2)*ArcSin[x^2/4]}
{1/(x^1*Sqrt[16 - x^4]), x, 3, (-(1/8))*ArcTanh[Sqrt[16 - x^4]/4]}
{1/(x^3*Sqrt[16 - x^4]), x, 1, -(Sqrt[16 - x^4]/(32*x^2))}
{1/(x^5*Sqrt[16 - x^4]), x, 4, -(Sqrt[16 - x^4]/(64*x^4)) - (1/256)*ArcTanh[Sqrt[16 - x^4]/4]}
{1/(x^7*Sqrt[16 - x^4]), x, 2, -(Sqrt[16 - x^4]/(96*x^6)) - Sqrt[16 - x^4]/(768*x^2)}

{x^6/Sqrt[16 - x^4], x, 6, (-(1/5))*x^3*Sqrt[16 - x^4] + (96/5)*EllipticE[ArcSin[x/2], -1] - (96/5)*EllipticF[ArcSin[x/2], -1]}
{x^4/Sqrt[16 - x^4], x, 2, (-(1/3))*x*Sqrt[16 - x^4] + (8/3)*EllipticF[ArcSin[x/2], -1]}
{x^2/Sqrt[16 - x^4], x, 5, 2*EllipticE[ArcSin[x/2], -1] - 2*EllipticF[ArcSin[x/2], -1]}
{x^0/Sqrt[16 - x^4], x, 1, (1/2)*EllipticF[ArcSin[x/2], -1]}
{1/(x^2*Sqrt[16 - x^4]), x, 6, -(Sqrt[16 - x^4]/(16*x)) - (1/8)*EllipticE[ArcSin[x/2], -1] + (1/8)*EllipticF[ArcSin[x/2], -1]}
{1/(x^4*Sqrt[16 - x^4]), x, 2, -(Sqrt[16 - x^4]/(48*x^3)) + (1/96)*EllipticF[ArcSin[x/2], -1]}


{x/Sqrt[-4 + x^4], x, 3, (1/2)*ArcTanh[x^2/Sqrt[-4 + x^4]]}
{x/Sqrt[4 + x^4], x, 2, ArcSinh[x^2/2]/2}


{1/(x*Sqrt[-1 + x^4]), x, 3, ArcTan[Sqrt[-1 + x^4]]/2}

{x^4/Sqrt[-1 + x^4], x, 2, (1/3)*x*Sqrt[-1 + x^4] + (Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(3*Sqrt[2]*Sqrt[-1 + x^4])}
{x^0/Sqrt[-1 + x^4], x, 1, (Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(Sqrt[2]*Sqrt[-1 + x^4])}
{1/(x^4*Sqrt[-1 + x^4]), x, 2, Sqrt[-1 + x^4]/(3*x^3) + (Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(3*Sqrt[2]*Sqrt[-1 + x^4])}

{x^6/Sqrt[-1 + x^4], x, 4, (3*x*(1 + x^2))/(5*Sqrt[-1 + x^4]) + (1/5)*x^3*Sqrt[-1 + x^4] - (3*Sqrt[2]*Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticE[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(5*Sqrt[-1 + x^4]) + (3*Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(5*Sqrt[2]*Sqrt[-1 + x^4])}
{x^2/Sqrt[-1 + x^4], x, 3, (x*(1 + x^2))/Sqrt[-1 + x^4] - (Sqrt[2]*Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticE[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/Sqrt[-1 + x^4] + (Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(Sqrt[2]*Sqrt[-1 + x^4])}
{1/(x^2*Sqrt[-1 + x^4]), x, 4, -((x*(1 + x^2))/Sqrt[-1 + x^4]) + Sqrt[-1 + x^4]/x + (Sqrt[2]*Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticE[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/Sqrt[-1 + x^4] - (Sqrt[-1 + x^2]*Sqrt[1 + x^2]*EllipticF[ArcSin[(Sqrt[2]*x)/Sqrt[-1 + x^2]], 1/2])/(Sqrt[2]*Sqrt[-1 + x^4])}


{x^2/Sqrt[3 - 2*x^4], x, 5, (3^(1/4)*EllipticE[ArcSin[(2/3)^(1/4)*x], -1])/2^(3/4) - (3^(1/4)*EllipticF[ArcSin[(2/3)^(1/4)*x], -1])/2^(3/4)}
{x^2/Sqrt[3 - b*x^4], x, 4, (3^(1/4)*EllipticE[ArcSin[(b^(1/4)*x)/3^(1/4)], -1])/b^(3/4) - (3^(1/4)*EllipticF[ArcSin[(b^(1/4)*x)/3^(1/4)], -1])/b^(3/4)}


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b x^4)^(p/2)*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^4)^(p/3)*)


{x^7*(1 + x^4)^(1/3), x, 3, (-(3/16))*(1 + x^4)^(4/3) + (3/28)*(1 + x^4)^(7/3)}


{x^3/(1 + x^4)^(4/3), x, 1, -3/(4*(1 + x^4)^(1/3))}
{x^3/(1 + x^4)^(1/3), x, 1, (3*(1 + x^4)^(2/3))/8}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^4)^(p/4)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^19*(a + b*x^4)^(1/4), x, 3, (a^4*(a + b*x^4)^(5/4))/(5*b^5) - (4*a^3*(a + b*x^4)^(9/4))/(9*b^5) + (6*a^2*(a + b*x^4)^(13/4))/(13*b^5) - (4*a*(a + b*x^4)^(17/4))/(17*b^5) + (a + b*x^4)^(21/4)/(21*b^5)}
{x^15*(a + b*x^4)^(1/4), x, 3, -(a^3*(a + b*x^4)^(5/4))/(5*b^4) + (a^2*(a + b*x^4)^(9/4))/(3*b^4) - (3*a*(a + b*x^4)^(13/4))/(13*b^4) + (a + b*x^4)^(17/4)/(17*b^4)}
{x^11*(a + b*x^4)^(1/4), x, 3, (a^2*(a + b*x^4)^(5/4))/(5*b^3) - (2*a*(a + b*x^4)^(9/4))/(9*b^3) + (a + b*x^4)^(13/4)/(13*b^3)}
{x^7*(a + b*x^4)^(1/4), x, 3, -(a*(a + b*x^4)^(5/4))/(5*b^2) + (a + b*x^4)^(9/4)/(9*b^2)}
{x^3*(a + b*x^4)^(1/4), x, 1, (a + b*x^4)^(5/4)/(5*b)}
{(a + b*x^4)^(1/4)/x^1, x, 6, (a + b*x^4)^(1/4) - (a^(1/4)*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/2 - (a^(1/4)*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/2}
{(a + b*x^4)^(1/4)/x^5, x, 6, -(a + b*x^4)^(1/4)/(4*x^4) - (b*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(3/4)) - (b*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(3/4))}
{(a + b*x^4)^(1/4)/x^9, x, 7, -(a + b*x^4)^(1/4)/(8*x^8) - (b*(a + b*x^4)^(1/4))/(32*a*x^4) + (3*b^2*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(7/4)) + (3*b^2*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(7/4))}

{x^9*(a + b*x^4)^(1/4), x, 6, -((2*a^2*x^2*(a + b*x^4)^(1/4))/(77*b^2)) + (a*x^6*(a + b*x^4)^(1/4))/(77*b) + (1/11)*x^10*(a + b*x^4)^(1/4) + (4*a^(7/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*b^(5/2)*(a + b*x^4)^(3/4))}
{x^5*(a + b*x^4)^(1/4), x, 5, (a*x^2*(a + b*x^4)^(1/4))/(21*b) + (1/7)*x^6*(a + b*x^4)^(1/4) - (2*a^(5/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(21*b^(3/2)*(a + b*x^4)^(3/4))}
{x^1*(a + b*x^4)^(1/4), x, 4, (1/3)*x^2*(a + b*x^4)^(1/4) + (a^(3/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*Sqrt[b]*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(1/4)/x^3, x, 4, -((a + b*x^4)^(1/4)/(2*x^2)) + (Sqrt[a]*Sqrt[b]*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(1/4)/x^7, x, 5, -((a + b*x^4)^(1/4)/(6*x^6)) - (b*(a + b*x^4)^(1/4))/(12*a*x^2) - (b^(3/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*Sqrt[a]*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(1/4)/x^11, x, 6, -((a + b*x^4)^(1/4)/(10*x^10)) - (b*(a + b*x^4)^(1/4))/(60*a*x^6) + (b^2*(a + b*x^4)^(1/4))/(24*a^2*x^2) + (b^(5/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(24*a^(3/2)*(a + b*x^4)^(3/4))}

{x^6*(a + b*x^4)^(1/4), x, 6, (a*x^3*(a + b*x^4)^(1/4))/(32*b) + (x^7*(a + b*x^4)^(1/4))/8 + (3*a^2*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(7/4)) - (3*a^2*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(7/4))}
{x^2*(a + b*x^4)^(1/4), x, 5, (x^3*(a + b*x^4)^(1/4))/4 - (a*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(3/4)) + (a*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(3/4))}
{(a + b*x^4)^(1/4)/x^2, x, 5, -((a + b*x^4)^(1/4)/x) - (b^(1/4)*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/2 + (b^(1/4)*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/2}
{(a + b*x^4)^(1/4)/x^6, x, 1, -(a + b*x^4)^(5/4)/(5*a*x^5)}
{(a + b*x^4)^(1/4)/x^10, x, 2, -(a + b*x^4)^(5/4)/(9*a*x^9) + (4*b*(a + b*x^4)^(5/4))/(45*a^2*x^5)}
{(a + b*x^4)^(1/4)/x^14, x, 3, -(a + b*x^4)^(5/4)/(13*a*x^13) + (8*b*(a + b*x^4)^(5/4))/(117*a^2*x^9) - (32*b^2*(a + b*x^4)^(5/4))/(585*a^3*x^5)}
{(a + b*x^4)^(1/4)/x^18, x, 4, -(a + b*x^4)^(5/4)/(17*a*x^17) + (12*b*(a + b*x^4)^(5/4))/(221*a^2*x^13) - (32*b^2*(a + b*x^4)^(5/4))/(663*a^3*x^9) + (128*b^3*(a + b*x^4)^(5/4))/(3315*a^4*x^5)}

{x^12*(a + b*x^4)^(1/4), x, 8, (3*a^3*x*(a + b*x^4)^(1/4))/(112*b^3) - (3*a^2*x^5*(a + b*x^4)^(1/4))/(280*b^2) + (a*x^9*(a + b*x^4)^(1/4))/(140*b) + (1/14)*x^13*(a + b*x^4)^(1/4) + (3*a^(7/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(112*b^(5/2)*(a + b*x^4)^(3/4))}
{x^8*(a + b*x^4)^(1/4), x, 7, -((a^2*x*(a + b*x^4)^(1/4))/(24*b^2)) + (a*x^5*(a + b*x^4)^(1/4))/(60*b) + (1/10)*x^9*(a + b*x^4)^(1/4) - (a^(5/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(24*b^(3/2)*(a + b*x^4)^(3/4))}
{x^4*(a + b*x^4)^(1/4), x, 6, (a*x*(a + b*x^4)^(1/4))/(12*b) + (1/6)*x^5*(a + b*x^4)^(1/4) + (a^(3/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*Sqrt[b]*(a + b*x^4)^(3/4))}
{x^0*(a + b*x^4)^(1/4), x, 5, (1/2)*x*(a + b*x^4)^(1/4) - (Sqrt[a]*Sqrt[b]*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(1/4)/x^4, x, 5, -((a + b*x^4)^(1/4)/(3*x^3)) - (b^(3/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*Sqrt[a]*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(1/4)/x^8, x, 6, -((a + b*x^4)^(1/4)/(7*x^7)) - (b*(a + b*x^4)^(1/4))/(21*a*x^3) + (2*b^(5/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(21*a^(3/2)*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(1/4)/x^12, x, 7, -((a + b*x^4)^(1/4)/(11*x^11)) - (b*(a + b*x^4)^(1/4))/(77*a*x^7) + (2*b^2*(a + b*x^4)^(1/4))/(77*a^2*x^3) - (4*b^(7/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*a^(5/2)*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(1/4)/x^16, x, 8, -((a + b*x^4)^(1/4)/(15*x^15)) - (b*(a + b*x^4)^(1/4))/(165*a*x^11) + (2*b^2*(a + b*x^4)^(1/4))/(231*a^2*x^7) - (4*b^3*(a + b*x^4)^(1/4))/(231*a^3*x^3) + (8*b^(9/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(231*a^(7/2)*(a + b*x^4)^(3/4))}


{x^19*(a + b*x^4)^(3/4), x, 3, (a^4*(a + b*x^4)^(7/4))/(7*b^5) - (4*a^3*(a + b*x^4)^(11/4))/(11*b^5) + (2*a^2*(a + b*x^4)^(15/4))/(5*b^5) - (4*a*(a + b*x^4)^(19/4))/(19*b^5) + (a + b*x^4)^(23/4)/(23*b^5)}
{x^15*(a + b*x^4)^(3/4), x, 3, -(a^3*(a + b*x^4)^(7/4))/(7*b^4) + (3*a^2*(a + b*x^4)^(11/4))/(11*b^4) - (a*(a + b*x^4)^(15/4))/(5*b^4) + (a + b*x^4)^(19/4)/(19*b^4)}
{x^11*(a + b*x^4)^(3/4), x, 3, (a^2*(a + b*x^4)^(7/4))/(7*b^3) - (2*a*(a + b*x^4)^(11/4))/(11*b^3) + (a + b*x^4)^(15/4)/(15*b^3)}
{x^7*(a + b*x^4)^(3/4), x, 3, -(a*(a + b*x^4)^(7/4))/(7*b^2) + (a + b*x^4)^(11/4)/(11*b^2)}
{x^3*(a + b*x^4)^(3/4), x, 1, (a + b*x^4)^(7/4)/(7*b)}
{(a + b*x^4)^(3/4)/x^1, x, 6, (a + b*x^4)^(3/4)/3 + (a^(3/4)*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/2 - (a^(3/4)*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/2}
{(a + b*x^4)^(3/4)/x^5, x, 6, -(a + b*x^4)^(3/4)/(4*x^4) + (3*b*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(1/4)) - (3*b*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(1/4))}
{(a + b*x^4)^(3/4)/x^9, x, 7, -(a + b*x^4)^(3/4)/(8*x^8) - (3*b*(a + b*x^4)^(3/4))/(32*a*x^4) - (3*b^2*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(5/4)) + (3*b^2*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(5/4))}

{x^9*(a + b*x^4)^(3/4), x, 7, (4*a^3*x^2)/(65*b^2*(a + b*x^4)^(1/4)) - (2*a^2*x^2*(a + b*x^4)^(3/4))/(65*b^2) + (a*x^6*(a + b*x^4)^(3/4))/(39*b) + (1/13)*x^10*(a + b*x^4)^(3/4) - (4*a^(7/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(65*b^(5/2)*(a + b*x^4)^(1/4))}
{x^5*(a + b*x^4)^(3/4), x, 6, -((2*a^2*x^2)/(15*b*(a + b*x^4)^(1/4))) + (a*x^2*(a + b*x^4)^(3/4))/(15*b) + (1/9)*x^6*(a + b*x^4)^(3/4) + (2*a^(5/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(15*b^(3/2)*(a + b*x^4)^(1/4))}
{x^1*(a + b*x^4)^(3/4), x, 5, (3*a*x^2)/(5*(a + b*x^4)^(1/4)) + (1/5)*x^2*(a + b*x^4)^(3/4) - (3*a^(3/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*Sqrt[b]*(a + b*x^4)^(1/4))}
{(a + b*x^4)^(3/4)/x^3, x, 5, (3*b*x^2)/(2*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/(2*x^2) - (3*Sqrt[a]*Sqrt[b]*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*(a + b*x^4)^(1/4))}
{(a + b*x^4)^(3/4)/x^7, x, 6, (b^2*x^2)/(4*a*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/(6*x^6) - (b*(a + b*x^4)^(3/4))/(4*a*x^2) - (b^(3/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*Sqrt[a]*(a + b*x^4)^(1/4))}
{(a + b*x^4)^(3/4)/x^11, x, 7, -((3*b^3*x^2)/(40*a^2*(a + b*x^4)^(1/4))) - (a + b*x^4)^(3/4)/(10*x^10) - (b*(a + b*x^4)^(3/4))/(20*a*x^6) + (3*b^2*(a + b*x^4)^(3/4))/(40*a^2*x^2) + (3*b^(5/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*a^(3/2)*(a + b*x^4)^(1/4))}

{x^12*(a + b*x^4)^(3/4), x, 8, (45*a^3*x*(a + b*x^4)^(3/4))/(2048*b^3) - (9*a^2*x^5*(a + b*x^4)^(3/4))/(512*b^2) + (a*x^9*(a + b*x^4)^(3/4))/(64*b) + (x^13*(a + b*x^4)^(3/4))/16 - (45*a^4*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(4096*b^(13/4)) - (45*a^4*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(4096*b^(13/4))}
{x^8*(a + b*x^4)^(3/4), x, 7, (-5*a^2*x*(a + b*x^4)^(3/4))/(128*b^2) + (a*x^5*(a + b*x^4)^(3/4))/(32*b) + (x^9*(a + b*x^4)^(3/4))/12 + (5*a^3*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(256*b^(9/4)) + (5*a^3*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(256*b^(9/4))}
{x^4*(a + b*x^4)^(3/4), x, 6, (3*a*x*(a + b*x^4)^(3/4))/(32*b) + (x^5*(a + b*x^4)^(3/4))/8 - (3*a^2*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(5/4)) - (3*a^2*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(5/4))}
{x^0*(a + b*x^4)^(3/4), x, 5, (x*(a + b*x^4)^(3/4))/4 + (3*a*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(1/4)) + (3*a*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(1/4))}
{(a + b*x^4)^(3/4)/x^4, x, 5, -(a + b*x^4)^(3/4)/(3*x^3) + (b^(3/4)*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/2 + (b^(3/4)*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/2}
{(a + b*x^4)^(3/4)/x^8, x, 1, -(a + b*x^4)^(7/4)/(7*a*x^7)}
{(a + b*x^4)^(3/4)/x^12, x, 2, -(a + b*x^4)^(7/4)/(11*a*x^11) + (4*b*(a + b*x^4)^(7/4))/(77*a^2*x^7)}
{(a + b*x^4)^(3/4)/x^16, x, 3, -(a + b*x^4)^(7/4)/(15*a*x^15) + (8*b*(a + b*x^4)^(7/4))/(165*a^2*x^11) - (32*b^2*(a + b*x^4)^(7/4))/(1155*a^3*x^7)}
{(a + b*x^4)^(3/4)/x^20, x, 4, -(a + b*x^4)^(7/4)/(19*a*x^19) + (4*b*(a + b*x^4)^(7/4))/(95*a^2*x^15) - (32*b^2*(a + b*x^4)^(7/4))/(1045*a^3*x^11) + (128*b^3*(a + b*x^4)^(7/4))/(7315*a^4*x^7)}

{x^10*(a + b*x^4)^(3/4), x, 8, (3*a^3*x^3)/(80*b^2*(a + b*x^4)^(1/4)) - (a^2*x^3*(a + b*x^4)^(3/4))/(40*b^2) + (3*a*x^7*(a + b*x^4)^(3/4))/(140*b) + (1/14)*x^11*(a + b*x^4)^(3/4) + (3*a^(7/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(80*b^(5/2)*(a + b*x^4)^(1/4))}
{x^6*(a + b*x^4)^(3/4), x, 7, -((3*a^2*x^3)/(40*b*(a + b*x^4)^(1/4))) + (a*x^3*(a + b*x^4)^(3/4))/(20*b) + (1/10)*x^7*(a + b*x^4)^(3/4) - (3*a^(5/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*b^(3/2)*(a + b*x^4)^(1/4))}
{x^2*(a + b*x^4)^(3/4), x, 6, (a*x^3)/(4*(a + b*x^4)^(1/4)) + (1/6)*x^3*(a + b*x^4)^(3/4) + (a^(3/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*Sqrt[b]*(a + b*x^4)^(1/4))}
{(a + b*x^4)^(3/4)/x^2, x, 6, (3*b*x^3)/(2*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/x + (3*Sqrt[a]*Sqrt[b]*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*(a + b*x^4)^(1/4))}
{(a + b*x^4)^(3/4)/x^6, x, 6, -((3*b)/(5*x*(a + b*x^4)^(1/4))) - (a + b*x^4)^(3/4)/(5*x^5) + (3*b^(3/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*Sqrt[a]*(a + b*x^4)^(1/4))}
{(a + b*x^4)^(3/4)/x^10, x, 7, (2*b^2)/(15*a*x*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/(9*x^9) - (b*(a + b*x^4)^(3/4))/(15*a*x^5) - (2*b^(5/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(15*a^(3/2)*(a + b*x^4)^(1/4))}
{(a + b*x^4)^(3/4)/x^14, x, 8, -((4*b^3)/(65*a^2*x*(a + b*x^4)^(1/4))) - (a + b*x^4)^(3/4)/(13*x^13) - (b*(a + b*x^4)^(3/4))/(39*a*x^9) + (2*b^2*(a + b*x^4)^(3/4))/(65*a^2*x^5) + (4*b^(7/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(65*a^(5/2)*(a + b*x^4)^(1/4))}


{x^19*(a + b*x^4)^(5/4), x, 3, (a^4*(a + b*x^4)^(9/4))/(9*b^5) - (4*a^3*(a + b*x^4)^(13/4))/(13*b^5) + (6*a^2*(a + b*x^4)^(17/4))/(17*b^5) - (4*a*(a + b*x^4)^(21/4))/(21*b^5) + (a + b*x^4)^(25/4)/(25*b^5)}
{x^15*(a + b*x^4)^(5/4), x, 3, -(a^3*(a + b*x^4)^(9/4))/(9*b^4) + (3*a^2*(a + b*x^4)^(13/4))/(13*b^4) - (3*a*(a + b*x^4)^(17/4))/(17*b^4) + (a + b*x^4)^(21/4)/(21*b^4)}
{x^11*(a + b*x^4)^(5/4), x, 3, (a^2*(a + b*x^4)^(9/4))/(9*b^3) - (2*a*(a + b*x^4)^(13/4))/(13*b^3) + (a + b*x^4)^(17/4)/(17*b^3)}
{x^7*(a + b*x^4)^(5/4), x, 3, -(a*(a + b*x^4)^(9/4))/(9*b^2) + (a + b*x^4)^(13/4)/(13*b^2)}
{x^3*(a + b*x^4)^(5/4), x, 1, (a + b*x^4)^(9/4)/(9*b)}
{(a + b*x^4)^(5/4)/x^1, x, 7, a*(a + b*x^4)^(1/4) + (a + b*x^4)^(5/4)/5 - (a^(5/4)*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/2 - (a^(5/4)*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/2}
{(a + b*x^4)^(5/4)/x^5, x, 7, (5*b*(a + b*x^4)^(1/4))/4 - (a + b*x^4)^(5/4)/(4*x^4) - (5*a^(1/4)*b*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/8 - (5*a^(1/4)*b*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/8}
{(a + b*x^4)^(5/4)/x^9, x, 7, (-5*b*(a + b*x^4)^(1/4))/(32*x^4) - (a + b*x^4)^(5/4)/(8*x^8) - (5*b^2*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(3/4)) - (5*b^2*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(3/4))}

{x^9*(a + b*x^4)^(5/4), x, 7, -((2*a^3*x^2*(a + b*x^4)^(1/4))/(231*b^2)) + (a^2*x^6*(a + b*x^4)^(1/4))/(231*b) + (1/33)*a*x^10*(a + b*x^4)^(1/4) + (1/15)*x^10*(a + b*x^4)^(5/4) + (4*a^(9/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(231*b^(5/2)*(a + b*x^4)^(3/4))}
{x^5*(a + b*x^4)^(5/4), x, 6, (5*a^2*x^2*(a + b*x^4)^(1/4))/(231*b) + (5/77)*a*x^6*(a + b*x^4)^(1/4) + (1/11)*x^6*(a + b*x^4)^(5/4) - (10*a^(7/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(231*b^(3/2)*(a + b*x^4)^(3/4))}
{x^1*(a + b*x^4)^(5/4), x, 5, (5/21)*a*x^2*(a + b*x^4)^(1/4) + (1/7)*x^2*(a + b*x^4)^(5/4) + (5*a^(5/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(21*Sqrt[b]*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^3, x, 5, (5/6)*b*x^2*(a + b*x^4)^(1/4) - (a + b*x^4)^(5/4)/(2*x^2) + (5*a^(3/2)*Sqrt[b]*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(6*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^7, x, 5, -((5*b*(a + b*x^4)^(1/4))/(12*x^2)) - (a + b*x^4)^(5/4)/(6*x^6) + (5*Sqrt[a]*b^(3/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^11, x, 6, -((b*(a + b*x^4)^(1/4))/(12*x^6)) - (b^2*(a + b*x^4)^(1/4))/(24*a*x^2) - (a + b*x^4)^(5/4)/(10*x^10) - (b^(5/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(24*Sqrt[a]*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^15, x, 7, -((b*(a + b*x^4)^(1/4))/(28*x^10)) - (b^2*(a + b*x^4)^(1/4))/(168*a*x^6) + (5*b^3*(a + b*x^4)^(1/4))/(336*a^2*x^2) - (a + b*x^4)^(5/4)/(14*x^14) + (5*b^(7/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(336*a^(3/2)*(a + b*x^4)^(3/4))}

{x^10*(a + b*x^4)^(5/4), x, 8, (-35*a^3*x^3*(a + b*x^4)^(1/4))/(6144*b^2) + (5*a^2*x^7*(a + b*x^4)^(1/4))/(1536*b) + (5*a*x^11*(a + b*x^4)^(1/4))/192 + (x^11*(a + b*x^4)^(5/4))/16 - (35*a^4*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(4096*b^(11/4)) + (35*a^4*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(4096*b^(11/4))}
{x^6*(a + b*x^4)^(5/4), x, 7, (5*a^2*x^3*(a + b*x^4)^(1/4))/(384*b) + (5*a*x^7*(a + b*x^4)^(1/4))/96 + (x^7*(a + b*x^4)^(5/4))/12 + (5*a^3*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(256*b^(7/4)) - (5*a^3*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(256*b^(7/4))}
{x^2*(a + b*x^4)^(5/4), x, 6, (5*a*x^3*(a + b*x^4)^(1/4))/32 + (x^3*(a + b*x^4)^(5/4))/8 - (5*a^2*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(3/4)) + (5*a^2*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(3/4))}
{(a + b*x^4)^(5/4)/x^2, x, 6, (5*b*x^3*(a + b*x^4)^(1/4))/4 - (a + b*x^4)^(5/4)/x - (5*a*b^(1/4)*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/8 + (5*a*b^(1/4)*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/8}
{(a + b*x^4)^(5/4)/x^6, x, 6, -((b*(a + b*x^4)^(1/4))/x) - (a + b*x^4)^(5/4)/(5*x^5) - (b^(5/4)*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/2 + (b^(5/4)*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/2}
{(a + b*x^4)^(5/4)/x^10, x, 1, -(a + b*x^4)^(9/4)/(9*a*x^9)}
{(a + b*x^4)^(5/4)/x^14, x, 2, -(a + b*x^4)^(9/4)/(13*a*x^13) + (4*b*(a + b*x^4)^(9/4))/(117*a^2*x^9)}
{(a + b*x^4)^(5/4)/x^18, x, 3, -(a + b*x^4)^(9/4)/(17*a*x^17) + (8*b*(a + b*x^4)^(9/4))/(221*a^2*x^13) - (32*b^2*(a + b*x^4)^(9/4))/(1989*a^3*x^9)}
{(a + b*x^4)^(5/4)/x^22, x, 4, -(a + b*x^4)^(9/4)/(21*a*x^21) + (4*b*(a + b*x^4)^(9/4))/(119*a^2*x^17) - (32*b^2*(a + b*x^4)^(9/4))/(1547*a^3*x^13) + (128*b^3*(a + b*x^4)^(9/4))/(13923*a^4*x^9)}

{x^12*(a + b*x^4)^(5/4), x, 9, (5*a^4*x*(a + b*x^4)^(1/4))/(672*b^3) - (a^3*x^5*(a + b*x^4)^(1/4))/(336*b^2) + (a^2*x^9*(a + b*x^4)^(1/4))/(504*b) + (5/252)*a*x^13*(a + b*x^4)^(1/4) + (1/18)*x^13*(a + b*x^4)^(5/4) + (5*a^(9/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(672*b^(5/2)*(a + b*x^4)^(3/4))}
{x^8*(a + b*x^4)^(5/4), x, 8, -((5*a^3*x*(a + b*x^4)^(1/4))/(336*b^2)) + (a^2*x^5*(a + b*x^4)^(1/4))/(168*b) + (1/28)*a*x^9*(a + b*x^4)^(1/4) + (1/14)*x^9*(a + b*x^4)^(5/4) - (5*a^(7/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(336*b^(3/2)*(a + b*x^4)^(3/4))}
{x^4*(a + b*x^4)^(5/4), x, 7, (a^2*x*(a + b*x^4)^(1/4))/(24*b) + (1/12)*a*x^5*(a + b*x^4)^(1/4) + (1/10)*x^5*(a + b*x^4)^(5/4) + (a^(5/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(24*Sqrt[b]*(a + b*x^4)^(3/4))}
{x^0*(a + b*x^4)^(5/4), x, 6, (5/12)*a*x*(a + b*x^4)^(1/4) + (1/6)*x*(a + b*x^4)^(5/4) - (5*a^(3/2)*Sqrt[b]*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^4, x, 6, (5/6)*b*x*(a + b*x^4)^(1/4) - (a + b*x^4)^(5/4)/(3*x^3) - (5*Sqrt[a]*b^(3/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(6*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^8, x, 6, -((5*b*(a + b*x^4)^(1/4))/(21*x^3)) - (a + b*x^4)^(5/4)/(7*x^7) - (5*b^(5/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(21*Sqrt[a]*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^12, x, 7, -((5*b*(a + b*x^4)^(1/4))/(77*x^7)) - (5*b^2*(a + b*x^4)^(1/4))/(231*a*x^3) - (a + b*x^4)^(5/4)/(11*x^11) + (10*b^(7/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(231*a^(3/2)*(a + b*x^4)^(3/4))}
{(a + b*x^4)^(5/4)/x^16, x, 8, -((b*(a + b*x^4)^(1/4))/(33*x^11)) - (b^2*(a + b*x^4)^(1/4))/(231*a*x^7) + (2*b^3*(a + b*x^4)^(1/4))/(231*a^2*x^3) - (a + b*x^4)^(5/4)/(15*x^15) - (4*b^(9/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(231*a^(5/2)*(a + b*x^4)^(3/4))}


{(a + b*x^4)^(7/4), x, 6, (7/32)*a*x*(a + b*x^4)^(3/4) + (1/8)*x*(a + b*x^4)^(7/4) + (21*a^2*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(1/4)) + (21*a^2*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(1/4))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^19/(a + b*x^4)^(1/4), x, 3, (a^4*(a + b*x^4)^(3/4))/(3*b^5) - (4*a^3*(a + b*x^4)^(7/4))/(7*b^5) + (6*a^2*(a + b*x^4)^(11/4))/(11*b^5) - (4*a*(a + b*x^4)^(15/4))/(15*b^5) + (a + b*x^4)^(19/4)/(19*b^5)}
{x^15/(a + b*x^4)^(1/4), x, 3, -(a^3*(a + b*x^4)^(3/4))/(3*b^4) + (3*a^2*(a + b*x^4)^(7/4))/(7*b^4) - (3*a*(a + b*x^4)^(11/4))/(11*b^4) + (a + b*x^4)^(15/4)/(15*b^4)}
{x^11/(a + b*x^4)^(1/4), x, 3, (a^2*(a + b*x^4)^(3/4))/(3*b^3) - (2*a*(a + b*x^4)^(7/4))/(7*b^3) + (a + b*x^4)^(11/4)/(11*b^3)}
{x^7/(a + b*x^4)^(1/4), x, 3, -(a*(a + b*x^4)^(3/4))/(3*b^2) + (a + b*x^4)^(7/4)/(7*b^2)}
{x^3/(a + b*x^4)^(1/4), x, 1, (a + b*x^4)^(3/4)/(3*b)}
{1/(x^1*(a + b*x^4)^(1/4)), x, 5, ArcTan[(a + b*x^4)^(1/4)/a^(1/4)]/(2*a^(1/4)) - ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)]/(2*a^(1/4))}
{1/(x^5*(a + b*x^4)^(1/4)), x, 6, -(a + b*x^4)^(3/4)/(4*a*x^4) - (b*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(5/4)) + (b*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(5/4))}
{1/(x^9*(a + b*x^4)^(1/4)), x, 7, -(a + b*x^4)^(3/4)/(8*a*x^8) + (5*b*(a + b*x^4)^(3/4))/(32*a^2*x^4) + (5*b^2*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(9/4)) - (5*b^2*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(9/4))}

{x^13/(a + b*x^4)^(1/4), x, 7, -((8*a^3*x^2)/(39*b^3*(a + b*x^4)^(1/4))) + (4*a^2*x^2*(a + b*x^4)^(3/4))/(39*b^3) - (10*a*x^6*(a + b*x^4)^(3/4))/(117*b^2) + (x^10*(a + b*x^4)^(3/4))/(13*b) + (8*a^(7/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(39*b^(7/2)*(a + b*x^4)^(1/4))}
{x^9/(a + b*x^4)^(1/4), x, 6, (4*a^2*x^2)/(15*b^2*(a + b*x^4)^(1/4)) - (2*a*x^2*(a + b*x^4)^(3/4))/(15*b^2) + (x^6*(a + b*x^4)^(3/4))/(9*b) - (4*a^(5/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(15*b^(5/2)*(a + b*x^4)^(1/4))}
{x^5/(a + b*x^4)^(1/4), x, 5, -((2*a*x^2)/(5*b*(a + b*x^4)^(1/4))) + (x^2*(a + b*x^4)^(3/4))/(5*b) + (2*a^(3/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*b^(3/2)*(a + b*x^4)^(1/4))}
{x^1/(a + b*x^4)^(1/4), x, 4, x^2/(a + b*x^4)^(1/4) - (Sqrt[a]*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[b]*(a + b*x^4)^(1/4))}
{1/(x^3*(a + b*x^4)^(1/4)), x, 5, (b*x^2)/(2*a*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/(2*a*x^2) - (Sqrt[b]*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[a]*(a + b*x^4)^(1/4))}
{1/(x^7*(a + b*x^4)^(1/4)), x, 6, -((b^2*x^2)/(4*a^2*(a + b*x^4)^(1/4))) - (a + b*x^4)^(3/4)/(6*a*x^6) + (b*(a + b*x^4)^(3/4))/(4*a^2*x^2) + (b^(3/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*a^(3/2)*(a + b*x^4)^(1/4))}
{1/(x^11*(a + b*x^4)^(1/4)), x, 7, (7*b^3*x^2)/(40*a^3*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/(10*a*x^10) + (7*b*(a + b*x^4)^(3/4))/(60*a^2*x^6) - (7*b^2*(a + b*x^4)^(3/4))/(40*a^3*x^2) - (7*b^(5/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*a^(5/2)*(a + b*x^4)^(1/4))}

{x^8/(a + b*x^4)^(1/4), x, 6, (-5*a*x*(a + b*x^4)^(3/4))/(32*b^2) + (x^5*(a + b*x^4)^(3/4))/(8*b) + (5*a^2*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(9/4)) + (5*a^2*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(9/4))}
{x^4/(a + b*x^4)^(1/4), x, 5, (x*(a + b*x^4)^(3/4))/(4*b) - (a*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(5/4)) - (a*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(5/4))}
{x^0/(a + b*x^4)^(1/4), x, 4, ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)]/(2*b^(1/4)) + ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)]/(2*b^(1/4))}
{1/(x^4*(a + b*x^4)^(1/4)), x, 1, -(a + b*x^4)^(3/4)/(3*a*x^3)}
{1/(x^8*(a + b*x^4)^(1/4)), x, 2, -(a + b*x^4)^(3/4)/(7*a*x^7) + (4*b*(a + b*x^4)^(3/4))/(21*a^2*x^3)}
{1/(x^12*(a + b*x^4)^(1/4)), x, 3, -(a + b*x^4)^(3/4)/(11*a*x^11) + (8*b*(a + b*x^4)^(3/4))/(77*a^2*x^7) - (32*b^2*(a + b*x^4)^(3/4))/(231*a^3*x^3)}
{1/(x^16*(a + b*x^4)^(1/4)), x, 4, -(a + b*x^4)^(3/4)/(15*a*x^15) + (4*b*(a + b*x^4)^(3/4))/(55*a^2*x^11) - (32*b^2*(a + b*x^4)^(3/4))/(385*a^3*x^7) + (128*b^3*(a + b*x^4)^(3/4))/(1155*a^4*x^3)}
{1/(x^20*(a + b*x^4)^(1/4)), x, 5, -(a + b*x^4)^(3/4)/(19*a*x^19) + (16*b*(a + b*x^4)^(3/4))/(285*a^2*x^15) - (64*b^2*(a + b*x^4)^(3/4))/(1045*a^3*x^11) + (512*b^3*(a + b*x^4)^(3/4))/(7315*a^4*x^7) - (2048*b^4*(a + b*x^4)^(3/4))/(21945*a^5*x^3)}

{x^10/(a + b*x^4)^(1/4), x, 7, (7*a^2*x^3)/(40*b^2*(a + b*x^4)^(1/4)) - (7*a*x^3*(a + b*x^4)^(3/4))/(60*b^2) + (x^7*(a + b*x^4)^(3/4))/(10*b) + (7*a^(5/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*b^(5/2)*(a + b*x^4)^(1/4))}
{x^6/(a + b*x^4)^(1/4), x, 6, -((a*x^3)/(4*b*(a + b*x^4)^(1/4))) + (x^3*(a + b*x^4)^(3/4))/(6*b) - (a^(3/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*b^(3/2)*(a + b*x^4)^(1/4))}
{x^2/(a + b*x^4)^(1/4), x, 5, x^3/(2*(a + b*x^4)^(1/4)) + (Sqrt[a]*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[b]*(a + b*x^4)^(1/4))}
{1/(x^2*(a + b*x^4)^(1/4)), x, 5, -(1/(x*(a + b*x^4)^(1/4))) + (Sqrt[b]*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[a]*(a + b*x^4)^(1/4))}
{1/(x^6*(a + b*x^4)^(1/4)), x, 6, (2*b)/(5*a*x*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/(5*a*x^5) - (2*b^(3/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*a^(3/2)*(a + b*x^4)^(1/4))}
{1/(x^10*(a + b*x^4)^(1/4)), x, 7, -((4*b^2)/(15*a^2*x*(a + b*x^4)^(1/4))) - (a + b*x^4)^(3/4)/(9*a*x^9) + (2*b*(a + b*x^4)^(3/4))/(15*a^2*x^5) + (4*b^(5/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(15*a^(5/2)*(a + b*x^4)^(1/4))}
{1/(x^14*(a + b*x^4)^(1/4)), x, 8, (8*b^3)/(39*a^3*x*(a + b*x^4)^(1/4)) - (a + b*x^4)^(3/4)/(13*a*x^13) + (10*b*(a + b*x^4)^(3/4))/(117*a^2*x^9) - (4*b^2*(a + b*x^4)^(3/4))/(39*a^3*x^5) - (8*b^(7/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(39*a^(7/2)*(a + b*x^4)^(1/4))}


{x^19/(a + b*x^4)^(3/4), x, 3, (a^4*(a + b*x^4)^(1/4))/b^5 - (4*a^3*(a + b*x^4)^(5/4))/(5*b^5) + (2*a^2*(a + b*x^4)^(9/4))/(3*b^5) - (4*a*(a + b*x^4)^(13/4))/(13*b^5) + (a + b*x^4)^(17/4)/(17*b^5)}
{x^15/(a + b*x^4)^(3/4), x, 3, -((a^3*(a + b*x^4)^(1/4))/b^4) + (3*a^2*(a + b*x^4)^(5/4))/(5*b^4) - (a*(a + b*x^4)^(9/4))/(3*b^4) + (a + b*x^4)^(13/4)/(13*b^4)}
{x^11/(a + b*x^4)^(3/4), x, 3, (a^2*(a + b*x^4)^(1/4))/b^3 - (2*a*(a + b*x^4)^(5/4))/(5*b^3) + (a + b*x^4)^(9/4)/(9*b^3)}
{x^7/(a + b*x^4)^(3/4), x, 3, -((a*(a + b*x^4)^(1/4))/b^2) + (a + b*x^4)^(5/4)/(5*b^2)}
{x^3/(a + b*x^4)^(3/4), x, 1, (a + b*x^4)^(1/4)/b}
{1/(x^1*(a + b*x^4)^(3/4)), x, 5, -ArcTan[(a + b*x^4)^(1/4)/a^(1/4)]/(2*a^(3/4)) - ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)]/(2*a^(3/4))}
{1/(x^5*(a + b*x^4)^(3/4)), x, 6, -(a + b*x^4)^(1/4)/(4*a*x^4) + (3*b*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(7/4)) + (3*b*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(7/4))}
{1/(x^9*(a + b*x^4)^(3/4)), x, 7, -(a + b*x^4)^(1/4)/(8*a*x^8) + (7*b*(a + b*x^4)^(1/4))/(32*a^2*x^4) - (21*b^2*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(11/4)) - (21*b^2*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(11/4))}

{x^13/(a + b*x^4)^(3/4), x, 6, (20*a^2*x^2*(a + b*x^4)^(1/4))/(77*b^3) - (10*a*x^6*(a + b*x^4)^(1/4))/(77*b^2) + (x^10*(a + b*x^4)^(1/4))/(11*b) - (40*a^(7/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*b^(7/2)*(a + b*x^4)^(3/4))}
{x^9/(a + b*x^4)^(3/4), x, 5, -((2*a*x^2*(a + b*x^4)^(1/4))/(7*b^2)) + (x^6*(a + b*x^4)^(1/4))/(7*b) + (4*a^(5/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(7*b^(5/2)*(a + b*x^4)^(3/4))}
{x^5/(a + b*x^4)^(3/4), x, 4, (x^2*(a + b*x^4)^(1/4))/(3*b) - (2*a^(3/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*b^(3/2)*(a + b*x^4)^(3/4))}
{x^1/(a + b*x^4)^(3/4), x, 3, (Sqrt[a]*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[b]*(a + b*x^4)^(3/4))}
{1/(x^3*(a + b*x^4)^(3/4)), x, 4, -((a + b*x^4)^(1/4)/(2*a*x^2)) - (Sqrt[b]*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[a]*(a + b*x^4)^(3/4))}
{1/(x^7*(a + b*x^4)^(3/4)), x, 5, -((a + b*x^4)^(1/4)/(6*a*x^6)) + (5*b*(a + b*x^4)^(1/4))/(12*a^2*x^2) + (5*b^(3/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*a^(3/2)*(a + b*x^4)^(3/4))}
{1/(x^11*(a + b*x^4)^(3/4)), x, 6, -((a + b*x^4)^(1/4)/(10*a*x^10)) + (3*b*(a + b*x^4)^(1/4))/(20*a^2*x^6) - (3*b^2*(a + b*x^4)^(1/4))/(8*a^3*x^2) - (3*b^(5/2)*(1 + (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(8*a^(5/2)*(a + b*x^4)^(3/4))}

{x^10/(a + b*x^4)^(3/4), x, 6, (-7*a*x^3*(a + b*x^4)^(1/4))/(32*b^2) + (x^7*(a + b*x^4)^(1/4))/(8*b) - (21*a^2*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(11/4)) + (21*a^2*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(11/4))}
{x^6/(a + b*x^4)^(3/4), x, 5, (x^3*(a + b*x^4)^(1/4))/(4*b) + (3*a*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(7/4)) - (3*a*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(7/4))}
{x^2/(a + b*x^4)^(3/4), x, 4, -ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)]/(2*b^(3/4)) + ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)]/(2*b^(3/4))}
{1/(x^2*(a + b*x^4)^(3/4)), x, 1, -((a + b*x^4)^(1/4)/(a*x))}
{1/(x^6*(a + b*x^4)^(3/4)), x, 2, -(a + b*x^4)^(1/4)/(5*a*x^5) + (4*b*(a + b*x^4)^(1/4))/(5*a^2*x)}
{1/(x^10*(a + b*x^4)^(3/4)), x, 3, -(a + b*x^4)^(1/4)/(9*a*x^9) + (8*b*(a + b*x^4)^(1/4))/(45*a^2*x^5) - (32*b^2*(a + b*x^4)^(1/4))/(45*a^3*x)}
{1/(x^14*(a + b*x^4)^(3/4)), x, 4, -(a + b*x^4)^(1/4)/(13*a*x^13) + (4*b*(a + b*x^4)^(1/4))/(39*a^2*x^9) - (32*b^2*(a + b*x^4)^(1/4))/(195*a^3*x^5) + (128*b^3*(a + b*x^4)^(1/4))/(195*a^4*x)}

{x^12/(a + b*x^4)^(3/4), x, 7, (3*a^2*x*(a + b*x^4)^(1/4))/(8*b^3) - (3*a*x^5*(a + b*x^4)^(1/4))/(20*b^2) + (x^9*(a + b*x^4)^(1/4))/(10*b) + (3*a^(5/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(8*b^(5/2)*(a + b*x^4)^(3/4))}
{x^8/(a + b*x^4)^(3/4), x, 6, -((5*a*x*(a + b*x^4)^(1/4))/(12*b^2)) + (x^5*(a + b*x^4)^(1/4))/(6*b) - (5*a^(3/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*b^(3/2)*(a + b*x^4)^(3/4))}
{x^4/(a + b*x^4)^(3/4), x, 5, (x*(a + b*x^4)^(1/4))/(2*b) + (Sqrt[a]*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[b]*(a + b*x^4)^(3/4))}
{x^0/(a + b*x^4)^(3/4), x, 4, -((Sqrt[b]*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[a]*(a + b*x^4)^(3/4)))}
{1/(x^4*(a + b*x^4)^(3/4)), x, 5, -((a + b*x^4)^(1/4)/(3*a*x^3)) + (2*b^(3/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*a^(3/2)*(a + b*x^4)^(3/4))}
{1/(x^8*(a + b*x^4)^(3/4)), x, 6, -((a + b*x^4)^(1/4)/(7*a*x^7)) + (2*b*(a + b*x^4)^(1/4))/(7*a^2*x^3) - (4*b^(5/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(7*a^(5/2)*(a + b*x^4)^(3/4))}
{1/(x^12*(a + b*x^4)^(3/4)), x, 7, -((a + b*x^4)^(1/4)/(11*a*x^11)) + (10*b*(a + b*x^4)^(1/4))/(77*a^2*x^7) - (20*b^2*(a + b*x^4)^(1/4))/(77*a^3*x^3) + (40*b^(7/2)*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*a^(7/2)*(a + b*x^4)^(3/4))}


{x^19/(a + b*x^4)^(5/4), x, 3, -(a^4/(b^5*(a + b*x^4)^(1/4))) - (4*a^3*(a + b*x^4)^(3/4))/(3*b^5) + (6*a^2*(a + b*x^4)^(7/4))/(7*b^5) - (4*a*(a + b*x^4)^(11/4))/(11*b^5) + (a + b*x^4)^(15/4)/(15*b^5)}
{x^15/(a + b*x^4)^(5/4), x, 3, a^3/(b^4*(a + b*x^4)^(1/4)) + (a^2*(a + b*x^4)^(3/4))/b^4 - (3*a*(a + b*x^4)^(7/4))/(7*b^4) + (a + b*x^4)^(11/4)/(11*b^4)}
{x^11/(a + b*x^4)^(5/4), x, 3, -(a^2/(b^3*(a + b*x^4)^(1/4))) - (2*a*(a + b*x^4)^(3/4))/(3*b^3) + (a + b*x^4)^(7/4)/(7*b^3)}
{x^7/(a + b*x^4)^(5/4), x, 3, a/(b^2*(a + b*x^4)^(1/4)) + (a + b*x^4)^(3/4)/(3*b^2)}
{x^3/(a + b*x^4)^(5/4), x, 1, -(1/(b*(a + b*x^4)^(1/4)))}
{1/(x^1*(a + b*x^4)^(5/4)), x, 6, 1/(a*(a + b*x^4)^(1/4)) + ArcTan[(a + b*x^4)^(1/4)/a^(1/4)]/(2*a^(5/4)) - ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)]/(2*a^(5/4))}
{1/(x^5*(a + b*x^4)^(5/4)), x, 7, -((5*b)/(4*a^2*(a + b*x^4)^(1/4))) - 1/(4*a*x^4*(a + b*x^4)^(1/4)) - (5*b*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(9/4)) + (5*b*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(8*a^(9/4))}
{1/(x^9*(a + b*x^4)^(5/4)), x, 8, (45*b^2)/(32*a^3*(a + b*x^4)^(1/4)) - 1/(8*a*x^8*(a + b*x^4)^(1/4)) + (9*b)/(32*a^2*x^4*(a + b*x^4)^(1/4)) + (45*b^2*ArcTan[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(13/4)) - (45*b^2*ArcTanh[(a + b*x^4)^(1/4)/a^(1/4)])/(64*a^(13/4))}

{x^13/(a + b*x^4)^(5/4), x, 6, (4*a^2*x^2)/(3*b^3*(a + b*x^4)^(1/4)) - (2*a*x^6)/(9*b^2*(a + b*x^4)^(1/4)) + x^10/(9*b*(a + b*x^4)^(1/4)) - (8*a^(5/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*b^(7/2)*(a + b*x^4)^(1/4))}
{x^9/(a + b*x^4)^(5/4), x, 5, -((6*a*x^2)/(5*b^2*(a + b*x^4)^(1/4))) + x^6/(5*b*(a + b*x^4)^(1/4)) + (12*a^(3/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*b^(5/2)*(a + b*x^4)^(1/4))}
{x^5/(a + b*x^4)^(5/4), x, 4, x^2/(b*(a + b*x^4)^(1/4)) - (2*Sqrt[a]*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(b^(3/2)*(a + b*x^4)^(1/4))}
{x^1/(a + b*x^4)^(5/4), x, 3, ((1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[a]*Sqrt[b]*(a + b*x^4)^(1/4))}
{1/(x^3*(a + b*x^4)^(5/4)), x, 4, -(1/(2*a*x^2*(a + b*x^4)^(1/4))) - (3*Sqrt[b]*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*a^(3/2)*(a + b*x^4)^(1/4))}
{1/(x^7*(a + b*x^4)^(5/4)), x, 5, -(1/(6*a*x^6*(a + b*x^4)^(1/4))) + (7*b)/(12*a^2*x^2*(a + b*x^4)^(1/4)) + (7*b^(3/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*a^(5/2)*(a + b*x^4)^(1/4))}
{1/(x^11*(a + b*x^4)^(5/4)), x, 6, -(1/(10*a*x^10*(a + b*x^4)^(1/4))) + (11*b)/(60*a^2*x^6*(a + b*x^4)^(1/4)) - (77*b^2)/(120*a^3*x^2*(a + b*x^4)^(1/4)) - (77*b^(5/2)*(1 + (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcTan[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*a^(7/2)*(a + b*x^4)^(1/4))}

{x^12/(a + b*x^4)^(5/4), x, 7, -(x^9/(b*(a + b*x^4)^(1/4))) - (45*a*x*(a + b*x^4)^(3/4))/(32*b^3) + (9*x^5*(a + b*x^4)^(3/4))/(8*b^2) + (45*a^2*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(13/4)) + (45*a^2*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(64*b^(13/4))}
{x^8/(a + b*x^4)^(5/4), x, 6, -(x^5/(b*(a + b*x^4)^(1/4))) + (5*x*(a + b*x^4)^(3/4))/(4*b^2) - (5*a*ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(9/4)) - (5*a*ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)])/(8*b^(9/4))}
{x^4/(a + b*x^4)^(5/4), x, 5, -(x/(b*(a + b*x^4)^(1/4))) + ArcTan[(b^(1/4)*x)/(a + b*x^4)^(1/4)]/(2*b^(5/4)) + ArcTanh[(b^(1/4)*x)/(a + b*x^4)^(1/4)]/(2*b^(5/4))}
{x^0/(a + b*x^4)^(5/4), x, 1, x/(a*(a + b*x^4)^(1/4))}
{1/(x^4*(a + b*x^4)^(5/4)), x, 2, -1/(3*a*x^3*(a + b*x^4)^(1/4)) - (4*b*x)/(3*a^2*(a + b*x^4)^(1/4))}
{1/(x^8*(a + b*x^4)^(5/4)), x, 3, -1/(7*a*x^7*(a + b*x^4)^(1/4)) + (8*b)/(21*a^2*x^3*(a + b*x^4)^(1/4)) + (32*b^2*x)/(21*a^3*(a + b*x^4)^(1/4))}
{1/(x^12*(a + b*x^4)^(5/4)), x, 4, -1/(11*a*x^11*(a + b*x^4)^(1/4)) + (12*b)/(77*a^2*x^7*(a + b*x^4)^(1/4)) - (32*b^2)/(77*a^3*x^3*(a + b*x^4)^(1/4)) - (128*b^3*x)/(77*a^4*(a + b*x^4)^(1/4))}
{1/(x^16*(a + b*x^4)^(5/4)), x, 5, -1/(15*a*x^15*(a + b*x^4)^(1/4)) + (16*b)/(165*a^2*x^11*(a + b*x^4)^(1/4)) - (64*b^2)/(385*a^3*x^7*(a + b*x^4)^(1/4)) + (512*b^3)/(1155*a^4*x^3*(a + b*x^4)^(1/4)) + (2048*b^4*x)/(1155*a^5*(a + b*x^4)^(1/4))}

{x^14/(a + b*x^4)^(5/4), x, 7, (77*a^2*x^3)/(120*b^3*(a + b*x^4)^(1/4)) - (11*a*x^7)/(60*b^2*(a + b*x^4)^(1/4)) + x^11/(10*b*(a + b*x^4)^(1/4)) + (77*a^(5/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*b^(7/2)*(a + b*x^4)^(1/4))}
{x^10/(a + b*x^4)^(5/4), x, 6, -((7*a*x^3)/(12*b^2*(a + b*x^4)^(1/4))) + x^7/(6*b*(a + b*x^4)^(1/4)) - (7*a^(3/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*b^(5/2)*(a + b*x^4)^(1/4))}
{x^6/(a + b*x^4)^(5/4), x, 5, x^3/(2*b*(a + b*x^4)^(1/4)) + (3*Sqrt[a]*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*b^(3/2)*(a + b*x^4)^(1/4))}
{x^2/(a + b*x^4)^(5/4), x, 4, -(((1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[a]*Sqrt[b]*(a + b*x^4)^(1/4)))}
{1/(x^2*(a + b*x^4)^(5/4)), x, 5, -(1/(a*x*(a + b*x^4)^(1/4))) + (2*Sqrt[b]*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(a^(3/2)*(a + b*x^4)^(1/4))}
{1/(x^6*(a + b*x^4)^(5/4)), x, 6, -(1/(5*a*x^5*(a + b*x^4)^(1/4))) + (6*b)/(5*a^2*x*(a + b*x^4)^(1/4)) - (12*b^(3/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*a^(5/2)*(a + b*x^4)^(1/4))}
{1/(x^10*(a + b*x^4)^(5/4)), x, 7, -(1/(9*a*x^9*(a + b*x^4)^(1/4))) + (2*b)/(9*a^2*x^5*(a + b*x^4)^(1/4)) - (4*b^2)/(3*a^3*x*(a + b*x^4)^(1/4)) + (8*b^(5/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*a^(7/2)*(a + b*x^4)^(1/4))}
{1/(x^14*(a + b*x^4)^(5/4)), x, 8, -(1/(13*a*x^13*(a + b*x^4)^(1/4))) + (14*b)/(117*a^2*x^9*(a + b*x^4)^(1/4)) - (28*b^2)/(117*a^3*x^5*(a + b*x^4)^(1/4)) + (56*b^3)/(39*a^4*x*(a + b*x^4)^(1/4)) - (112*b^(7/2)*(1 + a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(39*a^(9/2)*(a + b*x^4)^(1/4))}


{1/(a + b*x^4)^(7/4), x, 5, x/(3*a*(a + b*x^4)^(3/4)) - (2*Sqrt[b]*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*a^(3/2)*(a + b*x^4)^(3/4))}


{1/(a + b*x^4)^(9/4), x, 2, x/(5*a*(a + b*x^4)^(5/4)) + (4*x)/(5*a^2*(a + b*x^4)^(1/4))}


{1/(a + b*x^4)^(11/4), x, 6, x/(7*a*(a + b*x^4)^(7/4)) + (2*x)/(7*a^2*(a + b*x^4)^(3/4)) - (4*Sqrt[b]*(1 + a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCot[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(7*a^(5/2)*(a + b*x^4)^(3/4))}


{1/(a + b*x^4)^(13/4), x, 3, x/(9*a*(a + b*x^4)^(9/4)) + (8*x)/(45*a^2*(a + b*x^4)^(5/4)) + (32*x)/(45*a^3*(a + b*x^4)^(1/4))}
{1/(a + b*x^4)^(17/4), x, 4, x/(13*a*(a + b*x^4)^(13/4)) + (4*x)/(39*a^2*(a + b*x^4)^(9/4)) + (32*x)/(195*a^3*(a + b*x^4)^(5/4)) + (128*x)/(195*a^4*(a + b*x^4)^(1/4))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a-b x^4)^(p/4)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^19*(a - b*x^4)^(1/4), x, 3, -((a^4*(a - b*x^4)^(5/4))/(5*b^5)) + (4*a^3*(a - b*x^4)^(9/4))/(9*b^5) - (6*a^2*(a - b*x^4)^(13/4))/(13*b^5) + (4*a*(a - b*x^4)^(17/4))/(17*b^5) - (a - b*x^4)^(21/4)/(21*b^5)}
{x^15*(a - b*x^4)^(1/4), x, 3, -((a^3*(a - b*x^4)^(5/4))/(5*b^4)) + (a^2*(a - b*x^4)^(9/4))/(3*b^4) - (3*a*(a - b*x^4)^(13/4))/(13*b^4) + (a - b*x^4)^(17/4)/(17*b^4)}
{x^11*(a - b*x^4)^(1/4), x, 3, -((a^2*(a - b*x^4)^(5/4))/(5*b^3)) + (2*a*(a - b*x^4)^(9/4))/(9*b^3) - (a - b*x^4)^(13/4)/(13*b^3)}
{x^7*(a - b*x^4)^(1/4), x, 3, -((a*(a - b*x^4)^(5/4))/(5*b^2)) + (a - b*x^4)^(9/4)/(9*b^2)}
{x^3*(a - b*x^4)^(1/4), x, 1, -((a - b*x^4)^(5/4)/(5*b))}
{(a - b*x^4)^(1/4)/x^1, x, 6, (a - b*x^4)^(1/4) - (1/2)*a^(1/4)*ArcTan[(a - b*x^4)^(1/4)/a^(1/4)] - (1/2)*a^(1/4)*ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)]}
{(a - b*x^4)^(1/4)/x^5, x, 6, -((a - b*x^4)^(1/4)/(4*x^4)) + (b*ArcTan[(a - b*x^4)^(1/4)/a^(1/4)])/(8*a^(3/4)) + (b*ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)])/(8*a^(3/4))}
{(a - b*x^4)^(1/4)/x^9, x, 7, -((a - b*x^4)^(1/4)/(8*x^8)) + (b*(a - b*x^4)^(1/4))/(32*a*x^4) + (3*b^2*ArcTan[(a - b*x^4)^(1/4)/a^(1/4)])/(64*a^(7/4)) + (3*b^2*ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)])/(64*a^(7/4))}

{x^9*(a - b*x^4)^(1/4), x, 6, -((2*a^2*x^2*(a - b*x^4)^(1/4))/(77*b^2)) - (a*x^6*(a - b*x^4)^(1/4))/(77*b) + (1/11)*x^10*(a - b*x^4)^(1/4) + (4*a^(7/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*b^(5/2)*(a - b*x^4)^(3/4))}
{x^5*(a - b*x^4)^(1/4), x, 5, -((a*x^2*(a - b*x^4)^(1/4))/(21*b)) + (1/7)*x^6*(a - b*x^4)^(1/4) + (2*a^(5/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(21*b^(3/2)*(a - b*x^4)^(3/4))}
{x^1*(a - b*x^4)^(1/4), x, 4, (1/3)*x^2*(a - b*x^4)^(1/4) + (a^(3/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*Sqrt[b]*(a - b*x^4)^(3/4))}
{(a - b*x^4)^(1/4)/x^3, x, 4, -((a - b*x^4)^(1/4)/(2*x^2)) - (Sqrt[a]*Sqrt[b]*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*(a - b*x^4)^(3/4))}
{(a - b*x^4)^(1/4)/x^7, x, 5, -((a - b*x^4)^(1/4)/(6*x^6)) + (b*(a - b*x^4)^(1/4))/(12*a*x^2) - (b^(3/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*Sqrt[a]*(a - b*x^4)^(3/4))}
{(a - b*x^4)^(1/4)/x^11, x, 6, -((a - b*x^4)^(1/4)/(10*x^10)) + (b*(a - b*x^4)^(1/4))/(60*a*x^6) + (b^2*(a - b*x^4)^(1/4))/(24*a^2*x^2) - (b^(5/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(24*a^(3/2)*(a - b*x^4)^(3/4))}

{x^6*(a - b*x^4)^(1/4), x, 12, -((a*x^3*(a - b*x^4)^(1/4))/(32*b)) + (1/8)*x^7*(a - b*x^4)^(1/4) - (3*a^2*ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(64*Sqrt[2]*b^(7/4)) + (3*a^2*ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(64*Sqrt[2]*b^(7/4)) + (3*a^2*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(128*Sqrt[2]*b^(7/4)) - (3*a^2*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(128*Sqrt[2]*b^(7/4))}
{x^2*(a - b*x^4)^(1/4), x, 11, (1/4)*x^3*(a - b*x^4)^(1/4) - (a*ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(8*Sqrt[2]*b^(3/4)) + (a*ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(8*Sqrt[2]*b^(3/4)) + (a*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(16*Sqrt[2]*b^(3/4)) - (a*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(16*Sqrt[2]*b^(3/4))}
{(a - b*x^4)^(1/4)/x^2, x, 11, -((a - b*x^4)^(1/4)/x) + (b^(1/4)*ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(2*Sqrt[2]) - (b^(1/4)*ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(2*Sqrt[2]) - (b^(1/4)*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(4*Sqrt[2]) + (b^(1/4)*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(4*Sqrt[2])}
{(a - b*x^4)^(1/4)/x^6, x, 1, -((a - b*x^4)^(5/4)/(5*a*x^5))}
{(a - b*x^4)^(1/4)/x^10, x, 2, -((a - b*x^4)^(5/4)/(9*a*x^9)) - (4*b*(a - b*x^4)^(5/4))/(45*a^2*x^5)}
{(a - b*x^4)^(1/4)/x^14, x, 3, -((a - b*x^4)^(5/4)/(13*a*x^13)) - (8*b*(a - b*x^4)^(5/4))/(117*a^2*x^9) - (32*b^2*(a - b*x^4)^(5/4))/(585*a^3*x^5)}
{(a - b*x^4)^(1/4)/x^18, x, 4, -((a - b*x^4)^(5/4)/(17*a*x^17)) - (12*b*(a - b*x^4)^(5/4))/(221*a^2*x^13) - (32*b^2*(a - b*x^4)^(5/4))/(663*a^3*x^9) - (128*b^3*(a - b*x^4)^(5/4))/(3315*a^4*x^5)}

{x^12*(a - b*x^4)^(1/4), x, 8, -((3*a^3*x*(a - b*x^4)^(1/4))/(112*b^3)) - (3*a^2*x^5*(a - b*x^4)^(1/4))/(280*b^2) - (a*x^9*(a - b*x^4)^(1/4))/(140*b) + (1/14)*x^13*(a - b*x^4)^(1/4) - (3*a^(7/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(112*b^(5/2)*(a - b*x^4)^(3/4))}
{x^8*(a - b*x^4)^(1/4), x, 7, -((a^2*x*(a - b*x^4)^(1/4))/(24*b^2)) - (a*x^5*(a - b*x^4)^(1/4))/(60*b) + (1/10)*x^9*(a - b*x^4)^(1/4) - (a^(5/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(24*b^(3/2)*(a - b*x^4)^(3/4))}
{x^4*(a - b*x^4)^(1/4), x, 6, -((a*x*(a - b*x^4)^(1/4))/(12*b)) + (1/6)*x^5*(a - b*x^4)^(1/4) - (a^(3/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*Sqrt[b]*(a - b*x^4)^(3/4))}
{x^0*(a - b*x^4)^(1/4), x, 5, (1/2)*x*(a - b*x^4)^(1/4) - (Sqrt[a]*Sqrt[b]*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*(a - b*x^4)^(3/4))}
{(a - b*x^4)^(1/4)/x^4, x, 5, -((a - b*x^4)^(1/4)/(3*x^3)) + (b^(3/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*Sqrt[a]*(a - b*x^4)^(3/4))}
{(a - b*x^4)^(1/4)/x^8, x, 6, -((a - b*x^4)^(1/4)/(7*x^7)) + (b*(a - b*x^4)^(1/4))/(21*a*x^3) + (2*b^(5/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(21*a^(3/2)*(a - b*x^4)^(3/4))}
{(a - b*x^4)^(1/4)/x^12, x, 7, -((a - b*x^4)^(1/4)/(11*x^11)) + (b*(a - b*x^4)^(1/4))/(77*a*x^7) + (2*b^2*(a - b*x^4)^(1/4))/(77*a^2*x^3) + (4*b^(7/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*a^(5/2)*(a - b*x^4)^(3/4))}
{(a - b*x^4)^(1/4)/x^16, x, 8, -((a - b*x^4)^(1/4)/(15*x^15)) + (b*(a - b*x^4)^(1/4))/(165*a*x^11) + (2*b^2*(a - b*x^4)^(1/4))/(231*a^2*x^7) + (4*b^3*(a - b*x^4)^(1/4))/(231*a^3*x^3) + (8*b^(9/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(231*a^(7/2)*(a - b*x^4)^(3/4))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^19/(a - b*x^4)^(1/4), x, 3, -((a^4*(a - b*x^4)^(3/4))/(3*b^5)) + (4*a^3*(a - b*x^4)^(7/4))/(7*b^5) - (6*a^2*(a - b*x^4)^(11/4))/(11*b^5) + (4*a*(a - b*x^4)^(15/4))/(15*b^5) - (a - b*x^4)^(19/4)/(19*b^5)}
{x^15/(a - b*x^4)^(1/4), x, 3, -((a^3*(a - b*x^4)^(3/4))/(3*b^4)) + (3*a^2*(a - b*x^4)^(7/4))/(7*b^4) - (3*a*(a - b*x^4)^(11/4))/(11*b^4) + (a - b*x^4)^(15/4)/(15*b^4)}
{x^11/(a - b*x^4)^(1/4), x, 3, -((a^2*(a - b*x^4)^(3/4))/(3*b^3)) + (2*a*(a - b*x^4)^(7/4))/(7*b^3) - (a - b*x^4)^(11/4)/(11*b^3)}
{x^7/(a - b*x^4)^(1/4), x, 3, -((a*(a - b*x^4)^(3/4))/(3*b^2)) + (a - b*x^4)^(7/4)/(7*b^2)}
{x^3/(a - b*x^4)^(1/4), x, 1, -((a - b*x^4)^(3/4)/(3*b))}
{1/(x^1*(a - b*x^4)^(1/4)), x, 5, ArcTan[(a - b*x^4)^(1/4)/a^(1/4)]/(2*a^(1/4)) - ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)]/(2*a^(1/4))}
{1/(x^5*(a - b*x^4)^(1/4)), x, 6, -((a - b*x^4)^(3/4)/(4*a*x^4)) + (b*ArcTan[(a - b*x^4)^(1/4)/a^(1/4)])/(8*a^(5/4)) - (b*ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)])/(8*a^(5/4))}
{1/(x^9*(a - b*x^4)^(1/4)), x, 7, -((a - b*x^4)^(3/4)/(8*a*x^8)) - (5*b*(a - b*x^4)^(3/4))/(32*a^2*x^4) + (5*b^2*ArcTan[(a - b*x^4)^(1/4)/a^(1/4)])/(64*a^(9/4)) - (5*b^2*ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)])/(64*a^(9/4))}

{x^13/(a - b*x^4)^(1/4), x, 6, -((4*a^2*x^2*(a - b*x^4)^(3/4))/(39*b^3)) - (10*a*x^6*(a - b*x^4)^(3/4))/(117*b^2) - (x^10*(a - b*x^4)^(3/4))/(13*b) + (8*a^(7/2)*(1 - (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(39*b^(7/2)*(a - b*x^4)^(1/4))}
{x^9/(a - b*x^4)^(1/4), x, 5, -((2*a*x^2*(a - b*x^4)^(3/4))/(15*b^2)) - (x^6*(a - b*x^4)^(3/4))/(9*b) + (4*a^(5/2)*(1 - (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(15*b^(5/2)*(a - b*x^4)^(1/4))}
{x^5/(a - b*x^4)^(1/4), x, 4, -((x^2*(a - b*x^4)^(3/4))/(5*b)) + (2*a^(3/2)*(1 - (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*b^(3/2)*(a - b*x^4)^(1/4))}
{x^1/(a - b*x^4)^(1/4), x, 3, (Sqrt[a]*(1 - (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[b]*(a - b*x^4)^(1/4))}
{1/(x^3*(a - b*x^4)^(1/4)), x, 4, -((a - b*x^4)^(3/4)/(2*a*x^2)) - (Sqrt[b]*(1 - (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[a]*(a - b*x^4)^(1/4))}
{1/(x^7*(a - b*x^4)^(1/4)), x, 5, -((a - b*x^4)^(3/4)/(6*a*x^6)) - (b*(a - b*x^4)^(3/4))/(4*a^2*x^2) - (b^(3/2)*(1 - (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*a^(3/2)*(a - b*x^4)^(1/4))}
{1/(x^11*(a - b*x^4)^(1/4)), x, 6, -((a - b*x^4)^(3/4)/(10*a*x^10)) - (7*b*(a - b*x^4)^(3/4))/(60*a^2*x^6) - (7*b^2*(a - b*x^4)^(3/4))/(40*a^3*x^2) - (7*b^(5/2)*(1 - (b*x^4)/a)^(1/4)*EllipticE[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*a^(5/2)*(a - b*x^4)^(1/4))}

{x^8/(a - b*x^4)^(1/4), x, 12, -((5*a*x*(a - b*x^4)^(3/4))/(32*b^2)) - (x^5*(a - b*x^4)^(3/4))/(8*b) - (5*a^2*ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(64*Sqrt[2]*b^(9/4)) + (5*a^2*ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(64*Sqrt[2]*b^(9/4)) - (5*a^2*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(128*Sqrt[2]*b^(9/4)) + (5*a^2*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(128*Sqrt[2]*b^(9/4))}
{x^4/(a - b*x^4)^(1/4), x, 11, -((x*(a - b*x^4)^(3/4))/(4*b)) - (a*ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(8*Sqrt[2]*b^(5/4)) + (a*ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(8*Sqrt[2]*b^(5/4)) - (a*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(16*Sqrt[2]*b^(5/4)) + (a*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(16*Sqrt[2]*b^(5/4))}
{x^0/(a - b*x^4)^(1/4), x, 10, -(ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(2*Sqrt[2]*b^(1/4))) + ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(2*Sqrt[2]*b^(1/4)) - Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(4*Sqrt[2]*b^(1/4)) + Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(4*Sqrt[2]*b^(1/4))}
{1/(x^4*(a - b*x^4)^(1/4)), x, 1, -((a - b*x^4)^(3/4)/(3*a*x^3))}
{1/(x^8*(a - b*x^4)^(1/4)), x, 2, -((a - b*x^4)^(3/4)/(7*a*x^7)) - (4*b*(a - b*x^4)^(3/4))/(21*a^2*x^3)}
{1/(x^12*(a - b*x^4)^(1/4)), x, 3, -((a - b*x^4)^(3/4)/(11*a*x^11)) - (8*b*(a - b*x^4)^(3/4))/(77*a^2*x^7) - (32*b^2*(a - b*x^4)^(3/4))/(231*a^3*x^3)}
{1/(x^16*(a - b*x^4)^(1/4)), x, 4, -((a - b*x^4)^(3/4)/(15*a*x^15)) - (4*b*(a - b*x^4)^(3/4))/(55*a^2*x^11) - (32*b^2*(a - b*x^4)^(3/4))/(385*a^3*x^7) - (128*b^3*(a - b*x^4)^(3/4))/(1155*a^4*x^3)}
{1/(x^20*(a - b*x^4)^(1/4)), x, 5, -((a - b*x^4)^(3/4)/(19*a*x^19)) - (16*b*(a - b*x^4)^(3/4))/(285*a^2*x^15) - (64*b^2*(a - b*x^4)^(3/4))/(1045*a^3*x^11) - (512*b^3*(a - b*x^4)^(3/4))/(7315*a^4*x^7) - (2048*b^4*(a - b*x^4)^(3/4))/(21945*a^5*x^3)}

{x^10/(a - b*x^4)^(1/4), x, 7, -((7*a^2*(a - b*x^4)^(3/4))/(40*b^3*x)) - (7*a*x^3*(a - b*x^4)^(3/4))/(60*b^2) - (x^7*(a - b*x^4)^(3/4))/(10*b) + (7*a^(5/2)*(1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(40*b^(5/2)*(a - b*x^4)^(1/4))}
{x^6/(a - b*x^4)^(1/4), x, 6, -((a*(a - b*x^4)^(3/4))/(4*b^2*x)) - (x^3*(a - b*x^4)^(3/4))/(6*b) + (a^(3/2)*(1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(4*b^(3/2)*(a - b*x^4)^(1/4))}
{x^2/(a - b*x^4)^(1/4), x, 5, -((a - b*x^4)^(3/4)/(2*b*x)) + (Sqrt[a]*(1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[b]*(a - b*x^4)^(1/4))}
{1/(x^2*(a - b*x^4)^(1/4)), x, 4, -((Sqrt[b]*(1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[a]*(a - b*x^4)^(1/4)))}
{1/(x^6*(a - b*x^4)^(1/4)), x, 5, -((a - b*x^4)^(3/4)/(5*a*x^5)) - (2*b^(3/2)*(1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(5*a^(3/2)*(a - b*x^4)^(1/4))}
{1/(x^10*(a - b*x^4)^(1/4)), x, 6, -((a - b*x^4)^(3/4)/(9*a*x^9)) - (2*b*(a - b*x^4)^(3/4))/(15*a^2*x^5) - (4*b^(5/2)*(1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(15*a^(5/2)*(a - b*x^4)^(1/4))}
{1/(x^14*(a - b*x^4)^(1/4)), x, 7, -((a - b*x^4)^(3/4)/(13*a*x^13)) - (10*b*(a - b*x^4)^(3/4))/(117*a^2*x^9) - (4*b^2*(a - b*x^4)^(3/4))/(39*a^3*x^5) - (8*b^(7/2)*(1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(39*a^(7/2)*(a - b*x^4)^(1/4))}


{x^19/(a - b*x^4)^(3/4), x, 3, -((a^4*(a - b*x^4)^(1/4))/b^5) + (4*a^3*(a - b*x^4)^(5/4))/(5*b^5) - (2*a^2*(a - b*x^4)^(9/4))/(3*b^5) + (4*a*(a - b*x^4)^(13/4))/(13*b^5) - (a - b*x^4)^(17/4)/(17*b^5)}
{x^15/(a - b*x^4)^(3/4), x, 3, -((a^3*(a - b*x^4)^(1/4))/b^4) + (3*a^2*(a - b*x^4)^(5/4))/(5*b^4) - (a*(a - b*x^4)^(9/4))/(3*b^4) + (a - b*x^4)^(13/4)/(13*b^4)}
{x^11/(a - b*x^4)^(3/4), x, 3, -((a^2*(a - b*x^4)^(1/4))/b^3) + (2*a*(a - b*x^4)^(5/4))/(5*b^3) - (a - b*x^4)^(9/4)/(9*b^3)}
{x^7/(a - b*x^4)^(3/4), x, 3, -((a*(a - b*x^4)^(1/4))/b^2) + (a - b*x^4)^(5/4)/(5*b^2)}
{x^3/(a - b*x^4)^(3/4), x, 1, -((a - b*x^4)^(1/4)/b)}
{1/(x^1*(a - b*x^4)^(3/4)), x, 5, -(ArcTan[(a - b*x^4)^(1/4)/a^(1/4)]/(2*a^(3/4))) - ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)]/(2*a^(3/4))}
{1/(x^5*(a - b*x^4)^(3/4)), x, 6, -((a - b*x^4)^(1/4)/(4*a*x^4)) - (3*b*ArcTan[(a - b*x^4)^(1/4)/a^(1/4)])/(8*a^(7/4)) - (3*b*ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)])/(8*a^(7/4))}
{1/(x^9*(a - b*x^4)^(3/4)), x, 7, -((a - b*x^4)^(1/4)/(8*a*x^8)) - (7*b*(a - b*x^4)^(1/4))/(32*a^2*x^4) - (21*b^2*ArcTan[(a - b*x^4)^(1/4)/a^(1/4)])/(64*a^(11/4)) - (21*b^2*ArcTanh[(a - b*x^4)^(1/4)/a^(1/4)])/(64*a^(11/4))}

{x^13/(a - b*x^4)^(3/4), x, 6, -((20*a^2*x^2*(a - b*x^4)^(1/4))/(77*b^3)) - (10*a*x^6*(a - b*x^4)^(1/4))/(77*b^2) - (x^10*(a - b*x^4)^(1/4))/(11*b) + (40*a^(7/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*b^(7/2)*(a - b*x^4)^(3/4))}
{x^9/(a - b*x^4)^(3/4), x, 5, -((2*a*x^2*(a - b*x^4)^(1/4))/(7*b^2)) - (x^6*(a - b*x^4)^(1/4))/(7*b) + (4*a^(5/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(7*b^(5/2)*(a - b*x^4)^(3/4))}
{x^5/(a - b*x^4)^(3/4), x, 4, -((x^2*(a - b*x^4)^(1/4))/(3*b)) + (2*a^(3/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*b^(3/2)*(a - b*x^4)^(3/4))}
{x^1/(a - b*x^4)^(3/4), x, 3, (Sqrt[a]*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[b]*(a - b*x^4)^(3/4))}
{1/(x^3*(a - b*x^4)^(3/4)), x, 4, -((a - b*x^4)^(1/4)/(2*a*x^2)) + (Sqrt[b]*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[a]*(a - b*x^4)^(3/4))}
{1/(x^7*(a - b*x^4)^(3/4)), x, 5, -((a - b*x^4)^(1/4)/(6*a*x^6)) - (5*b*(a - b*x^4)^(1/4))/(12*a^2*x^2) + (5*b^(3/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*a^(3/2)*(a - b*x^4)^(3/4))}
{1/(x^11*(a - b*x^4)^(3/4)), x, 6, -((a - b*x^4)^(1/4)/(10*a*x^10)) - (3*b*(a - b*x^4)^(1/4))/(20*a^2*x^6) - (3*b^2*(a - b*x^4)^(1/4))/(8*a^3*x^2) + (3*b^(5/2)*(1 - (b*x^4)/a)^(3/4)*EllipticF[(1/2)*ArcSin[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(8*a^(5/2)*(a - b*x^4)^(3/4))}

{x^10/(a - b*x^4)^(3/4), x, 12, -((7*a*x^3*(a - b*x^4)^(1/4))/(32*b^2)) - (x^7*(a - b*x^4)^(1/4))/(8*b) - (21*a^2*ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(64*Sqrt[2]*b^(11/4)) + (21*a^2*ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(64*Sqrt[2]*b^(11/4)) + (21*a^2*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(128*Sqrt[2]*b^(11/4)) - (21*a^2*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(128*Sqrt[2]*b^(11/4))}
{x^6/(a - b*x^4)^(3/4), x, 11, -((x^3*(a - b*x^4)^(1/4))/(4*b)) - (3*a*ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(8*Sqrt[2]*b^(7/4)) + (3*a*ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(8*Sqrt[2]*b^(7/4)) + (3*a*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(16*Sqrt[2]*b^(7/4)) - (3*a*Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)])/(16*Sqrt[2]*b^(7/4))}
{x^2/(a - b*x^4)^(3/4), x, 10, -(ArcTan[1 - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(2*Sqrt[2]*b^(3/4))) + ArcTan[1 + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(2*Sqrt[2]*b^(3/4)) + Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] - (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(4*Sqrt[2]*b^(3/4)) - Log[1 + (Sqrt[b]*x^2)/Sqrt[a - b*x^4] + (Sqrt[2]*b^(1/4)*x)/(a - b*x^4)^(1/4)]/(4*Sqrt[2]*b^(3/4))}
{1/(x^2*(a - b*x^4)^(3/4)), x, 1, -((a - b*x^4)^(1/4)/(a*x))}
{1/(x^6*(a - b*x^4)^(3/4)), x, 2, -((a - b*x^4)^(1/4)/(5*a*x^5)) - (4*b*(a - b*x^4)^(1/4))/(5*a^2*x)}
{1/(x^10*(a - b*x^4)^(3/4)), x, 3, -((a - b*x^4)^(1/4)/(9*a*x^9)) - (8*b*(a - b*x^4)^(1/4))/(45*a^2*x^5) - (32*b^2*(a - b*x^4)^(1/4))/(45*a^3*x)}
{1/(x^14*(a - b*x^4)^(3/4)), x, 4, -((a - b*x^4)^(1/4)/(13*a*x^13)) - (4*b*(a - b*x^4)^(1/4))/(39*a^2*x^9) - (32*b^2*(a - b*x^4)^(1/4))/(195*a^3*x^5) - (128*b^3*(a - b*x^4)^(1/4))/(195*a^4*x)}

{x^12/(a - b*x^4)^(3/4), x, 7, -((3*a^2*x*(a - b*x^4)^(1/4))/(8*b^3)) - (3*a*x^5*(a - b*x^4)^(1/4))/(20*b^2) - (x^9*(a - b*x^4)^(1/4))/(10*b) - (3*a^(5/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(8*b^(5/2)*(a - b*x^4)^(3/4))}
{x^8/(a - b*x^4)^(3/4), x, 6, -((5*a*x*(a - b*x^4)^(1/4))/(12*b^2)) - (x^5*(a - b*x^4)^(1/4))/(6*b) - (5*a^(3/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(12*b^(3/2)*(a - b*x^4)^(3/4))}
{x^4/(a - b*x^4)^(3/4), x, 5, -((x*(a - b*x^4)^(1/4))/(2*b)) - (Sqrt[a]*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(2*Sqrt[b]*(a - b*x^4)^(3/4))}
{x^0/(a - b*x^4)^(3/4), x, 4, -((Sqrt[b]*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[a]*(a - b*x^4)^(3/4)))}
{1/(x^4*(a - b*x^4)^(3/4)), x, 5, -((a - b*x^4)^(1/4)/(3*a*x^3)) - (2*b^(3/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(3*a^(3/2)*(a - b*x^4)^(3/4))}
{1/(x^8*(a - b*x^4)^(3/4)), x, 6, -((a - b*x^4)^(1/4)/(7*a*x^7)) - (2*b*(a - b*x^4)^(1/4))/(7*a^2*x^3) - (4*b^(5/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(7*a^(5/2)*(a - b*x^4)^(3/4))}
{1/(x^12*(a - b*x^4)^(3/4)), x, 7, -((a - b*x^4)^(1/4)/(11*a*x^11)) - (10*b*(a - b*x^4)^(1/4))/(77*a^2*x^7) - (20*b^2*(a - b*x^4)^(1/4))/(77*a^3*x^3) - (40*b^(7/2)*(1 - a/(b*x^4))^(3/4)*x^3*EllipticF[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(77*a^(7/2)*(a - b*x^4)^(3/4))}


{x^2/(a - b*x^4)^(5/4), x, 5, 1/(b*x*(a - b*x^4)^(1/4)) - ((1 - a/(b*x^4))^(1/4)*x*EllipticE[(1/2)*ArcCsc[(Sqrt[b]*x^2)/Sqrt[a]], 2])/(Sqrt[a]*Sqrt[b]*(a - b*x^4)^(1/4))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^4)^p with p symbolic*)


{x^7*(a + b*x^4)^p, x, 3, -((a*(a + b*x^4)^(1 + p))/(4*b^2*(1 + p))) + (a + b*x^4)^(2 + p)/(4*b^2*(2 + p))}
{x^3*(a + b*x^4)^p, x, 1, (a + b*x^4)^(1 + p)/(4*b*(1 + p))}
{(a + b*x^4)^p/x^1, x, 2, -(((a + b*x^4)^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*x^4)/a])/(4*a*(1 + p)))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^5)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^5)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^24/(a + b*x^5), x, 3, -((a^3*x^5)/(5*b^4)) + (a^2*x^10)/(10*b^3) - (a*x^15)/(15*b^2) + x^20/(20*b) + (a^4*Log[a + b*x^5])/(5*b^5)}
{x^19/(a + b*x^5), x, 3, (a^2*x^5)/(5*b^3) - (a*x^10)/(10*b^2) + x^15/(15*b) - (a^3*Log[a + b*x^5])/(5*b^4)}
{x^14/(a + b*x^5), x, 3, -((a*x^5)/(5*b^2)) + x^10/(10*b) + (a^2*Log[a + b*x^5])/(5*b^3)}
{x^9/(a + b*x^5), x, 3, x^5/(5*b) - (a*Log[a + b*x^5])/(5*b^2)}
{x^4/(a + b*x^5), x, 1, Log[a + b*x^5]/(5*b)}
{1/(x^1*(a + b*x^5)), x, 4, Log[x]/a - Log[a + b*x^5]/(5*a)}
{1/(x^6*(a + b*x^5)), x, 3, -(1/(5*a*x^5)) - (b*Log[x])/a^2 + (b*Log[a + b*x^5])/(5*a^2)}
{1/(x^11*(a + b*x^5)), x, 3, -(1/(10*a*x^10)) + b/(5*a^2*x^5) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x^5])/(5*a^3)}
{1/(x^16*(a + b*x^5)), x, 3, -(1/(15*a*x^15)) + b/(10*a^2*x^10) - b^2/(5*a^3*x^5) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x^5])/(5*a^4)}

{1/(a + b*x^5), x, 6, -((Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[((1 - Sqrt[5])*a^(1/5) - 4*b^(1/5)*x)/(Sqrt[2*(5 + Sqrt[5])]*a^(1/5))])/(5*a^(4/5)*b^(1/5))) - (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[((1 + Sqrt[5])*a^(1/5) - 4*b^(1/5)*x)/(Sqrt[2*(5 - Sqrt[5])]*a^(1/5))])/(5*a^(4/5)*b^(1/5)) + Log[a^(1/5) + b^(1/5)*x]/(5*a^(4/5)*b^(1/5)) - ((1 - Sqrt[5])*Log[2*a^(2/5) - (1 - Sqrt[5])*a^(1/5)*b^(1/5)*x + 2*b^(2/5)*x^2])/(20*a^(4/5)*b^(1/5)) - ((1 + Sqrt[5])*Log[2*a^(2/5) - (1 + Sqrt[5])*a^(1/5)*b^(1/5)*x + 2*b^(2/5)*x^2])/(20*a^(4/5)*b^(1/5)), (Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + (2*Sqrt[2/(5 + Sqrt[5])]*b^(1/5)*x)/a^(1/5)])/(5*a^(4/5)*b^(1/5)) - (Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - (Sqrt[(2/5)*(5 + Sqrt[5])]*b^(1/5)*x)/a^(1/5)])/(5*a^(4/5)*b^(1/5)) + Log[a^(1/5) + b^(1/5)*x]/(5*a^(4/5)*b^(1/5)) - ((1 - Sqrt[5])*Log[a^(2/5) - (1/2)*(1 - Sqrt[5])*a^(1/5)*b^(1/5)*x + b^(2/5)*x^2])/(20*a^(4/5)*b^(1/5)) - ((1 + Sqrt[5])*Log[a^(2/5) - (1/2)*(1 + Sqrt[5])*a^(1/5)*b^(1/5)*x + b^(2/5)*x^2])/(20*a^(4/5)*b^(1/5))}


{x^24/(a + b*x^5)^2, x, 3, (3*a^2*x^5)/(5*b^4) - (a*x^10)/(5*b^3) + x^15/(15*b^2) - a^4/(5*b^5*(a + b*x^5)) - (4*a^3*Log[a + b*x^5])/(5*b^5)}
{x^19/(a + b*x^5)^2, x, 3, -((2*a*x^5)/(5*b^3)) + x^10/(10*b^2) + a^3/(5*b^4*(a + b*x^5)) + (3*a^2*Log[a + b*x^5])/(5*b^4)}
{x^14/(a + b*x^5)^2, x, 3, x^5/(5*b^2) - a^2/(5*b^3*(a + b*x^5)) - (2*a*Log[a + b*x^5])/(5*b^3)}
{x^9/(a + b*x^5)^2, x, 3, a/(5*b^2*(a + b*x^5)) + Log[a + b*x^5]/(5*b^2)}
{x^4/(a + b*x^5)^2, x, 1, -(1/(5*b*(a + b*x^5)))}
{1/(x^1*(a + b*x^5)^2), x, 3, 1/(5*a*(a + b*x^5)) + Log[x]/a^2 - Log[a + b*x^5]/(5*a^2)}
{1/(x^6*(a + b*x^5)^2), x, 3, -(1/(5*a^2*x^5)) - b/(5*a^2*(a + b*x^5)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x^5])/(5*a^3)}
{1/(x^11*(a + b*x^5)^2), x, 3, -(1/(10*a^2*x^10)) + (2*b)/(5*a^3*x^5) + b^2/(5*a^3*(a + b*x^5)) + (3*b^2*Log[x])/a^4 - (3*b^2*Log[a + b*x^5])/(5*a^4)}


{x^14/(2*b + b*x^5), x, 3, -((2*x^5)/(5*b)) + x^10/(10*b) + (4*Log[2 + x^5])/(5*b)}
{x^9/(2*b + b*x^5), x, 3, x^5/(5*b) - (2*Log[2 + x^5])/(5*b)}
{x^4/(2*b + b*x^5), x, 1, Log[2 + x^5]/(5*b)}
{1/(x^1*(2*b + b*x^5)), x, 4, Log[x]/(2*b) - Log[2 + x^5]/(10*b)}
{1/(x^6*(2*b + b*x^5)), x, 3, -(1/(10*b*x^5)) - Log[x]/(4*b) + Log[2 + x^5]/(20*b)}

{x^14/(3 + b*x^5), x, 3, -((3*x^5)/(5*b^2)) + x^10/(10*b) + (9*Log[3 + b*x^5])/(5*b^3)}
{x^9/(3 + b*x^5), x, 3, x^5/(5*b) - (3*Log[3 + b*x^5])/(5*b^2)}
{x^4/(3 + b*x^5), x, 1, Log[3 + b*x^5]/(5*b)}
{1/(x^1*(3 + b*x^5)), x, 4, Log[x]/3 - (1/15)*Log[3 + b*x^5]}
{1/(x^6*(3 + b*x^5)), x, 3, -(1/(15*x^5)) - (1/9)*b*Log[x] + (1/45)*b*Log[3 + b*x^5]}


{x^14/(1 + x^5), x, 3, -(x^5/5) + x^10/10 + (1/5)*Log[1 + x^5]}
{x^9/(1 + x^5), x, 3, x^5/5 - (1/5)*Log[1 + x^5]}
{x^4/(1 + x^5), x, 1, (1/5)*Log[1 + x^5]}
{1/(x^1*(1 + x^5)), x, 4, Log[x] - (1/5)*Log[1 + x^5]}
{1/(x^6*(1 + x^5)), x, 3, -(1/(5*x^5)) - Log[x] + (1/5)*Log[1 + x^5]}

{x^5/(1 + x^5), x, 7, x - (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] + (1/5)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] - (1/5)*Log[1 + x] + (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] + (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}
{x^3/(1 + x^5), x, 6, (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] - (1/5)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] - (1/5)*Log[1 + x] + (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] + (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}
{x^2/(1 + x^5), x, 6, (-(1/5))*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] - (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] + (1/5)*Log[1 + x] - (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] - (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}
{x^1/(1 + x^5), x, 6, (-(1/5))*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] - (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] - (1/5)*Log[1 + x] + (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] + (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}
{x^0/(1 + x^5), x, 6, (-(1/5))*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[2*(5 + Sqrt[5])]] - (1/5)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[(1/2)*Sqrt[(1/10)*(5 + Sqrt[5])]*(1 + Sqrt[5] - 4*x)] + (1/5)*Log[1 + x] - (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] - (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2], (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] - (1/5)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] + (1/5)*Log[1 + x] - (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] - (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}
{1/(x^2*(1 + x^5)), x, 7, -(1/x) - (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] + (1/5)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] + (1/5)*Log[1 + x] - (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] - (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}
{1/(x^3*(1 + x^5)), x, 7, -(1/(2*x^2)) + (1/5)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] + (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] - (1/5)*Log[1 + x] + (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] + (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}
{1/(x^4*(1 + x^5)), x, 7, -(1/(3*x^3)) + (1/5)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + 2*Sqrt[2/(5 + Sqrt[5])]*x] + (1/5)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - Sqrt[(2/5)*(5 + Sqrt[5])]*x] + (1/5)*Log[1 + x] - (1/20)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] - (1/20)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^5)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^5)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^5)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


(* Integrands of the form x^(n/2)/Sqrt[a+b*x^5] where n mod 10 = 0 *)
{x^(23/2)/Sqrt[a + b*x^5], x, 6, -((3*a*x^(5/2)*Sqrt[a + b*x^5])/(20*b^2)) + (x^(15/2)*Sqrt[a + b*x^5])/(10*b) + (3*a^2*ArcTanh[(Sqrt[b]*x^(5/2))/Sqrt[a + b*x^5]])/(20*b^(5/2))}
{x^(13/2)/Sqrt[a + b*x^5], x, 5, (x^(5/2)*Sqrt[a + b*x^5])/(5*b) - (a*ArcTanh[(Sqrt[b]*x^(5/2))/Sqrt[a + b*x^5]])/(5*b^(3/2))}
{x^(3/2)/Sqrt[a + b*x^5], x, 4, (2*ArcTanh[(Sqrt[b]*x^(5/2))/Sqrt[a + b*x^5]])/(5*Sqrt[b])}
{x^(-7/2)/Sqrt[a + b*x^5], x, 1, -((2*Sqrt[a + b*x^5])/(5*a*x^(5/2)))}
{x^(-17/2)/Sqrt[a + b*x^5], x, 2, -((2*Sqrt[a + b*x^5])/(15*a*x^(15/2))) + (4*b*Sqrt[a + b*x^5])/(15*a^2*x^(5/2))}


(* Integrands of the form x^(n/2)/Sqrt[1+x^5] where n mod 10 = 0 *)
{x^(23/2)/Sqrt[1 + x^5], x, 5, (-(3/20))*x^(5/2)*Sqrt[1 + x^5] + (1/10)*x^(15/2)*Sqrt[1 + x^5] + (3/20)*ArcSinh[x^(5/2)]}
{x^(13/2)/Sqrt[1 + x^5], x, 4, (1/5)*x^(5/2)*Sqrt[1 + x^5] - (1/5)*ArcSinh[x^(5/2)]}
{x^(3/2)/Sqrt[1 + x^5], x, 3, (2/5)*ArcSinh[x^(5/2)]}
{x^(-7/2)/Sqrt[1 + x^5], x, 1, -((2*Sqrt[1 + x^5])/(5*x^(5/2)))}
{x^(-17/2)/Sqrt[1 + x^5], x, 2, -((2*Sqrt[1 + x^5])/(15*x^(15/2))) + (4*Sqrt[1 + x^5])/(15*x^(5/2))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^6)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^6)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^8/(a + b*x^6), x, 3, x^3/(3*b) - (Sqrt[a]*ArcTan[(Sqrt[b]*x^3)/Sqrt[a]])/(3*b^(3/2))}
{x^7/(a + b*x^6), x, 8, x^2/(2*b) + (a^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))])/(2*Sqrt[3]*b^(4/3)) - (a^(1/3)*Log[a^(1/3) + b^(1/3)*x^2])/(6*b^(4/3)) + (a^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4])/(12*b^(4/3))}
{x^6/(a + b*x^6), x, 11, x/b - (a^(1/6)*ArcTan[(b^(1/6)*x)/a^(1/6)])/(3*b^(7/6)) + (a^(1/6)*ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)])/(6*b^(7/6)) - (a^(1/6)*ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)])/(6*b^(7/6)) + (a^(1/6)*Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(4*Sqrt[3]*b^(7/6)) - (a^(1/6)*Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(4*Sqrt[3]*b^(7/6))}
{x^5/(a + b*x^6), x, 1, Log[a + b*x^6]/(6*b)}
{x^4/(a + b*x^6), x, 10, ArcTan[(b^(1/6)*x)/a^(1/6)]/(3*a^(1/6)*b^(5/6)) - ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)]/(6*a^(1/6)*b^(5/6)) + ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)]/(6*a^(1/6)*b^(5/6)) + Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(4*Sqrt[3]*a^(1/6)*b^(5/6)) - Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(4*Sqrt[3]*a^(1/6)*b^(5/6))}
{x^3/(a + b*x^6), x, 7, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(2*Sqrt[3]*a^(1/3)*b^(2/3))) - Log[a^(1/3) + b^(1/3)*x^2]/(6*a^(1/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(12*a^(1/3)*b^(2/3))}
{x^2/(a + b*x^6), x, 2, ArcTan[(Sqrt[b]*x^3)/Sqrt[a]]/(3*Sqrt[a]*Sqrt[b])}
{x^1/(a + b*x^6), x, 7, -(ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(2*Sqrt[3]*a^(2/3)*b^(1/3))) + Log[a^(1/3) + b^(1/3)*x^2]/(6*a^(2/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(12*a^(2/3)*b^(1/3))}
{x^0/(a + b*x^6), x, 10, ArcTan[(b^(1/6)*x)/a^(1/6)]/(3*a^(5/6)*b^(1/6)) - ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)]/(6*a^(5/6)*b^(1/6)) + ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)]/(6*a^(5/6)*b^(1/6)) - Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(4*Sqrt[3]*a^(5/6)*b^(1/6)) + Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(4*Sqrt[3]*a^(5/6)*b^(1/6))}
{1/(x^1*(a + b*x^6)), x, 4, Log[x]/a - Log[a + b*x^6]/(6*a)}
{1/(x^2*(a + b*x^6)), x, 11, -(1/(a*x)) - (b^(1/6)*ArcTan[(b^(1/6)*x)/a^(1/6)])/(3*a^(7/6)) + (b^(1/6)*ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)])/(6*a^(7/6)) - (b^(1/6)*ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)])/(6*a^(7/6)) - (b^(1/6)*Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(4*Sqrt[3]*a^(7/6)) + (b^(1/6)*Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(4*Sqrt[3]*a^(7/6))}
{1/(x^3*(a + b*x^6)), x, 8, -(1/(2*a*x^2)) + (b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))])/(2*Sqrt[3]*a^(4/3)) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*x^2])/(6*a^(4/3)) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4])/(12*a^(4/3))}
{1/(x^4*(a + b*x^6)), x, 3, -(1/(3*a*x^3)) - (Sqrt[b]*ArcTan[(Sqrt[b]*x^3)/Sqrt[a]])/(3*a^(3/2))}


{x^8/(a + b*x^6)^2, x, 3, -x^3/(6*b*(a + b*x^6)) + ArcTan[(Sqrt[b]*x^3)/Sqrt[a]]/(6*Sqrt[a]*b^(3/2))}
{x^7/(a + b*x^6)^2, x, 8, -(x^2/(6*b*(a + b*x^6))) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(6*Sqrt[3]*a^(2/3)*b^(4/3)) + Log[a^(1/3) + b^(1/3)*x^2]/(18*a^(2/3)*b^(4/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(36*a^(2/3)*b^(4/3))}
{x^6/(a + b*x^6)^2, x, 11, -(x/(6*b*(a + b*x^6))) + ArcTan[(b^(1/6)*x)/a^(1/6)]/(18*a^(5/6)*b^(7/6)) - ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)]/(36*a^(5/6)*b^(7/6)) + ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)]/(36*a^(5/6)*b^(7/6)) - Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(24*Sqrt[3]*a^(5/6)*b^(7/6)) + Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(24*Sqrt[3]*a^(5/6)*b^(7/6))}
{x^5/(a + b*x^6)^2, x, 1, -(1/(6*b*(a + b*x^6)))}
{x^4/(a + b*x^6)^2, x, 11, x^5/(6*a*(a + b*x^6)) + ArcTan[(b^(1/6)*x)/a^(1/6)]/(18*a^(7/6)*b^(5/6)) - ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)]/(36*a^(7/6)*b^(5/6)) + ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)]/(36*a^(7/6)*b^(5/6)) + Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(24*Sqrt[3]*a^(7/6)*b^(5/6)) - Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2]/(24*Sqrt[3]*a^(7/6)*b^(5/6))}
{x^3/(a + b*x^6)^2, x, 8, x^4/(6*a*(a + b*x^6)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(6*Sqrt[3]*a^(4/3)*b^(2/3)) - Log[a^(1/3) + b^(1/3)*x^2]/(18*a^(4/3)*b^(2/3)) + Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(36*a^(4/3)*b^(2/3))}
{x^2/(a + b*x^6)^2, x, 3, x^3/(6*a*(a + b*x^6)) + ArcTan[(Sqrt[b]*x^3)/Sqrt[a]]/(6*a^(3/2)*Sqrt[b])}
{x^1/(a + b*x^6)^2, x, 8, x^2/(6*a*(a + b*x^6)) - ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(5/3)*b^(1/3)) + Log[a^(1/3) + b^(1/3)*x^2]/(9*a^(5/3)*b^(1/3)) - Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4]/(18*a^(5/3)*b^(1/3))}
{x^0/(a + b*x^6)^2, x, 11, x/(6*a*(a + b*x^6)) + (5*ArcTan[(b^(1/6)*x)/a^(1/6)])/(18*a^(11/6)*b^(1/6)) - (5*ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)])/(36*a^(11/6)*b^(1/6)) + (5*ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)])/(36*a^(11/6)*b^(1/6)) - (5*Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(24*Sqrt[3]*a^(11/6)*b^(1/6)) + (5*Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(24*Sqrt[3]*a^(11/6)*b^(1/6))}
{1/(x^1*(a + b*x^6)^2), x, 3, 1/(6*a*(a + b*x^6)) + Log[x]/a^2 - Log[a + b*x^6]/(6*a^2)}
{1/(x^2*(a + b*x^6)^2), x, 12, -(7/(6*a^2*x)) + 1/(6*a*x*(a + b*x^6)) - (7*b^(1/6)*ArcTan[(b^(1/6)*x)/a^(1/6)])/(18*a^(13/6)) + (7*b^(1/6)*ArcTan[(Sqrt[3]*a^(1/6) - 2*b^(1/6)*x)/a^(1/6)])/(36*a^(13/6)) - (7*b^(1/6)*ArcTan[(Sqrt[3]*a^(1/6) + 2*b^(1/6)*x)/a^(1/6)])/(36*a^(13/6)) - (7*b^(1/6)*Log[a^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(24*Sqrt[3]*a^(13/6)) + (7*b^(1/6)*Log[a^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + b^(1/3)*x^2])/(24*Sqrt[3]*a^(13/6))}
{1/(x^3*(a + b*x^6)^2), x, 9, -(2/(3*a^2*x^2)) + 1/(6*a*x^2*(a + b*x^6)) + (2*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^2)/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)) + (2*b^(1/3)*Log[a^(1/3) + b^(1/3)*x^2])/(9*a^(7/3)) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^2 + b^(2/3)*x^4])/(9*a^(7/3))}
{1/(x^4*(a + b*x^6)^2), x, 4, -(1/(2*a^2*x^3)) + 1/(6*a*x^3*(a + b*x^6)) - (Sqrt[b]*ArcTan[(Sqrt[b]*x^3)/Sqrt[a]])/(2*a^(5/2))}


{x^8/(1 - x^6), x, 3, -(x^3/3) + ArcTanh[x^3]/3}
{x^7/(1 - x^6), x, 8, -(x^2/2) + ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{x^6/(1 - x^6), x, 11, -x + ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3]) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)], -x - ArcTan[(1 - 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTan[(1 + 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTanh[x]/3 - (1/12)*Log[1 - x + x^2] + (1/12)*Log[1 + x + x^2]}
{x^5/(1 - x^6), x, 1, (-(1/6))*Log[1 - x^6]}
{x^4/(1 - x^6), x, 10, -(ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3])) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)], ArcTan[(1 - 2*x)/Sqrt[3]]/(2*Sqrt[3]) - ArcTan[(1 + 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTanh[x]/3 - (1/12)*Log[1 - x + x^2] + (1/12)*Log[1 + x + x^2]}
{x^3/(1 - x^6), x, 7, -(ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3])) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{x^2/(1 - x^6), x, 2, ArcTanh[x^3]/3}
{x^1/(1 - x^6), x, 7, ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{1/(1 - x^6), x, 10, ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3]) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)], -(ArcTan[(1 - 2*x)/Sqrt[3]]/(2*Sqrt[3])) + ArcTan[(1 + 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTanh[x]/3 - (1/12)*Log[1 - x + x^2] + (1/12)*Log[1 + x + x^2]}
{1/(x^1*(1 - x^6)), x, 4, Log[x] - (1/6)*Log[1 - x^6]}
{1/(x^2*(1 - x^6)), x, 11, -(1/x) - ArcTan[(Sqrt[3]*x)/(1 - x^2)]/(2*Sqrt[3]) + ArcTanh[x]/3 + (1/6)*ArcTanh[x/(1 + x^2)], -(1/x) + ArcTan[(1 - 2*x)/Sqrt[3]]/(2*Sqrt[3]) - ArcTan[(1 + 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTanh[x]/3 - (1/12)*Log[1 - x + x^2] + (1/12)*Log[1 + x + x^2]}
{1/(x^3*(1 - x^6)), x, 8, -(1/(2*x^2)) - ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{1/(x^4*(1 - x^6)), x, 3, -(1/(3*x^3)) + ArcTanh[x^3]/3}
{1/(x^5*(1 - x^6)), x, 8, -(1/(4*x^4)) + ArcTan[(1 + 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 - x^2] + (1/12)*Log[1 + x^2 + x^4]}
{1/(x^6*(1 - x^6)), x, 11, -(1/(5*x^5)) - ArcTan[(1 - 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTan[(1 + 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTanh[x]/3 - (1/12)*Log[1 - x + x^2] + (1/12)*Log[1 + x + x^2]}
{1/(x^7*(1 - x^6)), x, 3, -(1/(6*x^6)) + Log[x] - (1/6)*Log[1 - x^6]}
{1/(x^8*(1 - x^6)), x, 12, -(1/(7*x^7)) - 1/x + ArcTan[(1 - 2*x)/Sqrt[3]]/(2*Sqrt[3]) - ArcTan[(1 + 2*x)/Sqrt[3]]/(2*Sqrt[3]) + ArcTanh[x]/3 - (1/12)*Log[1 - x + x^2] + (1/12)*Log[1 + x + x^2]}


{x^8/(1 + x^6), x, 3, x^3/3 - ArcTan[x^3]/3}
{x^7/(1 + x^6), x, 8, x^2/2 + ArcTan[(1 - 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 + x^2] + (1/12)*Log[1 - x^2 + x^4]}
{x^6/(1 + x^6), x, 11, x + (1/6)*ArcTan[Sqrt[3] - 2*x] - ArcTan[x]/3 - (1/6)*ArcTan[Sqrt[3] + 2*x] + Log[1 - Sqrt[3]*x + x^2]/(4*Sqrt[3]) - Log[1 + Sqrt[3]*x + x^2]/(4*Sqrt[3])}
{x^5/(1 + x^6), x, 1, (1/6)*Log[1 + x^6]}
{x^4/(1 + x^6), x, 10, (-(1/6))*ArcTan[Sqrt[3] - 2*x] + ArcTan[x]/3 + (1/6)*ArcTan[Sqrt[3] + 2*x] + Log[1 - Sqrt[3]*x + x^2]/(4*Sqrt[3]) - Log[1 + Sqrt[3]*x + x^2]/(4*Sqrt[3])}
{x^3/(1 + x^6), x, 7, -(ArcTan[(1 - 2*x^2)/Sqrt[3]]/(2*Sqrt[3])) - (1/6)*Log[1 + x^2] + (1/12)*Log[1 - x^2 + x^4]}
{x^2/(1 + x^6), x, 2, ArcTan[x^3]/3}
{x^1/(1 + x^6), x, 7, -(ArcTan[(1 - 2*x^2)/Sqrt[3]]/(2*Sqrt[3])) + (1/6)*Log[1 + x^2] - (1/12)*Log[1 - x^2 + x^4]}
{1/(1 + x^6), x, 10, (-(1/6))*ArcTan[Sqrt[3] - 2*x] + ArcTan[x]/3 + (1/6)*ArcTan[Sqrt[3] + 2*x] - Log[1 - Sqrt[3]*x + x^2]/(4*Sqrt[3]) + Log[1 + Sqrt[3]*x + x^2]/(4*Sqrt[3])}
{1/(x^1*(1 + x^6)), x, 4, Log[x] - (1/6)*Log[1 + x^6]}
{1/(x^2*(1 + x^6)), x, 11, -(1/x) + (1/6)*ArcTan[Sqrt[3] - 2*x] - ArcTan[x]/3 - (1/6)*ArcTan[Sqrt[3] + 2*x] - Log[1 - Sqrt[3]*x + x^2]/(4*Sqrt[3]) + Log[1 + Sqrt[3]*x + x^2]/(4*Sqrt[3])}
{1/(x^3*(1 + x^6)), x, 8, -(1/(2*x^2)) + ArcTan[(1 - 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) + (1/6)*Log[1 + x^2] - (1/12)*Log[1 - x^2 + x^4]}
{1/(x^4*(1 + x^6)), x, 3, -(1/(3*x^3)) - ArcTan[x^3]/3}
{1/(x^5*(1 + x^6)), x, 8, -(1/(4*x^4)) + ArcTan[(1 - 2*x^2)/Sqrt[3]]/(2*Sqrt[3]) - (1/6)*Log[1 + x^2] + (1/12)*Log[1 - x^2 + x^4]}
{1/(x^6*(1 + x^6)), x, 11, -(1/(5*x^5)) + (1/6)*ArcTan[Sqrt[3] - 2*x] - ArcTan[x]/3 - (1/6)*ArcTan[Sqrt[3] + 2*x] + Log[1 - Sqrt[3]*x + x^2]/(4*Sqrt[3]) - Log[1 + Sqrt[3]*x + x^2]/(4*Sqrt[3])}
{1/(x^7*(1 + x^6)), x, 3, -(1/(6*x^6)) - Log[x] + (1/6)*Log[1 + x^6]}
{1/(x^8*(1 + x^6)), x, 12, -(1/(7*x^7)) + 1/x - (1/6)*ArcTan[Sqrt[3] - 2*x] + ArcTan[x]/3 + (1/6)*ArcTan[Sqrt[3] + 2*x] + Log[1 - Sqrt[3]*x + x^2]/(4*Sqrt[3]) - Log[1 + Sqrt[3]*x + x^2]/(4*Sqrt[3])}


{1/(2 - 3*x^6), x, 10, If[$VersionNumber<9, -(ArcTan[1/Sqrt[3] - (2^(5/6)*x)/3^(1/3)]/(2*2^(5/6)*3^(2/3))) + ArcTan[1/Sqrt[3] + (2^(5/6)*x)/3^(1/3)]/(2*2^(5/6)*3^(2/3)) + ArcTanh[(3/2)^(1/6)*x]/(3*2^(5/6)*3^(1/6)) - Log[2^(1/3) - 6^(1/6)*x + 3^(1/3)*x^2]/(12*2^(5/6)*3^(1/6)) + Log[2^(1/3) + 6^(1/6)*x + 3^(1/3)*x^2]/(12*2^(5/6)*3^(1/6)), -(ArcTan[(6^(1/6) - 2*3^(1/3)*x)/(2^(1/6)*3^(2/3))]/(2*2^(5/6)*3^(2/3))) + ArcTan[(6^(1/6) + 2*3^(1/3)*x)/(2^(1/6)*3^(2/3))]/(2*2^(5/6)*3^(2/3)) + ArcTanh[(3/2)^(1/6)*x]/(3*2^(5/6)*3^(1/6)) - Log[2^(1/3) - 6^(1/6)*x + 3^(1/3)*x^2]/(12*2^(5/6)*3^(1/6)) + Log[2^(1/3) + 6^(1/6)*x + 3^(1/3)*x^2]/(12*2^(5/6)*3^(1/6))]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b x^6)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(1/3)/(1 - x^6), x, 8, -(ArcTan[(1 + 2*x^(2/3))/Sqrt[3]]/(2*Sqrt[3])) + (1/3)*ArcTan[(x^(2/3) - Cos[(2*Pi)/9])*Csc[(2*Pi)/9]]*Cos[Pi/18] - (1/6)*Log[1 - x^(2/3)] + (1/12)*Log[1 + x^(2/3) + x^(4/3)] - (1/6)*Cos[(2*Pi)/9]*Log[1 + x^(4/3) + 2*x^(2/3)*Cos[Pi/9]] + (1/6)*Cos[Pi/9]*Log[1 + x^(4/3) - 2*x^(2/3)*Sin[Pi/18]] - (1/6)*Log[1 + x^(4/3) - 2*x^(2/3)*Cos[(2*Pi)/9]]*Sin[Pi/18] + (1/3)*ArcTan[Sec[Pi/18]*(x^(2/3) - Sin[Pi/18])]*Sin[Pi/9] - (1/3)*ArcTan[(x^(2/3) + Cos[Pi/9])*Csc[Pi/9]]*Sin[(2*Pi)/9]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^6)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^8*Sqrt[-1 + 4*x^6], x, 5, (-(1/96))*x^3*Sqrt[-1 + 4*x^6] + (1/12)*x^9*Sqrt[-1 + 4*x^6] - (1/192)*ArcTanh[(2*x^3)/Sqrt[-1 + 4*x^6]]}
{x^5*Sqrt[a^6 - x^6], x, 1, -(a^6 - x^6)^(3/2)/9}
{x^2*Sqrt[-2 + x^6], x, 4, (1/6)*x^3*Sqrt[-2 + x^6] - (1/3)*ArcTanh[x^3/Sqrt[-2 + x^6]]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^23/Sqrt[2 + x^6], x, 3, (-(8/3))*Sqrt[2 + x^6] + (4/3)*(2 + x^6)^(3/2) - (2/5)*(2 + x^6)^(5/2) + (1/21)*(2 + x^6)^(7/2)}
{x^17/Sqrt[2 + x^6], x, 3, (4*Sqrt[2 + x^6])/3 - (4/9)*(2 + x^6)^(3/2) + (1/15)*(2 + x^6)^(5/2)}
{x^11/Sqrt[2 + x^6], x, 3, (-(2/3))*Sqrt[2 + x^6] + (1/9)*(2 + x^6)^(3/2)}
{x^5/Sqrt[2 + x^6], x, 1, Sqrt[2 + x^6]/3}
{1/(x^1*Sqrt[2 + x^6]), x, 3, -(ArcTanh[Sqrt[2 + x^6]/Sqrt[2]]/(3*Sqrt[2]))}
{1/(x^7*Sqrt[2 + x^6]), x, 4, -(Sqrt[2 + x^6]/(12*x^6)) + ArcTanh[Sqrt[2 + x^6]/Sqrt[2]]/(12*Sqrt[2])}
{1/(x^13*Sqrt[2 + x^6]), x, 5, -(Sqrt[2 + x^6]/(24*x^12)) + Sqrt[2 + x^6]/(32*x^6) - ArcTanh[Sqrt[2 + x^6]/Sqrt[2]]/(32*Sqrt[2])}

{x^14/Sqrt[2 + x^6], x, 4, (-(1/4))*x^3*Sqrt[2 + x^6] + (1/12)*x^9*Sqrt[2 + x^6] + (1/2)*ArcSinh[x^3/Sqrt[2]]}
{x^8/Sqrt[2 + x^6], x, 3, (1/6)*x^3*Sqrt[2 + x^6] - (1/3)*ArcSinh[x^3/Sqrt[2]]}
{x^2/Sqrt[2 + x^6], x, 2, (1/3)*ArcSinh[x^3/Sqrt[2]]}
{1/(x^4*Sqrt[2 + x^6]), x, 1, -(Sqrt[2 + x^6]/(6*x^3))}
{1/(x^10*Sqrt[2 + x^6]), x, 2, -(Sqrt[2 + x^6]/(18*x^9)) + Sqrt[2 + x^6]/(18*x^3)}
{1/(x^16*Sqrt[2 + x^6]), x, 3, -(Sqrt[2 + x^6]/(30*x^15)) + Sqrt[2 + x^6]/(45*x^9) - Sqrt[2 + x^6]/(45*x^3)}

{x^7/Sqrt[2 + x^6], x, 3, (1/5)*x^2*Sqrt[2 + x^6] - (2*2^(5/6)*Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(5*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{x^1/Sqrt[2 + x^6], x, 2, (Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(2^(1/6)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{1/(x^5*Sqrt[2 + x^6]), x, 3, -(Sqrt[2 + x^6]/(8*x^4)) - (Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(8*2^(1/6)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}

{x^6/Sqrt[2 + x^6], x, 2, (1/4)*x*Sqrt[2 + x^6] - (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(4*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{x^0/Sqrt[2 + x^6], x, 1, (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(2*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{1/(x^6*Sqrt[2 + x^6]), x, 2, -(Sqrt[2 + x^6]/(10*x^5)) - (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(10*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}

{x^9/Sqrt[2 + x^6], x, 5, (1/7)*x^4*Sqrt[2 + x^6] - (8*Sqrt[2 + x^6])/(7*(2^(1/3)*(1 + Sqrt[3]) + x^2)) + (4*2^(1/6)*3^(1/4)*Sqrt[2 - Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticE[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(7*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6]) - (8*2^(2/3)*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(7*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{x^3/Sqrt[2 + x^6], x, 4, Sqrt[2 + x^6]/(2^(1/3)*(1 + Sqrt[3]) + x^2) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticE[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(2^(5/6)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6]) + (2^(2/3)*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{1/(x^3*Sqrt[2 + x^6]), x, 5, -(Sqrt[2 + x^6]/(4*x^2)) + Sqrt[2 + x^6]/(4*(2^(1/3)*(1 + Sqrt[3]) + x^2)) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticE[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(4*2^(5/6)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6]) + ((2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(2*2^(1/3)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}

{x^10/Sqrt[2 + x^6], x, 4, (1/8)*x^5*Sqrt[2 + x^6] - (5*(1 + Sqrt[3])*x*Sqrt[2 + x^6])/(8*(2^(1/3) + (1 + Sqrt[3])*x^2)) + (5*3^(1/4)*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticE[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(4*2^(2/3)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6]) + (5*(1 - Sqrt[3])*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(8*2^(2/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{x^4/Sqrt[2 + x^6], x, 3, ((1 + Sqrt[3])*x*Sqrt[2 + x^6])/(2*(2^(1/3) + (1 + Sqrt[3])*x^2)) - (3^(1/4)*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticE[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(2^(2/3)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6]) - ((1 - Sqrt[3])*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(2*2^(2/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{1/(x^2*Sqrt[2 + x^6]), x, 4, -(Sqrt[2 + x^6]/(2*x)) + ((1 + Sqrt[3])*x*Sqrt[2 + x^6])/(2*(2^(1/3) + (1 + Sqrt[3])*x^2)) - (3^(1/4)*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticE[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(2^(2/3)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6]) - ((1 - Sqrt[3])*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(2*2^(2/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}


{x^23/(2 + x^6)^(3/2), x, 3, 8/(3*Sqrt[2 + x^6]) + 4*Sqrt[2 + x^6] - (2/3)*(2 + x^6)^(3/2) + (1/15)*(2 + x^6)^(5/2)}
{x^17/(2 + x^6)^(3/2), x, 3, -(4/(3*Sqrt[2 + x^6])) - (4*Sqrt[2 + x^6])/3 + (1/9)*(2 + x^6)^(3/2)}
{x^11/(2 + x^6)^(3/2), x, 3, 2/(3*Sqrt[2 + x^6]) + Sqrt[2 + x^6]/3}
{x^5/(2 + x^6)^(3/2), x, 1, -(1/(3*Sqrt[2 + x^6]))}
{1/(x^1*(2 + x^6)^(3/2)), x, 4, 1/(6*Sqrt[2 + x^6]) - ArcTanh[Sqrt[2 + x^6]/Sqrt[2]]/(6*Sqrt[2])}
{1/(x^7*(2 + x^6)^(3/2)), x, 5, -(1/(8*Sqrt[2 + x^6])) - 1/(12*x^6*Sqrt[2 + x^6]) + ArcTanh[Sqrt[2 + x^6]/Sqrt[2]]/(8*Sqrt[2])}
{1/(x^13*(2 + x^6)^(3/2)), x, 6, 5/(64*Sqrt[2 + x^6]) - 1/(24*x^12*Sqrt[2 + x^6]) + 5/(96*x^6*Sqrt[2 + x^6]) - (5*ArcTanh[Sqrt[2 + x^6]/Sqrt[2]])/(64*Sqrt[2])}

{x^14/(2 + x^6)^(3/2), x, 4, -(x^9/(3*Sqrt[2 + x^6])) + (1/2)*x^3*Sqrt[2 + x^6] - ArcSinh[x^3/Sqrt[2]]}
{x^8/(2 + x^6)^(3/2), x, 3, -(x^3/(3*Sqrt[2 + x^6])) + (1/3)*ArcSinh[x^3/Sqrt[2]]}
{x^2/(2 + x^6)^(3/2), x, 1, x^3/(6*Sqrt[2 + x^6])}
{1/(x^4*(2 + x^6)^(3/2)), x, 2, -(1/(6*x^3*Sqrt[2 + x^6])) - x^3/(6*Sqrt[2 + x^6])}
{1/(x^10*(2 + x^6)^(3/2)), x, 3, -(1/(18*x^9*Sqrt[2 + x^6])) + 1/(9*x^3*Sqrt[2 + x^6]) + x^3/(9*Sqrt[2 + x^6])}

{x^13/(2 + x^6)^(3/2), x, 4, -(x^8/(3*Sqrt[2 + x^6])) + (8/15)*x^2*Sqrt[2 + x^6] - (16*2^(5/6)*Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(15*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{x^7/(2 + x^6)^(3/2), x, 3, -(x^2/(3*Sqrt[2 + x^6])) + (2^(5/6)*Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{x^1/(2 + x^6)^(3/2), x, 3, x^2/(6*Sqrt[2 + x^6]) + (Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(6*2^(1/6)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{1/(x^5*(2 + x^6)^(3/2)), x, 4, 1/(6*x^4*Sqrt[2 + x^6]) - (7*Sqrt[2 + x^6])/(48*x^4) - (7*Sqrt[2 + Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(48*2^(1/6)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}

{x^12/(2 + x^6)^(3/2), x, 3, -(x^7/(3*Sqrt[2 + x^6])) + (7/12)*x*Sqrt[2 + x^6] - (7*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(12*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{x^6/(2 + x^6)^(3/2), x, 2, -(x/(3*Sqrt[2 + x^6])) + (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(6*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{x^0/(2 + x^6)^(3/2), x, 2, x/(6*Sqrt[2 + x^6]) + (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(6*2^(1/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{1/(x^6*(2 + x^6)^(3/2)), x, 3, 1/(6*x^5*Sqrt[2 + x^6]) - (2*Sqrt[2 + x^6])/(15*x^5) - (2^(2/3)*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(15*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}

{x^15/(2 + x^6)^(3/2), x, 6, -(x^10/(3*Sqrt[2 + x^6])) + (10/21)*x^4*Sqrt[2 + x^6] - (80*Sqrt[2 + x^6])/(21*(2^(1/3)*(1 + Sqrt[3]) + x^2)) + (40*2^(1/6)*Sqrt[2 - Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticE[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(7*3^(3/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6]) - (80*2^(2/3)*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(21*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{x^9/(2 + x^6)^(3/2), x, 5, -(x^4/(3*Sqrt[2 + x^6])) + (4*Sqrt[2 + x^6])/(3*(2^(1/3)*(1 + Sqrt[3]) + x^2)) - (2*2^(1/6)*Sqrt[2 - Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticE[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(3^(3/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6]) + (4*2^(2/3)*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{x^3/(2 + x^6)^(3/2), x, 5, x^4/(6*Sqrt[2 + x^6]) - Sqrt[2 + x^6]/(6*(2^(1/3)*(1 + Sqrt[3]) + x^2)) + (Sqrt[2 - Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticE[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(2*2^(5/6)*3^(3/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6]) - ((2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(3*2^(1/3)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}
{1/(x^3*(2 + x^6)^(3/2)), x, 6, 1/(6*x^2*Sqrt[2 + x^6]) - (5*Sqrt[2 + x^6])/(24*x^2) + (5*Sqrt[2 + x^6])/(24*(2^(1/3)*(1 + Sqrt[3]) + x^2)) - (5*Sqrt[2 - Sqrt[3]]*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticE[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(8*2^(5/6)*3^(3/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6]) + (5*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*EllipticF[ArcSin[(2^(1/3)*(1 - Sqrt[3]) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)], -7 - 4*Sqrt[3]])/(12*2^(1/3)*3^(1/4)*Sqrt[(2^(1/3) + x^2)/(2^(1/3)*(1 + Sqrt[3]) + x^2)^2]*Sqrt[2 + x^6])}

{x^10/(2 + x^6)^(3/2), x, 4, -(x^5/(3*Sqrt[2 + x^6])) + (5*(1 + Sqrt[3])*x*Sqrt[2 + x^6])/(6*(2^(1/3) + (1 + Sqrt[3])*x^2)) - (5*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticE[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(2^(2/3)*3^(3/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6]) - (5*(1 - Sqrt[3])*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(6*2^(2/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{x^4/(2 + x^6)^(3/2), x, 4, x^5/(6*Sqrt[2 + x^6]) - ((1 + Sqrt[3])*x*Sqrt[2 + x^6])/(6*(2^(1/3) + (1 + Sqrt[3])*x^2)) + (x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticE[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(2^(2/3)*3^(3/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6]) + ((1 - Sqrt[3])*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(6*2^(2/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}
{1/(x^2*(2 + x^6)^(3/2)), x, 5, 1/(6*x*Sqrt[2 + x^6]) - Sqrt[2 + x^6]/(3*x) + ((1 + Sqrt[3])*x*Sqrt[2 + x^6])/(3*(2^(1/3) + (1 + Sqrt[3])*x^2)) - (2^(1/3)*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticE[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(3^(3/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6]) - ((1 - Sqrt[3])*x*(2^(1/3) + x^2)*Sqrt[(2^(2/3) - 2^(1/3)*x^2 + x^4)/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*EllipticF[ArcCos[(2^(1/3) + (1 - Sqrt[3])*x^2)/(2^(1/3) + (1 + Sqrt[3])*x^2)], (1/4)*(2 + Sqrt[3])])/(3*2^(2/3)*3^(1/4)*Sqrt[(x^2*(2^(1/3) + x^2))/(2^(1/3) + (1 + Sqrt[3])*x^2)^2]*Sqrt[2 + x^6])}


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b x^6)^(p/2)*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^7)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^7)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b*x^7)*x^m, x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(8 + m))/(8 + m)}

{(a + b*x^7)*x^8, x, 2, (a*x^9)/9 + (b*x^16)/16}
{(a + b*x^7)/x^8, x, 2, -(a/(7*x^7)) + b*Log[x]}


{(a + b*x^7)^2*x^m, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(8 + m))/(8 + m) + (b^2*x^(15 + m))/(15 + m)}

{(a + b*x^7)^2*x^8, x, 2, (a^2*x^9)/9 + (1/8)*a*b*x^16 + (b^2*x^23)/23}
{(a + b*x^7)^2/x^8, x, 3, -(a^2/(7*x^7)) + (b^2*x^7)/7 + 2*a*b*Log[x]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^m/(a + b*x^7), x, 1, (x^(1 + m)*Hypergeometric2F1[1, (1 + m)/7, (8 + m)/7, -((b*x^7)/a)])/(a*(1 + m))}

{x^6/(a + b*x^7), x, 1, Log[a + b*x^7]/(7*b)}
{x^0/(a + b*x^7), x, 6, (2*ArcTan[(b^(1/7)*x*Sec[Pi/14])/a^(1/7) - Tan[Pi/14]]*Cos[Pi/14])/(7*a^(6/7)*b^(1/7)) + (2*ArcTan[(b^(1/7)*x*Sec[(3*Pi)/14])/a^(1/7) + Tan[(3*Pi)/14]]*Cos[(3*Pi)/14])/(7*a^(6/7)*b^(1/7)) + Log[a^(1/7) + b^(1/7)*x]/(7*a^(6/7)*b^(1/7)) - (Cos[Pi/7]*Log[a^(2/7) + b^(2/7)*x^2 - 2*a^(1/7)*b^(1/7)*x*Cos[Pi/7]])/(7*a^(6/7)*b^(1/7)) - (Log[a^(2/7) + b^(2/7)*x^2 - 2*a^(1/7)*b^(1/7)*x*Sin[Pi/14]]*Sin[Pi/14])/(7*a^(6/7)*b^(1/7)) - (2*ArcTan[Cot[Pi/7] - (b^(1/7)*x*Csc[Pi/7])/a^(1/7)]*Sin[Pi/7])/(7*a^(6/7)*b^(1/7)) + (Log[a^(2/7) + b^(2/7)*x^2 + 2*a^(1/7)*b^(1/7)*x*Sin[(3*Pi)/14]]*Sin[(3*Pi)/14])/(7*a^(6/7)*b^(1/7))}
{1/(x^1*(a + b*x^7)), x, 4, Log[x]/a - Log[a + b*x^7]/(7*a)}


{x^m/(a - b*x^7), x, 1, (x^(1 + m)*Hypergeometric2F1[1, (1 + m)/7, (8 + m)/7, (b*x^7)/a])/(a*(1 + m))}

{x^6/(a - b*x^7), x, 1, -(Log[a - b*x^7]/(7*b))}
{x^0/(a - b*x^7), x, 6, (2*ArcTan[(b^(1/7)*x*Sec[Pi/14])/a^(1/7) + Tan[Pi/14]]*Cos[Pi/14])/(7*a^(6/7)*b^(1/7)) + (2*ArcTan[(b^(1/7)*x*Sec[(3*Pi)/14])/a^(1/7) - Tan[(3*Pi)/14]]*Cos[(3*Pi)/14])/(7*a^(6/7)*b^(1/7)) - Log[a^(1/7) - b^(1/7)*x]/(7*a^(6/7)*b^(1/7)) + (Cos[Pi/7]*Log[a^(2/7) + b^(2/7)*x^2 + 2*a^(1/7)*b^(1/7)*x*Cos[Pi/7]])/(7*a^(6/7)*b^(1/7)) + (Log[a^(2/7) + b^(2/7)*x^2 + 2*a^(1/7)*b^(1/7)*x*Sin[Pi/14]]*Sin[Pi/14])/(7*a^(6/7)*b^(1/7)) + (2*ArcTan[Cot[Pi/7] + (b^(1/7)*x*Csc[Pi/7])/a^(1/7)]*Sin[Pi/7])/(7*a^(6/7)*b^(1/7)) - (Log[a^(2/7) + b^(2/7)*x^2 - 2*a^(1/7)*b^(1/7)*x*Sin[(3*Pi)/14]]*Sin[(3*Pi)/14])/(7*a^(6/7)*b^(1/7))}
{1/(x^1*(a - b*x^7)), x, 4, Log[x]/a - Log[a - b*x^7]/(7*a)}


{1/(1 - x^7), x, 6, (2/7)*ArcTan[Sec[Pi/14]*(x + Sin[Pi/14])]*Cos[Pi/14] + (2/7)*ArcTan[Sec[(3*Pi)/14]*(x - Sin[(3*Pi)/14])]*Cos[(3*Pi)/14] - (1/7)*Log[1 - x] + (1/7)*Cos[Pi/7]*Log[1 + x^2 + 2*x*Cos[Pi/7]] + (1/7)*Log[1 + x^2 + 2*x*Sin[Pi/14]]*Sin[Pi/14] + (2/7)*ArcTan[(x + Cos[Pi/7])*Csc[Pi/7]]*Sin[Pi/7] - (1/7)*Log[1 + x^2 - 2*x*Sin[(3*Pi)/14]]*Sin[(3*Pi)/14]}
{1/(1 + x^7), x, 6, (2/7)*ArcTan[x*Sec[Pi/14] - Tan[Pi/14]]*Cos[Pi/14] + (2/7)*ArcTan[x*Sec[(3*Pi)/14] + Tan[(3*Pi)/14]]*Cos[(3*Pi)/14] + (1/7)*Log[1 + x] - (1/7)*Cos[Pi/7]*Log[1 + x^2 - 2*x*Cos[Pi/7]] - (1/7)*Log[1 + x^2 - 2*x*Sin[Pi/14]]*Sin[Pi/14] - (2/7)*ArcTan[Cot[Pi/7] - x*Csc[Pi/7]]*Sin[Pi/7] + (1/7)*Log[1 + x^2 + 2*x*Sin[(3*Pi)/14]]*Sin[(3*Pi)/14]}


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b x^7)^p*)


(* ::Subsection:: *)
(*Integrands of the form x^m (a+b x^7)^(p/2)*)


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b x^7)^(p/2)*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^8)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^8)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^9/(a + b*x^8), x, 11, x^2/(2*b) + (a^(1/4)*ArcTan[1 - (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)])/(4*Sqrt[2]*b^(5/4)) - (a^(1/4)*ArcTan[1 + (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)])/(4*Sqrt[2]*b^(5/4)) + (a^(1/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4])/(8*Sqrt[2]*b^(5/4)) - (a^(1/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4])/(8*Sqrt[2]*b^(5/4))}
{x^7/(a + b*x^8), x, 1, Log[a + b*x^8]/(8*b)}
{x^5/(a + b*x^8), x, 10, -(ArcTan[1 - (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)]/(4*Sqrt[2]*a^(1/4)*b^(3/4))) + ArcTan[1 + (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)]/(4*Sqrt[2]*a^(1/4)*b^(3/4)) + Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4]/(8*Sqrt[2]*a^(1/4)*b^(3/4)) - Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4]/(8*Sqrt[2]*a^(1/4)*b^(3/4))}
{x^3/(a + b*x^8), x, 2, ArcTan[(Sqrt[b]*x^4)/Sqrt[a]]/(4*Sqrt[a]*Sqrt[b])}
{x^1/(a + b*x^8), x, 10, -(ArcTan[1 - (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)]/(4*Sqrt[2]*a^(3/4)*b^(1/4))) + ArcTan[1 + (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)]/(4*Sqrt[2]*a^(3/4)*b^(1/4)) - Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4]/(8*Sqrt[2]*a^(3/4)*b^(1/4)) + Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4]/(8*Sqrt[2]*a^(3/4)*b^(1/4))}
{1/(x^1*(a + b*x^8)), x, 4, Log[x]/a - Log[a + b*x^8]/(8*a)}
{1/(x^3*(a + b*x^8)), x, 11, -(1/(2*a*x^2)) + (b^(1/4)*ArcTan[1 - (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)])/(4*Sqrt[2]*a^(5/4)) - (b^(1/4)*ArcTan[1 + (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)])/(4*Sqrt[2]*a^(5/4)) - (b^(1/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4])/(8*Sqrt[2]*a^(5/4)) + (b^(1/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4])/(8*Sqrt[2]*a^(5/4))}
{1/(x^5*(a + b*x^8)), x, 3, -1/(4*a*x^4) - (Sqrt[b]*ArcTan[(Sqrt[b]*x^4)/Sqrt[a]])/(4*a^(3/2))}
{1/(x^7*(a + b*x^8)), x, 11, -(1/(6*a*x^6)) + (b^(3/4)*ArcTan[1 - (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)])/(4*Sqrt[2]*a^(7/4)) - (b^(3/4)*ArcTan[1 + (Sqrt[2]*b^(1/4)*x^2)/a^(1/4)])/(4*Sqrt[2]*a^(7/4)) + (b^(3/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4])/(8*Sqrt[2]*a^(7/4)) - (b^(3/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x^2 + Sqrt[b]*x^4])/(8*Sqrt[2]*a^(7/4))}
{1/(x^9*(a + b*x^8)), x, 3, -1/(8*a*x^8) - (b*Log[x])/a^2 + (b*Log[a + b*x^8])/(8*a^2)}

{x^8/(a + b*x^8), x, 14, x/b - ((-a)^(1/8)*ArcTan[(b^(1/8)*x)/(-a)^(1/8)])/(4*b^(9/8)) + ((-a)^(1/8)*ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*b^(9/8)) - ((-a)^(1/8)*ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*b^(9/8)) - ((-a)^(1/8)*ArcTanh[(b^(1/8)*x)/(-a)^(1/8)])/(4*b^(9/8)) + ((-a)^(1/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*b^(9/8)) - ((-a)^(1/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*b^(9/8))}
{x^6/(a + b*x^8), x, 13, ArcTan[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(1/8)*b^(7/8)) - ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(1/8)*b^(7/8)) + ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(1/8)*b^(7/8)) - ArcTanh[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(1/8)*b^(7/8)) + Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(1/8)*b^(7/8)) - Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(1/8)*b^(7/8))}
{x^4/(a + b*x^8), x, 13, -(ArcTan[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(3/8)*b^(5/8))) - ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(3/8)*b^(5/8)) + ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(3/8)*b^(5/8)) - ArcTanh[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(3/8)*b^(5/8)) - Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(3/8)*b^(5/8)) + Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(3/8)*b^(5/8))}
{x^2/(a + b*x^8), x, 13, ArcTan[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(5/8)*b^(3/8)) + ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(5/8)*b^(3/8)) - ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(5/8)*b^(3/8)) - ArcTanh[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(5/8)*b^(3/8)) - Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(5/8)*b^(3/8)) + Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(5/8)*b^(3/8))}
{x^0/(a + b*x^8), x, 13, -(ArcTan[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(7/8)*b^(1/8))) + ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(7/8)*b^(1/8)) - ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)]/(4*Sqrt[2]*(-a)^(7/8)*b^(1/8)) - ArcTanh[(b^(1/8)*x)/(-a)^(1/8)]/(4*(-a)^(7/8)*b^(1/8)) + Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(7/8)*b^(1/8)) - Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*(-a)^(7/8)*b^(1/8))}
{1/(x^2*(a + b*x^8)), x, 14, -(1/(a*x)) + (b^(1/8)*ArcTan[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(9/8)) - (b^(1/8)*ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(9/8)) + (b^(1/8)*ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(9/8)) - (b^(1/8)*ArcTanh[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(9/8)) + (b^(1/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(9/8)) - (b^(1/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(9/8))}
{1/(x^4*(a + b*x^8)), x, 14, -(1/(3*a*x^3)) - (b^(3/8)*ArcTan[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(11/8)) - (b^(3/8)*ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(11/8)) + (b^(3/8)*ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(11/8)) - (b^(3/8)*ArcTanh[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(11/8)) - (b^(3/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(11/8)) + (b^(3/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(11/8))}
{1/(x^6*(a + b*x^8)), x, 14, -(1/(5*a*x^5)) + (b^(5/8)*ArcTan[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(13/8)) + (b^(5/8)*ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(13/8)) - (b^(5/8)*ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(13/8)) - (b^(5/8)*ArcTanh[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(13/8)) - (b^(5/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(13/8)) + (b^(5/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(13/8))}
{1/(x^8*(a + b*x^8)), x, 14, -(1/(7*a*x^7)) - (b^(7/8)*ArcTan[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(15/8)) + (b^(7/8)*ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(15/8)) - (b^(7/8)*ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/(-a)^(1/8)])/(4*Sqrt[2]*(-a)^(15/8)) - (b^(7/8)*ArcTanh[(b^(1/8)*x)/(-a)^(1/8)])/(4*(-a)^(15/8)) + (b^(7/8)*Log[(-a)^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(15/8)) - (b^(7/8)*Log[(-a)^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + b^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(15/8))}


{1/(a - b*x^8), x, 13, ArcTan[(b^(1/8)*x)/a^(1/8)]/(4*a^(7/8)*b^(1/8)) - ArcTan[1 - (Sqrt[2]*b^(1/8)*x)/a^(1/8)]/(4*Sqrt[2]*a^(7/8)*b^(1/8)) + ArcTan[1 + (Sqrt[2]*b^(1/8)*x)/a^(1/8)]/(4*Sqrt[2]*a^(7/8)*b^(1/8)) + ArcTanh[(b^(1/8)*x)/a^(1/8)]/(4*a^(7/8)*b^(1/8)) - Log[a^(1/4) - Sqrt[2]*a^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*a^(7/8)*b^(1/8)) + Log[a^(1/4) + Sqrt[2]*a^(1/8)*b^(1/8)*x + b^(1/4)*x^2]/(8*Sqrt[2]*a^(7/8)*b^(1/8))}


{x^9/(1 - x^8), x, 5, -(x^2/2) + ArcTan[x^2]/4 + ArcTanh[x^2]/4}
{x^7/(1 - x^8), x, 1, (-(1/8))*Log[1 - x^8]}
{x^5/(1 - x^8), x, 4, (-(1/4))*ArcTan[x^2] + ArcTanh[x^2]/4}
{x^3/(1 - x^8), x, 2, ArcTanh[x^4]/4}
{x^1/(1 - x^8), x, 4, ArcTan[x^2]/4 + ArcTanh[x^2]/4}
{1/(x^1*(1 - x^8)), x, 4, Log[x] - (1/8)*Log[1 - x^8]}
{1/(x^3*(1 - x^8)), x, 5, -(1/(2*x^2)) - ArcTan[x^2]/4 + ArcTanh[x^2]/4}
{1/(x^5*(1 - x^8)), x, 3, -(1/(4*x^4)) + ArcTanh[x^4]/4}
{1/(x^7*(1 - x^8)), x, 5, -(1/(6*x^6)) + ArcTan[x^2]/4 + ArcTanh[x^2]/4}
{1/(x^9*(1 - x^8)), x, 3, -(1/(8*x^8)) + Log[x] - (1/8)*Log[1 - x^8]}

{x^8/(1 - x^8), x, 14, -x + ArcTan[x]/4 - ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) + ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 - Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{x^6/(1 - x^8), x, 13, -(ArcTan[x]/4) + ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) - ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 - Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{x^4/(1 - x^8), x, 13, ArcTan[x]/4 + ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) - ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 + Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) - Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{x^2/(1 - x^8), x, 13, -(ArcTan[x]/4) - ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) + ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 + Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) - Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{x^0/(1 - x^8), x, 13, ArcTan[x]/4 - ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) + ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 - Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{1/(x^2*(1 - x^8)), x, 14, -(1/x) - ArcTan[x]/4 + ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) - ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 - Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{1/(x^4*(1 - x^8)), x, 14, -(1/(3*x^3)) + ArcTan[x]/4 + ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) - ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 + Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) - Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{1/(x^6*(1 - x^8)), x, 14, -(1/(5*x^5)) - ArcTan[x]/4 - ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) + ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 + Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) - Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}
{1/(x^8*(1 - x^8)), x, 14, -(1/(7*x^7)) + ArcTan[x]/4 - ArcTan[1 - Sqrt[2]*x]/(4*Sqrt[2]) + ArcTan[1 + Sqrt[2]*x]/(4*Sqrt[2]) + ArcTanh[x]/4 - Log[1 - Sqrt[2]*x + x^2]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x + x^2]/(8*Sqrt[2])}


{x^9/(1 + x^8), x, 11, x^2/2 + ArcTan[1 - Sqrt[2]*x^2]/(4*Sqrt[2]) - ArcTan[1 + Sqrt[2]*x^2]/(4*Sqrt[2]) + Log[1 - Sqrt[2]*x^2 + x^4]/(8*Sqrt[2]) - Log[1 + Sqrt[2]*x^2 + x^4]/(8*Sqrt[2])}
{x^7/(1 + x^8), x, 1, (1/8)*Log[1 + x^8]}
{x^5/(1 + x^8), x, 10, -(ArcTan[1 - Sqrt[2]*x^2]/(4*Sqrt[2])) + ArcTan[1 + Sqrt[2]*x^2]/(4*Sqrt[2]) + Log[1 - Sqrt[2]*x^2 + x^4]/(8*Sqrt[2]) - Log[1 + Sqrt[2]*x^2 + x^4]/(8*Sqrt[2])}
{x^3/(1 + x^8), x, 2, ArcTan[x^4]/4}
{x^1/(1 + x^8), x, 10, -(ArcTan[1 - Sqrt[2]*x^2]/(4*Sqrt[2])) + ArcTan[1 + Sqrt[2]*x^2]/(4*Sqrt[2]) - Log[1 - Sqrt[2]*x^2 + x^4]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x^2 + x^4]/(8*Sqrt[2])}
{1/(x^1*(1 + x^8)), x, 4, Log[x] - (1/8)*Log[1 + x^8]}
{1/(x^3*(1 + x^8)), x, 11, -(1/(2*x^2)) + ArcTan[1 - Sqrt[2]*x^2]/(4*Sqrt[2]) - ArcTan[1 + Sqrt[2]*x^2]/(4*Sqrt[2]) - Log[1 - Sqrt[2]*x^2 + x^4]/(8*Sqrt[2]) + Log[1 + Sqrt[2]*x^2 + x^4]/(8*Sqrt[2])}
{1/(x^5*(1 + x^8)), x, 3, -(1/(4*x^4)) - ArcTan[x^4]/4}
{1/(x^7*(1 + x^8)), x, 11, -(1/(6*x^6)) + ArcTan[1 - Sqrt[2]*x^2]/(4*Sqrt[2]) - ArcTan[1 + Sqrt[2]*x^2]/(4*Sqrt[2]) + Log[1 - Sqrt[2]*x^2 + x^4]/(8*Sqrt[2]) - Log[1 + Sqrt[2]*x^2 + x^4]/(8*Sqrt[2])}
{1/(x^9*(1 + x^8)), x, 3, -(1/(8*x^8)) - Log[x] + (1/8)*Log[1 + x^8]}

{x^8/(1 + x^8), x, 20, x + ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) + ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) - ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) - ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) + (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2] + (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]}
{x^6/(1 + x^8), x, 21, -(ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])])) - ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) + ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) + ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) + (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2] + (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]}
{x^4/(1 + x^8), x, 19, ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) - ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) - ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) + ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) - Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) + Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) + Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])]) - Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])])}
{x^2/(1 + x^8), x, 19, (1/8)*Sqrt[2 - Sqrt[2]]*ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]] - (1/8)*Sqrt[2 + Sqrt[2]]*ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]] - (1/8)*Sqrt[2 - Sqrt[2]]*ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]] + (1/8)*Sqrt[2 + Sqrt[2]]*ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]] + Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) - Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) - Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])]) + Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])])}
{x^0/(1 + x^8), x, 19, -(ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])])) - ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) + ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) + ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) - (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2] + (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2] + (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]}
{1/(x^2*(1 + x^8)), x, 22, -(1/x) + ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) + ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) - ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) - ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) - (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2] + (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2] + (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]}
{1/(x^4*(1 + x^8)), x, 20, -(1/(3*x^3)) - ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) + ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) + ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) - ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) + Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) - Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) - Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])]) + Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])])}
{1/(x^6*(1 + x^8)), x, 20, -(1/(5*x^5)) - (1/8)*Sqrt[2 - Sqrt[2]]*ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]] + (1/8)*Sqrt[2 + Sqrt[2]]*ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]] + (1/8)*Sqrt[2 - Sqrt[2]]*ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]] - (1/8)*Sqrt[2 + Sqrt[2]]*ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]] - Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) + Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 - Sqrt[2])]) + Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])]) - Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]/(8*Sqrt[2*(2 + Sqrt[2])])}
{1/(x^8*(1 + x^8)), x, 20, -(1/(7*x^7)) + ArcTan[(Sqrt[2 - Sqrt[2]] - 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) + ArcTan[(Sqrt[2 + Sqrt[2]] - 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) - ArcTan[(Sqrt[2 - Sqrt[2]] + 2*x)/Sqrt[2 + Sqrt[2]]]/(4*Sqrt[2*(2 - Sqrt[2])]) - ArcTan[(Sqrt[2 + Sqrt[2]] + 2*x)/Sqrt[2 - Sqrt[2]]]/(4*Sqrt[2*(2 + Sqrt[2])]) + (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 - Sqrt[2 - Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 - Sqrt[2]]*Log[1 + Sqrt[2 - Sqrt[2]]*x + x^2] + (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 - Sqrt[2 + Sqrt[2]]*x + x^2] - (1/16)*Sqrt[2 + Sqrt[2]]*Log[1 + Sqrt[2 + Sqrt[2]]*x + x^2]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^8)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^8)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*Sqrt[1 + x^8], x, 3, (1/8)*x^4*Sqrt[1 + x^8] + ArcSinh[x^4]/8}
{x^1*Sqrt[1 + x^8], x, 3, (1/6)*x^2*Sqrt[1 + x^8] + ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(6*Sqrt[1 + x^8])}
{Sqrt[1 + x^8]/x^1, x, 4, Sqrt[1 + x^8]/4 - (1/4)*ArcTanh[Sqrt[1 + x^8]]}
{Sqrt[1 + x^8]/x^3, x, 5, -(Sqrt[1 + x^8]/(2*x^2)) + (x^2*Sqrt[1 + x^8])/(1 + x^4) - ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticE[2*ArcTan[x^2], 1/2])/Sqrt[1 + x^8] + ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(2*Sqrt[1 + x^8])}


{x^3*Sqrt[-2 + x^8], x, 4, (1/8)*x^4*Sqrt[-2 + x^8] - (1/4)*ArcTanh[x^4/Sqrt[-2 + x^8]]}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^19/Sqrt[1 + x^8], x, 4, (-(3/32))*x^4*Sqrt[1 + x^8] + (1/16)*x^12*Sqrt[1 + x^8] + (3*ArcSinh[x^4])/32}
{x^15/Sqrt[1 + x^8], x, 3, (-(1/4))*Sqrt[1 + x^8] + (1/12)*(1 + x^8)^(3/2)}
{x^11/Sqrt[1 + x^8], x, 3, (1/8)*x^4*Sqrt[1 + x^8] - ArcSinh[x^4]/8}
{x^7/Sqrt[1 + x^8], x, 1, Sqrt[1 + x^8]/4}
{x^3/Sqrt[1 + x^8], x, 2, ArcSinh[x^4]/4}
{1/(x^1*Sqrt[1 + x^8]), x, 3, -ArcTanh[Sqrt[1 + x^8]]/4}
{1/(x^5*Sqrt[1 + x^8]), x, 1, -(Sqrt[1 + x^8]/(4*x^4))}
{1/(x^9*Sqrt[1 + x^8]), x, 4, -(Sqrt[1 + x^8]/(8*x^8)) + (1/8)*ArcTanh[Sqrt[1 + x^8]]}
{1/(x^13*Sqrt[1 + x^8]), x, 2, -(Sqrt[1 + x^8]/(12*x^12)) + Sqrt[1 + x^8]/(6*x^4)}
{1/(x^17*Sqrt[1 + x^8]), x, 5, -(Sqrt[1 + x^8]/(16*x^16)) + (3*Sqrt[1 + x^8])/(32*x^8) - (3/32)*ArcTanh[Sqrt[1 + x^8]]}

{x^13/Sqrt[1 + x^8], x, 5, (1/10)*x^6*Sqrt[1 + x^8] - (3*x^2*Sqrt[1 + x^8])/(10*(1 + x^4)) + (3*(1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticE[2*ArcTan[x^2], 1/2])/(10*Sqrt[1 + x^8]) - (3*(1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(20*Sqrt[1 + x^8])}
{x^9/Sqrt[1 + x^8], x, 3, (1/6)*x^2*Sqrt[1 + x^8] - ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(12*Sqrt[1 + x^8])}
{x^5/Sqrt[1 + x^8], x, 4, (x^2*Sqrt[1 + x^8])/(2*(1 + x^4)) - ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticE[2*ArcTan[x^2], 1/2])/(2*Sqrt[1 + x^8]) + ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(4*Sqrt[1 + x^8])}
{x^1/Sqrt[1 + x^8], x, 2, ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(4*Sqrt[1 + x^8])}
{1/(x^3*Sqrt[1 + x^8]), x, 5, -(Sqrt[1 + x^8]/(2*x^2)) + (x^2*Sqrt[1 + x^8])/(2*(1 + x^4)) - ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticE[2*ArcTan[x^2], 1/2])/(2*Sqrt[1 + x^8]) + ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(4*Sqrt[1 + x^8])}
{1/(x^7*Sqrt[1 + x^8]), x, 3, -(Sqrt[1 + x^8]/(6*x^6)) - ((1 + x^4)*Sqrt[(1 + x^8)/(1 + x^4)^2]*EllipticF[2*ArcTan[x^2], 1/2])/(12*Sqrt[1 + x^8])}

{x^10/Sqrt[1 + x^8], x, 4, (1/7)*x^3*Sqrt[1 + x^8] + (3*x^3*Sqrt[(1 + x^2)^2/x^2]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[-((Sqrt[2] - 2*x^2 + Sqrt[2]*x^4)/x^2)]], -2*(1 - Sqrt[2])])/(14*Sqrt[2 + Sqrt[2]]*(1 + x^2)*Sqrt[1 + x^8]) + (3*x^3*Sqrt[-((1 - x^2)^2/x^2)]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[(Sqrt[2] + 2*x^2 + Sqrt[2]*x^4)/x^2]], -2*(1 - Sqrt[2])])/(14*Sqrt[2 + Sqrt[2]]*(1 - x^2)*Sqrt[1 + x^8])}
{x^8/Sqrt[1 + x^8], x, 4, (1/5)*x*Sqrt[1 + x^8] - (x^3*Sqrt[(1 + x^2)^2/x^2]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[-((Sqrt[2] - 2*x^2 + Sqrt[2]*x^4)/x^2)]], -2*(1 - Sqrt[2])])/(10*Sqrt[2 + Sqrt[2]]*(1 + x^2)*Sqrt[1 + x^8]) + (x^3*Sqrt[-((1 - x^2)^2/x^2)]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[(Sqrt[2] + 2*x^2 + Sqrt[2]*x^4)/x^2]], -2*(1 - Sqrt[2])])/(10*Sqrt[2 + Sqrt[2]]*(1 - x^2)*Sqrt[1 + x^8])}
{x^6/Sqrt[1 + x^8], x, 1, (1/7)*x^7*Hypergeometric2F1[1/2, 7/8, 15/8, -x^8]}
{x^4/Sqrt[1 + x^8], x, 1, (1/5)*x^5*Hypergeometric2F1[1/2, 5/8, 13/8, -x^8]}
{x^2/Sqrt[1 + x^8], x, 3, -((x^3*Sqrt[(1 + x^2)^2/x^2]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[-((Sqrt[2] - 2*x^2 + Sqrt[2]*x^4)/x^2)]], -2*(1 - Sqrt[2])])/(2*Sqrt[2 + Sqrt[2]]*(1 + x^2)*Sqrt[1 + x^8])) - (x^3*Sqrt[-((1 - x^2)^2/x^2)]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[(Sqrt[2] + 2*x^2 + Sqrt[2]*x^4)/x^2]], -2*(1 - Sqrt[2])])/(2*Sqrt[2 + Sqrt[2]]*(1 - x^2)*Sqrt[1 + x^8])}
{x^0/Sqrt[1 + x^8], x, 3, (x^3*Sqrt[(1 + x^2)^2/x^2]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[-((Sqrt[2] - 2*x^2 + Sqrt[2]*x^4)/x^2)]], -2*(1 - Sqrt[2])])/(2*Sqrt[2 + Sqrt[2]]*(1 + x^2)*Sqrt[1 + x^8]) - (x^3*Sqrt[-((1 - x^2)^2/x^2)]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[(Sqrt[2] + 2*x^2 + Sqrt[2]*x^4)/x^2]], -2*(1 - Sqrt[2])])/(2*Sqrt[2 + Sqrt[2]]*(1 - x^2)*Sqrt[1 + x^8])}
{1/(x^2*Sqrt[1 + x^8]), x, 2, -(Sqrt[1 + x^8]/x) + (3/7)*x^7*Hypergeometric2F1[1/2, 7/8, 15/8, -x^8]}
{1/(x^4*Sqrt[1 + x^8]), x, 2, -(Sqrt[1 + x^8]/(3*x^3)) + (1/15)*x^5*Hypergeometric2F1[1/2, 5/8, 13/8, -x^8]}
{1/(x^6*Sqrt[1 + x^8]), x, 4, -(Sqrt[1 + x^8]/(5*x^5)) + (x^3*Sqrt[(1 + x^2)^2/x^2]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[-((Sqrt[2] - 2*x^2 + Sqrt[2]*x^4)/x^2)]], -2*(1 - Sqrt[2])])/(10*Sqrt[2 + Sqrt[2]]*(1 + x^2)*Sqrt[1 + x^8]) + (x^3*Sqrt[-((1 - x^2)^2/x^2)]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[(Sqrt[2] + 2*x^2 + Sqrt[2]*x^4)/x^2]], -2*(1 - Sqrt[2])])/(10*Sqrt[2 + Sqrt[2]]*(1 - x^2)*Sqrt[1 + x^8])}
{1/(x^8*Sqrt[1 + x^8]), x, 4, -(Sqrt[1 + x^8]/(7*x^7)) - (3*x^3*Sqrt[(1 + x^2)^2/x^2]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[-((Sqrt[2] - 2*x^2 + Sqrt[2]*x^4)/x^2)]], -2*(1 - Sqrt[2])])/(14*Sqrt[2 + Sqrt[2]]*(1 + x^2)*Sqrt[1 + x^8]) + (3*x^3*Sqrt[-((1 - x^2)^2/x^2)]*Sqrt[-((1 + x^8)/x^4)]*EllipticF[ArcSin[(1/2)*Sqrt[(Sqrt[2] + 2*x^2 + Sqrt[2]*x^4)/x^2]], -2*(1 - Sqrt[2])])/(14*Sqrt[2 + Sqrt[2]]*(1 - x^2)*Sqrt[1 + x^8])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^8)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^10)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^10)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(1 - x^10), x, 10, (1/20)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(Sqrt[10 - 2*Sqrt[5]]*x)/(2*(1 - x^2))] + (1/20)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(Sqrt[10 + 2*Sqrt[5]]*x)/(2*(1 - x^2))] + ArcTanh[x]/5 + (1/20)*(1 - Sqrt[5])*ArcTanh[((1 - Sqrt[5])*x)/(2*(1 + x^2))] + (1/20)*(1 + Sqrt[5])*ArcTanh[((1 + Sqrt[5])*x)/(2*(1 + x^2))], (-(1/10))*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(1 - Sqrt[5] - 4*x)/Sqrt[2*(5 + Sqrt[5])]] - (1/10)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[(1/2)*Sqrt[(1/10)*(5 + Sqrt[5])]*(1 + Sqrt[5] - 4*x)] + (1/10)*Sqrt[(1/2)*(5 + Sqrt[5])]*ArcTan[(1 - Sqrt[5] + 4*x)/Sqrt[2*(5 + Sqrt[5])]] + (1/10)*Sqrt[(1/2)*(5 - Sqrt[5])]*ArcTan[(1/2)*Sqrt[(1/10)*(5 + Sqrt[5])]*(1 + Sqrt[5] + 4*x)] + ArcTanh[x]/5 - (1/40)*(1 - Sqrt[5])*Log[1 - (1/2)*(1 - Sqrt[5])*x + x^2] + (1/40)*(1 - Sqrt[5])*Log[1 + (1/2)*(1 - Sqrt[5])*x + x^2] - (1/40)*(1 + Sqrt[5])*Log[1 - (1/2)*(1 + Sqrt[5])*x + x^2] + (1/40)*(1 + Sqrt[5])*Log[1 + (1/2)*(1 + Sqrt[5])*x + x^2]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^10)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^10)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/Sqrt[1 - x^10], x, 2, ArcSin[x^5]/5}
{x^4/Sqrt[-2 + x^10], x, 3, (1/5)*ArcTanh[x^5/Sqrt[-2 + x^10]]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^10)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^12)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^12)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^5/(9 + x^12), x, 2, ArcTan[x^6/3]/18}
{x^5/(9 - x^12), x, 2, ArcTanh[x^6/3]/18}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^12)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^12)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^5*Sqrt[9 + x^12], x, 3, (1/12)*x^6*Sqrt[9 + x^12] + (3/4)*ArcSinh[x^6/3]}


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^12)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Title::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p when n<0 is an integer*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b/x)*x^6, x, 2, (b*x^6)/6 + (a*x^7)/7}
{(a + b/x)*x^5, x, 2, (b*x^5)/5 + (a*x^6)/6}
{(a + b/x)*x^4, x, 2, (b*x^4)/4 + (a*x^5)/5}
{(a + b/x)*x^3, x, 2, (b*x^3)/3 + (a*x^4)/4}
{(a + b/x)*x^2, x, 2, (b*x^2)/2 + (a*x^3)/3}
{(a + b/x)*x, x, 2, b*x + (a*x^2)/2}
{a + b/x, x, 1, a*x + b*Log[x]}
{(a + b/x)/x, x, 2, -(b/x) + a*Log[x]}
{(a + b/x)/x^2, x, 2, -(b/(2*x^2)) - a/x}
{(a + b/x)/x^3, x, 2, -b/(3*x^3) - a/(2*x^2)}
{(a + b/x)/x^4, x, 2, -b/(4*x^4) - a/(3*x^3)}
{(a + b/x)/x^5, x, 2, -b/(5*x^5) - a/(4*x^4)}
{(a + b/x)/x^6, x, 2, -b/(6*x^6) - a/(5*x^5)}


{(a + b/x)^2*x^5, x, 3, (b^2*x^4)/4 + (2*a*b*x^5)/5 + (a^2*x^6)/6}
{(a + b/x)^2*x^4, x, 3, (b^2*x^3)/3 + (a*b*x^4)/2 + (a^2*x^5)/5}
{(a + b/x)^2*x^3, x, 3, (b^2*x^2)/2 + (2/3)*a*b*x^3 + (a^2*x^4)/4}
{(a + b/x)^2*x^2, x, 2, (b + a*x)^3/(3*a)}
{(a + b/x)^2*x, x, 3, 2*a*b*x + (a^2*x^2)/2 + b^2*Log[x]}
{(a + b/x)^2, x, 3, -(b^2/x) + a^2*x + 2*a*b*Log[x]}
{(a + b/x)^2/x, x, 3, -b^2/(2*x^2) - (2*a*b)/x + a^2*Log[x]}
{(a + b/x)^2/x^2, x, 1, -(a + b/x)^3/(3*b)}
{(a + b/x)^2/x^3, x, 3, -b^2/(4*x^4) - (2*a*b)/(3*x^3) - a^2/(2*x^2)}
{(a + b/x)^2/x^4, x, 3, -b^2/(5*x^5) - (a*b)/(2*x^4) - a^2/(3*x^3)}
{(a + b/x)^2/x^5, x, 3, -b^2/(6*x^6) - (2*a*b)/(5*x^5) - a^2/(4*x^4)}


{(a + b/x)^3*x^6, x, 3, (b^3*x^4)/4 + (3*a*b^2*x^5)/5 + (a^2*b*x^6)/2 + (a^3*x^7)/7}
{(a + b/x)^3*x^5, x, 3, (b^3*x^3)/3 + (3/4)*a*b^2*x^4 + (3/5)*a^2*b*x^5 + (a^3*x^6)/6}
{(a + b/x)^3*x^4, x, 3, -(b*(b + a*x)^4)/(4*a^2) + (b + a*x)^5/(5*a^2)}
{(a + b/x)^3*x^3, x, 2, (b + a*x)^4/(4*a)}
{(a + b/x)^3*x^2, x, 3, 3*a*b^2*x + (3*a^2*b*x^2)/2 + (a^3*x^3)/3 + b^3*Log[x]}
{(a + b/x)^3*x, x, 3, -(b^3/x) + 3*a^2*b*x + (a^3*x^2)/2 + 3*a*b^2*Log[x]}
{(a + b/x)^3, x, 3, -b^3/(2*x^2) - (3*a*b^2)/x + a^3*x + 3*a^2*b*Log[x]}
{(a + b/x)^3/x, x, 3, -b^3/(3*x^3) - (3*a*b^2)/(2*x^2) - (3*a^2*b)/x + a^3*Log[x]}
{(a + b/x)^3/x^2, x, 1, -(a + b/x)^4/(4*b)}
{(a + b/x)^3/x^3, x, 3, -((b + a*x)^4/(5*b*x^5)) + (a*(b + a*x)^4)/(20*b^2*x^4)}
{(a + b/x)^3/x^4, x, 3, -b^3/(6*x^6) - (3*a*b^2)/(5*x^5) - (3*a^2*b)/(4*x^4) - a^3/(3*x^3)}
{(a + b/x)^3/x^5, x, 3, -b^3/(7*x^7) - (a*b^2)/(2*x^6) - (3*a^2*b)/(5*x^5) - a^3/(4*x^4)}
{(a + b/x)^3/x^6, x, 3, -b^3/(8*x^8) - (3*a*b^2)/(7*x^7) - (a^2*b)/(2*x^6) - a^3/(5*x^5)}


{(a + b/x)^8*x^16, x, 3, (b^8*x^9)/9 + (4/5)*a*b^7*x^10 + (28/11)*a^2*b^6*x^11 + (14/3)*a^3*b^5*x^12 + (70/13)*a^4*b^4*x^13 + 4*a^5*b^3*x^14 + (28/15)*a^6*b^2*x^15 + (1/2)*a^7*b*x^16 + (a^8*x^17)/17}
{(a + b/x)^8*x^15, x, 3, (b^8*x^8)/8 + (8/9)*a*b^7*x^9 + (14/5)*a^2*b^6*x^10 + (56/11)*a^3*b^5*x^11 + (35/6)*a^4*b^4*x^12 + (56/13)*a^5*b^3*x^13 + 2*a^6*b^2*x^14 + (8/15)*a^7*b*x^15 + (a^8*x^16)/16}
{(a + b/x)^8*x^13, x, 3, -((b^5*(b + a*x)^9)/(9*a^6)) + (b^4*(b + a*x)^10)/(2*a^6) - (10*b^3*(b + a*x)^11)/(11*a^6) + (5*b^2*(b + a*x)^12)/(6*a^6) - (5*b*(b + a*x)^13)/(13*a^6) + (b + a*x)^14/(14*a^6)}
{(a + b/x)^8*x^12, x, 3, (b^4*(b + a*x)^9)/(9*a^5) - (2*b^3*(b + a*x)^10)/(5*a^5) + (6*b^2*(b + a*x)^11)/(11*a^5) - (b*(b + a*x)^12)/(3*a^5) + (b + a*x)^13/(13*a^5)}
{(a + b/x)^8*x^11, x, 3, -((b^3*(b + a*x)^9)/(9*a^4)) + (3*b^2*(b + a*x)^10)/(10*a^4) - (3*b*(b + a*x)^11)/(11*a^4) + (b + a*x)^12/(12*a^4)}
{(a + b/x)^8*x^10, x, 3, (b^2*(b + a*x)^9)/(9*a^3) - (b*(b + a*x)^10)/(5*a^3) + (b + a*x)^11/(11*a^3)}
{(a + b/x)^8*x^9, x, 3, -((b*(b + a*x)^9)/(9*a^2)) + (b + a*x)^10/(10*a^2)}
{(a + b/x)^8*x^8, x, 2, (b + a*x)^9/(9*a)}
{(a + b/x)^8*x^7, x, 3, 8*a*b^7*x + 14*a^2*b^6*x^2 + (56/3)*a^3*b^5*x^3 + (35/2)*a^4*b^4*x^4 + (56/5)*a^5*b^3*x^5 + (14/3)*a^6*b^2*x^6 + (8/7)*a^7*b*x^7 + (a^8*x^8)/8 + b^8*Log[x]}
{(a + b/x)^8*x^6, x, 3, -(b^8/x) + 28*a^2*b^6*x + 28*a^3*b^5*x^2 + (70/3)*a^4*b^4*x^3 + 14*a^5*b^3*x^4 + (28/5)*a^6*b^2*x^5 + (4/3)*a^7*b*x^6 + (a^8*x^7)/7 + 8*a*b^7*Log[x]}
{(a + b/x)^8*x^5, x, 3, -(b^8/(2*x^2)) - (8*a*b^7)/x + 56*a^3*b^5*x + 35*a^4*b^4*x^2 + (56/3)*a^5*b^3*x^3 + 7*a^6*b^2*x^4 + (8/5)*a^7*b*x^5 + (a^8*x^6)/6 + 28*a^2*b^6*Log[x]}
{(a + b/x)^8*x^4, x, 3, -(b^8/(3*x^3)) - (4*a*b^7)/x^2 - (28*a^2*b^6)/x + 70*a^4*b^4*x + 28*a^5*b^3*x^2 + (28/3)*a^6*b^2*x^3 + 2*a^7*b*x^4 + (a^8*x^5)/5 + 56*a^3*b^5*Log[x]}
{(a + b/x)^8*x^3, x, 3, -(b^8/(4*x^4)) - (8*a*b^7)/(3*x^3) - (14*a^2*b^6)/x^2 - (56*a^3*b^5)/x + 56*a^5*b^3*x + 14*a^6*b^2*x^2 + (8/3)*a^7*b*x^3 + (a^8*x^4)/4 + 70*a^4*b^4*Log[x]}
{(a + b/x)^8*x^2, x, 3, -(b^8/(5*x^5)) - (2*a*b^7)/x^4 - (28*a^2*b^6)/(3*x^3) - (28*a^3*b^5)/x^2 - (70*a^4*b^4)/x + 28*a^6*b^2*x + 4*a^7*b*x^2 + (a^8*x^3)/3 + 56*a^5*b^3*Log[x]}
{(a + b/x)^8*x^1, x, 3, -(b^8/(6*x^6)) - (8*a*b^7)/(5*x^5) - (7*a^2*b^6)/x^4 - (56*a^3*b^5)/(3*x^3) - (35*a^4*b^4)/x^2 - (56*a^5*b^3)/x + 8*a^7*b*x + (a^8*x^2)/2 + 28*a^6*b^2*Log[x]}
{(a + b/x)^8*x^0, x, 3, -(b^8/(7*x^7)) - (4*a*b^7)/(3*x^6) - (28*a^2*b^6)/(5*x^5) - (14*a^3*b^5)/x^4 - (70*a^4*b^4)/(3*x^3) - (28*a^5*b^3)/x^2 - (28*a^6*b^2)/x + a^8*x + 8*a^7*b*Log[x]}
{(a + b/x)^8/x^1, x, 3, -(b^8/(8*x^8)) - (8*a*b^7)/(7*x^7) - (14*a^2*b^6)/(3*x^6) - (56*a^3*b^5)/(5*x^5) - (35*a^4*b^4)/(2*x^4) - (56*a^5*b^3)/(3*x^3) - (14*a^6*b^2)/x^2 - (8*a^7*b)/x + a^8*Log[x]}
{(a + b/x)^8/x^2, x, 1, -((a + b/x)^9/(9*b))}
{(a + b/x)^8/x^3, x, 3, -((b + a*x)^9/(10*b*x^10)) + (a*(b + a*x)^9)/(90*b^2*x^9)}
{(a + b/x)^8/x^4, x, 4, -((b + a*x)^9/(11*b*x^11)) + (a*(b + a*x)^9)/(55*b^2*x^10) - (a^2*(b + a*x)^9)/(495*b^3*x^9)}
{(a + b/x)^8/x^5, x, 5, -((b + a*x)^9/(12*b*x^12)) + (a*(b + a*x)^9)/(44*b^2*x^11) - (a^2*(b + a*x)^9)/(220*b^3*x^10) + (a^3*(b + a*x)^9)/(1980*b^4*x^9)}
{(a + b/x)^8/x^6, x, 6, -((b + a*x)^9/(13*b*x^13)) + (a*(b + a*x)^9)/(39*b^2*x^12) - (a^2*(b + a*x)^9)/(143*b^3*x^11) + (a^3*(b + a*x)^9)/(715*b^4*x^10) - (a^4*(b + a*x)^9)/(6435*b^5*x^9)}
{(a + b/x)^8/x^7, x, 3, -(b^8/(14*x^14)) - (8*a*b^7)/(13*x^13) - (7*a^2*b^6)/(3*x^12) - (56*a^3*b^5)/(11*x^11) - (7*a^4*b^4)/x^10 - (56*a^5*b^3)/(9*x^9) - (7*a^6*b^2)/(2*x^8) - (8*a^7*b)/(7*x^7) - a^8/(6*x^6)}
{(a + b/x)^8/x^8, x, 3, -(b^8/(15*x^15)) - (4*a*b^7)/(7*x^14) - (28*a^2*b^6)/(13*x^13) - (14*a^3*b^5)/(3*x^12) - (70*a^4*b^4)/(11*x^11) - (28*a^5*b^3)/(5*x^10) - (28*a^6*b^2)/(9*x^9) - (a^7*b)/x^8 - a^8/(7*x^7)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^4/(a + b/x), x, 3, (b^4*x)/a^5 - (b^3*x^2)/(2*a^4) + (b^2*x^3)/(3*a^3) - (b*x^4)/(4*a^2) + x^5/(5*a) - (b^5*Log[b + a*x])/a^6}
{x^3/(a + b/x), x, 3, -((b^3*x)/a^4) + (b^2*x^2)/(2*a^3) - (b*x^3)/(3*a^2) + x^4/(4*a) + (b^4*Log[b + a*x])/a^5}
{x^2/(a + b/x), x, 3, (b^2*x)/a^3 - (b*x^2)/(2*a^2) + x^3/(3*a) - (b^3*Log[b + a*x])/a^4}
{x/(a + b/x), x, 3, -((b*x)/a^2) + x^2/(2*a) + (b^2*Log[b + a*x])/a^3}
{1/(a + b/x), x, 3, x/a - (b*Log[b + a*x])/a^2}
{1/((a + b/x)*x), x, 2, Log[b + a*x]/a}
{1/((a + b/x)*x^2), x, 1, -(Log[a + b/x]/b)}
{1/((a + b/x)*x^3), x, 3, -(1/(b*x)) - (a*Log[x])/b^2 + (a*Log[b + a*x])/b^2}
{1/((a + b/x)*x^4), x, 3, -(1/(2*b*x^2)) + a/(b^2*x) + (a^2*Log[x])/b^3 - (a^2*Log[b + a*x])/b^3}
{1/((a + b/x)*x^5), x, 3, -(1/(3*b*x^3)) + a/(2*b^2*x^2) - a^2/(b^3*x) - (a^3*Log[x])/b^4 + (a^3*Log[b + a*x])/b^4}
{1/((a + b/x)*x^6), x, 3, -(1/(4*b*x^4)) + a/(3*b^2*x^3) - a^2/(2*b^3*x^2) + a^3/(b^4*x) + (a^4*Log[x])/b^5 - (a^4*Log[b + a*x])/b^5}
{1/((a + b/x)*x^7), x, 3, -(1/(5*b*x^5)) + a/(4*b^2*x^4) - a^2/(3*b^3*x^3) + a^3/(2*b^4*x^2) - a^4/(b^5*x) - (a^5*Log[x])/b^6 + (a^5*Log[b + a*x])/b^6}


{x^5/(a + b/x)^2, x, 3, (-6*b^5*x)/a^7 + (5*b^4*x^2)/(2*a^6) - (4*b^3*x^3)/(3*a^5) + (3*b^2*x^4)/(4*a^4) - (2*b*x^5)/(5*a^3) + x^6/(6*a^2) + b^7/(a^8*(b + a*x)) + (7*b^6*Log[b + a*x])/a^8}
{x^4/(a + b/x)^2, x, 3, (5*b^4*x)/a^6 - (2*b^3*x^2)/a^5 + (b^2*x^3)/a^4 - (b*x^4)/(2*a^3) + x^5/(5*a^2) - b^6/(a^7*(b + a*x)) - (6*b^5*Log[b + a*x])/a^7}
{x^3/(a + b/x)^2, x, 3, (-4*b^3*x)/a^5 + (3*b^2*x^2)/(2*a^4) - (2*b*x^3)/(3*a^3) + x^4/(4*a^2) + b^5/(a^6*(b + a*x)) + (5*b^4*Log[b + a*x])/a^6}
{x^2/(a + b/x)^2, x, 3, (3*b^2*x)/a^4 - (b*x^2)/a^3 + x^3/(3*a^2) - b^4/(a^5*(b + a*x)) - (4*b^3*Log[b + a*x])/a^5}
{x/(a + b/x)^2, x, 3, (-2*b*x)/a^3 + x^2/(2*a^2) + b^3/(a^4*(b + a*x)) + (3*b^2*Log[b + a*x])/a^4}
{1/(a + b/x)^2, x, 4, (2*x)/a^2 - x/(a*(a + b/x)) - (2*b*Log[b + a*x])/a^3}
{1/((a + b/x)^2*x), x, 3, b/(a^2*(b + a*x)) + Log[b + a*x]/a^2}
{1/((a + b/x)^2*x^2), x, 1, 1/(b*(a + b/x))}
{1/((a + b/x)^2*x^3), x, 3, 1/(b*(b + a*x)) + Log[x]/b^2 - Log[b + a*x]/b^2}
{1/((a + b/x)^2*x^4), x, 3, -(1/(b^2*x)) - a/(b^2*(b + a*x)) - (2*a*Log[x])/b^3 + (2*a*Log[b + a*x])/b^3}
{1/((a + b/x)^2*x^5), x, 3, -(1/(2*b^2*x^2)) + (2*a)/(b^3*x) + a^2/(b^3*(b + a*x)) + (3*a^2*Log[x])/b^4 - (3*a^2*Log[b + a*x])/b^4}
{1/((a + b/x)^2*x^6), x, 3, -(1/(3*b^2*x^3)) + a/(b^3*x^2) - (3*a^2)/(b^4*x) - a^3/(b^4*(b + a*x)) - (4*a^3*Log[x])/b^5 + (4*a^3*Log[b + a*x])/b^5}
{1/((a + b/x)^2*x^7), x, 3, -(1/(4*b^2*x^4)) + (2*a)/(3*b^3*x^3) - (3*a^2)/(2*b^4*x^2) + (4*a^3)/(b^5*x) + a^4/(b^5*(b + a*x)) + (5*a^4*Log[x])/b^6 - (5*a^4*Log[b + a*x])/b^6}
{1/((a + b/x)^2*x^8), x, 3, -(1/(5*b^2*x^5)) + a/(2*b^3*x^4) - a^2/(b^4*x^3) + (2*a^3)/(b^5*x^2) - (5*a^4)/(b^6*x) - a^5/(b^6*(b + a*x)) - (6*a^5*Log[x])/b^7 + (6*a^5*Log[b + a*x])/b^7}


{x^4/(a + b/x)^3, x, 3, (15*b^4*x)/a^7 - (5*b^3*x^2)/a^6 + (2*b^2*x^3)/a^5 - (3*b*x^4)/(4*a^4) + x^5/(5*a^3) + b^7/(2*a^8*(b + a*x)^2) - (7*b^6)/(a^8*(b + a*x)) - (21*b^5*Log[b + a*x])/a^8}
{x^3/(a + b/x)^3, x, 3, (-10*b^3*x)/a^6 + (3*b^2*x^2)/a^5 - (b*x^3)/a^4 + x^4/(4*a^3) - b^6/(2*a^7*(b + a*x)^2) + (6*b^5)/(a^7*(b + a*x)) + (15*b^4*Log[b + a*x])/a^7}
{x^2/(a + b/x)^3, x, 3, (6*b^2*x)/a^5 - (3*b*x^2)/(2*a^4) + x^3/(3*a^3) + b^5/(2*a^6*(b + a*x)^2) - (5*b^4)/(a^6*(b + a*x)) - (10*b^3*Log[b + a*x])/a^6}
{x/(a + b/x)^3, x, 3, (-3*b*x)/a^4 + x^2/(2*a^3) - b^4/(2*a^5*(b + a*x)^2) + (4*b^3)/(a^5*(b + a*x)) + (6*b^2*Log[b + a*x])/a^5}
{1/(a + b/x)^3, x, 5, (3*x)/a^3 - x/(2*a*(a + b/x)^2) - (3*x)/(2*a^2*(a + b/x)) - (3*b*Log[b + a*x])/a^4}
{1/((a + b/x)^3*x), x, 3, -(b^2/(2*a^3*(b + a*x)^2)) + (2*b)/(a^3*(b + a*x)) + Log[b + a*x]/a^3}
{1/((a + b/x)^3*x^2), x, 1, 1/(2*b*(a + b/x)^2)}
{1/((a + b/x)^3*x^3), x, 2, -(1/(2*a*(b + a*x)^2))}
{1/((a + b/x)^3*x^4), x, 3, 1/(2*b*(b + a*x)^2) + 1/(b^2*(b + a*x)) + Log[x]/b^3 - Log[b + a*x]/b^3}
{1/((a + b/x)^3*x^5), x, 3, -(1/(b^3*x)) - a/(2*b^2*(b + a*x)^2) - (2*a)/(b^3*(b + a*x)) - (3*a*Log[x])/b^4 + (3*a*Log[b + a*x])/b^4}
{1/((a + b/x)^3*x^6), x, 3, -(1/(2*b^3*x^2)) + (3*a)/(b^4*x) + a^2/(2*b^3*(b + a*x)^2) + (3*a^2)/(b^4*(b + a*x)) + (6*a^2*Log[x])/b^5 - (6*a^2*Log[b + a*x])/b^5}
{1/((a + b/x)^3*x^7), x, 3, -(1/(3*b^3*x^3)) + (3*a)/(2*b^4*x^2) - (6*a^2)/(b^5*x) - a^3/(2*b^4*(b + a*x)^2) - (4*a^3)/(b^5*(b + a*x)) - (10*a^3*Log[x])/b^6 + (10*a^3*Log[b + a*x])/b^6}
{1/((a + b/x)^3*x^8), x, 3, -(1/(4*b^3*x^4)) + a/(b^4*x^3) - (3*a^2)/(b^5*x^2) + (10*a^3)/(b^6*x) + a^4/(2*b^5*(b + a*x)^2) + (5*a^4)/(b^6*(b + a*x)) + (15*a^4*Log[x])/b^7 - (15*a^4*Log[b + a*x])/b^7}
{1/((a + b/x)^3*x^9), x, 3, -(1/(5*b^3*x^5)) + (3*a)/(4*b^4*x^4) - (2*a^2)/(b^5*x^3) + (5*a^3)/(b^6*x^2) - (15*a^4)/(b^7*x) - a^5/(2*b^6*(b + a*x)^2) - (6*a^5)/(b^7*(b + a*x)) - (21*a^5*Log[x])/b^8 + (21*a^5*Log[b + a*x])/b^8}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b/x)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b/x)*x^(5/2), x, 2, (2/5)*b*x^(5/2) + (2/7)*a*x^(7/2)}
{(a + b/x)*x^(3/2), x, 2, (2/3)*b*x^(3/2) + (2/5)*a*x^(5/2)}
{(a + b/x)*x^(1/2), x, 2, 2*b*Sqrt[x] + (2/3)*a*x^(3/2)}
{(a + b/x)/x^(1/2), x, 2, -((2*b)/Sqrt[x]) + 2*a*Sqrt[x]}
{(a + b/x)/x^(3/2), x, 2, -((2*b)/(3*x^(3/2))) - (2*a)/Sqrt[x]}
{(a + b/x)/x^(5/2), x, 2, -((2*b)/(5*x^(5/2))) - (2*a)/(3*x^(3/2))}


{(a + b/x)^2*x^(5/2), x, 3, (2/3)*b^2*x^(3/2) + (4/5)*a*b*x^(5/2) + (2/7)*a^2*x^(7/2)}
{(a + b/x)^2*x^(3/2), x, 3, 2*b^2*Sqrt[x] + (4/3)*a*b*x^(3/2) + (2/5)*a^2*x^(5/2)}
{(a + b/x)^2*x^(1/2), x, 3, -((2*b^2)/Sqrt[x]) + 4*a*b*Sqrt[x] + (2/3)*a^2*x^(3/2)}
{(a + b/x)^2/x^(1/2), x, 3, -((2*b^2)/(3*x^(3/2))) - (4*a*b)/Sqrt[x] + 2*a^2*Sqrt[x]}
{(a + b/x)^2/x^(3/2), x, 3, -((2*b^2)/(5*x^(5/2))) - (4*a*b)/(3*x^(3/2)) - (2*a^2)/Sqrt[x]}
{(a + b/x)^2/x^(5/2), x, 3, -((2*b^2)/(7*x^(7/2))) - (4*a*b)/(5*x^(5/2)) - (2*a^2)/(3*x^(3/2))}


{(a + b/x)^3*x^(5/2), x, 3, 2*b^3*Sqrt[x] + 2*a*b^2*x^(3/2) + (6/5)*a^2*b*x^(5/2) + (2/7)*a^3*x^(7/2)}
{(a + b/x)^3*x^(3/2), x, 3, -((2*b^3)/Sqrt[x]) + 6*a*b^2*Sqrt[x] + 2*a^2*b*x^(3/2) + (2/5)*a^3*x^(5/2)}
{(a + b/x)^3*x^(1/2), x, 3, -((2*b^3)/(3*x^(3/2))) - (6*a*b^2)/Sqrt[x] + 6*a^2*b*Sqrt[x] + (2/3)*a^3*x^(3/2)}
{(a + b/x)^3/x^(1/2), x, 3, -((2*b^3)/(5*x^(5/2))) - (2*a*b^2)/x^(3/2) - (6*a^2*b)/Sqrt[x] + 2*a^3*Sqrt[x]}
{(a + b/x)^3/x^(3/2), x, 3, -((2*b^3)/(7*x^(7/2))) - (6*a*b^2)/(5*x^(5/2)) - (2*a^2*b)/x^(3/2) - (2*a^3)/Sqrt[x]}
{(a + b/x)^3/x^(5/2), x, 3, -((2*b^3)/(9*x^(9/2))) - (6*a*b^2)/(7*x^(7/2)) - (6*a^2*b)/(5*x^(5/2)) - (2*a^3)/(3*x^(3/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(a + b/x)*x^(5/2), x, 7, -((2*b^3*Sqrt[x])/a^4) + (2*b^2*x^(3/2))/(3*a^3) - (2*b*x^(5/2))/(5*a^2) + (2*x^(7/2))/(7*a) + (2*b^(7/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(9/2)}
{1/(a + b/x)*x^(3/2), x, 6, (2*b^2*Sqrt[x])/a^3 - (2*b*x^(3/2))/(3*a^2) + (2*x^(5/2))/(5*a) - (2*b^(5/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(7/2)}
{1/(a + b/x)*x^(1/2), x, 5, -((2*b*Sqrt[x])/a^2) + (2*x^(3/2))/(3*a) + (2*b^(3/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(5/2)}
{1/(a + b/x)/x^(1/2), x, 4, (2*Sqrt[x])/a - (2*Sqrt[b]*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(3/2)}
{1/(a + b/x)/x^(3/2), x, 3, (2*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(Sqrt[a]*Sqrt[b])}
{1/(a + b/x)/x^(5/2), x, 4, -(2/(b*Sqrt[x])) - (2*Sqrt[a]*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/b^(3/2)}
{1/(a + b/x)/x^(7/2), x, 5, -(2/(3*b*x^(3/2))) + (2*a)/(b^2*Sqrt[x]) + (2*a^(3/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/b^(5/2)}
{1/(a + b/x)/x^(9/2), x, 6, -(2/(5*b*x^(5/2))) + (2*a)/(3*b^2*x^(3/2)) - (2*a^2)/(b^3*Sqrt[x]) - (2*a^(5/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/b^(7/2)}


{1/(a + b/x)^2*x^(5/2), x, 8, -((9*b^3*Sqrt[x])/a^5) + (3*b^2*x^(3/2))/a^4 - (9*b*x^(5/2))/(5*a^3) + (9*x^(7/2))/(7*a^2) - x^(9/2)/(a*(b + a*x)) + (9*b^(7/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(11/2)}
{1/(a + b/x)^2*x^(3/2), x, 7, (7*b^2*Sqrt[x])/a^4 - (7*b*x^(3/2))/(3*a^3) + (7*x^(5/2))/(5*a^2) - x^(7/2)/(a*(b + a*x)) - (7*b^(5/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(9/2)}
{1/(a + b/x)^2*x^(1/2), x, 6, -((5*b*Sqrt[x])/a^3) + (5*x^(3/2))/(3*a^2) - x^(5/2)/(a*(b + a*x)) + (5*b^(3/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(7/2)}
{1/(a + b/x)^2/x^(1/2), x, 5, (3*Sqrt[x])/a^2 - x^(3/2)/(a*(b + a*x)) - (3*Sqrt[b]*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/a^(5/2)}
{1/(a + b/x)^2/x^(3/2), x, 4, -(Sqrt[x]/(a*(b + a*x))) + ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]]/(a^(3/2)*Sqrt[b])}
{1/(a + b/x)^2/x^(5/2), x, 4, Sqrt[x]/(b*(b + a*x)) + ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]]/(Sqrt[a]*b^(3/2))}
{1/(a + b/x)^2/x^(7/2), x, 5, -(3/(b^2*Sqrt[x])) + 1/(b*Sqrt[x]*(b + a*x)) - (3*Sqrt[a]*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/b^(5/2)}
{1/(a + b/x)^2/x^(9/2), x, 6, -(5/(3*b^2*x^(3/2))) + (5*a)/(b^3*Sqrt[x]) + 1/(b*x^(3/2)*(b + a*x)) + (5*a^(3/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/b^(7/2)}
{1/(a + b/x)^2/x^(11/2), x, 7, -(7/(5*b^2*x^(5/2))) + (7*a)/(3*b^3*x^(3/2)) - (7*a^2)/(b^4*Sqrt[x]) + 1/(b*x^(5/2)*(b + a*x)) - (7*a^(5/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/b^(9/2)}


{1/(a + b/x)^3*x^(3/2), x, 8, (63*b^2*Sqrt[x])/(4*a^5) - (21*b*x^(3/2))/(4*a^4) + (63*x^(5/2))/(20*a^3) - x^(9/2)/(2*a*(b + a*x)^2) - (9*x^(7/2))/(4*a^2*(b + a*x)) - (63*b^(5/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*a^(11/2))}
{1/(a + b/x)^3*x^(1/2), x, 7, -((35*b*Sqrt[x])/(4*a^4)) + (35*x^(3/2))/(12*a^3) - x^(7/2)/(2*a*(b + a*x)^2) - (7*x^(5/2))/(4*a^2*(b + a*x)) + (35*b^(3/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*a^(9/2))}
{1/(a + b/x)^3/x^(1/2), x, 6, (15*Sqrt[x])/(4*a^3) - x^(5/2)/(2*a*(b + a*x)^2) - (5*x^(3/2))/(4*a^2*(b + a*x)) - (15*Sqrt[b]*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*a^(7/2))}
{1/(a + b/x)^3/x^(3/2), x, 5, -(x^(3/2)/(2*a*(b + a*x)^2)) - (3*Sqrt[x])/(4*a^2*(b + a*x)) + (3*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*a^(5/2)*Sqrt[b])}
{1/(a + b/x)^3/x^(5/2), x, 5, -(Sqrt[x]/(2*a*(b + a*x)^2)) + Sqrt[x]/(4*a*b*(b + a*x)) + ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]]/(4*a^(3/2)*b^(3/2))}
{1/(a + b/x)^3/x^(7/2), x, 5, Sqrt[x]/(2*b*(b + a*x)^2) + (3*Sqrt[x])/(4*b^2*(b + a*x)) + (3*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*Sqrt[a]*b^(5/2))}
{1/(a + b/x)^3/x^(9/2), x, 6, -(15/(4*b^3*Sqrt[x])) + 1/(2*b*Sqrt[x]*(b + a*x)^2) + 5/(4*b^2*Sqrt[x]*(b + a*x)) - (15*Sqrt[a]*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*b^(7/2))}
{1/(a + b/x)^3/x^(11/2), x, 7, -(35/(12*b^3*x^(3/2))) + (35*a)/(4*b^4*Sqrt[x]) + 1/(2*b*x^(3/2)*(b + a*x)^2) + 7/(4*b^2*x^(3/2)*(b + a*x)) + (35*a^(3/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*b^(9/2))}
{1/(a + b/x)^3/x^(13/2), x, 8, -(63/(20*b^3*x^(5/2))) + (21*a)/(4*b^4*x^(3/2)) - (63*a^2)/(4*b^5*Sqrt[x]) + 1/(2*b*x^(5/2)*(b + a*x)^2) + 9/(4*b^2*x^(5/2)*(b + a*x)) - (63*a^(5/2)*ArcTan[(Sqrt[a]*Sqrt[x])/Sqrt[b]])/(4*b^(11/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*Sqrt[a + b/x], x, 7, (5*b^3*Sqrt[a + b/x]*x)/(64*a^3) - (5*b^2*Sqrt[a + b/x]*x^2)/(96*a^2) + (b*Sqrt[a + b/x]*x^3)/(24*a) + (1/4)*Sqrt[a + b/x]*x^4 - (5*b^4*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(64*a^(7/2))}
{x^2*Sqrt[a + b/x], x, 6, -((b^2*Sqrt[a + b/x]*x)/(8*a^2)) + (b*Sqrt[a + b/x]*x^2)/(12*a) + (1/3)*Sqrt[a + b/x]*x^3 + (b^3*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(8*a^(5/2))}
{x^1*Sqrt[a + b/x], x, 5, (b*Sqrt[a + b/x]*x)/(4*a) + (1/2)*Sqrt[a + b/x]*x^2 - (b^2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(4*a^(3/2))}
{x^0*Sqrt[a + b/x], x, 4, Sqrt[a + b/x]*x + (b*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/Sqrt[a]}
{Sqrt[a + b/x]/x^1, x, 4, -2*Sqrt[a + b/x] + 2*Sqrt[a]*ArcTanh[Sqrt[a + b/x]/Sqrt[a]]}
{Sqrt[a + b/x]/x^2, x, 1, -((2*(a + b/x)^(3/2))/(3*b))}
{Sqrt[a + b/x]/x^3, x, 3, (2*a*(a + b/x)^(3/2))/(3*b^2) - (2*(a + b/x)^(5/2))/(5*b^2)}
{Sqrt[a + b/x]/x^4, x, 3, -((2*a^2*(a + b/x)^(3/2))/(3*b^3)) + (4*a*(a + b/x)^(5/2))/(5*b^3) - (2*(a + b/x)^(7/2))/(7*b^3)}
{Sqrt[a + b/x]/x^5, x, 3, (2*a^3*(a + b/x)^(3/2))/(3*b^4) - (6*a^2*(a + b/x)^(5/2))/(5*b^4) + (6*a*(a + b/x)^(7/2))/(7*b^4) - (2*(a + b/x)^(9/2))/(9*b^4)}
{Sqrt[a + b/x]/x^6, x, 3, -((2*a^4*(a + b/x)^(3/2))/(3*b^5)) + (8*a^3*(a + b/x)^(5/2))/(5*b^5) - (12*a^2*(a + b/x)^(7/2))/(7*b^5) + (8*a*(a + b/x)^(9/2))/(9*b^5) - (2*(a + b/x)^(11/2))/(11*b^5)}


{x^3*(a + b/x)^(3/2), x, 7, -((3*b^3*Sqrt[a + b/x]*x)/(64*a^2)) + (b^2*Sqrt[a + b/x]*x^2)/(32*a) + (1/8)*b*Sqrt[a + b/x]*x^3 + (1/4)*(a + b/x)^(3/2)*x^4 + (3*b^4*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(64*a^(5/2))}
{x^2*(a + b/x)^(3/2), x, 6, (b^2*Sqrt[a + b/x]*x)/(8*a) + (1/4)*b*Sqrt[a + b/x]*x^2 + (1/3)*(a + b/x)^(3/2)*x^3 - (b^3*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(8*a^(3/2))}
{x^1*(a + b/x)^(3/2), x, 5, (3/4)*b*Sqrt[a + b/x]*x + (1/2)*(a + b/x)^(3/2)*x^2 + (3*b^2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(4*Sqrt[a])}
{x^0*(a + b/x)^(3/2), x, 5, -3*b*Sqrt[a + b/x] + (a + b/x)^(3/2)*x + 3*Sqrt[a]*b*ArcTanh[Sqrt[a + b/x]/Sqrt[a]]}
{(a + b/x)^(3/2)/x^1, x, 5, -2*a*Sqrt[a + b/x] - (2/3)*(a + b/x)^(3/2) + 2*a^(3/2)*ArcTanh[Sqrt[a + b/x]/Sqrt[a]]}
{(a + b/x)^(3/2)/x^2, x, 1, -((2*(a + b/x)^(5/2))/(5*b))}
{(a + b/x)^(3/2)/x^3, x, 3, (2*a*(a + b/x)^(5/2))/(5*b^2) - (2*(a + b/x)^(7/2))/(7*b^2)}
{(a + b/x)^(3/2)/x^4, x, 3, -((2*a^2*(a + b/x)^(5/2))/(5*b^3)) + (4*a*(a + b/x)^(7/2))/(7*b^3) - (2*(a + b/x)^(9/2))/(9*b^3)}
{(a + b/x)^(3/2)/x^5, x, 3, (2*a^3*(a + b/x)^(5/2))/(5*b^4) - (6*a^2*(a + b/x)^(7/2))/(7*b^4) + (2*a*(a + b/x)^(9/2))/(3*b^4) - (2*(a + b/x)^(11/2))/(11*b^4)}
{(a + b/x)^(3/2)/x^6, x, 3, -((2*a^4*(a + b/x)^(5/2))/(5*b^5)) + (8*a^3*(a + b/x)^(7/2))/(7*b^5) - (4*a^2*(a + b/x)^(9/2))/(3*b^5) + (8*a*(a + b/x)^(11/2))/(11*b^5) - (2*(a + b/x)^(13/2))/(13*b^5)}
{(a + b/x)^(3/2)/x^7, x, 3, (2*a^5*(a + b/x)^(5/2))/(5*b^6) - (10*a^4*(a + b/x)^(7/2))/(7*b^6) + (20*a^3*(a + b/x)^(9/2))/(9*b^6) - (20*a^2*(a + b/x)^(11/2))/(11*b^6) + (10*a*(a + b/x)^(13/2))/(13*b^6) - (2*(a + b/x)^(15/2))/(15*b^6)}


{x^3*(a + b/x)^(5/2), x, 7, (5*b^3*Sqrt[a + b/x]*x)/(64*a) + (5/32)*b^2*Sqrt[a + b/x]*x^2 + (5/24)*b*(a + b/x)^(3/2)*x^3 + (1/4)*(a + b/x)^(5/2)*x^4 - (5*b^4*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(64*a^(3/2))}
{x^2*(a + b/x)^(5/2), x, 6, (5/8)*b^2*Sqrt[a + b/x]*x + (5/12)*b*(a + b/x)^(3/2)*x^2 + (1/3)*(a + b/x)^(5/2)*x^3 + (5*b^3*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(8*Sqrt[a])}
{x^1*(a + b/x)^(5/2), x, 6, (-(15/4))*b^2*Sqrt[a + b/x] + (5/4)*b*(a + b/x)^(3/2)*x + (1/2)*(a + b/x)^(5/2)*x^2 + (15/4)*Sqrt[a]*b^2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]]}
{x^0*(a + b/x)^(5/2), x, 6, -5*a*b*Sqrt[a + b/x] - (5/3)*b*(a + b/x)^(3/2) + (a + b/x)^(5/2)*x + 5*a^(3/2)*b*ArcTanh[Sqrt[a + b/x]/Sqrt[a]]}
{(a + b/x)^(5/2)/x^1, x, 6, -2*a^2*Sqrt[a + b/x] - (2/3)*a*(a + b/x)^(3/2) - (2/5)*(a + b/x)^(5/2) + 2*a^(5/2)*ArcTanh[Sqrt[a + b/x]/Sqrt[a]]}
{(a + b/x)^(5/2)/x^2, x, 1, -((2*(a + b/x)^(7/2))/(7*b))}
{(a + b/x)^(5/2)/x^3, x, 3, (2*a*(a + b/x)^(7/2))/(7*b^2) - (2*(a + b/x)^(9/2))/(9*b^2)}
{(a + b/x)^(5/2)/x^4, x, 3, -((2*a^2*(a + b/x)^(7/2))/(7*b^3)) + (4*a*(a + b/x)^(9/2))/(9*b^3) - (2*(a + b/x)^(11/2))/(11*b^3)}
{(a + b/x)^(5/2)/x^5, x, 3, (2*a^3*(a + b/x)^(7/2))/(7*b^4) - (2*a^2*(a + b/x)^(9/2))/(3*b^4) + (6*a*(a + b/x)^(11/2))/(11*b^4) - (2*(a + b/x)^(13/2))/(13*b^4)}
{(a + b/x)^(5/2)/x^6, x, 3, -((2*a^4*(a + b/x)^(7/2))/(7*b^5)) + (8*a^3*(a + b/x)^(9/2))/(9*b^5) - (12*a^2*(a + b/x)^(11/2))/(11*b^5) + (8*a*(a + b/x)^(13/2))/(13*b^5) - (2*(a + b/x)^(15/2))/(15*b^5)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^3/Sqrt[a + b/x], x, 7, -((35*b^3*Sqrt[a + b/x]*x)/(64*a^4)) + (35*b^2*Sqrt[a + b/x]*x^2)/(96*a^3) - (7*b*Sqrt[a + b/x]*x^3)/(24*a^2) + (Sqrt[a + b/x]*x^4)/(4*a) + (35*b^4*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(64*a^(9/2))}
{x^2/Sqrt[a + b/x], x, 6, (5*b^2*Sqrt[a + b/x]*x)/(8*a^3) - (5*b*Sqrt[a + b/x]*x^2)/(12*a^2) + (Sqrt[a + b/x]*x^3)/(3*a) - (5*b^3*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(8*a^(7/2))}
{x^1/Sqrt[a + b/x], x, 5, -((3*b*Sqrt[a + b/x]*x)/(4*a^2)) + (Sqrt[a + b/x]*x^2)/(2*a) + (3*b^2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(4*a^(5/2))}
{x^0/Sqrt[a + b/x], x, 4, (Sqrt[a + b/x]*x)/a - (b*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/a^(3/2)}
{1/(x^1*Sqrt[a + b/x]), x, 3, (2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/Sqrt[a]}
{1/(x^2*Sqrt[a + b/x]), x, 1, -((2*Sqrt[a + b/x])/b)}
{1/(x^3*Sqrt[a + b/x]), x, 3, (2*a*Sqrt[a + b/x])/b^2 - (2*(a + b/x)^(3/2))/(3*b^2)}
{1/(x^4*Sqrt[a + b/x]), x, 3, -((2*a^2*Sqrt[a + b/x])/b^3) + (4*a*(a + b/x)^(3/2))/(3*b^3) - (2*(a + b/x)^(5/2))/(5*b^3)}
{1/(x^5*Sqrt[a + b/x]), x, 3, (2*a^3*Sqrt[a + b/x])/b^4 - (2*a^2*(a + b/x)^(3/2))/b^4 + (6*a*(a + b/x)^(5/2))/(5*b^4) - (2*(a + b/x)^(7/2))/(7*b^4)}
{1/(x^6*Sqrt[a + b/x]), x, 3, -((2*a^4*Sqrt[a + b/x])/b^5) + (8*a^3*(a + b/x)^(3/2))/(3*b^5) - (12*a^2*(a + b/x)^(5/2))/(5*b^5) + (8*a*(a + b/x)^(7/2))/(7*b^5) - (2*(a + b/x)^(9/2))/(9*b^5)}


{x^2/(a + b/x)^(3/2), x, 7, (35*b^3)/(8*a^4*Sqrt[a + b/x]) + (35*b^2*x)/(24*a^3*Sqrt[a + b/x]) - (7*b*x^2)/(12*a^2*Sqrt[a + b/x]) + x^3/(3*a*Sqrt[a + b/x]) - (35*b^3*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(8*a^(9/2))}
{x^1/(a + b/x)^(3/2), x, 6, -((15*b^2)/(4*a^3*Sqrt[a + b/x])) - (5*b*x)/(4*a^2*Sqrt[a + b/x]) + x^2/(2*a*Sqrt[a + b/x]) + (15*b^2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(4*a^(7/2))}
{x^0/(a + b/x)^(3/2), x, 5, (3*b)/(a^2*Sqrt[a + b/x]) + x/(a*Sqrt[a + b/x]) - (3*b*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/a^(5/2)}
{1/(x^1*(a + b/x)^(3/2)), x, 4, -(2/(a*Sqrt[a + b/x])) + (2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/a^(3/2)}
{1/(x^2*(a + b/x)^(3/2)), x, 1, 2/(b*Sqrt[a + b/x])}
{1/(x^3*(a + b/x)^(3/2)), x, 3, -((2*a)/(b^2*Sqrt[a + b/x])) - (2*Sqrt[a + b/x])/b^2}
{1/(x^4*(a + b/x)^(3/2)), x, 3, (2*a^2)/(b^3*Sqrt[a + b/x]) + (4*a*Sqrt[a + b/x])/b^3 - (2*(a + b/x)^(3/2))/(3*b^3)}
{1/(x^5*(a + b/x)^(3/2)), x, 3, -((2*a^3)/(b^4*Sqrt[a + b/x])) - (6*a^2*Sqrt[a + b/x])/b^4 + (2*a*(a + b/x)^(3/2))/b^4 - (2*(a + b/x)^(5/2))/(5*b^4)}
{1/(x^6*(a + b/x)^(3/2)), x, 3, (2*a^4)/(b^5*Sqrt[a + b/x]) + (8*a^3*Sqrt[a + b/x])/b^5 - (4*a^2*(a + b/x)^(3/2))/b^5 + (8*a*(a + b/x)^(5/2))/(5*b^5) - (2*(a + b/x)^(7/2))/(7*b^5)}
{1/(x^7*(a + b/x)^(3/2)), x, 3, -((2*a^5)/(b^6*Sqrt[a + b/x])) - (10*a^4*Sqrt[a + b/x])/b^6 + (20*a^3*(a + b/x)^(3/2))/(3*b^6) - (4*a^2*(a + b/x)^(5/2))/b^6 + (10*a*(a + b/x)^(7/2))/(7*b^6) - (2*(a + b/x)^(9/2))/(9*b^6)}


{x^2/(a + b/x)^(5/2), x, 8, (35*b^3)/(8*a^4*(a + b/x)^(3/2)) + (105*b^3)/(8*a^5*Sqrt[a + b/x]) + (21*b^2*x)/(8*a^3*(a + b/x)^(3/2)) - (3*b*x^2)/(4*a^2*(a + b/x)^(3/2)) + x^3/(3*a*(a + b/x)^(3/2)) - (105*b^3*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(8*a^(11/2))}
{x^1/(a + b/x)^(5/2), x, 7, -((35*b^2)/(12*a^3*(a + b/x)^(3/2))) - (35*b^2)/(4*a^4*Sqrt[a + b/x]) - (7*b*x)/(4*a^2*(a + b/x)^(3/2)) + x^2/(2*a*(a + b/x)^(3/2)) + (35*b^2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/(4*a^(9/2))}
{x^0/(a + b/x)^(5/2), x, 6, (5*b)/(3*a^2*(a + b/x)^(3/2)) + (5*b)/(a^3*Sqrt[a + b/x]) + x/(a*(a + b/x)^(3/2)) - (5*b*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/a^(7/2)}
{1/(x^1*(a + b/x)^(5/2)), x, 5, -(2/(3*a*(a + b/x)^(3/2))) - 2/(a^2*Sqrt[a + b/x]) + (2*ArcTanh[Sqrt[a + b/x]/Sqrt[a]])/a^(5/2)}
{1/(x^2*(a + b/x)^(5/2)), x, 1, 2/(3*b*(a + b/x)^(3/2))}
{1/(x^3*(a + b/x)^(5/2)), x, 3, -((2*a)/(3*b^2*(a + b/x)^(3/2))) + 2/(b^2*Sqrt[a + b/x])}
{1/(x^4*(a + b/x)^(5/2)), x, 3, (2*a^2)/(3*b^3*(a + b/x)^(3/2)) - (4*a)/(b^3*Sqrt[a + b/x]) - (2*Sqrt[a + b/x])/b^3}
{1/(x^5*(a + b/x)^(5/2)), x, 3, -((2*a^3)/(3*b^4*(a + b/x)^(3/2))) + (6*a^2)/(b^4*Sqrt[a + b/x]) + (6*a*Sqrt[a + b/x])/b^4 - (2*(a + b/x)^(3/2))/(3*b^4)}
{1/(x^6*(a + b/x)^(5/2)), x, 3, (2*a^4)/(3*b^5*(a + b/x)^(3/2)) - (8*a^3)/(b^5*Sqrt[a + b/x]) - (12*a^2*Sqrt[a + b/x])/b^5 + (8*a*(a + b/x)^(3/2))/(3*b^5) - (2*(a + b/x)^(5/2))/(5*b^5)}
{1/(x^7*(a + b/x)^(5/2)), x, 3, -((2*a^5)/(3*b^6*(a + b/x)^(3/2))) + (10*a^4)/(b^6*Sqrt[a + b/x]) + (20*a^3*Sqrt[a + b/x])/b^6 - (20*a^2*(a + b/x)^(3/2))/(3*b^6) + (2*a*(a + b/x)^(5/2))/b^6 - (2*(a + b/x)^(7/2))/(7*b^6)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b/x)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b/x)^(1/2)*x^(7/2), x, 4, -((32*b^3*(a + b/x)^(3/2)*x^(3/2))/(315*a^4)) + (16*b^2*(a + b/x)^(3/2)*x^(5/2))/(105*a^3) - (4*b*(a + b/x)^(3/2)*x^(7/2))/(21*a^2) + (2*(a + b/x)^(3/2)*x^(9/2))/(9*a)}
{(a + b/x)^(1/2)*x^(5/2), x, 3, (16*b^2*(a + b/x)^(3/2)*x^(3/2))/(105*a^3) - (8*b*(a + b/x)^(3/2)*x^(5/2))/(35*a^2) + (2*(a + b/x)^(3/2)*x^(7/2))/(7*a)}
{(a + b/x)^(1/2)*x^(3/2), x, 2, -((4*b*(a + b/x)^(3/2)*x^(3/2))/(15*a^2)) + (2*(a + b/x)^(3/2)*x^(5/2))/(5*a)}
{(a + b/x)^(1/2)*x^(1/2), x, 1, (2*(a + b/x)^(3/2)*x^(3/2))/(3*a)}
{(a + b/x)^(1/2)/x^(1/2), x, 4, 2*Sqrt[a + b/x]*Sqrt[x] - 2*Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])]}
{(a + b/x)^(1/2)/x^(3/2), x, 4, -(Sqrt[a + b/x]/Sqrt[x]) - (a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/Sqrt[b]}
{(a + b/x)^(1/2)/x^(5/2), x, 5, -(Sqrt[a + b/x]/(2*x^(3/2))) - (a*Sqrt[a + b/x])/(4*b*Sqrt[x]) + (a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(4*b^(3/2))}
{(a + b/x)^(1/2)/x^(7/2), x, 6, -(Sqrt[a + b/x]/(3*x^(5/2))) - (a*Sqrt[a + b/x])/(12*b*x^(3/2)) + (a^2*Sqrt[a + b/x])/(8*b^2*Sqrt[x]) - (a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(8*b^(5/2))}


{(a + b/x)^(3/2)*x^(9/2), x, 4, -((32*b^3*(a + b/x)^(5/2)*x^(5/2))/(1155*a^4)) + (16*b^2*(a + b/x)^(5/2)*x^(7/2))/(231*a^3) - (4*b*(a + b/x)^(5/2)*x^(9/2))/(33*a^2) + (2*(a + b/x)^(5/2)*x^(11/2))/(11*a)}
{(a + b/x)^(3/2)*x^(7/2), x, 3, (16*b^2*(a + b/x)^(5/2)*x^(5/2))/(315*a^3) - (8*b*(a + b/x)^(5/2)*x^(7/2))/(63*a^2) + (2*(a + b/x)^(5/2)*x^(9/2))/(9*a)}
{(a + b/x)^(3/2)*x^(5/2), x, 2, -((4*b*(a + b/x)^(5/2)*x^(5/2))/(35*a^2)) + (2*(a + b/x)^(5/2)*x^(7/2))/(7*a)}
{(a + b/x)^(3/2)*x^(3/2), x, 1, (2*(a + b/x)^(5/2)*x^(5/2))/(5*a)}
{(a + b/x)^(3/2)*x^(1/2), x, 5, 2*b*Sqrt[a + b/x]*Sqrt[x] + (2/3)*(a + b/x)^(3/2)*x^(3/2) - 2*b^(3/2)*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])]}
{(a + b/x)^(3/2)/x^(1/2), x, 5, -((3*b*Sqrt[a + b/x])/Sqrt[x]) + 2*(a + b/x)^(3/2)*Sqrt[x] - 3*a*Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])]}
{(a + b/x)^(3/2)/x^(3/2), x, 5, -((3*a*Sqrt[a + b/x])/(4*Sqrt[x])) - (a + b/x)^(3/2)/(2*Sqrt[x]) - (3*a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(4*Sqrt[b])}
{(a + b/x)^(3/2)/x^(5/2), x, 6, -((a*Sqrt[a + b/x])/(4*x^(3/2))) - (a + b/x)^(3/2)/(3*x^(3/2)) - (a^2*Sqrt[a + b/x])/(8*b*Sqrt[x]) + (a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(8*b^(3/2))}


{(a + b/x)^(5/2)*x^(11/2), x, 4, -((32*b^3*(a + b/x)^(7/2)*x^(7/2))/(3003*a^4)) + (16*b^2*(a + b/x)^(7/2)*x^(9/2))/(429*a^3) - (12*b*(a + b/x)^(7/2)*x^(11/2))/(143*a^2) + (2*(a + b/x)^(7/2)*x^(13/2))/(13*a)}
{(a + b/x)^(5/2)*x^(9/2), x, 3, (16*b^2*(a + b/x)^(7/2)*x^(7/2))/(693*a^3) - (8*b*(a + b/x)^(7/2)*x^(9/2))/(99*a^2) + (2*(a + b/x)^(7/2)*x^(11/2))/(11*a)}
{(a + b/x)^(5/2)*x^(7/2), x, 2, -((4*b*(a + b/x)^(7/2)*x^(7/2))/(63*a^2)) + (2*(a + b/x)^(7/2)*x^(9/2))/(9*a)}
{(a + b/x)^(5/2)*x^(5/2), x, 1, (2*(a + b/x)^(7/2)*x^(7/2))/(7*a)}
{(a + b/x)^(5/2)*x^(3/2), x, 6, 2*b^2*Sqrt[a + b/x]*Sqrt[x] + (2/3)*b*(a + b/x)^(3/2)*x^(3/2) + (2/5)*(a + b/x)^(5/2)*x^(5/2) - 2*b^(5/2)*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])]}
{(a + b/x)^(5/2)*x^(1/2), x, 6, -((5*b^2*Sqrt[a + b/x])/Sqrt[x]) + (10/3)*b*(a + b/x)^(3/2)*Sqrt[x] + (2/3)*(a + b/x)^(5/2)*x^(3/2) - 5*a*b^(3/2)*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])]}
{(a + b/x)^(5/2)/x^(1/2), x, 6, -((15*a*b*Sqrt[a + b/x])/(4*Sqrt[x])) - (5*b*(a + b/x)^(3/2))/(2*Sqrt[x]) + 2*(a + b/x)^(5/2)*Sqrt[x] - (15/4)*a^2*Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])]}
{(a + b/x)^(5/2)/x^(3/2), x, 6, -((5*a^2*Sqrt[a + b/x])/(8*Sqrt[x])) - (5*a*(a + b/x)^(3/2))/(12*Sqrt[x]) - (a + b/x)^(5/2)/(3*Sqrt[x]) - (5*a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(8*Sqrt[b])}
{(a + b/x)^(5/2)/x^(5/2), x, 7, -((5*a^2*Sqrt[a + b/x])/(32*x^(3/2))) - (5*a*(a + b/x)^(3/2))/(24*x^(3/2)) - (a + b/x)^(5/2)/(4*x^(3/2)) - (5*a^3*Sqrt[a + b/x])/(64*b*Sqrt[x]) + (5*a^4*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(64*b^(3/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(a + b/x)^(1/2)*x^(7/2), x, 5, (256*b^4*Sqrt[a + b/x]*Sqrt[x])/(315*a^5) - (128*b^3*Sqrt[a + b/x]*x^(3/2))/(315*a^4) + (32*b^2*Sqrt[a + b/x]*x^(5/2))/(105*a^3) - (16*b*Sqrt[a + b/x]*x^(7/2))/(63*a^2) + (2*Sqrt[a + b/x]*x^(9/2))/(9*a)}
{1/(a + b/x)^(1/2)*x^(5/2), x, 4, -((32*b^3*Sqrt[a + b/x]*Sqrt[x])/(35*a^4)) + (16*b^2*Sqrt[a + b/x]*x^(3/2))/(35*a^3) - (12*b*Sqrt[a + b/x]*x^(5/2))/(35*a^2) + (2*Sqrt[a + b/x]*x^(7/2))/(7*a)}
{1/(a + b/x)^(1/2)*x^(3/2), x, 3, (16*b^2*Sqrt[a + b/x]*Sqrt[x])/(15*a^3) - (8*b*Sqrt[a + b/x]*x^(3/2))/(15*a^2) + (2*Sqrt[a + b/x]*x^(5/2))/(5*a)}
{1/(a + b/x)^(1/2)*x^(1/2), x, 2, -((4*b*Sqrt[a + b/x]*Sqrt[x])/(3*a^2)) + (2*Sqrt[a + b/x]*x^(3/2))/(3*a)}
{1/(a + b/x)^(1/2)/x^(1/2), x, 1, (2*Sqrt[a + b/x]*Sqrt[x])/a}
{1/(a + b/x)^(1/2)/x^(3/2), x, 3, -((2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/Sqrt[b])}
{1/(a + b/x)^(1/2)/x^(5/2), x, 4, -(Sqrt[a + b/x]/(b*Sqrt[x])) + (a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/b^(3/2)}
{1/(a + b/x)^(1/2)/x^(7/2), x, 5, -(Sqrt[a + b/x]/(2*b*x^(3/2))) + (3*a*Sqrt[a + b/x])/(4*b^2*Sqrt[x]) - (3*a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(4*b^(5/2))}
{1/(a + b/x)^(1/2)/x^(9/2), x, 6, -(Sqrt[a + b/x]/(3*b*x^(5/2))) + (5*a*Sqrt[a + b/x])/(12*b^2*x^(3/2)) - (5*a^2*Sqrt[a + b/x])/(8*b^3*Sqrt[x]) + (5*a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(8*b^(7/2))}


{1/(a + b/x)^(3/2)*x^(5/2), x, 5, -((256*b^4)/(35*a^5*Sqrt[a + b/x]*Sqrt[x])) - (128*b^3*Sqrt[x])/(35*a^4*Sqrt[a + b/x]) + (32*b^2*x^(3/2))/(35*a^3*Sqrt[a + b/x]) - (16*b*x^(5/2))/(35*a^2*Sqrt[a + b/x]) + (2*x^(7/2))/(7*a*Sqrt[a + b/x])}
{1/(a + b/x)^(3/2)*x^(3/2), x, 4, (32*b^3)/(5*a^4*Sqrt[a + b/x]*Sqrt[x]) + (16*b^2*Sqrt[x])/(5*a^3*Sqrt[a + b/x]) - (4*b*x^(3/2))/(5*a^2*Sqrt[a + b/x]) + (2*x^(5/2))/(5*a*Sqrt[a + b/x])}
{1/(a + b/x)^(3/2)*x^(1/2), x, 3, -((16*b^2)/(3*a^3*Sqrt[a + b/x]*Sqrt[x])) - (8*b*Sqrt[x])/(3*a^2*Sqrt[a + b/x]) + (2*x^(3/2))/(3*a*Sqrt[a + b/x])}
{1/(a + b/x)^(3/2)/x^(1/2), x, 2, (4*b)/(a^2*Sqrt[a + b/x]*Sqrt[x]) + (2*Sqrt[x])/(a*Sqrt[a + b/x])}
{1/(a + b/x)^(3/2)/x^(3/2), x, 1, -(2/(a*Sqrt[a + b/x]*Sqrt[x]))}
{1/(a + b/x)^(3/2)/x^(5/2), x, 4, 2/(b*Sqrt[a + b/x]*Sqrt[x]) - (2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/b^(3/2)}
{1/(a + b/x)^(3/2)/x^(7/2), x, 5, 2/(b*Sqrt[a + b/x]*x^(3/2)) - (3*Sqrt[a + b/x])/(b^2*Sqrt[x]) + (3*a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/b^(5/2)}
{1/(a + b/x)^(3/2)/x^(9/2), x, 6, 2/(b*Sqrt[a + b/x]*x^(5/2)) - (5*Sqrt[a + b/x])/(2*b^2*x^(3/2)) + (15*a*Sqrt[a + b/x])/(4*b^3*Sqrt[x]) - (15*a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(4*b^(7/2))}
{1/(a + b/x)^(3/2)/x^(11/2), x, 7, 2/(b*Sqrt[a + b/x]*x^(7/2)) - (7*Sqrt[a + b/x])/(3*b^2*x^(5/2)) + (35*a*Sqrt[a + b/x])/(12*b^3*x^(3/2)) - (35*a^2*Sqrt[a + b/x])/(8*b^4*Sqrt[x]) + (35*a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(8*b^(9/2))}


{1/(a + b/x)^(5/2)*x^(5/2), x, 6, -((512*b^5)/(21*a^6*(a + b/x)^(3/2)*x^(3/2))) - (256*b^4)/(7*a^5*(a + b/x)^(3/2)*Sqrt[x]) - (64*b^3*Sqrt[x])/(7*a^4*(a + b/x)^(3/2)) + (32*b^2*x^(3/2))/(21*a^3*(a + b/x)^(3/2)) - (4*b*x^(5/2))/(7*a^2*(a + b/x)^(3/2)) + (2*x^(7/2))/(7*a*(a + b/x)^(3/2))}
{1/(a + b/x)^(5/2)*x^(3/2), x, 5, (256*b^4)/(15*a^5*(a + b/x)^(3/2)*x^(3/2)) + (128*b^3)/(5*a^4*(a + b/x)^(3/2)*Sqrt[x]) + (32*b^2*Sqrt[x])/(5*a^3*(a + b/x)^(3/2)) - (16*b*x^(3/2))/(15*a^2*(a + b/x)^(3/2)) + (2*x^(5/2))/(5*a*(a + b/x)^(3/2))}
{1/(a + b/x)^(5/2)*x^(1/2), x, 4, -((32*b^3)/(3*a^4*(a + b/x)^(3/2)*x^(3/2))) - (16*b^2)/(a^3*(a + b/x)^(3/2)*Sqrt[x]) - (4*b*Sqrt[x])/(a^2*(a + b/x)^(3/2)) + (2*x^(3/2))/(3*a*(a + b/x)^(3/2))}
{1/(a + b/x)^(5/2)/x^(1/2), x, 3, (16*b^2)/(3*a^3*(a + b/x)^(3/2)*x^(3/2)) + (8*b)/(a^2*(a + b/x)^(3/2)*Sqrt[x]) + (2*Sqrt[x])/(a*(a + b/x)^(3/2))}
{1/(a + b/x)^(5/2)/x^(3/2), x, 2, -((4*b)/(3*a^2*(a + b/x)^(3/2)*x^(3/2))) - 2/(a*(a + b/x)^(3/2)*Sqrt[x])}
{1/(a + b/x)^(5/2)/x^(5/2), x, 1, -(2/(3*a*(a + b/x)^(3/2)*x^(3/2)))}
{1/(a + b/x)^(5/2)/x^(7/2), x, 5, 2/(3*b*(a + b/x)^(3/2)*x^(3/2)) + 2/(b^2*Sqrt[a + b/x]*Sqrt[x]) - (2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/b^(5/2)}
{1/(a + b/x)^(5/2)/x^(9/2), x, 6, 2/(3*b*(a + b/x)^(3/2)*x^(5/2)) + 10/(3*b^2*Sqrt[a + b/x]*x^(3/2)) - (5*Sqrt[a + b/x])/(b^3*Sqrt[x]) + (5*a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/b^(7/2)}
{1/(a + b/x)^(5/2)/x^(11/2), x, 7, 2/(3*b*(a + b/x)^(3/2)*x^(7/2)) + 14/(3*b^2*Sqrt[a + b/x]*x^(5/2)) - (35*Sqrt[a + b/x])/(6*b^3*x^(3/2)) + (35*a*Sqrt[a + b/x])/(4*b^4*Sqrt[x]) - (35*a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x]*Sqrt[x])])/(4*b^(9/2))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^2)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b/x^2)*x^6, x, 2, (b*x^5)/5 + (a*x^7)/7}
{(a + b/x^2)*x^5, x, 2, (b*x^4)/4 + (a*x^6)/6}
{(a + b/x^2)*x^4, x, 2, (b*x^3)/3 + (a*x^5)/5}
{(a + b/x^2)*x^3, x, 2, (b*x^2)/2 + (a*x^4)/4}
{(a + b/x^2)*x^2, x, 2, b*x + (a*x^3)/3}
{(a + b/x^2)*x, x, 2, (a*x^2)/2 + b*Log[x]}
{a + b/x^2, x, 1, -(b/x) + a*x}
{(a + b/x^2)/x, x, 2, -b/(2*x^2) + a*Log[x]}
{(a + b/x^2)/x^2, x, 2, -b/(3*x^3) - a/x}
{(a + b/x^2)/x^3, x, 2, -b/(4*x^4) - a/(2*x^2)}
{(a + b/x^2)/x^4, x, 2, -b/(5*x^5) - a/(3*x^3)}
{(a + b/x^2)/x^5, x, 2, -b/(6*x^6) - a/(4*x^4)}
{(a + b/x^2)/x^6, x, 2, -b/(7*x^7) - a/(5*x^5)}


{(a + b/x^2)^2*x^6, x, 3, (b^2*x^3)/3 + (2*a*b*x^5)/5 + (a^2*x^7)/7}
{(a + b/x^2)^2*x^5, x, 2, (b + a*x^2)^3/(6*a)}
{(a + b/x^2)^2*x^4, x, 3, b^2*x + (2*a*b*x^3)/3 + (a^2*x^5)/5}
{(a + b/x^2)^2*x^3, x, 4, a*b*x^2 + (a^2*x^4)/4 + b^2*Log[x]}
{(a + b/x^2)^2*x^2, x, 3, -(b^2/x) + 2*a*b*x + (a^2*x^3)/3}
{(a + b/x^2)^2*x^1, x, 4, -b^2/(2*x^2) + (a^2*x^2)/2 + 2*a*b*Log[x]}
{(a + b/x^2)^2*x^0, x, 3, -b^2/(3*x^3) - (2*a*b)/x + a^2*x}
{(a + b/x^2)^2/x^1, x, 4, -b^2/(4*x^4) - (a*b)/x^2 + a^2*Log[x]}
{(a + b/x^2)^2/x^2, x, 3, -b^2/(5*x^5) - (2*a*b)/(3*x^3) - a^2/x}
{(a + b/x^2)^2/x^3, x, 1, -(a + b/x^2)^3/(6*b)}
{(a + b/x^2)^2/x^4, x, 3, -b^2/(7*x^7) - (2*a*b)/(5*x^5) - a^2/(3*x^3)}
{(a + b/x^2)^2/x^5, x, 4, -b^2/(8*x^8) - (a*b)/(3*x^6) - a^2/(4*x^4)}
{(a + b/x^2)^2/x^6, x, 3, -b^2/(9*x^9) - (2*a*b)/(7*x^7) - a^2/(5*x^5)}


{(a + b/x^2)^3*x^6, x, 3, b^3*x + a*b^2*x^3 + (3*a^2*b*x^5)/5 + (a^3*x^7)/7}
{(a + b/x^2)^3*x^5, x, 4, (3*a*b^2*x^2)/2 + (3*a^2*b*x^4)/4 + (a^3*x^6)/6 + b^3*Log[x]}
{(a + b/x^2)^3*x^4, x, 3, -(b^3/x) + 3*a*b^2*x + a^2*b*x^3 + (a^3*x^5)/5}
{(a + b/x^2)^3*x^3, x, 4, -b^3/(2*x^2) + (3*a^2*b*x^2)/2 + (a^3*x^4)/4 + 3*a*b^2*Log[x]}
{(a + b/x^2)^3*x^2, x, 3, -b^3/(3*x^3) - (3*a*b^2)/x + 3*a^2*b*x + (a^3*x^3)/3}
{(a + b/x^2)^3*x, x, 4, -b^3/(4*x^4) - (3*a*b^2)/(2*x^2) + (a^3*x^2)/2 + 3*a^2*b*Log[x]}
{(a + b/x^2)^3, x, 3, -b^3/(5*x^5) - (a*b^2)/x^3 - (3*a^2*b)/x + a^3*x}
{(a + b/x^2)^3/x, x, 4, -b^3/(6*x^6) - (3*a*b^2)/(4*x^4) - (3*a^2*b)/(2*x^2) + a^3*Log[x]}
{(a + b/x^2)^3/x^2, x, 3, -b^3/(7*x^7) - (3*a*b^2)/(5*x^5) - (a^2*b)/x^3 - a^3/x}
{(a + b/x^2)^3/x^3, x, 1, -(a + b/x^2)^4/(8*b)}
{(a + b/x^2)^3/x^4, x, 3, -b^3/(9*x^9) - (3*a*b^2)/(7*x^7) - (3*a^2*b)/(5*x^5) - a^3/(3*x^3)}
{(a + b/x^2)^3/x^5, x, 4, -((b + a*x^2)^4/(10*b*x^10)) + (a*(b + a*x^2)^4)/(40*b^2*x^8)}
{(a + b/x^2)^3/x^6, x, 3, -b^3/(11*x^11) - (a*b^2)/(3*x^9) - (3*a^2*b)/(7*x^7) - a^3/(5*x^5)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^6/(a + b/x^2), x, 4, -((b^3*x)/a^4) + (b^2*x^3)/(3*a^3) - (b*x^5)/(5*a^2) + x^7/(7*a) + (b^(7/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/a^(9/2)}
{x^5/(a + b/x^2), x, 4, (b^2*x^2)/(2*a^3) - (b*x^4)/(4*a^2) + x^6/(6*a) - (b^3*Log[b + a*x^2])/(2*a^4)}
{x^4/(a + b/x^2), x, 4, (b^2*x)/a^3 - (b*x^3)/(3*a^2) + x^5/(5*a) - (b^(5/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/a^(7/2)}
{x^3/(a + b/x^2), x, 4, -(b*x^2)/(2*a^2) + x^4/(4*a) + (b^2*Log[b + a*x^2])/(2*a^3)}
{x^2/(a + b/x^2), x, 4, -((b*x)/a^2) + x^3/(3*a) + (b^(3/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/a^(5/2)}
{x/(a + b/x^2), x, 4, x^2/(2*a) - (b*Log[b + a*x^2])/(2*a^2)}
{1/(a + b/x^2), x, 3, x/a - (Sqrt[b]*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/a^(3/2)}
{1/((a + b/x^2)*x), x, 2, Log[b + a*x^2]/(2*a)}
{1/((a + b/x^2)*x^2), x, 2, ArcTan[(Sqrt[a]*x)/Sqrt[b]]/(Sqrt[a]*Sqrt[b])}
{1/((a + b/x^2)*x^3), x, 1, -Log[a + b/x^2]/(2*b)}
{1/((a + b/x^2)*x^4), x, 3, -(1/(b*x)) - (Sqrt[a]*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/b^(3/2)}
{1/((a + b/x^2)*x^5), x, 4, -(1/(2*b*x^2)) - (a*Log[x])/b^2 + (a*Log[b + a*x^2])/(2*b^2)}
{1/((a + b/x^2)*x^6), x, 4, -(1/(3*b*x^3)) + a/(b^2*x) + (a^(3/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/b^(5/2)}
{1/((a + b/x^2)*x^7), x, 4, -(1/(4*b*x^4)) + a/(2*b^2*x^2) + (a^2*Log[x])/b^3 - (a^2*Log[b + a*x^2])/(2*b^3)}
{1/((a + b/x^2)*x^8), x, 5, -(1/(5*b*x^5)) + a/(3*b^2*x^3) - a^2/(b^3*x) - (a^(5/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/b^(7/2)}


{x^6/(a + b/x^2)^2, x, 5, (-9*b^3*x)/(2*a^5) + (3*b^2*x^3)/(2*a^4) - (9*b*x^5)/(10*a^3) + (9*x^7)/(14*a^2) - x^9/(2*a*(b + a*x^2)) + (9*b^(7/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(2*a^(11/2))}
{x^5/(a + b/x^2)^2, x, 4, (3*b^2*x^2)/(2*a^4) - (b*x^4)/(2*a^3) + x^6/(6*a^2) - b^4/(2*a^5*(b + a*x^2)) - (2*b^3*Log[b + a*x^2])/a^5}
{x^4/(a + b/x^2)^2, x, 5, (7*b^2*x)/(2*a^4) - (7*b*x^3)/(6*a^3) + (7*x^5)/(10*a^2) - x^7/(2*a*(b + a*x^2)) - (7*b^(5/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(2*a^(9/2))}
{x^3/(a + b/x^2)^2, x, 4, -((b*x^2)/a^3) + x^4/(4*a^2) + b^3/(2*a^4*(b + a*x^2)) + (3*b^2*Log[b + a*x^2])/(2*a^4)}
{x^2/(a + b/x^2)^2, x, 5, (-5*b*x)/(2*a^3) + (5*x^3)/(6*a^2) - x^5/(2*a*(b + a*x^2)) + (5*b^(3/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(2*a^(7/2))}
{x/(a + b/x^2)^2, x, 4, x^2/(2*a^2) - b^2/(2*a^3*(b + a*x^2)) - (b*Log[b + a*x^2])/a^3}
{(a + b/x^2)^(-2), x, 4, (3*x)/(2*a^2) - x^3/(2*a*(b + a*x^2)) - (3*Sqrt[b]*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(2*a^(5/2))}
{1/((a + b/x^2)^2*x), x, 4, b/(2*a^2*(b + a*x^2)) + Log[b + a*x^2]/(2*a^2)}
{1/((a + b/x^2)^2*x^2), x, 3, -(x/(2*a*(b + a*x^2))) + ArcTan[(Sqrt[a]*x)/Sqrt[b]]/(2*a^(3/2)*Sqrt[b])}
{1/((a + b/x^2)^2*x^3), x, 1, 1/(2*b*(a + b/x^2))}
{1/((a + b/x^2)^2*x^4), x, 3, x/(2*b*(b + a*x^2)) + ArcTan[(Sqrt[a]*x)/Sqrt[b]]/(2*Sqrt[a]*b^(3/2))}
{1/((a + b/x^2)^2*x^5), x, 4, 1/(2*b*(b + a*x^2)) + Log[x]/b^2 - Log[b + a*x^2]/(2*b^2)}
{1/((a + b/x^2)^2*x^6), x, 4, -(3/(2*b^2*x)) + 1/(2*b*x*(b + a*x^2)) - (3*Sqrt[a]*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(2*b^(5/2))}
{1/((a + b/x^2)^2*x^7), x, 4, -(1/(2*b^2*x^2)) - a/(2*b^2*(b + a*x^2)) - (2*a*Log[x])/b^3 + (a*Log[b + a*x^2])/b^3}
{1/((a + b/x^2)^2*x^8), x, 5, -(5/(6*b^2*x^3)) + (5*a)/(2*b^3*x) + 1/(2*b*x^3*(b + a*x^2)) + (5*a^(3/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(2*b^(7/2))}
{1/((a + b/x^2)^2*x^9), x, 4, -(1/(4*b^2*x^4)) + a/(b^3*x^2) + a^2/(2*b^3*(b + a*x^2)) + (3*a^2*Log[x])/b^4 - (3*a^2*Log[b + a*x^2])/(2*b^4)}


{x^5/(a + b/x^2)^3, x, 4, (3*b^2*x^2)/a^5 - (3*b*x^4)/(4*a^4) + x^6/(6*a^3) + b^5/(4*a^6*(b + a*x^2)^2) - (5*b^4)/(2*a^6*(b + a*x^2)) - (5*b^3*Log[b + a*x^2])/a^6}
{x^4/(a + b/x^2)^3, x, 6, (63*b^2*x)/(8*a^5) - (21*b*x^3)/(8*a^4) + (63*x^5)/(40*a^3) - x^9/(4*a*(b + a*x^2)^2) - (9*x^7)/(8*a^2*(b + a*x^2)) - (63*b^(5/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*a^(11/2))}
{x^3/(a + b/x^2)^3, x, 4, (-3*b*x^2)/(2*a^4) + x^4/(4*a^3) - b^4/(4*a^5*(b + a*x^2)^2) + (2*b^3)/(a^5*(b + a*x^2)) + (3*b^2*Log[b + a*x^2])/a^5}
{x^2/(a + b/x^2)^3, x, 6, (-35*b*x)/(8*a^4) + (35*x^3)/(24*a^3) - x^7/(4*a*(b + a*x^2)^2) - (7*x^5)/(8*a^2*(b + a*x^2)) + (35*b^(3/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*a^(9/2))}
{x/(a + b/x^2)^3, x, 4, x^2/(2*a^3) + b^3/(4*a^4*(b + a*x^2)^2) - (3*b^2)/(2*a^4*(b + a*x^2)) - (3*b*Log[b + a*x^2])/(2*a^4)}
{(a + b/x^2)^(-3), x, 5, (15*x)/(8*a^3) - x^5/(4*a*(b + a*x^2)^2) - (5*x^3)/(8*a^2*(b + a*x^2)) - (15*Sqrt[b]*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*a^(7/2))}
{1/((a + b/x^2)^3*x), x, 4, -(b^2/(4*a^3*(b + a*x^2)^2)) + b/(a^3*(b + a*x^2)) + Log[b + a*x^2]/(2*a^3)}
{1/((a + b/x^2)^3*x^2), x, 4, -(x^3/(4*a*(b + a*x^2)^2)) - (3*x)/(8*a^2*(b + a*x^2)) + (3*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*a^(5/2)*Sqrt[b])}
{1/((a + b/x^2)^3*x^3), x, 1, 1/(4*b*(a + b/x^2)^2)}
{1/((a + b/x^2)^3*x^4), x, 4, -(x/(4*a*(b + a*x^2)^2)) + x/(8*a*b*(b + a*x^2)) + ArcTan[(Sqrt[a]*x)/Sqrt[b]]/(8*a^(3/2)*b^(3/2))}
{1/((a + b/x^2)^3*x^5), x, 2, -(1/(4*a*(b + a*x^2)^2))}
{1/((a + b/x^2)^3*x^6), x, 4, x/(4*b*(b + a*x^2)^2) + (3*x)/(8*b^2*(b + a*x^2)) + (3*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*Sqrt[a]*b^(5/2))}
{1/((a + b/x^2)^3*x^7), x, 4, 1/(4*b*(b + a*x^2)^2) + 1/(2*b^2*(b + a*x^2)) + Log[x]/b^3 - Log[b + a*x^2]/(2*b^3)}
{1/((a + b/x^2)^3*x^8), x, 5, -(15/(8*b^3*x)) + 1/(4*b*x*(b + a*x^2)^2) + 5/(8*b^2*x*(b + a*x^2)) - (15*Sqrt[a]*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*b^(7/2))}
{1/((a + b/x^2)^3*x^9), x, 4, -(1/(2*b^3*x^2)) - a/(4*b^2*(b + a*x^2)^2) - a/(b^3*(b + a*x^2)) - (3*a*Log[x])/b^4 + (3*a*Log[b + a*x^2])/(2*b^4)}
{1/((a + b/x^2)^3*x^10), x, 6, -(35/(24*b^3*x^3)) + (35*a)/(8*b^4*x) + 1/(4*b*x^3*(b + a*x^2)^2) + 7/(8*b^2*x^3*(b + a*x^2)) + (35*a^(3/2)*ArcTan[(Sqrt[a]*x)/Sqrt[b]])/(8*b^(9/2))}
{1/((a + b/x^2)^3*x^11), x, 4, -(1/(4*b^3*x^4)) + (3*a)/(2*b^4*x^2) + a^2/(4*b^3*(b + a*x^2)^2) + (3*a^2)/(2*b^4*(b + a*x^2)) + (6*a^2*Log[x])/b^5 - (3*a^2*Log[b + a*x^2])/b^5}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^2)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*(a + b/x^2)^(1/2), x, 5, (b*Sqrt[a + b/x^2]*x^2)/(8*a) + (1/4)*Sqrt[a + b/x^2]*x^4 - (b^2*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(8*a^(3/2))}
{x^2*(a + b/x^2)^(1/2), x, 1, ((a + b/x^2)^(3/2)*x^3)/(3*a)}
{x^1*(a + b/x^2)^(1/2), x, 4, (1/2)*Sqrt[a + b/x^2]*x^2 + (b*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(2*Sqrt[a])}
{x^0*(a + b/x^2)^(1/2), x, 4, Sqrt[a + b/x^2]*x - Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]}
{(a + b/x^2)^(1/2)/x^1, x, 4, -Sqrt[a + b/x^2] + Sqrt[a]*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]}
{(a + b/x^2)^(1/2)/x^2, x, 4, -(Sqrt[a + b/x^2]/(2*x)) - (a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(2*Sqrt[b])}
{(a + b/x^2)^(1/2)/x^3, x, 1, -((a + b/x^2)^(3/2)/(3*b))}
{(a + b/x^2)^(1/2)/x^4, x, 5, -(Sqrt[a + b/x^2]/(4*x^3)) - (a*Sqrt[a + b/x^2])/(8*b*x) + (a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(8*b^(3/2))}


{x^3*(a + b/x^2)^(3/2), x, 5, (3/8)*b*Sqrt[a + b/x^2]*x^2 + (1/4)*(a + b/x^2)^(3/2)*x^4 + (3*b^2*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(8*Sqrt[a])}
{x^2*(a + b/x^2)^(3/2), x, 5, b*Sqrt[a + b/x^2]*x + (1/3)*(a + b/x^2)^(3/2)*x^3 - b^(3/2)*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]}
{x^1*(a + b/x^2)^(3/2), x, 5, (-(3/2))*b*Sqrt[a + b/x^2] + (1/2)*(a + b/x^2)^(3/2)*x^2 + (3/2)*Sqrt[a]*b*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]}
{x^0*(a + b/x^2)^(3/2), x, 5, -((3*b*Sqrt[a + b/x^2])/(2*x)) + (a + b/x^2)^(3/2)*x - (3/2)*a*Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]}
{(a + b/x^2)^(3/2)/x^1, x, 5, (-a)*Sqrt[a + b/x^2] - (1/3)*(a + b/x^2)^(3/2) + a^(3/2)*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]}
{(a + b/x^2)^(3/2)/x^2, x, 5, -((3*a*Sqrt[a + b/x^2])/(8*x)) - (a + b/x^2)^(3/2)/(4*x) - (3*a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(8*Sqrt[b])}
{(a + b/x^2)^(3/2)/x^3, x, 1, -((a + b/x^2)^(5/2)/(5*b))}
{(a + b/x^2)^(3/2)/x^4, x, 6, -((a*Sqrt[a + b/x^2])/(8*x^3)) - (a + b/x^2)^(3/2)/(6*x^3) - (a^2*Sqrt[a + b/x^2])/(16*b*x) + (a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(16*b^(3/2))}


{x^3*(a + b/x^2)^(5/2), x, 6, (-(15/8))*b^2*Sqrt[a + b/x^2] + (5/8)*b*(a + b/x^2)^(3/2)*x^2 + (1/4)*(a + b/x^2)^(5/2)*x^4 + (15/8)*Sqrt[a]*b^2*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]}
{x^2*(a + b/x^2)^(5/2), x, 6, -((5*b^2*Sqrt[a + b/x^2])/(2*x)) + (5/3)*b*(a + b/x^2)^(3/2)*x + (1/3)*(a + b/x^2)^(5/2)*x^3 - (5/2)*a*b^(3/2)*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]}
{x^1*(a + b/x^2)^(5/2), x, 6, (-(5/2))*a*b*Sqrt[a + b/x^2] - (5/6)*b*(a + b/x^2)^(3/2) + (1/2)*(a + b/x^2)^(5/2)*x^2 + (5/2)*a^(3/2)*b*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]}
{x^0*(a + b/x^2)^(5/2), x, 6, -((15*a*b*Sqrt[a + b/x^2])/(8*x)) - (5*b*(a + b/x^2)^(3/2))/(4*x) + (a + b/x^2)^(5/2)*x - (15/8)*a^2*Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]}
{(a + b/x^2)^(5/2)/x^1, x, 6, (-a^2)*Sqrt[a + b/x^2] - (1/3)*a*(a + b/x^2)^(3/2) - (1/5)*(a + b/x^2)^(5/2) + a^(5/2)*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]}
{(a + b/x^2)^(5/2)/x^2, x, 6, -((5*a^2*Sqrt[a + b/x^2])/(16*x)) - (5*a*(a + b/x^2)^(3/2))/(24*x) - (a + b/x^2)^(5/2)/(6*x) - (5*a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(16*Sqrt[b])}
{(a + b/x^2)^(5/2)/x^3, x, 1, -((a + b/x^2)^(7/2)/(7*b))}
{(a + b/x^2)^(5/2)/x^4, x, 7, -((5*a^2*Sqrt[a + b/x^2])/(64*x^3)) - (5*a*(a + b/x^2)^(3/2))/(48*x^3) - (a + b/x^2)^(5/2)/(8*x^3) - (5*a^3*Sqrt[a + b/x^2])/(128*b*x) + (5*a^4*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(128*b^(3/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^3/(a + b/x^2)^(1/2), x, 5, -((3*b*Sqrt[a + b/x^2]*x^2)/(8*a^2)) + (Sqrt[a + b/x^2]*x^4)/(4*a) + (3*b^2*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(8*a^(5/2))}
{x^1/(a + b/x^2)^(1/2), x, 4, (Sqrt[a + b/x^2]*x^2)/(2*a) - (b*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(2*a^(3/2))}
{1/(x^1*(a + b/x^2)^(1/2)), x, 3, ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]/Sqrt[a]}
{1/(x^3*(a + b/x^2)^(1/2)), x, 1, -(Sqrt[a + b/x^2]/b)}
{1/(x^5*(a + b/x^2)^(1/2)), x, 3, (a*Sqrt[a + b/x^2])/b^2 - (a + b/x^2)^(3/2)/(3*b^2)}
{1/(x^7*(a + b/x^2)^(1/2)), x, 3, -((a^2*Sqrt[a + b/x^2])/b^3) + (2*a*(a + b/x^2)^(3/2))/(3*b^3) - (a + b/x^2)^(5/2)/(5*b^3)}
{1/(x^9*(a + b/x^2)^(1/2)), x, 3, (a^3*Sqrt[a + b/x^2])/b^4 - (a^2*(a + b/x^2)^(3/2))/b^4 + (3*a*(a + b/x^2)^(5/2))/(5*b^4) - (a + b/x^2)^(7/2)/(7*b^4)}

{x^4/(a + b/x^2)^(1/2), x, 3, (8*b^2*Sqrt[a + b/x^2]*x)/(15*a^3) - (4*b*Sqrt[a + b/x^2]*x^3)/(15*a^2) + (Sqrt[a + b/x^2]*x^5)/(5*a)}
{x^2/(a + b/x^2)^(1/2), x, 2, -((2*b*Sqrt[a + b/x^2]*x)/(3*a^2)) + (Sqrt[a + b/x^2]*x^3)/(3*a)}
{x^0/(a + b/x^2)^(1/2), x, 1, (Sqrt[a + b/x^2]*x)/a}
{1/(x^2*(a + b/x^2)^(1/2)), x, 3, -(ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]/Sqrt[b])}
{1/(x^4*(a + b/x^2)^(1/2)), x, 4, -(Sqrt[a + b/x^2]/(2*b*x)) + (a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(2*b^(3/2))}

{1/(x^1*Sqrt[-a + b/x^2]), x, 3, -(ArcTan[Sqrt[-a + b/x^2]/Sqrt[a]]/Sqrt[a])}
{1/(x^2*Sqrt[2 + b/x^2]), x, 2, -(ArcCsch[(Sqrt[2]*x)/Sqrt[b]]/Sqrt[b])}
{1/(x^2*Sqrt[2 - b/x^2]), x, 2, -(ArcCsc[(Sqrt[2]*x)/Sqrt[b]]/Sqrt[b])}


{x^3/(a + b/x^2)^(3/2), x, 6, -((15*b^2)/(8*a^3*Sqrt[a + b/x^2])) - (5*b*x^2)/(8*a^2*Sqrt[a + b/x^2]) + x^4/(4*a*Sqrt[a + b/x^2]) + (15*b^2*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(8*a^(7/2))}
{x^1/(a + b/x^2)^(3/2), x, 5, (3*b)/(2*a^2*Sqrt[a + b/x^2]) + x^2/(2*a*Sqrt[a + b/x^2]) - (3*b*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(2*a^(5/2))}
{1/(x^1*(a + b/x^2)^(3/2)), x, 4, -(1/(a*Sqrt[a + b/x^2])) + ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]/a^(3/2)}
{1/(x^3*(a + b/x^2)^(3/2)), x, 1, 1/(b*Sqrt[a + b/x^2])}
{1/(x^5*(a + b/x^2)^(3/2)), x, 3, -(a/(b^2*Sqrt[a + b/x^2])) - Sqrt[a + b/x^2]/b^2}
{1/(x^7*(a + b/x^2)^(3/2)), x, 3, a^2/(b^3*Sqrt[a + b/x^2]) + (2*a*Sqrt[a + b/x^2])/b^3 - (a + b/x^2)^(3/2)/(3*b^3)}
{1/(x^9*(a + b/x^2)^(3/2)), x, 3, -(a^3/(b^4*Sqrt[a + b/x^2])) - (3*a^2*Sqrt[a + b/x^2])/b^4 + (a*(a + b/x^2)^(3/2))/b^4 - (a + b/x^2)^(5/2)/(5*b^4)}

{x^4/(a + b/x^2)^(3/2), x, 4, -((8*b^2*x)/(5*a^3*Sqrt[a + b/x^2])) + (16*b^2*Sqrt[a + b/x^2]*x)/(5*a^4) - (2*b*x^3)/(5*a^2*Sqrt[a + b/x^2]) + x^5/(5*a*Sqrt[a + b/x^2])}
{x^2/(a + b/x^2)^(3/2), x, 3, (4*b*x)/(3*a^2*Sqrt[a + b/x^2]) - (8*b*Sqrt[a + b/x^2]*x)/(3*a^3) + x^3/(3*a*Sqrt[a + b/x^2])}
{x^0/(a + b/x^2)^(3/2), x, 2, -(x/(a*Sqrt[a + b/x^2])) + (2*Sqrt[a + b/x^2]*x)/a^2}
{1/(x^2*(a + b/x^2)^(3/2)), x, 1, -(1/(a*Sqrt[a + b/x^2]*x))}
{1/(x^4*(a + b/x^2)^(3/2)), x, 4, 1/(b*Sqrt[a + b/x^2]*x) - ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]/b^(3/2)}
{1/(x^6*(a + b/x^2)^(3/2)), x, 5, 1/(b*Sqrt[a + b/x^2]*x^3) - (3*Sqrt[a + b/x^2])/(2*b^2*x) + (3*a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(2*b^(5/2))}
{1/(x^8*(a + b/x^2)^(3/2)), x, 6, 1/(b*Sqrt[a + b/x^2]*x^5) - (5*Sqrt[a + b/x^2])/(4*b^2*x^3) + (15*a*Sqrt[a + b/x^2])/(8*b^3*x) - (15*a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(8*b^(7/2))}


{x^3/(a + b/x^2)^(5/2), x, 7, -((35*b^2)/(24*a^3*(a + b/x^2)^(3/2))) - (35*b^2)/(8*a^4*Sqrt[a + b/x^2]) - (7*b*x^2)/(8*a^2*(a + b/x^2)^(3/2)) + x^4/(4*a*(a + b/x^2)^(3/2)) + (35*b^2*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(8*a^(9/2))}
{x^1/(a + b/x^2)^(5/2), x, 6, (5*b)/(6*a^2*(a + b/x^2)^(3/2)) + (5*b)/(2*a^3*Sqrt[a + b/x^2]) + x^2/(2*a*(a + b/x^2)^(3/2)) - (5*b*ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]])/(2*a^(7/2))}
{1/(x^1*(a + b/x^2)^(5/2)), x, 5, -(1/(3*a*(a + b/x^2)^(3/2))) - 1/(a^2*Sqrt[a + b/x^2]) + ArcTanh[Sqrt[a + b/x^2]/Sqrt[a]]/a^(5/2)}
{1/(x^3*(a + b/x^2)^(5/2)), x, 1, 1/(3*b*(a + b/x^2)^(3/2))}
{1/(x^5*(a + b/x^2)^(5/2)), x, 3, -(a/(3*b^2*(a + b/x^2)^(3/2))) + 1/(b^2*Sqrt[a + b/x^2])}
{1/(x^7*(a + b/x^2)^(5/2)), x, 3, a^2/(3*b^3*(a + b/x^2)^(3/2)) - (2*a)/(b^3*Sqrt[a + b/x^2]) - Sqrt[a + b/x^2]/b^3}
{1/(x^9*(a + b/x^2)^(5/2)), x, 3, -(a^3/(3*b^4*(a + b/x^2)^(3/2))) + (3*a^2)/(b^4*Sqrt[a + b/x^2]) + (3*a*Sqrt[a + b/x^2])/b^4 - (a + b/x^2)^(3/2)/(3*b^4)}

{x^2/(a + b/x^2)^(5/2), x, 4, (2*b*x)/(3*a^2*(a + b/x^2)^(3/2)) + (8*b*x)/(3*a^3*Sqrt[a + b/x^2]) - (16*b*Sqrt[a + b/x^2]*x)/(3*a^4) + x^3/(3*a*(a + b/x^2)^(3/2))}
{x^0/(a + b/x^2)^(5/2), x, 3, -(x/(3*a*(a + b/x^2)^(3/2))) - (4*x)/(3*a^2*Sqrt[a + b/x^2]) + (8*Sqrt[a + b/x^2]*x)/(3*a^3)}
{1/(x^2*(a + b/x^2)^(5/2)), x, 2, -((2*b)/(3*a^2*(a + b/x^2)^(3/2)*x^3)) - 1/(a*(a + b/x^2)^(3/2)*x)}
{1/(x^4*(a + b/x^2)^(5/2)), x, 1, -(1/(3*a*(a + b/x^2)^(3/2)*x^3))}
{1/(x^6*(a + b/x^2)^(5/2)), x, 5, 1/(3*b*(a + b/x^2)^(3/2)*x^3) + 1/(b^2*Sqrt[a + b/x^2]*x) - ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)]/b^(5/2)}
{1/(x^8*(a + b/x^2)^(5/2)), x, 6, 1/(3*b*(a + b/x^2)^(3/2)*x^5) + 5/(3*b^2*Sqrt[a + b/x^2]*x^3) - (5*Sqrt[a + b/x^2])/(2*b^3*x) + (5*a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^2]*x)])/(2*b^(7/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^2)^(p/3)*)


{(1 + 1/x^2)^(1/3)/x^3, x, 1, (-3*(1 + x^(-2))^(4/3))/8}
{(1 + 1/x^2)^(5/3)/x^3, x, 1, (-3*(1 + x^(-2))^(8/3))/16}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^2)^p with m symbolic*)


{(c*x)^m*(1 + b/x^2)^(3/2), x, 2, ((c*x)^(1 + m)*Hypergeometric2F1[-(3/2), (1/2)*(-1 - m), (1 - m)/2, -(b/x^2)])/(c*(1 + m))}
{(c*x)^m*(1 + b/x^2)^(1/2), x, 2, ((c*x)^(1 + m)*Hypergeometric2F1[-(1/2), (1/2)*(-1 - m), (1 - m)/2, -(b/x^2)])/(c*(1 + m))}
{(c*x)^m/(1 + b/x^2)^(1/2), x, 2, ((c*x)^(1 + m)*Hypergeometric2F1[1/2, (1/2)*(-1 - m), (1 - m)/2, -(b/x^2)])/(c*(1 + m))}
{(c*x)^m/(1 + b/x^2)^(3/2), x, 2, ((c*x)^(1 + m)*Hypergeometric2F1[3/2, (1/2)*(-1 - m), (1 - m)/2, -(b/x^2)])/(c*(1 + m))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^2)^p with p symbolic*)


{(c*x)^m*(1 + b/x^2)^p, x, 2, ((c*x)^(1 + m)*Hypergeometric2F1[(1/2)*(-1 - m), -p, (1 - m)/2, -(b/x^2)])/(c*(1 + m))}
{(c*x)^m*(a + b/x^2)^p, x, 3, ((a + b/x^2)^p*(c*x)^(1 + m)*Hypergeometric2F1[(1/2)*(-1 - m), -p, (1 - m)/2, -(b/(a*x^2))])/((1 + b/(a*x^2))^p*(c*(1 + m)))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^3)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^3)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^5/(a + b/x^3), x, 4, -((b*x^3)/(3*a^2)) + x^6/(6*a) + (b^2*Log[b + a*x^3])/(3*a^3)}
{x^4/(a + b/x^3), x, 9, -((b*x^2)/(2*a^2)) + x^5/(5*a) - (b^(5/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(Sqrt[3]*a^(8/3)) - (b^(5/3)*Log[b^(1/3) + a^(1/3)*x])/(3*a^(8/3)) + (b^(5/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(6*a^(8/3))}
{x^3/(a + b/x^3), x, 9, -((b*x)/a^2) + x^4/(4*a) - (b^(4/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(Sqrt[3]*a^(7/3)) + (b^(4/3)*Log[b^(1/3) + a^(1/3)*x])/(3*a^(7/3)) - (b^(4/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(6*a^(7/3))}
{x^2/(a + b/x^3), x, 4, x^3/(3*a) - (b*Log[b + a*x^3])/(3*a^2)}
{x^1/(a + b/x^3), x, 8, x^2/(2*a) + (b^(2/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(Sqrt[3]*a^(5/3)) + (b^(2/3)*Log[b^(1/3) + a^(1/3)*x])/(3*a^(5/3)) - (b^(2/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(6*a^(5/3))}
{x^0/(a + b/x^3), x, 8, x/a + (b^(1/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(Sqrt[3]*a^(4/3)) - (b^(1/3)*Log[b^(1/3) + a^(1/3)*x])/(3*a^(4/3)) + (b^(1/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(6*a^(4/3))}
{1/(x^1*(a + b/x^3)), x, 2, Log[b + a*x^3]/(3*a)}
{1/(x^2*(a + b/x^3)), x, 7, -(ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))]/(Sqrt[3]*a^(2/3)*b^(1/3))) - Log[b^(1/3) + a^(1/3)*x]/(3*a^(2/3)*b^(1/3)) + Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2]/(6*a^(2/3)*b^(1/3))}
{1/(x^3*(a + b/x^3)), x, 7, -(ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3))) + Log[b^(1/3) + a^(1/3)*x]/(3*a^(1/3)*b^(2/3)) - Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2]/(6*a^(1/3)*b^(2/3))}
{1/(x^4*(a + b/x^3)), x, 1, -(Log[a + b/x^3]/(3*b))}
{1/(x^5*(a + b/x^3)), x, 8, -(1/(b*x)) + (a^(1/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(Sqrt[3]*b^(4/3)) + (a^(1/3)*Log[b^(1/3) + a^(1/3)*x])/(3*b^(4/3)) - (a^(1/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(6*b^(4/3))}
{1/(x^6*(a + b/x^3)), x, 8, -(1/(2*b*x^2)) + (a^(2/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(Sqrt[3]*b^(5/3)) - (a^(2/3)*Log[b^(1/3) + a^(1/3)*x])/(3*b^(5/3)) + (a^(2/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(6*b^(5/3))}
{1/(x^7*(a + b/x^3)), x, 4, -(1/(3*b*x^3)) - (a*Log[x])/b^2 + (a*Log[b + a*x^3])/(3*b^2)}


{x^5/(a + b/x^3)^2, x, 4, -((2*b*x^3)/(3*a^3)) + x^6/(6*a^2) + b^3/(3*a^4*(b + a*x^3)) + (b^2*Log[b + a*x^3])/a^4}
{x^4/(a + b/x^3)^2, x, 10, -((4*b*x^2)/(3*a^3)) + (8*x^5)/(15*a^2) - x^8/(3*a*(b + a*x^3)) - (8*b^(5/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(3*Sqrt[3]*a^(11/3)) - (8*b^(5/3)*Log[b^(1/3) + a^(1/3)*x])/(9*a^(11/3)) + (4*b^(5/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(9*a^(11/3))}
{x^3/(a + b/x^3)^2, x, 10, -((7*b*x)/(3*a^3)) + (7*x^4)/(12*a^2) - x^7/(3*a*(b + a*x^3)) - (7*b^(4/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(3*Sqrt[3]*a^(10/3)) + (7*b^(4/3)*Log[b^(1/3) + a^(1/3)*x])/(9*a^(10/3)) - (7*b^(4/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(18*a^(10/3))}
{x^2/(a + b/x^3)^2, x, 4, x^3/(3*a^2) - b^2/(3*a^3*(b + a*x^3)) - (2*b*Log[b + a*x^3])/(3*a^3)}
{x^1/(a + b/x^3)^2, x, 9, (5*x^2)/(6*a^2) - x^5/(3*a*(b + a*x^3)) + (5*b^(2/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(3*Sqrt[3]*a^(8/3)) + (5*b^(2/3)*Log[b^(1/3) + a^(1/3)*x])/(9*a^(8/3)) - (5*b^(2/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(18*a^(8/3))}
{x^0/(a + b/x^3)^2, x, 9, (4*x)/(3*a^2) - x^4/(3*a*(b + a*x^3)) + (4*b^(1/3)*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(3*Sqrt[3]*a^(7/3)) - (4*b^(1/3)*Log[b^(1/3) + a^(1/3)*x])/(9*a^(7/3)) + (2*b^(1/3)*Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2])/(9*a^(7/3))}
{1/(x^1*(a + b/x^3)^2), x, 4, b/(3*a^2*(b + a*x^3)) + Log[b + a*x^3]/(3*a^2)}
{1/(x^2*(a + b/x^3)^2), x, 8, -(x^2/(3*a*(b + a*x^3))) - (2*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(3*Sqrt[3]*a^(5/3)*b^(1/3)) - (2*Log[b^(1/3) + a^(1/3)*x])/(9*a^(5/3)*b^(1/3)) + Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2]/(9*a^(5/3)*b^(1/3))}
{1/(x^3*(a + b/x^3)^2), x, 8, -(x/(3*a*(b + a*x^3))) - ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))]/(3*Sqrt[3]*a^(4/3)*b^(2/3)) + Log[b^(1/3) + a^(1/3)*x]/(9*a^(4/3)*b^(2/3)) - Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2]/(18*a^(4/3)*b^(2/3))}
{1/(x^4*(a + b/x^3)^2), x, 1, 1/(3*b*(a + b/x^3))}
{1/(x^5*(a + b/x^3)^2), x, 8, x^2/(3*b*(b + a*x^3)) - ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))]/(3*Sqrt[3]*a^(2/3)*b^(4/3)) - Log[b^(1/3) + a^(1/3)*x]/(9*a^(2/3)*b^(4/3)) + Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2]/(18*a^(2/3)*b^(4/3))}
{1/(x^6*(a + b/x^3)^2), x, 8, x/(3*b*(b + a*x^3)) - (2*ArcTan[(b^(1/3) - 2*a^(1/3)*x)/(Sqrt[3]*b^(1/3))])/(3*Sqrt[3]*a^(1/3)*b^(5/3)) + (2*Log[b^(1/3) + a^(1/3)*x])/(9*a^(1/3)*b^(5/3)) - Log[b^(2/3) - a^(1/3)*b^(1/3)*x + a^(2/3)*x^2]/(9*a^(1/3)*b^(5/3))}
{1/(x^7*(a + b/x^3)^2), x, 4, 1/(3*b*(b + a*x^3)) + Log[x]/b^2 - Log[b + a*x^3]/(3*b^2)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^3)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{Sqrt[a + b/x^3]*x^5, x, 5, (b*Sqrt[a + b/x^3]*x^3)/(12*a) + (Sqrt[a + b/x^3]*x^6)/6 - (b^2*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(12*a^(3/2))}
{Sqrt[a + b/x^3]*x^2, x, 4, (Sqrt[a + b/x^3]*x^3)/3 + (b*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(3*Sqrt[a])}
{Sqrt[a + b/x^3]/x^1, x, 4, (-2*Sqrt[a + b/x^3])/3 + (2*Sqrt[a]*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/3}
{Sqrt[a + b/x^3]/x^4, x, 1, (-2*(a + b/x^3)^(3/2))/(9*b)}
{Sqrt[a + b/x^3]/x^7, x, 3, (2*a*(a + b/x^3)^(3/2))/(9*b^2) - (2*(a + b/x^3)^(5/2))/(15*b^2)}
{Sqrt[a + b/x^3]/x^10, x, 3, (-2*a^2*(a + b/x^3)^(3/2))/(9*b^3) + (4*a*(a + b/x^3)^(5/2))/(15*b^3) - (2*(a + b/x^3)^(7/2))/(21*b^3)}
{Sqrt[a + b/x^3]/x^13, x, 3, (2*a^3*(a + b/x^3)^(3/2))/(9*b^4) - (2*a^2*(a + b/x^3)^(5/2))/(5*b^4) + (2*a*(a + b/x^3)^(7/2))/(7*b^4) - (2*(a + b/x^3)^(9/2))/(27*b^4)}

{Sqrt[a + b/x^3]*x^7, x, 5, -((21*b^2*Sqrt[a + b/x^3]*x^2)/(320*a^2)) + (3*b*Sqrt[a + b/x^3]*x^5)/(80*a) + (1/8)*Sqrt[a + b/x^3]*x^8 - (7*3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(8/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(320*a^2*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]*x^4, x, 4, (3*b*Sqrt[a + b/x^3]*x^2)/(20*a) + (1/5)*Sqrt[a + b/x^3]*x^5 + (3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(5/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(20*a*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]*x^1, x, 3, (1/2)*Sqrt[a + b/x^3]*x^2 - (3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(2/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(2*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]/x^2, x, 3, -((2*Sqrt[a + b/x^3])/(5*x)) - (2*3^(3/4)*Sqrt[2 + Sqrt[3]]*a*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(5*b^(1/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]/x^5, x, 4, -((2*Sqrt[a + b/x^3])/(11*x^4)) - (6*a*Sqrt[a + b/x^3])/(55*b*x) + (4*3^(3/4)*Sqrt[2 + Sqrt[3]]*a^2*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(55*b^(4/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]/x^8, x, 5, -((2*Sqrt[a + b/x^3])/(17*x^7)) - (6*a*Sqrt[a + b/x^3])/(187*b*x^4) + (48*a^2*Sqrt[a + b/x^3])/(935*b^2*x) - (32*3^(3/4)*Sqrt[2 + Sqrt[3]]*a^3*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(935*b^(7/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}

{Sqrt[a + b/x^3]*x^6, x, 7, (15*b^(7/3)*Sqrt[a + b/x^3])/(112*a^2*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) - (15*b^2*Sqrt[a + b/x^3]*x)/(112*a^2) + (3*b*Sqrt[a + b/x^3]*x^4)/(56*a) + (1/7)*Sqrt[a + b/x^3]*x^7 - (15*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(224*a^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (5*3^(3/4)*b^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(56*Sqrt[2]*a^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]*x^3, x, 6, -((3*b^(4/3)*Sqrt[a + b/x^3])/(8*a*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) + (3*b*Sqrt[a + b/x^3]*x)/(8*a) + (1/4)*Sqrt[a + b/x^3]*x^4 + (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(16*a^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (3^(3/4)*b^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*a^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]*x^0, x, 5, -((3*b^(1/3)*Sqrt[a + b/x^3])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) + Sqrt[a + b/x^3]*x + (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*b^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(2*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (Sqrt[2]*3^(3/4)*a^(1/3)*b^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]/x^3, x, 5, -((6*a*Sqrt[a + b/x^3])/(7*b^(2/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) - (2*Sqrt[a + b/x^3])/(7*x^2) + (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(7*b^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (2*Sqrt[2]*3^(3/4)*a^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(7*b^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]/x^6, x, 6, (24*a^2*Sqrt[a + b/x^3])/(91*b^(5/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) - (2*Sqrt[a + b/x^3])/(13*x^5) - (6*a*Sqrt[a + b/x^3])/(91*b*x^2) - (12*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(91*b^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (8*Sqrt[2]*3^(3/4)*a^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(91*b^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{Sqrt[a + b/x^3]/x^9, x, 7, -((240*a^3*Sqrt[a + b/x^3])/(1729*b^(8/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) - (2*Sqrt[a + b/x^3])/(19*x^8) - (6*a*Sqrt[a + b/x^3])/(247*b*x^5) + (60*a^2*Sqrt[a + b/x^3])/(1729*b^2*x^2) + (120*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(10/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(1729*b^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (80*Sqrt[2]*3^(3/4)*a^(10/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(1729*b^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}


{(a + b/x^3)^(3/2)*x^5, x, 5, (b*Sqrt[a + b/x^3]*x^3)/4 + ((a + b/x^3)^(3/2)*x^6)/6 + (b^2*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(4*Sqrt[a])}
{(a + b/x^3)^(3/2)*x^2, x, 5, -(b*Sqrt[a + b/x^3]) + ((a + b/x^3)^(3/2)*x^3)/3 + Sqrt[a]*b*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]]}
{(a + b/x^3)^(3/2)/x^1, x, 5, (-2*a*Sqrt[a + b/x^3])/3 - (2*(a + b/x^3)^(3/2))/9 + (2*a^(3/2)*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/3}
{(a + b/x^3)^(3/2)/x^4, x, 1, (-2*(a + b/x^3)^(5/2))/(15*b)}
{(a + b/x^3)^(3/2)/x^7, x, 3, (2*a*(a + b/x^3)^(5/2))/(15*b^2) - (2*(a + b/x^3)^(7/2))/(21*b^2)}
{(a + b/x^3)^(3/2)/x^10, x, 3, (-2*a^2*(a + b/x^3)^(5/2))/(15*b^3) + (4*a*(a + b/x^3)^(7/2))/(21*b^3) - (2*(a + b/x^3)^(9/2))/(27*b^3)}
{(a + b/x^3)^(3/2)/x^13, x, 3, (2*a^3*(a + b/x^3)^(5/2))/(15*b^4) - (2*a^2*(a + b/x^3)^(7/2))/(7*b^4) + (2*a*(a + b/x^3)^(9/2))/(9*b^4) - (2*(a + b/x^3)^(11/2))/(33*b^4)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^5/Sqrt[a + b/x^3], x, 5, -((b*Sqrt[a + b/x^3]*x^3)/(4*a^2)) + (Sqrt[a + b/x^3]*x^6)/(6*a) + (b^2*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(4*a^(5/2))}
{x^2/Sqrt[a + b/x^3], x, 4, (Sqrt[a + b/x^3]*x^3)/(3*a) - (b*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(3*a^(3/2))}
{1/(x^1*Sqrt[a + b/x^3]), x, 3, (2*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(3*Sqrt[a])}
{1/(x^4*Sqrt[a + b/x^3]), x, 1, -((2*Sqrt[a + b/x^3])/(3*b))}
{1/(x^7*Sqrt[a + b/x^3]), x, 3, (2*a*Sqrt[a + b/x^3])/(3*b^2) - (2*(a + b/x^3)^(3/2))/(9*b^2)}
{1/(x^10*Sqrt[a + b/x^3]), x, 3, -((2*a^2*Sqrt[a + b/x^3])/(3*b^3)) + (4*a*(a + b/x^3)^(3/2))/(9*b^3) - (2*(a + b/x^3)^(5/2))/(15*b^3)}
{1/(x^13*Sqrt[a + b/x^3]), x, 3, (2*a^3*Sqrt[a + b/x^3])/(3*b^4) - (2*a^2*(a + b/x^3)^(3/2))/(3*b^4) + (2*a*(a + b/x^3)^(5/2))/(5*b^4) - (2*(a + b/x^3)^(7/2))/(21*b^4)}

{x^7/Sqrt[a + b/x^3], x, 5, (91*b^2*Sqrt[a + b/x^3]*x^2)/(320*a^3) - (13*b*Sqrt[a + b/x^3]*x^5)/(80*a^2) + (Sqrt[a + b/x^3]*x^8)/(8*a) + (91*Sqrt[2 + Sqrt[3]]*b^(8/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(320*3^(1/4)*a^3*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^4/Sqrt[a + b/x^3], x, 4, -((7*b*Sqrt[a + b/x^3]*x^2)/(20*a^2)) + (Sqrt[a + b/x^3]*x^5)/(5*a) - (7*Sqrt[2 + Sqrt[3]]*b^(5/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(20*3^(1/4)*a^2*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^1/Sqrt[a + b/x^3], x, 3, (Sqrt[a + b/x^3]*x^2)/(2*a) + (Sqrt[2 + Sqrt[3]]*b^(2/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(2*3^(1/4)*a*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^2*Sqrt[a + b/x^3]), x, 2, -((2*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3^(1/4)*b^(1/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]))}
{1/(x^5*Sqrt[a + b/x^3]), x, 3, -((2*Sqrt[a + b/x^3])/(5*b*x)) + (4*Sqrt[2 + Sqrt[3]]*a*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(5*3^(1/4)*b^(4/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^8*Sqrt[a + b/x^3]), x, 4, -((2*Sqrt[a + b/x^3])/(11*b*x^4)) + (16*a*Sqrt[a + b/x^3])/(55*b^2*x) - (32*Sqrt[2 + Sqrt[3]]*a^2*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(55*3^(1/4)*b^(7/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}

{x^6/Sqrt[a + b/x^3], x, 7, -((55*b^(7/3)*Sqrt[a + b/x^3])/(112*a^3*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) + (55*b^2*Sqrt[a + b/x^3]*x)/(112*a^3) - (11*b*Sqrt[a + b/x^3]*x^4)/(56*a^2) + (Sqrt[a + b/x^3]*x^7)/(7*a) + (55*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(224*a^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (55*b^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(56*Sqrt[2]*3^(1/4)*a^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^3/Sqrt[a + b/x^3], x, 6, (5*b^(4/3)*Sqrt[a + b/x^3])/(8*a^2*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) - (5*b*Sqrt[a + b/x^3]*x)/(8*a^2) + (Sqrt[a + b/x^3]*x^4)/(4*a) - (5*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(16*a^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (5*b^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*3^(1/4)*a^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^0/Sqrt[a + b/x^3], x, 5, -((b^(1/3)*Sqrt[a + b/x^3])/(a*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) + (Sqrt[a + b/x^3]*x)/a + (3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(2*a^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (Sqrt[2]*b^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3^(1/4)*a^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^3*Sqrt[a + b/x^3]), x, 4, -((2*Sqrt[a + b/x^3])/(b^(2/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) + (3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(b^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (2*Sqrt[2]*a^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3^(1/4)*b^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^6*Sqrt[a + b/x^3]), x, 5, (8*a*Sqrt[a + b/x^3])/(7*b^(5/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) - (2*Sqrt[a + b/x^3])/(7*b*x^2) - (4*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(7*b^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (8*Sqrt[2]*a^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(7*3^(1/4)*b^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^9*Sqrt[a + b/x^3]), x, 6, -((80*a^2*Sqrt[a + b/x^3])/(91*b^(8/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) - (2*Sqrt[a + b/x^3])/(13*b*x^5) + (20*a*Sqrt[a + b/x^3])/(91*b^2*x^2) + (40*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(91*b^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (80*Sqrt[2]*a^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(91*3^(1/4)*b^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^12*Sqrt[a + b/x^3]), x, 7, (1280*a^3*Sqrt[a + b/x^3])/(1729*b^(11/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) - (2*Sqrt[a + b/x^3])/(19*b*x^8) + (32*a*Sqrt[a + b/x^3])/(247*b^2*x^5) - (320*a^2*Sqrt[a + b/x^3])/(1729*b^3*x^2) - (640*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(10/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(1729*b^(11/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (1280*Sqrt[2]*a^(10/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(1729*3^(1/4)*b^(11/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}


{x^5/(a + b/x^3)^(3/2), x, 6, -((5*b^2)/(4*a^3*Sqrt[a + b/x^3])) - (5*b*x^3)/(12*a^2*Sqrt[a + b/x^3]) + x^6/(6*a*Sqrt[a + b/x^3]) + (5*b^2*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(4*a^(7/2))}
{x^2/(a + b/x^3)^(3/2), x, 5, b/(a^2*Sqrt[a + b/x^3]) + x^3/(3*a*Sqrt[a + b/x^3]) - (b*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/a^(5/2)}
{1/(x^1*(a + b/x^3)^(3/2)), x, 4, -(2/(3*a*Sqrt[a + b/x^3])) + (2*ArcTanh[Sqrt[a + b/x^3]/Sqrt[a]])/(3*a^(3/2))}
{1/(x^4*(a + b/x^3)^(3/2)), x, 1, 2/(3*b*Sqrt[a + b/x^3])}
{1/(x^7*(a + b/x^3)^(3/2)), x, 3, -((2*a)/(3*b^2*Sqrt[a + b/x^3])) - (2*Sqrt[a + b/x^3])/(3*b^2)}
{1/(x^10*(a + b/x^3)^(3/2)), x, 3, (2*a^2)/(3*b^3*Sqrt[a + b/x^3]) + (4*a*Sqrt[a + b/x^3])/(3*b^3) - (2*(a + b/x^3)^(3/2))/(9*b^3)}
{1/(x^13*(a + b/x^3)^(3/2)), x, 3, -((2*a^3)/(3*b^4*Sqrt[a + b/x^3])) - (2*a^2*Sqrt[a + b/x^3])/b^4 + (2*a*(a + b/x^3)^(3/2))/(3*b^4) - (2*(a + b/x^3)^(5/2))/(15*b^4)}

{x^7/(a + b/x^3)^(3/2), x, 6, (1729*b^2*Sqrt[a + b/x^3]*x^2)/(960*a^4) - (247*b*Sqrt[a + b/x^3]*x^5)/(240*a^3) - (2*x^8)/(3*a*Sqrt[a + b/x^3]) + (19*Sqrt[a + b/x^3]*x^8)/(24*a^2) + (1729*Sqrt[2 + Sqrt[3]]*b^(8/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(960*3^(1/4)*a^4*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^4/(a + b/x^3)^(3/2), x, 5, -((91*b*Sqrt[a + b/x^3]*x^2)/(60*a^3)) - (2*x^5)/(3*a*Sqrt[a + b/x^3]) + (13*Sqrt[a + b/x^3]*x^5)/(15*a^2) - (91*Sqrt[2 + Sqrt[3]]*b^(5/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(60*3^(1/4)*a^3*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^1/(a + b/x^3)^(3/2), x, 4, -((2*x^2)/(3*a*Sqrt[a + b/x^3])) + (7*Sqrt[a + b/x^3]*x^2)/(6*a^2) + (7*Sqrt[2 + Sqrt[3]]*b^(2/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(6*3^(1/4)*a^2*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^2*(a + b/x^3)^(3/2)), x, 3, -(2/(3*a*Sqrt[a + b/x^3]*x)) - (2*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a*b^(1/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^5*(a + b/x^3)^(3/2)), x, 3, 2/(3*b*Sqrt[a + b/x^3]*x) - (4*Sqrt[2 + Sqrt[3]]*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*b^(4/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^8*(a + b/x^3)^(3/2)), x, 4, 2/(3*b*Sqrt[a + b/x^3]*x^4) - (16*Sqrt[a + b/x^3])/(15*b^2*x) + (32*Sqrt[2 + Sqrt[3]]*a*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(15*3^(1/4)*b^(7/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}

{x^6/(a + b/x^3)^(3/2), x, 8, -((935*b^(7/3)*Sqrt[a + b/x^3])/(336*a^4*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) + (935*b^2*Sqrt[a + b/x^3]*x)/(336*a^4) - (187*b*Sqrt[a + b/x^3]*x^4)/(168*a^3) - (2*x^7)/(3*a*Sqrt[a + b/x^3]) + (17*Sqrt[a + b/x^3]*x^7)/(21*a^2) + (935*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(672*a^(11/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (935*b^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(168*Sqrt[2]*3^(1/4)*a^(11/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^3/(a + b/x^3)^(3/2), x, 7, (55*b^(4/3)*Sqrt[a + b/x^3])/(24*a^3*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) - (55*b*Sqrt[a + b/x^3]*x)/(24*a^3) - (2*x^4)/(3*a*Sqrt[a + b/x^3]) + (11*Sqrt[a + b/x^3]*x^4)/(12*a^2) - (55*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(48*a^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (55*b^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(12*Sqrt[2]*3^(1/4)*a^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{x^0/(a + b/x^3)^(3/2), x, 6, -((5*b^(1/3)*Sqrt[a + b/x^3])/(3*a^2*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) - (2*x)/(3*a*Sqrt[a + b/x^3]) + (5*Sqrt[a + b/x^3]*x)/(3*a^2) + (5*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(6*a^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (5*Sqrt[2]*b^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^3*(a + b/x^3)^(3/2)), x, 5, (2*Sqrt[a + b/x^3])/(3*a*b^(2/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) - 2/(3*a*Sqrt[a + b/x^3]*x^2) - (3^(1/4)*Sqrt[2 - Sqrt[3]]*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3*a^(2/3)*b^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (2*Sqrt[2]*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*a^(2/3)*b^(2/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^6*(a + b/x^3)^(3/2)), x, 5, -((8*Sqrt[a + b/x^3])/(3*b^(5/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) + 2/(3*b*Sqrt[a + b/x^3]*x^2) + (4*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3*b^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (8*Sqrt[2]*a^(1/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(3*3^(1/4)*b^(5/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^9*(a + b/x^3)^(3/2)), x, 6, (80*a*Sqrt[a + b/x^3])/(21*b^(8/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)) + 2/(3*b*Sqrt[a + b/x^3]*x^5) - (20*Sqrt[a + b/x^3])/(21*b^2*x^2) - (40*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(21*b^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) + (80*Sqrt[2]*a^(4/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(21*3^(1/4)*b^(8/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}
{1/(x^12*(a + b/x^3)^(3/2)), x, 7, -((1280*a^2*Sqrt[a + b/x^3])/(273*b^(11/3)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x))) + 2/(3*b*Sqrt[a + b/x^3]*x^8) - (32*Sqrt[a + b/x^3])/(39*b^2*x^5) + (320*a*Sqrt[a + b/x^3])/(273*b^3*x^2) + (640*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(273*b^(11/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]) - (1280*Sqrt[2]*a^(7/3)*(a^(1/3) + b^(1/3)/x)*Sqrt[(a^(2/3) + b^(2/3)/x^2 - (a^(1/3)*b^(1/3))/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)/x)/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)], -7 - 4*Sqrt[3]])/(273*3^(1/4)*b^(11/3)*Sqrt[a + b/x^3]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)/x))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)/x)^2])}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^4)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^4)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(a + b/x^4), x, 11, x/a + (b^(1/4)*ArcTan[1 - (Sqrt[2]*a^(1/4)*x)/b^(1/4)])/(2*Sqrt[2]*a^(5/4)) - (b^(1/4)*ArcTan[1 + (Sqrt[2]*a^(1/4)*x)/b^(1/4)])/(2*Sqrt[2]*a^(5/4)) + (b^(1/4)*Log[Sqrt[b] - Sqrt[2]*a^(1/4)*b^(1/4)*x + Sqrt[a]*x^2])/(4*Sqrt[2]*a^(5/4)) - (b^(1/4)*Log[Sqrt[b] + Sqrt[2]*a^(1/4)*b^(1/4)*x + Sqrt[a]*x^2])/(4*Sqrt[2]*a^(5/4))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^4)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{Sqrt[a + b/x^4]*x^3, x, 4, (Sqrt[a + b/x^4]*x^4)/4 + (b*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/(4*Sqrt[a])}
{Sqrt[a + b/x^4]*x^1, x, 5, (Sqrt[a + b/x^4]*x^2)/2 - (Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^4]*x^2)])/2}
{Sqrt[a + b/x^4]/x^1, x, 4, -Sqrt[a + b/x^4]/2 + (Sqrt[a]*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/2}
{Sqrt[a + b/x^4]/x^3, x, 5, -Sqrt[a + b/x^4]/(4*x^2) - (a*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^4]*x^2)])/(4*Sqrt[b])}

{Sqrt[a + b/x^4]*x^2, x, 3, (1/3)*Sqrt[a + b/x^4]*x^3 - (b^(3/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(3*a^(1/4)*Sqrt[a + b/x^4])}
{Sqrt[a + b/x^4]*x^0, x, 5, -((2*Sqrt[b]*Sqrt[a + b/x^4])/((Sqrt[a] + Sqrt[b]/x^2)*x)) + Sqrt[a + b/x^4]*x + (2*a^(1/4)*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/Sqrt[a + b/x^4] - (a^(1/4)*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/Sqrt[a + b/x^4]}
{Sqrt[a + b/x^4]/x^2, x, 3, -(Sqrt[a + b/x^4]/(3*x)) - (a^(3/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(3*b^(1/4)*Sqrt[a + b/x^4])}
{Sqrt[a + b/x^4]/x^4, x, 5, -(Sqrt[a + b/x^4]/(5*x^3)) - (2*a*Sqrt[a + b/x^4])/(5*Sqrt[b]*(Sqrt[a] + Sqrt[b]/x^2)*x) + (2*a^(5/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(5*b^(3/4)*Sqrt[a + b/x^4]) - (a^(5/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(5*b^(3/4)*Sqrt[a + b/x^4])}


{(a + b/x^4)^(3/2)*x^3, x, 5, (-3*b*Sqrt[a + b/x^4])/4 + ((a + b/x^4)^(3/2)*x^4)/4 + (3*Sqrt[a]*b*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/4}
{(a + b/x^4)^(3/2)*x^1, x, 6, (-3*b*Sqrt[a + b/x^4])/(4*x^2) + ((a + b/x^4)^(3/2)*x^2)/2 - (3*a*Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^4]*x^2)])/4}
{(a + b/x^4)^(3/2)/x^1, x, 5, -(a*Sqrt[a + b/x^4])/2 - (a + b/x^4)^(3/2)/6 + (a^(3/2)*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/2}
{(a + b/x^4)^(3/2)/x^3, x, 6, (-3*a*Sqrt[a + b/x^4])/(16*x^2) - (a + b/x^4)^(3/2)/(8*x^2) - (3*a^2*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^4]*x^2)])/(16*Sqrt[b])}

{(a + b/x^4)^(3/2)*x^2, x, 4, -((2*b*Sqrt[a + b/x^4])/(3*x)) + (1/3)*(a + b/x^4)^(3/2)*x^3 - (2*a^(3/4)*b^(3/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(3*Sqrt[a + b/x^4])}
{(a + b/x^4)^(3/2)*x^0, x, 6, -((6*b*Sqrt[a + b/x^4])/(5*x^3)) - (12*a*Sqrt[b]*Sqrt[a + b/x^4])/(5*(Sqrt[a] + Sqrt[b]/x^2)*x) + (a + b/x^4)^(3/2)*x + (12*a^(5/4)*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(5*Sqrt[a + b/x^4]) - (6*a^(5/4)*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(5*Sqrt[a + b/x^4])}
{(a + b/x^4)^(3/2)/x^2, x, 4, -((2*a*Sqrt[a + b/x^4])/(7*x)) - (a + b/x^4)^(3/2)/(7*x) - (2*a^(7/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(7*b^(1/4)*Sqrt[a + b/x^4])}
{(a + b/x^4)^(3/2)/x^4, x, 6, -((2*a*Sqrt[a + b/x^4])/(15*x^3)) - (a + b/x^4)^(3/2)/(9*x^3) - (4*a^2*Sqrt[a + b/x^4])/(15*Sqrt[b]*(Sqrt[a] + Sqrt[b]/x^2)*x) + (4*a^(9/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(15*b^(3/4)*Sqrt[a + b/x^4]) - (2*a^(9/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(15*b^(3/4)*Sqrt[a + b/x^4])}


{(a + b/x^4)^(5/2)*x^3, x, 6, (-5*a*b*Sqrt[a + b/x^4])/4 - (5*b*(a + b/x^4)^(3/2))/12 + ((a + b/x^4)^(5/2)*x^4)/4 + (5*a^(3/2)*b*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/4}
{(a + b/x^4)^(5/2)*x^1, x, 7, (-15*a*b*Sqrt[a + b/x^4])/(16*x^2) - (5*b*(a + b/x^4)^(3/2))/(8*x^2) + ((a + b/x^4)^(5/2)*x^2)/2 - (15*a^2*Sqrt[b]*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^4]*x^2)])/16}
{(a + b/x^4)^(5/2)/x^1, x, 6, -(a^2*Sqrt[a + b/x^4])/2 - (a*(a + b/x^4)^(3/2))/6 - (a + b/x^4)^(5/2)/10 + (a^(5/2)*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/2}
{(a + b/x^4)^(5/2)/x^3, x, 7, (-5*a^2*Sqrt[a + b/x^4])/(32*x^2) - (5*a*(a + b/x^4)^(3/2))/(48*x^2) - (a + b/x^4)^(5/2)/(12*x^2) - (5*a^3*ArcTanh[Sqrt[b]/(Sqrt[a + b/x^4]*x^2)])/(32*Sqrt[b])}

{(a + b/x^4)^(5/2)*x^2, x, 5, -((20*a*b*Sqrt[a + b/x^4])/(21*x)) - (10*b*(a + b/x^4)^(3/2))/(21*x) + (1/3)*(a + b/x^4)^(5/2)*x^3 - (20*a^(7/4)*b^(3/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(21*Sqrt[a + b/x^4])}
{(a + b/x^4)^(5/2)*x^0, x, 7, -((4*a*b*Sqrt[a + b/x^4])/(3*x^3)) - (10*b*(a + b/x^4)^(3/2))/(9*x^3) - (8*a^2*Sqrt[b]*Sqrt[a + b/x^4])/(3*(Sqrt[a] + Sqrt[b]/x^2)*x) + (a + b/x^4)^(5/2)*x + (8*a^(9/4)*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(3*Sqrt[a + b/x^4]) - (4*a^(9/4)*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(3*Sqrt[a + b/x^4])}
{(a + b/x^4)^(5/2)/x^2, x, 5, -((20*a^2*Sqrt[a + b/x^4])/(77*x)) - (10*a*(a + b/x^4)^(3/2))/(77*x) - (a + b/x^4)^(5/2)/(11*x) - (20*a^(11/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(77*b^(1/4)*Sqrt[a + b/x^4])}
{(a + b/x^4)^(5/2)/x^4, x, 7, -((4*a^2*Sqrt[a + b/x^4])/(39*x^3)) - (10*a*(a + b/x^4)^(3/2))/(117*x^3) - (a + b/x^4)^(5/2)/(13*x^3) - (8*a^3*Sqrt[a + b/x^4])/(39*Sqrt[b]*(Sqrt[a] + Sqrt[b]/x^2)*x) + (8*a^(13/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(39*b^(3/4)*Sqrt[a + b/x^4]) - (4*a^(13/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(39*b^(3/4)*Sqrt[a + b/x^4])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^3/Sqrt[a + b/x^4], x, 4, (Sqrt[a + b/x^4]*x^4)/(4*a) - (b*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/(4*a^(3/2))}
{x^1/Sqrt[a + b/x^4], x, 1, (Sqrt[a + b/x^4]*x^2)/(2*a)}
{1/(Sqrt[a + b/x^4]*x^1), x, 3, ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]]/(2*Sqrt[a])}
{1/(Sqrt[a + b/x^4]*x^3), x, 4, -ArcTanh[Sqrt[b]/(Sqrt[a + b/x^4]*x^2)]/(2*Sqrt[b])}

{x^2/Sqrt[a + b/x^4], x, 3, (Sqrt[a + b/x^4]*x^3)/(3*a) + (b^(3/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(6*a^(5/4)*Sqrt[a + b/x^4])}
{x^0/Sqrt[a + b/x^4], x, 5, -((Sqrt[b]*Sqrt[a + b/x^4])/(a*(Sqrt[a] + Sqrt[b]/x^2)*x)) + (Sqrt[a + b/x^4]*x)/a + (b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(a^(3/4)*Sqrt[a + b/x^4]) - (b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(2*a^(3/4)*Sqrt[a + b/x^4])}
{1/(Sqrt[a + b/x^4]*x^2), x, 2, -((Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(2*a^(1/4)*b^(1/4)*Sqrt[a + b/x^4]))}
{1/(Sqrt[a + b/x^4]*x^4), x, 4, -(Sqrt[a + b/x^4]/(Sqrt[b]*(Sqrt[a] + Sqrt[b]/x^2)*x)) + (a^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(b^(3/4)*Sqrt[a + b/x^4]) - (a^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(2*b^(3/4)*Sqrt[a + b/x^4])}


{x^3/(a + b/x^4)^(3/2), x, 5, (3*b)/(4*a^2*Sqrt[a + b/x^4]) + x^4/(4*a*Sqrt[a + b/x^4]) - (3*b*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/(4*a^(5/2))}
{x^1/(a + b/x^4)^(3/2), x, 2, -(x^2/(2*a*Sqrt[a + b/x^4])) + (Sqrt[a + b/x^4]*x^2)/a^2}
{1/((a + b/x^4)^(3/2)*x^1), x, 4, -1/(2*a*Sqrt[a + b/x^4]) + ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]]/(2*a^(3/2))}
{1/((a + b/x^4)^(3/2)*x^3), x, 1, -1/(2*a*Sqrt[a + b/x^4]*x^2)}

{x^2/(a + b/x^4)^(3/2), x, 4, -(x^3/(2*a*Sqrt[a + b/x^4])) + (5*Sqrt[a + b/x^4]*x^3)/(6*a^2) + (5*b^(3/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(12*a^(9/4)*Sqrt[a + b/x^4])}
{x^0/(a + b/x^4)^(3/2), x, 6, -((3*Sqrt[b]*Sqrt[a + b/x^4])/(2*a^2*(Sqrt[a] + Sqrt[b]/x^2)*x)) - x/(2*a*Sqrt[a + b/x^4]) + (3*Sqrt[a + b/x^4]*x)/(2*a^2) + (3*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(2*a^(7/4)*Sqrt[a + b/x^4]) - (3*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(4*a^(7/4)*Sqrt[a + b/x^4])}
{1/((a + b/x^4)^(3/2)*x^2), x, 3, -(1/(2*a*Sqrt[a + b/x^4]*x)) - (Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(4*a^(5/4)*b^(1/4)*Sqrt[a + b/x^4])}
{1/((a + b/x^4)^(3/2)*x^4), x, 5, -(1/(2*a*Sqrt[a + b/x^4]*x^3)) + Sqrt[a + b/x^4]/(2*a*Sqrt[b]*(Sqrt[a] + Sqrt[b]/x^2)*x) - (Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(2*a^(3/4)*b^(3/4)*Sqrt[a + b/x^4]) + (Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(4*a^(3/4)*b^(3/4)*Sqrt[a + b/x^4])}


{x^3/(a + b/x^4)^(5/2), x, 6, (5*b)/(12*a^2*(a + b/x^4)^(3/2)) + (5*b)/(4*a^3*Sqrt[a + b/x^4]) + x^4/(4*a*(a + b/x^4)^(3/2)) - (5*b*ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]])/(4*a^(7/2))}
{x^1/(a + b/x^4)^(5/2), x, 3, -(x^2/(6*a*(a + b/x^4)^(3/2))) - (2*x^2)/(3*a^2*Sqrt[a + b/x^4]) + (4*Sqrt[a + b/x^4]*x^2)/(3*a^3)}
{1/((a + b/x^4)^(5/2)*x^1), x, 5, -1/(6*a*(a + b/x^4)^(3/2)) - 1/(2*a^2*Sqrt[a + b/x^4]) + ArcTanh[Sqrt[a + b/x^4]/Sqrt[a]]/(2*a^(5/2))}
{1/((a + b/x^4)^(5/2)*x^3), x, 2, -(b/(3*a^2*(a + b/x^4)^(3/2)*x^6)) - 1/(2*a*(a + b/x^4)^(3/2)*x^2)}

{x^2/(a + b/x^4)^(5/2), x, 5, -(x^3/(6*a*(a + b/x^4)^(3/2))) - (3*x^3)/(4*a^2*Sqrt[a + b/x^4]) + (5*Sqrt[a + b/x^4]*x^3)/(4*a^3) + (5*b^(3/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(8*a^(13/4)*Sqrt[a + b/x^4])}
{x^0/(a + b/x^4)^(5/2), x, 7, -((7*Sqrt[b]*Sqrt[a + b/x^4])/(4*a^3*(Sqrt[a] + Sqrt[b]/x^2)*x)) - x/(6*a*(a + b/x^4)^(3/2)) - (7*x)/(12*a^2*Sqrt[a + b/x^4]) + (7*Sqrt[a + b/x^4]*x)/(4*a^3) + (7*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(4*a^(11/4)*Sqrt[a + b/x^4]) - (7*b^(1/4)*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(8*a^(11/4)*Sqrt[a + b/x^4])}
{1/((a + b/x^4)^(5/2)*x^2), x, 4, -(1/(6*a*(a + b/x^4)^(3/2)*x)) - 5/(12*a^2*Sqrt[a + b/x^4]*x) - (5*Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(24*a^(9/4)*b^(1/4)*Sqrt[a + b/x^4])}
{1/((a + b/x^4)^(5/2)*x^4), x, 6, -(1/(6*a*(a + b/x^4)^(3/2)*x^3)) - 1/(4*a^2*Sqrt[a + b/x^4]*x^3) + Sqrt[a + b/x^4]/(4*a^2*Sqrt[b]*(Sqrt[a] + Sqrt[b]/x^2)*x) - (Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticE[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(4*a^(7/4)*b^(3/4)*Sqrt[a + b/x^4]) + (Sqrt[(a + b/x^4)/(Sqrt[a] + Sqrt[b]/x^2)^2]*(Sqrt[a] + Sqrt[b]/x^2)*EllipticF[2*ArcCot[(a^(1/4)*x)/b^(1/4)], 1/2])/(8*a^(7/4)*b^(3/4)*Sqrt[a + b/x^4])}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^5)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^5)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(a + b/x^5), x, 8, x/a - (Sqrt[(1/2)*(5 + Sqrt[5])]*b^(1/5)*ArcTan[Sqrt[(1/5)*(5 - 2*Sqrt[5])] + (2*Sqrt[2/(5 + Sqrt[5])]*a^(1/5)*x)/b^(1/5)])/(5*a^(6/5)) + (Sqrt[(1/2)*(5 - Sqrt[5])]*b^(1/5)*ArcTan[Sqrt[(1/5)*(5 + 2*Sqrt[5])] - (Sqrt[(2/5)*(5 + Sqrt[5])]*a^(1/5)*x)/b^(1/5)])/(5*a^(6/5)) - (b^(1/5)*Log[b^(1/5) + a^(1/5)*x])/(5*a^(6/5)) + ((1 - Sqrt[5])*b^(1/5)*Log[b^(2/5) - (1/2)*(1 - Sqrt[5])*a^(1/5)*b^(1/5)*x + a^(2/5)*x^2])/(20*a^(6/5)) + ((1 + Sqrt[5])*b^(1/5)*Log[b^(2/5) - (1/2)*(1 + Sqrt[5])*a^(1/5)*b^(1/5)*x + a^(2/5)*x^2])/(20*a^(6/5))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^5)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(Sqrt[a + b/x^5]*x), x, 3, (2*ArcTanh[Sqrt[a + b/x^5]/Sqrt[a]])/(5*Sqrt[a])}
{1/(Sqrt[-a + b/x^5]*x), x, 3, (-2*ArcTan[Sqrt[-a + b/x^5]/Sqrt[a]])/(5*Sqrt[a])}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^6)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^6)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(a + b/x^6), x, 12, x/a - (b^(1/6)*ArcTan[(a^(1/6)*x)/b^(1/6)])/(3*a^(7/6)) + (b^(1/6)*ArcTan[(Sqrt[3]*b^(1/6) - 2*a^(1/6)*x)/b^(1/6)])/(6*a^(7/6)) - (b^(1/6)*ArcTan[(Sqrt[3]*b^(1/6) + 2*a^(1/6)*x)/b^(1/6)])/(6*a^(7/6)) + (b^(1/6)*Log[b^(1/3) - Sqrt[3]*a^(1/6)*b^(1/6)*x + a^(1/3)*x^2])/(4*Sqrt[3]*a^(7/6)) - (b^(1/6)*Log[b^(1/3) + Sqrt[3]*a^(1/6)*b^(1/6)*x + a^(1/3)*x^2])/(4*Sqrt[3]*a^(7/6))}


(* ::Subsection:: *)
(*Integrands of the form x^m (a+b/x^6)^(p/2)*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^8)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^8)^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(a + b/x^8), x, 15, x/a + (b^(1/8)*ArcTan[((-a)^(1/8)*x)/b^(1/8)])/(4*(-a)^(9/8)) - (b^(1/8)*ArcTan[1 - (Sqrt[2]*(-a)^(1/8)*x)/b^(1/8)])/(4*Sqrt[2]*(-a)^(9/8)) + (b^(1/8)*ArcTan[1 + (Sqrt[2]*(-a)^(1/8)*x)/b^(1/8)])/(4*Sqrt[2]*(-a)^(9/8)) + (b^(1/8)*ArcTanh[((-a)^(1/8)*x)/b^(1/8)])/(4*(-a)^(9/8)) - (b^(1/8)*Log[b^(1/4) - Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + (-a)^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(9/8)) + (b^(1/8)*Log[b^(1/4) + Sqrt[2]*(-a)^(1/8)*b^(1/8)*x + (-a)^(1/4)*x^2])/(8*Sqrt[2]*(-a)^(9/8))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^8)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection:: *)
(*p<0*)


(* ::Title::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p when n>0 is a fraction*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^(1/2))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b Sqrt[x])^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b*Sqrt[x])*x^4, x, 2, (a*x^5)/5 + (2*b*x^(11/2))/11}
{(a + b*Sqrt[x])*x^3, x, 2, (a*x^4)/4 + (2*b*x^(9/2))/9}
{(a + b*Sqrt[x])*x^2, x, 2, (a*x^3)/3 + (2*b*x^(7/2))/7}
{(a + b*Sqrt[x])*x^1, x, 2, (a*x^2)/2 + (2*b*x^(5/2))/5}
{(a + b*Sqrt[x])*x^0, x, 1, a*x + (2*b*x^(3/2))/3}

{(a + b*Sqrt[x])/x^1, x, 2, 2*b*Sqrt[x] + a*Log[x]}

{(a + b*Sqrt[x])/x^2, x, 2, -(a/x) - (2*b)/Sqrt[x]}
{(a + b*Sqrt[x])/x^3, x, 2, -a/(2*x^2) - (2*b)/(3*x^(3/2))}
{(a + b*Sqrt[x])/x^4, x, 2, -a/(3*x^3) - (2*b)/(5*x^(5/2))}


{(a + b*Sqrt[x])^2*x^4, x, 3, (a^2*x^5)/5 + (4*a*b*x^(11/2))/11 + (b^2*x^6)/6}
{(a + b*Sqrt[x])^2*x^3, x, 3, (a^2*x^4)/4 + (4*a*b*x^(9/2))/9 + (b^2*x^5)/5}
{(a + b*Sqrt[x])^2*x^2, x, 3, (a^2*x^3)/3 + (4*a*b*x^(7/2))/7 + (b^2*x^4)/4}
{(a + b*Sqrt[x])^2*x^1, x, 3, (a^2*x^2)/2 + (4*a*b*x^(5/2))/5 + (b^2*x^3)/3}
{(a + b*Sqrt[x])^2*x^0, x, 3, a^2*x + (4*a*b*x^(3/2))/3 + (b^2*x^2)/2}

{(a + b*Sqrt[x])^2/x^1, x, 3, 4*a*b*Sqrt[x] + b^2*x + a^2*Log[x]}
{(a + b*Sqrt[x])^2/x^2, x, 3, -(a^2/x) - (4*a*b)/Sqrt[x] + b^2*Log[x]}

{(a + b*Sqrt[x])^2/x^3, x, 3, -a^2/(2*x^2) - (4*a*b)/(3*x^(3/2)) - b^2/x}
{(a + b*Sqrt[x])^2/x^4, x, 3, -a^2/(3*x^3) - (4*a*b)/(5*x^(5/2)) - b^2/(2*x^2)}
{(a + b*Sqrt[x])^2/x^5, x, 3, -a^2/(4*x^4) - (4*a*b)/(7*x^(7/2)) - b^2/(3*x^3)}


{(a + b*Sqrt[x])^3*x^4, x, 3, (a^3*x^5)/5 + (6*a^2*b*x^(11/2))/11 + (a*b^2*x^6)/2 + (2*b^3*x^(13/2))/13}
{(a + b*Sqrt[x])^3*x^3, x, 3, (a^3*x^4)/4 + (2*a^2*b*x^(9/2))/3 + (3*a*b^2*x^5)/5 + (2*b^3*x^(11/2))/11}
{(a + b*Sqrt[x])^3*x^2, x, 3, (a^3*x^3)/3 + (6*a^2*b*x^(7/2))/7 + (3*a*b^2*x^4)/4 + (2*b^3*x^(9/2))/9}
{(a + b*Sqrt[x])^3*x^1, x, 3, (a^3*x^2)/2 + (6*a^2*b*x^(5/2))/5 + a*b^2*x^3 + (2*b^3*x^(7/2))/7}
{(a + b*Sqrt[x])^3*x^0, x, 3, -(a*(a + b*Sqrt[x])^4)/(2*b^2) + (2*(a + b*Sqrt[x])^5)/(5*b^2)}

{(a + b*Sqrt[x])^3/x^1, x, 3, 6*a^2*b*Sqrt[x] + 3*a*b^2*x + (2*b^3*x^(3/2))/3 + a^3*Log[x]}
{(a + b*Sqrt[x])^3/x^2, x, 3, -(a^3/x) - (6*a^2*b)/Sqrt[x] + 2*b^3*Sqrt[x] + 3*a*b^2*Log[x]}

{(a + b*Sqrt[x])^3/x^3, x, 1, -(a + b*Sqrt[x])^4/(2*a*x^2)}
{(a + b*Sqrt[x])^3/x^4, x, 3, -a^3/(3*x^3) - (6*a^2*b)/(5*x^(5/2)) - (3*a*b^2)/(2*x^2) - (2*b^3)/(3*x^(3/2))}
{(a + b*Sqrt[x])^3/x^5, x, 3, -a^3/(4*x^4) - (6*a^2*b)/(7*x^(7/2)) - (a*b^2)/x^3 - (2*b^3)/(5*x^(5/2))}
{(a + b*Sqrt[x])^3/x^6, x, 3, -a^3/(5*x^5) - (2*a^2*b)/(3*x^(9/2)) - (3*a*b^2)/(4*x^4) - (2*b^3)/(7*x^(7/2))}


{(a + b*Sqrt[x])^5*x^4, x, 3, (a^5*x^5)/5 + (10*a^4*b*x^(11/2))/11 + (5*a^3*b^2*x^6)/3 + (20*a^2*b^3*x^(13/2))/13 + (5*a*b^4*x^7)/7 + (2*b^5*x^(15/2))/15}
{(a + b*Sqrt[x])^5*x^3, x, 3, (a^5*x^4)/4 + (10*a^4*b*x^(9/2))/9 + 2*a^3*b^2*x^5 + (20*a^2*b^3*x^(11/2))/11 + (5*a*b^4*x^6)/6 + (2*b^5*x^(13/2))/13}
{(a + b*Sqrt[x])^5*x^2, x, 3, (a^5*x^3)/3 + (10*a^4*b*x^(7/2))/7 + (5*a^3*b^2*x^4)/2 + (20*a^2*b^3*x^(9/2))/9 + a*b^4*x^5 + (2*b^5*x^(11/2))/11}
{(a + b*Sqrt[x])^5*x^1, x, 3, -((a^3*(a + b*Sqrt[x])^6)/(3*b^4)) + (6*a^2*(a + b*Sqrt[x])^7)/(7*b^4) - (3*a*(a + b*Sqrt[x])^8)/(4*b^4) + (2*(a + b*Sqrt[x])^9)/(9*b^4)}
{(a + b*Sqrt[x])^5*x^0, x, 3, -(a*(a + b*Sqrt[x])^6)/(3*b^2) + (2*(a + b*Sqrt[x])^7)/(7*b^2)}

{(a + b*Sqrt[x])^5/x^1, x, 3, 10*a^4*b*Sqrt[x] + 10*a^3*b^2*x + (20*a^2*b^3*x^(3/2))/3 + (5*a*b^4*x^2)/2 + (2*b^5*x^(5/2))/5 + a^5*Log[x]}
{(a + b*Sqrt[x])^5/x^2, x, 3, -(a^5/x) - (10*a^4*b)/Sqrt[x] + 20*a^2*b^3*Sqrt[x] + 5*a*b^4*x + (2*b^5*x^(3/2))/3 + 10*a^3*b^2*Log[x]}
{(a + b*Sqrt[x])^5/x^3, x, 3, -a^5/(2*x^2) - (10*a^4*b)/(3*x^(3/2)) - (10*a^3*b^2)/x - (20*a^2*b^3)/Sqrt[x] + 2*b^5*Sqrt[x] + 5*a*b^4*Log[x]}

{(a + b*Sqrt[x])^5/x^4, x, 1, -(a + b*Sqrt[x])^6/(3*a*x^3)}
{(a + b*Sqrt[x])^5/x^5, x, 4, -((a + b*Sqrt[x])^6/(4*a*x^4)) + (b*(a + b*Sqrt[x])^6)/(14*a^2*x^(7/2)) - (b^2*(a + b*Sqrt[x])^6)/(84*a^3*x^3)}

{(a + b*Sqrt[x])^5/x^6, x, 3, -a^5/(5*x^5) - (10*a^4*b)/(9*x^(9/2)) - (5*a^3*b^2)/(2*x^4) - (20*a^2*b^3)/(7*x^(7/2)) - (5*a*b^4)/(3*x^3) - (2*b^5)/(5*x^(5/2))}
{(a + b*Sqrt[x])^5/x^7, x, 3, -a^5/(6*x^6) - (10*a^4*b)/(11*x^(11/2)) - (2*a^3*b^2)/x^5 - (20*a^2*b^3)/(9*x^(9/2)) - (5*a*b^4)/(4*x^4) - (2*b^5)/(7*x^(7/2))}


{(a + b*Sqrt[x])^10*x^4, x, 3, (a^10*x^5)/5 + (20/11)*a^9*b*x^(11/2) + (15/2)*a^8*b^2*x^6 + (240/13)*a^7*b^3*x^(13/2) + 30*a^6*b^4*x^7 + (168/5)*a^5*b^5*x^(15/2) + (105/4)*a^4*b^6*x^8 + (240/17)*a^3*b^7*x^(17/2) + 5*a^2*b^8*x^9 + (20/19)*a*b^9*x^(19/2) + (b^10*x^10)/10}
{(a + b*Sqrt[x])^10*x^3, x, 3, -((2*a^7*(a + b*Sqrt[x])^11)/(11*b^8)) + (7*a^6*(a + b*Sqrt[x])^12)/(6*b^8) - (42*a^5*(a + b*Sqrt[x])^13)/(13*b^8) + (5*a^4*(a + b*Sqrt[x])^14)/b^8 - (14*a^3*(a + b*Sqrt[x])^15)/(3*b^8) + (21*a^2*(a + b*Sqrt[x])^16)/(8*b^8) - (14*a*(a + b*Sqrt[x])^17)/(17*b^8) + (a + b*Sqrt[x])^18/(9*b^8)}
{(a + b*Sqrt[x])^10*x^2, x, 3, (-2*a^5*(a + b*Sqrt[x])^11)/(11*b^6) + (5*a^4*(a + b*Sqrt[x])^12)/(6*b^6) - (20*a^3*(a + b*Sqrt[x])^13)/(13*b^6) + (10*a^2*(a + b*Sqrt[x])^14)/(7*b^6) - (2*a*(a + b*Sqrt[x])^15)/(3*b^6) + (a + b*Sqrt[x])^16/(8*b^6)}
{(a + b*Sqrt[x])^10*x^1, x, 3, (-2*a^3*(a + b*Sqrt[x])^11)/(11*b^4) + (a^2*(a + b*Sqrt[x])^12)/(2*b^4) - (6*a*(a + b*Sqrt[x])^13)/(13*b^4) + (a + b*Sqrt[x])^14/(7*b^4)}
{(a + b*Sqrt[x])^10*x^0, x, 3, (-2*a*(a + b*Sqrt[x])^11)/(11*b^2) + (a + b*Sqrt[x])^12/(6*b^2)}

{(a + b*Sqrt[x])^10/x^1, x, 3, 20*a^9*b*Sqrt[x] + 45*a^8*b^2*x + 80*a^7*b^3*x^(3/2) + 105*a^6*b^4*x^2 + (504*a^5*b^5*x^(5/2))/5 + 70*a^4*b^6*x^3 + (240*a^3*b^7*x^(7/2))/7 + (45*a^2*b^8*x^4)/4 + (20*a*b^9*x^(9/2))/9 + (b^10*x^5)/5 + a^10*Log[x]}
{(a + b*Sqrt[x])^10/x^2, x, 3, -(a^10/x) - (20*a^9*b)/Sqrt[x] + 240*a^7*b^3*Sqrt[x] + 210*a^6*b^4*x + 168*a^5*b^5*x^(3/2) + 105*a^4*b^6*x^2 + 48*a^3*b^7*x^(5/2) + 15*a^2*b^8*x^3 + (20*a*b^9*x^(7/2))/7 + (b^10*x^4)/4 + 45*a^8*b^2*Log[x]}
{(a + b*Sqrt[x])^10/x^3, x, 3, -a^10/(2*x^2) - (20*a^9*b)/(3*x^(3/2)) - (45*a^8*b^2)/x - (240*a^7*b^3)/Sqrt[x] + 504*a^5*b^5*Sqrt[x] + 210*a^4*b^6*x + 80*a^3*b^7*x^(3/2) + (45*a^2*b^8*x^2)/2 + 4*a*b^9*x^(5/2) + (b^10*x^3)/3 + 210*a^6*b^4*Log[x]}
{(a + b*Sqrt[x])^10/x^4, x, 3, -a^10/(3*x^3) - (4*a^9*b)/x^(5/2) - (45*a^8*b^2)/(2*x^2) - (80*a^7*b^3)/x^(3/2) - (210*a^6*b^4)/x - (504*a^5*b^5)/Sqrt[x] + 240*a^3*b^7*Sqrt[x] + 45*a^2*b^8*x + (20*a*b^9*x^(3/2))/3 + (b^10*x^2)/2 + 210*a^4*b^6*Log[x]}
{(a + b*Sqrt[x])^10/x^5, x, 3, -a^10/(4*x^4) - (20*a^9*b)/(7*x^(7/2)) - (15*a^8*b^2)/x^3 - (48*a^7*b^3)/x^(5/2) - (105*a^6*b^4)/x^2 - (168*a^5*b^5)/x^(3/2) - (210*a^4*b^6)/x - (240*a^3*b^7)/Sqrt[x] + 20*a*b^9*Sqrt[x] + b^10*x + 45*a^2*b^8*Log[x]}
{(a + b*Sqrt[x])^10/x^6, x, 3, -a^10/(5*x^5) - (20*a^9*b)/(9*x^(9/2)) - (45*a^8*b^2)/(4*x^4) - (240*a^7*b^3)/(7*x^(7/2)) - (70*a^6*b^4)/x^3 - (504*a^5*b^5)/(5*x^(5/2)) - (105*a^4*b^6)/x^2 - (80*a^3*b^7)/x^(3/2) - (45*a^2*b^8)/x - (20*a*b^9)/Sqrt[x] + b^10*Log[x]}

{(a + b*Sqrt[x])^10/x^7, x, 3, -(a + b*Sqrt[x])^11/(6*a*x^6) + (b*(a + b*Sqrt[x])^11)/(66*a^2*x^(11/2))}
{(a + b*Sqrt[x])^10/x^8, x, 5, -(a + b*Sqrt[x])^11/(7*a*x^7) + (3*b*(a + b*Sqrt[x])^11)/(91*a^2*x^(13/2)) - (b^2*(a + b*Sqrt[x])^11)/(182*a^3*x^6) + (b^3*(a + b*Sqrt[x])^11)/(2002*a^4*x^(11/2))}
{(a + b*Sqrt[x])^10/x^9, x, 7, -(a + b*Sqrt[x])^11/(8*a*x^8) + (b*(a + b*Sqrt[x])^11)/(24*a^2*x^(15/2)) - (b^2*(a + b*Sqrt[x])^11)/(84*a^3*x^7) + (b^3*(a + b*Sqrt[x])^11)/(364*a^4*x^(13/2)) - (b^4*(a + b*Sqrt[x])^11)/(2184*a^5*x^6) + (b^5*(a + b*Sqrt[x])^11)/(24024*a^6*x^(11/2))}

{(a + b*Sqrt[x])^10/x^10, x, 3, -a^10/(9*x^9) - (20*a^9*b)/(17*x^(17/2)) - (45*a^8*b^2)/(8*x^8) - (16*a^7*b^3)/x^(15/2) - (30*a^6*b^4)/x^7 - (504*a^5*b^5)/(13*x^(13/2)) - (35*a^4*b^6)/x^6 - (240*a^3*b^7)/(11*x^(11/2)) - (9*a^2*b^8)/x^5 - (20*a*b^9)/(9*x^(9/2)) - b^10/(4*x^4)}
{(a + b*Sqrt[x])^10/x^11, x, 3, -a^10/(10*x^10) - (20*a^9*b)/(19*x^(19/2)) - (5*a^8*b^2)/x^9 - (240*a^7*b^3)/(17*x^(17/2)) - (105*a^6*b^4)/(4*x^8) - (168*a^5*b^5)/(5*x^(15/2)) - (30*a^4*b^6)/x^7 - (240*a^3*b^7)/(13*x^(13/2)) - (15*a^2*b^8)/(2*x^6) - (20*a*b^9)/(11*x^(11/2)) - b^10/(5*x^5)}


{(a + b*Sqrt[x])^15*x^5, x, 3, -((a^11*(a + b*Sqrt[x])^16)/(8*b^12)) + (22*a^10*(a + b*Sqrt[x])^17)/(17*b^12) - (55*a^9*(a + b*Sqrt[x])^18)/(9*b^12) + (330*a^8*(a + b*Sqrt[x])^19)/(19*b^12) - (33*a^7*(a + b*Sqrt[x])^20)/b^12 + (44*a^6*(a + b*Sqrt[x])^21)/b^12 - (42*a^5*(a + b*Sqrt[x])^22)/b^12 + (660*a^4*(a + b*Sqrt[x])^23)/(23*b^12) - (55*a^3*(a + b*Sqrt[x])^24)/(4*b^12) + (22*a^2*(a + b*Sqrt[x])^25)/(5*b^12) - (11*a*(a + b*Sqrt[x])^26)/(13*b^12) + (2*(a + b*Sqrt[x])^27)/(27*b^12)}
{(a + b*Sqrt[x])^15*x^4, x, 3, -(a^9*(a + b*Sqrt[x])^16)/(8*b^10) + (18*a^8*(a + b*Sqrt[x])^17)/(17*b^10) - (4*a^7*(a + b*Sqrt[x])^18)/b^10 + (168*a^6*(a + b*Sqrt[x])^19)/(19*b^10) - (63*a^5*(a + b*Sqrt[x])^20)/(5*b^10) + (12*a^4*(a + b*Sqrt[x])^21)/b^10 - (84*a^3*(a + b*Sqrt[x])^22)/(11*b^10) + (72*a^2*(a + b*Sqrt[x])^23)/(23*b^10) - (3*a*(a + b*Sqrt[x])^24)/(4*b^10) + (2*(a + b*Sqrt[x])^25)/(25*b^10)}
{(a + b*Sqrt[x])^15*x^3, x, 3, -(a^7*(a + b*Sqrt[x])^16)/(8*b^8) + (14*a^6*(a + b*Sqrt[x])^17)/(17*b^8) - (7*a^5*(a + b*Sqrt[x])^18)/(3*b^8) + (70*a^4*(a + b*Sqrt[x])^19)/(19*b^8) - (7*a^3*(a + b*Sqrt[x])^20)/(2*b^8) + (2*a^2*(a + b*Sqrt[x])^21)/b^8 - (7*a*(a + b*Sqrt[x])^22)/(11*b^8) + (2*(a + b*Sqrt[x])^23)/(23*b^8)}
{(a + b*Sqrt[x])^15*x^2, x, 3, -(a^5*(a + b*Sqrt[x])^16)/(8*b^6) + (10*a^4*(a + b*Sqrt[x])^17)/(17*b^6) - (10*a^3*(a + b*Sqrt[x])^18)/(9*b^6) + (20*a^2*(a + b*Sqrt[x])^19)/(19*b^6) - (a*(a + b*Sqrt[x])^20)/(2*b^6) + (2*(a + b*Sqrt[x])^21)/(21*b^6)}
{(a + b*Sqrt[x])^15*x^1, x, 3, -(a^3*(a + b*Sqrt[x])^16)/(8*b^4) + (6*a^2*(a + b*Sqrt[x])^17)/(17*b^4) - (a*(a + b*Sqrt[x])^18)/(3*b^4) + (2*(a + b*Sqrt[x])^19)/(19*b^4)}
{(a + b*Sqrt[x])^15*x^0, x, 3, -(a*(a + b*Sqrt[x])^16)/(8*b^2) + (2*(a + b*Sqrt[x])^17)/(17*b^2)}

{(a + b*Sqrt[x])^15/x^1, x, 3, 30*a^14*b*Sqrt[x] + 105*a^13*b^2*x + (910*a^12*b^3*x^(3/2))/3 + (1365*a^11*b^4*x^2)/2 + (6006*a^10*b^5*x^(5/2))/5 + (5005*a^9*b^6*x^3)/3 + (12870*a^8*b^7*x^(7/2))/7 + (6435*a^7*b^8*x^4)/4 + (10010*a^6*b^9*x^(9/2))/9 + (3003*a^5*b^10*x^5)/5 + (2730*a^4*b^11*x^(11/2))/11 + (455*a^3*b^12*x^6)/6 + (210*a^2*b^13*x^(13/2))/13 + (15*a*b^14*x^7)/7 + (2*b^15*x^(15/2))/15 + a^15*Log[x]}
{(a + b*Sqrt[x])^15/x^2, x, 3, -(a^15/x) - (30*a^14*b)/Sqrt[x] + 910*a^12*b^3*Sqrt[x] + 1365*a^11*b^4*x + 2002*a^10*b^5*x^(3/2) + (5005*a^9*b^6*x^2)/2 + 2574*a^8*b^7*x^(5/2) + 2145*a^7*b^8*x^3 + 1430*a^6*b^9*x^(7/2) + (3003*a^5*b^10*x^4)/4 + (910*a^4*b^11*x^(9/2))/3 + 91*a^3*b^12*x^5 + (210*a^2*b^13*x^(11/2))/11 + (5*a*b^14*x^6)/2 + (2*b^15*x^(13/2))/13 + 105*a^13*b^2*Log[x]}
{(a + b*Sqrt[x])^15/x^3, x, 3, -a^15/(2*x^2) - (10*a^14*b)/x^(3/2) - (105*a^13*b^2)/x - (910*a^12*b^3)/Sqrt[x] + 6006*a^10*b^5*Sqrt[x] + 5005*a^9*b^6*x + 4290*a^8*b^7*x^(3/2) + (6435*a^7*b^8*x^2)/2 + 2002*a^6*b^9*x^(5/2) + 1001*a^5*b^10*x^3 + 390*a^4*b^11*x^(7/2) + (455*a^3*b^12*x^4)/4 + (70*a^2*b^13*x^(9/2))/3 + 3*a*b^14*x^5 + (2*b^15*x^(11/2))/11 + 1365*a^11*b^4*Log[x]}
{(a + b*Sqrt[x])^15/x^4, x, 3, -a^15/(3*x^3) - (6*a^14*b)/x^(5/2) - (105*a^13*b^2)/(2*x^2) - (910*a^12*b^3)/(3*x^(3/2)) - (1365*a^11*b^4)/x - (6006*a^10*b^5)/Sqrt[x] + 12870*a^8*b^7*Sqrt[x] + 6435*a^7*b^8*x + (10010*a^6*b^9*x^(3/2))/3 + (3003*a^5*b^10*x^2)/2 + 546*a^4*b^11*x^(5/2) + (455*a^3*b^12*x^3)/3 + 30*a^2*b^13*x^(7/2) + (15*a*b^14*x^4)/4 + (2*b^15*x^(9/2))/9 + 5005*a^9*b^6*Log[x]}
{(a + b*Sqrt[x])^15/x^6, x, 3, -a^15/(5*x^5) - (10*a^14*b)/(3*x^(9/2)) - (105*a^13*b^2)/(4*x^4) - (130*a^12*b^3)/x^(7/2) - (455*a^11*b^4)/x^3 - (6006*a^10*b^5)/(5*x^(5/2)) - (5005*a^9*b^6)/(2*x^2) - (4290*a^8*b^7)/x^(3/2) - (6435*a^7*b^8)/x - (10010*a^6*b^9)/Sqrt[x] + 2730*a^4*b^11*Sqrt[x] + 455*a^3*b^12*x + 70*a^2*b^13*x^(3/2) + (15*a*b^14*x^2)/2 + (2*b^15*x^(5/2))/5 + 3003*a^5*b^10*Log[x]}
{(a + b*Sqrt[x])^15/x^7, x, 3, -a^15/(6*x^6) - (30*a^14*b)/(11*x^(11/2)) - (21*a^13*b^2)/x^5 - (910*a^12*b^3)/(9*x^(9/2)) - (1365*a^11*b^4)/(4*x^4) - (858*a^10*b^5)/x^(7/2) - (5005*a^9*b^6)/(3*x^3) - (2574*a^8*b^7)/x^(5/2) - (6435*a^7*b^8)/(2*x^2) - (10010*a^6*b^9)/(3*x^(3/2)) - (3003*a^5*b^10)/x - (2730*a^4*b^11)/Sqrt[x] + 210*a^2*b^13*Sqrt[x] + 15*a*b^14*x + (2*b^15*x^(3/2))/3 + 455*a^3*b^12*Log[x]}
{(a + b*Sqrt[x])^15/x^8, x, 3, -a^15/(7*x^7) - (30*a^14*b)/(13*x^(13/2)) - (35*a^13*b^2)/(2*x^6) - (910*a^12*b^3)/(11*x^(11/2)) - (273*a^11*b^4)/x^5 - (2002*a^10*b^5)/(3*x^(9/2)) - (5005*a^9*b^6)/(4*x^4) - (12870*a^8*b^7)/(7*x^(7/2)) - (2145*a^7*b^8)/x^3 - (2002*a^6*b^9)/x^(5/2) - (3003*a^5*b^10)/(2*x^2) - (910*a^4*b^11)/x^(3/2) - (455*a^3*b^12)/x - (210*a^2*b^13)/Sqrt[x] + 2*b^15*Sqrt[x] + 15*a*b^14*Log[x]}

{(a + b*Sqrt[x])^15/x^9, x, 1, -(a + b*Sqrt[x])^16/(8*a*x^8)}
{(a + b*Sqrt[x])^15/x^10, x, 4, -(a + b*Sqrt[x])^16/(9*a*x^9) + (2*b*(a + b*Sqrt[x])^16)/(153*a^2*x^(17/2)) - (b^2*(a + b*Sqrt[x])^16)/(1224*a^3*x^8)}
{(a + b*Sqrt[x])^15/x^11, x, 6, -(a + b*Sqrt[x])^16/(10*a*x^10) + (2*b*(a + b*Sqrt[x])^16)/(95*a^2*x^(19/2)) - (b^2*(a + b*Sqrt[x])^16)/(285*a^3*x^9) + (2*b^3*(a + b*Sqrt[x])^16)/(4845*a^4*x^(17/2)) - (b^4*(a + b*Sqrt[x])^16)/(38760*a^5*x^8)}
{(a + b*Sqrt[x])^15/x^12, x, 8, -(a + b*Sqrt[x])^16/(11*a*x^11) + (2*b*(a + b*Sqrt[x])^16)/(77*a^2*x^(21/2)) - (b^2*(a + b*Sqrt[x])^16)/(154*a^3*x^10) + (2*b^3*(a + b*Sqrt[x])^16)/(1463*a^4*x^(19/2)) - (b^4*(a + b*Sqrt[x])^16)/(4389*a^5*x^9) + (2*b^5*(a + b*Sqrt[x])^16)/(74613*a^6*x^(17/2)) - (b^6*(a + b*Sqrt[x])^16)/(596904*a^7*x^8)}
{(a + b*Sqrt[x])^15/x^13, x, 10, -(a + b*Sqrt[x])^16/(12*a*x^12) + (2*b*(a + b*Sqrt[x])^16)/(69*a^2*x^(23/2)) - (7*b^2*(a + b*Sqrt[x])^16)/(759*a^3*x^11) + (2*b^3*(a + b*Sqrt[x])^16)/(759*a^4*x^(21/2)) - (b^4*(a + b*Sqrt[x])^16)/(1518*a^5*x^10) + (2*b^5*(a + b*Sqrt[x])^16)/(14421*a^6*x^(19/2)) - (b^6*(a + b*Sqrt[x])^16)/(43263*a^7*x^9) + (2*b^7*(a + b*Sqrt[x])^16)/(735471*a^8*x^(17/2)) - (b^8*(a + b*Sqrt[x])^16)/(5883768*a^9*x^8)}
{(a + b*Sqrt[x])^15/x^14, x, 12, -((a + b*Sqrt[x])^16/(13*a*x^13)) + (2*b*(a + b*Sqrt[x])^16)/(65*a^2*x^(25/2)) - (3*b^2*(a + b*Sqrt[x])^16)/(260*a^3*x^12) + (6*b^3*(a + b*Sqrt[x])^16)/(1495*a^4*x^(23/2)) - (21*b^4*(a + b*Sqrt[x])^16)/(16445*a^5*x^11) + (6*b^5*(a + b*Sqrt[x])^16)/(16445*a^6*x^(21/2)) - (3*b^6*(a + b*Sqrt[x])^16)/(32890*a^7*x^10) + (6*b^7*(a + b*Sqrt[x])^16)/(312455*a^8*x^(19/2)) - (b^8*(a + b*Sqrt[x])^16)/(312455*a^9*x^9) + (2*b^9*(a + b*Sqrt[x])^16)/(5311735*a^10*x^(17/2)) - (b^10*(a + b*Sqrt[x])^16)/(42493880*a^11*x^8)}

{(a + b*Sqrt[x])^15/x^15, x, 3, -a^15/(14*x^14) - (10*a^14*b)/(9*x^(27/2)) - (105*a^13*b^2)/(13*x^13) - (182*a^12*b^3)/(5*x^(25/2)) - (455*a^11*b^4)/(4*x^12) - (6006*a^10*b^5)/(23*x^(23/2)) - (455*a^9*b^6)/x^11 - (4290*a^8*b^7)/(7*x^(21/2)) - (1287*a^7*b^8)/(2*x^10) - (10010*a^6*b^9)/(19*x^(19/2)) - (1001*a^5*b^10)/(3*x^9) - (2730*a^4*b^11)/(17*x^(17/2)) - (455*a^3*b^12)/(8*x^8) - (14*a^2*b^13)/x^(15/2) - (15*a*b^14)/(7*x^7) - (2*b^15)/(13*x^(13/2))}
{(a + b*Sqrt[x])^15/x^16, x, 3, -a^15/(15*x^15) - (30*a^14*b)/(29*x^(29/2)) - (15*a^13*b^2)/(2*x^14) - (910*a^12*b^3)/(27*x^(27/2)) - (105*a^11*b^4)/x^13 - (6006*a^10*b^5)/(25*x^(25/2)) - (5005*a^9*b^6)/(12*x^12) - (12870*a^8*b^7)/(23*x^(23/2)) - (585*a^7*b^8)/x^11 - (1430*a^6*b^9)/(3*x^(21/2)) - (3003*a^5*b^10)/(10*x^10) - (2730*a^4*b^11)/(19*x^(19/2)) - (455*a^3*b^12)/(9*x^9) - (210*a^2*b^13)/(17*x^(17/2)) - (15*a*b^14)/(8*x^8) - (2*b^15)/(15*x^(15/2))}
{(a + b*Sqrt[x])^15/x^17, x, 3, -a^15/(16*x^16) - (30*a^14*b)/(31*x^(31/2)) - (7*a^13*b^2)/x^15 - (910*a^12*b^3)/(29*x^(29/2)) - (195*a^11*b^4)/(2*x^14) - (2002*a^10*b^5)/(9*x^(27/2)) - (385*a^9*b^6)/x^13 - (2574*a^8*b^7)/(5*x^(25/2)) - (2145*a^7*b^8)/(4*x^12) - (10010*a^6*b^9)/(23*x^(23/2)) - (273*a^5*b^10)/x^11 - (130*a^4*b^11)/x^(21/2) - (91*a^3*b^12)/(2*x^10) - (210*a^2*b^13)/(19*x^(19/2)) - (5*a*b^14)/(3*x^9) - (2*b^15)/(17*x^(17/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^3/(a + b*Sqrt[x]), x, 3, (2*a^6*Sqrt[x])/b^7 - (a^5*x)/b^6 + (2*a^4*x^(3/2))/(3*b^5) - (a^3*x^2)/(2*b^4) + (2*a^2*x^(5/2))/(5*b^3) - (a*x^3)/(3*b^2) + (2*x^(7/2))/(7*b) - (2*a^7*Log[a + b*Sqrt[x]])/b^8}
{x^2/(a + b*Sqrt[x]), x, 3, (2*a^4*Sqrt[x])/b^5 - (a^3*x)/b^4 + (2*a^2*x^(3/2))/(3*b^3) - (a*x^2)/(2*b^2) + (2*x^(5/2))/(5*b) - (2*a^5*Log[a + b*Sqrt[x]])/b^6}
{x^1/(a + b*Sqrt[x]), x, 3, (2*a^2*Sqrt[x])/b^3 - (a*x)/b^2 + (2*x^(3/2))/(3*b) - (2*a^3*Log[a + b*Sqrt[x]])/b^4}
{x^0/(a + b*Sqrt[x]), x, 3, (2*Sqrt[x])/b - (2*a*Log[a + b*Sqrt[x]])/b^2}
{1/(x^1*(a + b*Sqrt[x])), x, 4, (-2*Log[a + b*Sqrt[x]])/a + Log[x]/a}
{1/(x^2*(a + b*Sqrt[x])), x, 3, -(1/(a*x)) + (2*b)/(a^2*Sqrt[x]) - (2*b^2*Log[a + b*Sqrt[x]])/a^3 + (b^2*Log[x])/a^3}
{1/(x^3*(a + b*Sqrt[x])), x, 3, -1/(2*a*x^2) + (2*b)/(3*a^2*x^(3/2)) - b^2/(a^3*x) + (2*b^3)/(a^4*Sqrt[x]) - (2*b^4*Log[a + b*Sqrt[x]])/a^5 + (b^4*Log[x])/a^5}
{1/(x^4*(a + b*Sqrt[x])), x, 3, -1/(3*a*x^3) + (2*b)/(5*a^2*x^(5/2)) - b^2/(2*a^3*x^2) + (2*b^3)/(3*a^4*x^(3/2)) - b^4/(a^5*x) + (2*b^5)/(a^6*Sqrt[x]) - (2*b^6*Log[a + b*Sqrt[x]])/a^7 + (b^6*Log[x])/a^7}


{x^3/(a + b*Sqrt[x])^2, x, 3, (2*a^7)/(b^8*(a + b*Sqrt[x])) - (12*a^5*Sqrt[x])/b^7 + (5*a^4*x)/b^6 - (8*a^3*x^(3/2))/(3*b^5) + (3*a^2*x^2)/(2*b^4) - (4*a*x^(5/2))/(5*b^3) + x^3/(3*b^2) + (14*a^6*Log[a + b*Sqrt[x]])/b^8}
{x^2/(a + b*Sqrt[x])^2, x, 3, (2*a^5)/(b^6*(a + b*Sqrt[x])) - (8*a^3*Sqrt[x])/b^5 + (3*a^2*x)/b^4 - (4*a*x^(3/2))/(3*b^3) + x^2/(2*b^2) + (10*a^4*Log[a + b*Sqrt[x]])/b^6}
{x^1/(a + b*Sqrt[x])^2, x, 3, (2*a^3)/(b^4*(a + b*Sqrt[x])) - (4*a*Sqrt[x])/b^3 + x/b^2 + (6*a^2*Log[a + b*Sqrt[x]])/b^4}
{x^0/(a + b*Sqrt[x])^2, x, 3, (2*a)/(b^2*(a + b*Sqrt[x])) + (2*Log[a + b*Sqrt[x]])/b^2}
{1/(x^1*(a + b*Sqrt[x])^2), x, 3, 2/(a*(a + b*Sqrt[x])) - (2*Log[a + b*Sqrt[x]])/a^2 + Log[x]/a^2}
{1/(x^2*(a + b*Sqrt[x])^2), x, 3, (2*b^2)/(a^3*(a + b*Sqrt[x])) - 1/(a^2*x) + (4*b)/(a^3*Sqrt[x]) - (6*b^2*Log[a + b*Sqrt[x]])/a^4 + (3*b^2*Log[x])/a^4}
{1/(x^3*(a + b*Sqrt[x])^2), x, 3, (2*b^4)/(a^5*(a + b*Sqrt[x])) - 1/(2*a^2*x^2) + (4*b)/(3*a^3*x^(3/2)) - (3*b^2)/(a^4*x) + (8*b^3)/(a^5*Sqrt[x]) - (10*b^4*Log[a + b*Sqrt[x]])/a^6 + (5*b^4*Log[x])/a^6}
{1/(x^4*(a + b*Sqrt[x])^2), x, 3, (2*b^6)/(a^7*(a + b*Sqrt[x])) - 1/(3*a^2*x^3) + (4*b)/(5*a^3*x^(5/2)) - (3*b^2)/(2*a^4*x^2) + (8*b^3)/(3*a^5*x^(3/2)) - (5*b^4)/(a^6*x) + (12*b^5)/(a^7*Sqrt[x]) - (14*b^6*Log[a + b*Sqrt[x]])/a^8 + (7*b^6*Log[x])/a^8}


{x^3/(a + b*Sqrt[x])^3, x, 3, a^7/(b^8*(a + b*Sqrt[x])^2) - (14*a^6)/(b^8*(a + b*Sqrt[x])) + (30*a^4*Sqrt[x])/b^7 - (10*a^3*x)/b^6 + (4*a^2*x^(3/2))/b^5 - (3*a*x^2)/(2*b^4) + (2*x^(5/2))/(5*b^3) - (42*a^5*Log[a + b*Sqrt[x]])/b^8}
{x^2/(a + b*Sqrt[x])^3, x, 3, a^5/(b^6*(a + b*Sqrt[x])^2) - (10*a^4)/(b^6*(a + b*Sqrt[x])) + (12*a^2*Sqrt[x])/b^5 - (3*a*x)/b^4 + (2*x^(3/2))/(3*b^3) - (20*a^3*Log[a + b*Sqrt[x]])/b^6}
{x^1/(a + b*Sqrt[x])^3, x, 3, a^3/(b^4*(a + b*Sqrt[x])^2) - (6*a^2)/(b^4*(a + b*Sqrt[x])) + (2*Sqrt[x])/b^3 - (6*a*Log[a + b*Sqrt[x]])/b^4}
{x^0/(a + b*Sqrt[x])^3, x, 2, x/(a*(a + b*Sqrt[x])^2)}
{1/(x^1*(a + b*Sqrt[x])^3), x, 3, 1/(a*(a + b*Sqrt[x])^2) + 2/(a^2*(a + b*Sqrt[x])) - (2*Log[a + b*Sqrt[x]])/a^3 + Log[x]/a^3}
{1/(x^2*(a + b*Sqrt[x])^3), x, 3, b^2/(a^3*(a + b*Sqrt[x])^2) + (6*b^2)/(a^4*(a + b*Sqrt[x])) - 1/(a^3*x) + (6*b)/(a^4*Sqrt[x]) - (12*b^2*Log[a + b*Sqrt[x]])/a^5 + (6*b^2*Log[x])/a^5}
{1/(x^3*(a + b*Sqrt[x])^3), x, 3, b^4/(a^5*(a + b*Sqrt[x])^2) + (10*b^4)/(a^6*(a + b*Sqrt[x])) - 1/(2*a^3*x^2) + (2*b)/(a^4*x^(3/2)) - (6*b^2)/(a^5*x) + (20*b^3)/(a^6*Sqrt[x]) - (30*b^4*Log[a + b*Sqrt[x]])/a^7 + (15*b^4*Log[x])/a^7}
{1/(x^4*(a + b*Sqrt[x])^3), x, 3, b^6/(a^7*(a + b*Sqrt[x])^2) + (14*b^6)/(a^8*(a + b*Sqrt[x])) - 1/(3*a^3*x^3) + (6*b)/(5*a^4*x^(5/2)) - (3*b^2)/(a^5*x^2) + (20*b^3)/(3*a^6*x^(3/2)) - (15*b^4)/(a^7*x) + (42*b^5)/(a^8*Sqrt[x]) - (56*b^6*Log[a + b*Sqrt[x]])/a^9 + (28*b^6*Log[x])/a^9}


{x^4/(a + b*Sqrt[x])^5, x, 3, a^9/(2*b^10*(a + b*Sqrt[x])^4) - (6*a^8)/(b^10*(a + b*Sqrt[x])^3) + (36*a^7)/(b^10*(a + b*Sqrt[x])^2) - (168*a^6)/(b^10*(a + b*Sqrt[x])) + (140*a^4*Sqrt[x])/b^9 - (35*a^3*x)/b^8 + (10*a^2*x^(3/2))/b^7 - (5*a*x^2)/(2*b^6) + (2*x^(5/2))/(5*b^5) - (252*a^5*Log[a + b*Sqrt[x]])/b^10}
{x^3/(a + b*Sqrt[x])^5, x, 3, a^7/(2*b^8*(a + b*Sqrt[x])^4) - (14*a^6)/(3*b^8*(a + b*Sqrt[x])^3) + (21*a^5)/(b^8*(a + b*Sqrt[x])^2) - (70*a^4)/(b^8*(a + b*Sqrt[x])) + (30*a^2*Sqrt[x])/b^7 - (5*a*x)/b^6 + (2*x^(3/2))/(3*b^5) - (70*a^3*Log[a + b*Sqrt[x]])/b^8}
{x^2/(a + b*Sqrt[x])^5, x, 3, a^5/(2*b^6*(a + b*Sqrt[x])^4) - (10*a^4)/(3*b^6*(a + b*Sqrt[x])^3) + (10*a^3)/(b^6*(a + b*Sqrt[x])^2) - (20*a^2)/(b^6*(a + b*Sqrt[x])) + (2*Sqrt[x])/b^5 - (10*a*Log[a + b*Sqrt[x]])/b^6}
{x^1/(a + b*Sqrt[x])^5, x, 1, x^2/(2*a*(a + b*Sqrt[x])^4)}
{x^0/(a + b*Sqrt[x])^5, x, 3, a/(2*b^2*(a + b*Sqrt[x])^4) - 2/(3*b^2*(a + b*Sqrt[x])^3)}
{1/(x^1*(a + b*Sqrt[x])^5), x, 3, 1/(2*a*(a + b*Sqrt[x])^4) + 2/(3*a^2*(a + b*Sqrt[x])^3) + 1/(a^3*(a + b*Sqrt[x])^2) + 2/(a^4*(a + b*Sqrt[x])) - (2*Log[a + b*Sqrt[x]])/a^5 + Log[x]/a^5}
{1/(x^2*(a + b*Sqrt[x])^5), x, 3, b^2/(2*a^3*(a + b*Sqrt[x])^4) + (2*b^2)/(a^4*(a + b*Sqrt[x])^3) + (6*b^2)/(a^5*(a + b*Sqrt[x])^2) + (20*b^2)/(a^6*(a + b*Sqrt[x])) - 1/(a^5*x) + (10*b)/(a^6*Sqrt[x]) - (30*b^2*Log[a + b*Sqrt[x]])/a^7 + (15*b^2*Log[x])/a^7}
{1/(x^3*(a + b*Sqrt[x])^5), x, 3, b^4/(2*a^5*(a + b*Sqrt[x])^4) + (10*b^4)/(3*a^6*(a + b*Sqrt[x])^3) + (15*b^4)/(a^7*(a + b*Sqrt[x])^2) + (70*b^4)/(a^8*(a + b*Sqrt[x])) - 1/(2*a^5*x^2) + (10*b)/(3*a^6*x^(3/2)) - (15*b^2)/(a^7*x) + (70*b^3)/(a^8*Sqrt[x]) - (140*b^4*Log[a + b*Sqrt[x]])/a^9 + (70*b^4*Log[x])/a^9}


{x^5/(a + b*Sqrt[x])^8, x, 3, (2*a^11)/(7*b^12*(a + b*Sqrt[x])^7) - (11*a^10)/(3*b^12*(a + b*Sqrt[x])^6) + (22*a^9)/(b^12*(a + b*Sqrt[x])^5) - (165*a^8)/(2*b^12*(a + b*Sqrt[x])^4) + (220*a^7)/(b^12*(a + b*Sqrt[x])^3) - (462*a^6)/(b^12*(a + b*Sqrt[x])^2) + (924*a^5)/(b^12*(a + b*Sqrt[x])) - (240*a^3*Sqrt[x])/b^11 + (36*a^2*x)/b^10 - (16*a*x^(3/2))/(3*b^9) + x^2/(2*b^8) + (660*a^4*Log[a + b*Sqrt[x]])/b^12}
{x^4/(a + b*Sqrt[x])^8, x, 3, (2*a^9)/(7*b^10*(a + b*Sqrt[x])^7) - (3*a^8)/(b^10*(a + b*Sqrt[x])^6) + (72*a^7)/(5*b^10*(a + b*Sqrt[x])^5) - (42*a^6)/(b^10*(a + b*Sqrt[x])^4) + (84*a^5)/(b^10*(a + b*Sqrt[x])^3) - (126*a^4)/(b^10*(a + b*Sqrt[x])^2) + (168*a^3)/(b^10*(a + b*Sqrt[x])) - (16*a*Sqrt[x])/b^9 + x/b^8 + (72*a^2*Log[a + b*Sqrt[x]])/b^10}
{x^3/(a + b*Sqrt[x])^8, x, 3, (2*a^7)/(7*b^8*(a + b*Sqrt[x])^7) - (7*a^6)/(3*b^8*(a + b*Sqrt[x])^6) + (42*a^5)/(5*b^8*(a + b*Sqrt[x])^5) - (35*a^4)/(2*b^8*(a + b*Sqrt[x])^4) + (70*a^3)/(3*b^8*(a + b*Sqrt[x])^3) - (21*a^2)/(b^8*(a + b*Sqrt[x])^2) + (14*a)/(b^8*(a + b*Sqrt[x])) + (2*Log[a + b*Sqrt[x]])/b^8}
{x^2/(a + b*Sqrt[x])^8, x, 3, (2*x^3)/(7*a*(a + b*Sqrt[x])^7) + x^3/(21*a^2*(a + b*Sqrt[x])^6)}
{x^1/(a + b*Sqrt[x])^8, x, 3, (2*a^3)/(7*b^4*(a + b*Sqrt[x])^7) - a^2/(b^4*(a + b*Sqrt[x])^6) + (6*a)/(5*b^4*(a + b*Sqrt[x])^5) - 1/(2*b^4*(a + b*Sqrt[x])^4)}
{x^0/(a + b*Sqrt[x])^8, x, 3, (2*a)/(7*b^2*(a + b*Sqrt[x])^7) - 1/(3*b^2*(a + b*Sqrt[x])^6)}
{1/(x^1*(a + b*Sqrt[x])^8), x, 3, 2/(7*a*(a + b*Sqrt[x])^7) + 1/(3*a^2*(a + b*Sqrt[x])^6) + 2/(5*a^3*(a + b*Sqrt[x])^5) + 1/(2*a^4*(a + b*Sqrt[x])^4) + 2/(3*a^5*(a + b*Sqrt[x])^3) + 1/(a^6*(a + b*Sqrt[x])^2) + 2/(a^7*(a + b*Sqrt[x])) - (2*Log[a + b*Sqrt[x]])/a^8 + Log[x]/a^8}
{1/(x^2*(a + b*Sqrt[x])^8), x, 3, (2*b^2)/(7*a^3*(a + b*Sqrt[x])^7) + b^2/(a^4*(a + b*Sqrt[x])^6) + (12*b^2)/(5*a^5*(a + b*Sqrt[x])^5) + (5*b^2)/(a^6*(a + b*Sqrt[x])^4) + (10*b^2)/(a^7*(a + b*Sqrt[x])^3) + (21*b^2)/(a^8*(a + b*Sqrt[x])^2) + (56*b^2)/(a^9*(a + b*Sqrt[x])) - 1/(a^8*x) + (16*b)/(a^9*Sqrt[x]) - (72*b^2*Log[a + b*Sqrt[x]])/a^10 + (36*b^2*Log[x])/a^10}
{1/(x^3*(a + b*Sqrt[x])^8), x, 3, (2*b^4)/(7*a^5*(a + b*Sqrt[x])^7) + (5*b^4)/(3*a^6*(a + b*Sqrt[x])^6) + (6*b^4)/(a^7*(a + b*Sqrt[x])^5) + (35*b^4)/(2*a^8*(a + b*Sqrt[x])^4) + (140*b^4)/(3*a^9*(a + b*Sqrt[x])^3) + (126*b^4)/(a^10*(a + b*Sqrt[x])^2) + (420*b^4)/(a^11*(a + b*Sqrt[x])) - 1/(2*a^8*x^2) + (16*b)/(3*a^9*x^(3/2)) - (36*b^2)/(a^10*x) + (240*b^3)/(a^11*Sqrt[x]) - (660*b^4*Log[a + b*Sqrt[x]])/a^12 + (330*b^4*Log[x])/a^12}


{1/(x*(2 + b*Sqrt[x])), x, 4, -Log[2 + b*Sqrt[x]] + Log[x]/2}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b Sqrt[x])^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^2*Sqrt[a + b*Sqrt[x]], x, 3, -((4*a^5*(a + b*Sqrt[x])^(3/2))/(3*b^6)) + (4*a^4*(a + b*Sqrt[x])^(5/2))/b^6 - (40*a^3*(a + b*Sqrt[x])^(7/2))/(7*b^6) + (40*a^2*(a + b*Sqrt[x])^(9/2))/(9*b^6) - (20*a*(a + b*Sqrt[x])^(11/2))/(11*b^6) + (4*(a + b*Sqrt[x])^(13/2))/(13*b^6)}
{x^1*Sqrt[a + b*Sqrt[x]], x, 3, -((4*a^3*(a + b*Sqrt[x])^(3/2))/(3*b^4)) + (12*a^2*(a + b*Sqrt[x])^(5/2))/(5*b^4) - (12*a*(a + b*Sqrt[x])^(7/2))/(7*b^4) + (4*(a + b*Sqrt[x])^(9/2))/(9*b^4)}
{x^0*Sqrt[a + b*Sqrt[x]], x, 3, -((4*a*(a + b*Sqrt[x])^(3/2))/(3*b^2)) + (4*(a + b*Sqrt[x])^(5/2))/(5*b^2)}
{1/x^1*Sqrt[a + b*Sqrt[x]], x, 4, 4*Sqrt[a + b*Sqrt[x]] - 4*Sqrt[a]*ArcTanh[Sqrt[a + b*Sqrt[x]]/Sqrt[a]]}
{1/x^2*Sqrt[a + b*Sqrt[x]], x, 5, -(Sqrt[a + b*Sqrt[x]]/x) - (b*Sqrt[a + b*Sqrt[x]])/(2*a*Sqrt[x]) + (b^2*ArcTanh[Sqrt[a + b*Sqrt[x]]/Sqrt[a]])/(2*a^(3/2))}
{1/x^3*Sqrt[a + b*Sqrt[x]], x, 7, -(Sqrt[a + b*Sqrt[x]]/(2*x^2)) - (b*Sqrt[a + b*Sqrt[x]])/(12*a*x^(3/2)) + (5*b^2*Sqrt[a + b*Sqrt[x]])/(48*a^2*x) - (5*b^3*Sqrt[a + b*Sqrt[x]])/(32*a^3*Sqrt[x]) + (5*b^4*ArcTanh[Sqrt[a + b*Sqrt[x]]/Sqrt[a]])/(32*a^(7/2))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^2/Sqrt[a + b*Sqrt[x]], x, 3, -((4*a^5*Sqrt[a + b*Sqrt[x]])/b^6) + (20*a^4*(a + b*Sqrt[x])^(3/2))/(3*b^6) - (8*a^3*(a + b*Sqrt[x])^(5/2))/b^6 + (40*a^2*(a + b*Sqrt[x])^(7/2))/(7*b^6) - (20*a*(a + b*Sqrt[x])^(9/2))/(9*b^6) + (4*(a + b*Sqrt[x])^(11/2))/(11*b^6)}
{x^1/Sqrt[a + b*Sqrt[x]], x, 3, -((4*a^3*Sqrt[a + b*Sqrt[x]])/b^4) + (4*a^2*(a + b*Sqrt[x])^(3/2))/b^4 - (12*a*(a + b*Sqrt[x])^(5/2))/(5*b^4) + (4*(a + b*Sqrt[x])^(7/2))/(7*b^4)}
{x^0/Sqrt[a + b*Sqrt[x]], x, 3, -((4*a*Sqrt[a + b*Sqrt[x]])/b^2) + (4*(a + b*Sqrt[x])^(3/2))/(3*b^2)}
{1/(x^1*Sqrt[a + b*Sqrt[x]]), x, 3, -((4*ArcTanh[Sqrt[a + b*Sqrt[x]]/Sqrt[a]])/Sqrt[a])}
{1/(x^2*Sqrt[a + b*Sqrt[x]]), x, 5, -(Sqrt[a + b*Sqrt[x]]/(a*x)) + (3*b*Sqrt[a + b*Sqrt[x]])/(2*a^2*Sqrt[x]) - (3*b^2*ArcTanh[Sqrt[a + b*Sqrt[x]]/Sqrt[a]])/(2*a^(5/2))}
{1/(x^3*Sqrt[a + b*Sqrt[x]]), x, 7, -(Sqrt[a + b*Sqrt[x]]/(2*a*x^2)) + (7*b*Sqrt[a + b*Sqrt[x]])/(12*a^2*x^(3/2)) - (35*b^2*Sqrt[a + b*Sqrt[x]])/(48*a^3*x) + (35*b^3*Sqrt[a + b*Sqrt[x]])/(32*a^4*Sqrt[x]) - (35*b^4*ArcTanh[Sqrt[a + b*Sqrt[x]]/Sqrt[a]])/(32*a^(9/2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b Sqrt[x])^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b*Sqrt[x])^n*Sqrt[x], x, 3, (2*a^2*(a + b*Sqrt[x])^(1 + n))/(b^3*(1 + n)) - (4*a*(a + b*Sqrt[x])^(2 + n))/(b^3*(2 + n)) + (2*(a + b*Sqrt[x])^(3 + n))/(b^3*(3 + n))}
{(a + b*Sqrt[x])^n/Sqrt[x], x, 1, (2*(a + b*Sqrt[x])^(1 + n))/(b*(1 + n))}

{(1 + Sqrt[x])/Sqrt[x], x, 2, 2*Sqrt[x] + x}
{(1 + Sqrt[x])^2/Sqrt[x], x, 1, (2*(1 + Sqrt[x])^3)/3}
{(1 + Sqrt[x])^3/Sqrt[x], x, 1, (1 + Sqrt[x])^4/2}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{Sqrt[x]/(1 + Sqrt[x]), x, 3, -2*Sqrt[x] + x + 2*Log[1 + Sqrt[x]]}
{1/((1 + Sqrt[x])*Sqrt[x]), x, 1, 2*Log[1 + Sqrt[x]]}


{1/((1 + Sqrt[x])^2*Sqrt[x]), x, 1, -2/(1 + Sqrt[x])}


{1/((1 + Sqrt[x])^3*Sqrt[x]), x, 1, -(1 + Sqrt[x])^(-2)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b Sqrt[x])^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{Sqrt[1 + Sqrt[x]]*Sqrt[x], x, 3, (4/3)*(1 + Sqrt[x])^(3/2) - (8/5)*(1 + Sqrt[x])^(5/2) + (4/7)*(1 + Sqrt[x])^(7/2)}
{Sqrt[1 + Sqrt[x]]/Sqrt[x], x, 1, (4*(1 + Sqrt[x])^(3/2))/3}


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b Sqrt[x])^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(1/3)/(1 + Sqrt[x]), x, 7, -3*x^(1/3) + (6*x^(5/6))/5 - 2*Sqrt[3]*ArcTan[(1 - 2*x^(1/6))/Sqrt[3]] - 3*Log[1 + x^(1/6)] + Log[1 + Sqrt[x]]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b Sqrt[x])^p with m symbolic*)


{x^m*(a + b*Sqrt[x])^4, x, 2, (a^4*x^(1 + m))/(1 + m) + (8*a^3*b*x^(3/2 + m))/(3 + 2*m) + (6*a^2*b^2*x^(2 + m))/(2 + m) + (8*a*b^3*x^(5/2 + m))/(5 + 2*m) + (b^4*x^(3 + m))/(3 + m)}
{x^m*(a + b*Sqrt[x])^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (6*a^2*b*x^(3/2 + m))/(3 + 2*m) + (3*a*b^2*x^(2 + m))/(2 + m) + (2*b^3*x^(5/2 + m))/(5 + 2*m)}
{x^m*(a + b*Sqrt[x])^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (4*a*b*x^(3/2 + m))/(3 + 2*m) + (b^2*x^(2 + m))/(2 + m)}
{x^m*(a + b*Sqrt[x])^1, x, 2, (a*x^(1 + m))/(1 + m) + (2*b*x^(3/2 + m))/(3 + 2*m)}
{x^m/(a + b*Sqrt[x])^1, x, 2, (x^(1 + m)*Hypergeometric2F1[1, 2*(1 + m), 3 + 2*m, -((b*Sqrt[x])/a)])/(a*(1 + m))}
{x^m/(a + b*Sqrt[x])^2, x, 2, (x^(1 + m)*Hypergeometric2F1[2, 2*(1 + m), 3 + 2*m, -((b*Sqrt[x])/a)])/(a^2*(1 + m))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b Sqrt[x])^p with p symbolic*)


{x^m*(a + b*Sqrt[x])^p, x, 3, -((2*(a + b*Sqrt[x])^(1 + p)*x^(1 + m)*Hypergeometric2F1[1, 3 + 2*m + p, 2 + p, (a + b*Sqrt[x])/a])/(a*(1 + p))), ((a + b*Sqrt[x])^p*x^(1 + m)*Hypergeometric2F1[2*(1 + m), -p, 3 + 2*m, -((b*Sqrt[x])/a)])/((1 + b*Sqrt[x]/a)^p*(1 + m))}


{x^3*(a + b*Sqrt[x])^p, x, 3, -((2*a^7*(a + b*Sqrt[x])^(1 + p))/(b^8*(1 + p))) + (14*a^6*(a + b*Sqrt[x])^(2 + p))/(b^8*(2 + p)) - (42*a^5*(a + b*Sqrt[x])^(3 + p))/(b^8*(3 + p)) + (70*a^4*(a + b*Sqrt[x])^(4 + p))/(b^8*(4 + p)) - (70*a^3*(a + b*Sqrt[x])^(5 + p))/(b^8*(5 + p)) + (42*a^2*(a + b*Sqrt[x])^(6 + p))/(b^8*(6 + p)) - (14*a*(a + b*Sqrt[x])^(7 + p))/(b^8*(7 + p)) + (2*(a + b*Sqrt[x])^(8 + p))/(b^8*(8 + p))}
{x^2*(a + b*Sqrt[x])^p, x, 3, -((2*a^5*(a + b*Sqrt[x])^(1 + p))/(b^6*(1 + p))) + (10*a^4*(a + b*Sqrt[x])^(2 + p))/(b^6*(2 + p)) - (20*a^3*(a + b*Sqrt[x])^(3 + p))/(b^6*(3 + p)) + (20*a^2*(a + b*Sqrt[x])^(4 + p))/(b^6*(4 + p)) - (10*a*(a + b*Sqrt[x])^(5 + p))/(b^6*(5 + p)) + (2*(a + b*Sqrt[x])^(6 + p))/(b^6*(6 + p))}
{x^1*(a + b*Sqrt[x])^p, x, 3, -((2*a^3*(a + b*Sqrt[x])^(1 + p))/(b^4*(1 + p))) + (6*a^2*(a + b*Sqrt[x])^(2 + p))/(b^4*(2 + p)) - (6*a*(a + b*Sqrt[x])^(3 + p))/(b^4*(3 + p)) + (2*(a + b*Sqrt[x])^(4 + p))/(b^4*(4 + p))}
{x^0*(a + b*Sqrt[x])^p, x, 3, -((2*a*(a + b*Sqrt[x])^(1 + p))/(b^2*(1 + p))) + (2*(a + b*Sqrt[x])^(2 + p))/(b^2*(2 + p))}
{(a + b*Sqrt[x])^p/x^1, x, 2, -((2*(a + b*Sqrt[x])^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*Sqrt[x])/a])/(a*(1 + p)))}
{(a + b*Sqrt[x])^p/x^2, x, 2, -((2*b^2*(a + b*Sqrt[x])^(1 + p)*Hypergeometric2F1[3, 1 + p, 2 + p, 1 + (b*Sqrt[x])/a])/(a^3*(1 + p)))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^(3/2))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^(3/2))^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{Sqrt[x]/(1 + x^(3/2)), x, 1, (2*Log[1 + x^(3/2)])/3}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^(3/2))^(p/3)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^3/(a + b*x^(3/2))^(2/3), x, 4, -((5*a*x*(a + b*x^(3/2))^(1/3))/(9*b^2)) + (x^(5/2)*(a + b*x^(3/2))^(1/3))/(3*b) - (10*a^2*ArcTan[(1 + (2*b^(1/3)*Sqrt[x])/(a + b*x^(3/2))^(1/3))/Sqrt[3]])/(9*Sqrt[3]*b^(8/3)) - (5*a^2*Log[b^(1/3)*Sqrt[x] - (a + b*x^(3/2))^(1/3)])/(9*b^(8/3))}
{x^0/(a + b*x^(3/2))^(2/3), x, 2, -((2*ArcTan[(1 + (2*b^(1/3)*Sqrt[x])/(a + b*x^(3/2))^(1/3))/Sqrt[3]])/(Sqrt[3]*b^(2/3))) - Log[b^(1/3)*Sqrt[x] - (a + b*x^(3/2))^(1/3)]/b^(2/3)}
{1/(x^3*(a + b*x^(3/2))^(2/3)), x, 2, -((a + b*x^(3/2))^(1/3)/(2*a*x^2)) + (3*b*(a + b*x^(3/2))^(1/3))/(2*a^2*Sqrt[x])}
{1/(x^6*(a + b*x^(3/2))^(2/3)), x, 4, -((a + b*x^(3/2))^(1/3)/(5*a*x^5)) + (9*b*(a + b*x^(3/2))^(1/3))/(35*a^2*x^(7/2)) - (27*b^2*(a + b*x^(3/2))^(1/3))/(70*a^3*x^2) + (81*b^3*(a + b*x^(3/2))^(1/3))/(70*a^4*Sqrt[x])}
{1/(x^9*(a + b*x^(3/2))^(2/3)), x, 6, -((a + b*x^(3/2))^(1/3)/(8*a*x^8)) + (15*b*(a + b*x^(3/2))^(1/3))/(104*a^2*x^(13/2)) - (9*b^2*(a + b*x^(3/2))^(1/3))/(52*a^3*x^5) + (81*b^3*(a + b*x^(3/2))^(1/3))/(364*a^4*x^(7/2)) - (243*b^4*(a + b*x^(3/2))^(1/3))/(728*a^5*x^2) + (729*b^5*(a + b*x^(3/2))^(1/3))/(728*a^6*Sqrt[x])}

{x^8/(a + b*x^(3/2))^(2/3), x, 3, -((2*a^5*(a + b*x^(3/2))^(1/3))/b^6) + (5*a^4*(a + b*x^(3/2))^(4/3))/(2*b^6) - (20*a^3*(a + b*x^(3/2))^(7/3))/(7*b^6) + (2*a^2*(a + b*x^(3/2))^(10/3))/b^6 - (10*a*(a + b*x^(3/2))^(13/3))/(13*b^6) + (a + b*x^(3/2))^(16/3)/(8*b^6)}
{x^5/(a + b*x^(3/2))^(2/3), x, 3, -((2*a^3*(a + b*x^(3/2))^(1/3))/b^4) + (3*a^2*(a + b*x^(3/2))^(4/3))/(2*b^4) - (6*a*(a + b*x^(3/2))^(7/3))/(7*b^4) + (a + b*x^(3/2))^(10/3)/(5*b^4)}
{x^2/(a + b*x^(3/2))^(2/3), x, 3, -((2*a*(a + b*x^(3/2))^(1/3))/b^2) + (a + b*x^(3/2))^(4/3)/(2*b^2)}
{1/(x^1*(a + b*x^(3/2))^(2/3)), x, 5, -((2*ArcTan[(a^(1/3) + 2*(a + b*x^(3/2))^(1/3))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(2/3))) - Log[x]/(2*a^(2/3)) + Log[a^(1/3) - (a + b*x^(3/2))^(1/3)]/a^(2/3)}
{1/(x^4*(a + b*x^(3/2))^(2/3)), x, 7, -((a + b*x^(3/2))^(1/3)/(3*a*x^3)) + (5*b*(a + b*x^(3/2))^(1/3))/(9*a^2*x^(3/2)) - (10*b^2*ArcTan[(a^(1/3) + 2*(a + b*x^(3/2))^(1/3))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(8/3)) - (5*b^2*Log[x])/(18*a^(8/3)) + (5*b^2*Log[a^(1/3) - (a + b*x^(3/2))^(1/3)])/(9*a^(8/3))}

{x^4/(a + b*x^(3/2))^(2/3), x, 3, (x^5*(a + b*x^(3/2))^(1/3)*Hypergeometric2F1[1, 11/3, 13/3, -((b*x^(3/2))/a)])/(5*a), (x^5*(1 + (b*x^(3/2))/a)^(2/3)*Hypergeometric2F1[2/3, 10/3, 13/3, -((b*x^(3/2))/a)])/(5*(a + b*x^(3/2))^(2/3))}
{x^1/(a + b*x^(3/2))^(2/3), x, 3, (x^2*(a + b*x^(3/2))^(1/3)*Hypergeometric2F1[1, 5/3, 7/3, -((b*x^(3/2))/a)])/(2*a), (x^2*(1 + (b*x^(3/2))/a)^(2/3)*Hypergeometric2F1[2/3, 4/3, 7/3, -((b*x^(3/2))/a)])/(2*(a + b*x^(3/2))^(2/3))}
{1/(x^2*(a + b*x^(3/2))^(2/3)), x, 3, -(((a + b*x^(3/2))^(1/3)*Hypergeometric2F1[-(1/3), 1, 1/3, -((b*x^(3/2))/a)])/(a*x)), -(((1 + (b*x^(3/2))/a)^(2/3)*Hypergeometric2F1[-(2/3), 2/3, 1/3, -((b*x^(3/2))/a)])/(x*(a + b*x^(3/2))^(2/3)))}
{1/(x^5*(a + b*x^(3/2))^(2/3)), x, 3, -(((1 + (b*x^(3/2))/a)^(2/3)*Hypergeometric2F1[-(8/3), 2/3, -(5/3), -((b*x^(3/2))/a)])/(4*x^4*(a + b*x^(3/2))^(2/3)))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^(1/3))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^(1/3))^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b*x^(1/3))*x^4, x, 2, (a*x^5)/5 + (3*b*x^(16/3))/16}
{(a + b*x^(1/3))*x^3, x, 2, (a*x^4)/4 + (3*b*x^(13/3))/13}
{(a + b*x^(1/3))*x^2, x, 2, (a*x^3)/3 + (3*b*x^(10/3))/10}
{(a + b*x^(1/3))*x, x, 2, (a*x^2)/2 + (3*b*x^(7/3))/7}
{a + b*x^(1/3), x, 1, a*x + (3*b*x^(4/3))/4}
{(a + b*x^(1/3))/x, x, 2, 3*b*x^(1/3) + a*Log[x]}
{(a + b*x^(1/3))/x^2, x, 2, -(a/x) - (3*b)/(2*x^(2/3))}
{(a + b*x^(1/3))/x^3, x, 2, -a/(2*x^2) - (3*b)/(5*x^(5/3))}
{(a + b*x^(1/3))/x^4, x, 2, -a/(3*x^3) - (3*b)/(8*x^(8/3))}


{(a + b*x^(1/3))^2*x^4, x, 3, (a^2*x^5)/5 + (3*a*b*x^(16/3))/8 + (3*b^2*x^(17/3))/17}
{(a + b*x^(1/3))^2*x^3, x, 3, (a^2*x^4)/4 + (6*a*b*x^(13/3))/13 + (3*b^2*x^(14/3))/14}
{(a + b*x^(1/3))^2*x^2, x, 3, (a^2*x^3)/3 + (3*a*b*x^(10/3))/5 + (3*b^2*x^(11/3))/11}
{(a + b*x^(1/3))^2*x, x, 3, (a^2*x^2)/2 + (6*a*b*x^(7/3))/7 + (3*b^2*x^(8/3))/8}
{(a + b*x^(1/3))^2, x, 3, a^2*x + (3*a*b*x^(4/3))/2 + (3*b^2*x^(5/3))/5}
{(a + b*x^(1/3))^2/x, x, 3, 6*a*b*x^(1/3) + (3*b^2*x^(2/3))/2 + a^2*Log[x]}
{(a + b*x^(1/3))^2/x^2, x, 1, -((a + b*x^(1/3))^3/(a*x))}
{(a + b*x^(1/3))^2/x^3, x, 3, -a^2/(2*x^2) - (6*a*b)/(5*x^(5/3)) - (3*b^2)/(4*x^(4/3))}
{(a + b*x^(1/3))^2/x^4, x, 3, -a^2/(3*x^3) - (3*a*b)/(4*x^(8/3)) - (3*b^2)/(7*x^(7/3))}


{(a + b*x^(1/3))^3*x^4, x, 3, (a^3*x^5)/5 + (9*a^2*b*x^(16/3))/16 + (9*a*b^2*x^(17/3))/17 + (b^3*x^6)/6}
{(a + b*x^(1/3))^3*x^3, x, 3, (a^3*x^4)/4 + (9*a^2*b*x^(13/3))/13 + (9*a*b^2*x^(14/3))/14 + (b^3*x^5)/5}
{(a + b*x^(1/3))^3*x^2, x, 3, (a^3*x^3)/3 + (9*a^2*b*x^(10/3))/10 + (9*a*b^2*x^(11/3))/11 + (b^3*x^4)/4}
{(a + b*x^(1/3))^3*x, x, 3, (a^3*x^2)/2 + (9*a^2*b*x^(7/3))/7 + (9*a*b^2*x^(8/3))/8 + (b^3*x^3)/3}
{(a + b*x^(1/3))^3, x, 3, a^3*x + (9/4)*a^2*b*x^(4/3) + (9/5)*a*b^2*x^(5/3) + (b^3*x^2)/2}
{(a + b*x^(1/3))^3/x, x, 3, 9*a^2*b*x^(1/3) + (9*a*b^2*x^(2/3))/2 + b^3*x + a^3*Log[x]}
{(a + b*x^(1/3))^3/x^2, x, 3, -(a^3/x) - (9*a^2*b)/(2*x^(2/3)) - (9*a*b^2)/x^(1/3) + b^3*Log[x]}
{(a + b*x^(1/3))^3/x^3, x, 3, -a^3/(2*x^2) - (9*a^2*b)/(5*x^(5/3)) - (9*a*b^2)/(4*x^(4/3)) - b^3/x}
{(a + b*x^(1/3))^3/x^4, x, 3, -a^3/(3*x^3) - (9*a^2*b)/(8*x^(8/3)) - (9*a*b^2)/(7*x^(7/3)) - b^3/(2*x^2)}


{(a + b*x^(1/3))^5*x^4, x, 3, (a^5*x^5)/5 + (15*a^4*b*x^(16/3))/16 + (30*a^3*b^2*x^(17/3))/17 + (5*a^2*b^3*x^6)/3 + (15*a*b^4*x^(19/3))/19 + (3*b^5*x^(20/3))/20}
{(a + b*x^(1/3))^5*x^3, x, 3, (a^5*x^4)/4 + (15*a^4*b*x^(13/3))/13 + (15*a^3*b^2*x^(14/3))/7 + 2*a^2*b^3*x^5 + (15*a*b^4*x^(16/3))/16 + (3*b^5*x^(17/3))/17}
{(a + b*x^(1/3))^5*x^2, x, 3, (a^5*x^3)/3 + (3*a^4*b*x^(10/3))/2 + (30*a^3*b^2*x^(11/3))/11 + (5*a^2*b^3*x^4)/2 + (15*a*b^4*x^(13/3))/13 + (3*b^5*x^(14/3))/14}
{(a + b*x^(1/3))^5*x, x, 3, (a^5*x^2)/2 + (15*a^4*b*x^(7/3))/7 + (15*a^3*b^2*x^(8/3))/4 + (10*a^2*b^3*x^3)/3 + (3*a*b^4*x^(10/3))/2 + (3*b^5*x^(11/3))/11}
{(a + b*x^(1/3))^5, x, 3, (a^2*(a + b*x^(1/3))^6)/(2*b^3) - (6*a*(a + b*x^(1/3))^7)/(7*b^3) + (3*(a + b*x^(1/3))^8)/(8*b^3)}
{(a + b*x^(1/3))^5/x, x, 3, 15*a^4*b*x^(1/3) + 15*a^3*b^2*x^(2/3) + 10*a^2*b^3*x + (15*a*b^4*x^(4/3))/4 + (3*b^5*x^(5/3))/5 + a^5*Log[x]}
{(a + b*x^(1/3))^5/x^2, x, 3, -(a^5/x) - (15*a^4*b)/(2*x^(2/3)) - (30*a^3*b^2)/x^(1/3) + 15*a*b^4*x^(1/3) + (3*b^5*x^(2/3))/2 + 10*a^2*b^3*Log[x]}
{(a + b*x^(1/3))^5/x^3, x, 1, -(a + b*x^(1/3))^6/(2*a*x^2)}
{(a + b*x^(1/3))^5/x^4, x, 3, -a^5/(3*x^3) - (15*a^4*b)/(8*x^(8/3)) - (30*a^3*b^2)/(7*x^(7/3)) - (5*a^2*b^3)/x^2 - (3*a*b^4)/x^(5/3) - (3*b^5)/(4*x^(4/3))}
{(a + b*x^(1/3))^5/x^5, x, 3, -a^5/(4*x^4) - (15*a^4*b)/(11*x^(11/3)) - (3*a^3*b^2)/x^(10/3) - (10*a^2*b^3)/(3*x^3) - (15*a*b^4)/(8*x^(8/3)) - (3*b^5)/(7*x^(7/3))}
{(a + b*x^(1/3))^5/x^6, x, 3, -a^5/(5*x^5) - (15*a^4*b)/(14*x^(14/3)) - (30*a^3*b^2)/(13*x^(13/3)) - (5*a^2*b^3)/(2*x^4) - (15*a*b^4)/(11*x^(11/3)) - (3*b^5)/(10*x^(10/3))}
{(a + b*x^(1/3))^5/x^7, x, 3, -a^5/(6*x^6) - (15*a^4*b)/(17*x^(17/3)) - (15*a^3*b^2)/(8*x^(16/3)) - (2*a^2*b^3)/x^5 - (15*a*b^4)/(14*x^(14/3)) - (3*b^5)/(13*x^(13/3))}


{(a + b*x^(1/3))^10*x^4, x, 3, (a^10*x^5)/5 + (15*a^9*b*x^(16/3))/8 + (135*a^8*b^2*x^(17/3))/17 + 20*a^7*b^3*x^6 + (630*a^6*b^4*x^(19/3))/19 + (189*a^5*b^5*x^(20/3))/5 + 30*a^4*b^6*x^7 + (180*a^3*b^7*x^(22/3))/11 + (135*a^2*b^8*x^(23/3))/23 + (5*a*b^9*x^8)/4 + (3*b^10*x^(25/3))/25}
{(a + b*x^(1/3))^10*x^3, x, 3, (a^10*x^4)/4 + (30*a^9*b*x^(13/3))/13 + (135*a^8*b^2*x^(14/3))/14 + 24*a^7*b^3*x^5 + (315*a^6*b^4*x^(16/3))/8 + (756*a^5*b^5*x^(17/3))/17 + 35*a^4*b^6*x^6 + (360*a^3*b^7*x^(19/3))/19 + (27*a^2*b^8*x^(20/3))/4 + (10*a*b^9*x^7)/7 + (3*b^10*x^(22/3))/22}
{(a + b*x^(1/3))^10*x^2, x, 3, (3*a^8*(a + b*x^(1/3))^11)/(11*b^9) - (2*a^7*(a + b*x^(1/3))^12)/b^9 + (84*a^6*(a + b*x^(1/3))^13)/(13*b^9) - (12*a^5*(a + b*x^(1/3))^14)/b^9 + (14*a^4*(a + b*x^(1/3))^15)/b^9 - (21*a^3*(a + b*x^(1/3))^16)/(2*b^9) + (84*a^2*(a + b*x^(1/3))^17)/(17*b^9) - (4*a*(a + b*x^(1/3))^18)/(3*b^9) + (3*(a + b*x^(1/3))^19)/(19*b^9)}
{(a + b*x^(1/3))^10*x, x, 3, (-3*a^5*(a + b*x^(1/3))^11)/(11*b^6) + (5*a^4*(a + b*x^(1/3))^12)/(4*b^6) - (30*a^3*(a + b*x^(1/3))^13)/(13*b^6) + (15*a^2*(a + b*x^(1/3))^14)/(7*b^6) - (a*(a + b*x^(1/3))^15)/b^6 + (3*(a + b*x^(1/3))^16)/(16*b^6)}
{(a + b*x^(1/3))^10, x, 3, (3*a^2*(a + b*x^(1/3))^11)/(11*b^3) - (a*(a + b*x^(1/3))^12)/(2*b^3) + (3*(a + b*x^(1/3))^13)/(13*b^3)}
{(a + b*x^(1/3))^10/x, x, 3, 30*a^9*b*x^(1/3) + (135*a^8*b^2*x^(2/3))/2 + 120*a^7*b^3*x + (315*a^6*b^4*x^(4/3))/2 + (756*a^5*b^5*x^(5/3))/5 + 105*a^4*b^6*x^2 + (360*a^3*b^7*x^(7/3))/7 + (135*a^2*b^8*x^(8/3))/8 + (10*a*b^9*x^3)/3 + (3*b^10*x^(10/3))/10 + a^10*Log[x]}
{(a + b*x^(1/3))^10/x^2, x, 3, -(a^10/x) - (15*a^9*b)/x^(2/3) - (135*a^8*b^2)/x^(1/3) + 630*a^6*b^4*x^(1/3) + 378*a^5*b^5*x^(2/3) + 210*a^4*b^6*x + 90*a^3*b^7*x^(4/3) + 27*a^2*b^8*x^(5/3) + 5*a*b^9*x^2 + (3*b^10*x^(7/3))/7 + 120*a^7*b^3*Log[x]}
{(a + b*x^(1/3))^10/x^3, x, 3, -a^10/(2*x^2) - (6*a^9*b)/x^(5/3) - (135*a^8*b^2)/(4*x^(4/3)) - (120*a^7*b^3)/x - (315*a^6*b^4)/x^(2/3) - (756*a^5*b^5)/x^(1/3) + 360*a^3*b^7*x^(1/3) + (135*a^2*b^8*x^(2/3))/2 + 10*a*b^9*x + (3*b^10*x^(4/3))/4 + 210*a^4*b^6*Log[x]}
{(a + b*x^(1/3))^10/x^4, x, 3, -a^10/(3*x^3) - (15*a^9*b)/(4*x^(8/3)) - (135*a^8*b^2)/(7*x^(7/3)) - (60*a^7*b^3)/x^2 - (126*a^6*b^4)/x^(5/3) - (189*a^5*b^5)/x^(4/3) - (210*a^4*b^6)/x - (180*a^3*b^7)/x^(2/3) - (135*a^2*b^8)/x^(1/3) + 3*b^10*x^(1/3) + 10*a*b^9*Log[x]}
{(a + b*x^(1/3))^10/x^5, x, 3, -(a + b*x^(1/3))^11/(4*a*x^4) + (b*(a + b*x^(1/3))^11)/(44*a^2*x^(11/3))}
{(a + b*x^(1/3))^10/x^6, x, 6, -(a + b*x^(1/3))^11/(5*a*x^5) + (2*b*(a + b*x^(1/3))^11)/(35*a^2*x^(14/3)) - (6*b^2*(a + b*x^(1/3))^11)/(455*a^3*x^(13/3)) + (b^3*(a + b*x^(1/3))^11)/(455*a^4*x^4) - (b^4*(a + b*x^(1/3))^11)/(5005*a^5*x^(11/3))}
{(a + b*x^(1/3))^10/x^7, x, 3, -a^10/(6*x^6) - (30*a^9*b)/(17*x^(17/3)) - (135*a^8*b^2)/(16*x^(16/3)) - (24*a^7*b^3)/x^5 - (45*a^6*b^4)/x^(14/3) - (756*a^5*b^5)/(13*x^(13/3)) - (105*a^4*b^6)/(2*x^4) - (360*a^3*b^7)/(11*x^(11/3)) - (27*a^2*b^8)/(2*x^(10/3)) - (10*a*b^9)/(3*x^3) - (3*b^10)/(8*x^(8/3))}
{(a + b*x^(1/3))^10/x^8, x, 3, -a^10/(7*x^7) - (3*a^9*b)/(2*x^(20/3)) - (135*a^8*b^2)/(19*x^(19/3)) - (20*a^7*b^3)/x^6 - (630*a^6*b^4)/(17*x^(17/3)) - (189*a^5*b^5)/(4*x^(16/3)) - (42*a^4*b^6)/x^5 - (180*a^3*b^7)/(7*x^(14/3)) - (135*a^2*b^8)/(13*x^(13/3)) - (5*a*b^9)/(2*x^4) - (3*b^10)/(11*x^(11/3))}
{(a + b*x^(1/3))^10/x^9, x, 3, -a^10/(8*x^8) - (30*a^9*b)/(23*x^(23/3)) - (135*a^8*b^2)/(22*x^(22/3)) - (120*a^7*b^3)/(7*x^7) - (63*a^6*b^4)/(2*x^(20/3)) - (756*a^5*b^5)/(19*x^(19/3)) - (35*a^4*b^6)/x^6 - (360*a^3*b^7)/(17*x^(17/3)) - (135*a^2*b^8)/(16*x^(16/3)) - (2*a*b^9)/x^5 - (3*b^10)/(14*x^(14/3))}
{(a + b*x^(1/3))^10/x^10, x, 3, -a^10/(9*x^9) - (15*a^9*b)/(13*x^(26/3)) - (27*a^8*b^2)/(5*x^(25/3)) - (15*a^7*b^3)/x^8 - (630*a^6*b^4)/(23*x^(23/3)) - (378*a^5*b^5)/(11*x^(22/3)) - (30*a^4*b^6)/x^7 - (18*a^3*b^7)/x^(20/3) - (135*a^2*b^8)/(19*x^(19/3)) - (5*a*b^9)/(3*x^6) - (3*b^10)/(17*x^(17/3))}


{(a + b*x^(1/3))^15*x^5, x, 3, (a^15*x^6)/6 + (45/19)*a^14*b*x^(19/3) + (63/4)*a^13*b^2*x^(20/3) + 65*a^12*b^3*x^7 + (4095/22)*a^11*b^4*x^(22/3) + (9009/23)*a^10*b^5*x^(23/3) + (5005/8)*a^9*b^6*x^8 + (3861/5)*a^8*b^7*x^(25/3) + (1485/2)*a^7*b^8*x^(26/3) + (5005/9)*a^6*b^9*x^9 + (1287/4)*a^5*b^10*x^(28/3) + (4095/29)*a^4*b^11*x^(29/3) + (91/2)*a^3*b^12*x^10 + (315/31)*a^2*b^13*x^(31/3) + (45/32)*a*b^14*x^(32/3) + (b^15*x^11)/11}
{(a + b*x^(1/3))^15*x^4, x, 3, (a^15*x^5)/5 + (45/16)*a^14*b*x^(16/3) + (315/17)*a^13*b^2*x^(17/3) + (455/6)*a^12*b^3*x^6 + (4095/19)*a^11*b^4*x^(19/3) + (9009/20)*a^10*b^5*x^(20/3) + 715*a^9*b^6*x^7 + (1755/2)*a^8*b^7*x^(22/3) + (19305/23)*a^7*b^8*x^(23/3) + (5005/8)*a^6*b^9*x^8 + (9009/25)*a^5*b^10*x^(25/3) + (315/2)*a^4*b^11*x^(26/3) + (455/9)*a^3*b^12*x^9 + (45/4)*a^2*b^13*x^(28/3) + (45/29)*a*b^14*x^(29/3) + (b^15*x^10)/10}
{(a + b*x^(1/3))^15*x^3, x, 3, -((3*a^11*(a + b*x^(1/3))^16)/(16*b^12)) + (33*a^10*(a + b*x^(1/3))^17)/(17*b^12) - (55*a^9*(a + b*x^(1/3))^18)/(6*b^12) + (495*a^8*(a + b*x^(1/3))^19)/(19*b^12) - (99*a^7*(a + b*x^(1/3))^20)/(2*b^12) + (66*a^6*(a + b*x^(1/3))^21)/b^12 - (63*a^5*(a + b*x^(1/3))^22)/b^12 + (990*a^4*(a + b*x^(1/3))^23)/(23*b^12) - (165*a^3*(a + b*x^(1/3))^24)/(8*b^12) + (33*a^2*(a + b*x^(1/3))^25)/(5*b^12) - (33*a*(a + b*x^(1/3))^26)/(26*b^12) + (a + b*x^(1/3))^27/(9*b^12)}
{(a + b*x^(1/3))^15*x^2, x, 3, (3*a^8*(a + b*x^(1/3))^16)/(16*b^9) - (24*a^7*(a + b*x^(1/3))^17)/(17*b^9) + (14*a^6*(a + b*x^(1/3))^18)/(3*b^9) - (168*a^5*(a + b*x^(1/3))^19)/(19*b^9) + (21*a^4*(a + b*x^(1/3))^20)/(2*b^9) - (8*a^3*(a + b*x^(1/3))^21)/b^9 + (42*a^2*(a + b*x^(1/3))^22)/(11*b^9) - (24*a*(a + b*x^(1/3))^23)/(23*b^9) + (a + b*x^(1/3))^24/(8*b^9)}
{(a + b*x^(1/3))^15*x, x, 3, (-3*a^5*(a + b*x^(1/3))^16)/(16*b^6) + (15*a^4*(a + b*x^(1/3))^17)/(17*b^6) - (5*a^3*(a + b*x^(1/3))^18)/(3*b^6) + (30*a^2*(a + b*x^(1/3))^19)/(19*b^6) - (3*a*(a + b*x^(1/3))^20)/(4*b^6) + (a + b*x^(1/3))^21/(7*b^6)}
{(a + b*x^(1/3))^15, x, 3, (3*a^2*(a + b*x^(1/3))^16)/(16*b^3) - (6*a*(a + b*x^(1/3))^17)/(17*b^3) + (a + b*x^(1/3))^18/(6*b^3)}
{(a + b*x^(1/3))^15/x, x, 3, 45*a^14*b*x^(1/3) + (315*a^13*b^2*x^(2/3))/2 + 455*a^12*b^3*x + (4095*a^11*b^4*x^(4/3))/4 + (9009*a^10*b^5*x^(5/3))/5 + (5005*a^9*b^6*x^2)/2 + (19305*a^8*b^7*x^(7/3))/7 + (19305*a^7*b^8*x^(8/3))/8 + (5005*a^6*b^9*x^3)/3 + (9009*a^5*b^10*x^(10/3))/10 + (4095*a^4*b^11*x^(11/3))/11 + (455*a^3*b^12*x^4)/4 + (315*a^2*b^13*x^(13/3))/13 + (45*a*b^14*x^(14/3))/14 + (b^15*x^5)/5 + a^15*Log[x]}
{(a + b*x^(1/3))^15/x^2, x, 3, -(a^15/x) - (45*a^14*b)/(2*x^(2/3)) - (315*a^13*b^2)/x^(1/3) + 4095*a^11*b^4*x^(1/3) + (9009*a^10*b^5*x^(2/3))/2 + 5005*a^9*b^6*x + (19305*a^8*b^7*x^(4/3))/4 + 3861*a^7*b^8*x^(5/3) + (5005*a^6*b^9*x^2)/2 + 1287*a^5*b^10*x^(7/3) + (4095*a^4*b^11*x^(8/3))/8 + (455*a^3*b^12*x^3)/3 + (63*a^2*b^13*x^(10/3))/2 + (45*a*b^14*x^(11/3))/11 + (b^15*x^4)/4 + 455*a^12*b^3*Log[x]}
{(a + b*x^(1/3))^15/x^3, x, 3, -a^15/(2*x^2) - (9*a^14*b)/x^(5/3) - (315*a^13*b^2)/(4*x^(4/3)) - (455*a^12*b^3)/x - (4095*a^11*b^4)/(2*x^(2/3)) - (9009*a^10*b^5)/x^(1/3) + 19305*a^8*b^7*x^(1/3) + (19305*a^7*b^8*x^(2/3))/2 + 5005*a^6*b^9*x + (9009*a^5*b^10*x^(4/3))/4 + 819*a^4*b^11*x^(5/3) + (455*a^3*b^12*x^2)/2 + 45*a^2*b^13*x^(7/3) + (45*a*b^14*x^(8/3))/8 + (b^15*x^3)/3 + 5005*a^9*b^6*Log[x]}
{(a + b*x^(1/3))^15/x^4, x, 3, -a^15/(3*x^3) - (45*a^14*b)/(8*x^(8/3)) - (45*a^13*b^2)/x^(7/3) - (455*a^12*b^3)/(2*x^2) - (819*a^11*b^4)/x^(5/3) - (9009*a^10*b^5)/(4*x^(4/3)) - (5005*a^9*b^6)/x - (19305*a^8*b^7)/(2*x^(2/3)) - (19305*a^7*b^8)/x^(1/3) + 9009*a^5*b^10*x^(1/3) + (4095*a^4*b^11*x^(2/3))/2 + 455*a^3*b^12*x + (315*a^2*b^13*x^(4/3))/4 + 9*a*b^14*x^(5/3) + (b^15*x^2)/2 + 5005*a^6*b^9*Log[x]}
{(a + b*x^(1/3))^15/x^6, x, 3, -a^15/(5*x^5) - (45*a^14*b)/(14*x^(14/3)) - (315*a^13*b^2)/(13*x^(13/3)) - (455*a^12*b^3)/(4*x^4) - (4095*a^11*b^4)/(11*x^(11/3)) - (9009*a^10*b^5)/(10*x^(10/3)) - (5005*a^9*b^6)/(3*x^3) - (19305*a^8*b^7)/(8*x^(8/3)) - (19305*a^7*b^8)/(7*x^(7/3)) - (5005*a^6*b^9)/(2*x^2) - (9009*a^5*b^10)/(5*x^(5/3)) - (4095*a^4*b^11)/(4*x^(4/3)) - (455*a^3*b^12)/x - (315*a^2*b^13)/(2*x^(2/3)) - (45*a*b^14)/x^(1/3) + b^15*Log[x]}
{(a + b*x^(1/3))^15/x^7, x, 4, -(a + b*x^(1/3))^16/(6*a*x^6) + (b*(a + b*x^(1/3))^16)/(51*a^2*x^(17/3)) - (b^2*(a + b*x^(1/3))^16)/(816*a^3*x^(16/3))}
{(a + b*x^(1/3))^15/x^8, x, 7, -(a + b*x^(1/3))^16/(7*a*x^7) + (b*(a + b*x^(1/3))^16)/(28*a^2*x^(20/3)) - (b^2*(a + b*x^(1/3))^16)/(133*a^3*x^(19/3)) + (b^3*(a + b*x^(1/3))^16)/(798*a^4*x^6) - (b^4*(a + b*x^(1/3))^16)/(6783*a^5*x^(17/3)) + (b^5*(a + b*x^(1/3))^16)/(108528*a^6*x^(16/3))}
{(a + b*x^(1/3))^15/x^9, x, 10, -(a + b*x^(1/3))^16/(8*a*x^8) + (b*(a + b*x^(1/3))^16)/(23*a^2*x^(23/3)) - (7*b^2*(a + b*x^(1/3))^16)/(506*a^3*x^(22/3)) + (b^3*(a + b*x^(1/3))^16)/(253*a^4*x^7) - (b^4*(a + b*x^(1/3))^16)/(1012*a^5*x^(20/3)) + (b^5*(a + b*x^(1/3))^16)/(4807*a^6*x^(19/3)) - (b^6*(a + b*x^(1/3))^16)/(28842*a^7*x^6) + (b^7*(a + b*x^(1/3))^16)/(245157*a^8*x^(17/3)) - (b^8*(a + b*x^(1/3))^16)/(3922512*a^9*x^(16/3))}
{(a + b*x^(1/3))^15/x^10, x, 3, -a^15/(9*x^9) - (45*a^14*b)/(26*x^(26/3)) - (63*a^13*b^2)/(5*x^(25/3)) - (455*a^12*b^3)/(8*x^8) - (4095*a^11*b^4)/(23*x^(23/3)) - (819*a^10*b^5)/(2*x^(22/3)) - (715*a^9*b^6)/x^7 - (3861*a^8*b^7)/(4*x^(20/3)) - (19305*a^7*b^8)/(19*x^(19/3)) - (5005*a^6*b^9)/(6*x^6) - (9009*a^5*b^10)/(17*x^(17/3)) - (4095*a^4*b^11)/(16*x^(16/3)) - (91*a^3*b^12)/x^5 - (45*a^2*b^13)/(2*x^(14/3)) - (45*a*b^14)/(13*x^(13/3)) - b^15/(4*x^4)}
{(a + b*x^(1/3))^15/x^11, x, 3, -a^15/(10*x^10) - (45*a^14*b)/(29*x^(29/3)) - (45*a^13*b^2)/(4*x^(28/3)) - (455*a^12*b^3)/(9*x^9) - (315*a^11*b^4)/(2*x^(26/3)) - (9009*a^10*b^5)/(25*x^(25/3)) - (5005*a^9*b^6)/(8*x^8) - (19305*a^8*b^7)/(23*x^(23/3)) - (1755*a^7*b^8)/(2*x^(22/3)) - (715*a^6*b^9)/x^7 - (9009*a^5*b^10)/(20*x^(20/3)) - (4095*a^4*b^11)/(19*x^(19/3)) - (455*a^3*b^12)/(6*x^6) - (315*a^2*b^13)/(17*x^(17/3)) - (45*a*b^14)/(16*x^(16/3)) - b^15/(5*x^5)}
{(a + b*x^(1/3))^15/x^12, x, 3, -a^15/(11*x^11) - (45*a^14*b)/(32*x^(32/3)) - (315*a^13*b^2)/(31*x^(31/3)) - (91*a^12*b^3)/(2*x^10) - (4095*a^11*b^4)/(29*x^(29/3)) - (1287*a^10*b^5)/(4*x^(28/3)) - (5005*a^9*b^6)/(9*x^9) - (1485*a^8*b^7)/(2*x^(26/3)) - (3861*a^7*b^8)/(5*x^(25/3)) - (5005*a^6*b^9)/(8*x^8) - (9009*a^5*b^10)/(23*x^(23/3)) - (4095*a^4*b^11)/(22*x^(22/3)) - (65*a^3*b^12)/x^7 - (63*a^2*b^13)/(4*x^(20/3)) - (45*a*b^14)/(19*x^(19/3)) - b^15/(6*x^6)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^3/(a + b*x^(1/3)), x, 3, (3*a^10*x^(1/3))/b^11 - (3*a^9*x^(2/3))/(2*b^10) + (a^8*x)/b^9 - (3*a^7*x^(4/3))/(4*b^8) + (3*a^6*x^(5/3))/(5*b^7) - (a^5*x^2)/(2*b^6) + (3*a^4*x^(7/3))/(7*b^5) - (3*a^3*x^(8/3))/(8*b^4) + (a^2*x^3)/(3*b^3) - (3*a*x^(10/3))/(10*b^2) + (3*x^(11/3))/(11*b) - (3*a^11*Log[a + b*x^(1/3)])/b^12}
{x^2/(a + b*x^(1/3)), x, 3, (-3*a^7*x^(1/3))/b^8 + (3*a^6*x^(2/3))/(2*b^7) - (a^5*x)/b^6 + (3*a^4*x^(4/3))/(4*b^5) - (3*a^3*x^(5/3))/(5*b^4) + (a^2*x^2)/(2*b^3) - (3*a*x^(7/3))/(7*b^2) + (3*x^(8/3))/(8*b) + (3*a^8*Log[a + b*x^(1/3)])/b^9}
{x/(a + b*x^(1/3)), x, 3, (3*a^4*x^(1/3))/b^5 - (3*a^3*x^(2/3))/(2*b^4) + (a^2*x)/b^3 - (3*a*x^(4/3))/(4*b^2) + (3*x^(5/3))/(5*b) - (3*a^5*Log[a + b*x^(1/3)])/b^6}
{1/(a + b*x^(1/3)), x, 3, (-3*a*x^(1/3))/b^2 + (3*x^(2/3))/(2*b) + (3*a^2*Log[a + b*x^(1/3)])/b^3}
{1/((a + b*x^(1/3))*x), x, 4, (-3*Log[a + b*x^(1/3)])/a + Log[x]/a}
{1/((a + b*x^(1/3))*x^2), x, 3, -(1/(a*x)) + (3*b)/(2*a^2*x^(2/3)) - (3*b^2)/(a^3*x^(1/3)) + (3*b^3*Log[a + b*x^(1/3)])/a^4 - (b^3*Log[x])/a^4}
{1/((a + b*x^(1/3))*x^3), x, 3, -1/(2*a*x^2) + (3*b)/(5*a^2*x^(5/3)) - (3*b^2)/(4*a^3*x^(4/3)) + b^3/(a^4*x) - (3*b^4)/(2*a^5*x^(2/3)) + (3*b^5)/(a^6*x^(1/3)) - (3*b^6*Log[a + b*x^(1/3)])/a^7 + (b^6*Log[x])/a^7}
{1/((a + b*x^(1/3))*x^4), x, 3, -1/(3*a*x^3) + (3*b)/(8*a^2*x^(8/3)) - (3*b^2)/(7*a^3*x^(7/3)) + b^3/(2*a^4*x^2) - (3*b^4)/(5*a^5*x^(5/3)) + (3*b^5)/(4*a^6*x^(4/3)) - b^6/(a^7*x) + (3*b^7)/(2*a^8*x^(2/3)) - (3*b^8)/(a^9*x^(1/3)) + (3*b^9*Log[a + b*x^(1/3)])/a^10 - (b^9*Log[x])/a^10}

{1/((2 + b*x^(1/3))*x), x, 4, (-(3/2))*Log[2 + b*x^(1/3)] + Log[x]/2}


{x^3/(a + b*x^(1/3))^2, x, 3, (3*a^11)/(b^12*(a + b*x^(1/3))) - (30*a^9*x^(1/3))/b^11 + (27*a^8*x^(2/3))/(2*b^10) - (8*a^7*x)/b^9 + (21*a^6*x^(4/3))/(4*b^8) - (18*a^5*x^(5/3))/(5*b^7) + (5*a^4*x^2)/(2*b^6) - (12*a^3*x^(7/3))/(7*b^5) + (9*a^2*x^(8/3))/(8*b^4) - (2*a*x^3)/(3*b^3) + (3*x^(10/3))/(10*b^2) + (33*a^10*Log[a + b*x^(1/3)])/b^12}
{x^2/(a + b*x^(1/3))^2, x, 3, (-3*a^8)/(b^9*(a + b*x^(1/3))) + (21*a^6*x^(1/3))/b^8 - (9*a^5*x^(2/3))/b^7 + (5*a^4*x)/b^6 - (3*a^3*x^(4/3))/b^5 + (9*a^2*x^(5/3))/(5*b^4) - (a*x^2)/b^3 + (3*x^(7/3))/(7*b^2) - (24*a^7*Log[a + b*x^(1/3)])/b^9}
{x/(a + b*x^(1/3))^2, x, 3, (3*a^5)/(b^6*(a + b*x^(1/3))) - (12*a^3*x^(1/3))/b^5 + (9*a^2*x^(2/3))/(2*b^4) - (2*a*x)/b^3 + (3*x^(4/3))/(4*b^2) + (15*a^4*Log[a + b*x^(1/3)])/b^6}
{1/(a + b*x^(1/3))^2, x, 3, -((3*a^2)/(b^3*(a + b*x^(1/3)))) + (3*x^(1/3))/b^2 - (6*a*Log[a + b*x^(1/3)])/b^3}
{1/((a + b*x^(1/3))^2*x), x, 3, 3/(a*(a + b*x^(1/3))) - (3*Log[a + b*x^(1/3)])/a^2 + Log[x]/a^2}
{1/((a + b*x^(1/3))^2*x^2), x, 3, -((3*b^3)/(a^4*(a + b*x^(1/3)))) - 1/(a^2*x) + (3*b)/(a^3*x^(2/3)) - (9*b^2)/(a^4*x^(1/3)) + (12*b^3*Log[a + b*x^(1/3)])/a^5 - (4*b^3*Log[x])/a^5}
{1/((a + b*x^(1/3))^2*x^3), x, 3, (3*b^6)/(a^7*(a + b*x^(1/3))) - 1/(2*a^2*x^2) + (6*b)/(5*a^3*x^(5/3)) - (9*b^2)/(4*a^4*x^(4/3)) + (4*b^3)/(a^5*x) - (15*b^4)/(2*a^6*x^(2/3)) + (18*b^5)/(a^7*x^(1/3)) - (21*b^6*Log[a + b*x^(1/3)])/a^8 + (7*b^6*Log[x])/a^8}
{1/((a + b*x^(1/3))^2*x^4), x, 3, -((3*b^9)/(a^10*(a + b*x^(1/3)))) - 1/(3*a^2*x^3) + (3*b)/(4*a^3*x^(8/3)) - (9*b^2)/(7*a^4*x^(7/3)) + (2*b^3)/(a^5*x^2) - (3*b^4)/(a^6*x^(5/3)) + (9*b^5)/(2*a^7*x^(4/3)) - (7*b^6)/(a^8*x) + (12*b^7)/(a^9*x^(2/3)) - (27*b^8)/(a^10*x^(1/3)) + (30*b^9*Log[a + b*x^(1/3)])/a^11 - (10*b^9*Log[x])/a^11}


{x^3/(a + b*x^(1/3))^3, x, 3, (3*a^11)/(2*b^12*(a + b*x^(1/3))^2) - (33*a^10)/(b^12*(a + b*x^(1/3))) + (135*a^8*x^(1/3))/b^11 - (54*a^7*x^(2/3))/b^10 + (28*a^6*x)/b^9 - (63*a^5*x^(4/3))/(4*b^8) + (9*a^4*x^(5/3))/b^7 - (5*a^3*x^2)/b^6 + (18*a^2*x^(7/3))/(7*b^5) - (9*a*x^(8/3))/(8*b^4) + x^3/(3*b^3) - (165*a^9*Log[a + b*x^(1/3)])/b^12}
{x^2/(a + b*x^(1/3))^3, x, 3, (-3*a^8)/(2*b^9*(a + b*x^(1/3))^2) + (24*a^7)/(b^9*(a + b*x^(1/3))) - (63*a^5*x^(1/3))/b^8 + (45*a^4*x^(2/3))/(2*b^7) - (10*a^3*x)/b^6 + (9*a^2*x^(4/3))/(2*b^5) - (9*a*x^(5/3))/(5*b^4) + x^2/(2*b^3) + (84*a^6*Log[a + b*x^(1/3)])/b^9}
{x/(a + b*x^(1/3))^3, x, 3, (3*a^5)/(2*b^6*(a + b*x^(1/3))^2) - (15*a^4)/(b^6*(a + b*x^(1/3))) + (18*a^2*x^(1/3))/b^5 - (9*a*x^(2/3))/(2*b^4) + x/b^3 - (30*a^3*Log[a + b*x^(1/3)])/b^6}
{1/(a + b*x^(1/3))^3, x, 3, -((3*a^2)/(2*b^3*(a + b*x^(1/3))^2)) + (6*a)/(b^3*(a + b*x^(1/3))) + (3*Log[a + b*x^(1/3)])/b^3}
{1/((a + b*x^(1/3))^3*x), x, 3, 3/(2*a*(a + b*x^(1/3))^2) + 3/(a^2*(a + b*x^(1/3))) - (3*Log[a + b*x^(1/3)])/a^3 + Log[x]/a^3}
{1/((a + b*x^(1/3))^3*x^2), x, 3, -((3*b^3)/(2*a^4*(a + b*x^(1/3))^2)) - (12*b^3)/(a^5*(a + b*x^(1/3))) - 1/(a^3*x) + (9*b)/(2*a^4*x^(2/3)) - (18*b^2)/(a^5*x^(1/3)) + (30*b^3*Log[a + b*x^(1/3)])/a^6 - (10*b^3*Log[x])/a^6}
{1/((a + b*x^(1/3))^3*x^3), x, 3, (3*b^6)/(2*a^7*(a + b*x^(1/3))^2) + (21*b^6)/(a^8*(a + b*x^(1/3))) - 1/(2*a^3*x^2) + (9*b)/(5*a^4*x^(5/3)) - (9*b^2)/(2*a^5*x^(4/3)) + (10*b^3)/(a^6*x) - (45*b^4)/(2*a^7*x^(2/3)) + (63*b^5)/(a^8*x^(1/3)) - (84*b^6*Log[a + b*x^(1/3)])/a^9 + (28*b^6*Log[x])/a^9}
{1/((a + b*x^(1/3))^3*x^4), x, 3, -((3*b^9)/(2*a^10*(a + b*x^(1/3))^2)) - (30*b^9)/(a^11*(a + b*x^(1/3))) - 1/(3*a^3*x^3) + (9*b)/(8*a^4*x^(8/3)) - (18*b^2)/(7*a^5*x^(7/3)) + (5*b^3)/(a^6*x^2) - (9*b^4)/(a^7*x^(5/3)) + (63*b^5)/(4*a^8*x^(4/3)) - (28*b^6)/(a^9*x) + (54*b^7)/(a^10*x^(2/3)) - (135*b^8)/(a^11*x^(1/3)) + (165*b^9*Log[a + b*x^(1/3)])/a^12 - (55*b^9*Log[x])/a^12}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^(1/3))^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/Sqrt[1 + x^(1/3)], x, 3, 6*Sqrt[1 + x^(1/3)] - 4*(1 + x^(1/3))^(3/2) + (6/5)*(1 + x^(1/3))^(5/2)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^(1/3))^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/((1 + x^(1/3))*x^(3/2)), x, 5, -(2/Sqrt[x]) + 6/x^(1/6) + 6*ArcTan[x^(1/6)]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b x^(1/3))^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(2/3)/(1 + x^(1/3)), x, 3, -3*x^(1/3) + (3*x^(2/3))/2 - x + (3*x^(4/3))/4 + 3*Log[1 + x^(1/3)]}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^(2/3))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^(2/3))^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/(1 + x^(2/3)), x, 3, 3*x^(1/3) - 3*ArcTan[x^(1/3)]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b x^(2/3))^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/((1 + x^(2/3))*x^(1/3)), x, 1, (3*Log[1 + x^(2/3)])/2}
{1/((1 + x^(2/3))*x^(2/3)), x, 2, 3*ArcTan[x^(1/3)]}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b x^(2/3))^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{Sqrt[-1 + x^(2/3)]/x^(1/3), x, 1, (-1 + x^(2/3))^(3/2)}
{(1 + x^(2/3))^(3/2)/x^(1/3), x, 1, (3*(1 + x^(2/3))^(5/2))/5}


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/2) (a+b x^(2/3))^p*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{Sqrt[x]/(1 + x^(2/3)), x, 13, -6*x^(1/6) + (6*x^(5/6))/5 - (3*ArcTan[1 - Sqrt[2]*x^(1/6)])/Sqrt[2] + (3*ArcTan[1 + Sqrt[2]*x^(1/6)])/Sqrt[2] - (3*Log[1 - Sqrt[2]*x^(1/6) + x^(1/3)])/(2*Sqrt[2]) + (3*Log[1 + Sqrt[2]*x^(1/6) + x^(1/3)])/(2*Sqrt[2])}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^(5/6))^p*)


{x^(1/3)/(-1 + x^(5/6)), x, 8, 2*Sqrt[x] + (3/5)*Sqrt[10 - 2*Sqrt[5]]*ArcTan[(1 - Sqrt[5] + 4*x^(1/6))/Sqrt[10 + 2*Sqrt[5]]] - (3/5)*Sqrt[10 + 2*Sqrt[5]]*ArcTan[(1 + Sqrt[5] + 4*x^(1/6))/Sqrt[10 - 2*Sqrt[5]]] + (6/5)*Log[1 - x^(1/6)] - (3/10)*(1 + Sqrt[5])*Log[2 + (1 - Sqrt[5])*x^(1/6) + 2*x^(1/3)] - (3/10)*(1 - Sqrt[5])*Log[2 + (1 + Sqrt[5])*x^(1/6) + 2*x^(1/3)], 2*Sqrt[x] + (3/5)*Sqrt[2*(5 - Sqrt[5])]*ArcTan[(1 - Sqrt[5] + 4*x^(1/6))/Sqrt[2*(5 + Sqrt[5])]] - (3/5)*Sqrt[2*(5 + Sqrt[5])]*ArcTan[(1/2)*Sqrt[(1/10)*(5 + Sqrt[5])]*(1 + Sqrt[5] + 4*x^(1/6))] + (6/5)*Log[1 - x^(1/6)] - (3/10)*(1 + Sqrt[5])*Log[2 + x^(1/6) - Sqrt[5]*x^(1/6) + 2*x^(1/3)] - (3/10)*(1 - Sqrt[5])*Log[2 + x^(1/6) + Sqrt[5]*x^(1/6) + 2*x^(1/3)]}


(* ::Title::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p when n<0 is a fraction*)


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^(n/2))^p*)


(* ::Subsection:: *)
(*Integrands of the form x^m (a+b/x^(n/2))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^(n/2))^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{Sqrt[3 - 1/Sqrt[x]], x, 5, (-(1/6))*Sqrt[3 - 1/Sqrt[x]]*Sqrt[x] + Sqrt[3 - 1/Sqrt[x]]*x - ArcTanh[Sqrt[3 - 1/Sqrt[x]]/Sqrt[3]]/(6*Sqrt[3])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{1/Sqrt[1 + 1/Sqrt[x]], x, 5, (-(3/2))*Sqrt[1 + 1/Sqrt[x]]*Sqrt[x] + Sqrt[1 + 1/Sqrt[x]]*x + (3/2)*ArcTanh[Sqrt[1 + 1/Sqrt[x]]]}


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b/x^(n/2))^p*)


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b/x^(n/2))^(p/2)*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^(n/2))^(p/3)*)


{(a + b/x^(3/2))^(2/3), x, 4, (a + b/x^(3/2))^(2/3)*x - (2*b^(2/3)*ArcTan[(1 + (2*b^(1/3))/((a + b/x^(3/2))^(1/3)*Sqrt[x]))/Sqrt[3]])/Sqrt[3] + b^(2/3)*Log[(a + b/x^(3/2))^(1/3) - b^(1/3)/Sqrt[x]]}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^(n/3))^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b/x^(n/3))^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b/x^(1/3))*x^4, x, 2, (3*b*x^(14/3))/14 + (a*x^5)/5}
{(a + b/x^(1/3))*x^3, x, 2, (3*b*x^(11/3))/11 + (a*x^4)/4}
{(a + b/x^(1/3))*x^2, x, 2, (3*b*x^(8/3))/8 + (a*x^3)/3}
{(a + b/x^(1/3))*x^1, x, 2, (3*b*x^(5/3))/5 + (a*x^2)/2}
{(a + b/x^(1/3))*x^0, x, 1, (3*b*x^(2/3))/2 + a*x}
{(a + b/x^(1/3))/x^1, x, 2, (-3*b)/x^(1/3) + a*Log[x]}
{(a + b/x^(1/3))/x^2, x, 2, (-3*b)/(4*x^(4/3)) - a/x}
{(a + b/x^(1/3))/x^3, x, 2, (-3*b)/(7*x^(7/3)) - a/(2*x^2)}
{(a + b/x^(1/3))/x^4, x, 2, (-3*b)/(10*x^(10/3)) - a/(3*x^3)}


{(a + b/x^(1/3))^2*x^4, x, 4, (3*b^2*x^(13/3))/13 + (3*a*b*x^(14/3))/7 + (a^2*x^5)/5}
{(a + b/x^(1/3))^2*x^3, x, 4, (3*b^2*x^(10/3))/10 + (6*a*b*x^(11/3))/11 + (a^2*x^4)/4}
{(a + b/x^(1/3))^2*x^2, x, 4, (3*b^2*x^(7/3))/7 + (3*a*b*x^(8/3))/4 + (a^2*x^3)/3}
{(a + b/x^(1/3))^2*x^1, x, 4, (3*b^2*x^(4/3))/4 + (6*a*b*x^(5/3))/5 + (a^2*x^2)/2}
{(a + b/x^(1/3))^2*x^0, x, 2, ((a + b/x^(1/3))^3*x)/a}
{(a + b/x^(1/3))^2/x^1, x, 4, (-3*b^2)/(2*x^(2/3)) - (6*a*b)/x^(1/3) + a^2*Log[x]}
{(a + b/x^(1/3))^2/x^2, x, 4, (-3*b^2)/(5*x^(5/3)) - (3*a*b)/(2*x^(4/3)) - a^2/x}
{(a + b/x^(1/3))^2/x^3, x, 4, (-3*b^2)/(8*x^(8/3)) - (6*a*b)/(7*x^(7/3)) - a^2/(2*x^2)}
{(a + b/x^(1/3))^2/x^4, x, 4, (-3*b^2)/(11*x^(11/3)) - (3*a*b)/(5*x^(10/3)) - a^2/(3*x^3)}


{(a + b/x^(1/3))^3*x^4, x, 4, (b^3*x^4)/4 + (9*a*b^2*x^(13/3))/13 + (9*a^2*b*x^(14/3))/14 + (a^3*x^5)/5}
{(a + b/x^(1/3))^3*x^3, x, 4, (b^3*x^3)/3 + (9*a*b^2*x^(10/3))/10 + (9*a^2*b*x^(11/3))/11 + (a^3*x^4)/4}
{(a + b/x^(1/3))^3*x^2, x, 4, (b^3*x^2)/2 + (9*a*b^2*x^(7/3))/7 + (9*a^2*b*x^(8/3))/8 + (a^3*x^3)/3}
{(a + b/x^(1/3))^3*x^1, x, 4, b^3*x + (9/4)*a*b^2*x^(4/3) + (9/5)*a^2*b*x^(5/3) + (a^3*x^2)/2}
{(a + b/x^(1/3))^3*x^0, x, 3, 9*a*b^2*x^(1/3) + (9*a^2*b*x^(2/3))/2 + a^3*x + b^3*Log[x]}
{(a + b/x^(1/3))^3/x^1, x, 4, -(b^3/x) - (9*a*b^2)/(2*x^(2/3)) - (9*a^2*b)/x^(1/3) + a^3*Log[x]}
{(a + b/x^(1/3))^3/x^2, x, 4, -b^3/(2*x^2) - (9*a*b^2)/(5*x^(5/3)) - (9*a^2*b)/(4*x^(4/3)) - a^3/x}
{(a + b/x^(1/3))^3/x^3, x, 4, -b^3/(3*x^3) - (9*a*b^2)/(8*x^(8/3)) - (9*a^2*b)/(7*x^(7/3)) - a^3/(2*x^2)}
{(a + b/x^(1/3))^3/x^4, x, 4, -b^3/(4*x^4) - (9*a*b^2)/(11*x^(11/3)) - (9*a^2*b)/(10*x^(10/3)) - a^3/(3*x^3)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^2/(a + b/x^(1/3)), x, 4, (3*b^8*x^(1/3))/a^9 - (3*b^7*x^(2/3))/(2*a^8) + (b^6*x)/a^7 - (3*b^5*x^(4/3))/(4*a^6) + (3*b^4*x^(5/3))/(5*a^5) - (b^3*x^2)/(2*a^4) + (3*b^2*x^(7/3))/(7*a^3) - (3*b*x^(8/3))/(8*a^2) + x^3/(3*a) - (3*b^9*Log[b + a*x^(1/3)])/a^10}
{x^1/(a + b/x^(1/3)), x, 4, -((3*b^5*x^(1/3))/a^6) + (3*b^4*x^(2/3))/(2*a^5) - (b^3*x)/a^4 + (3*b^2*x^(4/3))/(4*a^3) - (3*b*x^(5/3))/(5*a^2) + x^2/(2*a) + (3*b^6*Log[b + a*x^(1/3)])/a^7}
{x^0/(a + b/x^(1/3)), x, 3, (3*b^2*x^(1/3))/a^3 - (3*b*x^(2/3))/(2*a^2) + x/a - (3*b^3*Log[a + b/x^(1/3)])/a^4 - (b^3*Log[x])/a^4}
{1/((a + b/x^(1/3))*x^1), x, 2, (3*Log[b + a*x^(1/3)])/a}
{1/((a + b/x^(1/3))*x^2), x, 4, -(3/(2*b*x^(2/3))) + (3*a)/(b^2*x^(1/3)) - (3*a^2*Log[b + a*x^(1/3)])/b^3 + (a^2*Log[x])/b^3}
{1/((a + b/x^(1/3))*x^3), x, 4, -(3/(5*b*x^(5/3))) + (3*a)/(4*b^2*x^(4/3)) - a^2/(b^3*x) + (3*a^3)/(2*b^4*x^(2/3)) - (3*a^4)/(b^5*x^(1/3)) + (3*a^5*Log[b + a*x^(1/3)])/b^6 - (a^5*Log[x])/b^6}
{1/((a + b/x^(1/3))*x^4), x, 4, -(3/(8*b*x^(8/3))) + (3*a)/(7*b^2*x^(7/3)) - a^2/(2*b^3*x^2) + (3*a^3)/(5*b^4*x^(5/3)) - (3*a^4)/(4*b^5*x^(4/3)) + a^5/(b^6*x) - (3*a^6)/(2*b^7*x^(2/3)) + (3*a^7)/(b^8*x^(1/3)) - (3*a^8*Log[b + a*x^(1/3)])/b^9 + (a^8*Log[x])/b^9}
{1/((a + b/x^(1/3))*x^5), x, 4, -(3/(11*b*x^(11/3))) + (3*a)/(10*b^2*x^(10/3)) - a^2/(3*b^3*x^3) + (3*a^3)/(8*b^4*x^(8/3)) - (3*a^4)/(7*b^5*x^(7/3)) + a^5/(2*b^6*x^2) - (3*a^6)/(5*b^7*x^(5/3)) + (3*a^7)/(4*b^8*x^(4/3)) - a^8/(b^9*x) + (3*a^9)/(2*b^10*x^(2/3)) - (3*a^10)/(b^11*x^(1/3)) + (3*a^11*Log[b + a*x^(1/3)])/b^12 - (a^11*Log[x])/b^12}


{x^2/(a + b/x^(1/3))^2, x, 4, -((3*b^10)/(a^11*(b + a*x^(1/3)))) + (27*b^8*x^(1/3))/a^10 - (12*b^7*x^(2/3))/a^9 + (7*b^6*x)/a^8 - (9*b^5*x^(4/3))/(2*a^7) + (3*b^4*x^(5/3))/a^6 - (2*b^3*x^2)/a^5 + (9*b^2*x^(7/3))/(7*a^4) - (3*b*x^(8/3))/(4*a^3) + x^3/(3*a^2) - (30*b^9*Log[b + a*x^(1/3)])/a^11}
{x^1/(a + b/x^(1/3))^2, x, 4, (3*b^7)/(a^8*(b + a*x^(1/3))) - (18*b^5*x^(1/3))/a^7 + (15*b^4*x^(2/3))/(2*a^6) - (4*b^3*x)/a^5 + (9*b^2*x^(4/3))/(4*a^4) - (6*b*x^(5/3))/(5*a^3) + x^2/(2*a^2) + (21*b^6*Log[b + a*x^(1/3)])/a^8}
{x^0/(a + b/x^(1/3))^2, x, 3, (3*b^3)/(a^4*(a + b/x^(1/3))) + (9*b^2*x^(1/3))/a^4 - (3*b*x^(2/3))/a^3 + x/a^2 - (12*b^3*Log[a + b/x^(1/3)])/a^5 - (4*b^3*Log[x])/a^5}
{1/((a + b/x^(1/3))^2*x^1), x, 4, (3*b)/(a^2*(b + a*x^(1/3))) + (3*Log[b + a*x^(1/3)])/a^2}
{1/((a + b/x^(1/3))^2*x^2), x, 4, -((3*a)/(b^2*(b + a*x^(1/3)))) - 3/(b^2*x^(1/3)) + (6*a*Log[b + a*x^(1/3)])/b^3 - (2*a*Log[x])/b^3}
{1/((a + b/x^(1/3))^2*x^3), x, 4, (3*a^4)/(b^5*(b + a*x^(1/3))) - 3/(4*b^2*x^(4/3)) + (2*a)/(b^3*x) - (9*a^2)/(2*b^4*x^(2/3)) + (12*a^3)/(b^5*x^(1/3)) - (15*a^4*Log[b + a*x^(1/3)])/b^6 + (5*a^4*Log[x])/b^6}
{1/((a + b/x^(1/3))^2*x^4), x, 4, -((3*a^7)/(b^8*(b + a*x^(1/3)))) - 3/(7*b^2*x^(7/3)) + a/(b^3*x^2) - (9*a^2)/(5*b^4*x^(5/3)) + (3*a^3)/(b^5*x^(4/3)) - (5*a^4)/(b^6*x) + (9*a^5)/(b^7*x^(2/3)) - (21*a^6)/(b^8*x^(1/3)) + (24*a^7*Log[b + a*x^(1/3)])/b^9 - (8*a^7*Log[x])/b^9}
{1/((a + b/x^(1/3))^2*x^5), x, 4, (3*a^10)/(b^11*(b + a*x^(1/3))) - 3/(10*b^2*x^(10/3)) + (2*a)/(3*b^3*x^3) - (9*a^2)/(8*b^4*x^(8/3)) + (12*a^3)/(7*b^5*x^(7/3)) - (5*a^4)/(2*b^6*x^2) + (18*a^5)/(5*b^7*x^(5/3)) - (21*a^6)/(4*b^8*x^(4/3)) + (8*a^7)/(b^9*x) - (27*a^8)/(2*b^10*x^(2/3)) + (30*a^9)/(b^11*x^(1/3)) - (33*a^10*Log[b + a*x^(1/3)])/b^12 + (11*a^10*Log[x])/b^12}


{x^2/(a + b/x^(1/3))^3, x, 4, (3*b^11)/(2*a^12*(b + a*x^(1/3))^2) - (33*b^10)/(a^12*(b + a*x^(1/3))) + (135*b^8*x^(1/3))/a^11 - (54*b^7*x^(2/3))/a^10 + (28*b^6*x)/a^9 - (63*b^5*x^(4/3))/(4*a^8) + (9*b^4*x^(5/3))/a^7 - (5*b^3*x^2)/a^6 + (18*b^2*x^(7/3))/(7*a^5) - (9*b*x^(8/3))/(8*a^4) + x^3/(3*a^3) - (165*b^9*Log[b + a*x^(1/3)])/a^12}
{x^1/(a + b/x^(1/3))^3, x, 4, -((3*b^8)/(2*a^9*(b + a*x^(1/3))^2)) + (24*b^7)/(a^9*(b + a*x^(1/3))) - (63*b^5*x^(1/3))/a^8 + (45*b^4*x^(2/3))/(2*a^7) - (10*b^3*x)/a^6 + (9*b^2*x^(4/3))/(2*a^5) - (9*b*x^(5/3))/(5*a^4) + x^2/(2*a^3) + (84*b^6*Log[b + a*x^(1/3)])/a^9}
{x^0/(a + b/x^(1/3))^3, x, 3, (3*b^3)/(2*a^4*(a + b/x^(1/3))^2) + (12*b^3)/(a^5*(a + b/x^(1/3))) + (18*b^2*x^(1/3))/a^5 - (9*b*x^(2/3))/(2*a^4) + x/a^3 - (30*b^3*Log[a + b/x^(1/3)])/a^6 - (10*b^3*Log[x])/a^6}
{1/((a + b/x^(1/3))^3*x^1), x, 4, -((3*b^2)/(2*a^3*(b + a*x^(1/3))^2)) + (6*b)/(a^3*(b + a*x^(1/3))) + (3*Log[b + a*x^(1/3)])/a^3}
{1/((a + b/x^(1/3))^3*x^2), x, 4, 3/(2*b*(b + a*x^(1/3))^2) + 3/(b^2*(b + a*x^(1/3))) - (3*Log[b + a*x^(1/3)])/b^3 + Log[x]/b^3}
{1/((a + b/x^(1/3))^3*x^3), x, 4, -((3*a^3)/(2*b^4*(b + a*x^(1/3))^2)) - (12*a^3)/(b^5*(b + a*x^(1/3))) - 1/(b^3*x) + (9*a)/(2*b^4*x^(2/3)) - (18*a^2)/(b^5*x^(1/3)) + (30*a^3*Log[b + a*x^(1/3)])/b^6 - (10*a^3*Log[x])/b^6}
{1/((a + b/x^(1/3))^3*x^4), x, 4, (3*a^6)/(2*b^7*(b + a*x^(1/3))^2) + (21*a^6)/(b^8*(b + a*x^(1/3))) - 1/(2*b^3*x^2) + (9*a)/(5*b^4*x^(5/3)) - (9*a^2)/(2*b^5*x^(4/3)) + (10*a^3)/(b^6*x) - (45*a^4)/(2*b^7*x^(2/3)) + (63*a^5)/(b^8*x^(1/3)) - (84*a^6*Log[b + a*x^(1/3)])/b^9 + (28*a^6*Log[x])/b^9}
{1/((a + b/x^(1/3))^3*x^5), x, 4, -((3*a^9)/(2*b^10*(b + a*x^(1/3))^2)) - (30*a^9)/(b^11*(b + a*x^(1/3))) - 1/(3*b^3*x^3) + (9*a)/(8*b^4*x^(8/3)) - (18*a^2)/(7*b^5*x^(7/3)) + (5*a^3)/(b^6*x^2) - (9*a^4)/(b^7*x^(5/3)) + (63*a^5)/(4*b^8*x^(4/3)) - (28*a^6)/(b^9*x) + (54*a^7)/(b^10*x^(2/3)) - (135*a^8)/(b^11*x^(1/3)) + (165*a^9*Log[b + a*x^(1/3)])/b^12 - (55*a^9*Log[x])/b^12}


{1/(1 + b/x^(1/3)), x, 3, 3*b^2*x^(1/3) - (3/2)*b*x^(2/3) + x - 3*b^3*Log[1 + b/x^(1/3)] - b^3*Log[x]}


(* ::Subsection:: *)
(*Integrands of the form x^m (a+b/x^(n/3))^(p/2)*)


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b/x^(n/3))^p*)


(* ::Subsection:: *)
(*Integrands of the form x^(m/2) (a+b/x^(n/3))^(p/2)*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b/x^(n/3))^(p/3)*)


{x^(2/3)*(1 + x^(5/3))^(2/3), x, 1, (9*(1 + x^(5/3))^(5/3))/25}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(m/3) (a+b/x^(n/3))^(p/7)*)


{x^(7/3)*(a^(10/3) - x^(10/3))^(19/7), x, 1, (-21*(a^(10/3) - x^(10/3))^(26/7))/260}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b/x^(n/5))^p*)


{1/(1 + x^(1/5)), x, 3, -5*x^(1/5) + (5*x^(2/5))/2 - (5*x^(3/5))/3 + (5*x^(4/5))/4 + 5*Log[1 + x^(1/5)]}
{1/(Sqrt[1 + x^(4/5)]*x^(1/5)), x, 1, (5*Sqrt[1 + x^(4/5)])/2}


{(a + b/x^(3/5))^(2/3), x, 1, ((a + b/x^(3/5))^(5/3)*x)/a}


(* ::Title::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p when n symbolic*)


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a+b x^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^n)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^3*(a + b*x^n), x, 2, (a*x^4)/4 + (b*x^(4 + n))/(4 + n)}
{x^2*(a + b*x^n), x, 2, (a*x^3)/3 + (b*x^(3 + n))/(3 + n)}
{x^1*(a + b*x^n), x, 2, (a*x^2)/2 + (b*x^(2 + n))/(2 + n)}
{x^0*(a + b*x^n), x, 1, a*x + (b*x^(1 + n))/(1 + n)}
{(a + b*x^n)/x^1, x, 2, (b*x^n)/n + a*Log[x]}
{(a + b*x^n)/x^2, x, 2, -(a/x) - (b*x^(-1 + n))/(1 - n)}
{(a + b*x^n)/x^3, x, 2, -(a/(2*x^2)) - (b*x^(-2 + n))/(2 - n)}


{x^3*(a + b*x^n)^2, x, 2, (a^2*x^4)/4 + (b^2*x^(2*(2 + n)))/(2*(2 + n)) + (2*a*b*x^(4 + n))/(4 + n)}
{x^2*(a + b*x^n)^2, x, 2, (a^2*x^3)/3 + (2*a*b*x^(3 + n))/(3 + n) + (b^2*x^(3 + 2*n))/(3 + 2*n)}
{x^1*(a + b*x^n)^2, x, 2, (a^2*x^2)/2 + (b^2*x^(2*(1 + n)))/(2*(1 + n)) + (2*a*b*x^(2 + n))/(2 + n)}
{x^0*(a + b*x^n)^2, x, 2, a^2*x + (2*a*b*x^(1 + n))/(1 + n) + (b^2*x^(1 + 2*n))/(1 + 2*n)}
{(a + b*x^n)^2/x^1, x, 3, (2*a*b*x^n)/n + (b^2*x^(2*n))/(2*n) + a^2*Log[x]}
{(a + b*x^n)^2/x^2, x, 2, -(a^2/x) - (2*a*b*x^(-1 + n))/(1 - n) - (b^2*x^(-1 + 2*n))/(1 - 2*n)}
{(a + b*x^n)^2/x^3, x, 2, -(a^2/(2*x^2)) - b^2/(x^(2*(1 - n))*(2*(1 - n))) - (2*a*b*x^(-2 + n))/(2 - n)}


{x^3*(a + b*x^n)^3, x, 2, (a^3*x^4)/4 + (3*a*b^2*x^(2*(2 + n)))/(2*(2 + n)) + (3*a^2*b*x^(4 + n))/(4 + n) + (b^3*x^(4 + 3*n))/(4 + 3*n)}
{x^2*(a + b*x^n)^3, x, 2, (a^3*x^3)/3 + (b^3*x^(3*(1 + n)))/(3*(1 + n)) + (3*a^2*b*x^(3 + n))/(3 + n) + (3*a*b^2*x^(3 + 2*n))/(3 + 2*n)}
{x^1*(a + b*x^n)^3, x, 2, (a^3*x^2)/2 + (3*a*b^2*x^(2*(1 + n)))/(2*(1 + n)) + (3*a^2*b*x^(2 + n))/(2 + n) + (b^3*x^(2 + 3*n))/(2 + 3*n)}
{x^0*(a + b*x^n)^3, x, 2, a^3*x + (3*a^2*b*x^(1 + n))/(1 + n) + (3*a*b^2*x^(1 + 2*n))/(1 + 2*n) + (b^3*x^(1 + 3*n))/(1 + 3*n)}
{(a + b*x^n)^3/x^1, x, 3, (3*a^2*b*x^n)/n + (3*a*b^2*x^(2*n))/(2*n) + (b^3*x^(3*n))/(3*n) + a^3*Log[x]}
{(a + b*x^n)^3/x^2, x, 2, -(a^3/x) - (3*a^2*b*x^(-1 + n))/(1 - n) - (3*a*b^2*x^(-1 + 2*n))/(1 - 2*n) - (b^3*x^(-1 + 3*n))/(1 - 3*n)}
{(a + b*x^n)^3/x^3, x, 2, -(a^3/(2*x^2)) - (3*a*b^2)/(x^(2*(1 - n))*(2*(1 - n))) - (3*a^2*b*x^(-2 + n))/(2 - n) - (b^3*x^(-2 + 3*n))/(2 - 3*n)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^1/(a + b*x^n), x, 1, (x^2*Hypergeometric2F1[1, 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a)}
{x^0/(a + b*x^n), x, 1, (x*Hypergeometric2F1[1, 1/n, 1 + 1/n, -((b*x^n)/a)])/a}
{1/(x^1*(a + b*x^n)), x, 4, Log[x]/a - Log[a + b*x^n]/(a*n)}
{1/(x^2*(a + b*x^n)), x, 1, -(Hypergeometric2F1[1, -(1/n), -((1 - n)/n), -((b*x^n)/a)]/(a*x))}
{1/(x^3*(a + b*x^n)), x, 1, -(Hypergeometric2F1[1, -(2/n), -((2 - n)/n), -((b*x^n)/a)]/(2*a*x^2))}


{x^1/(a + b*x^n)^2, x, 1, (x^2*Hypergeometric2F1[2, 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a^2)}
{x^0/(a + b*x^n)^2, x, 1, (x*Hypergeometric2F1[2, 1/n, 1 + 1/n, -((b*x^n)/a)])/a^2}
{1/(x^1*(a + b*x^n)^2), x, 3, 1/(a*n*(a + b*x^n)) + Log[x]/a^2 - Log[a + b*x^n]/(a^2*n)}
{1/(x^2*(a + b*x^n)^2), x, 1, -(Hypergeometric2F1[2, -(1/n), -((1 - n)/n), -((b*x^n)/a)]/(a^2*x))}
{1/(x^3*(a + b*x^n)^2), x, 1, -(Hypergeometric2F1[2, -(2/n), -((2 - n)/n), -((b*x^n)/a)]/(2*a^2*x^2))}


{x^1/(a + b*x^n)^3, x, 1, (x^2*Hypergeometric2F1[3, 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a^3)}
{x^0/(a + b*x^n)^3, x, 1, (x*Hypergeometric2F1[3, 1/n, 1 + 1/n, -((b*x^n)/a)])/a^3}
{1/(x^1*(a + b*x^n)^3), x, 3, 1/(2*a*n*(a + b*x^n)^2) + 1/(a^2*n*(a + b*x^n)) + Log[x]/a^3 - Log[a + b*x^n]/(a^3*n)}
{1/(x^2*(a + b*x^n)^3), x, 1, -(Hypergeometric2F1[3, -(1/n), -((1 - n)/n), -((b*x^n)/a)]/(a^3*x))}
{1/(x^3*(a + b*x^n)^3), x, 1, -(Hypergeometric2F1[3, -(2/n), -((2 - n)/n), -((b*x^n)/a)]/(2*a^3*x^2))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^n)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^1*(a + b*x^n)^(1/2), x, 2, (x^2*(a + b*x^n)^(3/2)*Hypergeometric2F1[1, 3/2 + 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a), (x^2*Sqrt[a + b*x^n]*Hypergeometric2F1[-(1/2), 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*Sqrt[1 + (b*x^n)/a])}
{x^0*(a + b*x^n)^(1/2), x, 2, (x*(a + b*x^n)^(3/2)*Hypergeometric2F1[1, 3/2 + 1/n, 1 + 1/n, -((b*x^n)/a)])/a, (x*Sqrt[a + b*x^n]*Hypergeometric2F1[-(1/2), 1/n, 1 + 1/n, -((b*x^n)/a)])/Sqrt[1 + (b*x^n)/a]}
{(a + b*x^n)^(1/2)/x^1, x, 4, (2*Sqrt[a + b*x^n])/n - (2*Sqrt[a]*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/n}
{(a + b*x^n)^(1/2)/x^2, x, 2, -(((a + b*x^n)^(3/2)*Hypergeometric2F1[1, 3/2 - 1/n, -((1 - n)/n), -((b*x^n)/a)])/(a*x)), -((Sqrt[a + b*x^n]*Hypergeometric2F1[-(1/2), -(1/n), -((1 - n)/n), -((b*x^n)/a)])/(x*Sqrt[1 + (b*x^n)/a]))}
{(a + b*x^n)^(1/2)/x^3, x, 2, -(((a + b*x^n)^(3/2)*Hypergeometric2F1[1, 3/2 - 2/n, -((2 - n)/n), -((b*x^n)/a)])/(2*a*x^2)), -((Sqrt[a + b*x^n]*Hypergeometric2F1[-(1/2), -(2/n), -((2 - n)/n), -((b*x^n)/a)])/(2*x^2*Sqrt[1 + (b*x^n)/a]))}


{x^1*(a + b*x^n)^(3/2), x, 2, (x^2*(a + b*x^n)^(5/2)*Hypergeometric2F1[1, 5/2 + 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a), (a*x^2*Sqrt[a + b*x^n]*Hypergeometric2F1[-(3/2), 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*Sqrt[1 + (b*x^n)/a])}
{x^0*(a + b*x^n)^(3/2), x, 2, (x*(a + b*x^n)^(5/2)*Hypergeometric2F1[1, 5/2 + 1/n, 1 + 1/n, -((b*x^n)/a)])/a, (a*x*Sqrt[a + b*x^n]*Hypergeometric2F1[-(3/2), 1/n, 1 + 1/n, -((b*x^n)/a)])/Sqrt[1 + (b*x^n)/a]}
{(a + b*x^n)^(3/2)/x^1, x, 5, (2*a*Sqrt[a + b*x^n])/n + (2*(a + b*x^n)^(3/2))/(3*n) - (2*a^(3/2)*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/n}
{(a + b*x^n)^(3/2)/x^2, x, 2, -(((a + b*x^n)^(5/2)*Hypergeometric2F1[1, 5/2 - 1/n, -((1 - n)/n), -((b*x^n)/a)])/(a*x)), -((a*Sqrt[a + b*x^n]*Hypergeometric2F1[-(3/2), -(1/n), -((1 - n)/n), -((b*x^n)/a)])/(x*Sqrt[1 + (b*x^n)/a]))}
{(a + b*x^n)^(3/2)/x^3, x, 2, -(((a + b*x^n)^(5/2)*Hypergeometric2F1[1, 5/2 - 2/n, -((2 - n)/n), -((b*x^n)/a)])/(2*a*x^2)), -((a*Sqrt[a + b*x^n]*Hypergeometric2F1[-(3/2), -(2/n), -((2 - n)/n), -((b*x^n)/a)])/(2*x^2*Sqrt[1 + (b*x^n)/a]))}


{x^1*(a + b*x^n)^(5/2), x, 2, (x^2*(a + b*x^n)^(7/2)*Hypergeometric2F1[1, 7/2 + 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a), (a^2*x^2*Sqrt[a + b*x^n]*Hypergeometric2F1[-(5/2), 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*Sqrt[1 + (b*x^n)/a])}
{x^0*(a + b*x^n)^(5/2), x, 2, (x*(a + b*x^n)^(7/2)*Hypergeometric2F1[1, 7/2 + 1/n, 1 + 1/n, -((b*x^n)/a)])/a, (a^2*x*Sqrt[a + b*x^n]*Hypergeometric2F1[-(5/2), 1/n, 1 + 1/n, -((b*x^n)/a)])/Sqrt[1 + (b*x^n)/a]}
{(a + b*x^n)^(5/2)/x^1, x, 6, (2*a^2*Sqrt[a + b*x^n])/n + (2*a*(a + b*x^n)^(3/2))/(3*n) + (2*(a + b*x^n)^(5/2))/(5*n) - (2*a^(5/2)*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/n}
{(a + b*x^n)^(5/2)/x^2, x, 2, -(((a + b*x^n)^(7/2)*Hypergeometric2F1[1, 7/2 - 1/n, -((1 - n)/n), -((b*x^n)/a)])/(a*x)), -((a^2*Sqrt[a + b*x^n]*Hypergeometric2F1[-(5/2), -(1/n), -((1 - n)/n), -((b*x^n)/a)])/(x*Sqrt[1 + (b*x^n)/a]))}
{(a + b*x^n)^(5/2)/x^3, x, 2, -(((a + b*x^n)^(7/2)*Hypergeometric2F1[1, 7/2 - 2/n, -((2 - n)/n), -((b*x^n)/a)])/(2*a*x^2)), -((a^2*Sqrt[a + b*x^n]*Hypergeometric2F1[-(5/2), -(2/n), -((2 - n)/n), -((b*x^n)/a)])/(2*x^2*Sqrt[1 + (b*x^n)/a]))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^1/(a + b*x^n)^(1/2), x, 2, (x^2*Sqrt[a + b*x^n]*Hypergeometric2F1[1, 1/2 + 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a), (x^2*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*Sqrt[a + b*x^n])}
{x^0/(a + b*x^n)^(1/2), x, 2, (x*Sqrt[a + b*x^n]*Hypergeometric2F1[1, 1/2 + 1/n, 1 + 1/n, -((b*x^n)/a)])/a, (x*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, 1/n, 1 + 1/n, -((b*x^n)/a)])/Sqrt[a + b*x^n]}
{1/(x^1*(a + b*x^n)^(1/2)), x, 3, -((2*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(Sqrt[a]*n))}
{1/(x^2*(a + b*x^n)^(1/2)), x, 2, -((Sqrt[a + b*x^n]*Hypergeometric2F1[1, 1/2 - 1/n, -((1 - n)/n), -((b*x^n)/a)])/(a*x)), -((Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, -(1/n), -((1 - n)/n), -((b*x^n)/a)])/(x*Sqrt[a + b*x^n]))}
{1/(x^3*(a + b*x^n)^(1/2)), x, 2, -((Sqrt[a + b*x^n]*Hypergeometric2F1[1, 1/2 - 2/n, -((2 - n)/n), -((b*x^n)/a)])/(2*a*x^2)), -((Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, -(2/n), -((2 - n)/n), -((b*x^n)/a)])/(2*x^2*Sqrt[a + b*x^n]))}


{x^1/(a + b*x^n)^(3/2), x, 2, (x^2*Hypergeometric2F1[1, -(1/2) + 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a*Sqrt[a + b*x^n]), (x^2*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[3/2, 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a*Sqrt[a + b*x^n])}
{x^0/(a + b*x^n)^(3/2), x, 2, (x*Hypergeometric2F1[1, -(1/2) + 1/n, 1 + 1/n, -((b*x^n)/a)])/(a*Sqrt[a + b*x^n]), (x*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[3/2, 1/n, 1 + 1/n, -((b*x^n)/a)])/(a*Sqrt[a + b*x^n])}
{1/(x^1*(a + b*x^n)^(3/2)), x, 4, 2/(a*n*Sqrt[a + b*x^n]) - (2*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(a^(3/2)*n)}
{1/(x^2*(a + b*x^n)^(3/2)), x, 2, -(Hypergeometric2F1[1, -(1/2) - 1/n, -((1 - n)/n), -((b*x^n)/a)]/(a*x*Sqrt[a + b*x^n])), -((Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[3/2, -(1/n), -((1 - n)/n), -((b*x^n)/a)])/(a*x*Sqrt[a + b*x^n]))}
{1/(x^3*(a + b*x^n)^(3/2)), x, 2, -(Hypergeometric2F1[1, -(1/2) - 2/n, -((2 - n)/n), -((b*x^n)/a)]/(2*a*x^2*Sqrt[a + b*x^n])), -((Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[3/2, -(2/n), -((2 - n)/n), -((b*x^n)/a)])/(2*a*x^2*Sqrt[a + b*x^n]))}


{x^1/(a + b*x^n)^(5/2), x, 2, (x^2*Hypergeometric2F1[1, -(3/2) + 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a*(a + b*x^n)^(3/2)), (x^2*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[5/2, 2/n, (2 + n)/n, -((b*x^n)/a)])/(2*a^2*Sqrt[a + b*x^n])}
{x^0/(a + b*x^n)^(5/2), x, 2, (x*Hypergeometric2F1[1, -(3/2) + 1/n, 1 + 1/n, -((b*x^n)/a)])/(a*(a + b*x^n)^(3/2)), (x*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[5/2, 1/n, 1 + 1/n, -((b*x^n)/a)])/(a^2*Sqrt[a + b*x^n])}
{1/(x^1*(a + b*x^n)^(5/2)), x, 5, 2/(3*a*n*(a + b*x^n)^(3/2)) + 2/(a^2*n*Sqrt[a + b*x^n]) - (2*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(a^(5/2)*n)}
{1/(x^2*(a + b*x^n)^(5/2)), x, 2, -(Hypergeometric2F1[1, -(3/2) - 1/n, -((1 - n)/n), -((b*x^n)/a)]/(a*x*(a + b*x^n)^(3/2))), -((Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[5/2, -(1/n), -((1 - n)/n), -((b*x^n)/a)])/(a^2*x*Sqrt[a + b*x^n]))}
{1/(x^3*(a + b*x^n)^(5/2)), x, 2, -(Hypergeometric2F1[1, -(3/2) - 2/n, -((2 - n)/n), -((b*x^n)/a)]/(2*a*x^2*(a + b*x^n)^(3/2))), -((Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[5/2, -(2/n), -((2 - n)/n), -((b*x^n)/a)])/(2*a^2*x^2*Sqrt[a + b*x^n]))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^n)^(p/3)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b*x^n)^(1/3)/x, x, 6, (3*(a + b*x^n)^(1/3))/n - (Sqrt[3]*a^(1/3)*ArcTan[(a^(1/3) + 2*(a + b*x^n)^(1/3))/(Sqrt[3]*a^(1/3))])/n - (1/2)*a^(1/3)*Log[x] + (3*a^(1/3)*Log[a^(1/3) - (a + b*x^n)^(1/3)])/(2*n)}


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(k n-1) (a+b x^n)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(4*n - 1)*(a + b*x^n), x, 2, (a*x^(4*n))/(4*n) + (b*x^(5*n))/(5*n)}
{x^(3*n - 1)*(a + b*x^n), x, 2, (a*x^(3*n))/(3*n) + (b*x^(4*n))/(4*n)}
{x^(2*n - 1)*(a + b*x^n), x, 2, (a*x^(2*n))/(2*n) + (b*x^(3*n))/(3*n)}
{x^(1*n - 1)*(a + b*x^n), x, 2, (a*x^n)/n + (b*x^(2*n))/(2*n)}
{x^(0*n - 1)*(a + b*x^n), x, 2, (b*x^n)/n + a*Log[x]}
{x^(-1*n - 1)*(a + b*x^n), x, 2, -(a/(x^n*n)) + b*Log[x]}
{x^(-2*n - 1)*(a + b*x^n), x, 2, -(a/(x^(2*n)*(2*n))) - b/(x^n*n)}
{x^(-3*n - 1)*(a + b*x^n), x, 2, -(a/(x^(3*n)*(3*n))) - b/(x^(2*n)*(2*n))}
{x^(-4*n - 1)*(a + b*x^n), x, 2, -(a/(x^(4*n)*(4*n))) - b/(x^(3*n)*(3*n))}
{x^(-5*n - 1)*(a + b*x^n), x, 2, -(a/(x^(5*n)*(5*n))) - b/(x^(4*n)*(4*n))}


{x^(4*n - 1)*(a + b*x^n)^2, x, 3, (a^2*x^(4*n))/(4*n) + (2*a*b*x^(5*n))/(5*n) + (b^2*x^(6*n))/(6*n)}
{x^(3*n - 1)*(a + b*x^n)^2, x, 3, (a^2*x^(3*n))/(3*n) + (a*b*x^(4*n))/(2*n) + (b^2*x^(5*n))/(5*n)}
{x^(2*n - 1)*(a + b*x^n)^2, x, 3, (a^2*x^(2*n))/(2*n) + (2*a*b*x^(3*n))/(3*n) + (b^2*x^(4*n))/(4*n)}
{x^(1*n - 1)*(a + b*x^n)^2, x, 1, (a + b*x^n)^3/(3*b*n)}
{x^(0*n - 1)*(a + b*x^n)^2, x, 3, (2*a*b*x^n)/n + (b^2*x^(2*n))/(2*n) + a^2*Log[x]}
{x^(-1*n - 1)*(a + b*x^n)^2, x, 3, -(a^2/(x^n*n)) + (b^2*x^n)/n + 2*a*b*Log[x]}
{x^(-2*n - 1)*(a + b*x^n)^2, x, 3, -(a^2/(x^(2*n)*(2*n))) - (2*a*b)/(x^n*n) + b^2*Log[x]}
{x^(-3*n - 1)*(a + b*x^n)^2, x, 1, -((a + b*x^n)^3/(x^(3*n)*(3*a*n)))}
{x^(-4*n - 1)*(a + b*x^n)^2, x, 3, -(a^2/(x^(4*n)*(4*n))) - (2*a*b)/(x^(3*n)*(3*n)) - b^2/(x^(2*n)*(2*n))}
{x^(-5*n - 1)*(a + b*x^n)^2, x, 3, -(a^2/(x^(5*n)*(5*n))) - (a*b)/(x^(4*n)*(2*n)) - b^2/(x^(3*n)*(3*n))}
{x^(-6*n - 1)*(a + b*x^n)^2, x, 3, -(a^2/(x^(6*n)*(6*n))) - (2*a*b)/(x^(5*n)*(5*n)) - b^2/(x^(4*n)*(4*n))}


{x^(4*n - 1)*(a + b*x^n)^3, x, 3, (a^3*x^(4*n))/(4*n) + (3*a^2*b*x^(5*n))/(5*n) + (a*b^2*x^(6*n))/(2*n) + (b^3*x^(7*n))/(7*n)}
{x^(3*n - 1)*(a + b*x^n)^3, x, 3, (a^3*x^(3*n))/(3*n) + (3*a^2*b*x^(4*n))/(4*n) + (3*a*b^2*x^(5*n))/(5*n) + (b^3*x^(6*n))/(6*n)}
{x^(2*n - 1)*(a + b*x^n)^3, x, 3, -((a*(a + b*x^n)^4)/(4*b^2*n)) + (a + b*x^n)^5/(5*b^2*n)}
{x^(1*n - 1)*(a + b*x^n)^3, x, 1, (a + b*x^n)^4/(4*b*n)}
{x^(0*n - 1)*(a + b*x^n)^3, x, 3, (3*a^2*b*x^n)/n + (3*a*b^2*x^(2*n))/(2*n) + (b^3*x^(3*n))/(3*n) + a^3*Log[x]}
{x^(-1*n - 1)*(a + b*x^n)^3, x, 3, -(a^3/(x^n*n)) + (3*a*b^2*x^n)/n + (b^3*x^(2*n))/(2*n) + 3*a^2*b*Log[x]}
{x^(-2*n - 1)*(a + b*x^n)^3, x, 3, -(a^3/(x^(2*n)*(2*n))) - (3*a^2*b)/(x^n*n) + (b^3*x^n)/n + 3*a*b^2*Log[x]}
{x^(-3*n - 1)*(a + b*x^n)^3, x, 3, -(a^3/(x^(3*n)*(3*n))) - (3*a^2*b)/(x^(2*n)*(2*n)) - (3*a*b^2)/(x^n*n) + b^3*Log[x]}
{x^(-4*n - 1)*(a + b*x^n)^3, x, 1, -((a + b*x^n)^4/(x^(4*n)*(4*a*n)))}
{x^(-5*n - 1)*(a + b*x^n)^3, x, 3, -((a + b*x^n)^4/(x^(5*n)*(5*a*n))) + (b*(a + b*x^n)^4)/(x^(4*n)*(20*a^2*n))}
{x^(-6*n - 1)*(a + b*x^n)^3, x, 3, -(a^3/(x^(6*n)*(6*n))) - (3*a^2*b)/(x^(5*n)*(5*n)) - (3*a*b^2)/(x^(4*n)*(4*n)) - b^3/(x^(3*n)*(3*n))}
{x^(-7*n - 1)*(a + b*x^n)^3, x, 3, -(a^3/(x^(7*n)*(7*n))) - (a^2*b)/(x^(6*n)*(2*n)) - (3*a*b^2)/(x^(5*n)*(5*n)) - b^3/(x^(4*n)*(4*n))}


{x^(4*n - 1)*(a + b*x^n)^5, x, 3, -((a^3*(a + b*x^n)^6)/(6*b^4*n)) + (3*a^2*(a + b*x^n)^7)/(7*b^4*n) - (3*a*(a + b*x^n)^8)/(8*b^4*n) + (a + b*x^n)^9/(9*b^4*n)}
{x^(3*n - 1)*(a + b*x^n)^5, x, 3, (a^2*(a + b*x^n)^6)/(6*b^3*n) - (2*a*(a + b*x^n)^7)/(7*b^3*n) + (a + b*x^n)^8/(8*b^3*n)}
{x^(2*n - 1)*(a + b*x^n)^5, x, 3, -((a*(a + b*x^n)^6)/(6*b^2*n)) + (a + b*x^n)^7/(7*b^2*n)}
{x^(1*n - 1)*(a + b*x^n)^5, x, 1, (a + b*x^n)^6/(6*b*n)}
{x^(0*n - 1)*(a + b*x^n)^5, x, 3, (5*a^4*b*x^n)/n + (5*a^3*b^2*x^(2*n))/n + (10*a^2*b^3*x^(3*n))/(3*n) + (5*a*b^4*x^(4*n))/(4*n) + (b^5*x^(5*n))/(5*n) + a^5*Log[x]}
{x^(-1*n - 1)*(a + b*x^n)^5, x, 3, -(a^5/(x^n*n)) + (10*a^3*b^2*x^n)/n + (5*a^2*b^3*x^(2*n))/n + (5*a*b^4*x^(3*n))/(3*n) + (b^5*x^(4*n))/(4*n) + 5*a^4*b*Log[x]}
{x^(-2*n - 1)*(a + b*x^n)^5, x, 3, -(a^5/(x^(2*n)*(2*n))) - (5*a^4*b)/(x^n*n) + (10*a^2*b^3*x^n)/n + (5*a*b^4*x^(2*n))/(2*n) + (b^5*x^(3*n))/(3*n) + 10*a^3*b^2*Log[x]}
{x^(-3*n - 1)*(a + b*x^n)^5, x, 3, -(a^5/(x^(3*n)*(3*n))) - (5*a^4*b)/(x^(2*n)*(2*n)) - (10*a^3*b^2)/(x^n*n) + (5*a*b^4*x^n)/n + (b^5*x^(2*n))/(2*n) + 10*a^2*b^3*Log[x]}
{x^(-4*n - 1)*(a + b*x^n)^5, x, 3, -(a^5/(x^(4*n)*(4*n))) - (5*a^4*b)/(x^(3*n)*(3*n)) - (5*a^3*b^2)/(x^(2*n)*n) - (10*a^2*b^3)/(x^n*n) + (b^5*x^n)/n + 5*a*b^4*Log[x]}
{x^(-5*n - 1)*(a + b*x^n)^5, x, 3, -(a^5/(x^(5*n)*(5*n))) - (5*a^4*b)/(x^(4*n)*(4*n)) - (10*a^3*b^2)/(x^(3*n)*(3*n)) - (5*a^2*b^3)/(x^(2*n)*n) - (5*a*b^4)/(x^n*n) + b^5*Log[x]}
{x^(-6*n - 1)*(a + b*x^n)^5, x, 1, -((a + b*x^n)^6/(x^(6*n)*(6*a*n)))}
{x^(-7*n - 1)*(a + b*x^n)^5, x, 3, -((a + b*x^n)^6/(x^(7*n)*(7*a*n))) + (b*(a + b*x^n)^6)/(x^(6*n)*(42*a^2*n))}
{x^(-8*n - 1)*(a + b*x^n)^5, x, 4, -((a + b*x^n)^6/(x^(8*n)*(8*a*n))) + (b*(a + b*x^n)^6)/(x^(7*n)*(28*a^2*n)) - (b^2*(a + b*x^n)^6)/(x^(6*n)*(168*a^3*n))}
{x^(-9*n - 1)*(a + b*x^n)^5, x, 3, -(a^5/(x^(9*n)*(9*n))) - (5*a^4*b)/(x^(8*n)*(8*n)) - (10*a^3*b^2)/(x^(7*n)*(7*n)) - (5*a^2*b^3)/(x^(6*n)*(3*n)) - (a*b^4)/(x^(5*n)*n) - b^5/(x^(4*n)*(4*n))}
{x^(-10*n - 1)*(a + b*x^n)^5, x, 3, -(a^5/(x^(10*n)*(10*n))) - (5*a^4*b)/(x^(9*n)*(9*n)) - (5*a^3*b^2)/(x^(8*n)*(4*n)) - (10*a^2*b^3)/(x^(7*n)*(7*n)) - (5*a*b^4)/(x^(6*n)*(6*n)) - b^5/(x^(5*n)*(5*n))}


{x^(9*n - 1)*(a + b*x^n)^8, x, 3, (a^8*x^(9*n))/(9*n) + (4*a^7*b*x^(10*n))/(5*n) + (28*a^6*b^2*x^(11*n))/(11*n) + (14*a^5*b^3*x^(12*n))/(3*n) + (70*a^4*b^4*x^(13*n))/(13*n) + (4*a^3*b^5*x^(14*n))/n + (28*a^2*b^6*x^(15*n))/(15*n) + (a*b^7*x^(16*n))/(2*n) + (b^8*x^(17*n))/(17*n)}
{x^(8*n - 1)*(a + b*x^n)^8, x, 3, (a^8*x^(8*n))/(8*n) + (8*a^7*b*x^(9*n))/(9*n) + (14*a^6*b^2*x^(10*n))/(5*n) + (56*a^5*b^3*x^(11*n))/(11*n) + (35*a^4*b^4*x^(12*n))/(6*n) + (56*a^3*b^5*x^(13*n))/(13*n) + (2*a^2*b^6*x^(14*n))/n + (8*a*b^7*x^(15*n))/(15*n) + (b^8*x^(16*n))/(16*n)}
{x^(7*n - 1)*(a + b*x^n)^8, x, 3, (a^6*(a + b*x^n)^9)/(9*b^7*n) - (3*a^5*(a + b*x^n)^10)/(5*b^7*n) + (15*a^4*(a + b*x^n)^11)/(11*b^7*n) - (5*a^3*(a + b*x^n)^12)/(3*b^7*n) + (15*a^2*(a + b*x^n)^13)/(13*b^7*n) - (3*a*(a + b*x^n)^14)/(7*b^7*n) + (a + b*x^n)^15/(15*b^7*n)}
{x^(6*n - 1)*(a + b*x^n)^8, x, 3, -((a^5*(a + b*x^n)^9)/(9*b^6*n)) + (a^4*(a + b*x^n)^10)/(2*b^6*n) - (10*a^3*(a + b*x^n)^11)/(11*b^6*n) + (5*a^2*(a + b*x^n)^12)/(6*b^6*n) - (5*a*(a + b*x^n)^13)/(13*b^6*n) + (a + b*x^n)^14/(14*b^6*n)}
{x^(5*n - 1)*(a + b*x^n)^8, x, 3, (a^4*(a + b*x^n)^9)/(9*b^5*n) - (2*a^3*(a + b*x^n)^10)/(5*b^5*n) + (6*a^2*(a + b*x^n)^11)/(11*b^5*n) - (a*(a + b*x^n)^12)/(3*b^5*n) + (a + b*x^n)^13/(13*b^5*n)}
{x^(4*n - 1)*(a + b*x^n)^8, x, 3, -((a^3*(a + b*x^n)^9)/(9*b^4*n)) + (3*a^2*(a + b*x^n)^10)/(10*b^4*n) - (3*a*(a + b*x^n)^11)/(11*b^4*n) + (a + b*x^n)^12/(12*b^4*n)}
{x^(3*n - 1)*(a + b*x^n)^8, x, 3, (a^2*(a + b*x^n)^9)/(9*b^3*n) - (a*(a + b*x^n)^10)/(5*b^3*n) + (a + b*x^n)^11/(11*b^3*n)}
{x^(2*n - 1)*(a + b*x^n)^8, x, 3, -((a*(a + b*x^n)^9)/(9*b^2*n)) + (a + b*x^n)^10/(10*b^2*n)}
{x^(1*n - 1)*(a + b*x^n)^8, x, 1, (a + b*x^n)^9/(9*b*n)}
{x^(0*n - 1)*(a + b*x^n)^8, x, 3, (8*a^7*b*x^n)/n + (14*a^6*b^2*x^(2*n))/n + (56*a^5*b^3*x^(3*n))/(3*n) + (35*a^4*b^4*x^(4*n))/(2*n) + (56*a^3*b^5*x^(5*n))/(5*n) + (14*a^2*b^6*x^(6*n))/(3*n) + (8*a*b^7*x^(7*n))/(7*n) + (b^8*x^(8*n))/(8*n) + a^8*Log[x]}
{x^(-1*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^n*n)) + (28*a^6*b^2*x^n)/n + (28*a^5*b^3*x^(2*n))/n + (70*a^4*b^4*x^(3*n))/(3*n) + (14*a^3*b^5*x^(4*n))/n + (28*a^2*b^6*x^(5*n))/(5*n) + (4*a*b^7*x^(6*n))/(3*n) + (b^8*x^(7*n))/(7*n) + 8*a^7*b*Log[x]}
{x^(-2*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(2*n)*(2*n))) - (8*a^7*b)/(x^n*n) + (56*a^5*b^3*x^n)/n + (35*a^4*b^4*x^(2*n))/n + (56*a^3*b^5*x^(3*n))/(3*n) + (7*a^2*b^6*x^(4*n))/n + (8*a*b^7*x^(5*n))/(5*n) + (b^8*x^(6*n))/(6*n) + 28*a^6*b^2*Log[x]}
{x^(-3*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(3*n)*(3*n))) - (4*a^7*b)/(x^(2*n)*n) - (28*a^6*b^2)/(x^n*n) + (70*a^4*b^4*x^n)/n + (28*a^3*b^5*x^(2*n))/n + (28*a^2*b^6*x^(3*n))/(3*n) + (2*a*b^7*x^(4*n))/n + (b^8*x^(5*n))/(5*n) + 56*a^5*b^3*Log[x]}
{x^(-4*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(4*n)*(4*n))) - (8*a^7*b)/(x^(3*n)*(3*n)) - (14*a^6*b^2)/(x^(2*n)*n) - (56*a^5*b^3)/(x^n*n) + (56*a^3*b^5*x^n)/n + (14*a^2*b^6*x^(2*n))/n + (8*a*b^7*x^(3*n))/(3*n) + (b^8*x^(4*n))/(4*n) + 70*a^4*b^4*Log[x]}
{x^(-5*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(5*n)*(5*n))) - (2*a^7*b)/(x^(4*n)*n) - (28*a^6*b^2)/(x^(3*n)*(3*n)) - (28*a^5*b^3)/(x^(2*n)*n) - (70*a^4*b^4)/(x^n*n) + (28*a^2*b^6*x^n)/n + (4*a*b^7*x^(2*n))/n + (b^8*x^(3*n))/(3*n) + 56*a^3*b^5*Log[x]}
{x^(-6*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(6*n)*(6*n))) - (8*a^7*b)/(x^(5*n)*(5*n)) - (7*a^6*b^2)/(x^(4*n)*n) - (56*a^5*b^3)/(x^(3*n)*(3*n)) - (35*a^4*b^4)/(x^(2*n)*n) - (56*a^3*b^5)/(x^n*n) + (8*a*b^7*x^n)/n + (b^8*x^(2*n))/(2*n) + 28*a^2*b^6*Log[x]}
{x^(-7*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(7*n)*(7*n))) - (4*a^7*b)/(x^(6*n)*(3*n)) - (28*a^6*b^2)/(x^(5*n)*(5*n)) - (14*a^5*b^3)/(x^(4*n)*n) - (70*a^4*b^4)/(x^(3*n)*(3*n)) - (28*a^3*b^5)/(x^(2*n)*n) - (28*a^2*b^6)/(x^n*n) + (b^8*x^n)/n + 8*a*b^7*Log[x]}
{x^(-8*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(8*n)*(8*n))) - (8*a^7*b)/(x^(7*n)*(7*n)) - (14*a^6*b^2)/(x^(6*n)*(3*n)) - (56*a^5*b^3)/(x^(5*n)*(5*n)) - (35*a^4*b^4)/(x^(4*n)*(2*n)) - (56*a^3*b^5)/(x^(3*n)*(3*n)) - (14*a^2*b^6)/(x^(2*n)*n) - (8*a*b^7)/(x^n*n) + b^8*Log[x]}
{x^(-9*n - 1)*(a + b*x^n)^8, x, 1, -((a + b*x^n)^9/(x^(9*n)*(9*a*n)))}
{x^(-10*n - 1)*(a + b*x^n)^8, x, 3, -((a + b*x^n)^9/(x^(10*n)*(10*a*n))) + (b*(a + b*x^n)^9)/(x^(9*n)*(90*a^2*n))}
{x^(-11*n - 1)*(a + b*x^n)^8, x, 4, -((a + b*x^n)^9/(x^(11*n)*(11*a*n))) + (b*(a + b*x^n)^9)/(x^(10*n)*(55*a^2*n)) - (b^2*(a + b*x^n)^9)/(x^(9*n)*(495*a^3*n))}
{x^(-12*n - 1)*(a + b*x^n)^8, x, 5, -((a + b*x^n)^9/(x^(12*n)*(12*a*n))) + (b*(a + b*x^n)^9)/(x^(11*n)*(44*a^2*n)) - (b^2*(a + b*x^n)^9)/(x^(10*n)*(220*a^3*n)) + (b^3*(a + b*x^n)^9)/(x^(9*n)*(1980*a^4*n))}
{x^(-13*n - 1)*(a + b*x^n)^8, x, 6, -((a + b*x^n)^9/(x^(13*n)*(13*a*n))) + (b*(a + b*x^n)^9)/(x^(12*n)*(39*a^2*n)) - (b^2*(a + b*x^n)^9)/(x^(11*n)*(143*a^3*n)) + (b^3*(a + b*x^n)^9)/(x^(10*n)*(715*a^4*n)) - (b^4*(a + b*x^n)^9)/(x^(9*n)*(6435*a^5*n))}
{x^(-14*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(14*n)*(14*n))) - (8*a^7*b)/(x^(13*n)*(13*n)) - (7*a^6*b^2)/(x^(12*n)*(3*n)) - (56*a^5*b^3)/(x^(11*n)*(11*n)) - (7*a^4*b^4)/(x^(10*n)*n) - (56*a^3*b^5)/(x^(9*n)*(9*n)) - (7*a^2*b^6)/(x^(8*n)*(2*n)) - (8*a*b^7)/(x^(7*n)*(7*n)) - b^8/(x^(6*n)*(6*n))}
{x^(-15*n - 1)*(a + b*x^n)^8, x, 3, -(a^8/(x^(15*n)*(15*n))) - (4*a^7*b)/(x^(14*n)*(7*n)) - (28*a^6*b^2)/(x^(13*n)*(13*n)) - (14*a^5*b^3)/(x^(12*n)*(3*n)) - (70*a^4*b^4)/(x^(11*n)*(11*n)) - (28*a^3*b^5)/(x^(10*n)*(5*n)) - (28*a^2*b^6)/(x^(9*n)*(9*n)) - (a*b^7)/(x^(8*n)*n) - b^8/(x^(7*n)*(7*n))}


{x^(n - 1)*(a + b*x^n)^16, x, 1, (a + b*x^n)^17/(17*b*n)}


{x^12*(a + b*x^13)^12, x, 1, (a + b*x^13)^13/(169*b)}
{x^24*(a + b*x^25)^12, x, 1, (a + b*x^25)^13/(325*b)}
{x^36*(a + b*x^37)^12, x, 1, (a + b*x^37)^13/(481*b)}
{x^(12*m)*(a + b*x^(12*m + 1))^12, x, 1, (a + b*x^(1 + 12*m))^13/(13*b*(1 + 12*m))}

(* Need to detect that degree of nomomial simplifies to 12*m so integrand is not be expanded! *)
{x^(12 + 12*(m - 1))*(a + b*x^(12*m + 1))^12, x, 1, (a + b*x^(1 + 12*m))^13/(13*b*(1 + 12*m))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(5*n - 1)/(a + b*x^n), x, 3, -((a^3*x^n)/(b^4*n)) + (a^2*x^(2*n))/(2*b^3*n) - (a*x^(3*n))/(3*b^2*n) + x^(4*n)/(4*b*n) + (a^4*Log[a + b*x^n])/(b^5*n)}
{x^(4*n - 1)/(a + b*x^n), x, 3, (a^2*x^n)/(b^3*n) - (a*x^(2*n))/(2*b^2*n) + x^(3*n)/(3*b*n) - (a^3*Log[a + b*x^n])/(b^4*n)}
{x^(3*n - 1)/(a + b*x^n), x, 3, -((a*x^n)/(b^2*n)) + x^(2*n)/(2*b*n) + (a^2*Log[a + b*x^n])/(b^3*n)}
{x^(2*n - 1)/(a + b*x^n), x, 3, x^n/(b*n) - (a*Log[a + b*x^n])/(b^2*n)}
{x^(1*n - 1)/(a + b*x^n), x, 1, Log[a + b*x^n]/(b*n)}
{x^(0*n - 1)/(a + b*x^n), x, 4, Log[x]/a - Log[a + b*x^n]/(a*n)}
{x^(-1*n - 1)/(a + b*x^n), x, 3, -(1/(x^n*(a*n))) - (b*Log[x])/a^2 + (b*Log[a + b*x^n])/(a^2*n)}
{x^(-2*n - 1)/(a + b*x^n), x, 3, -(1/(x^(2*n)*(2*a*n))) + b/(x^n*(a^2*n)) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x^n])/(a^3*n)}
{x^(-3*n - 1)/(a + b*x^n), x, 3, -(1/(x^(3*n)*(3*a*n))) + b/(x^(2*n)*(2*a^2*n)) - b^2/(x^n*(a^3*n)) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x^n])/(a^4*n)}


(* Note: Requires simplification of the exponent of the monomial. *)
{x^(5*(n - 1) + 4)/(a + b*x^n), x, 3, -((a^3*x^n)/(b^4*n)) + (a^2*x^(2*n))/(2*b^3*n) - (a*x^(3*n))/(3*b^2*n) + x^(4*n)/(4*b*n) + (a^4*Log[a + b*x^n])/(b^5*n)}
{x^(4*(n - 1) + 3)/(a + b*x^n), x, 3, (a^2*x^n)/(b^3*n) - (a*x^(2*n))/(2*b^2*n) + x^(3*n)/(3*b*n) - (a^3*Log[a + b*x^n])/(b^4*n)}
{x^(3*(n - 1) + 2)/(a + b*x^n), x, 3, -((a*x^n)/(b^2*n)) + x^(2*n)/(2*b*n) + (a^2*Log[a + b*x^n])/(b^3*n)}
{x^(2*(n - 1) + 1)/(a + b*x^n), x, 3, x^n/(b*n) - (a*Log[a + b*x^n])/(b^2*n)}
{x^(1*(n - 1) + 0)/(a + b*x^n), x, 1, Log[a + b*x^n]/(b*n)}
{x^(0*(n - 1) - 1)/(a + b*x^n), x, 4, Log[x]/a - Log[a + b*x^n]/(a*n)}
{x^(-1*(n - 1) - 2)/(a + b*x^n), x, 3, -(1/(x^n*(a*n))) - (b*Log[x])/a^2 + (b*Log[a + b*x^n])/(a^2*n)}
{x^(-2*(n - 1) - 3)/(a + b*x^n), x, 3, -(1/(x^(2*n)*(2*a*n))) + b/(x^n*(a^2*n)) + (b^2*Log[x])/a^3 - (b^2*Log[a + b*x^n])/(a^3*n)}
{x^(-3*(n - 1) - 4)/(a + b*x^n), x, 3, -(1/(x^(3*n)*(3*a*n))) + b/(x^(2*n)*(2*a^2*n)) - b^2/(x^n*(a^3*n)) - (b^3*Log[x])/a^4 + (b^3*Log[a + b*x^n])/(a^4*n)}


{x^(5*n - 1)/(2 + b*x^n), x, 3, -((8*x^n)/(b^4*n)) + (2*x^(2*n))/(b^3*n) - (2*x^(3*n))/(3*b^2*n) + x^(4*n)/(4*b*n) + (16*Log[2 + b*x^n])/(b^5*n)}
{x^(4*n - 1)/(2 + b*x^n), x, 3, (4*x^n)/(b^3*n) - x^(2*n)/(b^2*n) + x^(3*n)/(3*b*n) - (8*Log[2 + b*x^n])/(b^4*n)}
{x^(3*n - 1)/(2 + b*x^n), x, 3, -((2*x^n)/(b^2*n)) + x^(2*n)/(2*b*n) + (4*Log[2 + b*x^n])/(b^3*n)}
{x^(2*n - 1)/(2 + b*x^n), x, 3, x^n/(b*n) - (2*Log[2 + b*x^n])/(b^2*n)}
{x^(1*n - 1)/(2 + b*x^n), x, 1, Log[2 + b*x^n]/(b*n)}
{x^(0*n - 1)/(2 + b*x^n), x, 4, Log[x]/2 - Log[2 + b*x^n]/(2*n)}
{x^(-1*n - 1)/(2 + b*x^n), x, 3, -(1/(x^n*(2*n))) - (1/4)*b*Log[x] + (b*Log[2 + b*x^n])/(4*n)}
{x^(-2*n - 1)/(2 + b*x^n), x, 3, -(1/(x^(2*n)*(4*n))) + b/(x^n*(4*n)) + (1/8)*b^2*Log[x] - (b^2*Log[2 + b*x^n])/(8*n)}
{x^(-3*n - 1)/(2 + b*x^n), x, 3, -(1/(x^(3*n)*(6*n))) + b/(x^(2*n)*(8*n)) - b^2/(x^n*(8*n)) - (1/16)*b^3*Log[x] + (b^3*Log[2 + b*x^n])/(16*n)}


{x^(4*n - 1)/(a + b*x^n)^2, x, 3, -((2*a*x^n)/(b^3*n)) + x^(2*n)/(2*b^2*n) + a^3/(b^4*n*(a + b*x^n)) + (3*a^2*Log[a + b*x^n])/(b^4*n)}
{x^(3*n - 1)/(a + b*x^n)^2, x, 3, x^n/(b^2*n) - a^2/(b^3*n*(a + b*x^n)) - (2*a*Log[a + b*x^n])/(b^3*n)}
{x^(2*n - 1)/(a + b*x^n)^2, x, 3, a/(b^2*n*(a + b*x^n)) + Log[a + b*x^n]/(b^2*n)}
{x^(1*n - 1)/(a + b*x^n)^2, x, 1, -(1/(b*n*(a + b*x^n)))}
{x^(0*n - 1)/(a + b*x^n)^2, x, 3, 1/(a*n*(a + b*x^n)) + Log[x]/a^2 - Log[a + b*x^n]/(a^2*n)}
{x^(-1*n - 1)/(a + b*x^n)^2, x, 3, -(1/(x^n*(a^2*n))) - b/(a^2*n*(a + b*x^n)) - (2*b*Log[x])/a^3 + (2*b*Log[a + b*x^n])/(a^3*n)}
{x^(-2*n - 1)/(a + b*x^n)^2, x, 3, -(1/(x^(2*n)*(2*a^2*n))) + (2*b)/(x^n*(a^3*n)) + b^2/(a^3*n*(a + b*x^n)) + (3*b^2*Log[x])/a^4 - (3*b^2*Log[a + b*x^n])/(a^4*n)}
{x^(-3*n - 1)/(a + b*x^n)^2, x, 3, -(1/(x^(3*n)*(3*a^2*n))) + b/(x^(2*n)*(a^3*n)) - (3*b^2)/(x^n*(a^4*n)) - b^3/(a^4*n*(a + b*x^n)) - (4*b^3*Log[x])/a^5 + (4*b^3*Log[a + b*x^n])/(a^5*n)}


{x^(4*n - 1)/(a + b*x^n)^3, x, 3, x^n/(b^3*n) + a^3/(2*b^4*n*(a + b*x^n)^2) - (3*a^2)/(b^4*n*(a + b*x^n)) - (3*a*Log[a + b*x^n])/(b^4*n)}
{x^(3*n - 1)/(a + b*x^n)^3, x, 3, -(a^2/(2*b^3*n*(a + b*x^n)^2)) + (2*a)/(b^3*n*(a + b*x^n)) + Log[a + b*x^n]/(b^3*n)}
{x^(2*n - 1)/(a + b*x^n)^3, x, 1, x^(2*n)/(2*a*n*(a + b*x^n)^2)}
{x^(1*n - 1)/(a + b*x^n)^3, x, 1, -(1/(2*b*n*(a + b*x^n)^2))}
{x^(0*n - 1)/(a + b*x^n)^3, x, 3, 1/(2*a*n*(a + b*x^n)^2) + 1/(a^2*n*(a + b*x^n)) + Log[x]/a^3 - Log[a + b*x^n]/(a^3*n)}
{x^(-1*n - 1)/(a + b*x^n)^3, x, 3, -(1/(x^n*(a^3*n))) - b/(2*a^2*n*(a + b*x^n)^2) - (2*b)/(a^3*n*(a + b*x^n)) - (3*b*Log[x])/a^4 + (3*b*Log[a + b*x^n])/(a^4*n)}
{x^(-2*n - 1)/(a + b*x^n)^3, x, 3, -(1/(x^(2*n)*(2*a^3*n))) + (3*b)/(x^n*(a^4*n)) + b^2/(2*a^3*n*(a + b*x^n)^2) + (3*b^2)/(a^4*n*(a + b*x^n)) + (6*b^2*Log[x])/a^5 - (6*b^2*Log[a + b*x^n])/(a^5*n)}


{x^(-1 - 1*n/2)/(a + b*x^n), x, 4, -(2/(x^(n/2)*(a*n))) + (2*Sqrt[b]*ArcTan[Sqrt[a]/(x^(n/2)*Sqrt[b])])/(a^(3/2)*n)}
{x^(-1 - 2*n/3)/(a + b*x^n), x, 8, -(3/(x^((2*n)/3)*(2*a*n))) + (Sqrt[3]*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(n/3))/(Sqrt[3]*a^(1/3))])/(a^(5/3)*n) - (b^(2/3)*Log[a^(1/3) + b^(1/3)*x^(n/3)])/(a^(5/3)*n) + (b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(n/3) + b^(2/3)*x^((2*n)/3)])/(2*a^(5/3)*n)}
{x^(-1 - 3*n/4)/(a + b*x^n), x, 11, -(4/(x^((3*n)/4)*(3*a*n))) + (Sqrt[2]*b^(3/4)*ArcTan[1 - (Sqrt[2]*b^(1/4)*x^(n/4))/a^(1/4)])/(a^(7/4)*n) - (Sqrt[2]*b^(3/4)*ArcTan[1 + (Sqrt[2]*b^(1/4)*x^(n/4))/a^(1/4)])/(a^(7/4)*n) + (b^(3/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x^(n/4) + Sqrt[b]*x^(n/2)])/(Sqrt[2]*a^(7/4)*n) - (b^(3/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x^(n/4) + Sqrt[b]*x^(n/2)])/(Sqrt[2]*a^(7/4)*n)}


{x^(-1 - n/1)/(a + b*x^n), x, 3, -(1/(x^n*(a*n))) - (b*Log[x])/a^2 + (b*Log[a + b*x^n])/(a^2*n)}
{x^(-1 - n/2)/(a + b*x^n), x, 4, -(2/(x^(n/2)*(a*n))) + (2*Sqrt[b]*ArcTan[Sqrt[a]/(x^(n/2)*Sqrt[b])])/(a^(3/2)*n)}
{x^(-1 - n/3)/(a + b*x^n), x, 9, -(3/(x^(n/3)*(a*n))) - (Sqrt[3]*b^(1/3)*ArcTan[(b^(1/3) - (2*a^(1/3))/x^(n/3))/(Sqrt[3]*b^(1/3))])/(a^(4/3)*n) + (b^(1/3)*Log[b^(1/3) + a^(1/3)/x^(n/3)])/(a^(4/3)*n) - (b^(1/3)*Log[b^(2/3) + a^(2/3)/x^((2*n)/3) - (a^(1/3)*b^(1/3))/x^(n/3)])/(2*a^(4/3)*n)}
{x^(-1 - n/4)/(a + b*x^n), x, 12, -(4/(x^(n/4)*(a*n))) - (Sqrt[2]*b^(1/4)*ArcTan[1 - (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/(a^(5/4)*n) + (Sqrt[2]*b^(1/4)*ArcTan[1 + (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/(a^(5/4)*n) - (b^(1/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) - (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/(Sqrt[2]*a^(5/4)*n) + (b^(1/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) + (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/(Sqrt[2]*a^(5/4)*n)}


{x^(-1 - 3*n/2)/(a + b*x^n), x, 5, -(2/(x^((3*n)/2)*(3*a*n))) + (2*b)/(x^(n/2)*(a^2*n)) - (2*b^(3/2)*ArcTan[Sqrt[a]/(x^(n/2)*Sqrt[b])])/(a^(5/2)*n)}
{x^(-1 - 4*n/3)/(a + b*x^n), x, 10, If[$VersionNumber>=8, -(3/(x^((4*n)/3)*(4*a*n))) + (3*b)/(x^(n/3)*(a^2*n)) + (Sqrt[3]*b^(4/3)*ArcTan[(b^(1/3) - (2*a^(1/3))/x^(n/3))/(Sqrt[3]*b^(1/3))])/(a^(7/3)*n) - (b^(4/3)*Log[b^(1/3) + a^(1/3)/x^(n/3)])/(a^(7/3)*n) + (b^(4/3)*Log[b^(2/3) + a^(2/3)/x^((2*n)/3) - (a^(1/3)*b^(1/3))/x^(n/3)])/(2*a^(7/3)*n), -(3/(x^((4*n)/3)*(4*a*n))) + (3*b)/(x^(n/3)*(a^2*n)) + (Sqrt[3]*b^(4/3)*ArcTan[(1 - (2*a^(1/3))/(x^(n/3)*b^(1/3)))/Sqrt[3]])/(a^(7/3)*n) - (b^(4/3)*Log[b^(1/3) + a^(1/3)/x^(n/3)])/(a^(7/3)*n) + (b^(4/3)*Log[b^(2/3) + a^(2/3)/x^((2*n)/3) - (a^(1/3)*b^(1/3))/x^(n/3)])/(2*a^(7/3)*n)]}
{x^(-1 - 5*n/4)/(a + b*x^n), x, 13, -(4/(x^((5*n)/4)*(5*a*n))) + (4*b)/(x^(n/4)*(a^2*n)) + (Sqrt[2]*b^(5/4)*ArcTan[1 - (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/(a^(9/4)*n) - (Sqrt[2]*b^(5/4)*ArcTan[1 + (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/(a^(9/4)*n) + (b^(5/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) - (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/(Sqrt[2]*a^(9/4)*n) - (b^(5/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) + (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/(Sqrt[2]*a^(9/4)*n)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^(k n-1) (a+b x^n)^(p/2)*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{x^(4*n - 1)*(a + b*x^n)^(1/2), x, 3, -((2*a^3*(a + b*x^n)^(3/2))/(3*b^4*n)) + (6*a^2*(a + b*x^n)^(5/2))/(5*b^4*n) - (6*a*(a + b*x^n)^(7/2))/(7*b^4*n) + (2*(a + b*x^n)^(9/2))/(9*b^4*n)}
{x^(3*n - 1)*(a + b*x^n)^(1/2), x, 3, (2*a^2*(a + b*x^n)^(3/2))/(3*b^3*n) - (4*a*(a + b*x^n)^(5/2))/(5*b^3*n) + (2*(a + b*x^n)^(7/2))/(7*b^3*n)}
{x^(2*n - 1)*(a + b*x^n)^(1/2), x, 3, -((2*a*(a + b*x^n)^(3/2))/(3*b^2*n)) + (2*(a + b*x^n)^(5/2))/(5*b^2*n)}
{x^(1*n - 1)*(a + b*x^n)^(1/2), x, 1, (2*(a + b*x^n)^(3/2))/(3*b*n)}
{x^(0*n - 1)*(a + b*x^n)^(1/2), x, 4, (2*Sqrt[a + b*x^n])/n - (2*Sqrt[a]*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/n}
{x^(-1*n - 1)*(a + b*x^n)^(1/2), x, 4, -(Sqrt[a + b*x^n]/(x^n*n)) - (b*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(Sqrt[a]*n)}
{x^(-2*n - 1)*(a + b*x^n)^(1/2), x, 5, -(Sqrt[a + b*x^n]/(x^(2*n)*(2*n))) - (b*Sqrt[a + b*x^n])/(x^n*(4*a*n)) + (b^2*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(4*a^(3/2)*n)}
{x^(-3*n - 1)*(a + b*x^n)^(1/2), x, 6, -(Sqrt[a + b*x^n]/(x^(3*n)*(3*n))) - (b*Sqrt[a + b*x^n])/(x^(2*n)*(12*a*n)) + (b^2*Sqrt[a + b*x^n])/(x^n*(8*a^2*n)) - (b^3*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(8*a^(5/2)*n)}
{x^(-4*n - 1)*(a + b*x^n)^(1/2), x, 7, -(Sqrt[a + b*x^n]/(x^(4*n)*(4*n))) - (b*Sqrt[a + b*x^n])/(x^(3*n)*(24*a*n)) + (5*b^2*Sqrt[a + b*x^n])/(x^(2*n)*(96*a^2*n)) - (5*b^3*Sqrt[a + b*x^n])/(x^n*(64*a^3*n)) + (5*b^4*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(64*a^(7/2)*n)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^(4*n - 1)/(a + b*x^n)^(1/2), x, 3, -((2*a^3*Sqrt[a + b*x^n])/(b^4*n)) + (2*a^2*(a + b*x^n)^(3/2))/(b^4*n) - (6*a*(a + b*x^n)^(5/2))/(5*b^4*n) + (2*(a + b*x^n)^(7/2))/(7*b^4*n)}
{x^(3*n - 1)/(a + b*x^n)^(1/2), x, 3, (2*a^2*Sqrt[a + b*x^n])/(b^3*n) - (4*a*(a + b*x^n)^(3/2))/(3*b^3*n) + (2*(a + b*x^n)^(5/2))/(5*b^3*n)}
{x^(2*n - 1)/(a + b*x^n)^(1/2), x, 3, -((2*a*Sqrt[a + b*x^n])/(b^2*n)) + (2*(a + b*x^n)^(3/2))/(3*b^2*n)}
{x^(1*n - 1)/(a + b*x^n)^(1/2), x, 1, (2*Sqrt[a + b*x^n])/(b*n)}
{x^(0*n - 1)/(a + b*x^n)^(1/2), x, 3, -((2*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(Sqrt[a]*n))}
{x^(-1*n - 1)/(a + b*x^n)^(1/2), x, 4, -(Sqrt[a + b*x^n]/(x^n*(a*n))) + (b*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(a^(3/2)*n)}
{x^(-2*n - 1)/(a + b*x^n)^(1/2), x, 5, -(Sqrt[a + b*x^n]/(x^(2*n)*(2*a*n))) + (3*b*Sqrt[a + b*x^n])/(x^n*(4*a^2*n)) - (3*b^2*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(4*a^(5/2)*n)}
{x^(-3*n - 1)/(a + b*x^n)^(1/2), x, 6, -(Sqrt[a + b*x^n]/(x^(3*n)*(3*a*n))) + (5*b*Sqrt[a + b*x^n])/(x^(2*n)*(12*a^2*n)) - (5*b^2*Sqrt[a + b*x^n])/(x^n*(8*a^3*n)) + (5*b^3*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(8*a^(7/2)*n)}
{x^(-4*n - 1)/(a + b*x^n)^(1/2), x, 7, -(Sqrt[a + b*x^n]/(x^(4*n)*(4*a*n))) + (7*b*Sqrt[a + b*x^n])/(x^(3*n)*(24*a^2*n)) - (35*b^2*Sqrt[a + b*x^n])/(x^(2*n)*(96*a^3*n)) + (35*b^3*Sqrt[a + b*x^n])/(x^n*(64*a^4*n)) - (35*b^4*ArcTanh[Sqrt[a + b*x^n]/Sqrt[a]])/(64*a^(9/2)*n)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^n)^p with m symbolic*)


{x^m*(a + b*x^n)^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (3*a^2*b*x^(1 + m + n))/(1 + m + n) + (3*a*b^2*x^(1 + m + 2*n))/(1 + m + 2*n) + (b^3*x^(1 + m + 3*n))/(1 + m + 3*n)}
{x^m*(a + b*x^n)^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(1 + m + n))/(1 + m + n) + (b^2*x^(1 + m + 2*n))/(1 + m + 2*n)}
{x^m*(a + b*x^n)^1, x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(1 + m + n))/(1 + m + n)}
{x^m/(a + b*x^n)^1, x, 1, (x^(1 + m)*Hypergeometric2F1[1, (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m))}
{x^m/(a + b*x^n)^2, x, 1, (x^(1 + m)*Hypergeometric2F1[2, (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a^2*(1 + m))}
{x^m/(a + b*x^n)^3, x, 1, (x^(1 + m)*Hypergeometric2F1[3, (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a^3*(1 + m))}


{x^m*(a + b*x^n)^(3/2), x, 2, (x^(1 + m)*(a + b*x^n)^(5/2)*Hypergeometric2F1[1, 5/2 + (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m)), (a*x^(1 + m)*Sqrt[a + b*x^n]*Hypergeometric2F1[-(3/2), (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/((1 + m)*Sqrt[1 + (b*x^n)/a])}
{x^m*(a + b*x^n)^(1/2), x, 2, (x^(1 + m)*(a + b*x^n)^(3/2)*Hypergeometric2F1[1, 3/2 + (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m)), (x^(1 + m)*Sqrt[a + b*x^n]*Hypergeometric2F1[-(1/2), (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/((1 + m)*Sqrt[1 + (b*x^n)/a])}
{x^m/(a + b*x^n)^(1/2), x, 2, (x^(1 + m)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, 1/2 + (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m)), (x^(1 + m)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/((1 + m)*Sqrt[a + b*x^n])}
{x^m/(a + b*x^n)^(3/2), x, 2, (x^(1 + m)*Hypergeometric2F1[1, -(1/2) + (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m)*Sqrt[a + b*x^n]), (x^(1 + m)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[3/2, (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m)*Sqrt[a + b*x^n])}
{x^m/(a + b*x^n)^(5/2), x, 2, (x^(1 + m)*Hypergeometric2F1[1, -(3/2) + (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m)*(a + b*x^n)^(3/2)), (x^(1 + m)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[5/2, (1 + m)/n, (1 + m + n)/n, -((b*x^n)/a)])/(a^2*(1 + m)*Sqrt[a + b*x^n])}


{x^(3 + 2*n)/Sqrt[a + b*x^n], x, 2, (x^(2*(2 + n))*Sqrt[a + b*x^n]*Hypergeometric2F1[1, (1/2)*(5 + 8/n), 3 + 4/n, -((b*x^n)/a)])/(2*a*(2 + n)), (x^(2*(2 + n))*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, 2*(1 + 2/n), 3 + 4/n, -((b*x^n)/a)])/(2*(2 + n)*Sqrt[a + b*x^n])}
{x^(3 + n)/Sqrt[a + b*x^n], x, 2, (x^(4 + n)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, (1/2)*(3 + 8/n), 2*(1 + 2/n), -((b*x^n)/a)])/(a*(4 + n)), (x^(4 + n)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, (4 + n)/n, 2*(1 + 2/n), -((b*x^n)/a)])/((4 + n)*Sqrt[a + b*x^n])}
{x^(3 - n)/Sqrt[a + b*x^n], x, 2, (x^(4 - n)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, (1/2)*(-1 + 8/n), 4/n, -((b*x^n)/a)])/(a*(4 - n)), (x^(4 - n)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, -1 + 4/n, 4/n, -((b*x^n)/a)])/((4 - n)*Sqrt[a + b*x^n])}
{x^(3 - 2*n)/Sqrt[a + b*x^n], x, 2, (x^(4 - 2*n)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, (1/2)*(-3 + 8/n), -1 + 4/n, -((b*x^n)/a)])/(2*a*(2 - n)), (x^(4 - 2*n)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, -2*(1 - 2/n), -1 + 4/n, -((b*x^n)/a)])/(2*(2 - n)*Sqrt[a + b*x^n])}

{x^(m + 2*n)/Sqrt[a + b*x^n], x, 2, (x^(1 + m + 2*n)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, (1/2)*(5 + (2*(1 + m))/n), (1 + m + 3*n)/n, -((b*x^n)/a)])/(a*(1 + m + 2*n)), (x^(1 + m + 2*n)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, (1 + m + 2*n)/n, (1 + m + 3*n)/n, -((b*x^n)/a)])/((1 + m + 2*n)*Sqrt[a + b*x^n])}
{x^(m + n)/Sqrt[a + b*x^n], x, 2, (x^(1 + m + n)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, 1/2 + (1 + m + n)/n, (1 + m + 2*n)/n, -((b*x^n)/a)])/(a*(1 + m + n)), (x^(1 + m + n)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, (1 + m + n)/n, (1 + m + 2*n)/n, -((b*x^n)/a)])/((1 + m + n)*Sqrt[a + b*x^n])}
{x^(m - n)/Sqrt[a + b*x^n], x, 2, (x^(1 + m - n)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, (1/2)*(-1 + (2*(1 + m))/n), (1 + m)/n, -((b*x^n)/a)])/(a*(1 + m - n)), (x^(1 + m - n)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, (1 + m - n)/n, (1 + m)/n, -((b*x^n)/a)])/((1 + m - n)*Sqrt[a + b*x^n])}
{x^(m - 2*n)/Sqrt[a + b*x^n], x, 2, (x^(1 + m - 2*n)*Sqrt[a + b*x^n]*Hypergeometric2F1[1, (1/2)*(-3 + (2*(1 + m))/n), (1 + m - n)/n, -((b*x^n)/a)])/(a*(1 + m - 2*n)), (x^(1 + m - 2*n)*Sqrt[1 + (b*x^n)/a]*Hypergeometric2F1[1/2, (1 + m - 2*n)/n, (1 + m - n)/n, -((b*x^n)/a)])/((1 + m - 2*n)*Sqrt[a + b*x^n])}

{-((b*n*x^(-1 + m + n))/(2*(a + b*x^n)^(3/2))) + (m*x^(-1 + m))/Sqrt[a + b*x^n], x, -5, x^m/Sqrt[a + b*x^n], -((b*x^(m + n))/(a*Sqrt[a + b*x^n])) + (x^m*Sqrt[a + b*x^n])/a}


{x^(7*n/2 - 1)/Sqrt[a + b*x^n], x, 5, (5*a^2*x^(n/2)*Sqrt[a + b*x^n])/(8*b^3*n) - (5*a*x^((3*n)/2)*Sqrt[a + b*x^n])/(12*b^2*n) + (x^((5*n)/2)*Sqrt[a + b*x^n])/(3*b*n) - (5*a^3*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(8*b^(7/2)*n)}
{x^(5*n/2 - 1)/Sqrt[a + b*x^n], x, 4, -((3*a*x^(n/2)*Sqrt[a + b*x^n])/(4*b^2*n)) + (x^((3*n)/2)*Sqrt[a + b*x^n])/(2*b*n) + (3*a^2*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(4*b^(5/2)*n)}
{x^(3*n/2 - 1)/Sqrt[a + b*x^n], x, 3, (x^(n/2)*Sqrt[a + b*x^n])/(b*n) - (a*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(b^(3/2)*n)}
{x^(1*n/2 - 1)/Sqrt[a + b*x^n], x, 3, (2*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(Sqrt[b]*n)}
{x^(-1*n/2 - 1)/Sqrt[a + b*x^n], x, 1, -((2*Sqrt[a + b*x^n])/(x^(n/2)*(a*n)))}
{x^(-3*n/2 - 1)/Sqrt[a + b*x^n], x, 2, -((2*Sqrt[a + b*x^n])/(x^((3*n)/2)*(3*a*n))) + (4*b*Sqrt[a + b*x^n])/(x^(n/2)*(3*a^2*n))}
{x^(-5*n/2 - 1)/Sqrt[a + b*x^n], x, 3, -((2*Sqrt[a + b*x^n])/(x^((5*n)/2)*(5*a*n))) + (8*b*Sqrt[a + b*x^n])/(x^((3*n)/2)*(15*a^2*n)) - (16*b^2*Sqrt[a + b*x^n])/(x^(n/2)*(15*a^3*n))}
{x^(-7*n/2 - 1)/Sqrt[a + b*x^n], x, 4, -((2*Sqrt[a + b*x^n])/(x^((7*n)/2)*(7*a*n))) + (12*b*Sqrt[a + b*x^n])/(x^((5*n)/2)*(35*a^2*n)) - (16*b^2*Sqrt[a + b*x^n])/(x^((3*n)/2)*(35*a^3*n)) + (32*b^3*Sqrt[a + b*x^n])/(x^(n/2)*(35*a^4*n))}


{x^m/Sqrt[a + b*x^(m-2)], x, 2, (x^(1 + m)*Sqrt[a + b*x^(-2 + m)]*Hypergeometric2F1[1, -((3*m)/(2*(2 - m))), (1 - 2*m)/(2 - m), -((b*x^(-2 + m))/a)])/(a*(1 + m)), (x^(1 + m)*Sqrt[1 + (b*x^(-2 + m))/a]*Hypergeometric2F1[1/2, -((1 + m)/(2 - m)), (1 - 2*m)/(2 - m), -((b*x^(-2 + m))/a)])/((1 + m)*Sqrt[a + b*x^(-2 + m)])}
{x^m/Sqrt[a + b*x^(2-m)], x, 2, (x^(1 + m)*Sqrt[a + b*x^(2 - m)]*Hypergeometric2F1[1, (4 + m)/(2*(2 - m)), 3/(2 - m), -((b*x^(2 - m))/a)])/(a*(1 + m)), (x^(1 + m)*Sqrt[1 + (b*x^(2 - m))/a]*Hypergeometric2F1[1/2, (1 + m)/(2 - m), 3/(2 - m), -((b*x^(2 - m))/a)])/((1 + m)*Sqrt[a + b*x^(2 - m)])}

{(6*a*x^2)/(b*(4 + m)*Sqrt[a + b*x^(-2 + m)]) + x^m/Sqrt[a + b*x^(-2 + m)], x, -5, (2*x^3*Sqrt[a + b*x^(-2 + m)])/(b*(4 + m)), (2*x^(1 + m)*(b + a*x^(2 - m)))/(b*(4 + m)*Sqrt[a + b*x^(-2 + m)])}


{(x^(-1 + m)*(2*a*m + b*(2*m - n)*x^n))/(2*(a + b*x^n)^(3/2)), x, 2, x^m/Sqrt[a + b*x^n]}
{-((b*n*x^(-1 + m + n))/(2*(a + b*x^n)^(3/2))) + (m*x^(-1 + m))/Sqrt[a + b*x^n], x, -5, x^m/Sqrt[a + b*x^n], -((b*x^(m + n))/(a*Sqrt[a + b*x^n])) + (x^m*Sqrt[a + b*x^n])/a}


(* The substitution m->-1-2*n/3 transforms the first integrand into the second. *)
{x^m/(a + b*x^(3*(1 + m)))^(1/3), x, 2, ArcTan[(1 + (2*b^(1/3)*x^(1 + m))/(a + b*x^(3*(1 + m)))^(1/3))/Sqrt[3]]/(Sqrt[3]*b^(1/3)*(1 + m)) - Log[b^(1/3)*x^(1 + m) - (a + b*x^(3*(1 + m)))^(1/3)]/(2*b^(1/3)*(1 + m))}
{x^m*(a + b/x^((3/2)*(1 + m)))^(2/3), x, 3, (x^(1 + m)*(a + b/x^((3/2)*(1 + m)))^(2/3))/(1 + m) - (2*b^(2/3)*ArcTan[(1 + (2*b^(1/3)*x^((1/2)*(-1 - m)))/(a + b/x^((3/2)*(1 + m)))^(1/3))/Sqrt[3]])/(Sqrt[3]*(1 + m)) + (b^(2/3)*Log[b^(1/3)*x^((1/2)*(-1 - m)) - (a + b/x^((3/2)*(1 + m)))^(1/3)])/(1 + m), (x^(1 + m)*(a + b/x^((3/2)*(1 + m)))^(2/3))/(1 + m) - (2*b^(2/3)*ArcTan[(1 + (2*b^(1/3)*x^((1/2)*(-1 - m)))/(a + b/x^((3/2)*(1 + m)))^(1/3))/Sqrt[3]])/(Sqrt[3]*(1 + m)) + (b^(2/3)*Log[(-x^((1/2)*(-1 - m)))*(b^(1/3) - x^((1 + m)/2)*(a + b/x^((3/2)*(1 + m)))^(1/3))])/(1 + m)}


{x^(-1 + n/3)/(a + b*x^n)^(1/3), x, 2, (Sqrt[3]*ArcTan[(1 + (2*b^(1/3)*x^(n/3))/(a + b*x^n)^(1/3))/Sqrt[3]])/(b^(1/3)*n) - (3*Log[b^(1/3)*x^(n/3) - (a + b*x^n)^(1/3)])/(2*b^(1/3)*n)}
{x^(-1 - (2*n)/3)*(a + b*x^n)^(2/3), x, 3, -((3*(a + b*x^n)^(2/3))/(x^((2*n)/3)*(2*n))) + (Sqrt[3]*b^(2/3)*ArcTan[(1 + (2*b^(1/3)*x^(n/3))/(a + b*x^n)^(1/3))/Sqrt[3]])/n - (3*b^(2/3)*Log[b^(1/3)*x^(n/3) - (a + b*x^n)^(1/3)])/(2*n)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^n)^p with p symbolic*)


{x^m*(a + b*x^n)^p, x, 2, (x^(1 + m)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, 1 + (1 + m)/n + p, (1 + m + n)/n, -((b*x^n)/a)])/(a*(1 + m)), (x^(1 + m)*(a + b*x^n)^p*Hypergeometric2F1[(1 + m)/n, -p, (1 + m + n)/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(1 + m))}


{1/(a + b*x^n)^(1/n + 4), x, 4, If[$VersionNumber>=8, (x*(a + b*x^n)^(-3 - 1/n))/(a*(1 + 3*n)) + (3*n*x*(a + b*x^n)^(-2 - 1/n))/(a^2*(1 + 5*n + 6*n^2)) + (6*n^2*x*(a + b*x^n)^(-1 - 1/n))/(a^3*(1 + n)*(1 + 2*n)*(1 + 3*n)) + (6*n^3*x)/((a + b*x^n)^n^(-1)*(a^4*(1 + n)*(1 + 2*n)*(1 + 3*n))), (x*(a + b*x^n)^(-3 - 1/n))/(a*(1 + 3*n)) + (3*n*x*(a + b*x^n)^(-2 - 1/n))/(a^2*(1 + 5*n + 6*n^2)) + (6*n^2*x*(a + b*x^n)^(-1 - 1/n))/(a^3*(1 + 6*n + 11*n^2 + 6*n^3)) + (6*n^3*x)/((a + b*x^n)^n^(-1)*(a^4*(1 + 6*n + 11*n^2 + 6*n^3)))]}
{1/(a + b*x^n)^(1/n + 3), x, 3, If[$VersionNumber>=8, (x*(a + b*x^n)^(-2 - 1/n))/(a*(1 + 2*n)) + (2*n*x*(a + b*x^n)^(-1 - 1/n))/(a^2*(1 + n)*(1 + 2*n)) + (2*n^2*x)/((a + b*x^n)^n^(-1)*(a^3*(1 + n)*(1 + 2*n))), (x*(a + b*x^n)^(-2 - 1/n))/(a*(1 + 2*n)) + (2*n*x*(a + b*x^n)^(-1 - 1/n))/(a^2*(1 + 3*n + 2*n^2)) + (2*n^2*x)/((a + b*x^n)^n^(-1)*(a^3*(1 + 3*n + 2*n^2)))]}
{1/(a + b*x^n)^(1/n + 2), x, 2, (x*(a + b*x^n)^(-1 - 1/n))/(a*(1 + n)) + (n*x)/((a + b*x^n)^n^(-1)*(a^2*(1 + n)))}
{1/(a + b*x^n)^(1/n + 1), x, 1, x/((a + b*x^n)^n^(-1)*a)}
{1/(a + b*x^n)^(1/n + 0), x, 2, (x*(1 + (b*x^n)/a)^(1/n)*Hypergeometric2F1[1/n, 1/n, 1 + 1/n, -((b*x^n)/a)])/(a + b*x^n)^n^(-1)}
{1/(a + b*x^n)^(1/n - 1), x, 2, (a*x*(1 + (b*x^n)/a)^(1/n)*Hypergeometric2F1[-1 + 1/n, 1/n, 1 + 1/n, -((b*x^n)/a)])/(a + b*x^n)^n^(-1)}
{1/(a + b*x^n)^(1/n - 2), x, 2, (a^2*x*(1 + (b*x^n)/a)^(1/n)*Hypergeometric2F1[-2 + 1/n, 1/n, 1 + 1/n, -((b*x^n)/a)])/(a + b*x^n)^n^(-1)}


{(b*x^n)^p*x^m, x, 2, (x^(1 + m)*(b*x^n)^p)/(1 + m + n*p)}

{(b*x^n)^p*x^2, x, 2, (x^3*(b*x^n)^p)/(3 + n*p)}
{(b*x^n)^p*x^1, x, 2, (x^2*(b*x^n)^p)/(2 + n*p)}
{(b*x^n)^p*x^0, x, 2, (x*(b*x^n)^p)/(1 + n*p)}
{(b*x^n)^p/x^1, x, 2, (b*x^n)^p/(n*p)}
{(b*x^n)^p/x^2, x, 2, -((b*x^n)^p/((1 - n*p)*x))}
{(b*x^n)^p/x^3, x, 2, -((b*x^n)^p/((2 - n*p)*x^2))}
{(b*x^n)^p/x^4, x, 2, -((b*x^n)^p/((3 - n*p)*x^3))}


{x^(n - 1)*(a + b*x^n)^p, x, 1, (a + b*x^n)^(1 + p)/(b*n*(1 + p))}
{x^(2*n - 1)*(a + b*x^n)^p, x, 3, -((a*(a + b*x^n)^(1 + p))/(b^2*n*(1 + p))) + (a + b*x^n)^(2 + p)/(b^2*n*(2 + p))}
{x^(3*n - 1)*(a + b*x^n)^p, x, 3, (a^2*(a + b*x^n)^(1 + p))/(b^3*n*(1 + p)) - (2*a*(a + b*x^n)^(2 + p))/(b^3*n*(2 + p)) + (a + b*x^n)^(3 + p)/(b^3*n*(3 + p))}
{x^(4*n - 1)*(a + b*x^n)^p, x, 3, -((a^3*(a + b*x^n)^(1 + p))/(b^4*n*(1 + p))) + (3*a^2*(a + b*x^n)^(2 + p))/(b^4*n*(2 + p)) - (3*a*(a + b*x^n)^(3 + p))/(b^4*n*(3 + p)) + (a + b*x^n)^(4 + p)/(b^4*n*(4 + p))}


(* Integrands of the form x^m*(a+b*x^n)^p where n*p+n+m+1=0 *)
{(a + b*x^n)^p/x^(n*p + n + 1), x, 1, -((a + b*x^n)^(1 + p)/(x^(n*(1 + p))*(a*n*(1 + p))))}
{(a + b*x^n)^8/x^(n*8 + n + 1), x, 1, -((a + b*x^n)^9/(x^(9*n)*(9*a*n)))}
{(a + b*x^3)^p/x^(3*p + 3 + 1), x, 1, -((a + b*x^3)^(1 + p)/(x^(3*(1 + p))*(3*a*(1 + p))))}
{(a + b*x^3)^8/x^(3*8 + 3 + 1), x, 1, -((a + b*x^3)^9/(27*a*x^27))}
{(a + b*x^n)^(-1)/x^(n*(-1) + n + 1), x, 4, Log[x]/a - Log[a + b*x^n]/(a*n)}
{(a + b*x^3)^(-1)/x^(3*(-1) + 3 + 1), x, 4, Log[x]/a - Log[a + b*x^3]/(3*a)}


{1/(a + b*x^n)^((1 + 4*n)/n), x, 4, If[$VersionNumber>=8, (x*(a + b*x^n)^(-3 - 1/n))/(a*(1 + 3*n)) + (3*n*x*(a + b*x^n)^(-2 - 1/n))/(a^2*(1 + 5*n + 6*n^2)) + (6*n^3*x)/((a + b*x^n)^n^(-1)*(a^4*(1 + n)*(1 + 2*n)*(1 + 3*n))) + (6*n^2*x)/((a + b*x^n)^((1 + n)/n)*(a^3*(1 + n)*(1 + 2*n)*(1 + 3*n))), (x*(a + b*x^n)^(-3 - 1/n))/(a*(1 + 3*n)) + (3*n*x*(a + b*x^n)^(-2 - 1/n))/(a^2*(1 + 5*n + 6*n^2)) + (6*n^3*x)/((a + b*x^n)^n^(-1)*(a^4*(1 + 6*n + 11*n^2 + 6*n^3))) + (6*n^2*x)/((a + b*x^n)^((1 + n)/n)*(a^3*(1 + 6*n + 11*n^2 + 6*n^3)))]}
{1/(a + b*x^n)^((1 + 3*n)/n), x, 3, If[$VersionNumber>=8, (x*(a + b*x^n)^(-2 - 1/n))/(a*(1 + 2*n)) + (2*n^2*x)/((a + b*x^n)^n^(-1)*(a^3*(1 + n)*(1 + 2*n))) + (2*n*x)/((a + b*x^n)^((1 + n)/n)*(a^2*(1 + n)*(1 + 2*n))), (x*(a + b*x^n)^(-2 - 1/n))/(a*(1 + 2*n)) + (2*n^2*x)/((a + b*x^n)^n^(-1)*(a^3*(1 + 3*n + 2*n^2))) + (2*n*x)/((a + b*x^n)^((1 + n)/n)*(a^2*(1 + 3*n + 2*n^2)))]}
{1/(a + b*x^n)^((1 + 2*n)/n), x, 2, (n*x)/((a + b*x^n)^n^(-1)*(a^2*(1 + n))) + x/((a + b*x^n)^((1 + n)/n)*(a*(1 + n)))}
{1/(a + b*x^n)^((1 + 1*n)/n), x, 1, x/((a + b*x^n)^n^(-1)*a)}
{1/(a + b*x^n)^((1 + 0*n)/n), x, 2, (x*(1 + (b*x^n)/a)^(1/n)*Hypergeometric2F1[1/n, 1/n, 1 + 1/n, -((b*x^n)/a)])/(a + b*x^n)^n^(-1)}
{1/(a + b*x^n)^((1 - 1*n)/n), x, 2, (x*(1 + (b*x^n)/a)^(-1 + 1/n)*Hypergeometric2F1[-1 + 1/n, 1/n, 1 + 1/n, -((b*x^n)/a)])/(a + b*x^n)^((1 - n)/n)}
{1/(a + b*x^n)^((1 - 2*n)/n), x, 2, x*(a + b*x^n)^(2 - 1/n)*(1 + (b*x^n)/a)^(-2 + 1/n)*Hypergeometric2F1[-2 + 1/n, 1/n, 1 + 1/n, -((b*x^n)/a)]}


{1/(x*(a + b/x^n)), x, 2, Log[b + a*x^n]/(a*n)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b x^(n (m + 1)))^p*)


{x^m/(a + b*x^(m + 1)), x, 1, Log[a + b*x^(1 + m)]/(b*(1 + m))}
{x^m*(a + b*x^(m + 1))^n, x, 1, (a + b*x^(1 + m))^(1 + n)/(b*(1 + m)*(1 + n))}


{x^m*(a + b*x^(2 + 2*m))^3, x, 2, (a^3*x^(1 + m))/(1 + m) + (a^2*b*x^(3*(1 + m)))/(1 + m) + (3*a*b^2*x^(5*(1 + m)))/(5*(1 + m)) + (b^3*x^(7*(1 + m)))/(7*(1 + m))}
{x^m*(a + b*x^(2 + 2*m))^2, x, 2, (a^2*x^(1 + m))/(1 + m) + (2*a*b*x^(3*(1 + m)))/(3*(1 + m)) + (b^2*x^(5*(1 + m)))/(5*(1 + m))}
{x^m*(a + b*x^(2 + 2*m)), x, 2, (a*x^(1 + m))/(1 + m) + (b*x^(3*(1 + m)))/(3*(1 + m))}
{x^m/(a + b*x^(2 + 2*m)), x, 2, ArcTan[(Sqrt[b]*x^(1 + m))/Sqrt[a]]/(Sqrt[a]*Sqrt[b]*(1 + m))}
{x^m/(a + b*x^(2 + 2*m))^2, x, 3, x^(1 + m)/(2*a*(1 + m)*(a + b*x^(2*(1 + m)))) + ArcTan[(Sqrt[b]*x^(1 + m))/Sqrt[a]]/(2*a^(3/2)*Sqrt[b]*(1 + m))}
{x^m/(a + b*x^(2 + 2*m))^3, x, 4, x^(1 + m)/(4*a*(1 + m)*(a + b*x^(2*(1 + m)))^2) + (3*x^(1 + m))/(8*a^2*(1 + m)*(a + b*x^(2*(1 + m)))) + (3*ArcTan[(Sqrt[b]*x^(1 + m))/Sqrt[a]])/(8*a^(5/2)*Sqrt[b]*(1 + m))}


{x^m*(a + b*x^(2 + 2*m))^(5/2), x, 6, (5*a^2*x^(1 + m)*Sqrt[a + b*x^(2*(1 + m))])/(16*(1 + m)) + (5*a*x^(1 + m)*(a + b*x^(2*(1 + m)))^(3/2))/(24*(1 + m)) + (x^(1 + m)*(a + b*x^(2*(1 + m)))^(5/2))/(6*(1 + m)) + (5*a^3*ArcTanh[(Sqrt[b]*x^(1 + m))/Sqrt[a + b*x^(2*(1 + m))]])/(16*Sqrt[b]*(1 + m))}
{x^m*(a + b*x^(2 + 2*m))^(3/2), x, 5, (3*a*x^(1 + m)*Sqrt[a + b*x^(2*(1 + m))])/(8*(1 + m)) + (x^(1 + m)*(a + b*x^(2*(1 + m)))^(3/2))/(4*(1 + m)) + (3*a^2*ArcTanh[(Sqrt[b]*x^(1 + m))/Sqrt[a + b*x^(2*(1 + m))]])/(8*Sqrt[b]*(1 + m))}
{x^m*(a + b*x^(2 + 2*m))^(1/2), x, 4, (x^(1 + m)*Sqrt[a + b*x^(2*(1 + m))])/(2*(1 + m)) + (a*ArcTanh[(Sqrt[b]*x^(1 + m))/Sqrt[a + b*x^(2*(1 + m))]])/(2*Sqrt[b]*(1 + m))}
{x^m/(a + b*x^(2 + 2*m))^(1/2), x, 3, ArcTanh[(Sqrt[b]*x^(1 + m))/Sqrt[a + b*x^(2*(1 + m))]]/(Sqrt[b]*(1 + m))}
{x^m/(a + b*x^(2 + 2*m))^(3/2), x, 1, x^(1 + m)/(a*(1 + m)*Sqrt[a + b*x^(2*(1 + m))])}
{x^m/(a + b*x^(2 + 2*m))^(5/2), x, 2, x^(1 + m)/(a*(1 + m)*(a + b*x^(2*(1 + m)))^(3/2)) + (2*b*x^(3*(1 + m)))/(3*a^2*(1 + m)*(a + b*x^(2*(1 + m)))^(3/2))}
{x^m/(a + b*x^(2 + 2*m))^(7/2), x, 3, x^(1 + m)/(a*(1 + m)*(a + b*x^(2*(1 + m)))^(5/2)) + (4*b*x^(3*(1 + m)))/(3*a^2*(1 + m)*(a + b*x^(2*(1 + m)))^(5/2)) + (8*b^2*x^(5*(1 + m)))/(15*a^3*(1 + m)*(a + b*x^(2*(1 + m)))^(5/2))}


{x^n*Sqrt[1 + x^(1 + n)], x, 1, (2*(1 + x^(1 + n))^(3/2))/(3*(1 + n))}
{x^n*Sqrt[a^2 + x^(1 + n)], x, 1, (2*(a^2 + x^(1 + n))^(3/2))/(3*(1 + n))}


(* ::Section::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(c*x)^m*(a + b*x^n)^2, x, 6, (2*a*b*x^(1 + n)*(c*x)^m)/(1 + m + n) + (b^2*x^(1 + 2*n)*(c*x)^m)/(1 + m + 2*n) + (a^2*(c*x)^(1 + m))/(c*(1 + m))}

{(c*x)^m*(a + b*x^3)^2, x, 2, (a^2*(c*x)^(1 + m))/(c*(1 + m)) + (2*a*b*(c*x)^(4 + m))/(c^4*(4 + m)) + (b^2*(c*x)^(7 + m))/(c^7*(7 + m))}
{(c*x)^m*(a + b*x^2)^2, x, 2, (a^2*(c*x)^(1 + m))/(c*(1 + m)) + (2*a*b*(c*x)^(3 + m))/(c^3*(3 + m)) + (b^2*(c*x)^(5 + m))/(c^5*(5 + m))}
{(c*x)^m*(a + b*x^1)^2, x, 2, (a^2*(c*x)^(1 + m))/(c*(1 + m)) + (2*a*b*(c*x)^(2 + m))/(c^2*(2 + m)) + (b^2*(c*x)^(3 + m))/(c^3*(3 + m))}
{(c*x)^m*(a + b/x^1)^2, x, 2, -((b^2*c*(c*x)^(-1 + m))/(1 - m)) + (2*a*b*(c*x)^m)/m + (a^2*(c*x)^(1 + m))/(c*(1 + m))}
{(c*x)^m*(a + b/x^2)^2, x, 2, -((b^2*c^3*(c*x)^(-3 + m))/(3 - m)) - (2*a*b*c*(c*x)^(-1 + m))/(1 - m) + (a^2*(c*x)^(1 + m))/(c*(1 + m))}
{(c*x)^m*(a + b/x^3)^2, x, 2, -((b^2*c^5*(c*x)^(-5 + m))/(5 - m)) - (2*a*b*c^2*(c*x)^(-2 + m))/(2 - m) + (a^2*(c*x)^(1 + m))/(c*(1 + m))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{(c*x)^(-1 - 1*n/2)/(a + b*x^n), x, 5, -(2/((c*x)^(n/2)*(a*c*n))) + (2*Sqrt[b]*x^(n/2)*ArcTan[Sqrt[a]/(x^(n/2)*Sqrt[b])])/((c*x)^(n/2)*(a^(3/2)*c*n))}
{(c*x)^(-1 - 2*n/3)/(a + b*x^n), x, 9, -(3/((c*x)^((2*n)/3)*(2*a*c*n))) + (Sqrt[3]*b^(2/3)*x^((2*n)/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*x^(n/3))/(Sqrt[3]*a^(1/3))])/((c*x)^((2*n)/3)*(a^(5/3)*c*n)) - (b^(2/3)*x^((2*n)/3)*Log[a^(1/3) + b^(1/3)*x^(n/3)])/((c*x)^((2*n)/3)*(a^(5/3)*c*n)) + (b^(2/3)*x^((2*n)/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*x^(n/3) + b^(2/3)*x^((2*n)/3)])/((c*x)^((2*n)/3)*(2*a^(5/3)*c*n))}
{(c*x)^(-1 - 3*n/4)/(a + b*x^n), x, 12, -(4/((c*x)^((3*n)/4)*(3*a*c*n))) + (Sqrt[2]*b^(3/4)*x^((3*n)/4)*ArcTan[1 - (Sqrt[2]*b^(1/4)*x^(n/4))/a^(1/4)])/((c*x)^((3*n)/4)*(a^(7/4)*c*n)) - (Sqrt[2]*b^(3/4)*x^((3*n)/4)*ArcTan[1 + (Sqrt[2]*b^(1/4)*x^(n/4))/a^(1/4)])/((c*x)^((3*n)/4)*(a^(7/4)*c*n)) + (b^(3/4)*x^((3*n)/4)*Log[Sqrt[a] - Sqrt[2]*a^(1/4)*b^(1/4)*x^(n/4) + Sqrt[b]*x^(n/2)])/((c*x)^((3*n)/4)*(Sqrt[2]*a^(7/4)*c*n)) - (b^(3/4)*x^((3*n)/4)*Log[Sqrt[a] + Sqrt[2]*a^(1/4)*b^(1/4)*x^(n/4) + Sqrt[b]*x^(n/2)])/((c*x)^((3*n)/4)*(Sqrt[2]*a^(7/4)*c*n))}


{(c*x)^(-1 - n/1)/(a + b*x^n), x, 4, -(1/((c*x)^n*(a*c*n))) - (b*x^n*Log[x])/((c*x)^n*(a^2*c)) + (b*x^n*Log[a + b*x^n])/((c*x)^n*(a^2*c*n))}
{(c*x)^(-1 - n/2)/(a + b*x^n), x, 5, -(2/((c*x)^(n/2)*(a*c*n))) + (2*Sqrt[b]*x^(n/2)*ArcTan[Sqrt[a]/(x^(n/2)*Sqrt[b])])/((c*x)^(n/2)*(a^(3/2)*c*n))}
{(c*x)^(-1 - n/3)/(a + b*x^n), x, 10, -(3/((c*x)^(n/3)*(a*c*n))) - (Sqrt[3]*b^(1/3)*x^(n/3)*ArcTan[(b^(1/3) - (2*a^(1/3))/x^(n/3))/(Sqrt[3]*b^(1/3))])/((c*x)^(n/3)*(a^(4/3)*c*n)) + (b^(1/3)*x^(n/3)*Log[b^(1/3) + a^(1/3)/x^(n/3)])/((c*x)^(n/3)*(a^(4/3)*c*n)) - (b^(1/3)*x^(n/3)*Log[b^(2/3) + a^(2/3)/x^((2*n)/3) - (a^(1/3)*b^(1/3))/x^(n/3)])/((c*x)^(n/3)*(2*a^(4/3)*c*n))}
{(c*x)^(-1 - n/4)/(a + b*x^n), x, 13, -(4/((c*x)^(n/4)*(a*c*n))) - (Sqrt[2]*b^(1/4)*x^(n/4)*ArcTan[1 - (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/((c*x)^(n/4)*(a^(5/4)*c*n)) + (Sqrt[2]*b^(1/4)*x^(n/4)*ArcTan[1 + (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/((c*x)^(n/4)*(a^(5/4)*c*n)) - (b^(1/4)*x^(n/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) - (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/((c*x)^(n/4)*(Sqrt[2]*a^(5/4)*c*n)) + (b^(1/4)*x^(n/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) + (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/((c*x)^(n/4)*(Sqrt[2]*a^(5/4)*c*n))}


{(c*x)^(-1 - 3*n/2)/(a + b*x^n), x, 6, -(2/((c*x)^((3*n)/2)*(3*a*c*n))) + (2*b*x^n)/((c*x)^((3*n)/2)*(a^2*c*n)) - (2*b^(3/2)*x^((3*n)/2)*ArcTan[Sqrt[a]/(x^(n/2)*Sqrt[b])])/((c*x)^((3*n)/2)*(a^(5/2)*c*n))}
{(c*x)^(-1 - 4*n/3)/(a + b*x^n), x, 11, If[$VersionNumber>=8, -(3/((c*x)^((4*n)/3)*(4*a*c*n))) + (3*b*x^n)/((c*x)^((4*n)/3)*(a^2*c*n)) + (Sqrt[3]*b^(4/3)*x^((4*n)/3)*ArcTan[(b^(1/3) - (2*a^(1/3))/x^(n/3))/(Sqrt[3]*b^(1/3))])/((c*x)^((4*n)/3)*(a^(7/3)*c*n)) - (b^(4/3)*x^((4*n)/3)*Log[b^(1/3) + a^(1/3)/x^(n/3)])/((c*x)^((4*n)/3)*(a^(7/3)*c*n)) + (b^(4/3)*x^((4*n)/3)*Log[b^(2/3) + a^(2/3)/x^((2*n)/3) - (a^(1/3)*b^(1/3))/x^(n/3)])/((c*x)^((4*n)/3)*(2*a^(7/3)*c*n)), -(3/((c*x)^((4*n)/3)*(4*a*c*n))) + (3*b*x^n)/((c*x)^((4*n)/3)*(a^2*c*n)) + (Sqrt[3]*b^(4/3)*x^((4*n)/3)*ArcTan[(1 - (2*a^(1/3))/(x^(n/3)*b^(1/3)))/Sqrt[3]])/((c*x)^((4*n)/3)*(a^(7/3)*c*n)) - (b^(4/3)*x^((4*n)/3)*Log[b^(1/3) + a^(1/3)/x^(n/3)])/((c*x)^((4*n)/3)*(a^(7/3)*c*n)) + (b^(4/3)*x^((4*n)/3)*Log[b^(2/3) + a^(2/3)/x^((2*n)/3) - (a^(1/3)*b^(1/3))/x^(n/3)])/((c*x)^((4*n)/3)*(2*a^(7/3)*c*n))]}
{(c*x)^(-1 - 5*n/4)/(a + b*x^n), x, 14, -(4/((c*x)^((5*n)/4)*(5*a*c*n))) + (4*b*x^n)/((c*x)^((5*n)/4)*(a^2*c*n)) + (Sqrt[2]*b^(5/4)*x^((5*n)/4)*ArcTan[1 - (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/((c*x)^((5*n)/4)*(a^(9/4)*c*n)) - (Sqrt[2]*b^(5/4)*x^((5*n)/4)*ArcTan[1 + (Sqrt[2]*a^(1/4))/(x^(n/4)*b^(1/4))])/((c*x)^((5*n)/4)*(a^(9/4)*c*n)) + (b^(5/4)*x^((5*n)/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) - (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/((c*x)^((5*n)/4)*(Sqrt[2]*a^(9/4)*c*n)) - (b^(5/4)*x^((5*n)/4)*Log[Sqrt[b] + Sqrt[a]/x^(n/2) + (Sqrt[2]*a^(1/4)*b^(1/4))/x^(n/4)])/((c*x)^((5*n)/4)*(Sqrt[2]*a^(9/4)*c*n))}


{(c*x)^(n + 4)/(a + b*x^n), x, 1, ((c*x)^(5 + n)*Hypergeometric2F1[1, (5 + n)/n, 2 + 5/n, -((b*x^n)/a)])/(a*c*(5 + n))}
{(c*x)^(n + 3)/(a + b*x^n), x, 1, ((c*x)^(4 + n)*Hypergeometric2F1[1, (4 + n)/n, 2*(1 + 2/n), -((b*x^n)/a)])/(a*c*(4 + n))}
{(c*x)^(n + 2)/(a + b*x^n), x, 1, ((c*x)^(3 + n)*Hypergeometric2F1[1, (3 + n)/n, 2 + 3/n, -((b*x^n)/a)])/(a*c*(3 + n))}
{(c*x)^(n + 1)/(a + b*x^n), x, 1, ((c*x)^(2 + n)*Hypergeometric2F1[1, (2 + n)/n, 2*(1 + 1/n), -((b*x^n)/a)])/(a*c*(2 + n))}
{(c*x)^(n + 0)/(a + b*x^n), x, 1, ((c*x)^(1 + n)*Hypergeometric2F1[1, 1 + 1/n, 2 + 1/n, -((b*x^n)/a)])/(a*c*(1 + n))}
{(c*x)^(n - 1)/(a + b*x^n), x, 2, ((c*x)^n*Log[a + b*x^n])/(x^n*(b*c*n))}
{(c*x)^(n - 2)/(a + b*x^n), x, 1, -(((c*x)^(-1 + n)*Hypergeometric2F1[1, -((1 - n)/n), 2 - 1/n, -((b*x^n)/a)])/(a*c*(1 - n)))}
{(c*x)^(n - 3)/(a + b*x^n), x, 1, -(((c*x)^(-2 + n)*Hypergeometric2F1[1, -((2 - n)/n), 2*(1 - 1/n), -((b*x^n)/a)])/(a*c*(2 - n)))}


{(c*x)^(n - 1)/(a + b*x^n)^2, x, 1, (c*x)^n/(a*c*n*(a + b*x^n))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^(p/2)*)


(* ::Subsubsection:: *)
(*p>0*)


(* ::Subsubsection::Closed:: *)
(*p<0*)


{(c*x)^(7*n/2 - 1)/Sqrt[a + b*x^n], x, 6, (5*a^2*(c*x)^((7*n)/2)*Sqrt[a + b*x^n])/(x^(3*n)*(8*b^3*c*n)) - (5*a*(c*x)^((7*n)/2)*Sqrt[a + b*x^n])/(x^(2*n)*(12*b^2*c*n)) + ((c*x)^((7*n)/2)*Sqrt[a + b*x^n])/(x^n*(3*b*c*n)) - (5*a^3*(c*x)^((7*n)/2)*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(x^((7*n)/2)*(8*b^(7/2)*c*n))}
{(c*x)^(5*n/2 - 1)/Sqrt[a + b*x^n], x, 5, -((3*a*(c*x)^((5*n)/2)*Sqrt[a + b*x^n])/(x^(2*n)*(4*b^2*c*n))) + ((c*x)^((5*n)/2)*Sqrt[a + b*x^n])/(x^n*(2*b*c*n)) + (3*a^2*(c*x)^((5*n)/2)*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(x^((5*n)/2)*(4*b^(5/2)*c*n))}
{(c*x)^(3*n/2 - 1)/Sqrt[a + b*x^n], x, 4, ((c*x)^((3*n)/2)*Sqrt[a + b*x^n])/(x^n*(b*c*n)) - (a*(c*x)^((3*n)/2)*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(x^((3*n)/2)*(b^(3/2)*c*n))}
{(c*x)^(1*n/2 - 1)/Sqrt[a + b*x^n], x, 4, (2*(c*x)^(n/2)*ArcTanh[(Sqrt[b]*x^(n/2))/Sqrt[a + b*x^n]])/(x^(n/2)*(Sqrt[b]*c*n))}
{(c*x)^(-1*n/2 - 1)/Sqrt[a + b*x^n], x, 1, -((2*Sqrt[a + b*x^n])/((c*x)^(n/2)*(a*c*n)))}
{(c*x)^(-3*n/2 - 1)/Sqrt[a + b*x^n], x, 2, -((2*Sqrt[a + b*x^n])/((c*x)^((3*n)/2)*(a*c*n))) + (4*(a + b*x^n)^(3/2))/((c*x)^((3*n)/2)*(3*a^2*c*n))}
{(c*x)^(-5*n/2 - 1)/Sqrt[a + b*x^n], x, 3, -((2*Sqrt[a + b*x^n])/((c*x)^((5*n)/2)*(a*c*n))) + (8*(a + b*x^n)^(3/2))/((c*x)^((5*n)/2)*(3*a^2*c*n)) - (16*(a + b*x^n)^(5/2))/((c*x)^((5*n)/2)*(15*a^3*c*n))}
{(c*x)^(-7*n/2 - 1)/Sqrt[a + b*x^n], x, 4, -((2*Sqrt[a + b*x^n])/((c*x)^((7*n)/2)*(a*c*n))) + (4*(a + b*x^n)^(3/2))/((c*x)^((7*n)/2)*(a^2*c*n)) - (16*(a + b*x^n)^(5/2))/((c*x)^((7*n)/2)*(5*a^3*c*n)) + (32*(a + b*x^n)^(7/2))/((c*x)^((7*n)/2)*(35*a^4*c*n))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (c x)^m (a+b x^n)^p with p symbolic*)


{(c*x)^m*(a + b*x^n)^p, x, 2, ((c*x)^(1 + m)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, 1 + (1 + m)/n + p, (1 + m + n)/n, -((b*x^n)/a)])/(a*c*(1 + m)), ((c*x)^(1 + m)*(a + b*x^n)^p*Hypergeometric2F1[(1 + m)/n, -p, (1 + m + n)/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(c*(1 + m)))}


{(a + b*x^n)^p*(c*x)^(3*n), x, 2, ((c*x)^(1 + 3*n)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, 4 + 1/n + p, 4 + 1/n, -((b*x^n)/a)])/(a*c*(1 + 3*n)), ((c*x)^(1 + 3*n)*(a + b*x^n)^p*Hypergeometric2F1[3 + 1/n, -p, 4 + 1/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(c*(1 + 3*n)))}
{(a + b*x^n)^p*(c*x)^(2*n), x, 2, ((c*x)^(1 + 2*n)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, 3 + 1/n + p, 3 + 1/n, -((b*x^n)/a)])/(a*c*(1 + 2*n)), ((c*x)^(1 + 2*n)*(a + b*x^n)^p*Hypergeometric2F1[2 + 1/n, -p, 3 + 1/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(c*(1 + 2*n)))}
{(a + b*x^n)^p*(c*x)^(1*n), x, 2, ((c*x)^(1 + n)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, 2 + 1/n + p, 2 + 1/n, -((b*x^n)/a)])/(a*c*(1 + n)), ((c*x)^(1 + n)*(a + b*x^n)^p*Hypergeometric2F1[1 + 1/n, -p, 2 + 1/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(c*(1 + n)))}
{(a + b*x^n)^p*(c*x)^(0*n), x, 2, (x*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, 1 + 1/n + p, 1 + 1/n, -((b*x^n)/a)])/a, (x*(a + b*x^n)^p*Hypergeometric2F1[1/n, -p, 1 + 1/n, -((b*x^n)/a)])/(1 + (b*x^n)/a)^p}
{(a + b*x^n)^p/(c*x)^(1*n), x, 2, ((c*x)^(1 - n)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, 1/n + p, 1/n, -((b*x^n)/a)])/(a*c*(1 - n)), ((c*x)^(1 - n)*(a + b*x^n)^p*Hypergeometric2F1[-1 + 1/n, -p, 1/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(c*(1 - n)))}
{(a + b*x^n)^p/(c*x)^(2*n), x, 2, ((c*x)^(1 - 2*n)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, -1 + 1/n + p, -1 + 1/n, -((b*x^n)/a)])/(a*c*(1 - 2*n)), ((c*x)^(1 - 2*n)*(a + b*x^n)^p*Hypergeometric2F1[-2 + 1/n, -p, -1 + 1/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(c*(1 - 2*n)))}
{(a + b*x^n)^p/(c*x)^(3*n), x, 2, ((c*x)^(1 - 3*n)*(a + b*x^n)^(1 + p)*Hypergeometric2F1[1, -2 + 1/n + p, -2 + 1/n, -((b*x^n)/a)])/(a*c*(1 - 3*n)), ((c*x)^(1 - 3*n)*(a + b*x^n)^p*Hypergeometric2F1[-3 + 1/n, -p, -2 + 1/n, -((b*x^n)/a)])/((1 + (b*x^n)/a)^p*(c*(1 - 3*n)))}


{(a + b*x^n)^p/(c*x)^(n*p + 0*n + 1), x, 2, -(((a + b*x^n)^p*Hypergeometric2F1[-p, -p, 1 - p, -((b*x^n)/a)])/((c*x)^(n*p)*(1 + (b*x^n)/a)^p*(c*n*p)))}
{(a + b*x^n)^p/(c*x)^(n*p + 1*n + 1), x, 1, -((a + b*x^n)^(1 + p)/((c*x)^(n*(1 + p))*(a*c*n*(1 + p))))}
{(a + b*x^n)^p/(c*x)^(n*p + 2*n + 1), x, 2, -((a + b*x^n)^(1 + p)/((c*x)^(n*(2 + p))*(a*c*n*(1 + p)))) + (a + b*x^n)^(2 + p)/((c*x)^(n*(2 + p))*(a^2*c*n*(1 + p)*(2 + p)))}
{(a + b*x^n)^p/(c*x)^(n*p + 3*n + 1), x, 3, -((a + b*x^n)^(1 + p)/((c*x)^(n*(3 + p))*(a*c*n*(1 + p)))) + (2*(a + b*x^n)^(2 + p))/((c*x)^(n*(3 + p))*(a^2*c*n*(1 + p)*(2 + p))) - (2*(a + b*x^n)^(3 + p))/((c*x)^(n*(3 + p))*(a^3*c*n*(1 + p)*(2 + p)*(3 + p)))}
{(a + b*x^n)^p/(c*x)^(n*p + 4*n + 1), x, 4, If[$VersionNumber>=8, -((a + b*x^n)^(1 + p)/((c*x)^(n*(4 + p))*(a*c*n*(1 + p)))) + (3*(a + b*x^n)^(2 + p))/((c*x)^(n*(4 + p))*(a^2*c*n*(1 + p)*(2 + p))) - (6*(a + b*x^n)^(3 + p))/((c*x)^(n*(4 + p))*(a^3*c*n*(1 + p)*(2 + p)*(3 + p))) + (6*(a + b*x^n)^(4 + p))/((c*x)^(n*(4 + p))*(a^4*c*n*(1 + p)*(2 + p)*(3 + p)*(4 + p))), -((a + b*x^n)^(1 + p)/((c*x)^(n*(4 + p))*(a*c*n*(1 + p)))) + (3*(a + b*x^n)^(2 + p))/((c*x)^(n*(4 + p))*(a^2*c*n*(1 + p)*(2 + p))) - (6*(a + b*x^n)^(3 + p))/((c*x)^(n*(4 + p))*(a^3*c*n*(1 + p)*(2 + p)*(3 + p))) + (6*(a + b*x^n)^(4 + p))/((c*x)^(n*(4 + p))*(a^4*c*n*(2 + 3*p + p^2)*(12 + 7*p + p^2)))]}


(* ::Title::Closed:: *)
(*Integrands of the form (c+d x)^m (b (c+d x)^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (b (c+d x)^2)^p*)


{(c*(a + b*x)^2)^(5/2), x, 3, (c^2*(a + b*x)^5*Sqrt[c*(a + b*x)^2])/(6*b)}
{(c*(a + b*x)^2)^(3/2), x, 3, (c*(a + b*x)^3*Sqrt[c*(a + b*x)^2])/(4*b)}
{(c*(a + b*x)^2)^(1/2), x, 3, ((a + b*x)*Sqrt[c*(a + b*x)^2])/(2*b)}
{1/(c*(a + b*x)^2)^(1/2), x, 3, ((a + b*x)*Log[a + b*x])/(b*Sqrt[c*(a + b*x)^2])}
{1/(c*(a + b*x)^2)^(3/2), x, 3, -(1/(2*b*c*(a + b*x)*Sqrt[c*(a + b*x)^2]))}
{1/(c*(a + b*x)^2)^(5/2), x, 3, -(1/(4*b*c^2*(a + b*x)^3*Sqrt[c*(a + b*x)^2]))}


{Sqrt[(3 + 5*x)^2], x, 3, (1/10)*(3 + 5*x)*Sqrt[(3 + 5*x)^2]}
{Sqrt[(6 + 10*x)^2], x, 3, (1/5)*(3 + 5*x)*Sqrt[(3 + 5*x)^2]}

{1/Sqrt[(3 + 5*x)^2], x, 3, (3 + 5*x)*(Log[3 + 5*x]/(5*Sqrt[(3 + 5*x)^2]))}
{1/Sqrt[(6 + 10*x)^2], x, 3, ((3 + 5*x)*Log[3 + 5*x])/(10*Sqrt[(3 + 5*x)^2]), ((3 + 5*x)*Log[6 + 10*x])/(10*Sqrt[(3 + 5*x)^2])}


{1/Sqrt[-(2 + 3*x)^2], x, 3, ((2 + 3*x)*Log[2 + 3*x])/(3*Sqrt[-(2 + 3*x)^2])}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (b (c+d x)^3)^p*)


{(c*(a + b*x)^3)^(5/2), x, 3, (2*c^2*(a + b*x)^7*Sqrt[c*(a + b*x)^3])/(17*b)}
{(c*(a + b*x)^3)^(3/2), x, 3, (2*c*(a + b*x)^4*Sqrt[c*(a + b*x)^3])/(11*b)}
{(c*(a + b*x)^3)^(1/2), x, 3, (2*(a + b*x)*Sqrt[c*(a + b*x)^3])/(5*b)}
{1/(c*(a + b*x)^3)^(1/2), x, 3, -((2*(a + b*x))/(b*Sqrt[c*(a + b*x)^3]))}
{1/(c*(a + b*x)^3)^(3/2), x, 3, -(2/(7*b*c*(a + b*x)^2*Sqrt[c*(a + b*x)^3]))}
{1/(c*(a + b*x)^3)^(5/2), x, 3, -(2/(13*b*c^2*(a + b*x)^5*Sqrt[c*(a + b*x)^3]))}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (b (c+d x)^(-1))^p*)


{(c/(a + b*x))^(5/2), x, 3, -((2*c^2*Sqrt[c/(a + b*x)])/(3*b*(a + b*x)))}
{(c/(a + b*x))^(3/2), x, 3, -((2*c*Sqrt[c/(a + b*x)])/b)}
{(c/(a + b*x))^(1/2), x, 3, (2*Sqrt[c/(a + b*x)]*(a + b*x))/b}
{1/(c/(a + b*x))^(1/2), x, 3, (2*(a + b*x))/(3*b*Sqrt[c/(a + b*x)])}
{1/(c/(a + b*x))^(3/2), x, 3, (2*(a + b*x)^2)/(5*b*c*Sqrt[c/(a + b*x)])}
{1/(c/(a + b*x))^(5/2), x, 3, (2*(a + b*x)^3)/(7*b*c^2*Sqrt[c/(a + b*x)])}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (b (c+d x)^(-2))^p*)


{(c/(a + b*x)^2)^(5/2), x, 3, -((c^2*Sqrt[c/(a + b*x)^2])/(4*b*(a + b*x)^3))}
{(c/(a + b*x)^2)^(3/2), x, 3, -((c*Sqrt[c/(a + b*x)^2])/(2*b*(a + b*x)))}
{(c/(a + b*x)^2)^(1/2), x, 3, (Sqrt[c/(a + b*x)^2]*(a + b*x)*Log[a + b*x])/b}
{1/(c/(a + b*x)^2)^(1/2), x, 3, (a + b*x)/(2*b*Sqrt[c/(a + b*x)^2])}
{1/(c/(a + b*x)^2)^(3/2), x, 3, (a + b*x)^3/(4*b*c*Sqrt[c/(a + b*x)^2])}
{1/(c/(a + b*x)^2)^(5/2), x, 3, (a + b*x)^5/(6*b*c^2*Sqrt[c/(a + b*x)^2])}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (b (c+d x)^(-3))^p*)


{(c/(a + b*x)^3)^(5/2), x, 3, -((2*c^2*Sqrt[c/(a + b*x)^3])/(13*b*(a + b*x)^5))}
{(c/(a + b*x)^3)^(3/2), x, 3, -((2*c*Sqrt[c/(a + b*x)^3])/(7*b*(a + b*x)^2))}
{(c/(a + b*x)^3)^(1/2), x, 3, -((2*Sqrt[c/(a + b*x)^3]*(a + b*x))/b)}
{1/(c/(a + b*x)^3)^(1/2), x, 3, (2*(a + b*x))/(5*b*Sqrt[c/(a + b*x)^3])}
{1/(c/(a + b*x)^3)^(3/2), x, 3, (2*(a + b*x)^4)/(11*b*c*Sqrt[c/(a + b*x)^3])}
{1/(c/(a + b*x)^3)^(5/2), x, 3, (2*(a + b*x)^7)/(17*b*c^2*Sqrt[c/(a + b*x)^3])}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (b (c+d x)^n)^p*)


{(c*(a + b*x)^(3/2))^(2/3), x, 3, ((a + b*x)*(c*(a + b*x)^(3/2))^(2/3))/(2*b)}
{(c*(a + b*x)^(2/3))^(3/2), x, 3, (c*Sqrt[c*(a + b*x)^(2/3)]*(a + b*x)^(5/3))/(2*b)}


{1/(c/(a + b*x)^(3/2))^(2/3), x, 3, (a + b*x)/(2*b*(c/(a + b*x)^(3/2))^(2/3))}
{1/(c/(a + b*x)^(2/3))^(3/2), x, 3, (a + b*x)^(5/3)/(2*b*c*Sqrt[c/(a + b*x)^(2/3)])}


(* ::Title::Closed:: *)
(*Integrands of the form (c+d x)^m (a+b (c+d x)^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (a+b (c+d x)^2)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(c + d*x)^3*(a + b*(c + d*x)^2), x, 3, (a*(c + d*x)^4)/(4*d) + (b*(c + d*x)^6)/(6*d)}
{(c + d*x)^3*(a + b*(c + d*x)^2)^2, x, 4, (a^2*(c + d*x)^4)/(4*d) + (a*b*(c + d*x)^6)/(3*d) + (b^2*(c + d*x)^8)/(8*d)}
{(c + d*x)^3*(a + b*(c + d*x)^2)^3, x, 4, -((a*(a + b*(c + d*x)^2)^4)/(8*b^2*d)) + (a + b*(c + d*x)^2)^5/(10*b^2*d)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{(2 + x)/(1 + (2 + x)^2), x, 2, (1/2)*Log[1 + (2 + x)^2]}
{(2 + x)/(1 + (2 + x)^2)^2, x, 2, -(1/(2*(1 + (2 + x)^2)))}
{(2 + x)/(1 + (2 + x)^2)^3, x, 2, -(1/(4*(1 + (2 + x)^2)^2))}


(* ::Subsubsection::Closed:: *)
(*p symbolic*)


{(c + d*x)^5*(a + b*(c + d*x)^2)^p, x, 4, (a^2*(a + b*(c + d*x)^2)^(1 + p))/(2*b^3*d*(1 + p)) - (a*(a + b*(c + d*x)^2)^(2 + p))/(b^3*d*(2 + p)) + (a + b*(c + d*x)^2)^(3 + p)/(2*b^3*d*(3 + p))}
{(c + d*x)^4*(a + b*(c + d*x)^2)^p, x, 3, ((c + d*x)^5*(a + b*(c + d*x)^2)^(1 + p)*Hypergeometric2F1[1, 7/2 + p, 7/2, -((b*(c + d*x)^2)/a)])/(5*a*d), ((c + d*x)^5*(a + b*(c + d*x)^2)^p*Hypergeometric2F1[5/2, -p, 7/2, -((b*(c + d*x)^2)/a)])/((1 + (b*(c + d*x)^2)/a)^p*(5*d))}
{(c + d*x)^3*(a + b*(c + d*x)^2)^p, x, 4, -((a*(a + b*(c + d*x)^2)^(1 + p))/(2*b^2*d*(1 + p))) + (a + b*(c + d*x)^2)^(2 + p)/(2*b^2*d*(2 + p))}
{(c + d*x)^2*(a + b*(c + d*x)^2)^p, x, 3, ((c + d*x)^3*(a + b*(c + d*x)^2)^(1 + p)*Hypergeometric2F1[1, 5/2 + p, 5/2, -((b*(c + d*x)^2)/a)])/(3*a*d), ((c + d*x)^3*(a + b*(c + d*x)^2)^p*Hypergeometric2F1[3/2, -p, 5/2, -((b*(c + d*x)^2)/a)])/((1 + (b*(c + d*x)^2)/a)^p*(3*d))}
{(c + d*x)^1*(a + b*(c + d*x)^2)^p, x, 2, (a + b*(c + d*x)^2)^(1 + p)/(2*b*d*(1 + p))}
{(a + b*(c + d*x)^2)^p/(c + d*x)^1, x, 3, -(((a + b*(c + d*x)^2)^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*(c + d*x)^2)/a])/(2*a*d*(1 + p)))}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (a+b (c+d x)^3)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(c + d*x)^3*(a + b*(c + d*x)^3), x, 3, (a*(c + d*x)^4)/(4*d) + (b*(c + d*x)^7)/(7*d)}
{(c + d*x)^3*(a + b*(c + d*x)^3)^2, x, 3, (a^2*(c + d*x)^4)/(4*d) + (2*a*b*(c + d*x)^7)/(7*d) + (b^2*(c + d*x)^10)/(10*d)}
{(c + d*x)^3*(a + b*(c + d*x)^3)^3, x, 3, (1/4)*a^3*((c + d*x)^4/d) + (3/(7*d))*a^2*b*(c + d*x)^7 + (3/(10*d))*a*b^2*(c + d*x)^10 + (1/(13*d))*b^3*(c + d*x)^13}


{(c*e + d*e*x)^3*(a + b*(c + d*x)^3), x, 3, (a*e^3*(c + d*x)^4)/(4*d) + (b*e^3*(c + d*x)^7)/(7*d)}
{(c*e + d*e*x)^3*(a + b*(c + d*x)^3)^2, x, 3, (a^2*e^3*(c + d*x)^4)/(4*d) + (2*a*b*e^3*(c + d*x)^7)/(7*d) + (b^2*e^3*(c + d*x)^10)/(10*d)}
{(c*e + d*e*x)^3*(a + b*(c + d*x)^3)^3, x, 3, (a^3*e^3*(c + d*x)^4)/(4*d) + (3*a^2*b*e^3*(c + d*x)^7)/(7*d) + (3*a*b^2*e^3*(c + d*x)^10)/(10*d) + (b^3*e^3*(c + d*x)^13)/(13*d)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{(c + d*x)^4/(a + b*(c + d*x)^3), x, 8, (c + d*x)^2/(2*b*d) + (a^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(5/3)*d) + (a^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*b^(5/3)*d) - (a^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*b^(5/3)*d)}
{(c + d*x)^3/(a + b*(c + d*x)^3), x, 8, x/b + (a^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(4/3)*d) - (a^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*b^(4/3)*d) + (a^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*b^(4/3)*d)}
{(c + d*x)^2/(a + b*(c + d*x)^3), x, 2, Log[a + b*(c + d*x)^3]/(3*b*d)}
{(c + d*x)^1/(a + b*(c + d*x)^3), x, 7, -(ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(1/3)*b^(2/3)*d)) - Log[a^(1/3) + b^(1/3)*(c + d*x)]/(3*a^(1/3)*b^(2/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(6*a^(1/3)*b^(2/3)*d)}
{(c + d*x)^0/(a + b*(c + d*x)^3), x, 7, -(ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(Sqrt[3]*a^(2/3)*b^(1/3)*d)) + Log[a^(1/3) + b^(1/3)*(c + d*x)]/(3*a^(2/3)*b^(1/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(6*a^(2/3)*b^(1/3)*d)}
{1/((c + d*x)^1*(a + b*(c + d*x)^3)), x, 5, Log[c + d*x]/(a*d) - Log[a + b*(c + d*x)^3]/(3*a*d)}
{1/((c + d*x)^2*(a + b*(c + d*x)^3)), x, 8, -(1/(a*d*(c + d*x))) + (b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)*d) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(4/3)*d) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(4/3)*d)}
{1/((c + d*x)^3*(a + b*(c + d*x)^3)), x, 8, -(1/(2*a*d*(c + d*x)^2)) + (b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)*d) - (b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(5/3)*d) + (b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(5/3)*d)}
{1/((c + d*x)^4*(a + b*(c + d*x)^3)), x, 4, -(1/(3*a*d*(c + d*x)^3)) - (b*Log[c + d*x])/(a^2*d) + (b*Log[a + b*(c + d*x)^3])/(3*a^2*d)}


{(c + d*x)^4/(a + b*(c + d*x)^3)^2, x, 8, -((c + d*x)^2/(3*b*d*(a + b*(c + d*x)^3))) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(1/3)*b^(5/3)*d) - (2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(1/3)*b^(5/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(9*a^(1/3)*b^(5/3)*d)}
{(c + d*x)^3/(a + b*(c + d*x)^3)^2, x, 8, -((c + d*x)/(3*b*d*(a + b*(c + d*x)^3))) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(2/3)*b^(4/3)*d) + Log[a^(1/3) + b^(1/3)*(c + d*x)]/(9*a^(2/3)*b^(4/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(18*a^(2/3)*b^(4/3)*d)}
{(c + d*x)^2/(a + b*(c + d*x)^3)^2, x, 2, -(1/(3*b*d*(a + b*(c + d*x)^3)))}
{(c + d*x)^1/(a + b*(c + d*x)^3)^2, x, 8, (c + d*x)^2/(3*a*d*(a + b*(c + d*x)^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(3*Sqrt[3]*a^(4/3)*b^(2/3)*d) - Log[a^(1/3) + b^(1/3)*(c + d*x)]/(9*a^(4/3)*b^(2/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(18*a^(4/3)*b^(2/3)*d)}
{(c + d*x)^0/(a + b*(c + d*x)^3)^2, x, 8, (c + d*x)/(3*a*d*(a + b*(c + d*x)^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(5/3)*b^(1/3)*d) + (2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(5/3)*b^(1/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(9*a^(5/3)*b^(1/3)*d)}
{1/((c + d*x)^1*(a + b*(c + d*x)^3)^2), x, 4, 1/(3*a*d*(a + b*(c + d*x)^3)) + Log[c + d*x]/(a^2*d) - Log[a + b*(c + d*x)^3]/(3*a^2*d)}
{1/((c + d*x)^2*(a + b*(c + d*x)^3)^2), x, 9, -(4/(3*a^2*d*(c + d*x))) + 1/(3*a*d*(c + d*x)*(a + b*(c + d*x)^3)) + (4*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)*d) + (4*b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(7/3)*d) - (2*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(9*a^(7/3)*d)}
{1/((c + d*x)^3*(a + b*(c + d*x)^3)^2), x, 9, -(5/(6*a^2*d*(c + d*x)^2)) + 1/(3*a*d*(c + d*x)^2*(a + b*(c + d*x)^3)) + (5*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(8/3)*d) - (5*b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(8/3)*d) + (5*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(18*a^(8/3)*d)}
{1/((c + d*x)^4*(a + b*(c + d*x)^3)^2), x, 4, -(1/(3*a^2*d*(c + d*x)^3)) - b/(3*a^2*d*(a + b*(c + d*x)^3)) - (2*b*Log[c + d*x])/(a^3*d) + (2*b*Log[a + b*(c + d*x)^3])/(3*a^3*d)}


{(c + d*x)^4/(a + b*(c + d*x)^3)^3, x, 9, -((c + d*x)^2/(6*b*d*(a + b*(c + d*x)^3)^2)) + (c + d*x)^2/(9*a*b*d*(a + b*(c + d*x)^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(4/3)*b^(5/3)*d) - Log[a^(1/3) + b^(1/3)*(c + d*x)]/(27*a^(4/3)*b^(5/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(54*a^(4/3)*b^(5/3)*d)}
{(c + d*x)^3/(a + b*(c + d*x)^3)^3, x, 9, -((c + d*x)/(6*b*d*(a + b*(c + d*x)^3)^2)) + (c + d*x)/(18*a*b*d*(a + b*(c + d*x)^3)) - ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))]/(9*Sqrt[3]*a^(5/3)*b^(4/3)*d) + Log[a^(1/3) + b^(1/3)*(c + d*x)]/(27*a^(5/3)*b^(4/3)*d) - Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(54*a^(5/3)*b^(4/3)*d)}
{(c + d*x)^2/(a + b*(c + d*x)^3)^3, x, 2, -(1/(6*b*d*(a + b*(c + d*x)^3)^2))}
{(c + d*x)^1/(a + b*(c + d*x)^3)^3, x, 9, (c + d*x)^2/(6*a*d*(a + b*(c + d*x)^3)^2) + (2*(c + d*x)^2)/(9*a^2*d*(a + b*(c + d*x)^3)) - (2*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(7/3)*b^(2/3)*d) - (2*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(7/3)*b^(2/3)*d) + Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2]/(27*a^(7/3)*b^(2/3)*d)}
{(c + d*x)^0/(a + b*(c + d*x)^3)^3, x, 9, (c + d*x)/(6*a*d*(a + b*(c + d*x)^3)^2) + (5*(c + d*x))/(18*a^2*d*(a + b*(c + d*x)^3)) - (5*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(8/3)*b^(1/3)*d) + (5*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(8/3)*b^(1/3)*d) - (5*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(54*a^(8/3)*b^(1/3)*d)}
{1/((c + d*x)^1*(a + b*(c + d*x)^3)^3), x, 4, 1/(6*a*d*(a + b*(c + d*x)^3)^2) + 1/(3*a^2*d*(a + b*(c + d*x)^3)) + Log[c + d*x]/(a^3*d) - Log[a + b*(c + d*x)^3]/(3*a^3*d)}
{1/((c + d*x)^2*(a + b*(c + d*x)^3)^3), x, 10, -(14/(9*a^3*d*(c + d*x))) + 1/(6*a*d*(c + d*x)*(a + b*(c + d*x)^3)^2) + 7/(18*a^2*d*(c + d*x)*(a + b*(c + d*x)^3)) + (14*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(10/3)*d) + (14*b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(10/3)*d) - (7*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(27*a^(10/3)*d)}
{1/((c + d*x)^3*(a + b*(c + d*x)^3)^3), x, 10, -(10/(9*a^3*d*(c + d*x)^2)) + 1/(6*a*d*(c + d*x)^2*(a + b*(c + d*x)^3)^2) + 4/(9*a^2*d*(c + d*x)^2*(a + b*(c + d*x)^3)) + (20*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(11/3)*d) - (20*b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(11/3)*d) + (10*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(27*a^(11/3)*d)}
{1/((c + d*x)^4*(a + b*(c + d*x)^3)^3), x, 4, -(1/(3*a^3*d*(c + d*x)^3)) - b/(6*a^2*d*(a + b*(c + d*x)^3)^2) - (2*b)/(3*a^3*d*(a + b*(c + d*x)^3)) - (3*b*Log[c + d*x])/(a^4*d) + (b*Log[a + b*(c + d*x)^3])/(a^4*d)}


{(c*e + d*e*x)^4/(a + b*(c + d*x)^3), x, 8, (e^4*(c + d*x)^2)/(2*b*d) + (a^(2/3)*e^4*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(5/3)*d) + (a^(2/3)*e^4*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*b^(5/3)*d) - (a^(2/3)*e^4*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*b^(5/3)*d)}
{(c*e + d*e*x)^3/(a + b*(c + d*x)^3), x, 8, (e^3*x)/b + (a^(1/3)*e^3*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*b^(4/3)*d) - (a^(1/3)*e^3*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*b^(4/3)*d) + (a^(1/3)*e^3*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*b^(4/3)*d)}
{(c*e + d*e*x)^2/(a + b*(c + d*x)^3), x, 2, (e^2*Log[a + b*(c + d*x)^3])/(3*b*d)}
{(c*e + d*e*x)^1/(a + b*(c + d*x)^3), x, 7, -((e*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(1/3)*b^(2/3)*d)) - (e*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(1/3)*b^(2/3)*d) + (e*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(1/3)*b^(2/3)*d)}
{1/((c*e + d*e*x)^1*(a + b*(c + d*x)^3)), x, 5, Log[c + d*x]/(a*d*e) - Log[a + b*(c + d*x)^3]/(3*a*d*e)}
{1/((c*e + d*e*x)^2*(a + b*(c + d*x)^3)), x, 8, -(1/(a*d*e^2*(c + d*x))) + (b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(4/3)*d*e^2) + (b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(4/3)*d*e^2) - (b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(4/3)*d*e^2)}
{1/((c*e + d*e*x)^3*(a + b*(c + d*x)^3)), x, 8, -1/(2*a*d*e^3*(c + d*x)^2) + (b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(Sqrt[3]*a^(5/3)*d*e^3) - (b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(3*a^(5/3)*d*e^3) + (b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(6*a^(5/3)*d*e^3)}
{1/((c*e + d*e*x)^4*(a + b*(c + d*x)^3)), x, 4, -1/(3*a*d*e^4*(c + d*x)^3) - (b*Log[c + d*x])/(a^2*d*e^4) + (b*Log[a + b*(c + d*x)^3])/(3*a^2*d*e^4)}


{(c*e + d*e*x)^4/(a + b*(c + d*x)^3)^2, x, 8, -(e^4*(c + d*x)^2)/(3*b*d*(a + b*(c + d*x)^3)) - (2*e^4*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(1/3)*b^(5/3)*d) - (2*e^4*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(1/3)*b^(5/3)*d) + (e^4*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(9*a^(1/3)*b^(5/3)*d)}
{(c*e + d*e*x)^3/(a + b*(c + d*x)^3)^2, x, 8, -(e^3*(c + d*x))/(3*b*d*(a + b*(c + d*x)^3)) - (e^3*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(2/3)*b^(4/3)*d) + (e^3*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(2/3)*b^(4/3)*d) - (e^3*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(18*a^(2/3)*b^(4/3)*d)}
{(c*e + d*e*x)^2/(a + b*(c + d*x)^3)^2, x, 2, -e^2/(3*b*d*(a + b*(c + d*x)^3))}
{(c*e + d*e*x)^1/(a + b*(c + d*x)^3)^2, x, 8, (e*(c + d*x)^2)/(3*a*d*(a + b*(c + d*x)^3)) - (e*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(4/3)*b^(2/3)*d) - (e*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(4/3)*b^(2/3)*d) + (e*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(18*a^(4/3)*b^(2/3)*d)}
{1/((c*e + d*e*x)^1*(a + b*(c + d*x)^3)^2), x, 4, 1/(3*a*d*e*(a + b*(c + d*x)^3)) + Log[c + d*x]/(a^2*d*e) - Log[a + b*(c + d*x)^3]/(3*a^2*d*e)}
{1/((c*e + d*e*x)^2*(a + b*(c + d*x)^3)^2), x, 9, -4/(3*a^2*d*e^2*(c + d*x)) + 1/(3*a*d*e^2*(c + d*x)*(a + b*(c + d*x)^3)) + (4*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(7/3)*d*e^2) + (4*b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(7/3)*d*e^2) - (2*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(9*a^(7/3)*d*e^2)}
{1/((c*e + d*e*x)^3*(a + b*(c + d*x)^3)^2), x, 9, -5/(6*a^2*d*e^3*(c + d*x)^2) + 1/(3*a*d*e^3*(c + d*x)^2*(a + b*(c + d*x)^3)) + (5*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(3*Sqrt[3]*a^(8/3)*d*e^3) - (5*b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(9*a^(8/3)*d*e^3) + (5*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(18*a^(8/3)*d*e^3)}
{1/((c*e + d*e*x)^4*(a + b*(c + d*x)^3)^2), x, 4, -(1/(3*a^2*d*e^4*(c + d*x)^3)) - b/(3*a^2*d*e^4*(a + b*(c + d*x)^3)) - (2*b*Log[c + d*x])/(a^3*d*e^4) + (2*b*Log[a + b*(c + d*x)^3])/(3*a^3*d*e^4)}


{(c*e + d*e*x)^4/(a + b*(c + d*x)^3)^3, x, 9, -(e^4*(c + d*x)^2)/(6*b*d*(a + b*(c + d*x)^3)^2) + (e^4*(c + d*x)^2)/(9*a*b*d*(a + b*(c + d*x)^3)) - (e^4*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(4/3)*b^(5/3)*d) - (e^4*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(4/3)*b^(5/3)*d) + (e^4*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(54*a^(4/3)*b^(5/3)*d)}
{(c*e + d*e*x)^3/(a + b*(c + d*x)^3)^3, x, 9, -(e^3*(c + d*x))/(6*b*d*(a + b*(c + d*x)^3)^2) + (e^3*(c + d*x))/(18*a*b*d*(a + b*(c + d*x)^3)) - (e^3*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(5/3)*b^(4/3)*d) + (e^3*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(5/3)*b^(4/3)*d) - (e^3*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(54*a^(5/3)*b^(4/3)*d)}
{(c*e + d*e*x)^2/(a + b*(c + d*x)^3)^3, x, 2, -e^2/(6*b*d*(a + b*(c + d*x)^3)^2)}
{(c*e + d*e*x)^1/(a + b*(c + d*x)^3)^3, x, 9, (e*(c + d*x)^2)/(6*a*d*(a + b*(c + d*x)^3)^2) + (2*e*(c + d*x)^2)/(9*a^2*d*(a + b*(c + d*x)^3)) - (2*e*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(7/3)*b^(2/3)*d) - (2*e*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(7/3)*b^(2/3)*d) + (e*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(27*a^(7/3)*b^(2/3)*d)}
{1/((c*e + d*e*x)^1*(a + b*(c + d*x)^3)^3), x, 4, 1/(6*a*d*e*(a + b*(c + d*x)^3)^2) + 1/(3*a^2*d*e*(a + b*(c + d*x)^3)) + Log[c + d*x]/(a^3*d*e) - Log[a + b*(c + d*x)^3]/(3*a^3*d*e)}
{1/((c*e + d*e*x)^2*(a + b*(c + d*x)^3)^3), x, 10, -14/(9*a^3*d*e^2*(c + d*x)) + 1/(6*a*d*e^2*(c + d*x)*(a + b*(c + d*x)^3)^2) + 7/(18*a^2*d*e^2*(c + d*x)*(a + b*(c + d*x)^3)) + (14*b^(1/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(10/3)*d*e^2) + (14*b^(1/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(10/3)*d*e^2) - (7*b^(1/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(27*a^(10/3)*d*e^2)}
{1/((c*e + d*e*x)^3*(a + b*(c + d*x)^3)^3), x, 10, -10/(9*a^3*d*e^3*(c + d*x)^2) + 1/(6*a*d*e^3*(c + d*x)^2*(a + b*(c + d*x)^3)^2) + 4/(9*a^2*d*e^3*(c + d*x)^2*(a + b*(c + d*x)^3)) + (20*b^(2/3)*ArcTan[(a^(1/3) - 2*b^(1/3)*(c + d*x))/(Sqrt[3]*a^(1/3))])/(9*Sqrt[3]*a^(11/3)*d*e^3) - (20*b^(2/3)*Log[a^(1/3) + b^(1/3)*(c + d*x)])/(27*a^(11/3)*d*e^3) + (10*b^(2/3)*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c + d*x) + b^(2/3)*(c + d*x)^2])/(27*a^(11/3)*d*e^3)}
{1/((c*e + d*e*x)^4*(a + b*(c + d*x)^3)^3), x, 4, -(1/(3*a^3*d*e^4*(c + d*x)^3)) - b/(6*a^2*d*e^4*(a + b*(c + d*x)^3)^2) - (2*b)/(3*a^3*d*e^4*(a + b*(c + d*x)^3)) - (3*b*Log[c + d*x])/(a^4*d*e^4) + (b*Log[a + b*(c + d*x)^3])/(a^4*d*e^4)}


(* ::Section::Closed:: *)
(*Integrands of the form (c+d x)^m (a+b (c+d x)^4)^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(c + d*x)^3*(a + b*(c + d*x)^4)^p, x, 2, (a + b*(c + d*x)^4)^(1 + p)/(4*b*d*(1 + p))}

{(c + d*x)^3*(a + b*(c + d*x)^4)^1, x, 3, (a + b*(c + d*x)^4)^2/(8*b*d), (a*(c + d*x)^4)/(4*d) + (b*(c + d*x)^8)/(8*d)}
{(c + d*x)^3*(a + b*(c + d*x)^4)^2, x, 2, (a + b*(c + d*x)^4)^3/(12*b*d)}
{(c + d*x)^3*(a + b*(c + d*x)^4)^3, x, 2, (a + b*(c + d*x)^4)^4/(16*b*d)}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{(c + d*x)^3/(a + b*(c + d*x)^4), x, 2, Log[a + b*(c + d*x)^4]/(4*b*d)}
{(c + d*x)^3/(a + b*(c + d*x)^4)^2, x, 2, -(1/(4*b*d*(a + b*(c + d*x)^4)))}
{(c + d*x)^3/(a + b*(c + d*x)^4)^3, x, 2, -(1/(8*b*d*(a + b*(c + d*x)^4)^2))}


{1/Sqrt[a + b*(c + d*x)^4], x, 2, ((Sqrt[a] + Sqrt[b]*(c + d*x)^2)*Sqrt[(a + b*(c + d*x)^4)/(Sqrt[a] + Sqrt[b]*(c + d*x)^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*(c + d*x))/a^(1/4)], 1/2])/(2*a^(1/4)*b^(1/4)*d*Sqrt[a + b*(c + d*x)^4])}


{x/Sqrt[a + b*(c + d*x)^4], x, 7, ArcTanh[(Sqrt[b]*(c + d*x)^2)/Sqrt[a + b*(c + d*x)^4]]/(2*Sqrt[b]*d^2) - (c*(Sqrt[a] + Sqrt[b]*(c + d*x)^2)*Sqrt[(a + b*(c + d*x)^4)/(Sqrt[a] + Sqrt[b]*(c + d*x)^2)^2]*EllipticF[2*ArcTan[(b^(1/4)*(c + d*x))/a^(1/4)], 1/2])/(2*a^(1/4)*b^(1/4)*d^2*Sqrt[a + b*(c + d*x)^4])}


(* ::Title::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^q)^n)^p*)


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^1)^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x)^(n/2))^p with m symbolic*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(d*x)^m*Sqrt[a + b*(c*x)^(3/2)], x, 5, (x*(d*x)^m*Sqrt[a + b*(c*x)^(3/2)]*Hypergeometric2F1[-(1/2), (2*(1 + m))/3, (1/3)*(5 + 2*m), -((b*(c*x)^(3/2))/a)])/((1 + m)*Sqrt[1 + (b*(c*x)^(3/2))/a])}
{(d*x)^m*Sqrt[a + b*(c*x)^(1/2)], x, 5, -((4*a*(d*x)^m*(a + b*Sqrt[c*x])^(3/2)*Hypergeometric2F1[3/2, -1 - 2*m, 5/2, 1 + (b*Sqrt[c*x])/a])/((-((b*Sqrt[c*x])/a))^(2*m)*(3*b^2*c)))}
{(d*x)^m*Sqrt[a + b/(c*x)^(1/2)], x, 6, (4*b^2*(d*x)^m*(-(b/(a*Sqrt[c*x])))^(2*m)*(a + b/Sqrt[c*x])^(3/2)*Hypergeometric2F1[3/2, 3 + 2*m, 5/2, 1 + b/(a*Sqrt[c*x])])/(3*a^3*c)}
{(d*x)^m*Sqrt[a + b/(c*x)^(3/2)], x, 6, (x*(d*x)^m*Sqrt[a + b/(c*x)^(3/2)]*Hypergeometric2F1[-(1/2), (-(2/3))*(1 + m), (1/3)*(1 - 2*m), -(b/(a*(c*x)^(3/2)))])/((1 + m)*Sqrt[1 + b/(a*(c*x)^(3/2))])}


(* ::Subsubsection:: *)
(*p<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x)^n)^p with n and p symbolic*)


{(d*x)^m*(a + b*(c*x)^n)^p, x, 3, ((d*x)^(1 + m)*(a + b*(c*x)^n)^p*Hypergeometric2F1[(1 + m)/n, -p, (1 + m + n)/n, -((b*(c*x)^n)/a)])/((1 + (b*(c*x)^n)/a)^p*(d*(1 + m)))}


{x^2*(a + b*(c*x)^n)^p, x, 4, ((1/3)*x^3*(a + b*(c*x)^n)^p*Hypergeometric2F1[3/n, -p, (3 + n)/n, -((b*(c*x)^n)/a)])/(1 + (b*(c*x)^n)/a)^p}
{x^1*(a + b*(c*x)^n)^p, x, 4, ((1/2)*x^2*(a + b*(c*x)^n)^p*Hypergeometric2F1[2/n, -p, (2 + n)/n, -((b*(c*x)^n)/a)])/(1 + (b*(c*x)^n)/a)^p}
{x^0*(a + b*(c*x)^n)^p, x, 3, (x*(a + b*(c*x)^n)^p*Hypergeometric2F1[1/n, -p, 1 + 1/n, -((b*(c*x)^n)/a)])/(1 + (b*(c*x)^n)/a)^p}
{(a + b*(c*x)^n)^p/x^1, x, 4, -(((a + b*(c*x)^n)^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*(c*x)^n)/a])/(a*n*(1 + p)))}
{(a + b*(c*x)^n)^p/x^2, x, 4, -(((a + b*(c*x)^n)^p*Hypergeometric2F1[-(1/n), -p, -((1 - n)/n), -((b*(c*x)^n)/a)])/((1 + (b*(c*x)^n)/a)^p*x))}


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^2)^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c x^2)^(n/2))^(-1)*)


{1/(1 + (x^2)^(3/2)), x, 7, -((x*ArcTan[(1 - 2*Sqrt[x^2])/Sqrt[3]])/(Sqrt[3]*Sqrt[x^2])) - (x*Log[1 + x^2 - Sqrt[x^2]])/(6*Sqrt[x^2]) + (x*Log[1 + Sqrt[x^2]])/(3*Sqrt[x^2])}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c x^2)^(n/2))^(1/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^5*Sqrt[a + b*Sqrt[c*x^2]], x, 3, -((2*a^5*(a + b*Sqrt[c*x^2])^(3/2))/(3*b^6*c^3)) + (2*a^4*(a + b*Sqrt[c*x^2])^(5/2))/(b^6*c^3) - (20*a^3*(a + b*Sqrt[c*x^2])^(7/2))/(7*b^6*c^3) + (20*a^2*(a + b*Sqrt[c*x^2])^(9/2))/(9*b^6*c^3) - (10*a*(a + b*Sqrt[c*x^2])^(11/2))/(11*b^6*c^3) + (2*(a + b*Sqrt[c*x^2])^(13/2))/(13*b^6*c^3)}
{x^3*Sqrt[a + b*Sqrt[c*x^2]], x, 3, -((2*a^3*(a + b*Sqrt[c*x^2])^(3/2))/(3*b^4*c^2)) + (6*a^2*(a + b*Sqrt[c*x^2])^(5/2))/(5*b^4*c^2) - (6*a*(a + b*Sqrt[c*x^2])^(7/2))/(7*b^4*c^2) + (2*(a + b*Sqrt[c*x^2])^(9/2))/(9*b^4*c^2)}
{x^1*Sqrt[a + b*Sqrt[c*x^2]], x, 3, -((2*a*(a + b*Sqrt[c*x^2])^(3/2))/(3*b^2*c)) + (2*(a + b*Sqrt[c*x^2])^(5/2))/(5*b^2*c)}
{Sqrt[a + b*Sqrt[c*x^2]]/x^1, x, 4, 2*Sqrt[a + b*Sqrt[c*x^2]] - 2*Sqrt[a]*ArcTanh[Sqrt[a + b*Sqrt[c*x^2]]/Sqrt[a]]}
{Sqrt[a + b*Sqrt[c*x^2]]/x^3, x, 5, -(Sqrt[a + b*Sqrt[c*x^2]]/(2*x^2)) - (b*c*Sqrt[a + b*Sqrt[c*x^2]])/(4*a*Sqrt[c*x^2]) + (b^2*c*ArcTanh[Sqrt[a + b*Sqrt[c*x^2]]/Sqrt[a]])/(4*a^(3/2))}
{Sqrt[a + b*Sqrt[c*x^2]]/x^5, x, 7, -(Sqrt[a + b*Sqrt[c*x^2]]/(4*x^4)) + (5*b^2*c*Sqrt[a + b*Sqrt[c*x^2]])/(96*a^2*x^2) - (b*c^2*Sqrt[a + b*Sqrt[c*x^2]])/(24*a*(c*x^2)^(3/2)) - (5*b^3*c^2*Sqrt[a + b*Sqrt[c*x^2]])/(64*a^3*Sqrt[c*x^2]) + (5*b^4*c^2*ArcTanh[Sqrt[a + b*Sqrt[c*x^2]]/Sqrt[a]])/(64*a^(7/2))}

{x^4*Sqrt[a + b*Sqrt[c*x^2]], x, 3, (2*a^4*x^5*(a + b*Sqrt[c*x^2])^(3/2))/(3*b^5*(c*x^2)^(5/2)) - (8*a^3*x^5*(a + b*Sqrt[c*x^2])^(5/2))/(5*b^5*(c*x^2)^(5/2)) + (12*a^2*x^5*(a + b*Sqrt[c*x^2])^(7/2))/(7*b^5*(c*x^2)^(5/2)) - (8*a*x^5*(a + b*Sqrt[c*x^2])^(9/2))/(9*b^5*(c*x^2)^(5/2)) + (2*x^5*(a + b*Sqrt[c*x^2])^(11/2))/(11*b^5*(c*x^2)^(5/2))}
{x^2*Sqrt[a + b*Sqrt[c*x^2]], x, 3, (2*a^2*x^3*(a + b*Sqrt[c*x^2])^(3/2))/(3*b^3*(c*x^2)^(3/2)) - (4*a*x^3*(a + b*Sqrt[c*x^2])^(5/2))/(5*b^3*(c*x^2)^(3/2)) + (2*x^3*(a + b*Sqrt[c*x^2])^(7/2))/(7*b^3*(c*x^2)^(3/2))}
{x^0*Sqrt[a + b*Sqrt[c*x^2]], x, 2, (2*x*(a + b*Sqrt[c*x^2])^(3/2))/(3*b*Sqrt[c*x^2])}
{Sqrt[a + b*Sqrt[c*x^2]]/x^2, x, 4, -(Sqrt[a + b*Sqrt[c*x^2]]/x) - (b*Sqrt[c*x^2]*ArcTanh[Sqrt[a + b*Sqrt[c*x^2]]/Sqrt[a]])/(Sqrt[a]*x)}
{Sqrt[a + b*Sqrt[c*x^2]]/x^4, x, 6, -(Sqrt[a + b*Sqrt[c*x^2]]/(3*x^3)) + (b^2*c*Sqrt[a + b*Sqrt[c*x^2]])/(8*a^2*x) - (b*(c*x^2)^(3/2)*Sqrt[a + b*Sqrt[c*x^2]])/(12*a*c*x^5) - (b^3*(c*x^2)^(3/2)*ArcTanh[Sqrt[a + b*Sqrt[c*x^2]]/Sqrt[a]])/(8*a^(5/2)*x^3)}
{Sqrt[a + b*Sqrt[c*x^2]]/x^6, x, 8, -(Sqrt[a + b*Sqrt[c*x^2]]/(5*x^5)) + (7*b^2*c*Sqrt[a + b*Sqrt[c*x^2]])/(240*a^2*x^3) + (7*b^4*c^2*Sqrt[a + b*Sqrt[c*x^2]])/(128*a^4*x) - (b*(c*x^2)^(5/2)*Sqrt[a + b*Sqrt[c*x^2]])/(40*a*c^2*x^9) - (7*b^3*(c*x^2)^(5/2)*Sqrt[a + b*Sqrt[c*x^2]])/(192*a^3*c*x^7) - (7*b^5*(c*x^2)^(5/2)*ArcTanh[Sqrt[a + b*Sqrt[c*x^2]]/Sqrt[a]])/(128*a^(9/2)*x^5)}


{x^8*Sqrt[a + b*(c*x^2)^(3/2)], x, 4, (2*a^2*x^9*(a + b*(c*x^2)^(3/2))^(3/2))/(9*b^3*(c*x^2)^(9/2)) - (4*a*x^9*(a + b*(c*x^2)^(3/2))^(5/2))/(15*b^3*(c*x^2)^(9/2)) + (2*x^9*(a + b*(c*x^2)^(3/2))^(7/2))/(21*b^3*(c*x^2)^(9/2))}
{x^5*Sqrt[a + b*(c*x^2)^(3/2)], x, 4, -((2*a*(a + b*(c*x^2)^(3/2))^(3/2))/(9*b^2*c^3)) + (2*(a + b*(c*x^2)^(3/2))^(5/2))/(15*b^2*c^3)}
{x^2*Sqrt[a + b*(c*x^2)^(3/2)], x, 2, (2*x^3*(a + b*(c*x^2)^(3/2))^(3/2))/(9*b*(c*x^2)^(3/2))}
{Sqrt[a + b*(c*x^2)^(3/2)]/x^1, x, 5, (2/3)*Sqrt[a + b*(c*x^2)^(3/2)] - (2/3)*Sqrt[a]*ArcTanh[Sqrt[a + b*(c*x^2)^(3/2)]/Sqrt[a]]}
{Sqrt[a + b*(c*x^2)^(3/2)]/x^4, x, 5, -(Sqrt[a + b*(c*x^2)^(3/2)]/(3*x^3)) - (b*(c*x^2)^(3/2)*ArcTanh[Sqrt[a + b*(c*x^2)^(3/2)]/Sqrt[a]])/(3*Sqrt[a]*x^3)}

{x^3*Sqrt[a + b*(c*x^2)^(3/2)], x, 4, (2/11)*x^4*Sqrt[a + b*(c*x^2)^(3/2)] + (6*a*Sqrt[c*x^2]*Sqrt[a + b*(c*x^2)^(3/2)])/(55*b*c^2) - (4*3^(3/4)*Sqrt[2 + Sqrt[3]]*a^2*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(55*b^(4/3)*c^2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}
{x^0*Sqrt[a + b*(c*x^2)^(3/2)], x, 3, (2/5)*x*Sqrt[a + b*(c*x^2)^(3/2)] + (2*3^(3/4)*Sqrt[2 + Sqrt[3]]*a*x*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(5*b^(1/3)*Sqrt[c*x^2]*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}
{Sqrt[a + b*(c*x^2)^(3/2)]/x^3, x, 3, -(Sqrt[a + b*(c*x^2)^(3/2)]/(2*x^2)) + (3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(2/3)*c*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(2*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}
{Sqrt[a + b*(c*x^2)^(3/2)]/x^6, x, 4, -(Sqrt[a + b*(c*x^2)^(3/2)]/(5*x^5)) - (3*b*(c*x^2)^(5/2)*Sqrt[a + b*(c*x^2)^(3/2)])/(20*a*c*x^7) - (3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(5/3)*(c*x^2)^(5/2)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(20*a*x^5*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}

{x^4*Sqrt[a + b*(c*x^2)^(3/2)], x, 6, (2/13)*x^5*Sqrt[a + b*(c*x^2)^(3/2)] + (6*a*c*x^7*Sqrt[a + b*(c*x^2)^(3/2)])/(91*b*(c*x^2)^(5/2)) - (24*a^2*x^5*Sqrt[a + b*(c*x^2)^(3/2)])/(91*b^(5/3)*(c*x^2)^(5/2)*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])) + (12*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(7/3)*x^5*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(91*b^(5/3)*(c*x^2)^(5/2)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)]) - (8*Sqrt[2]*3^(3/4)*a^(7/3)*x^5*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(91*b^(5/3)*(c*x^2)^(5/2)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}
{x^1*Sqrt[a + b*(c*x^2)^(3/2)], x, 5, (2/7)*x^2*Sqrt[a + b*(c*x^2)^(3/2)] + (6*a*Sqrt[a + b*(c*x^2)^(3/2)])/(7*b^(2/3)*c*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])) - (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(7*b^(2/3)*c*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)]) + (2*Sqrt[2]*3^(3/4)*a^(4/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(7*b^(2/3)*c*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}
{Sqrt[a + b*(c*x^2)^(3/2)]/x^2, x, 5, -(Sqrt[a + b*(c*x^2)^(3/2)]/x) + (3*b^(1/3)*Sqrt[c*x^2]*Sqrt[a + b*(c*x^2)^(3/2)])/(x*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])) - (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(1/3)*b^(1/3)*Sqrt[c*x^2]*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(2*x*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)]) + (Sqrt[2]*3^(3/4)*a^(1/3)*b^(1/3)*Sqrt[c*x^2]*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(x*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}
{Sqrt[a + b*(c*x^2)^(3/2)]/x^5, x, 6, -(Sqrt[a + b*(c*x^2)^(3/2)]/(4*x^4)) - (3*b*c^2*Sqrt[a + b*(c*x^2)^(3/2)])/(8*a*Sqrt[c*x^2]) + (3*b^(4/3)*c^2*Sqrt[a + b*(c*x^2)^(3/2)])/(8*a*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])) - (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*c^2*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(16*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)]) + (3^(3/4)*b^(4/3)*c^2*(a^(1/3) + b^(1/3)*Sqrt[c*x^2])*Sqrt[(a^(2/3) + b^(2/3)*c*x^2 - a^(1/3)*b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])], -7 - 4*Sqrt[3]])/(4*Sqrt[2]*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^2]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^2])^2]*Sqrt[a + b*(c*x^2)^(3/2)])}


(* ::Subsubsection:: *)
(*n<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^2)^(n/2))^p with m symbolic*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(d*x)^m*Sqrt[a + b*(c*x^2)^(3/2)], x, 3, ((d*x)^(1 + m)*Sqrt[a + b*(c*x^2)^(3/2)]*Hypergeometric2F1[-(1/2), (1 + m)/3, (4 + m)/3, -((b*(c*x^2)^(3/2))/a)])/(d*(1 + m)*Sqrt[1 + (b*(c*x^2)^(3/2))/a])}
{(d*x)^m*Sqrt[a + b*(c*x^2)^(1/2)], x, 3, (2*(d*x)^(1 + m)*(a + b*Sqrt[c*x^2])^(3/2)*Hypergeometric2F1[3/2, -m, 5/2, 1 + (b*Sqrt[c*x^2])/a])/((-((b*Sqrt[c*x^2])/a))^m*(3*b*d*Sqrt[c*x^2]))}
{(d*x)^m*Sqrt[a + b/(c*x^2)^(1/2)], x, 4, -((2*b*(d*x)^(1 + m)*(-(b/(a*Sqrt[c*x^2])))^m*(a + b/Sqrt[c*x^2])^(3/2)*Hypergeometric2F1[3/2, 2 + m, 5/2, 1 + b/(a*Sqrt[c*x^2])])/(3*a^2*d*Sqrt[c*x^2]))}
{(d*x)^m*Sqrt[a + b/(c*x^2)^(3/2)], x, 4, ((d*x)^(1 + m)*Sqrt[a + b/(c*x^2)^(3/2)]*Hypergeometric2F1[-(1/2), (1/3)*(-1 - m), (2 - m)/3, -(b/(a*(c*x^2)^(3/2)))])/(d*(1 + m)*Sqrt[1 + b/(a*(c*x^2)^(3/2))])}


(* ::Subsubsection:: *)
(*p<0*)


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^3)^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c x^3)^(n/2))^(-1)*)


{1/(1 + (x^3)^(2/3)), x, 2, (x*ArcTan[(x^3)^(1/3)])/(x^3)^(1/3)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c x^3)^(n/2))^(1/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^5*Sqrt[a + b*Sqrt[c*x^3]], x, 4, -((4*a^3*(a + b*Sqrt[c*x^3])^(3/2))/(9*b^4*c^2)) + (4*a^2*(a + b*Sqrt[c*x^3])^(5/2))/(5*b^4*c^2) - (4*a*(a + b*Sqrt[c*x^3])^(7/2))/(7*b^4*c^2) + (4*(a + b*Sqrt[c*x^3])^(9/2))/(27*b^4*c^2)}
{x^2*Sqrt[a + b*Sqrt[c*x^3]], x, 4, -((4*a*(a + b*Sqrt[c*x^3])^(3/2))/(9*b^2*c)) + (4*(a + b*Sqrt[c*x^3])^(5/2))/(15*b^2*c)}
{Sqrt[a + b*Sqrt[c*x^3]]/x^1, x, 5, (4/3)*Sqrt[a + b*Sqrt[c*x^3]] - (4/3)*Sqrt[a]*ArcTanh[Sqrt[a + b*Sqrt[c*x^3]]/Sqrt[a]]}
{Sqrt[a + b*Sqrt[c*x^3]]/x^4, x, 6, -(Sqrt[a + b*Sqrt[c*x^3]]/(3*x^3)) - (b*c*Sqrt[a + b*Sqrt[c*x^3]])/(6*a*Sqrt[c*x^3]) + (b^2*c*ArcTanh[Sqrt[a + b*Sqrt[c*x^3]]/Sqrt[a]])/(6*a^(3/2))}

{x^1*Sqrt[a + b*Sqrt[c*x^3]], x, 5, (4/11)*x^2*Sqrt[a + b*Sqrt[c*x^3]] + (12*a*x^2*Sqrt[a + b*Sqrt[c*x^3]])/(55*b*Sqrt[c*x^3]) - (8*3^(3/4)*Sqrt[2 + Sqrt[3]]*a^2*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(55*b^(4/3)*c^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]])}
{Sqrt[a + b*Sqrt[c*x^3]]/x^2, x, 4, -(Sqrt[a + b*Sqrt[c*x^3]]/x) + (3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(2/3)*c^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]])}
{Sqrt[a + b*Sqrt[c*x^3]]/x^5, x, 6, -(Sqrt[a + b*Sqrt[c*x^3]]/(4*x^4)) + (21*b^2*c*Sqrt[a + b*Sqrt[c*x^3]])/(160*a^2*x) - (3*b*c^3*x^5*Sqrt[a + b*Sqrt[c*x^3]])/(40*a*(c*x^3)^(5/2)) + (7*3^(3/4)*Sqrt[2 + Sqrt[3]]*b^(8/3)*c^(4/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(160*a^2*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]])}

{x^3*Sqrt[a + b*Sqrt[c*x^3]], x, 8, -((120*a^2*x*Sqrt[a + b*Sqrt[c*x^3]])/(1729*b^2*c)) + (4/19)*x^4*Sqrt[a + b*Sqrt[c*x^3]] + (12*a*x*Sqrt[c*x^3]*Sqrt[a + b*Sqrt[c*x^3]])/(247*b*c) + (480*a^3*Sqrt[a + b*Sqrt[c*x^3]])/(1729*b^(8/3)*c^(4/3)*((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])) - (240*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(10/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(1729*b^(8/3)*c^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]]) + (160*Sqrt[2]*3^(3/4)*a^(10/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(1729*b^(8/3)*c^(4/3)*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]])}
{x^0*Sqrt[a + b*Sqrt[c*x^3]], x, 6, (4/7)*x*Sqrt[a + b*Sqrt[c*x^3]] + (12*a*Sqrt[a + b*Sqrt[c*x^3]])/(7*b^(2/3)*c^(1/3)*((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])) - (6*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(7*b^(2/3)*c^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]]) + (4*Sqrt[2]*3^(3/4)*a^(4/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(7*b^(2/3)*c^(1/3)*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]])}
{Sqrt[a + b*Sqrt[c*x^3]]/x^3, x, 7, -(Sqrt[a + b*Sqrt[c*x^3]]/(2*x^2)) - (3*b*c*x*Sqrt[a + b*Sqrt[c*x^3]])/(4*a*Sqrt[c*x^3]) + (3*b^(4/3)*c^(2/3)*Sqrt[a + b*Sqrt[c*x^3]])/(4*a*((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])) - (3*3^(1/4)*Sqrt[2 - Sqrt[3]]*b^(4/3)*c^(2/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(8*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]]) + (3^(3/4)*b^(4/3)*c^(2/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c^(1/3)*x - (a^(1/3)*b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(2*Sqrt[2]*a^(2/3)*Sqrt[(a^(1/3)*(a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + (b^(1/3)*c^(2/3)*x^2)/Sqrt[c*x^3])^2]*Sqrt[a + b*Sqrt[c*x^3]])}


{x^17*Sqrt[a + b*(c*x^3)^(3/2)], x, 4, -((4*a^3*(a + b*(c*x^3)^(3/2))^(3/2))/(27*b^4*c^6)) + (4*a^2*(a + b*(c*x^3)^(3/2))^(5/2))/(15*b^4*c^6) - (4*a*(a + b*(c*x^3)^(3/2))^(7/2))/(21*b^4*c^6) + (4*(a + b*(c*x^3)^(3/2))^(9/2))/(81*b^4*c^6)}
{x^8*Sqrt[a + b*(c*x^3)^(3/2)], x, 4, -((4*a*(a + b*(c*x^3)^(3/2))^(3/2))/(27*b^2*c^3)) + (4*(a + b*(c*x^3)^(3/2))^(5/2))/(45*b^2*c^3)}
{Sqrt[a + b*(c*x^3)^(3/2)]/x^1, x, 5, (4/9)*Sqrt[a + b*(c*x^3)^(3/2)] - (4/9)*Sqrt[a]*ArcTanh[Sqrt[a + b*(c*x^3)^(3/2)]/Sqrt[a]]}
{Sqrt[a + b*(c*x^3)^(3/2)]/x^10, x, 6, -(Sqrt[a + b*(c*x^3)^(3/2)]/(9*x^9)) - (b*c^3*Sqrt[a + b*(c*x^3)^(3/2)])/(18*a*(c*x^3)^(3/2)) + (b^2*c^3*ArcTanh[Sqrt[a + b*(c*x^3)^(3/2)]/Sqrt[a]])/(18*a^(3/2)), -(Sqrt[a + b*(c*x^3)^(3/2)]/(9*x^9)) - (b*c^6*x^9*Sqrt[a + b*(c*x^3)^(3/2)])/(18*a*(c*x^3)^(9/2)) + (b^2*c^3*ArcTanh[Sqrt[a + b*(c*x^3)^(3/2)]/Sqrt[a]])/(18*a^(3/2))}

{x^2*Sqrt[a + b*(c*x^3)^(3/2)], x, 7, (4/21)*x^3*Sqrt[a + b*(c*x^3)^(3/2)] + (4*a*Sqrt[a + b*(c*x^3)^(3/2)])/(7*b^(2/3)*c*((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])) - (2*3^(1/4)*Sqrt[2 - Sqrt[3]]*a^(4/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c*x^3 - a^(1/3)*b^(1/3)*Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])^2]*EllipticE[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(7*b^(2/3)*c*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])^2]*Sqrt[a + b*(c*x^3)^(3/2)]) + (4*Sqrt[2]*a^(4/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^3])*Sqrt[(a^(2/3) + b^(2/3)*c*x^3 - a^(1/3)*b^(1/3)*Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])^2]*EllipticF[ArcSin[((1 - Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])], -7 - 4*Sqrt[3]])/(7*3^(1/4)*b^(2/3)*c*Sqrt[(a^(1/3)*(a^(1/3) + b^(1/3)*Sqrt[c*x^3]))/((1 + Sqrt[3])*a^(1/3) + b^(1/3)*Sqrt[c*x^3])^2]*Sqrt[a + b*(c*x^3)^(3/2)])}

{x^9*Sqrt[a + b*(c*x^3)^(3/2)], x, 7, -((792*a^2*x*Sqrt[a + b*(c*x^3)^(3/2)])/(19747*b^2*c^3)) + (4/49)*x^10*Sqrt[a + b*(c*x^3)^(3/2)] + (36*a*x*(c*x^3)^(3/2)*Sqrt[a + b*(c*x^3)^(3/2)])/(1519*b*c^3) + (792*a^3*x*Sqrt[1 + (b*(c*x^3)^(3/2))/a]*Hypergeometric2F1[2/9, 1/2, 11/9, -((b*(c*x^3)^(3/2))/a)])/(19747*b^2*c^3*Sqrt[a + b*(c*x^3)^(3/2)])}
{x^0*Sqrt[a + b*(c*x^3)^(3/2)], x, 5, (4/13)*x*Sqrt[a + b*(c*x^3)^(3/2)] + (9*a*x*Sqrt[1 + (b*(c*x^3)^(3/2))/a]*Hypergeometric2F1[2/9, 1/2, 11/9, -((b*(c*x^3)^(3/2))/a)])/(13*Sqrt[a + b*(c*x^3)^(3/2)])}
{Sqrt[a + b*(c*x^3)^(3/2)]/x^9, x, 6, -(Sqrt[a + b*(c*x^3)^(3/2)]/(8*x^8)) - (9*b*c^3*x*Sqrt[a + b*(c*x^3)^(3/2)])/(112*a*(c*x^3)^(3/2)) - (45*b^2*c^3*x*Sqrt[1 + (b*(c*x^3)^(3/2))/a]*Hypergeometric2F1[2/9, 1/2, 11/9, -((b*(c*x^3)^(3/2))/a)])/(448*a*Sqrt[a + b*(c*x^3)^(3/2)]), -(Sqrt[a + b*(c*x^3)^(3/2)]/(8*x^8)) - (9*b*c^5*x^7*Sqrt[a + b*(c*x^3)^(3/2)])/(112*a*(c*x^3)^(7/2)) - (45*b^2*c^3*x*Sqrt[1 + (b*(c*x^3)^(3/2))/a]*Hypergeometric2F1[2/9, 1/2, 11/9, -((b*(c*x^3)^(3/2))/a)])/(448*a*Sqrt[a + b*(c*x^3)^(3/2)])}



(* ::Subsubsection:: *)
(*n<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^3)^(n/2))^p with m symbolic*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(d*x)^m*Sqrt[a + b*(c*x^3)^(3/2)], x, 5, (x*(d*x)^m*Sqrt[a + b*(c*x^3)^(3/2)]*Hypergeometric2F1[-(1/2), (2*(1 + m))/9, 1 + (2*(1 + m))/9, -((b*(c*x^3)^(3/2))/a)])/((1 + m)*Sqrt[1 + (b*(c*x^3)^(3/2))/a])}
{(d*x)^m*Sqrt[a + b*(c*x^3)^(1/2)], x, 5, (x*(d*x)^m*Sqrt[a + b*Sqrt[c*x^3]]*Hypergeometric2F1[-(1/2), (2*(1 + m))/3, (1/3)*(5 + 2*m), -((b*Sqrt[c*x^3])/a)])/((1 + m)*Sqrt[1 + (b*Sqrt[c*x^3])/a])}
{(d*x)^m*Sqrt[a + b/(c*x^3)^(1/2)], x, 6, (x*(d*x)^m*Sqrt[a + b/Sqrt[c*x^3]]*Hypergeometric2F1[-(1/2), (-(2/3))*(1 + m), (1/3)*(1 - 2*m), -(b/(a*Sqrt[c*x^3]))])/((1 + m)*Sqrt[1 + b/(a*Sqrt[c*x^3])])}
{(d*x)^m*Sqrt[a + b/(c*x^3)^(3/2)], x, 6, (x*(d*x)^m*Sqrt[a + (b*c^3*x^9)/(c*x^3)^(9/2)]*Hypergeometric2F1[-(1/2), (-(2/9))*(1 + m), (1/9)*(7 - 2*m), -((b*c^3*x^9)/(a*(c*x^3)^(9/2)))])/((1 + m)*Sqrt[1 + (b*c^3*x^9)/(a*(c*x^3)^(9/2))])}


(* ::Subsubsection:: *)
(*p<0*)


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^-1)^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c /x)^(n/2))^(1/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^1*Sqrt[a + b*Sqrt[c/x]], x, 8, (b*c^2*Sqrt[a + b*Sqrt[c/x]])/(12*a*(c/x)^(3/2)) + (5*b^3*c^2*Sqrt[a + b*Sqrt[c/x]])/(32*a^3*Sqrt[c/x]) - (5*b^2*c*Sqrt[a + b*Sqrt[c/x]]*x)/(48*a^2) + (1/2)*Sqrt[a + b*Sqrt[c/x]]*x^2 - (5*b^4*c^2*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]])/(32*a^(7/2)), (5*b^3*c^2*Sqrt[a + b*Sqrt[c/x]])/(32*a^3*Sqrt[c/x]) - (5*b^2*c*Sqrt[a + b*Sqrt[c/x]]*x)/(48*a^2) + (1/2)*Sqrt[a + b*Sqrt[c/x]]*x^2 + (b*Sqrt[a + b*Sqrt[c/x]]*(c/x)^(3/2)*x^3)/(12*a*c) - (5*b^4*c^2*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]])/(32*a^(7/2))}
{x^0*Sqrt[a + b*Sqrt[c/x]], x, 6, (b*c*Sqrt[a + b*Sqrt[c/x]])/(2*a*Sqrt[c/x]) + Sqrt[a + b*Sqrt[c/x]]*x - (b^2*c*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]])/(2*a^(3/2))}
{Sqrt[a + b*Sqrt[c/x]]/x^1, x, 5, -4*Sqrt[a + b*Sqrt[c/x]] + 4*Sqrt[a]*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]]}
{Sqrt[a + b*Sqrt[c/x]]/x^2, x, 4, (4*a*(a + b*Sqrt[c/x])^(3/2))/(3*b^2*c) - (4*(a + b*Sqrt[c/x])^(5/2))/(5*b^2*c)}
{Sqrt[a + b*Sqrt[c/x]]/x^3, x, 4, (4*a^3*(a + b*Sqrt[c/x])^(3/2))/(3*b^4*c^2) - (12*a^2*(a + b*Sqrt[c/x])^(5/2))/(5*b^4*c^2) + (12*a*(a + b*Sqrt[c/x])^(7/2))/(7*b^4*c^2) - (4*(a + b*Sqrt[c/x])^(9/2))/(9*b^4*c^2)}
{Sqrt[a + b*Sqrt[c/x]]/x^4, x, 4, (4*a^5*(a + b*Sqrt[c/x])^(3/2))/(3*b^6*c^3) - (4*a^4*(a + b*Sqrt[c/x])^(5/2))/(b^6*c^3) + (40*a^3*(a + b*Sqrt[c/x])^(7/2))/(7*b^6*c^3) - (40*a^2*(a + b*Sqrt[c/x])^(9/2))/(9*b^6*c^3) + (20*a*(a + b*Sqrt[c/x])^(11/2))/(11*b^6*c^3) - (4*(a + b*Sqrt[c/x])^(13/2))/(13*b^6*c^3)}


(* ::Subsubsection:: *)
(*n<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c /x)^(n/2))^(-1/2)*)


(* ::Subsubsection::Closed:: *)
(*n>0*)


{x^1/Sqrt[a + b*Sqrt[c/x]], x, 8, -((7*b*c^2*Sqrt[a + b*Sqrt[c/x]])/(12*a^2*(c/x)^(3/2))) - (35*b^3*c^2*Sqrt[a + b*Sqrt[c/x]])/(32*a^4*Sqrt[c/x]) + (35*b^2*c*Sqrt[a + b*Sqrt[c/x]]*x)/(48*a^3) + (Sqrt[a + b*Sqrt[c/x]]*x^2)/(2*a) + (35*b^4*c^2*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]])/(32*a^(9/2)), -((35*b^3*c^2*Sqrt[a + b*Sqrt[c/x]])/(32*a^4*Sqrt[c/x])) + (35*b^2*c*Sqrt[a + b*Sqrt[c/x]]*x)/(48*a^3) + (Sqrt[a + b*Sqrt[c/x]]*x^2)/(2*a) - (7*b*Sqrt[a + b*Sqrt[c/x]]*(c/x)^(3/2)*x^3)/(12*a^2*c) + (35*b^4*c^2*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]])/(32*a^(9/2))}
{x^0/Sqrt[a + b*Sqrt[c/x]], x, 6, -((3*b*c*Sqrt[a + b*Sqrt[c/x]])/(2*a^2*Sqrt[c/x])) + (Sqrt[a + b*Sqrt[c/x]]*x)/a + (3*b^2*c*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]])/(2*a^(5/2))}
{1/(x^1*Sqrt[a + b*Sqrt[c/x]]), x, 4, (4*ArcTanh[Sqrt[a + b*Sqrt[c/x]]/Sqrt[a]])/Sqrt[a]}
{1/(x^2*Sqrt[a + b*Sqrt[c/x]]), x, 4, (4*a*Sqrt[a + b*Sqrt[c/x]])/(b^2*c) - (4*(a + b*Sqrt[c/x])^(3/2))/(3*b^2*c)}
{1/(x^3*Sqrt[a + b*Sqrt[c/x]]), x, 4, (4*a^3*Sqrt[a + b*Sqrt[c/x]])/(b^4*c^2) - (4*a^2*(a + b*Sqrt[c/x])^(3/2))/(b^4*c^2) + (12*a*(a + b*Sqrt[c/x])^(5/2))/(5*b^4*c^2) - (4*(a + b*Sqrt[c/x])^(7/2))/(7*b^4*c^2)}
{1/(x^4*Sqrt[a + b*Sqrt[c/x]]), x, 4, (4*a^5*Sqrt[a + b*Sqrt[c/x]])/(b^6*c^3) - (20*a^4*(a + b*Sqrt[c/x])^(3/2))/(3*b^6*c^3) + (8*a^3*(a + b*Sqrt[c/x])^(5/2))/(b^6*c^3) - (40*a^2*(a + b*Sqrt[c/x])^(7/2))/(7*b^6*c^3) + (20*a*(a + b*Sqrt[c/x])^(9/2))/(9*b^6*c^3) - (4*(a + b*Sqrt[c/x])^(11/2))/(11*b^6*c^3)}


{1/Sqrt[1 + Sqrt[1/x]], x, 6, -((3*Sqrt[1 + Sqrt[1/x]])/(2*Sqrt[1/x])) + Sqrt[1 + Sqrt[1/x]]*x + (3/2)*ArcTanh[Sqrt[1 + Sqrt[1/x]]]}


(* ::Subsubsection:: *)
(*n<0*)


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^-1)^(n/2))^(p/2) with m symbolic*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(d*x)^m*Sqrt[a + b*(c/x)^(3/2)], x, 6, (Sqrt[a + (b*c^3)/((c/x)^(3/2)*x^3)]*x*(d*x)^m*Hypergeometric2F1[-(1/2), (-(2/3))*(1 + m), (1/3)*(1 - 2*m), -((b*c^3)/(a*(c/x)^(3/2)*x^3))])/((1 + m)*Sqrt[1 + (b*c^3)/(a*(c/x)^(3/2)*x^3)])}
{(d*x)^m*Sqrt[a + b*(c/x)^(1/2)], x, 6, (4*(a + b*Sqrt[c/x])^(3/2)*x^(1 + m)*Hypergeometric2F1[1, (1/2)*(-1 - 4*m), 5/2, (a + b*Sqrt[c/x])/a])/(3*a), (4*b^2*c*(a + b*Sqrt[c/x])^(3/2)*(-((b*Sqrt[c/x])/a))^(2*m)*(d*x)^m*Hypergeometric2F1[3/2, 3 + 2*m, 5/2, 1 + (b*Sqrt[c/x])/a])/(3*a^3)}
{(d*x)^m*Sqrt[a + b/(c/x)^(1/2)], x, 5, -((4*a*c*(a + b/Sqrt[c/x])^(3/2)*(d*x)^m*Hypergeometric2F1[3/2, -1 - 2*m, 5/2, 1 + b/(a*Sqrt[c/x])])/((-(b/(a*Sqrt[c/x])))^(2*m)*(3*b^2)))}
{(d*x)^m*Sqrt[a + b/(c/x)^(3/2)], x, 5, (x*(d*x)^m*Sqrt[a + (b*(c/x)^(3/2)*x^3)/c^3]*Hypergeometric2F1[-(1/2), (2*(1 + m))/3, (1/3)*(5 + 2*m), -((b*(c/x)^(3/2)*x^3)/(a*c^3))])/((1 + m)*Sqrt[1 + (b*(c/x)^(3/2)*x^3)/(a*c^3)])}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{(d*x)^m/Sqrt[a + b*(c/x)^(3/2)], x, 6, (Sqrt[1 + (b*c^3)/(a*(c/x)^(3/2)*x^3)]*x*(d*x)^m*Hypergeometric2F1[1/2, (-(2/3))*(1 + m), (1/3)*(1 - 2*m), -((b*c^3)/(a*(c/x)^(3/2)*x^3))])/((1 + m)*Sqrt[a + (b*c^3)/((c/x)^(3/2)*x^3)])}
{(d*x)^m/Sqrt[a + b*(c/x)^(1/2)], x, 6, (4*Sqrt[a + b*Sqrt[c/x]]*x^(1 + m)*Hypergeometric2F1[1, (1/2)*(-3 - 4*m), 3/2, (a + b*Sqrt[c/x])/a])/a, (4*b^2*c*Sqrt[a + b*Sqrt[c/x]]*(-((b*Sqrt[c/x])/a))^(2*m)*(d*x)^m*Hypergeometric2F1[1/2, 3 + 2*m, 3/2, 1 + (b*Sqrt[c/x])/a])/a^3}
{(d*x)^m/Sqrt[a + b/(c/x)^(1/2)], x, 5, -((4*a*c*Sqrt[a + b/Sqrt[c/x]]*(d*x)^m*Hypergeometric2F1[1/2, -1 - 2*m, 3/2, 1 + b/(a*Sqrt[c/x])])/((-(b/(a*Sqrt[c/x])))^(2*m)*b^2))}
{(d*x)^m/Sqrt[a + b/(c/x)^(3/2)], x, 5, (x*(d*x)^m*Sqrt[1 + (b*(c/x)^(3/2)*x^3)/(a*c^3)]*Hypergeometric2F1[1/2, (2*(1 + m))/3, (1/3)*(5 + 2*m), -((b*(c/x)^(3/2)*x^3)/(a*c^3))])/((1 + m)*Sqrt[a + (b*(c/x)^(3/2)*x^3)/c^3])}


(* ::Section::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^q)^n)^p*)


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c x^n)^(1/n))^p*)


(* ::Subsubsection::Closed:: *)
(*p>0*)


{(a + b*(c*x^n)^(1/n)), x, 3, a*x + (1/2)*b*x*(c*x^n)^(1/n)}


{(a + b*(c*x^n)^(1/n))^2, x, 2, (x*(a + b*(c*x^n)^(1/n))^3)/((c*x^n)^n^(-1)*(3*b))}


{(a + b*(c*x^n)^(1/n))^3, x, 2, (x*(a + b*(c*x^n)^(1/n))^4)/((c*x^n)^n^(-1)*(4*b))}


(* ::Subsubsection::Closed:: *)
(*p<0*)


{x^3/(a + b*(c*x^n)^(1/n)), x, 3, (a^2*x^4)/((c*x^n)^(3/n)*b^3) - (a*x^4)/((c*x^n)^(2/n)*(2*b^2)) + x^4/((c*x^n)^n^(-1)*(3*b)) - (a^3*x^4*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^(4/n)*b^4)}
{x^2/(a + b*(c*x^n)^(1/n)), x, 3, -((a*x^3)/((c*x^n)^(2/n)*b^2)) + x^3/((c*x^n)^n^(-1)*(2*b)) + (a^2*x^3*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^(3/n)*b^3)}
{x^1/(a + b*(c*x^n)^(1/n)), x, 3, x^2/((c*x^n)^n^(-1)*b) - (a*x^2*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^(2/n)*b^2)}
{x^0/(a + b*(c*x^n)^(1/n)), x, 2, (x*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^n^(-1)*b)}
{1/(x^1*(a + b*(c*x^n)^(1/n))), x, 4, Log[x]/a - Log[a + b*(c*x^n)^(1/n)]/a}
{1/(x^2*(a + b*(c*x^n)^(1/n))), x, 3, -(1/(a*x)) - (b*(c*x^n)^(1/n)*Log[x])/(a^2*x) + (b*(c*x^n)^(1/n)*Log[a + b*(c*x^n)^(1/n)])/(a^2*x)}
{1/(x^3*(a + b*(c*x^n)^(1/n))), x, 3, -(1/(2*a*x^2)) + (b*(c*x^n)^(1/n))/(a^2*x^2) + (b^2*(c*x^n)^(2/n)*Log[x])/(a^3*x^2) - (b^2*(c*x^n)^(2/n)*Log[a + b*(c*x^n)^(1/n)])/(a^3*x^2)}


{x^3/(a + b*(c*x^n)^(1/n))^2, x, 3, -((2*a*x^4)/((c*x^n)^(3/n)*b^3)) + x^4/((c*x^n)^(2/n)*(2*b^2)) + (a^3*x^4)/((c*x^n)^(4/n)*(b^4*(a + b*(c*x^n)^(1/n)))) + (3*a^2*x^4*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^(4/n)*b^4)}
{x^2/(a + b*(c*x^n)^(1/n))^2, x, 3, x^3/((c*x^n)^(2/n)*b^2) - (a^2*x^3)/((c*x^n)^(3/n)*(b^3*(a + b*(c*x^n)^(1/n)))) - (2*a*x^3*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^(3/n)*b^3)}
{x^1/(a + b*(c*x^n)^(1/n))^2, x, 3, (a*x^2)/((c*x^n)^(2/n)*(b^2*(a + b*(c*x^n)^(1/n)))) + (x^2*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^(2/n)*b^2)}
{x^0/(a + b*(c*x^n)^(1/n))^2, x, 2, x/(a^2 + a*b*(c*x^n)^(1/n)), -(x/((c*x^n)^n^(-1)*(b*(a + b*(c*x^n)^(1/n)))))}
{1/(x^1*(a + b*(c*x^n)^(1/n))^2), x, 3, 1/(a*(a + b*(c*x^n)^(1/n))) + Log[x]/a^2 - Log[a + b*(c*x^n)^(1/n)]/a^2}
{1/(x^2*(a + b*(c*x^n)^(1/n))^2), x, 3, -(1/(a^2*x)) - (b*(c*x^n)^(1/n))/(a^2*x*(a + b*(c*x^n)^(1/n))) - (2*b*(c*x^n)^(1/n)*Log[x])/(a^3*x) + (2*b*(c*x^n)^(1/n)*Log[a + b*(c*x^n)^(1/n)])/(a^3*x)}
{1/(x^3*(a + b*(c*x^n)^(1/n))^2), x, 3, -(1/(2*a^2*x^2)) + (2*b*(c*x^n)^(1/n))/(a^3*x^2) + (b^2*(c*x^n)^(2/n))/(a^3*x^2*(a + b*(c*x^n)^(1/n))) + (3*b^2*(c*x^n)^(2/n)*Log[x])/(a^4*x^2) - (3*b^2*(c*x^n)^(2/n)*Log[a + b*(c*x^n)^(1/n)])/(a^4*x^2)}


{1/(a + b*(c*x^n)^(1/n))^3, x, 2, -(x/((c*x^n)^n^(-1)*(2*b*(a + b*(c*x^n)^(1/n))^2)))}


{x/(1 + (x^n)^(1/n))^2, x, 3, x^2/((x^n)^(2/n)*(1 + (x^n)^(1/n))) + (x^2*Log[1 + (x^n)^(1/n)])/(x^n)^(2/n)}


(* ::Subsubsection::Closed:: *)
(*p symbolic*)


{x^3*(a + b*(c*x^n)^(1/n))^p, x, 3, -((a^3*x^4*(a + b*(c*x^n)^(1/n))^(1 + p))/((c*x^n)^(4/n)*(b^4*(1 + p)))) + (3*a^2*x^4*(a + b*(c*x^n)^(1/n))^(2 + p))/((c*x^n)^(4/n)*(b^4*(2 + p))) - (3*a*x^4*(a + b*(c*x^n)^(1/n))^(3 + p))/((c*x^n)^(4/n)*(b^4*(3 + p))) + (x^4*(a + b*(c*x^n)^(1/n))^(4 + p))/((c*x^n)^(4/n)*(b^4*(4 + p)))}
{x^2*(a + b*(c*x^n)^(1/n))^p, x, 3, (a^2*x^3*(a + b*(c*x^n)^(1/n))^(1 + p))/((c*x^n)^(3/n)*(b^3*(1 + p))) - (2*a*x^3*(a + b*(c*x^n)^(1/n))^(2 + p))/((c*x^n)^(3/n)*(b^3*(2 + p))) + (x^3*(a + b*(c*x^n)^(1/n))^(3 + p))/((c*x^n)^(3/n)*(b^3*(3 + p)))}
{x^1*(a + b*(c*x^n)^(1/n))^p, x, 3, -((a*x^2*(a + b*(c*x^n)^(1/n))^(1 + p))/((c*x^n)^(2/n)*(b^2*(1 + p)))) + (x^2*(a + b*(c*x^n)^(1/n))^(2 + p))/((c*x^n)^(2/n)*(b^2*(2 + p)))}
{x^0*(a + b*(c*x^n)^(1/n))^p, x, 2, (x*(a + b*(c*x^n)^(1/n))^(1 + p))/((c*x^n)^n^(-1)*(b*(1 + p)))}
{(a + b*(c*x^n)^(1/n))^p/x^1, x, 2, -(((a + b*(c*x^n)^(1/n))^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*(c*x^n)^(1/n))/a])/(a*(1 + p)))}
{(a + b*(c*x^n)^(1/n))^p/x^2, x, 2, (b*(c*x^n)^(1/n)*(a + b*(c*x^n)^(1/n))^(1 + p)*Hypergeometric2F1[2, 1 + p, 2 + p, 1 + (b*(c*x^n)^(1/n))/a])/(a^2*(1 + p)*x)}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c x^n)^(2/n))^p*)


{(a + b*(c*x^n)^(2/n))^3, x, 3, a^3*x + a^2*b*x*(c*x^n)^(2/n) + (3/5)*a*b^2*x*(c*x^n)^(4/n) + (1/7)*b^3*x*(c*x^n)^(6/n)}
{(a + b*(c*x^n)^(2/n))^2, x, 3, a^2*x + (2/3)*a*b*x*(c*x^n)^(2/n) + (1/5)*b^2*x*(c*x^n)^(4/n)}
{(a + b*(c*x^n)^(2/n)), x, 3, a*x + (1/3)*b*x*(c*x^n)^(2/n)}
{1/(a + b*(c*x^n)^(2/n)), x, 2, (x*ArcTan[(Sqrt[b]*(c*x^n)^(1/n))/Sqrt[a]])/((c*x^n)^n^(-1)*(Sqrt[a]*Sqrt[b]))}
{1/(a + b*(c*x^n)^(2/n))^2, x, 3, x/(2*a*(a + b*(c*x^n)^(2/n))) + (x*ArcTan[(Sqrt[b]*(c*x^n)^(1/n))/Sqrt[a]])/((c*x^n)^n^(-1)*(2*a^(3/2)*Sqrt[b]))}
{1/(a + b*(c*x^n)^(2/n))^3, x, 4, x/(4*a*(a + b*(c*x^n)^(2/n))^2) + (3*x)/(8*a^2*(a + b*(c*x^n)^(2/n))) + (3*x*ArcTan[(Sqrt[b]*(c*x^n)^(1/n))/Sqrt[a]])/((c*x^n)^n^(-1)*(8*a^(5/2)*Sqrt[b]))}


{1/(1 + 4*Sqrt[x^4]), x, 2, (x*ArcTan[2*(x^4)^(1/4)])/(2*(x^4)^(1/4))}
{1/(1 - 4*Sqrt[x^4]), x, 2, (x*ArcTanh[2*(x^4)^(1/4)])/(2*(x^4)^(1/4))}

{1/(1 + 4*(x^6)^(1/3)), x, 2, (x*ArcTan[2*(x^6)^(1/6)])/(2*(x^6)^(1/6))}
{1/(1 - 4*(x^6)^(1/3)), x, 2, (x*ArcTanh[2*(x^6)^(1/6)])/(2*(x^6)^(1/6))}

{1/(1 + 4*(x^(2*n))^(1/n)), x, 2, ((1/2)*x*ArcTan[2*(x^(2*n))^(1/(2*n))])/(x^(2*n))^(1/(2*n))}
{1/(1 - 4*(x^(2*n))^(1/n)), x, 2, ((1/2)*x*ArcTanh[2*(x^(2*n))^(1/(2*n))])/(x^(2*n))^(1/(2*n))}


(* ::Subsection::Closed:: *)
(*Integrands of the form x^m (a+b (c x^n)^(3/n))^p*)


{(a + b*(c*x^n)^(3/n))^3, x, 3, a^3*x + (3/4)*a^2*b*x*(c*x^n)^(3/n) + (3/7)*a*b^2*x*(c*x^n)^(6/n) + (1/10)*b^3*x*(c*x^n)^(9/n)}
{(a + b*(c*x^n)^(3/n))^2, x, 3, a^2*x + (1/2)*a*b*x*(c*x^n)^(3/n) + (1/7)*b^2*x*(c*x^n)^(6/n)}
{(a + b*(c*x^n)^(3/n)), x, 3, a*x + (1/4)*b*x*(c*x^n)^(3/n)}
{1/(a + b*(c*x^n)^(3/n)), x, 7, -((x*ArcTan[(a^(1/3) - 2*b^(1/3)*(c*x^n)^(1/n))/(Sqrt[3]*a^(1/3))])/((c*x^n)^(1/n)*(Sqrt[3]*a^(2/3)*b^(1/3)))) + (x*Log[a^(1/3) + b^(1/3)*(c*x^n)^(1/n)])/((c*x^n)^(1/n)*(3*a^(2/3)*b^(1/3))) - (x*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c*x^n)^(1/n) + b^(2/3)*(c*x^n)^(2/n)])/((c*x^n)^(1/n)*(6*a^(2/3)*b^(1/3)))}
{1/(a + b*(c*x^n)^(3/n))^2, x, 8, x/(3*a*(a + b*(c*x^n)^(3/n))) - (2*x*ArcTan[(a^(1/3) - 2*b^(1/3)*(c*x^n)^(1/n))/(Sqrt[3]*a^(1/3))])/((c*x^n)^n^(-1)*(3*Sqrt[3]*a^(5/3)*b^(1/3))) + (2*x*Log[a^(1/3) + b^(1/3)*(c*x^n)^(1/n)])/((c*x^n)^n^(-1)*(9*a^(5/3)*b^(1/3))) - (x*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c*x^n)^(1/n) + b^(2/3)*(c*x^n)^(2/n)])/((c*x^n)^n^(-1)*(9*a^(5/3)*b^(1/3)))}
{1/(a + b*(c*x^n)^(3/n))^3, x, 9, x/(6*a*(a + b*(c*x^n)^(3/n))^2) + (5*x)/(18*a^2*(a + b*(c*x^n)^(3/n))) - (5*x*ArcTan[(a^(1/3) - 2*b^(1/3)*(c*x^n)^(1/n))/(Sqrt[3]*a^(1/3))])/((c*x^n)^n^(-1)*(9*Sqrt[3]*a^(8/3)*b^(1/3))) + (5*x*Log[a^(1/3) + b^(1/3)*(c*x^n)^(1/n)])/((c*x^n)^n^(-1)*(27*a^(8/3)*b^(1/3))) - (5*x*Log[a^(2/3) - a^(1/3)*b^(1/3)*(c*x^n)^(1/n) + b^(2/3)*(c*x^n)^(2/n)])/((c*x^n)^n^(-1)*(54*a^(8/3)*b^(1/3)))}


(* ::Subsection::Closed:: *)
(*Integrands of the form (d x)^m (a+b (c x^q)^n)^p with n, p and q symbolic*)


{(d*x)^m*(a + b*(c*x^q)^n)^p, x, 3, ((d*x)^(1 + m)*(a + b*(c*x^q)^n)^p*Hypergeometric2F1[-p, (1 + m)/(n*q), 1 + (1 + m)/(n*q), -((b*(c*x^q)^n)/a)])/((1 + (b*(c*x^q)^n)/a)^p*(d*(1 + m)))}


{x^2*(a + b*(c*x^q)^n)^p, x, 3, ((1/3)*x^3*(a + b*(c*x^q)^n)^p*Hypergeometric2F1[-p, 3/(n*q), 1 + 3/(n*q), -((b*(c*x^q)^n)/a)])/(1 + (b*(c*x^q)^n)/a)^p}
{x^1*(a + b*(c*x^q)^n)^p, x, 3, ((1/2)*x^2*(a + b*(c*x^q)^n)^p*Hypergeometric2F1[-p, 2/(n*q), 1 + 2/(n*q), -((b*(c*x^q)^n)/a)])/(1 + (b*(c*x^q)^n)/a)^p}
{x^0*(a + b*(c*x^q)^n)^p, x, 3, (x*(a + b*(c*x^q)^n)^p*Hypergeometric2F1[-p, 1/(n*q), 1 + 1/(n*q), -((b*(c*x^q)^n)/a)])/(1 + (b*(c*x^q)^n)/a)^p}
{(a + b*(c*x^q)^n)^p/x^1, x, 3, -(((a + b*(c*x^q)^n)^(1 + p)*Hypergeometric2F1[1, 1 + p, 2 + p, 1 + (b*(c*x^q)^n)/a])/(a*n*(1 + p)*q))}
{(a + b*(c*x^q)^n)^p/x^2, x, 3, -(((a + b*(c*x^q)^n)^p*Hypergeometric2F1[-p, -(1/(n*q)), 1 - 1/(n*q), -((b*(c*x^q)^n)/a)])/((1 + (b*(c*x^q)^n)/a)^p*x))}


(* ::Section::Closed:: *)
(*Integrands of the form x^m (a+b (d/x)^n+c (d/x)^(2n))^p*)


{x^m*Sqrt[a + b*Sqrt[d/x] + c/x], x, 4, (Sqrt[a + b*Sqrt[d/x] + c/x]*x^(1 + m)*AppellF1[-2*(1 + m), -(1/2), -(1/2), -1 - 2*m, -((2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] - Sqrt[-4*a*c + b^2*d]))), -((2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] + Sqrt[-4*a*c + b^2*d])))])/((1 + m)*Sqrt[1 + (2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] - Sqrt[-4*a*c + b^2*d]))]*Sqrt[1 + (2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] + Sqrt[-4*a*c + b^2*d]))])}

{x^2*Sqrt[a + b*Sqrt[d/x] + c/x], x, 9, -((3*b*d^3*(a + b*Sqrt[d/x] + c/x)^(3/2))/(10*a^2*(d/x)^(5/2))) + (7*b*d^2*(28*a*c - 15*b^2*d)*(a + b*Sqrt[d/x] + c/x)^(3/2))/(480*a^4*(d/x)^(3/2)) + ((16*a^2*c^2 - 56*a*b^2*c*d + 21*b^4*d^2)*(2*a + b*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x]*x)/(256*a^5) - ((20*a*c - 21*b^2*d)*(a + b*Sqrt[d/x] + c/x)^(3/2)*x^2)/(80*a^3) + ((a + b*Sqrt[d/x] + c/x)^(3/2)*x^3)/(3*a) + ((4*a*c - b^2*d)*(16*a^2*c^2 - 56*a*b^2*c*d + 21*b^4*d^2)*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(512*a^(11/2))}
{x^1*Sqrt[a + b*Sqrt[d/x] + c/x], x, 7, -((5*b*d^2*(a + b*Sqrt[d/x] + c/x)^(3/2))/(12*a^2*(d/x)^(3/2))) - ((4*a*c - 5*b^2*d)*(2*a + b*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x]*x)/(32*a^3) + ((a + b*Sqrt[d/x] + c/x)^(3/2)*x^2)/(2*a) - ((4*a*c - 5*b^2*d)*(4*a*c - b^2*d)*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(64*a^(7/2))}
{x^0*Sqrt[a + b*Sqrt[d/x] + c/x], x, 5, ((2*a + b*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x]*x)/(2*a) + ((4*a*c - b^2*d)*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(4*a^(3/2))}
{Sqrt[a + b*Sqrt[d/x] + c/x]/x^1, x, 8, -2*Sqrt[a + b*Sqrt[d/x] + c/x] + 2*Sqrt[a]*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])] - (b*Sqrt[d]*ArcTanh[(b*d + 2*c*Sqrt[d/x])/(2*Sqrt[c]*Sqrt[d]*Sqrt[a + b*Sqrt[d/x] + c/x])])/Sqrt[c]}
{Sqrt[a + b*Sqrt[d/x] + c/x]/x^2, x, 6, (b*(b*d + 2*c*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x])/(4*c^2) - (2*(a + b*Sqrt[d/x] + c/x)^(3/2))/(3*c) + (b*Sqrt[d]*(4*a*c - b^2*d)*ArcTanh[(b*d + 2*c*Sqrt[d/x])/(2*Sqrt[c]*Sqrt[d]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(8*c^(5/2))}
{Sqrt[a + b*Sqrt[d/x] + c/x]/x^3, x, 7, -((b*(12*a*c - 7*b^2*d)*(b*d + 2*c*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x])/(64*c^4)) + ((32*a*c - 35*b^2*d + 42*b*c*Sqrt[d/x])*(a + b*Sqrt[d/x] + c/x)^(3/2))/(120*c^3) - (2*(a + b*Sqrt[d/x] + c/x)^(3/2))/(5*c*x) - (b*Sqrt[d]*(12*a*c - 7*b^2*d)*(4*a*c - b^2*d)*ArcTanh[(b*d + 2*c*Sqrt[d/x])/(2*Sqrt[c]*Sqrt[d]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(128*c^(9/2))}
{Sqrt[a + b*Sqrt[d/x] + c/x]/x^4, x, 9, (b*(80*a^2*c^2 - 120*a*b^2*c*d + 33*b^4*d^2)*(b*d + 2*c*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x])/(512*c^6) - ((1024*a^2*c^2 - 3276*a*b^2*c*d + 1155*b^4*d^2 + 18*b*c*(148*a*c - 77*b^2*d)*Sqrt[d/x])*(a + b*Sqrt[d/x] + c/x)^(3/2))/(6720*c^5) + (11*b*(a + b*Sqrt[d/x] + c/x)^(3/2)*(d/x)^(3/2))/(42*c^2*d) - (2*(a + b*Sqrt[d/x] + c/x)^(3/2))/(7*c*x^2) + ((32*a*c - 33*b^2*d)*(a + b*Sqrt[d/x] + c/x)^(3/2))/(140*c^3*x) + (b*Sqrt[d]*(4*a*c - b^2*d)*(80*a^2*c^2 - 120*a*b^2*c*d + 33*b^4*d^2)*ArcTanh[(b*d + 2*c*Sqrt[d/x])/(2*Sqrt[c]*Sqrt[d]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(1024*c^(13/2))}


{x^m/Sqrt[a + b*Sqrt[d/x] + c/x], x, 4, (Sqrt[1 + (2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] - Sqrt[-4*a*c + b^2*d]))]*Sqrt[1 + (2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] + Sqrt[-4*a*c + b^2*d]))]*x^(1 + m)*AppellF1[-2*(1 + m), 1/2, 1/2, -1 - 2*m, -((2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] - Sqrt[-4*a*c + b^2*d]))), -((2*c*Sqrt[d/x])/(Sqrt[d]*(b*Sqrt[d] + Sqrt[-4*a*c + b^2*d])))])/((1 + m)*Sqrt[a + b*Sqrt[d/x] + c/x])}

{x^2/Sqrt[a + b*Sqrt[d/x] + c/x], x, 10, -((11*b*d^3*Sqrt[a + b*Sqrt[d/x] + c/x])/(30*a^2*(d/x)^(5/2))) + (b*d^2*(156*a*c - 77*b^2*d)*Sqrt[a + b*Sqrt[d/x] + c/x])/(160*a^4*(d/x)^(3/2)) - (7*b*d*(528*a^2*c^2 - 680*a*b^2*c*d + 165*b^4*d^2)*Sqrt[a + b*Sqrt[d/x] + c/x])/(1280*a^6*Sqrt[d/x]) + ((400*a^2*c^2 - 1176*a*b^2*c*d + 385*b^4*d^2)*Sqrt[a + b*Sqrt[d/x] + c/x]*x)/(640*a^5) - ((100*a*c - 99*b^2*d)*Sqrt[a + b*Sqrt[d/x] + c/x]*x^2)/(240*a^3) + (Sqrt[a + b*Sqrt[d/x] + c/x]*x^3)/(3*a) - ((320*a^3*c^3 - 1680*a^2*b^2*c^2*d + 1260*a*b^4*c*d^2 - 231*b^6*d^3)*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(512*a^(13/2))}
{x^1/Sqrt[a + b*Sqrt[d/x] + c/x], x, 8, -((7*b*d^2*Sqrt[a + b*Sqrt[d/x] + c/x])/(12*a^2*(d/x)^(3/2))) + (5*b*d*(44*a*c - 21*b^2*d)*Sqrt[a + b*Sqrt[d/x] + c/x])/(96*a^4*Sqrt[d/x]) - ((36*a*c - 35*b^2*d)*Sqrt[a + b*Sqrt[d/x] + c/x]*x)/(48*a^3) + (Sqrt[a + b*Sqrt[d/x] + c/x]*x^2)/(2*a) + ((48*a^2*c^2 - 120*a*b^2*c*d + 35*b^4*d^2)*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(64*a^(9/2))}
{x^0/Sqrt[a + b*Sqrt[d/x] + c/x], x, 6, -((3*b*d*Sqrt[a + b*Sqrt[d/x] + c/x])/(2*a^2*Sqrt[d/x])) + (Sqrt[a + b*Sqrt[d/x] + c/x]*x)/a - ((4*a*c - 3*b^2*d)*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(4*a^(5/2))}
{1/(x^1*Sqrt[a + b*Sqrt[d/x] + c/x]), x, 4, (2*ArcTanh[(2*a + b*Sqrt[d/x])/(2*Sqrt[a]*Sqrt[a + b*Sqrt[d/x] + c/x])])/Sqrt[a]}
{1/(x^2*Sqrt[a + b*Sqrt[d/x] + c/x]), x, 5, -((2*Sqrt[a + b*Sqrt[d/x] + c/x])/c) + (b*Sqrt[d]*ArcTanh[(b*d + 2*c*Sqrt[d/x])/(2*Sqrt[c]*Sqrt[d]*Sqrt[a + b*Sqrt[d/x] + c/x])])/c^(3/2)}
{1/(x^3*Sqrt[a + b*Sqrt[d/x] + c/x]), x, 6, ((16*a*c - 15*b^2*d + 10*b*c*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x])/(12*c^3) - (2*Sqrt[a + b*Sqrt[d/x] + c/x])/(3*c*x) - (b*Sqrt[d]*(12*a*c - 5*b^2*d)*ArcTanh[(b*d + 2*c*Sqrt[d/x])/(2*Sqrt[c]*Sqrt[d]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(8*c^(7/2))}
{1/(x^4*Sqrt[a + b*Sqrt[d/x] + c/x]), x, 8, -(((1024*a^2*c^2 - 2940*a*b^2*c*d + 945*b^4*d^2 + 14*b*c*(92*a*c - 45*b^2*d)*Sqrt[d/x])*Sqrt[a + b*Sqrt[d/x] + c/x])/(960*c^5)) + (9*b*Sqrt[a + b*Sqrt[d/x] + c/x]*(d/x)^(3/2))/(20*c^2*d) - (2*Sqrt[a + b*Sqrt[d/x] + c/x])/(5*c*x^2) + ((64*a*c - 63*b^2*d)*Sqrt[a + b*Sqrt[d/x] + c/x])/(120*c^3*x) + (b*Sqrt[d]*(240*a^2*c^2 - 280*a*b^2*c*d + 63*b^4*d^2)*ArcTanh[(b*d + 2*c*Sqrt[d/x])/(2*Sqrt[c]*Sqrt[d]*Sqrt[a + b*Sqrt[d/x] + c/x])])/(128*c^(11/2))}


{Sqrt[Sqrt[1/x] + 1/x], x, 2, (4*(Sqrt[1/x] + 1/x)^(3/2))/(3*(1/x)^(3/2))}
{Sqrt[2 + Sqrt[1/x] + 1/x], x, 5, (1/4)*(4 + Sqrt[1/x])*Sqrt[2 + Sqrt[1/x] + 1/x]*x + (7*ArcTanh[(4 + Sqrt[1/x])/(2*Sqrt[2]*Sqrt[2 + Sqrt[1/x] + 1/x])])/(8*Sqrt[2])}


(* ::Section::Closed:: *)
(*Integrands of the form (c x^n)^(1/n) (a+b (c x^n)^(m/n))^p*)


{(c*x^n)^(1/n)*(a + b*(c*x^n)^(1/n))^p, x, 4, -((a*x*(a + b*(c*x^n)^(1/n))^(1 + p))/((c*x^n)^n^(-1)*(b^2*(1 + p)))) + (x*(a + b*(c*x^n)^(1/n))^(2 + p))/((c*x^n)^n^(-1)*(b^2*(2 + p)))}


{(c*x^n)^(1/n)*(a + b*(c*x^n)^(1/n))^3, x, 4, -((a*x*(a + b*(c*x^n)^(1/n))^4)/((c*x^n)^n^(-1)*(4*b^2))) + (x*(a + b*(c*x^n)^(1/n))^5)/((c*x^n)^n^(-1)*(5*b^2))}
{(c*x^n)^(1/n)*(a + b*(c*x^n)^(1/n))^2, x, 4, (1/2)*a^2*x*(c*x^n)^(1/n) + (2/3)*a*b*x*(c*x^n)^(2/n) + (1/4)*b^2*x*(c*x^n)^(3/n)}
{(c*x^n)^(1/n)*(a + b*(c*x^n)^(1/n))^1, x, 5, (1/2)*a*x*(c*x^n)^(1/n) + (1/3)*b*x*(c*x^n)^(2/n)}
{(c*x^n)^(1/n)/(a + b*(c*x^n)^(1/n))^1, x, 4, x/b - (a*x*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^n^(-1)*b^2)}
{(c*x^n)^(1/n)/(a + b*(c*x^n)^(1/n))^2, x, 4, (a*x)/((c*x^n)^n^(-1)*(b^2*(a + b*(c*x^n)^(1/n)))) + (x*Log[a + b*(c*x^n)^(1/n)])/((c*x^n)^n^(-1)*b^2)}
{(c*x^n)^(1/n)/(a + b*(c*x^n)^(1/n))^3, x, 3, (x*(c*x^n)^(1/n))/(2*a*(a + b*(c*x^n)^(1/n))^2)}
{(c*x^n)^(1/n)/(a + b*(c*x^n)^(1/n))^4, x, 4, (a*x)/((c*x^n)^n^(-1)*(3*b^2*(a + b*(c*x^n)^(1/n))^3)) - x/((c*x^n)^n^(-1)*(2*b^2*(a + b*(c*x^n)^(1/n))^2))}
{(c*x^n)^(1/n)/(a + b*(c*x^n)^(1/n))^5, x, 4, (a*x)/((c*x^n)^n^(-1)*(4*b^2*(a + b*(c*x^n)^(1/n))^4)) - x/((c*x^n)^n^(-1)*(3*b^2*(a + b*(c*x^n)^(1/n))^3))}
